/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap;

import io.opentelemetry.javaagent.bootstrap.VirtualFieldInstalledMarker;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.cache.Cache;
import java.util.Collection;

public final class VirtualFieldDetector {
    private static final Cache<Class<?>, Collection<String>> classesWithVirtualFields = Cache.weak();

    private VirtualFieldDetector() {
    }

    public static boolean hasVirtualField(Class<?> clazz, String virtualFieldInterfaceClassName) {
        Class<?>[] interfaces;
        if (!VirtualFieldInstalledMarker.class.isAssignableFrom(clazz)) {
            return false;
        }
        for (Class<?> interfaceClass : interfaces = clazz.getInterfaces()) {
            if (!virtualFieldInterfaceClassName.equals(interfaceClass.getName())) continue;
            return true;
        }
        Collection<String> virtualFields = classesWithVirtualFields.get(clazz);
        return virtualFields != null && virtualFields.contains(virtualFieldInterfaceClassName);
    }

    public static void markVirtualFields(Class<?> clazz, Collection<String> virtualFieldClassName) {
        classesWithVirtualFields.put(clazz, virtualFieldClassName);
    }
}

