import { FocusEvent, CompositionEvent, ClipboardEvent, DragEvent, KeyboardEvent, MouseEvent } from 'react';
import { ReactEditor } from '../editor';
/**
 * The default event handling behavior for the React editor.
 */
export default class ReactEditorEvents {
    /**
     * On before input.
     */
    onBeforeInput(this: ReactEditor, event: any): void;
    /**
     * On blur.
     */
    onBlur(this: ReactEditor, event: FocusEvent): void;
    /**
     * On click.
     */
    onClick(this: ReactEditor, event: MouseEvent): void;
    /**
     * On composition end.
     */
    onCompositionEnd(this: ReactEditor, event: CompositionEvent): void;
    /**
     * On composition start.
     */
    onCompositionStart(this: ReactEditor, event: CompositionEvent): void;
    /**
     * On copy.
     */
    onCopy(this: ReactEditor, event: ClipboardEvent): void;
    /**
     * On cut.
     */
    onCut(this: ReactEditor, event: ClipboardEvent): void;
    /**
     * On drag end.
     */
    onDragEnd(this: ReactEditor, event: DragEvent): void;
    /**
     * On drag enter.
     */
    onDragEnter(this: ReactEditor, event: DragEvent): void;
    /**
     * On drag exit.
     */
    onDragExit(this: ReactEditor, event: DragEvent): void;
    /**
     * On drag leave.
     */
    onDragLeave(this: ReactEditor, event: DragEvent): void;
    /**
     * On drag over.
     */
    onDragOver(this: ReactEditor, event: DragEvent): void;
    /**
     * On drag start.
     */
    onDragStart(this: ReactEditor, event: DragEvent): void;
    /**
     * On drop.
     */
    onDrop(this: ReactEditor, event: DragEvent): void;
    /**
     * On focus.
     */
    onFocus(this: ReactEditor, event: FocusEvent): void;
    /**
     * On input.
     */
    onInput(this: ReactEditor, event: any): void;
    /**
     * On key down.
     */
    onKeyDown(this: ReactEditor, event: KeyboardEvent): any;
    /**
     * On key up.
     */
    onKeyUp(this: ReactEditor, event: KeyboardEvent): void;
    /**
     * On mouse down.
     */
    onMouseDown(this: ReactEditor, event: MouseEvent): void;
    /**
     * On mouse up.
     */
    onMouseUp(this: ReactEditor, event: MouseEvent): void;
    /**
     * On paste.
     */
    onPaste(this: ReactEditor, event: ClipboardEvent): void;
    /**
     * On select.
     */
    onSelect(this: ReactEditor, event: any): void;
}
//# sourceMappingURL=events.d.ts.map