import { type KeyCode } from '@xyflow/system';
export type UseKeyPressOptions = {
    target?: Window | Document | HTMLElement | ShadowRoot | null;
    actInsideInputWithModifier?: boolean;
};
/**
 * This hook lets you listen for specific key codes and tells you whether they are
 * currently pressed or not.
 *
 * @public
 * @param param.keyCode - The key code (string or array of strings) to use
 * @param param.options - Options
 * @returns boolean
 *
 * @example
 * ```tsx
 *import { useKeyPress } from '@xyflow/react';
 *
 *export default function () {
 *  const spacePressed = useKeyPress('Space');
 *  const cmdAndSPressed = useKeyPress(['Meta+s', 'Strg+s']);
 *
 *  return (
 *    <div>
 *     {spacePressed && <p>Space pressed!</p>}
 *     {cmdAndSPressed && <p>Cmd + S pressed!</p>}
 *    </div>
 *  );
 *}
 *```
 */
export declare function useKeyPress(keyCode?: KeyCode | null, options?: UseKeyPressOptions): boolean;
//# sourceMappingURL=useKeyPress.d.ts.map