import { jsx } from 'react/jsx-runtime';
import hoistNonReactStatics from 'hoist-non-react-statics';
import memoize from 'micro-memoize';
import * as React from 'react';
import { useContext } from 'react';
import { ThemeContext } from '@grafana/data';
import { stylesFactory } from './stylesFactory.js';

let ThemeContextMock = null;
const memoizedStyleCreators = /* @__PURE__ */ new WeakMap();
const withTheme = (Component) => {
  const WithTheme = (props) => {
    const ContextComponent = ThemeContextMock || ThemeContext;
    return (
      // @ts-ignore
      /* @__PURE__ */ jsx(ContextComponent.Consumer, { children: (theme) => /* @__PURE__ */ jsx(Component, { ...props, theme: theme.v1 }) })
    );
  };
  WithTheme.displayName = `WithTheme(${Component.displayName})`;
  hoistNonReactStatics(WithTheme, Component);
  return WithTheme;
};
const withTheme2 = (Component) => {
  const WithTheme = (props) => {
    const ContextComponent = ThemeContextMock || ThemeContext;
    return (
      // @ts-ignore
      /* @__PURE__ */ jsx(ContextComponent.Consumer, { children: (theme) => /* @__PURE__ */ jsx(Component, { ...props, theme }) })
    );
  };
  WithTheme.displayName = `WithTheme(${Component.displayName})`;
  hoistNonReactStatics(WithTheme, Component);
  return WithTheme;
};
function useTheme() {
  return useContext(ThemeContextMock || ThemeContext).v1;
}
function useTheme2() {
  return useContext(ThemeContextMock || ThemeContext);
}
function useStyles(getStyles) {
  const theme = useTheme();
  let memoizedStyleCreator = memoizedStyleCreators.get(getStyles);
  if (!memoizedStyleCreator) {
    memoizedStyleCreator = stylesFactory(getStyles);
    memoizedStyleCreators.set(getStyles, memoizedStyleCreator);
  }
  return memoizedStyleCreator(theme);
}
function useStyles2(getStyles, ...additionalArguments) {
  const theme = useTheme2();
  let memoizedStyleCreator = memoizedStyleCreators.get(getStyles);
  if (!memoizedStyleCreator) {
    memoizedStyleCreator = memoize(getStyles, { maxSize: 10 });
    memoizedStyleCreators.set(getStyles, memoizedStyleCreator);
  }
  return memoizedStyleCreator(theme, ...additionalArguments);
}
const mockThemeContext = (theme) => {
  ThemeContextMock = React.createContext(theme);
  return () => {
    ThemeContextMock = null;
  };
};

export { memoizedStyleCreators, mockThemeContext, useStyles, useStyles2, useTheme, useTheme2, withTheme, withTheme2 };
//# sourceMappingURL=ThemeContext.js.map
