import { jsx } from 'react/jsx-runtime';
import WKT from 'ol/format/WKT';
import { Geometry } from 'ol/geom';

function GeoCell(props) {
  const { cell, tableStyles, cellProps } = props;
  let disp = "";
  if (cell.value instanceof Geometry) {
    disp = new WKT().writeGeometry(cell.value, {
      featureProjection: "EPSG:3857",
      dataProjection: "EPSG:4326"
    });
  } else if (cell.value != null) {
    disp = `${cell.value}`;
  }
  return /* @__PURE__ */ jsx("div", { ...cellProps, className: tableStyles.cellContainer, children: /* @__PURE__ */ jsx("div", { className: tableStyles.cellText, style: { fontFamily: "monospace" }, children: disp }) });
}

export { GeoCell };
//# sourceMappingURL=GeoCell.js.map
