import { jsx } from 'react/jsx-runtime';
import { isFunction } from 'lodash';
import { ThresholdsMode, getFieldConfigWithMinMax, VizOrientation } from '@grafana/data';
import { BarGaugeDisplayMode, TableCellDisplayMode, BarGaugeValueMode } from '@grafana/schema';
import { BarGauge } from '../BarGauge/BarGauge.js';
import { DataLinksContextMenu } from '../DataLinks/DataLinksContextMenu.js';
import { getCellOptions, getAlignmentFactor } from './utils.js';

const defaultScale = {
  mode: ThresholdsMode.Absolute,
  steps: [
    {
      color: "blue",
      value: -Infinity
    },
    {
      color: "green",
      value: 20
    }
  ]
};
const BarGaugeCell = (props) => {
  var _a;
  const { field, innerWidth, tableStyles, cell, cellProps, row, actions } = props;
  const displayValue = field.display(cell.value);
  const cellOptions = getCellOptions(field);
  let config = getFieldConfigWithMinMax(field, false);
  if (!config.thresholds) {
    config = {
      ...config,
      thresholds: defaultScale
    };
  }
  let barGaugeMode = BarGaugeDisplayMode.Gradient;
  let valueDisplayMode = void 0;
  if (cellOptions.type === TableCellDisplayMode.Gauge) {
    barGaugeMode = (_a = cellOptions.mode) != null ? _a : BarGaugeDisplayMode.Gradient;
    valueDisplayMode = cellOptions.valueDisplayMode !== void 0 ? cellOptions.valueDisplayMode : BarGaugeValueMode.Text;
  }
  const getLinks = () => {
    if (!isFunction(field.getLinks)) {
      return [];
    }
    return field.getLinks({ valueRowIndex: row.index });
  };
  const hasLinks = Boolean(getLinks().length);
  const hasActions = Boolean(actions == null ? void 0 : actions.length);
  const alignmentFactors = getAlignmentFactor(field, displayValue, cell.row.index);
  const renderComponent = (menuProps) => {
    const { openMenu, targetClassName } = menuProps;
    return /* @__PURE__ */ jsx(
      BarGauge,
      {
        width: innerWidth,
        height: tableStyles.cellHeightInner,
        field: config,
        display: field.display,
        text: { valueSize: 14 },
        value: displayValue,
        orientation: VizOrientation.Horizontal,
        theme: tableStyles.theme,
        alignmentFactors,
        onClick: openMenu,
        className: targetClassName,
        itemSpacing: 1,
        lcdCellWidth: 8,
        displayMode: barGaugeMode,
        valueDisplayMode
      }
    );
  };
  return /* @__PURE__ */ jsx("div", { ...cellProps, className: tableStyles.cellContainer, children: hasLinks || hasActions ? /* @__PURE__ */ jsx(DataLinksContextMenu, { links: getLinks, actions, style: { display: "flex", width: "100%" }, children: (api) => renderComponent(api) }) : renderComponent({}) });
};

export { BarGaugeCell };
//# sourceMappingURL=BarGaugeCell.js.map
