import { jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { Icon } from '../Icon/Icon.js';
import { Tooltip } from '../Tooltip/Tooltip.js';
import 'react';
import { TitleItem } from './TitleItem.js';

function PanelDescription({ description, className }) {
  const styles = useStyles2(getStyles);
  const getDescriptionContent = () => {
    const panelDescription = typeof description === "function" ? description() : description;
    return /* @__PURE__ */ jsx("div", { className: "panel-info-content markdown-html", children: /* @__PURE__ */ jsx("div", { dangerouslySetInnerHTML: { __html: panelDescription } }) });
  };
  return description !== "" ? /* @__PURE__ */ jsx(Tooltip, { interactive: true, content: getDescriptionContent, children: /* @__PURE__ */ jsx(TitleItem, { className: cx(className, styles.description), children: /* @__PURE__ */ jsx(Icon, { name: "info-circle", size: "md" }) }) }) : null;
}
const getStyles = (theme) => {
  return {
    description: css({
      code: {
        whiteSpace: "normal",
        wordWrap: "break-word"
      },
      "pre > code": {
        display: "block"
      }
    })
  };
};

export { PanelDescription };
//# sourceMappingURL=PanelDescription.js.map
