import { jsxs, jsx } from 'react/jsx-runtime';
import { cx, css } from '@emotion/css';
import * as React from 'react';
import { useRef, useImperativeHandle } from 'react';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { Box } from '../Layout/Box/Box.js';
import { MenuDivider } from './MenuDivider.js';
import { MenuGroup } from './MenuGroup.js';
import { MenuItem } from './MenuItem.js';
import { useMenuFocus } from './hooks.js';

const MenuComp = React.forwardRef(
  ({ header, children, ariaLabel, onOpen, onClose, onKeyDown, ...otherProps }, forwardedRef) => {
    const styles = useStyles2(getStyles);
    const localRef = useRef(null);
    useImperativeHandle(forwardedRef, () => localRef.current);
    const [handleKeys] = useMenuFocus({ isMenuOpen: true, localRef, onOpen, onClose, onKeyDown });
    return /* @__PURE__ */ jsxs(
      Box,
      {
        ...otherProps,
        "aria-label": ariaLabel,
        backgroundColor: "primary",
        borderRadius: "default",
        boxShadow: "z3",
        display: "inline-block",
        onKeyDown: handleKeys,
        paddingX: 0,
        paddingY: 0.5,
        ref: localRef,
        role: "menu",
        tabIndex: -1,
        children: [
          header && /* @__PURE__ */ jsx(
            "div",
            {
              className: cx(
                styles.header,
                Boolean(children) && React.Children.toArray(children).length > 0 && styles.headerBorder
              ),
              children: header
            }
          ),
          children
        ]
      }
    );
  }
);
MenuComp.displayName = "Menu";
const Menu = Object.assign(MenuComp, {
  Item: MenuItem,
  Divider: MenuDivider,
  Group: MenuGroup
});
const getStyles = (theme) => {
  return {
    header: css({
      padding: theme.spacing(0.5, 1, 1, 1)
    }),
    headerBorder: css({
      borderBottom: `1px solid ${theme.colors.border.weak}`
    })
  };
};

export { Menu };
//# sourceMappingURL=Menu.js.map
