import { jsx } from 'react/jsx-runtime';
import { useCallback, useMemo } from 'react';
import { selectors } from '@grafana/e2e-selectors';
import { Combobox } from '../Combobox/Combobox.js';

const weekStarts = [
  { value: "", label: "Default" },
  { value: "saturday", label: "Saturday" },
  { value: "sunday", label: "Sunday" },
  { value: "monday", label: "Monday" }
];
const isWeekStart = (value) => {
  return ["saturday", "sunday", "monday"].includes(value);
};
function getWeekStart(override) {
  var _a, _b;
  if (override && isWeekStart(override)) {
    return override;
  }
  const preference = (_b = (_a = window == null ? void 0 : window.grafanaBootData) == null ? void 0 : _a.user) == null ? void 0 : _b.weekStart;
  if (preference && isWeekStart(preference)) {
    return preference;
  }
  return "monday";
}
const WeekStartPicker = (props) => {
  const { onChange, width, autoFocus = false, onBlur, value, disabled = false, inputId } = props;
  const onChangeWeekStart = useCallback(
    (selectable) => {
      if (selectable && selectable.value !== void 0) {
        onChange(selectable.value);
      }
    },
    [onChange]
  );
  const selected = useMemo(() => {
    var _a, _b;
    return (_b = (_a = weekStarts.find((item) => item.value === value)) == null ? void 0 : _a.value) != null ? _b : null;
  }, [value]);
  return /* @__PURE__ */ jsx(
    Combobox,
    {
      id: inputId,
      value: selected,
      placeholder: selectors.components.WeekStartPicker.placeholder,
      autoFocus,
      width,
      options: weekStarts,
      onChange: onChangeWeekStart,
      onBlur,
      disabled
    }
  );
};

export { WeekStartPicker, getWeekStart };
//# sourceMappingURL=WeekStartPicker.js.map
