"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.throttle = void 0;
/**
 * Tail based throttle which caches the args of the last call and updates
 */
function throttle(callback, delay) {
    var pause = false;
    var lastPending;
    var timeoutBehavior = function () {
        if (lastPending == null) {
            pause = false;
            return;
        }
        callback.apply(void 0, lastPending);
        lastPending = null;
        setTimeout(timeoutBehavior, delay);
    };
    return function () {
        var args = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            args[_i] = arguments[_i];
        }
        if (pause) {
            lastPending = args;
            return;
        }
        callback.apply(void 0, args);
        pause = true;
        setTimeout(timeoutBehavior, delay);
    };
}
exports.throttle = throttle;
//# sourceMappingURL=throttle.js.map