"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getWebInstrumentations = void 0;
var instrumentations_1 = require("../instrumentations");
function getWebInstrumentations(options) {
    if (options === void 0) { options = {}; }
    var instrumentations = [
        new instrumentations_1.ErrorsInstrumentation(),
        new instrumentations_1.WebVitalsInstrumentation(),
        new instrumentations_1.SessionInstrumentation(),
        new instrumentations_1.ViewInstrumentation(),
    ];
    if (options.enablePerformanceInstrumentation !== false) {
        // unshift to ensure that initialization starts before the other instrumentations
        instrumentations.unshift(new instrumentations_1.PerformanceInstrumentation());
    }
    if (options.captureConsole !== false) {
        instrumentations.push(new instrumentations_1.ConsoleInstrumentation({
            disabledLevels: options.captureConsoleDisabledLevels,
        }));
    }
    return instrumentations;
}
exports.getWebInstrumentations = getWebInstrumentations;
//# sourceMappingURL=getWebInstrumentations.js.map