"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeTracesAPI = void 0;
var transports_1 = require("../../transports");
function initializeTracesAPI(_unpatchedConsole, internalLogger, _config, metas, transports) {
    internalLogger.debug('Initializing traces API');
    var otel = undefined;
    var initOTEL = function (trace, context) {
        internalLogger.debug('Initializing OpenTelemetry');
        otel = {
            trace: trace,
            context: context,
        };
    };
    var getTraceContext = function () {
        var ctx = otel === null || otel === void 0 ? void 0 : otel.trace.getSpanContext(otel.context.active());
        return !ctx
            ? undefined
            : {
                trace_id: ctx.traceId,
                span_id: ctx.spanId,
            };
    };
    var pushTraces = function (payload) {
        try {
            var item = {
                type: transports_1.TransportItemType.TRACE,
                payload: payload,
                meta: metas.value,
            };
            internalLogger.debug('Pushing trace\n', item);
            transports.execute(item);
        }
        catch (err) {
            internalLogger.error('Error pushing trace\n', err);
        }
    };
    var getOTEL = function () { return otel; };
    var isOTELInitialized = function () { return !!otel; };
    return {
        getOTEL: getOTEL,
        getTraceContext: getTraceContext,
        initOTEL: initOTEL,
        isOTELInitialized: isOTELInitialized,
        pushTraces: pushTraces,
    };
}
exports.initializeTracesAPI = initializeTracesAPI;
//# sourceMappingURL=initialize.js.map