"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeAPI = void 0;
var events_1 = require("./events");
var exceptions_1 = require("./exceptions");
var logs_1 = require("./logs");
var measurements_1 = require("./measurements");
var meta_1 = require("./meta");
var traces_1 = require("./traces");
function initializeAPI(unpatchedConsole, internalLogger, config, metas, transports) {
    internalLogger.debug('Initializing API');
    var tracesApi = (0, traces_1.initializeTracesAPI)(unpatchedConsole, internalLogger, config, metas, transports);
    return __assign(__assign(__assign(__assign(__assign(__assign({}, tracesApi), (0, exceptions_1.initializeExceptionsAPI)(unpatchedConsole, internalLogger, config, metas, transports, tracesApi)), (0, meta_1.initializeMetaAPI)(unpatchedConsole, internalLogger, config, metas, transports)), (0, logs_1.initializeLogsAPI)(unpatchedConsole, internalLogger, config, metas, transports, tracesApi)), (0, measurements_1.initializeMeasurementsAPI)(unpatchedConsole, internalLogger, config, metas, transports, tracesApi)), (0, events_1.initializeEventsAPI)(unpatchedConsole, internalLogger, config, metas, transports, tracesApi));
}
exports.initializeAPI = initializeAPI;
//# sourceMappingURL=initialize.js.map