"use strict";
var __spreadArray = (this && this.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeTransports = void 0;
var batchExecutor_1 = require("./batchExecutor");
function initializeTransports(unpatchedConsole, internalLogger, config, metas) {
    var _a;
    internalLogger.debug('Initializing transports');
    var transports = [];
    var paused = config.paused;
    var beforeSendHooks = [];
    var add = function () {
        var newTransports = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            newTransports[_i] = arguments[_i];
        }
        internalLogger.debug('Adding transports');
        newTransports.forEach(function (newTransport) {
            internalLogger.debug("Adding \"".concat(newTransport.name, "\" transport"));
            var exists = transports.some(function (existingTransport) { return existingTransport === newTransport; });
            if (exists) {
                internalLogger.warn("Transport ".concat(newTransport.name, " is already added"));
                return;
            }
            newTransport.unpatchedConsole = unpatchedConsole;
            newTransport.internalLogger = internalLogger;
            newTransport.config = config;
            newTransport.metas = metas;
            transports.push(newTransport);
        });
    };
    var addBeforeSendHooks = function () {
        var newBeforeSendHooks = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            newBeforeSendHooks[_i] = arguments[_i];
        }
        internalLogger.debug('Adding beforeSendHooks\n', beforeSendHooks);
        newBeforeSendHooks.forEach(function (beforeSendHook) {
            if (beforeSendHook) {
                beforeSendHooks.push(beforeSendHook);
            }
        });
    };
    var applyBeforeSendHooks = function (items) {
        var filteredItems = items;
        for (var _i = 0, beforeSendHooks_1 = beforeSendHooks; _i < beforeSendHooks_1.length; _i++) {
            var hook = beforeSendHooks_1[_i];
            var modified = filteredItems.map(hook).filter(Boolean);
            if (modified.length === 0) {
                return [];
            }
            filteredItems = modified;
        }
        return filteredItems;
    };
    var batchedSend = function (items) {
        var filteredItems = applyBeforeSendHooks(items);
        if (filteredItems.length === 0) {
            return;
        }
        for (var _i = 0, transports_1 = transports; _i < transports_1.length; _i++) {
            var transport = transports_1[_i];
            internalLogger.debug("Transporting item using ".concat(transport.name, "\n"), filteredItems);
            if (transport.isBatched()) {
                transport.send(filteredItems);
            }
        }
    };
    var instantSend = function (item) {
        var _a, _b;
        // prevent all beforeSend hooks being executed twice if batching is enabled.
        if (((_a = config.batching) === null || _a === void 0 ? void 0 : _a.enabled) && transports.every(function (transport) { return transport.isBatched(); })) {
            return;
        }
        var filteredItem = applyBeforeSendHooks([item])[0];
        if (filteredItem === undefined) {
            return;
        }
        for (var _i = 0, transports_2 = transports; _i < transports_2.length; _i++) {
            var transport = transports_2[_i];
            internalLogger.debug("Transporting item using ".concat(transport.name, "\n"), filteredItem);
            if (!transport.isBatched()) {
                transport.send(filteredItem);
            }
            else if (!((_b = config.batching) === null || _b === void 0 ? void 0 : _b.enabled)) {
                transport.send([filteredItem]);
            }
        }
    };
    var batchExecutor;
    if ((_a = config.batching) === null || _a === void 0 ? void 0 : _a.enabled) {
        batchExecutor = new batchExecutor_1.BatchExecutor(batchedSend, {
            sendTimeout: config.batching.sendTimeout,
            itemLimit: config.batching.itemLimit,
            paused: paused,
        });
    }
    // Send a signal to the appropriate transports
    //
    // 1. If SDK is paused, early return
    // 2. If batching is not enabled send the signal to all transports
    //    instantly.
    // 3i. If batching is enabled, enqueue the signal
    // 3ii. Send the signal instantly to all un-batched transports
    var execute = function (item) {
        var _a;
        if (paused) {
            return;
        }
        if ((_a = config.batching) === null || _a === void 0 ? void 0 : _a.enabled) {
            batchExecutor === null || batchExecutor === void 0 ? void 0 : batchExecutor.addItem(item);
        }
        instantSend(item);
    };
    var getBeforeSendHooks = function () { return __spreadArray([], beforeSendHooks, true); };
    var isPaused = function () { return paused; };
    var pause = function () {
        internalLogger.debug('Pausing transports');
        batchExecutor === null || batchExecutor === void 0 ? void 0 : batchExecutor.pause();
        paused = true;
    };
    var remove = function () {
        var transportsToRemove = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            transportsToRemove[_i] = arguments[_i];
        }
        internalLogger.debug('Removing transports');
        transportsToRemove.forEach(function (transportToRemove) {
            internalLogger.debug("Removing \"".concat(transportToRemove.name, "\" transport"));
            var existingTransportIndex = transports.indexOf(transportToRemove);
            if (existingTransportIndex === -1) {
                internalLogger.warn("Transport \"".concat(transportToRemove.name, "\" is not added"));
                return;
            }
            transports.splice(existingTransportIndex, 1);
        });
    };
    var removeBeforeSendHooks = function () {
        var beforeSendHooksToRemove = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            beforeSendHooksToRemove[_i] = arguments[_i];
        }
        beforeSendHooks.filter(function (beforeSendHook) { return !beforeSendHooksToRemove.includes(beforeSendHook); });
    };
    var unpause = function () {
        internalLogger.debug('Unpausing transports');
        batchExecutor === null || batchExecutor === void 0 ? void 0 : batchExecutor.start();
        paused = false;
    };
    return {
        add: add,
        addBeforeSendHooks: addBeforeSendHooks,
        getBeforeSendHooks: getBeforeSendHooks,
        execute: execute,
        isPaused: isPaused,
        pause: pause,
        remove: remove,
        removeBeforeSendHooks: removeBeforeSendHooks,
        get transports() {
            return __spreadArray([], transports, true);
        },
        unpause: unpause,
    };
}
exports.initializeTransports = initializeTransports;
//# sourceMappingURL=initialize.js.map