package com.saxonica.testdriver.gui;


import net.sf.saxon.s9api.*;
import net.sf.saxon.testdriver.QT3TestDriverHE;
import net.sf.saxon.testdriver.TestDriverShell;
import com.saxonica.testdriver.XMarkBenchmark;
import com.saxonica.testdriver.Xslt30TestSuiteDriverEE;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.trans.LicenseException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.filter.ElementFilter;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.XMLOutputter;
import org.jdom2.util.IteratorIterable;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.*;

/**
 * This class is the GUI for the W3C Test Suites. Version 4.1
 */
public class TestDriverGui extends TestDriverShell implements ActionListener, MouseListener {
    private JPanel GuiformPanel;
    private JPanel Title;
    private JPanel mainForm;
    private JPanel Footer;
    private JLabel TitleLabel;
    private JLabel companyLogo;
    private JRadioButton FOTSTestDriverRadioButton;
    private JRadioButton schemaTestDriverRadioButton;
    private JPanel testDriverChooser;
    private JRadioButton XMarkRadioButton;
    private JPanel testPanel;
    private JPanel optionsPanel;
    private JPanel outputPanel;
    private JPanel runPanel;
    private JButton runButton;
    private JCheckBox byteCodeCheckBox;
    private JScrollPane resultScrollPane;
    private JTextField workingDirField;
    private JButton workingDirButton;
    private JTextField testSetTextField;
    private JTextField testCaseTextField;
    private JButton stopButton;
    private JTextArea resultTextArea;
    private JCheckBox debugBytecodeCheckBox;
    private JCheckBox eeModeCheckBox;
    private JCheckBox pullModeCheckBox;
    private JRadioButton updateTestDriverRadioButton;
    private JTextField contributorTextField;
    private JLabel contributorLabel;
    private JLabel resultLabel;
    private JCheckBox fastCheckBox;
    private JLabel testSetLabel;
    private JLabel testCaseLabel;
    private JButton clearBtn;
    private JComboBox xsdVersion;
    private JLabel xsdVersionLab;
    /* private JButton resultsFileBtn;*/
    private JButton resultsDirBtn;
    private JCheckBox debugResultsCheckBox;
    private JRadioButton XSLT30DriverButton;
    private JLabel versionLabel;
    private JLabel resultsDirLabel;
    private JTextField resultsDirField;
    private JButton resultsDirButton;
    private JComboBox langComboBox;
    private JLabel langLabel;
    private JLabel treeModelLabel;
    private JComboBox treeModelCombo;
    private JLabel c;
    private Thread thread = null;
    private Processor driverProc = new Processor(true);
    private TreeModel treeModel = TreeModel.LINKED_TREE;
    private Document cacheNode = null;
    private XPathCompiler xpc = null;
    private Writer resultWriter = null;
    private File cacheFile = null;
    //#if EE==true || PE==true
    private XMarkBenchmark xmark = null;
    //#endif
    private String prevSource = "xsltTestDriver";
    private String resultFileStr = null;
    private String resultsDir = "";
    private String testDriverVersion = "4.1";

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() == resultsDirBtn) {
            String os = System.getProperty("os.name").toLowerCase();
            try {
                if (os.startsWith("windows")) {
                    Runtime.getRuntime().exec("explorer " + resultsDir);
                } else if (os.startsWith("linux") || os.startsWith("unix")) {
                    Runtime.getRuntime().exec("nautilus " + resultsDir);
                } else if (os.startsWith("mac")) {
                    Runtime.getRuntime().exec("open " + resultsDir);
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        //To change body of implemented methods use File | Settings | File Templates.
    }

    /**
     * Method generated by IntelliJ IDEA GUI Designer
     * >>> IMPORTANT!! <<<
     * DO NOT edit this method OR call it in your code!
     *
     * @noinspection ALL
     */
    private void $$$setupUI$$$() {
        GuiformPanel = new JPanel();
        GuiformPanel.setLayout(new BorderLayout(0,0));
        GuiformPanel.setEnabled(true);
        GuiformPanel.setMinimumSize(new Dimension(770, 900));
        GuiformPanel.setPreferredSize(new Dimension(770, 900));
        Title = new JPanel();
        Title.setLayout(new BorderLayout(0, 0));
        GuiformPanel.add(Title);
        TitleLabel = new JLabel();
        TitleLabel.setFont(new Font(TitleLabel.getFont().getName(), Font.BOLD, 18));
        TitleLabel.setHorizontalAlignment(0);
        TitleLabel.setHorizontalTextPosition(0);
        TitleLabel.setText("W3C Test Suite Drivers");
        Title.add(TitleLabel, BorderLayout.SOUTH);
        companyLogo = new JLabel();
        companyLogo.setHorizontalAlignment(0);
        companyLogo.setHorizontalTextPosition(0);
        companyLogo.setIcon(new ImageIcon(getClass().getResource("images/saxonica_logo.gif")));
        companyLogo.setText("");
        Title.add(companyLogo, BorderLayout.CENTER);
        versionLabel = new JLabel();
        versionLabel.setText("v4.1");
        Title.add(versionLabel, BorderLayout.WEST);
        mainForm = new JPanel();
        mainForm.setLayout(new BoxLayout(mainForm, BoxLayout.Y_AXIS));//, new Insets(0, 0, 0, 0), -1, -1));

        //final Spacer spacer1 = new Spacer();
        //mainForm.add(spacer1, new GridConstraints(1, 1, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_VERTICAL, 1, GridConstraints.SIZEPOLICY_WANT_GROW, null, null, null, 0, false));
        testDriverChooser = new JPanel();
        testDriverChooser.setLayout(new BoxLayout(testDriverChooser, BoxLayout.Y_AXIS));//, new Insets(0, 0, 0, 0), -1, -1));

         JPanel testDriverChooseri = new JPanel();
         testDriverChooseri.setLayout(new BoxLayout(testDriverChooseri, BoxLayout.Y_AXIS));
          testDriverChooseri.setMinimumSize(new Dimension(770, 200));
        XSLT30DriverButton = new JRadioButton();
        XSLT30DriverButton.setText("XSLT 3.0 Test Suite Driver");

        testDriverChooseri.add(XSLT30DriverButton);//, new GridConstraints(1, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));

        //final Spacer spacer2 = new Spacer();
        //testDriverChooser.add(spacer2, new GridConstraints(2, 1, 2, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_VERTICAL, 1, GridConstraints.SIZEPOLICY_WANT_GROW, null, null, null, 0, false));
        FOTSTestDriverRadioButton = new JRadioButton();
        FOTSTestDriverRadioButton.setText("W3C QT Test Suite Driver (XQuery 2.0/3.0/3.1, XPath 2.0/3.0/3.1)");
        testDriverChooseri.add(FOTSTestDriverRadioButton);//, new GridConstraints(2, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        schemaTestDriverRadioButton = new JRadioButton();
        schemaTestDriverRadioButton.setText("Schema Test Suite Driver");
        testDriverChooseri.add(schemaTestDriverRadioButton);//, new GridConstraints(3, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        XMarkRadioButton = new JRadioButton();
        XMarkRadioButton.setText("XMarkBench Test Suite Driver");
        testDriverChooseri.add(XMarkRadioButton);//, new GridConstraints(5, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        updateTestDriverRadioButton = new JRadioButton();
        updateTestDriverRadioButton.setText("XQuery Update Test Suite Driver");
        testDriverChooseri.add(updateTestDriverRadioButton);//, new GridConstraints(4, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        testDriverChooseri.setAlignmentX(Component.RIGHT_ALIGNMENT);
        testDriverChooser.add(testDriverChooseri);
         testDriverChooser.setAlignmentX(Component.RIGHT_ALIGNMENT);

        testPanel = new JPanel();
        testPanel.setLayout(new BoxLayout(testPanel, BoxLayout.Y_AXIS));//, new Insets(0, 0, 0, 0), -1, -1));
        JPanel p1 = new JPanel(new FlowLayout());
        JPanel p2 = new JPanel(new FlowLayout());
        JPanel p3 = new JPanel(new FlowLayout());
        JPanel p4 = new JPanel(new FlowLayout());
        JPanel p5 = new JPanel(new FlowLayout());
        JPanel p6 = new JPanel(new FlowLayout());
        JPanel p7 = new JPanel(new FlowLayout());
        JPanel p8 = new JPanel(new FlowLayout());
        final JLabel label1 = new JLabel();
        label1.setText("Working Directory:");
        p1.add(label1);//, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_FIXED, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        workingDirField = new JTextField(20);
        workingDirField.setText("");
        p1.add(workingDirField);//, new GridConstraints(0, 1, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_WANT_GROW, GridConstraints.SIZEPOLICY_FIXED, null, new Dimension(150, -1), null, 0, false));
        workingDirButton = new JButton();
        workingDirButton.setText("...");
        p1.add(workingDirButton);//, new GridConstraints(0, 2, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        testPanel.add(p1);

        resultsDirLabel = new JLabel();
        resultsDirLabel.setText("Results Directory:");
        p2.add(resultsDirLabel);//, new GridConstraints(1, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_FIXED, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        resultsDirField = new JTextField(20);

        resultsDirField.setText("");
        p2.add(resultsDirField);
        resultsDirButton = new JButton();
        resultsDirButton.setText("...");
        p2.add(resultsDirButton);
        testPanel.add(p2);
        testSetLabel = new JLabel();
        testSetLabel.setText("Test Set:");
        p3.add(testSetLabel);

        testSetTextField = new JTextField(20);
        p3.add(testSetTextField);//, new GridConstraints(3, 1, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_WANT_GROW, GridConstraints.SIZEPOLICY_FIXED, null, new Dimension(150, -1), null, 0, false));
        testPanel.add(p3);

        //, new GridConstraints(3, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_FIXED, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        testCaseLabel = new JLabel();
        testCaseLabel.setText("Test Case:");
        p4.add(testCaseLabel);
        testCaseTextField = new JTextField(20);
        p4.add(testCaseTextField);//, new GridConstraints(4, 1, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_WANT_GROW, GridConstraints.SIZEPOLICY_FIXED, null, new Dimension(150, -1), null, 0, false));
        testPanel.add(p4);
        //, new GridConstraints(4, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_FIXED, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        contributorLabel = new JLabel();
        contributorLabel.setEnabled(false);
        contributorLabel.setText("Contributor");
        p5.add(contributorLabel);
        contributorTextField = new JTextField(20);
        contributorTextField.setEnabled(false);
        p5.add(contributorTextField);
        testPanel.add(p5);
        //, new GridConstraints(5, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_FIXED, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        //, new GridConstraints(1, 1, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_WANT_GROW, GridConstraints.SIZEPOLICY_FIXED, null, new Dimension(150, -1), null, 0, false));
        //, new GridConstraints(1, 2, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        treeModelLabel = new JLabel();
        treeModelLabel.setText("Tree Model:");
        p6.add(treeModelLabel);//, new GridConstraints(2, 0, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_FIXED, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        treeModelCombo = new JComboBox();
        p6.add(treeModelCombo);//, new GridConstraints(2, 1, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        testPanel.add(p6);

        JPanel pp1 = new JPanel(new FlowLayout());
        final JLabel label2 = new JLabel();
        label2.setFont(new Font(label2.getFont().getName(), Font.BOLD, label2.getFont().getSize()));
        label2.setText("Options");
        testPanel.add(label2);


        optionsPanel = new JPanel();
        optionsPanel.setLayout(new FlowLayout());//, new Insets(0, 0, 0, 0), -1, -1));

        eeModeCheckBox = new JCheckBox();
        eeModeCheckBox.setEnabled(true);
        eeModeCheckBox.setText("EE mode");
        optionsPanel.add(eeModeCheckBox);//, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        byteCodeCheckBox = new JCheckBox();
        byteCodeCheckBox.setLabel("ByteCode");
        byteCodeCheckBox.setText("ByteCode");
        optionsPanel.add(byteCodeCheckBox);//, new GridConstraints(0, 8, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        debugBytecodeCheckBox = new JCheckBox();
        debugBytecodeCheckBox.setText("Debug Bytecode");
        optionsPanel.add(debugBytecodeCheckBox);//, new GridConstraints(0, 9, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        pullModeCheckBox = new JCheckBox();
        pullModeCheckBox.setEnabled(false);
        pullModeCheckBox.setText("Pull mode");
        optionsPanel.add(pullModeCheckBox);//, new GridConstraints(0, 6, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        fastCheckBox = new JCheckBox();
        fastCheckBox.setText("Fast");
        optionsPanel.add(fastCheckBox);//, new GridConstraints(0, 7, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        xsdVersion = new JComboBox();
        xsdVersion.setToolTipText("Schema Version");
        optionsPanel.add(xsdVersion);//, new GridConstraints(0, 4, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        xsdVersionLab = new JLabel();
        xsdVersionLab.setText("Schema Version:");
        optionsPanel.add(xsdVersionLab);//, new GridConstraints(0, 3, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_FIXED, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        debugResultsCheckBox = new JCheckBox();
        debugResultsCheckBox.setText("debug results");
        optionsPanel.add(debugResultsCheckBox);//, new GridConstraints(0, 5, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        langComboBox = new JComboBox();
        langComboBox.setToolTipText("Language Version");
        //, new GridConstraints(0, 2, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        langLabel = new JLabel();
        langLabel.setText("Lang:");

        optionsPanel.add(langLabel);//, new GridConstraints(0, 1, 1, 1, GridConstraints.ANCHOR_WEST, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_FIXED, GridConstraints.SIZEPOLICY_FIXED, null, null, null, 0, false));
        optionsPanel.add(langComboBox);

        testPanel.add(optionsPanel);
        outputPanel = new JPanel();
        outputPanel.setLayout(new BorderLayout(0, 0));

        resultScrollPane = new JScrollPane();
        resultScrollPane.setHorizontalScrollBarPolicy(30);
        resultScrollPane.setMinimumSize(new Dimension(700, 300));
        resultScrollPane.setPreferredSize(new Dimension(700, 300));
        resultScrollPane.setVerticalScrollBarPolicy(22);
        outputPanel.add(resultScrollPane, BorderLayout.CENTER);
        resultTextArea = new JTextArea();
        resultScrollPane.setViewportView(resultTextArea);
        runPanel = new JPanel();
        runPanel.setLayout(new FlowLayout(FlowLayout.CENTER, 5, 5));

        //final Spacer spacer3 = new Spacer();
        //runPanel.add(spacer3);
        runButton = new JButton();
        runButton.setText("Run");
        runPanel.add(runButton);
        stopButton = new JButton();
        stopButton.setText("Stop");
        runPanel.add(stopButton);
        clearBtn = new JButton();
        clearBtn.setText("Clear");
        runPanel.add(clearBtn);
        //final Spacer spacer4 = new Spacer();
        //testDriverChooser.add(spacer4, new GridConstraints(7, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_VERTICAL, 1, GridConstraints.SIZEPOLICY_WANT_GROW, null, null, null, 0, false));


        final JPanel panel2 = new JPanel();
        panel2.setLayout(new FlowLayout());


        resultLabel = new JLabel();
        resultLabel.setEnabled(true);
        resultLabel.setText("Results:");

        resultsDirBtn = new JButton();
        resultsDirBtn.setBackground(SystemColor.window);
        resultsDirBtn.setHorizontalAlignment(2);
        resultsDirBtn.setText("<HTML><U>Open Results Directory</U></HTML>");
        panel2.add(resultsDirBtn);
        testPanel.add(panel2);
        testDriverChooser.add(testPanel);//, new GridConstraints(6, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        testDriverChooser.add(runPanel);//, new GridConstraints(10, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_NONE, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        panel2.add(resultLabel);

       // final Spacer spacer5 = new Spacer();
        //mainForm.add(spacer5, new GridConstraints(0, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_FIXED, 1, new Dimension(10, -1), new Dimension(10, -1), new Dimension(10, -1), 0, false));
        //final Spacer spacer6 = new Spacer();
        //mainForm.add(spacer6, new GridConstraints(0, 2, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_HORIZONTAL, GridConstraints.SIZEPOLICY_WANT_GROW, 1, new Dimension(10, -1), new Dimension(10, -1), new Dimension(10, -1), 0, false));
        Footer = new JPanel();
        Footer.setLayout(new GridBagLayout());
        GuiformPanel.add(Footer, BorderLayout.SOUTH);
        final JPanel panel3 = new JPanel();
        panel3.setLayout(new BorderLayout(0, 0));
        GridBagConstraints gbc;
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = GridBagConstraints.BOTH;
        Footer.add(panel3, gbc);
        final JPanel spacer7 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.fill = GridBagConstraints.HORIZONTAL;
        Footer.add(spacer7, gbc);
        final JPanel spacer8 = new JPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.fill = GridBagConstraints.VERTICAL;
        Footer.add(spacer8, gbc);
        final JPanel panel4 = new JPanel();
        panel4.setLayout(new BorderLayout(0, 0));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.fill = GridBagConstraints.BOTH;
        Footer.add(panel4, gbc);
        ButtonGroup buttonGroup;
        buttonGroup = new ButtonGroup();
        buttonGroup.add(FOTSTestDriverRadioButton);

        buttonGroup.add(schemaTestDriverRadioButton);
        buttonGroup.add(XMarkRadioButton);
        buttonGroup.add(updateTestDriverRadioButton);
        buttonGroup.add(XSLT30DriverButton);
        mainForm.add(Title, BorderLayout.NORTH);
        mainForm.add(testDriverChooser, BorderLayout.CENTER);//, new GridConstraints(0, 1, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        mainForm.add(outputPanel, BorderLayout.SOUTH);//, new GridConstraints(12, 0, 1, 1, GridConstraints.ANCHOR_CENTER, GridConstraints.FILL_BOTH, GridConstraints.SIZEPOLICY_CAN_GROW, GridConstraints.SIZEPOLICY_CAN_SHRINK | GridConstraints.SIZEPOLICY_CAN_GROW, null, null, null, 0, false));
        GuiformPanel.add(mainForm, BorderLayout.CENTER);

    }

    /**
     * @noinspection ALL
     */
    public JComponent $$$getRootComponent$$$() {
        return GuiformPanel;
    }


    class RunThread implements Runnable {


        @Override
        public void run() {

        }

    }

    public TestDriverGui() {
        $$$setupUI$$$();
        versionLabel.setText("Version: "+testDriverVersion);
        runButton.addActionListener(this);
        workingDirButton.addActionListener(this);
        resultsDirButton.addActionListener(this);
        stopButton.addActionListener(this);

        XSLT30DriverButton.addActionListener(this);
        FOTSTestDriverRadioButton.addActionListener(this);
        schemaTestDriverRadioButton.addActionListener(this);
        updateTestDriverRadioButton.addActionListener(this);
        XMarkRadioButton.addActionListener(this);
        pullModeCheckBox.addActionListener(this);
        byteCodeCheckBox.addActionListener(this);
        contributorTextField.addActionListener(this);
        clearBtn.addActionListener(this);
        xsdVersion.addItem("1.0");
        xsdVersion.addItem("1.1");
        xsdVersion.addActionListener(this);
        xsdVersion.setVisible(false);
        xsdVersionLab.setVisible(false);
        langComboBox.setVisible(false);
        langLabel.setVisible(false);
        langComboBox.addActionListener(this);
        langComboBox.addItem("XP20");
        langComboBox.addItem("XP30");
        langComboBox.addItem("XP31");
        langComboBox.addItem("XQ10");
        langComboBox.addItem("XQ30");
        langComboBox.addItem("XQ31");
        runButton.setEnabled(true);
        stopButton.setEnabled(false);
        resultLabel.setVisible(false);
        pullModeCheckBox.setVisible(false);
        contributorLabel.setVisible(false);
        contributorTextField.setVisible(false);
        contributorTextField.setText("");
        fastCheckBox.addActionListener(this);
        fastCheckBox.setVisible(true);
        testSetTextField.setVisible(false);
        testSetLabel.setVisible(false);
        debugResultsCheckBox.setVisible(false);
        /* resultsFileBtn.setVisible(false);
       resultsFileBtn.setBorderPainted(false);
       resultsFileBtn.setOpaque(false);
       resultsFileBtn.setToolTipText("Get Results File");
       // resultsFileBtn.addActionListener(this);
       resultsFileBtn.addMouseListener(this);
       resultsFileBtn.setCursor(new Cursor(Cursor.HAND_CURSOR));*/


        /*
        *   if (argv[i].startsWith("-tree")) {
                if (argv[i].substring(6).equalsIgnoreCase("dom")) {
                    treeModel = new DOMObjectModel();
                } else if (argv[i].substring(6).equalsIgnoreCase("jdom")) {
                    treeModel = new JDOMObjectModel();
                } else  if (argv[i].substring(6).equalsIgnoreCase("jdom2")) {
                    treeModel = new JDOM2ObjectModel();
                } else  if (argv[i].substring(6).equalsIgnoreCase("dom4j")) {
                    treeModel = new DOM4JObjectModel();
                } else  if (argv[i].substring(6).equalsIgnoreCase("xom")) {
                    treeModel = new XOMObjectModel();
                } else  if (argv[i].substring(6).equalsIgnoreCase("axiom")) {
                    treeModel = new AxiomObjectModel();
                } else if (argv[i].substring(6).equalsIgnoreCase("tinytree")) {
                    treeModel = TreeModel.TINY_TREE;
                } else if (argv[i].substring(6).equalsIgnoreCase("condensed")) {
                    treeModel = TreeModel.TINY_TREE_CONDENSED;
                } else if (argv[i].substring(6).equalsIgnoreCase("linked")) {
                    treeModel = TreeModel.LINKED_TREE;
        * */
        treeModelCombo.addItem("tinytree");

        treeModelCombo.addItem("condensed");
        treeModelCombo.addItem("linked");
        treeModelCombo.addItem("dom");
        treeModelCombo.addItem("idom");
        treeModelCombo.addItem("idom2");
        treeModelCombo.addItem("dom4j");
        treeModelCombo.addItem("xom");
        treeModelCombo.addItem("axiom");
        treeModelLabel.setVisible(false);
        treeModelCombo.setVisible(false);
        //treeModelField.setVisible(false);
         treeModelCombo.setSelectedIndex(0);
        resultsDirBtn.setVisible(false);
        resultsDirBtn.setBorderPainted(false);
        resultsDirBtn.setOpaque(false);
        resultsDirBtn.setToolTipText("Open Results Directory");
        resultsDirBtn.addMouseListener(this);
        resultsDirBtn.setCursor(new Cursor(Cursor.HAND_CURSOR));
        debugBytecodeCheckBox.setVisible(false);

        checkCacheFileCreated();

        xpc = driverProc.newXPathCompiler();
        xpc.setLanguageVersion("3.0");
        xpc.setCaching(true);

        workingDirField.setText(getCacheElement("xsltTestDriver").getText());

    }

    public Element getCacheElement(String name) {
        ElementFilter filter=new org.jdom2.filter.ElementFilter(name);
        IteratorIterable<Element> it = cacheNode.getDescendants(filter);
        if (it.hasNext()) {
            return it.next();
        } else {
            return null;
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Guiform");
        frame.setContentPane(new TestDriverGui().GuiformPanel);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.pack();
        frame.setVisible(true);
    }


    public void setResultTextArea(String data) {
        if (resultTextArea.getText().length() > 16000) {
            resultTextArea.setText("");
        }
        resultTextArea.append(data + "\n");
        resultTextArea.setCaretPosition(resultTextArea.getText().length() - 1);
    }

    private void updateCacheFile(JTextField dirField, String elementStr, String prevTestDriver, String currentSelectTestDriver) {
        try {
            Element e = getCacheElement(prevTestDriver);
            Element d = e.getChild(elementStr);
            d.setText(dirField.getText());
            d = e.getChild(currentSelectTestDriver);
            dirField.setText(d.getText());
        } catch (Exception e1) {
            checkCacheFileCreated();
        }
    }


    private void writeCacheFile(JTextField dirField, String testDriver, String elementStr) {
        Element e = getCacheElement(testDriver);
        Element d = e.getChild(elementStr);
        d.setText(dirField.getText());
        org.jdom2.output.XMLOutputter out = new XMLOutputter();
        try {
            FileOutputStream os = new FileOutputStream(cacheFile);
            out.output(cacheNode, os);
            os.close();
        } catch (IOException err) {
            checkCacheFileCreated();
        }
    }

    private void checkCacheFileCreated() {
        cacheFile = new File("cache.xml");

        SAXBuilder builder = new SAXBuilder();
        try {
            cacheNode = builder.build(cacheFile);
            return;
        } catch (JDOMException e) {
            //
        } catch (IOException e) {
            //
        }


        String cacheStr = "<cache>\n" +
                "    <dir>\n" +
                "        <xsltTestDriver>\n" +
                "            <workingDir/>\n" +
                "            <resultsDir />\n" +
                "        </xsltTestDriver>\n" +
                "        <xslt30TestDriver>" +
                "            <workingDir/>\n" +
                "            <resultsDir />\n" +
                "        </xslt30TestDriver>\n" +
                "        <XMarkBenchmarkTestDriver>" +
                "            <workingDir/>\n" +
                "            <resultsDir />\n" +
                "        </XMarkBenchmarkTestDriver>\n" +
                "        <fotsTestDriver>" +
                "            <workingDir/>\n" +
                "            <resultsDir />\n" +
                "        </fotsTestDriver>\n" +
                "        <schemaTestDriver>" +
                "            <workingDir/>\n" +
                "            <resultsDir />\n" +
                "        </schemaTestDriver>\n" +
                "        <updateTestDriver>" +
                "            <workingDir/>\n" +
                "            <resultsDir />\n" +
                "        </updateTestDriver>\n" +
                "    </dir>\n" +
                "</cache>";
         try {
            cacheNode = builder.build(new StringReader(cacheStr));
        } catch (JDOMException e) {
            e.printStackTrace();
            throw new AssertionError(e);
        } catch (IOException e) {
            e.printStackTrace();
            throw new AssertionError(e);
        }
        org.jdom2.output.XMLOutputter out = new XMLOutputter();
        try {
            FileOutputStream os = new FileOutputStream(cacheFile);
            out.output(cacheNode, os);
            os.close();
        } catch (IOException err) {
            err.printStackTrace();
            throw new AssertionError(err);
        }

    }


    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        resultLabel.setVisible(false);
       if (source == XSLT30DriverButton) {
            updateCacheFile(workingDirField, "workingDir", prevSource, "xslt30TestDriver");
            updateCacheFile(resultsDirField, "resultsDir", prevSource, "xslt30TestDriver");
            eeModeCheckBox.setEnabled(false);
            eeModeCheckBox.setSelected(false);
            eeModeCheckBox.setVisible(false);
            treeModelLabel.setVisible(false);
           treeModelCombo.setVisible(false);
            treeModelCombo.setVisible(false);
            langComboBox.setVisible(true);
            langComboBox.removeAllItems();
            langComboBox.addItem("XT20");
            langComboBox.addItem("XT30");
            langLabel.setVisible(true);
            resultsDirField.setVisible(true);
            resultsDirLabel.setVisible(true);
            resultsDirButton.setVisible(true);
            /*resultsFileBtn.setVisible(false);*/
            resultsDirBtn.setVisible(false);
            debugResultsCheckBox.setVisible(true);
            pullModeCheckBox.setEnabled(false);
            pullModeCheckBox.setSelected(false);
            pullModeCheckBox.setVisible(false);
            contributorTextField.setEnabled(false);
            contributorLabel.setEnabled(false);
            contributorLabel.setVisible(false);
            contributorTextField.setVisible(false);
            testSetTextField.setVisible(true);
            testSetLabel.setVisible(true);
            xsdVersion.setVisible(false);
            xsdVersionLab.setVisible(false);
            contributorTextField.setText("");
            testCaseTextField.setText("");
            testSetTextField.setText("");
            testCaseLabel.setText("Test Case:");
            fastCheckBox.setVisible(false);
            prevSource = "xslt30TestDriver";

        } else if (source == FOTSTestDriverRadioButton) {
            updateCacheFile(workingDirField, "workingDir", prevSource, "fotsTestDriver");
            updateCacheFile(resultsDirField, "resultsDir", prevSource, "fotsTestDriver");
            eeModeCheckBox.setEnabled(false);
            eeModeCheckBox.setSelected(false);
            eeModeCheckBox.setVisible(false);
            treeModelLabel.setVisible(true);
            treeModelCombo.setVisible(true);
            debugResultsCheckBox.setVisible(true);
            langComboBox.setVisible(true);
            langComboBox.removeAllItems();
            langComboBox.addItem("XP20");
             langComboBox.addItem("XP30");
            langComboBox.addItem("XP31");
            langComboBox.addItem("XQ10");
            langComboBox.addItem("XQ30");
            langComboBox.addItem("XQ31");

            langLabel.setVisible(true);
            resultsDirField.setVisible(true);
            resultsDirLabel.setVisible(true);
            resultsDirButton.setVisible(true);
            /*resultsFileBtn.setVisible(false);*/
            resultsDirBtn.setVisible(false);
            pullModeCheckBox.setEnabled(false);
            pullModeCheckBox.setSelected(false);
            pullModeCheckBox.setVisible(false);
            xsdVersion.setVisible(false);
            xsdVersionLab.setVisible(false);
            contributorTextField.setEnabled(false);
            contributorLabel.setEnabled(false);
            contributorLabel.setVisible(false);
            contributorTextField.setVisible(false);
            testSetTextField.setVisible(true);
            testSetLabel.setVisible(true);
            contributorTextField.setText("");
            testCaseTextField.setText("");
            testSetTextField.setText("");
            testCaseLabel.setText("Test Case:");
            fastCheckBox.setVisible(false);
            prevSource = "fotsTestDriver";
        } else if (source == XMarkRadioButton) {
            updateCacheFile(workingDirField, "workingDir", prevSource, "XMarkBenchmarkTestDriver");
            updateCacheFile(resultsDirField, "resultsDir", prevSource, "XMarkBenchmarkTestDriver");
            resultsDirField.setVisible(false);
            resultsDirLabel.setVisible(false);
            resultsDirButton.setVisible(false);
            treeModelLabel.setVisible(true);
            treeModelCombo.setVisible(true);
            eeModeCheckBox.setEnabled(true);
            eeModeCheckBox.setSelected(false);
            eeModeCheckBox.setVisible(true);
            langComboBox.setVisible(false);
            langLabel.setVisible(false);
            /*resultsFileBtn.setVisible(false);*/
            debugResultsCheckBox.setVisible(false);
            pullModeCheckBox.setEnabled(true);
            pullModeCheckBox.setVisible(true);
            contributorTextField.setEnabled(false);
            contributorLabel.setVisible(false);
            contributorTextField.setVisible(false);
            fastCheckBox.setVisible(false);
            testSetTextField.setVisible(false);
            testSetLabel.setVisible(false);
            xsdVersion.setVisible(false);
            xsdVersionLab.setVisible(false);
            contributorTextField.setText("");
            testCaseTextField.setText("");
            testSetTextField.setText("");
            testCaseLabel.setText("Test Case:");
            contributorLabel.setEnabled(false);
            prevSource = "XMarkBenchmarkTestDriver";
        } else if (source == schemaTestDriverRadioButton) {
            updateCacheFile(workingDirField, "workingDir", prevSource, "schemaTestDriver");
            updateCacheFile(resultsDirField, "resultsDir", prevSource, "schemaTestDriver");
            eeModeCheckBox.setEnabled(false);
            eeModeCheckBox.setSelected(true);
            pullModeCheckBox.setEnabled(false);
            treeModelLabel.setVisible(false);
           treeModelCombo.setVisible(false);
            treeModelCombo.setVisible(false);
            debugResultsCheckBox.setVisible(false);
            langComboBox.setVisible(false);
            langLabel.setVisible(false);
            resultsDirField.setVisible(true);
            resultsDirLabel.setVisible(true);
            resultsDirButton.setVisible(true);
            /*resultsFileBtn.setVisible(false);*/
            resultsDirBtn.setVisible(false);
            fastCheckBox.setVisible(false);
            xsdVersion.setVisible(true);
            xsdVersionLab.setVisible(true);
            pullModeCheckBox.setSelected(false);
            pullModeCheckBox.setVisible(false);
            contributorLabel.setVisible(true);
            contributorLabel.setEnabled(true);
            contributorTextField.setVisible(true);
            contributorTextField.setEnabled(true);
            testSetTextField.setVisible(true);
            testSetLabel.setVisible(true);
            contributorTextField.setText("");
            testCaseTextField.setText("");
            testSetTextField.setText("");
            testCaseLabel.setText("Group:");
            prevSource = "schemaTestDriver";
        } else if (source == updateTestDriverRadioButton) {
            updateCacheFile(workingDirField, "workingDir", prevSource, "updateTestDriver");
            updateCacheFile(resultsDirField, "resultsDir", prevSource, "updateTestDriver");
            eeModeCheckBox.setEnabled(false);
            eeModeCheckBox.setVisible(false);
            treeModelLabel.setVisible(false);
            treeModelCombo.setVisible(false);
            langComboBox.setVisible(false);
            langLabel.setVisible(false);
            resultsDirField.setVisible(true);
            resultsDirLabel.setVisible(true);
            resultsDirButton.setVisible(true);
            /*resultsFileBtn.setVisible(false);*/
            resultsDirBtn.setVisible(false);
            debugResultsCheckBox.setVisible(false);
            eeModeCheckBox.setSelected(true);
            pullModeCheckBox.setEnabled(true);
            pullModeCheckBox.setVisible(true);
            pullModeCheckBox.setSelected(false);
            contributorTextField.setEnabled(true);
            fastCheckBox.setVisible(false);
            contributorLabel.setEnabled(false);
            contributorLabel.setVisible(false);
            xsdVersion.setVisible(false);
            xsdVersionLab.setVisible(false);
            contributorTextField.setVisible(false);
            testSetTextField.setVisible(true);
            testSetLabel.setVisible(true);
            contributorTextField.setText("");
            testCaseTextField.setText("");
            testSetTextField.setText("");
            testCaseLabel.setText("Test Case:");
            prevSource = "updateTestDriver";
        } else if (source == clearBtn) {
            if (runButton.isEnabled()) {
                resultTextArea.setText("");
            }

        } else if (source == runButton) {
            resultTextArea.setText("");

            String byteCodeStr = (debugBytecodeCheckBox.isSelected() ? ":debug" : "on");

            /*resultsFileBtn.setVisible(false);*/
            resultsDirBtn.setVisible(false);

           if (XSLT30DriverButton.isSelected()) {
                processXslt30DriverButton(byteCodeStr);

            } else if (FOTSTestDriverRadioButton.isSelected()) {
                processFotsDriverButton(byteCodeStr);

            } else if (schemaTestDriverRadioButton.isSelected()) {
                processSchemaDriverButton();

            } else if (updateTestDriverRadioButton.isSelected()) {
                processUpdateDriverButton();

            } else if (XMarkRadioButton.isSelected()) {
                processXMarkDriverButton();
            }


        } else if (source == workingDirButton) {
            int result;
            JFileChooser chooser = new JFileChooser();
            String choosertitle = "";
            chooser.setCurrentDirectory(new File("."));
            chooser.setDialogTitle(choosertitle);
            chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            chooser.setAcceptAllFileFilterUsed(false);
            //

            if (chooser.showOpenDialog(null/*this*/) == JFileChooser.APPROVE_OPTION) {
                System.out.println("getCurrentDirectory(): "
                        + chooser.getCurrentDirectory());
                System.out.println("getSelectedFile() : "
                        + chooser.getSelectedFile());

                workingDirField.setText(chooser.getSelectedFile().toString());
            } else {
                System.out.println("No Selection ");
            }


        } else if (source == resultsDirButton) {
            int result;
            JFileChooser chooser = new JFileChooser();
            String choosertitle = "";
            chooser.setCurrentDirectory(new File("."));
            chooser.setDialogTitle(choosertitle);
            chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
            chooser.setAcceptAllFileFilterUsed(false);
            //

            if (chooser.showOpenDialog(null/*this*/) == JFileChooser.APPROVE_OPTION) {
                System.out.println("getCurrentDirectory(): "
                        + chooser.getCurrentDirectory());
                System.out.println("getSelectedFile() : "
                        + chooser.getSelectedFile());

                resultsDirField.setText(chooser.getSelectedFile().toString());
            } else {
                System.out.println("No Selection ");
            }


        } else if (source == stopButton) {
//#if EE==true || PE==true
            if (thread != null) {
                if (xmark != null) {
                    synchronized (xmark) {
                        xmark.stopThread(true);
                    }
                }
                thread.interrupt();
                runButton.setEnabled(true);
                /*resultsFileBtn.setVisible(false);*/
                resultsDirBtn.setVisible(false);
            }
//#endif
        }

    }

    private void processXMarkDriverButton() {
        writeCacheFile(workingDirField, "XMarkBenchmarkTestDriver", "workingDir");
        writeCacheFile(resultsDirField, "XMarkBenchmarkTestDriver", "resultsDir");
//#if EE==true || PE==true
        xmark = new XMarkBenchmark();
        //xmark.setGuiform(this);
        String testSuiteDir = (workingDirField.getText().length() > 0 ? workingDirField.getText() : ".");
        String treeModelStr = treeModelCombo.getSelectedItem().toString();
        System.err.println(workingDirField.getText());
        //"Options: -pull -lazy -sa -xslt -compile -runcomp -tree")
        final String[] options = {"-dir:" + testSuiteDir + "/", (byteCodeCheckBox.isSelected() ? "-runcomp" : ""), (treeModelStr.equals("") ? "" : "-tree:" + treeModelStr), (pullModeCheckBox.isSelected() ? "-pull" : ""), (eeModeCheckBox.isSelected() ? "-sa" : ""), (testCaseTextField.getText().length() > 0 ? "-" + testCaseTextField.getText() : "-xx")};

        class RunThread1 extends RunThread {

            @Override
            public void run() {
                try {
                    xmark.go(options);
                    runButton.setEnabled(true);
                    xmark = null;
                } catch (Exception e) {
                    runButton.setEnabled(true);
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Setup Error", JOptionPane.ERROR_MESSAGE);
                    System.err.println(e);
                }
            }


        }

        Runnable runnable = new RunThread1();

        thread = new Thread(runnable);
        runButton.setEnabled(false);
        thread.start();
        stopButton.setEnabled(true);
        prevSource = "XMarkBenchmarkTestDriver";
//#endif
    }

    private void processUpdateDriverButton() {
        writeCacheFile(workingDirField, "updateTestDriver", "workingDir");
        writeCacheFile(resultsDirField, "updateTestDriver", "resultsDir");
//#if EE==true
        //UpdateTestSuiteDriver testsuiteDir saxonDir [testNamePattern] [-compile:off] [-runcomp] [-w] [-onwards] [-unfold] [-pull]

        final com.saxonica.testdriver.ee.UpdateTestSuiteDriver updateDriver = new com.saxonica.testdriver.ee.UpdateTestSuiteDriver();
        //updateDriver.setGuiform(this);

        String testSuiteDir = (workingDirField.getText().length() > 0 ? workingDirField.getText() : ".");
        String resultsDir = (resultsDirField.getText().length() > 0 ? resultsDirField.getText() : testSuiteDir + "/results/saxon");
        System.err.println(workingDirField.getText());

        final String[] options = {testSuiteDir, resultsDir, (byteCodeCheckBox.isSelected() ? "-compile:on" : "-compile:off"), (testCaseTextField.getText().length() > 0 ? testCaseTextField.getText() : ""), (pullModeCheckBox.isSelected() ? "-pull" : "")};

        class RunThread1 extends RunThread {

            @Override
            public void run() {
                try {
                    updateDriver.go(options);
                    runButton.setEnabled(true);
                } catch (LicenseException e) {
                    runButton.setEnabled(true);
                    JOptionPane.showMessageDialog(null, "License Not Found!", "License Error", JOptionPane.ERROR_MESSAGE);
                    System.err.println(e);
                } catch (Exception e) {
                    runButton.setEnabled(true);
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Setup Error", JOptionPane.ERROR_MESSAGE);
                    System.err.println(e);
                }

            }


        }

        Runnable runnable = new RunThread1();

        thread = new Thread(runnable);
        runButton.setEnabled(false);
        thread.start();
        stopButton.setEnabled(true);
        prevSource = "updateTestDriver";
//#endif
    }

    private void processSchemaDriverButton() {
        writeCacheFile(workingDirField, "schemaTestDriver", "workingDir");
        writeCacheFile(resultsDirField, "schemaTestDriver", "resultsDir");

//#if EE==true
        //SchemaTestSuiteDriver testDir [-w] [-onwards] [-scm:scmschema.xsd] -v:1.0|1.1 -c:contributor? -s:setName? -g:groupName?");

        final com.saxonica.testdriver.ee.SchemaTestSuiteDriver schema = new com.saxonica.testdriver.ee.SchemaTestSuiteDriver();
        schema.setTestDriverShell(this);

        String testSuiteDir = (workingDirField.getText().length() > 0 ? workingDirField.getText() : ".");
        System.err.println(workingDirField.getText());
        //"Options: -pull -lazy -sa -xslt -compile -runcomp")
        final String[] options = {testSuiteDir + "/", "-v:" + (xsdVersion.getSelectedIndex() == 0 ? "1.0" : "1.1"), (testCaseTextField.getText().length() > 0 ? "-c:" + contributorTextField.getText() : ""), (testSetTextField.getText().length() > 0 ? "-s:" + testSetTextField.getText() : ""), (testCaseTextField.getText().length() > 0 ? "-g:" + testCaseTextField.getText() : "")};

        class RunThread1 extends RunThread {

            @Override
            public void run() {
                try {
                    schema.go(options);
                    runButton.setEnabled(true);
                } catch (Exception e) {
                    runButton.setEnabled(true);
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Setup Error", JOptionPane.ERROR_MESSAGE);
                    System.err.println(e);
                }
            }
        }

        Runnable runnable = new RunThread1();

        thread = new Thread(runnable);
        thread.start();
        runButton.setEnabled(false);
        stopButton.setEnabled(true);
        prevSource = "schemaTestDriver";
//#endif
    }

    private void processFotsDriverButton(String byteCodeStr) {
        writeCacheFile(workingDirField, "fotsTestDriver", "workingDir");
        writeCacheFile(resultsDirField, "fotsTestDriver", "resultsDir");
        String debugResultsStr = (debugResultsCheckBox.isSelected() ? "-debug" : "");
        final QT3TestDriverHE fots = new QT3TestDriverHE();
        fots.setTestDriverShell(this);
        String testSuiteDir = (workingDirField.getText().length() > 0 ? workingDirField.getText() : ".");
        String resultsDir = (resultsDirField.getText().length() > 0 ? resultsDirField.getText() : testSuiteDir + "/results/saxon");
        System.err.println(workingDirField.getText());

        final String[] options = {testSuiteDir, testSuiteDir + "/catalog.xml", "-o:" + resultsDir, "-bytecode" + (byteCodeCheckBox.isSelected() ? byteCodeStr : ":off"), (testCaseTextField.getText().length() > 0 ? "-t:" + testCaseTextField.getText() : ""), (testSetTextField.getText().length() > 0 ? "-s:" + testSetTextField.getText() : ""), debugResultsStr, "-lang:" + langComboBox.getSelectedItem()};

        class RunThread1 extends RunThread {

            @Override
            public void run() {
                try {
                    fots.go(options);
                    runButton.setEnabled(true);
                } catch (Exception e) {
                    runButton.setEnabled(true);
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Setup Error", JOptionPane.ERROR_MESSAGE);
                    System.err.println(e.getMessage());
                }

            }

        }

        Runnable runnable = new RunThread1();

        thread = new Thread(runnable);
        thread.start();
        runButton.setEnabled(false);
        stopButton.setEnabled(true);
        prevSource = "fotsTestDriver";
    }

    private void processXslt30DriverButton(String byteCodeStr) {
        writeCacheFile(workingDirField, "xslt30TestDriver", "workingDir");
        writeCacheFile(resultsDirField, "xslt30TestDriver", "resultsDir");
        String debugResultsStr = (debugResultsCheckBox.isSelected() ? "-debug" : "");
        final Xslt30TestSuiteDriverEE xslt30 = new Xslt30TestSuiteDriverEE();
        xslt30.setTestDriverShell(this);
        String testSuiteDir = (workingDirField.getText().length() > 0 ? workingDirField.getText() : ".");
        String resultsDir = (resultsDirField.getText().length() > 0 ? resultsDirField.getText() : testSuiteDir + "/results/saxon");
        System.err.println(workingDirField.getText());

        final String[] options = {testSuiteDir, testSuiteDir + "/catalog.xml", "-o:" + resultsDir, "-bytecode" + (byteCodeCheckBox.isSelected() ? byteCodeStr : ":off"), (testCaseTextField.getText().length() > 0 ? "-t:" + testCaseTextField.getText() : ""), (testSetTextField.getText().length() > 0 ? "-s:" + testSetTextField.getText() : ""), "-lang:" + langComboBox.getSelectedItem(), debugResultsStr};

        class RunThread1 extends RunThread {

            @Override
            public void run() {
                try {
                    xslt30.go(options);
                    runButton.setEnabled(true);
                } catch (Exception e) {
                    runButton.setEnabled(true);
                    JOptionPane.showMessageDialog(null, e.getMessage(), "Setup Error", JOptionPane.ERROR_MESSAGE);
                    System.err.println(e.getMessage());
                }

            }

        }

        Runnable runnable = new RunThread1();

        thread = new Thread(runnable);
        thread.start();
        runButton.setEnabled(false);
        stopButton.setEnabled(true);
        prevSource = "xslt30TestDriver";
    }


    @Override
    public void printResults(String data, String resultFileStr, String resultsDir) {
        resultLabel.setVisible(true);
        /*resultsFileBtn.setVisible(true);*/
        resultsDirBtn.setVisible(true);
        resultLabel.setText(data);
        this.resultFileStr = resultFileStr;
        this.resultsDir = resultsDir;
    }

    @Override
    public void alert(String error) {
        JOptionPane.showMessageDialog(null, error, "Setup Error", JOptionPane.YES_NO_OPTION);
    }

    @Override
    public void println(String data) {
        setResultTextArea(data);
    }


}

// Copyright (c) 2011-2020 Saxonica Limited
