.\" *********************************** start of \input{common.tex}
.\" *********************************** end of \input{common.tex}
'\" t
.\" Manual page created with latex2man on Tue Aug 29 11:41:44 2023
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_INIT\\_REMOTE" "3libunwind" "29 August 2023" "Programming Library " "Programming Library "
.SH NAME
unw_init_remote
\-\- initialize cursor for remote unwinding 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_init_remote(unw_cursor_t *c,
unw_addr_space_t as,
void *arg);
.br
.PP
.SH DESCRIPTION

.PP
The unw_init_remote()
routine initializes the unwind cursor 
pointed to by c
for unwinding in the address space identified by 
as\&.
The as
argument can either be set to 
unw_local_addr_space
(local address space) or to an arbitrary 
address space created with unw_create_addr_space().
.PP
The arg
opaque pointer tells the address space exactly what entity 
should be unwound. For example, if unw_local_addr_space
is 
passed in as,
then arg
needs to be a pointer to a context 
structure containing the machine\-state of the initial stack frame. 
However, other address spaces may instead expect a process ID, a 
thread ID, or a pointer to an arbitrary structure which identifies the 
stack frame chain to be unwound. In other words, the interpretation 
of arg
is entirely dependent on the address space in use; 
libunwind
never interprets the argument in any way on its own. 
.PP
Note that unw_init_remote()
can be used to initiate unwinding 
in \fIany\fP
process, including the local process in which the 
unwinder itself is running. However, for local unwinding, it is 
generally preferable to use unw_init_local()
instead, because 
it is easier to use and because it may perform better. 
.PP
.SH RETURN VALUE

.PP
On successful completion, unw_init_remote()
returns 0. 
Otherwise the negative value of one of the error\-codes below is 
returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_init_remote()
is thread safe. If the local address space 
is passed in argument as,
this routine is also safe to use from 
a signal handler. 
.PP
.SH ERRORS

.PP
.TP
UNW_EINVAL
 unw_init_remote()
was called in a 
version of libunwind
which supports local unwinding only 
(this normally happens when defining UNW_LOCAL_ONLY
before 
including <libunwind.h>
and then calling 
unw_init_remote()).
.TP
UNW_EUNSPEC
 An unspecified error occurred. 
.TP
UNW_EBADREG
 A register needed by unw_init_remote()
wasn\&'t accessible. 
.PP
.SH SEE ALSO

.PP
libunwind(3libunwind),
unw_create_addr_space(3libunwind),
unw_init_local(3libunwind)
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br
Email: \fBdmosberger@gmail.com\fP
.br
WWW: \fBhttp://www.nongnu.org/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
