# NIF Bindings

## Engine

| Rust                                                                                                                                      | Elixir                                                                                                                    | Notes                                                                                                                      |
| ----------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------- | -------------------------------------------------------------------------------------------------------------------------- |
| [allow_anonymous_fn](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.allow_anonymous_fn)                                       | [allow_anonymous_fn/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#allow_anonymous_fn/1)                             |                                                                                                                            |
| [allow_if_expression](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.allow_if_expression)                                     | [allow_if_expression/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#allow_if_expression/1)                           |                                                                                                                            |
| [allow_loop_expressions](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.allow_loop_expressions)                               | [allow_loop_expressions/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#allow_loop_expressions/1)                     |                                                                                                                            |
| [allow_looping](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.allow_looping)                                                 | [allow_looping/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#allow_looping/1)                                       |                                                                                                                            |
| [allow_shadowing](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.allow_shadowing)                                             | [allow_shadowing/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#allow_shadowing/1)                                   |                                                                                                                            |
| [allow_statement_expression](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.allow_statement_expression)                       | [allow_statement_expression/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#allow_statement_expression/1)             |                                                                                                                            |
| [allow_switch_expression](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.allow_switch_expression)                             | [allow_switch_expression/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#allow_switch_expression/1)                   |                                                                                                                            |
| [build_type](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.build_type)                                                       | -                                                                                                                         | use [dylib](../README.md#extending-rhai-rustler-with-external-native-rust-modules) instead                                 |
| [call_fn](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.call_fn)                                                             | [call_fn/4](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#call_fn/4)                                                   |                                                                                                                            |
| [call_fn_dynamic](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.call_fn_dynamic)                                             | -                                                                                                                         | deprecated                                                                                                                 |
| [call_fn_raw](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.call_fn_raw)                                                     | -                                                                                                                         | deprecated                                                                                                                 |
| [call_fn_with_options](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.call_fn_with_options)                                   | -                                                                                                                         | advanced API                                                                                                               |
| [compact_script](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.compact_script)                                               | [compact_script/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#compact_script/2)                                     |                                                                                                                            |
| [compile](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.compile)                                                             | [compile/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#compile/2)                                                   |                                                                                                                            |
| [compile_expression](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.compile_expression)                                       | [compile_expression/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#compile_expression/2)                             |                                                                                                                            |
| [compile_expression_with_scope](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.compile_expression_with_scope)                 | [compile_expression_with_scope/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#compile_expression_with_scope/2)       |                                                                                                                            |
| [compile_file](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.compile_file)                                                   | [compile_file/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#compile_file/2)                                         |                                                                                                                            |
| [compile_file_with_scope](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.compile_file_with_scope)                             | [compile_file_with_scope/3](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#compile_file_with_scope/3)                   |                                                                                                                            |
| [compile_into_self_contained](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.compile_into_self_contained)                     | [compile_into_self_contained/3](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#compile_into_self_contained/3)           |                                                                                                                            |
| [compile_scripts_with_scope](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.compile_scripts_with_scope)                       | [compile_scripts_with_scope/3](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#compile_scripts_with_scope/3)             |                                                                                                                            |
| [compile_with_scope](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.compile_with_scope)                                       | [compile_with_scope/3](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#compile_with_scope/3)                             |                                                                                                                            |
| [const_empty_string](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.const_empty_string)                                       | -                                                                                                                         | not implemented                                                                                                            |
| [consume](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.consume)                                                             | -                                                                                                                         | deprecated, use `run` instead                                                                                              |
| [consume_ast](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.consume_ast)                                                     | -                                                                                                                         | deprecated                                                                                                                 |
| [consume_ast_with_scope](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.consume_ast_with_scope)                               | -                                                                                                                         | deprecated                                                                                                                 |
| [consume_file](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.consume_file)                                                   | -                                                                                                                         | deprecated                                                                                                                 |
| [consume_file_with_scope](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.consume_file_with_scope)                             | -                                                                                                                         | deprecated                                                                                                                 |
| [consume_with_scope](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.consume_with_scope)                                       | -                                                                                                                         | deprecated                                                                                                                 |
| [default_tag](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.default_tag)                                                     | -                                                                                                                         | not implemented                                                                                                            |
| [default_tag_mut](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.default_tag_mut)                                             | -                                                                                                                         | not implemented                                                                                                            |
| [definitions](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.definitions)                                                     | -                                                                                                                         | internals                                                                                                                  |
| [definitions_with_scope](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.definitions_with_scope)                               | -                                                                                                                         | internals                                                                                                                  |
| [disable_symbol](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.disable_symbol)                                               | -                                                                                                                         |                                                                                                                            |
| [ensure_data_size_within_limits](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.ensure_data_size_within_limits)               | [ensure_data_size_within_limits/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#ensure_data_size_within_limits/2)     |                                                                                                                            |
| [eval](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.eval)                                                                   | [eval/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#eval/2)                                                         |                                                                                                                            |
| [eval_ast](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.eval_ast)                                                           | [eval_ast/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#eval_ast/2)                                                 |                                                                                                                            |
| [eval_ast_with_scope](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.eval_ast_with_scope)                                     | [eval_ast_with_scope/3](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#eval_ast_with_scope/3)                           |                                                                                                                            |
| [eval_expression](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.eval_expression)                                             | [eval_expression/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#eval_expression/2)                                   |                                                                                                                            |
| [eval_expression_with_scope](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.eval_expression_with_scope)                       | [eval_expression_with_scope/3](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#eval_expression_with_scope/3)             |                                                                                                                            |
| [eval_file](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.eval_file)                                                         | [eval_file/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#eval_file/2)                                               |                                                                                                                            |
| [eval_file_with_scope](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.eval_file_with_scope)                                   | [eval_file_with_scope/3](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#eval_file_with_scope/3)                         |                                                                                                                            |
| [eval_statements_raw](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.eval_statements_raw)                                     | -                                                                                                                         | deprecated                                                                                                                 |
| [eval_with_scope](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.eval_with_scope)                                             | [eval_with_scope/3](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#eval_with_scope/3)                                   |                                                                                                                            |
| [fail_on_invalid_map_property](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.fail_on_invalid_map_property)                   | [fail_on_invalid_map_property/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#fail_on_invalid_map_property/1)         |                                                                                                                            |
| [fast_operators](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.fast_operators)                                               | [fast_operators/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#fast_operators/1)                                     |                                                                                                                            |
| [gen_fn_metadata_to_json](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.gen_fn_metadata_to_json)                             | -                                                                                                                         | not implemented, metadata feature is not enabled                                                                           |
| [gen_fn_metadata_with_ast_to_json](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.gen_fn_metadata_with_ast_to_json)           | -                                                                                                                         | not implemented, metadata feature is not enabled                                                                           |
| [gen_fn_signatures](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.gen_fn_signatures)                                         | -                                                                                                                         | not implemented, metadata feature is not enabled                                                                           |
| [get_interned_string](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.get_interned_string)                                     | -                                                                                                                         | internals                                                                                                                  |
| [lex](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.lex)                                                                     | -                                                                                                                         | internals                                                                                                                  |
| [lex_with_map](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.lex_with_map)                                                   | -                                                                                                                         | internals                                                                                                                  |
| [map_type_name](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.map_type_name)                                                 | -                                                                                                                         | not implemented                                                                                                            |
| [max_array_size](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.max_array_size)                                               | [max_array_size/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#max_array_size/1)                                     |                                                                                                                            |
| [max_call_levels](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.max_call_levels)                                             | [max_call_levels/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#max_call_levels/1)                                   |                                                                                                                            |
| [max_expr_depth](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.max_expr_depth)                                               | [max_expr_depth/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#max_expr_depth/1)                                     |                                                                                                                            |
| [max_function_expr_depth](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.max_function_expr_depth)                             | [max_function_expr_depth/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#max_function_expr_depth/1)                   |                                                                                                                            |
| [max_map_size](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.max_map_size)                                                   | [max_map_size/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#max_map_size/1)                                         |                                                                                                                            |
| [max_modules](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.max_modules)                                                     | [max_modules/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#max_modules/1)                                           |                                                                                                                            |
| [max_operations](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.max_operations)                                               | [max_operations/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#max_operations/1)                                     |                                                                                                                            |
| [max_string_size](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.max_string_size)                                             | [max_string_size/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#max_string_size/1)                                   |                                                                                                                            |
| [new](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.new)                                                                     | [new/0](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#new/0)                                                           |                                                                                                                            |
| [new_raw](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.new_raw)                                                             | [new_raw/0](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#new_raw/0)                                                   |                                                                                                                            |
| [optimization_level](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.optimization_level)                                       | [optimization_level/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#optimization_level/1)                             |                                                                                                                            |
| [optimize_ast](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.optimize_ast)                                                   | [optimize_ast/4](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#optimize_ast/4)                                         |                                                                                                                            |
| [register_custom_operator](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.register_custom_operator)                           | [register_custom_operator/3](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#register_custom_operator/3)                 | use [dylib](../README.md#extending-rhai-rustler-with-external-native-rust-modules) instead                                 |
| [register_global_module](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.register_global_module)                               | [register_global_module/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#register_global_module/2)                     |                                                                                                                            |
| [register_indexer_get](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.register_indexer_get)                                   | -                                                                                                                         | use [dylib](../README.md#extending-rhai-rustler-with-external-native-rust-modules) instead                                 |
| [register_custom_syntax](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.register_custom_syntax)                               | -                                                                                                                         | use [dylib](../README.md#extending-rhai-rustler-with-external-native-rust-modules) instead                                 |
| [register_custom_syntax_raw](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.register_custom_syntax_raw)                       | -                                                                                                                         | deprecated                                                                                                                 |
| [register_custom_syntax_with_state_raw](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.register_custom_syntax_with_state_raw) | -                                                                                                                         | low level API                                                                                                              |
| [register_debugger](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.register_debugger)                                         | -                                                                                                                         | unstable                                                                                                                   |
| [register_fn](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.register_fn)                                                     | -                                                                                                                         | use [dylib](../README.md#extending-rhai-rustler-with-external-native-rust-modules) instead                                 |
| [register_get](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.register_get)                                                   | -                                                                                                                         | use [dylib](../README.md#extending-rhai-rustler-with-external-native-rust-modules) instead                                 |
| [register_get_result](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.register_get_result)                                     | -                                                                                                                         | deprecated                                                                                                                 |
| [register_get_set](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.register_get_set)                                           | -                                                                                                                         | use [dylib](../README.md#extending-rhai-rustler-with-external-native-rust-modules) instead                                 |
| [run](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.run)                                                                     | [run/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#run/2)                                                           |                                                                                                                            |
| [run_ast](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.run_ast)                                                             | [run_ast/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#run_ast/2)                                                   |                                                                                                                            |
| [run_ast_with_scope](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.run_ast_with_scope)                                       | [run_ast_with_scope/3](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#run_ast_with_scope/3)                             |                                                                                                                            |
| [run_file](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.run_file)                                                           | [run_file/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#run_file/2)                                                 |                                                                                                                            |
| [run_file_with_scope](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.run_file_with_scope)                                     | [run_file_with_scope/3](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#run_file_with_scope/3)                           |                                                                                                                            |
| [run_with_scope](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.run_with_scope)                                               | [run_with_scope/3](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#run_with_scope/3)                                     |                                                                                                                            |
| [set_allow_anonymous_fn](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_allow_anonymous_fn)                               | [set_allow_anonymous_fn/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_allow_anonymous_fn/2)                     |                                                                                                                            |
| [set_allow_if_expression](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_allow_if_expression)                             | [set_allow_if_expression/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_allow_if_expression/2)                   |                                                                                                                            |
| [set_allow_loop_expressions](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_allow_loop_expressions)                       | [set_allow_loop_expressions/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_allow_loop_expressions/2)             |                                                                                                                            |
| [set_allow_looping](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_allow_looping)                                         | [set_allow_looping/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_allow_looping/2)                               |                                                                                                                            |
| [set_allow_shadowing](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_allow_shadowing)                                     | [set_allow_shadowing/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_allow_shadowing/2)                           |                                                                                                                            |
| [set_allow_statement_expression](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_allow_statement_expression)               | [set_allow_statement_expression/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_allow_statement_expression/2)     |                                                                                                                            |
| [set_allow_switch_expression](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_allow_switch_expression)                     | [set_allow_switch_expression/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_allow_switch_expression/2)           |                                                                                                                            |
| [set_default_tag](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_default_tag)                                             | -                                                                                                                         | not implemented                                                                                                            |
| [set_fail_on_invalid_map_property](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_fail_on_invalid_map_property)           | [set_fail_on_invalid_map_property/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_fail_on_invalid_map_property/2) |                                                                                                                            |
| [set_fast_operators](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_fast_operators)                                       | [set_fast_operators/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_fast_operators/2)                             |                                                                                                                            |
| [set_max_array_size](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_max_array_size)                                       | [set_max_array_size/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_max_array_size/2)                             |                                                                                                                            |
| [set_max_call_levels](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_max_call_levels)                                     | [set_max_call_levels/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_max_call_levels/2)                           |                                                                                                                            |
| [set_max_expr_depths](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_max_expr_depths)                                     | [set_max_expr_depths/3](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_max_expr_depths/3)                           |                                                                                                                            |
| [set_max_map_size](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_max_map_size)                                           | [set_max_map_size/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_max_map_size/2)                                 |                                                                                                                            |
| [set_max_modules](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_max_modules)                                             | [set_max_modules/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_max_modules/2)                                   |                                                                                                                            |
| [set_max_operations](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_max_operations)                                       | [set_max_operations/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_max_operations/2)                             |                                                                                                                            |
| [set_max_string_size](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_max_string_size)                                     | [set_max_string_size/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_max_string_size/2)                           |                                                                                                                            |
| [set_module_resolver](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_module_resolver)                                     | [set_module_resolvers/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_module_resolvers/2)                         | sets a [ModuleResolverCollection](https://docs.rs/rhai/latest/rhai/module_resolvers/struct.ModuleResolversCollection.html) |
| [set_optimization_level](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_optimization_level)                               | [set_optimization_level/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_optimization_level/2)                     |                                                                                                                            |
| [set_strict_variables](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.set_strict_variables)                                   | [set_strict_variables/2](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#set_strict_variables/2)                         |                                                                                                                            |
| [strict_variables](https://docs.rs/rhai/latest/rhai/struct.Engine.html#method.strict_variables)                                           | [strict_variables/1](https://hexdocs.pm/rhai_rustler/Rhai.Engine.html#strict_variables/1)                                 |                                                                                                                            |

## Scope

| Rust                                                                                                     | Elixir                                                                             | Notes                                                                                                     |
| -------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------- | --------------------------------------------------------------------------------------------------------- |
| [clear](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.clear)                                 | [clear/1](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#clear/1)                 |                                                                                                           |
| [clone_visible](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.clone_visible)                 | [clone_visible/1](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#clone_visible/1) |                                                                                                           |
| [contains](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.contains)                           | [contains/2](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#contains/2)           |                                                                                                           |
| [get](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.get)                                     | -                                                                                  | not implemented, use `get_value`                                                                          |
| [get_mut](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.get_mut)                             | -                                                                                  | not implemented, use `get_value`                                                                          |
| [get_value](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.get_value)                         | [get_value/2](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#get_value/2)         |                                                                                                           |
| [is_constant](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.is_constant)                     | [is_constant/2](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#is_constant/2)     |                                                                                                           |
| [is_empty](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.is_empty)                           | [is_empty/1](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#is_empty/1)           |                                                                                                           |
| [iter](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.iter)                                   | -                                                                                  | note implemented, `Scope` implements the [Enumerable](https://hexdocs.pm/elixir/Enumerable.html) protocol |
| [iter_raw](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.iter_raw)                           | -                                                                                  | not implemented                                                                                           |
| [len](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.len)                                     | [len/1](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#len/1)                     |                                                                                                           |
| [new](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.new)                                     | [new/0](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#new/0)                     |                                                                                                           |
| [pop](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.pop)                                     | [pop/1](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#pop/1)                     |                                                                                                           |
| [push](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.push)                                   | [push/2](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#push/2)                   |                                                                                                           |
| [push_constant](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.push_constant)                 | [push_constant/2](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#push_constant/2) |                                                                                                           |
| [push_constant_dynamic](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.push_constant_dynamic) | -                                                                                  | not implemented, use `push_constant`                                                                      |
| [push_dynamic](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.push_dynamic)                   | -                                                                                  | not implemented, use `push`                                                                               |
| [remove](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.remove)                               | [remove/2](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#remove/2)               |                                                                                                           |
| [rewind](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.rewind)                               | [rewind/2](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#rewind/2)               |                                                                                                           |
| [set_alias](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.set_alias)                         | [set_alias/3](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#set_alias/3)         |                                                                                                           |
| [set_or_push](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.set_or_push)                     | [set_or_push/3](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#set_or_push/3)     |                                                                                                           |
| [set_value](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.set_value)                         | [set_value/3](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#set_value/3)         |                                                                                                           |
| [with_capacity](https://docs.rs/rhai/latest/rhai/struct.Scope.html#method.with_capacity)                 | [with_capacity/1](https://hexdocs.pm/rhai_rustler/Rhai.Scope.html#with_capacity/1) |                                                                                                           |

## AST

| Rust                                                                                                                   | Elixir                                                                                           | Notes                                                     |
| ---------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------ | --------------------------------------------------------- |
| [clear_doc](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.clear_doc)                                         | -                                                                                                | not implemented, metadata feature is not enabled          |
| [clear_functions](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.clear_functions)                             | [clear_functions/1](https://hexdocs.pm/rhai_rustler/Rhai.AST.html#clear_functions/1)             |                                                           |
| [clear_source](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.clear_source)                                   | [clear_source/1](https://hexdocs.pm/rhai_rustler/Rhai.AST.html#clear_source/1)                   |                                                           |
| [clear_statements](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.clear_statements)                           | [clear_statements/1](https://hexdocs.pm/rhai_rustler/Rhai.AST.html#clear_statements/1)           |                                                           |
| [clone_functions_only](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.clone_functions_only)                   | [clone_functions_only/1](https://hexdocs.pm/rhai_rustler/Rhai.AST.html#clone_functions_only/1)   |                                                           |
| [clone_functions_only_filtered](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.clone_functions_only_filtered) | -                                                                                                | calling an Elixir function is not supported at the moment |
| [clone_statements_only](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.clone_statements_only)                 | [clone_statements_only/1](https://hexdocs.pm/rhai_rustler/Rhai.AST.html#clone_statements_only/1) |                                                           |
| [combine](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.combine)                                             | [combine/2](https://hexdocs.pm/rhai_rustler/Rhai.AST.html#combine/2)                             |                                                           |
| [combine_filtered](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.combine_filtered)                           | -                                                                                                | calling an Elixir function is not supported at the moment |
| [doc](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.doc)                                                     | -                                                                                                | not implemented, metadata feature is not enabled          |
| [empty](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.empty)                                                 | [empty/0](https://hexdocs.pm/rhai_rustler/Rhai.AST.html#empty/0)                                 |                                                           |
| [has_functions](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.has_functions)                                 | [has_functions/1](https://hexdocs.pm/rhai_rustler/Rhai.AST.html#has_functions/1)                 |                                                           |
| [iter_fn_def](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.iter_fn_def)                                     | -                                                                                                | internals                                                 |
| [iter_functions](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.iter_functions)                               | -                                                                                                |                                                           |
| [iter_literal_variables](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.iter_literal_variables)               | -                                                                                                |                                                           |
| [lib](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.lib)                                                     | -                                                                                                | deprecated                                                |
| [merge](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.merge)                                                 | [merge/2](https://hexdocs.pm/rhai_rustler/Rhai.AST.html#merge/2)                                 |                                                           |
| [merge_filtered](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.merge_filtered)                               | -                                                                                                | calling an Elixir function is not supported at the moment |
| [new](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.new)                                                     | -                                                                                                | internals                                                 |
| [new_with_source](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.new_with_source)                             | -                                                                                                | internals                                                 |
| [resolver](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.resolver)                                           | -                                                                                                | internals                                                 |
| [retain_functions](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.retain_functions)                           | -                                                                                                | calling an Elixir function is not supported at the moment |
| [set_source](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.set_source)                                       | [set_source/2](https://hexdocs.pm/rhai_rustler/Rhai.AST.html#set_source/2)                       |                                                           |
| [shared_lib](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.shared_lib)                                       | -                                                                                                | internals                                                 |
| [source](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.source)                                               | [source/0](https://hexdocs.pm/rhai_rustler/Rhai.AST.html#source/0)                               |                                                           |
| [statements](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.statements)                                       | -                                                                                                | internals                                                 |
| [walk](https://docs.rs/rhai/latest/rhai/struct.AST.html#method.walk)                                                   | -                                                                                                | internals                                                 |
