--
-- PostgreSQL database dump
--

-- Dumped from database version 15.6 (Debian 15.6-1.pgdg120+2)
-- Dumped by pg_dump version 15.6 (Debian 15.6-1.pgdg120+2)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: trento_eventstore_dev; Type: DATABASE; Schema: -; Owner: postgres
--

CREATE DATABASE trento_eventstore_dev WITH TEMPLATE = template0 ENCODING = 'UTF8' LOCALE_PROVIDER = libc LOCALE = 'en_US.utf8';


ALTER DATABASE trento_eventstore_dev OWNER TO postgres;

\connect trento_eventstore_dev

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: event_store_delete(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.event_store_delete() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
  message text;
BEGIN
  IF current_setting('eventstore.enable_hard_deletes', true) = 'on' OR
    current_setting('eventstore.reset', true) = 'on'
  THEN
    -- Allow DELETE
    RETURN OLD;
  ELSE
    -- Prevent DELETE
    message := 'EventStore: ' || TG_ARGV[0];

    RAISE EXCEPTION USING MESSAGE = message, ERRCODE = 'feature_not_supported';
  END IF;
END;
$$;


ALTER FUNCTION public.event_store_delete() OWNER TO postgres;

--
-- Name: event_store_exception(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.event_store_exception() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
  message text;
BEGIN
  message := 'EventStore: ' || TG_ARGV[0];

  RAISE EXCEPTION USING MESSAGE = message;
END;
$$;


ALTER FUNCTION public.event_store_exception() OWNER TO postgres;

--
-- Name: notify_events(); Type: FUNCTION; Schema: public; Owner: postgres
--

CREATE FUNCTION public.notify_events() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE
  old_stream_version bigint;
  channel text;
  payload text;
BEGIN
    -- Payload text contains:
    --  * `stream_uuid`
    --  * `stream_id`
    --  * first `stream_version`
    --  * last `stream_version`
    -- Each separated by a comma (e.g. 'stream-12345,1,1,5')

    IF TG_OP = 'UPDATE' THEN
      old_stream_version := OLD.stream_version + 1;
    ELSE
      old_stream_version := 1;
    END IF;

    channel := TG_TABLE_SCHEMA || '.events';
    payload := NEW.stream_uuid || ',' || NEW.stream_id || ',' || old_stream_version || ',' || NEW.stream_version;

    -- Notify events to listeners
    PERFORM pg_notify(channel, payload);

    RETURN NULL;
END;
$$;


ALTER FUNCTION public.notify_events() OWNER TO postgres;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: events; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.events (
    event_id uuid NOT NULL,
    event_type text NOT NULL,
    causation_id uuid,
    correlation_id uuid,
    data jsonb NOT NULL,
    metadata jsonb,
    created_at timestamp with time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.events OWNER TO postgres;

--
-- Name: schema_migrations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.schema_migrations (
    major_version integer NOT NULL,
    minor_version integer NOT NULL,
    patch_version integer NOT NULL,
    migrated_at timestamp with time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.schema_migrations OWNER TO postgres;

--
-- Name: snapshots; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.snapshots (
    source_uuid text NOT NULL,
    source_version bigint NOT NULL,
    source_type text NOT NULL,
    data jsonb NOT NULL,
    metadata jsonb,
    created_at timestamp with time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.snapshots OWNER TO postgres;

--
-- Name: stream_events; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.stream_events (
    event_id uuid NOT NULL,
    stream_id bigint NOT NULL,
    stream_version bigint NOT NULL,
    original_stream_id bigint,
    original_stream_version bigint
);


ALTER TABLE public.stream_events OWNER TO postgres;

--
-- Name: streams; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.streams (
    stream_id bigint NOT NULL,
    stream_uuid text NOT NULL,
    stream_version bigint DEFAULT 0 NOT NULL,
    created_at timestamp with time zone DEFAULT now() NOT NULL,
    deleted_at timestamp with time zone
);


ALTER TABLE public.streams OWNER TO postgres;

--
-- Name: streams_stream_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.streams_stream_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.streams_stream_id_seq OWNER TO postgres;

--
-- Name: streams_stream_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.streams_stream_id_seq OWNED BY public.streams.stream_id;


--
-- Name: subscriptions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.subscriptions (
    subscription_id bigint NOT NULL,
    stream_uuid text NOT NULL,
    subscription_name text NOT NULL,
    last_seen bigint,
    created_at timestamp with time zone DEFAULT now() NOT NULL
);


ALTER TABLE public.subscriptions OWNER TO postgres;

--
-- Name: subscriptions_subscription_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.subscriptions_subscription_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.subscriptions_subscription_id_seq OWNER TO postgres;

--
-- Name: subscriptions_subscription_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.subscriptions_subscription_id_seq OWNED BY public.subscriptions.subscription_id;


--
-- Name: streams stream_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.streams ALTER COLUMN stream_id SET DEFAULT nextval('public.streams_stream_id_seq'::regclass);


--
-- Name: subscriptions subscription_id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.subscriptions ALTER COLUMN subscription_id SET DEFAULT nextval('public.subscriptions_subscription_id_seq'::regclass);


--
-- Data for Name: events; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.events (event_id, event_type, causation_id, correlation_id, data, metadata, created_at) FROM stdin;
a4a2fe85-23e6-4f7c-9459-7de33a581232	Elixir.Trento.Hosts.Events.HostRegistered	a2ef6dd8-549a-4516-8ebc-71f248b6e4e8	db294593-802d-4760-8d3a-a3d79adf120c	{"health": null, "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 4, "hostname": "vmhdbdev01", "cpu_count": 4, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.100.1.11", "10.100.1.13"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 32107, "installation_source": "unknown", "fully_qualified_domain_name": "vmhdbdev01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:06:55.595428+00
a460c824-d0a8-4bdc-9460-fa78b4e8191c	Elixir.Trento.Hosts.Events.HostRegistered	dcb1fbf8-1302-4d9f-97d2-23e409afaf2f	0aaec32e-5395-4898-9189-9a065faa47e5	{"health": null, "host_id": "9a26b6d0-6e72-597c-9fe5-152a6875f214", "version": 4, "hostname": "vmiscsi01", "cpu_count": 1, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.80.1.4"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 3421, "installation_source": "unknown", "fully_qualified_domain_name": "vmiscsi01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:06:55.881522+00
4bacb6ea-0608-450b-b3af-fb22c9127325	Elixir.Trento.Hosts.Events.HostRegistered	a41771eb-639d-40ed-aca5-3885bf4644cd	7915b6ff-2d4e-40ff-86cd-08ef9817c8ed	{"health": null, "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 4, "hostname": "vmnwdev03", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.100.1.23", "10.100.1.27"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwdev03.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:06:56.008574+00
7faa0205-02be-430d-b8e4-34ddfb79280c	Elixir.Trento.Hosts.Events.HostRegistered	efe21ec9-dac9-4b6c-abe0-24e96c691341	2c3007f2-ea14-477c-bfef-ecc87b495853	{"health": null, "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 4, "hostname": "vmnwdev04", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.100.1.24", "10.100.1.28"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwdev04.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:06:56.369411+00
e09fd979-c816-4396-8267-add1eec24914	Elixir.Trento.Clusters.Events.ClusterRegistered	4c118b55-74f0-425f-8a7d-4391dc384cb0	7931b185-394a-47fc-91ed-9e750df217d5	{"sid": null, "name": "hana_cluster_3", "type": "unknown", "health": "unknown", "details": null, "version": 1, "provider": "unknown", "cluster_id": "469e7be5-4e20-5007-b044-c6f540a87493", "hosts_number": null, "additional_sids": [], "resources_number": null}	{}	2024-04-09 15:06:57.118788+00
4c4f2485-f8ce-46ec-bb5e-3b0787975761	Elixir.Trento.Clusters.Events.HostAddedToCluster	4c118b55-74f0-425f-8a7d-4391dc384cb0	7931b185-394a-47fc-91ed-9e750df217d5	{"host_id": "b767b3e9-e802-587e-a442-541d093b86b9", "version": 1, "cluster_id": "469e7be5-4e20-5007-b044-c6f540a87493"}	{}	2024-04-09 15:06:57.118798+00
701791de-b9d2-485d-a02a-7b0f85b63eca	Elixir.Trento.Clusters.Events.ClusterRegistered	17bc8263-eaa9-43d6-bcd3-589d3c6fd7b9	5583b2c0-f9fa-48f0-9194-0e2c0f8c6f6c	{"sid": null, "name": "netweaver_cluster", "type": "unknown", "health": "unknown", "details": null, "version": 1, "provider": "unknown", "cluster_id": "0eac831a-aa66-5f45-89a4-007fbd2c5714", "hosts_number": null, "additional_sids": [], "resources_number": null}	{}	2024-04-09 15:06:57.26369+00
6ae44389-074e-4389-862d-edfb5df60992	Elixir.Trento.Clusters.Events.HostAddedToCluster	17bc8263-eaa9-43d6-bcd3-589d3c6fd7b9	5583b2c0-f9fa-48f0-9194-0e2c0f8c6f6c	{"host_id": "4b30a6af-4b52-5bda-bccb-f2248a12c992", "version": 1, "cluster_id": "0eac831a-aa66-5f45-89a4-007fbd2c5714"}	{}	2024-04-09 15:06:57.263714+00
9008a583-6dac-40fa-8831-86ba89166e32	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	d872357d-f67b-46f1-b2f5-3b8bc2a0234e	2f78cd2a-9423-4b90-8800-e8ab0647b9f5	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:06:57.395462+00
d1a04a2e-98af-46a1-92fc-808587be031f	Elixir.Trento.Hosts.Events.HostRegistered	ebc97f19-5523-4c37-8534-2ce5ba72b37b	f8f3386b-307b-439e-8000-d45c0e9e2926	{"health": null, "host_id": "a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12", "version": 4, "hostname": "vmnwprd03", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.80.1.23", "10.80.1.27"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwprd03.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:06:58.427394+00
11865212-87d7-47e4-967f-12c17400a4c6	Elixir.Trento.Clusters.Events.ClusterRegistered	4d49959e-6ea6-438f-8d53-3c468e57bab3	ebe783aa-5e87-43a4-820b-87099a3651eb	{"sid": null, "name": "drbd_cluster", "type": "unknown", "health": "unknown", "details": null, "version": 1, "provider": "azure", "cluster_id": "8a66f8fb-5fe9-51b3-a34c-24321271a4e3", "hosts_number": 2, "additional_sids": [], "resources_number": 9}	{}	2024-04-09 15:06:58.680762+00
8b44c110-ea90-49fc-9637-a75c435d54eb	Elixir.Trento.Clusters.Events.HostAddedToCluster	4d49959e-6ea6-438f-8d53-3c468e57bab3	ebe783aa-5e87-43a4-820b-87099a3651eb	{"host_id": "422686d6-b2d1-5092-93e8-a744854f5085", "version": 1, "cluster_id": "8a66f8fb-5fe9-51b3-a34c-24321271a4e3"}	{}	2024-04-09 15:06:58.680778+00
005397e5-3378-44ba-8911-a4d1f98fad56	Elixir.Trento.Hosts.Events.HostRegistered	131b26c6-349a-4edf-b8c6-be88f9c4cc59	37acc643-8efb-49eb-a7f7-1e05ae5beeec	{"health": null, "host_id": "116d49bd-85e1-5e59-b820-83f66db8800c", "version": 4, "hostname": "vmnwprd01", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.80.1.21", "10.80.1.25"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwprd01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:06:59.021729+00
47ca5cea-7cb1-4fd9-be19-da7d04b7cc61	Elixir.Trento.Clusters.Events.ClusterRegistered	ca2841eb-2fa2-43da-8e9b-62f3c92d62e4	5eefe3c8-71ec-4402-b27f-44ccb3d10da6	{"sid": null, "name": "drbd_cluster", "type": "unknown", "health": "unknown", "details": null, "version": 1, "provider": "azure", "cluster_id": "c7a1e943-bf46-590b-bd26-bfc7c78def97", "hosts_number": 2, "additional_sids": [], "resources_number": 9}	{}	2024-04-09 15:06:59.481793+00
a1643268-6a05-4f08-bdba-a02f0baad9b4	Elixir.Trento.Clusters.Events.HostAddedToCluster	ca2841eb-2fa2-43da-8e9b-62f3c92d62e4	5eefe3c8-71ec-4402-b27f-44ccb3d10da6	{"host_id": "927901fa-2c87-524e-b18c-3ef5187f504f", "version": 1, "cluster_id": "c7a1e943-bf46-590b-bd26-bfc7c78def97"}	{}	2024-04-09 15:06:59.481803+00
b3806400-6aaf-4541-be78-659ca828404e	Elixir.Trento.Clusters.Events.ClusterRegistered	cbbc382e-49c3-4834-aaa5-b1d9fd58b7e7	637ac80d-a0c2-41da-87d0-37525cff4016	{"sid": null, "name": "hana_cluster_1", "type": "unknown", "health": "unknown", "details": null, "version": 1, "provider": "unknown", "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714", "hosts_number": null, "additional_sids": [], "resources_number": null}	{}	2024-04-09 15:06:59.71991+00
f9b6596b-956a-4219-b9e3-650df0ef88e4	Elixir.Trento.Clusters.Events.HostAddedToCluster	cbbc382e-49c3-4834-aaa5-b1d9fd58b7e7	637ac80d-a0c2-41da-87d0-37525cff4016	{"host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1, "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714"}	{}	2024-04-09 15:06:59.71992+00
365eca43-2838-47d8-bfe4-19387b64572f	Elixir.Trento.Hosts.Events.HostRegistered	a427de58-5ce4-473d-825a-4bec970f9da6	e3a41547-e01f-4da9-9677-61842c1b1577	{"health": null, "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 4, "hostname": "vmhdbqas01", "cpu_count": 4, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.90.1.11", "10.90.1.13"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 32107, "installation_source": "unknown", "fully_qualified_domain_name": "vmhdbqas01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:00.221647+00
415a54e4-708e-410c-b138-43ddea394646	Elixir.Trento.Clusters.Events.ClusterRegistered	9c28321a-8fce-4c30-b4e7-bce25c304563	dc97bcf9-db81-4b0a-93bf-fc124442c2ac	{"sid": null, "name": "netweaver_cluster", "type": "ascs_ers", "health": "passing", "details": {"sap_systems": [{"sid": "NWD", "nodes": [{"name": "vmnwdev01", "roles": ["ascs"], "status": "Online", "resources": [{"id": "rsc_ip_NWD_ASCS00", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_fs_NWD_ASCS00", "role": "Started", "type": "ocf::heartbeat:Filesystem", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_sap_NWD_ASCS00", "role": "Started", "type": "ocf::heartbeat:SAPInstance", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_NWD_ASCS00", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {}, "filesystems": ["/usr/sap/NWD/ASCS00"], "virtual_ips": ["10.100.1.25"]}, {"name": "vmnwdev02", "roles": ["ers"], "status": "Online", "resources": [{"id": "rsc_ip_NWD_ERS10", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_fs_NWD_ERS10", "role": "Started", "type": "ocf::heartbeat:Filesystem", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_sap_NWD_ERS10", "role": "Started", "type": "ocf::heartbeat:SAPInstance", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_NWD_ERS10", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"runs_ers_NWD": "1"}, "filesystems": ["/usr/sap/NWD/ERS10"], "virtual_ips": ["10.100.1.26"]}], "distributed": true, "filesystem_resource_based": true}], "sbd_devices": [{"device": "/dev/disk/by-id/scsi-36001405f01eb5f4c5c941e499beb055d", "status": "healthy"}], "fencing_type": "external/sbd", "maintenance_mode": false, "stopped_resources": []}, "version": 1, "provider": "azure", "cluster_id": "5284f376-c1f4-5178-8966-d490df3dab4f", "hosts_number": 2, "additional_sids": ["NWD"], "resources_number": 9}	{}	2024-04-09 15:07:00.091318+00
e7200256-5ca7-4c5e-97f5-351fbd9155b3	Elixir.Trento.Clusters.Events.HostAddedToCluster	9c28321a-8fce-4c30-b4e7-bce25c304563	dc97bcf9-db81-4b0a-93bf-fc124442c2ac	{"host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1, "cluster_id": "5284f376-c1f4-5178-8966-d490df3dab4f"}	{}	2024-04-09 15:07:00.091328+00
dcfe216a-d3a7-4a8a-a738-e60c3ed73f99	Elixir.Trento.Hosts.Events.HostRegistered	327e7189-767a-434d-9377-87134ee59896	fc059b0c-3a08-4645-b741-f58dc9a9a0e3	{"health": null, "host_id": "098fc159-3ed6-58e7-91be-38fda8a833ea", "version": 4, "hostname": "vmnwqas03", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.90.1.27", "10.90.1.23"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwqas03.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:01.718694+00
73c9e97d-f590-411e-8038-7ba9f3d736ce	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	73a5c751-9361-44fd-a5f8-ca960dca56da	6ee4ad08-4580-4c5b-94f4-cd82db0f10cb	{"status": {"staging": {"notes": [], "enabled": false, "solutions_ids": []}, "services": [{"name": "sapconf", "active": null, "enabled": null}, {"name": "saptune", "active": "active", "enabled": "enabled"}, {"name": "tuned", "active": null, "enabled": null}], "tuning_state": "not compliant", "applied_notes": [{"id": "941735", "additionally_enabled": false}, {"id": "1771258", "additionally_enabled": false}, {"id": "2578899", "additionally_enabled": false}, {"id": "2993054", "additionally_enabled": false}, {"id": "1656250", "additionally_enabled": false}, {"id": "900929", "additionally_enabled": false}], "enabled_notes": [{"id": "941735", "additionally_enabled": false}, {"id": "1771258", "additionally_enabled": false}, {"id": "2578899", "additionally_enabled": false}, {"id": "2993054", "additionally_enabled": false}, {"id": "1656250", "additionally_enabled": false}, {"id": "900929", "additionally_enabled": false}], "package_version": "3.1.0", "applied_solution": {"id": "NETWEAVER", "notes": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "partial": false}, "enabled_solution": {"id": "NETWEAVER", "notes": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "partial": false}, "configured_version": "3"}, "host_id": "a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12", "version": 1}	{}	2024-04-09 15:07:02.782353+00
0a5aab8b-5586-4b24-9ed0-bfce5601831c	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	73a5c751-9361-44fd-a5f8-ca960dca56da	6ee4ad08-4580-4c5b-94f4-cd82db0f10cb	{"host_id": "a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:07:02.782364+00
c796a37f-d29c-48a1-bbcf-404c2a2ab46d	Elixir.Trento.Hosts.Events.ProviderUpdated	65c4050d-6641-4799-af7c-e41db47e14bf	ab59eea2-4cc0-4161-baf3-f1160db423a8	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwdev04", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}}	{}	2024-04-09 15:07:03.434347+00
95712dd5-335f-4121-9365-9ea55bc74269	Elixir.Trento.Hosts.Events.ProviderUpdated	7993174a-4665-4468-a786-673d8b0261c4	54d34369-dd4b-409c-b11b-92a8c2d08492	{"host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmhdbqas01", "vm_size": "Standard_E4s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 7}}	{}	2024-04-09 15:07:03.570705+00
6939c71d-dfd1-4da1-a050-775a04667029	Elixir.Trento.SapSystems.Events.DatabaseRegistered	0d067428-1dad-4947-83bc-90fdd1dd36ae	d8dd8d12-1600-49d9-b4c7-5bb995d8644d	{"sid": "HDD", "health": "passing", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c"}	{}	2024-04-09 15:07:05.809246+00
7e4d81cf-356a-4734-a8db-5ab2ac0d5c07	Elixir.Trento.SapSystems.Events.DatabaseInstanceRegistered	0d067428-1dad-4947-83bc-90fdd1dd36ae	d8dd8d12-1600-49d9-b4c7-5bb995d8644d	{"sid": "HDD", "health": "passing", "tenant": "HDD", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "features": "HDB|HDB_WORKER", "http_port": 51013, "https_port": 51014, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "start_priority": "0.3", "instance_number": "10", "instance_hostname": "vmhdbdev01", "system_replication": "Primary", "system_replication_status": "ACTIVE"}	{}	2024-04-09 15:07:05.809255+00
82b7087d-b877-4eb4-8e52-124a42caf1c4	Elixir.Trento.SapSystems.Events.DatabaseRegistered	021cbfe8-4c77-434c-abb9-aabd47194399	0ad69f0e-fc7a-466e-a29a-001ed3af61eb	{"sid": "HDP", "health": "passing", "version": 1, "sap_system_id": "6c9208eb-a5bb-57ef-be5c-6422dedab602"}	{}	2024-04-09 15:07:06.937343+00
f202b991-9795-4056-8acb-3b1f70bee285	Elixir.Trento.SapSystems.Events.DatabaseInstanceRegistered	021cbfe8-4c77-434c-abb9-aabd47194399	0ad69f0e-fc7a-466e-a29a-001ed3af61eb	{"sid": "HDP", "health": "passing", "tenant": "HDP", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": 1, "features": "HDB|HDB_WORKER", "http_port": 51013, "https_port": 51014, "sap_system_id": "6c9208eb-a5bb-57ef-be5c-6422dedab602", "start_priority": "0.3", "instance_number": "10", "instance_hostname": "vmhdbprd01", "system_replication": "Primary", "system_replication_status": "ACTIVE"}	{}	2024-04-09 15:07:06.937351+00
946f8794-261b-421f-b20e-3eb355132332	Elixir.Trento.Clusters.Events.HostAddedToCluster	449a7927-a2a5-4d4c-9777-77d89e22afbd	482b74f1-d3fc-47e4-a8ea-63d145e9590f	{"host_id": "ddcb7992-2ffb-5c10-8b39-80685f6eaaba", "version": 1, "cluster_id": "8a66f8fb-5fe9-51b3-a34c-24321271a4e3"}	{}	2024-04-09 15:07:08.145603+00
4abef3e5-f728-4734-bf5c-4141fdb99b97	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	43641809-8c29-4619-91d1-400f42e9a56d	8b4914ad-6975-4da4-bb31-fda1785a7bb0	{"status": {"staging": null, "services": [], "tuning_state": null, "applied_notes": [], "enabled_notes": [], "package_version": "3.0.0", "applied_solution": null, "enabled_solution": null, "configured_version": null}, "host_id": "422686d6-b2d1-5092-93e8-a744854f5085", "version": 1}	{}	2024-04-09 15:07:08.932814+00
2e0c7a12-a051-48f0-94fa-b0780be8397a	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	43641809-8c29-4619-91d1-400f42e9a56d	8b4914ad-6975-4da4-bb31-fda1785a7bb0	{"host_id": "422686d6-b2d1-5092-93e8-a744854f5085", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:07:08.932827+00
a22c7426-5cfa-4042-a0c9-45f230a43700	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	c37b45ca-9cfa-4587-8a84-311cf2106845	1af738d9-7f06-40c0-901a-ca21be0c20c6	{"status": {"staging": null, "services": [], "tuning_state": null, "applied_notes": [], "enabled_notes": [], "package_version": "3.0.0", "applied_solution": null, "enabled_solution": null, "configured_version": null}, "host_id": "81e9b629-c1e7-538f-bff1-47d3a6580522", "version": 1}	{}	2024-04-09 15:07:14.469759+00
451ced12-7765-4b67-a843-4c81678a8291	Elixir.Trento.Clusters.Events.ClusterRegistered	4ae1dff1-85a3-4c5d-8de3-03d1067c7bc4	579b0bc4-8b2c-4b11-ae62-ba39d99b9a45	{"sid": null, "name": "drbd_cluster", "type": "unknown", "health": "unknown", "details": null, "version": 1, "provider": "unknown", "cluster_id": "6bd7ec60-8cb1-5c6b-a892-29e1fd2f8380", "hosts_number": null, "additional_sids": [], "resources_number": null}	{}	2024-04-09 15:07:00.817054+00
88f285f2-ade4-4322-aac4-70a5dc6502cb	Elixir.Trento.Clusters.Events.HostAddedToCluster	4ae1dff1-85a3-4c5d-8de3-03d1067c7bc4	579b0bc4-8b2c-4b11-ae62-ba39d99b9a45	{"host_id": "240f96b1-8d26-53b7-9e99-ffb0f2e735bf", "version": 1, "cluster_id": "6bd7ec60-8cb1-5c6b-a892-29e1fd2f8380"}	{}	2024-04-09 15:07:00.817066+00
fb56bd31-ab82-4940-b01a-69f9c3e66e0b	Elixir.Trento.Hosts.Events.HostRegistered	4177237e-faff-49c6-a3d4-c31ba4687c73	fc34ef61-7108-4797-a96f-7e6ee13d224d	{"health": null, "host_id": "21de186a-e38f-5804-b643-7f4ef22fecfd", "version": 4, "hostname": "vmdrbddev02", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.100.1.32"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": null}	{}	2024-04-09 15:07:00.938904+00
245a0888-3c76-4136-a3b5-fea63426fa31	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	cfc371af-12d6-4c60-b7da-44be06cb9298	a14e82f7-77f3-4b24-b547-96b50c009125	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:07:01.301953+00
1d6d4e85-c252-432e-82c9-4c2630ebb433	Elixir.Trento.Hosts.Events.ProviderUpdated	8179be6b-854d-4cd7-92aa-3f3c2cfb9f02	5b2bcf08-c8a2-4627-b1d7-d5b787838453	{"host_id": "a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwprd03", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}}	{}	2024-04-09 15:07:01.574366+00
b98199ac-dfbd-4083-81f2-c0c39dfe58a6	Elixir.Trento.Clusters.Events.ClusterRegistered	55041fec-6014-4065-ac1f-ecb664268a84	45412969-9daf-4030-9039-6f531aba33a2	{"sid": null, "name": "netweaver_cluster", "type": "ascs_ers", "health": "passing", "details": {"sap_systems": [{"sid": "NWQ", "nodes": [{"name": "vmnwqas01", "roles": ["ascs"], "status": "Online", "resources": [{"id": "rsc_ip_NWQ_ASCS00", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_fs_NWQ_ASCS00", "role": "Started", "type": "ocf::heartbeat:Filesystem", "status": "Active", "managed": true, "fail_count": 1}, {"id": "rsc_sap_NWQ_ASCS00", "role": "Started", "type": "ocf::heartbeat:SAPInstance", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_NWQ_ASCS00", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {}, "filesystems": ["/usr/sap/NWQ/ASCS00"], "virtual_ips": ["10.90.1.25"]}, {"name": "vmnwqas02", "roles": ["ers"], "status": "Online", "resources": [{"id": "rsc_ip_NWQ_ERS10", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_fs_NWQ_ERS10", "role": "Started", "type": "ocf::heartbeat:Filesystem", "status": "Active", "managed": true, "fail_count": 1}, {"id": "rsc_sap_NWQ_ERS10", "role": "Started", "type": "ocf::heartbeat:SAPInstance", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_NWQ_ERS10", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"runs_ers_NWQ": "1"}, "filesystems": ["/usr/sap/NWQ/ERS10"], "virtual_ips": ["10.90.1.26"]}], "distributed": true, "filesystem_resource_based": true}], "sbd_devices": [{"device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_813ace38-2d4f-48f6-8aa2-5360252ca492", "status": "healthy"}], "fencing_type": "external/sbd", "maintenance_mode": false, "stopped_resources": []}, "version": 1, "provider": "azure", "cluster_id": "fb861bce-d212-56b5-8786-74afd6eb58cb", "hosts_number": 2, "additional_sids": ["NWQ"], "resources_number": 9}	{}	2024-04-09 15:07:02.124896+00
ea6b9206-23b4-4320-a37e-62e6333c69e4	Elixir.Trento.Clusters.Events.HostAddedToCluster	55041fec-6014-4065-ac1f-ecb664268a84	45412969-9daf-4030-9039-6f531aba33a2	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "cluster_id": "fb861bce-d212-56b5-8786-74afd6eb58cb"}	{}	2024-04-09 15:07:02.124915+00
0d639479-98f2-44cf-83e2-03033bdc0a87	Elixir.Trento.Clusters.Events.HostAddedToCluster	b19812ab-b2ad-4ab4-97f2-03b2d569c622	4781ae3e-0f1a-441b-8aa5-4dd973852e79	{"host_id": "21de186a-e38f-5804-b643-7f4ef22fecfd", "version": 1, "cluster_id": "6bd7ec60-8cb1-5c6b-a892-29e1fd2f8380"}	{}	2024-04-09 15:07:02.529237+00
8f070d65-b07b-4391-b13c-9334ca1ca518	Elixir.Trento.Clusters.Events.ClusterDetailsUpdated	b19812ab-b2ad-4ab4-97f2-03b2d569c622	4781ae3e-0f1a-441b-8aa5-4dd973852e79	{"sid": null, "name": "drbd_cluster", "type": "unknown", "details": null, "version": 1, "provider": "azure", "cluster_id": "6bd7ec60-8cb1-5c6b-a892-29e1fd2f8380", "hosts_number": 2, "additional_sids": [], "resources_number": 9}	{}	2024-04-09 15:07:02.529247+00
fefb784a-22e6-4ebd-933a-a4d1a1e7bd3d	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	697bf49e-7fb1-4467-8735-1ecf9c11aad7	0ecaea69-2e67-48af-93f6-4edb4b8571df	{"host_id": "a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:03.047266+00
6853cc76-a193-4bdb-a878-9f826ec7b3d6	Elixir.Trento.Hosts.Events.HostRegistered	3e2885d4-fef2-456a-b614-508b9cd39858	1a9ecf7e-49cf-4bc0-907c-4b159f04f234	{"health": null, "host_id": "422686d6-b2d1-5092-93e8-a744854f5085", "version": 4, "hostname": "vmdrbdqas02", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.90.1.32"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmdrbdqas02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:03.808441+00
61422752-9b41-482a-ac75-788e6bcfeb73	Elixir.Trento.Hosts.Events.HostRegistered	532f7cf4-5413-4958-af5a-b9efde9ac976	fb27b1db-1e03-4076-9dfa-47daf33d1904	{"health": null, "host_id": "4b30a6af-4b52-5bda-bccb-f2248a12c992", "version": 4, "hostname": "vmnwprd02", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.80.1.22", "10.80.1.26"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwprd02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:04.373283+00
35eced1f-db7b-4e1e-81a4-5525e7a56199	Elixir.Trento.Hosts.Events.ProviderUpdated	06f11cca-2a10-41b2-9f3a-79d8a9b9d7cc	2da26031-980e-42b6-9545-cf24bfe5cb05	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmhdbdev01", "vm_size": "Standard_E4s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 7}}	{}	2024-04-09 15:07:04.757807+00
0182e0b4-db1e-4ef5-a330-c300f241fccc	Elixir.Trento.Clusters.Events.HostAddedToCluster	e0566425-993d-4c02-91b4-9b7a13287dad	ff940529-4fbc-401e-9183-51dee8d17311	{"host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1, "cluster_id": "5284f376-c1f4-5178-8966-d490df3dab4f"}	{}	2024-04-09 15:07:01.868476+00
a3e9f936-5d44-4d05-b19d-7beed0dd911a	Elixir.Trento.Hosts.Events.ProviderUpdated	1a9b02e9-b94e-4cbc-bbe7-d2813152a545	a626e8be-8918-4bf5-b1e0-8df255f79b1b	{"host_id": "116d49bd-85e1-5e59-b820-83f66db8800c", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwprd01", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 0}}	{}	2024-04-09 15:07:09.458195+00
135323aa-23e6-498a-b275-430bfbd1689f	Elixir.Trento.Hosts.Events.HostRegistered	0d06396f-729c-4bcc-ada4-35f4427804b6	342bfad0-ad97-43ef-bfa3-a16676f0ba8f	{"health": null, "host_id": "b767b3e9-e802-587e-a442-541d093b86b9", "version": 4, "hostname": "vmhdbprd02", "cpu_count": 4, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.80.1.12"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 32107, "installation_source": "unknown", "fully_qualified_domain_name": "vmhdbprd02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:10.026371+00
4e336802-51c8-4a74-b63a-3e887950cab8	Elixir.Trento.Hosts.Events.ProviderUpdated	85b121cc-f2a5-4bde-9f64-e9266c2a3710	6633f4a5-8ea7-481e-8554-0006142d5435	{"host_id": "a09d9cf3-46c1-505c-8fb8-4b0a71a9114e", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmdrbdprd01", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}}	{}	2024-04-09 15:07:11.465815+00
3c03d194-d73c-4f93-b898-f6d37aa3f3e2	Elixir.Trento.Hosts.Events.HostRegistered	61a3c5a3-cbdf-4085-a02a-24efa582114d	5d32597d-95f6-4549-bf37-f6581659f435	{"health": null, "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 4, "hostname": "vmnwqas01", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.90.1.21", "10.90.1.25"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwqas01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:11.585981+00
019d2480-3153-4be0-8606-dd8f53d81572	Elixir.Trento.SapSystems.Events.DatabaseInstanceRegistered	0d7db05b-a844-49de-a200-e2deb8b80433	9fc472a5-3a3c-4463-99ef-355fa7dd2739	{"sid": "HDD", "health": "passing", "tenant": "HDD", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1, "features": "HDB|HDB_WORKER", "http_port": 51013, "https_port": 51014, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "start_priority": "0.3", "instance_number": "10", "instance_hostname": "vmhdbdev02", "system_replication": "Secondary", "system_replication_status": null}	{}	2024-04-09 15:07:11.709413+00
f12a2585-7831-4dc1-bd2f-c7f7a9d42d4b	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	055afa7f-c679-4924-9fb7-d90f53a87057	7fefb22b-6263-4d9b-87b5-43b48e93f6c4	{"host_id": "9a26b6d0-6e72-597c-9fe5-152a6875f214", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:07:12.241965+00
a8b79302-97d5-4435-aaf5-881e00c58d2b	Elixir.Trento.Hosts.Events.HostRegistered	ed33e800-dbe1-409e-83eb-288bf853102c	499388a9-fc24-4e62-9b31-b3c34e609a35	{"health": null, "host_id": "0fc07435-7ee2-54ca-b0de-fb27ffdc5deb", "version": 4, "hostname": "vmnwprd04", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.80.1.24", "10.80.1.28"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwprd04.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:13.294571+00
aa018240-3ec2-491b-96ce-9a017ed48ec7	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	10ab4c9c-96bb-46a9-9c27-fc65e01cf641	f69773bb-2867-4693-b9ce-e9fe5b7ea229	{"host_id": "f0c808b3-d869-5192-a944-20f66a6a8449", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:07:13.417617+00
84918b3f-3dc9-4f95-adb5-e45ec36100ed	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	f4377720-2a78-4035-8d17-c23b9c2e2e93	ddc18d9f-3614-4b86-b553-dd1af41a8db1	{"sid": "NWP", "health": "passing", "host_id": "116d49bd-85e1-5e59-b820-83f66db8800c", "version": 1, "features": "MESSAGESERVER|ENQUE", "http_port": 50013, "https_port": 50014, "sap_system_id": "6c9208eb-a5bb-57ef-be5c-6422dedab602", "start_priority": "1", "instance_number": "00", "instance_hostname": "sapnwpas"}	{}	2024-04-09 15:07:13.543943+00
cf1e0ab5-58d8-4972-9e06-21ce3db2a370	Elixir.Trento.SapSystems.Events.SapSystemRegistered	f4377720-2a78-4035-8d17-c23b9c2e2e93	ddc18d9f-3614-4b86-b553-dd1af41a8db1	{"sid": "NWP", "health": "passing", "tenant": "HDP", "db_host": "10.80.1.13", "version": 1, "ensa_version": "ensa1", "sap_system_id": "6c9208eb-a5bb-57ef-be5c-6422dedab602"}	{}	2024-04-09 15:07:13.54395+00
fdd798d7-dd62-485a-8630-88aa62076daa	Elixir.Trento.Hosts.Events.HostRegistered	6163c31a-9fa6-427b-b49b-011ffb65c89e	8a233da1-8685-4ff5-b6b9-f6acc5deea85	{"health": null, "host_id": "81e9b629-c1e7-538f-bff1-47d3a6580522", "version": 4, "hostname": "vmnwqas04", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.90.1.28", "10.90.1.24"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwqas04.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:13.799842+00
67dcc925-3e7d-46df-924b-57b12fe0d770	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	b585f063-4a49-4af6-a264-bcba4c86c5b1	5cda721a-a006-46b8-8512-1e1cce280674	{"status": {"staging": {"notes": [], "enabled": false, "solutions_ids": []}, "services": [{"name": "sapconf", "active": null, "enabled": null}, {"name": "saptune", "active": "active", "enabled": "enabled"}, {"name": "tuned", "active": null, "enabled": null}], "tuning_state": "compliant", "applied_notes": [{"id": "941735", "additionally_enabled": false}, {"id": "1771258", "additionally_enabled": false}, {"id": "1868829", "additionally_enabled": false}, {"id": "1980196", "additionally_enabled": false}, {"id": "2578899", "additionally_enabled": false}, {"id": "2684254", "additionally_enabled": false}, {"id": "2382421", "additionally_enabled": false}, {"id": "2534844", "additionally_enabled": false}, {"id": "2993054", "additionally_enabled": false}, {"id": "1656250", "additionally_enabled": false}], "enabled_notes": [{"id": "941735", "additionally_enabled": false}, {"id": "1771258", "additionally_enabled": false}, {"id": "1868829", "additionally_enabled": false}, {"id": "1980196", "additionally_enabled": false}, {"id": "2578899", "additionally_enabled": false}, {"id": "2684254", "additionally_enabled": false}, {"id": "2382421", "additionally_enabled": false}, {"id": "2534844", "additionally_enabled": false}, {"id": "2993054", "additionally_enabled": false}, {"id": "1656250", "additionally_enabled": false}], "package_version": "3.1.0", "applied_solution": {"id": "HANA", "notes": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "partial": false}, "enabled_solution": {"id": "HANA", "notes": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "partial": false}, "configured_version": "3"}, "host_id": "b767b3e9-e802-587e-a442-541d093b86b9", "version": 1}	{}	2024-04-09 15:07:14.073449+00
89640bb7-bb3e-4cd8-b0a8-240f37f5abe2	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	b585f063-4a49-4af6-a264-bcba4c86c5b1	5cda721a-a006-46b8-8512-1e1cce280674	{"host_id": "b767b3e9-e802-587e-a442-541d093b86b9", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:07:14.073456+00
a703a933-7a33-47c5-acd5-4411a00d4d99	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	c37b45ca-9cfa-4587-8a84-311cf2106845	1af738d9-7f06-40c0-901a-ca21be0c20c6	{"host_id": "81e9b629-c1e7-538f-bff1-47d3a6580522", "version": 1, "saptune_health": "warning"}	{}	2024-04-09 15:07:14.469766+00
27783f73-5ed3-46dc-8910-fa4ab3663b6d	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	db31af28-d46a-4c15-a2f5-72fb89e23c9c	ce46448a-5ad7-4757-8d61-efb27026fe51	{"sid": "NWQ", "health": "passing", "host_id": "3711ea88-9ccc-5b07-8f9d-042be449d72b", "version": 1, "features": "ENQREP", "http_port": 51013, "https_port": 51014, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "start_priority": "0.5", "instance_number": "10", "instance_hostname": "sapnwqer"}	{}	2024-04-09 15:07:14.743354+00
acf18974-9866-422f-b698-f81b80653c90	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	a7194e2f-215c-422d-b773-2702e18c4a24	ba143c51-163e-4b59-a92d-592dd8e9f92a	{"status": {"staging": null, "services": [], "tuning_state": null, "applied_notes": [], "enabled_notes": [], "package_version": "3.0.0", "applied_solution": null, "enabled_solution": null, "configured_version": null}, "host_id": "098fc159-3ed6-58e7-91be-38fda8a833ea", "version": 1}	{}	2024-04-09 15:07:15.664348+00
b288a55a-aa7f-457d-885d-4d9a36e83060	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	a7194e2f-215c-422d-b773-2702e18c4a24	ba143c51-163e-4b59-a92d-592dd8e9f92a	{"host_id": "098fc159-3ed6-58e7-91be-38fda8a833ea", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:07:15.664355+00
33afa053-6e3f-45db-8e65-f08f04d7bf4e	Elixir.Trento.Clusters.Events.ClusterRegistered	c4671ce2-6b03-42c4-8a20-7364fa793afe	3ed34fd9-7f39-4d02-b116-a10e1d634ce8	{"sid": null, "name": "hana_cluster_2", "type": "unknown", "health": "unknown", "details": null, "version": 1, "provider": "unknown", "cluster_id": "fa0d74a3-9240-5d9e-99fa-61c4137acf81", "hosts_number": null, "additional_sids": [], "resources_number": null}	{}	2024-04-09 15:07:02.39181+00
b3773ca8-054c-45de-a883-6e409b547d88	Elixir.Trento.Clusters.Events.HostAddedToCluster	c4671ce2-6b03-42c4-8a20-7364fa793afe	3ed34fd9-7f39-4d02-b116-a10e1d634ce8	{"host_id": "e0c182db-32ff-55c6-a9eb-2b82dd21bc8b", "version": 1, "cluster_id": "fa0d74a3-9240-5d9e-99fa-61c4137acf81"}	{}	2024-04-09 15:07:02.39185+00
53f26459-c0b8-4439-9ead-285d9609ae48	Elixir.Trento.Hosts.Events.HostRegistered	5a40f37c-a705-49d5-b0b7-b738af2502a4	fcfe0a4c-30d4-48ae-8edd-d3f76804bb87	{"health": null, "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": 4, "hostname": "vmhdbprd01", "cpu_count": 4, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.80.1.11", "10.80.1.13"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 32107, "installation_source": "unknown", "fully_qualified_domain_name": "vmhdbprd01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:03.937628+00
4229ba10-3fea-4bc3-b72b-c6210f2b2990	Elixir.Trento.Clusters.Events.HostAddedToCluster	3ab26f27-aa2a-4423-8ec4-533d4738139d	1fb274c2-f832-4922-aea2-ace5ff89855e	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714"}	{}	2024-04-09 15:07:04.211117+00
e7dac3b2-5316-4f12-a428-ba0e206474ae	Elixir.Trento.Clusters.Events.ClusterDetailsUpdated	3ab26f27-aa2a-4423-8ec4-533d4738139d	1fb274c2-f832-4922-aea2-ace5ff89855e	{"sid": "HDD", "name": "hana_cluster_1", "type": "hana_scale_up", "details": {"nodes": [{"name": "vmhdbdev01", "site": "NBG", "status": "Online", "resources": [{"id": "stonith-sbd", "role": "Started", "type": "stonith:external/sbd", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHanaTopology_HDD_HDB10", "role": "Started", "type": "ocf::suse:SAPHanaTopology", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"lpa_hdd_lpt": "10", "hana_hdd_site": "NBG", "hana_hdd_roles": "1:P:master1::worker:", "hana_hdd_vhost": "vmhdbdev01", "hana_hdd_srmode": "sync", "hana_hdd_op_mode": "logreplay", "hana_hdd_version": "2.00.057.00.1629894416", "hana_hdd_remoteHost": "vmhdbdev02", "hana_hdd_sync_state": "SFAIL", "hana_hdd_clone_state": "UNDEFINED", "master-rsc_SAPHana_HDD_HDB10": "-9000"}, "virtual_ip": null, "hana_status": "Failed", "nameserver_actual_role": null, "indexserver_actual_role": null}, {"name": "vmhdbdev02", "site": "WDF", "status": "Online", "resources": [{"id": "rsc_SAPHana_HDD_HDB10", "role": "Master", "type": "ocf::suse:SAPHana", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHanaTopology_HDD_HDB10", "role": "Started", "type": "ocf::suse:SAPHanaTopology", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_ip_HDD_HDB10", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_HDD_HDB10", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"lpa_hdd_lpt": "1643125026", "hana_hdd_site": "WDF", "hana_hdd_roles": "4:P:master1:master:worker:master", "hana_hdd_vhost": "vmhdbdev02", "hana_hdd_srmode": "sync", "hana_hdd_op_mode": "logreplay", "hana_hdd_version": "2.00.057.00.1629894416", "hana_hdd_remoteHost": "vmhdbdev01", "hana_hdd_sync_state": "PRIM", "hana_hdd_clone_state": "PROMOTED", "master-rsc_SAPHana_HDD_HDB10": "150"}, "virtual_ip": "10.100.1.13", "hana_status": "Primary", "nameserver_actual_role": "master", "indexserver_actual_role": "master"}], "sites": [{"name": "NBG", "state": "Failed", "sr_health_state": "1"}, {"name": "WDF", "state": "Primary", "sr_health_state": "4"}], "sbd_devices": [{"device": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:182cb1b1-a815-4b82-b538-7a166b9bbb4a", "status": "healthy"}], "fencing_type": "external/sbd", "sr_health_state": "1", "maintenance_mode": false, "stopped_resources": [{"id": "rsc_SAPHana_HDD_HDB10", "role": "Stopped", "type": "ocf::suse:SAPHana", "status": null, "managed": null, "fail_count": null}], "secondary_sync_state": "SFAIL", "system_replication_mode": "sync", "system_replication_operation_mode": "logreplay"}, "version": 1, "provider": "azure", "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714", "hosts_number": 2, "additional_sids": [], "resources_number": 7}	{}	2024-04-09 15:07:04.211132+00
e46a6aac-671a-4453-b336-e846c8c76d4f	Elixir.Trento.Clusters.Events.ClusterDiscoveredHealthChanged	3ab26f27-aa2a-4423-8ec4-533d4738139d	1fb274c2-f832-4922-aea2-ace5ff89855e	{"version": 1, "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714", "discovered_health": "critical"}	{}	2024-04-09 15:07:04.211135+00
f4dca10c-2815-4217-bd3d-fab4e5840c18	Elixir.Trento.Clusters.Events.ClusterHealthChanged	3ab26f27-aa2a-4423-8ec4-533d4738139d	1fb274c2-f832-4922-aea2-ace5ff89855e	{"health": "critical", "version": 1, "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714"}	{}	2024-04-09 15:07:04.211136+00
b80b5bcd-6acb-4adb-bd73-a7b58d703923	Elixir.Trento.Hosts.Events.HostRegistered	3f0cf39d-41af-4c72-8b4c-52283d4aeeb7	1e563ebc-49e9-467e-8630-f727cd24f7b9	{"health": null, "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 4, "hostname": "vmhdbdev02", "cpu_count": 4, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.100.1.12"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 32107, "installation_source": "unknown", "fully_qualified_domain_name": "vmhdbdev02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:05.281949+00
ddbeeff3-8609-4163-940a-097a62db2729	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	0e9e973a-a007-4f12-a088-39d77ad48e65	c665cc0e-5b5a-4769-9900-b64e0684aae8	{"host_id": "a09d9cf3-46c1-505c-8fb8-4b0a71a9114e", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "a09d9cf3-46c1-505c-8fb8-4b0a71a9114e", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "a09d9cf3-46c1-505c-8fb8-4b0a71a9114e", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "a09d9cf3-46c1-505c-8fb8-4b0a71a9114e", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "a09d9cf3-46c1-505c-8fb8-4b0a71a9114e", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "a09d9cf3-46c1-505c-8fb8-4b0a71a9114e", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "a09d9cf3-46c1-505c-8fb8-4b0a71a9114e", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "a09d9cf3-46c1-505c-8fb8-4b0a71a9114e", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:07.53049+00
6e1e6f03-b25b-4c2d-a233-bdeebd2e5434	Elixir.Trento.Hosts.Events.HostRegistered	7d7ca51f-5a72-40dd-850a-a5d91be550c4	71d01062-9e0c-4cd9-870c-00731e957c54	{"health": null, "host_id": "927901fa-2c87-524e-b18c-3ef5187f504f", "version": 4, "hostname": "vmdrbdprd02", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.80.1.32"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmdrbdprd02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:08.41588+00
8c626e13-fd84-4d0f-ac81-a7b90e1073e0	Elixir.Trento.Hosts.Events.HostRegistered	3ba2053f-521e-48bb-81c3-7de61932bf6b	8c9a5433-ee58-4e59-ab4b-683dea68bfa2	{"health": null, "host_id": "3711ea88-9ccc-5b07-8f9d-042be449d72b", "version": 4, "hostname": "vmnwqas02", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.90.1.22", "10.90.1.26"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwqas02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:09.070425+00
bf5837db-a9c2-4973-9d24-5ace518d9a64	Elixir.Trento.SapSystems.Events.DatabaseRegistered	63ac4507-4aeb-434f-a669-f20783479ae4	b59f2c97-7925-4531-abd2-b4557bbc2722	{"sid": "HDQ", "health": "passing", "version": 1, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff"}	{}	2024-04-09 15:07:09.897493+00
dbc33cf0-e555-4919-bbc3-881d7a008b41	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	f6b0c3e7-ed7e-4567-840a-ee28eec1bdbc	2d69b77c-e92e-4726-bd17-294a290e37bc	{"host_id": "3711ea88-9ccc-5b07-8f9d-042be449d72b", "version": 1, "saptune_health": "warning"}	{}	2024-04-09 15:07:21.4409+00
fa9dd9af-f858-403d-817f-b61ec785b35f	Elixir.Trento.Clusters.Events.HostAddedToCluster	f9385a83-ab14-4810-bde0-8f91a76a9e75	623a63d1-7c2b-492e-a3dd-1b5a2ae5fa9a	{"host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": 1, "cluster_id": "469e7be5-4e20-5007-b044-c6f540a87493"}	{}	2024-04-09 15:07:05.131349+00
add5a929-a421-4ba7-bde1-7a379e5b9b10	Elixir.Trento.Clusters.Events.ClusterDetailsUpdated	f9385a83-ab14-4810-bde0-8f91a76a9e75	623a63d1-7c2b-492e-a3dd-1b5a2ae5fa9a	{"sid": "HDP", "name": "hana_cluster_3", "type": "hana_scale_up", "details": {"nodes": [{"name": "vmhdbprd01", "site": "NBG", "status": "Online", "resources": [{"id": "stonith-sbd", "role": "Started", "type": "stonith:external/sbd", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHana_HDP_HDB10", "role": "Master", "type": "ocf::suse:SAPHana", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHanaTopology_HDP_HDB10", "role": "Started", "type": "ocf::suse:SAPHanaTopology", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_ip_HDP_HDB10", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_HDP_HDB10", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"lpa_hdp_lpt": "1643125019", "hana_hdp_site": "NBG", "hana_hdp_roles": "4:P:master1:master:worker:master", "hana_hdp_vhost": "vmhdbprd01", "hana_hdp_srmode": "sync", "hana_hdp_op_mode": "logreplay", "hana_hdp_version": "2.00.057.00.1629894416", "hana_hdp_remoteHost": "vmhdbprd02", "hana_hdp_sync_state": "PRIM", "hana_hdp_clone_state": "PROMOTED", "master-rsc_SAPHana_HDP_HDB10": "150"}, "virtual_ip": "10.80.1.13", "hana_status": "Primary", "nameserver_actual_role": "master", "indexserver_actual_role": "master"}, {"name": "vmhdbprd02", "site": "WDF", "status": "Online", "resources": [{"id": "rsc_SAPHana_HDP_HDB10", "role": "Slave", "type": "ocf::suse:SAPHana", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHanaTopology_HDP_HDB10", "role": "Started", "type": "ocf::suse:SAPHanaTopology", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"lpa_hdp_lpt": "30", "hana_hdp_site": "WDF", "hana_hdp_roles": "4:S:master1:master:worker:master", "hana_hdp_vhost": "vmhdbprd02", "hana_hdp_srmode": "sync", "hana_hdp_op_mode": "logreplay", "hana_hdp_version": "2.00.057.00.1629894416", "hana_hdp_remoteHost": "vmhdbprd01", "hana_hdp_sync_state": "SOK", "hana_hdp_clone_state": "DEMOTED", "master-rsc_SAPHana_HDP_HDB10": "100"}, "virtual_ip": null, "hana_status": "Secondary", "nameserver_actual_role": "master", "indexserver_actual_role": "master"}], "sites": [{"name": "NBG", "state": "Primary", "sr_health_state": "4"}, {"name": "WDF", "state": "Secondary", "sr_health_state": "4"}], "sbd_devices": [{"device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b924e77", "status": "healthy"}, {"device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b912345", "status": "unhealthy"}, {"device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b954321", "status": "unknown"}], "fencing_type": "external/sbd", "sr_health_state": "4", "maintenance_mode": false, "stopped_resources": [], "secondary_sync_state": "SOK", "system_replication_mode": "sync", "system_replication_operation_mode": "logreplay"}, "version": 1, "provider": "azure", "cluster_id": "469e7be5-4e20-5007-b044-c6f540a87493", "hosts_number": 2, "additional_sids": [], "resources_number": 7}	{}	2024-04-09 15:07:05.131358+00
06b40fe6-8e30-4845-bf37-e650c11b3a88	Elixir.Trento.Clusters.Events.ClusterDiscoveredHealthChanged	f9385a83-ab14-4810-bde0-8f91a76a9e75	623a63d1-7c2b-492e-a3dd-1b5a2ae5fa9a	{"version": 1, "cluster_id": "469e7be5-4e20-5007-b044-c6f540a87493", "discovered_health": "passing"}	{}	2024-04-09 15:07:05.131361+00
d2b059bc-4833-44ce-906d-da647faa4cfa	Elixir.Trento.Clusters.Events.ClusterHealthChanged	f9385a83-ab14-4810-bde0-8f91a76a9e75	623a63d1-7c2b-492e-a3dd-1b5a2ae5fa9a	{"health": "passing", "version": 1, "cluster_id": "469e7be5-4e20-5007-b044-c6f540a87493"}	{}	2024-04-09 15:07:05.131363+00
8571ace6-d7b9-4d22-8d50-5252ad67a210	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	aba4620d-f53f-4593-80ce-1ba4dcc2de8c	964bdeaa-a805-42d0-a8b4-9c9919cb9d32	{"host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:07:07.808381+00
5d9e69ab-de22-494b-83e6-6424623a7391	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	55cc67ab-b2bc-479e-9000-ecff1fb21dc1	a1691062-7729-445f-ae45-83d38ca17ed9	{"host_id": "21de186a-e38f-5804-b643-7f4ef22fecfd", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "21de186a-e38f-5804-b643-7f4ef22fecfd", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "21de186a-e38f-5804-b643-7f4ef22fecfd", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "21de186a-e38f-5804-b643-7f4ef22fecfd", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "21de186a-e38f-5804-b643-7f4ef22fecfd", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "21de186a-e38f-5804-b643-7f4ef22fecfd", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "21de186a-e38f-5804-b643-7f4ef22fecfd", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "21de186a-e38f-5804-b643-7f4ef22fecfd", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:08.27762+00
7dd77b69-ccf9-4cea-b3bb-3f1d656ac8cc	Elixir.Trento.Clusters.Events.HostAddedToCluster	0daae9cd-1732-4cea-9dfe-cbbbb8943774	c0d1d383-07b5-4ec1-95da-7bed62d205fa	{"host_id": "116d49bd-85e1-5e59-b820-83f66db8800c", "version": 1, "cluster_id": "0eac831a-aa66-5f45-89a4-007fbd2c5714"}	{}	2024-04-09 15:07:08.800717+00
3d81c2d7-06c7-4283-8be6-62f0f61516e1	Elixir.Trento.Clusters.Events.ClusterDetailsUpdated	0daae9cd-1732-4cea-9dfe-cbbbb8943774	c0d1d383-07b5-4ec1-95da-7bed62d205fa	{"sid": null, "name": "netweaver_cluster", "type": "ascs_ers", "details": {"sap_systems": [{"sid": "NWP", "nodes": [{"name": "vmnwprd01", "roles": ["ascs"], "status": "Online", "resources": [{"id": "rsc_ip_NWP_ASCS00", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_fs_NWP_ASCS00", "role": "Started", "type": "ocf::heartbeat:Filesystem", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_sap_NWP_ASCS00", "role": "Started", "type": "ocf::heartbeat:SAPInstance", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_NWP_ASCS00", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {}, "filesystems": ["/usr/sap/NWP/ASCS00"], "virtual_ips": ["10.80.1.25"]}, {"name": "vmnwprd02", "roles": ["ers"], "status": "Online", "resources": [{"id": "rsc_ip_NWP_ERS10", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_fs_NWP_ERS10", "role": "Started", "type": "ocf::heartbeat:Filesystem", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_sap_NWP_ERS10", "role": "Started", "type": "ocf::heartbeat:SAPInstance", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_NWP_ERS10", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"runs_ers_NWP": "1"}, "filesystems": ["/usr/sap/NWP/ERS10"], "virtual_ips": ["10.80.1.26"]}], "distributed": true, "filesystem_resource_based": true}], "sbd_devices": [{"device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_e34218cd-0d9a-4b21-b6d5-a313980baa82", "status": "healthy"}], "fencing_type": "external/sbd", "maintenance_mode": false, "stopped_resources": []}, "version": 1, "provider": "azure", "cluster_id": "0eac831a-aa66-5f45-89a4-007fbd2c5714", "hosts_number": 2, "additional_sids": ["NWP"], "resources_number": 9}	{}	2024-04-09 15:07:08.800727+00
93a63871-a7c4-424d-91a6-6fc728a4ece2	Elixir.Trento.Clusters.Events.ClusterDiscoveredHealthChanged	0daae9cd-1732-4cea-9dfe-cbbbb8943774	c0d1d383-07b5-4ec1-95da-7bed62d205fa	{"version": 1, "cluster_id": "0eac831a-aa66-5f45-89a4-007fbd2c5714", "discovered_health": "passing"}	{}	2024-04-09 15:07:08.80073+00
df435fdd-45f4-47da-bf86-c14407e5e706	Elixir.Trento.Clusters.Events.ClusterHealthChanged	0daae9cd-1732-4cea-9dfe-cbbbb8943774	c0d1d383-07b5-4ec1-95da-7bed62d205fa	{"health": "passing", "version": 1, "cluster_id": "0eac831a-aa66-5f45-89a4-007fbd2c5714"}	{}	2024-04-09 15:07:08.800732+00
ee58cff4-2a79-41df-b122-cec9aafa713b	Elixir.Trento.Hosts.Events.HostRegistered	1c8fe5a0-2969-408e-b889-8fcaf1ac7d38	adaee07b-d75e-4ce3-a3b0-dc7fd3029e65	{"health": null, "host_id": "ddcb7992-2ffb-5c10-8b39-80685f6eaaba", "version": 4, "hostname": "vmdrbdqas01", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.90.1.31", "10.90.1.33"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmdrbdqas01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:09.597746+00
f17b8529-1305-4a20-bd95-ad72c24e4350	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	c3cfa8dc-be22-41b5-965f-703c590a12f7	ac0a40ae-f148-4fae-be68-b30f857975a3	{"sid": "NWP", "health": "passing", "host_id": "0fc07435-7ee2-54ca-b0de-fb27ffdc5deb", "version": 1, "features": "ABAP|GATEWAY|ICMAN|IGS", "http_port": 50213, "https_port": 50214, "sap_system_id": "6c9208eb-a5bb-57ef-be5c-6422dedab602", "start_priority": "3", "instance_number": "02", "instance_hostname": "sapnwpaas1"}	{}	2024-04-09 15:07:10.273961+00
b961a930-8fd7-40af-95d2-48e6d4a71d41	Elixir.Trento.Hosts.Events.SoftwareUpdatesDiscoveryCleared	5e0872db-7d51-433b-aaa1-eed11fe3bd5e	d5c4deba-6737-4fbb-b3a5-a5336986ffde	{"host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1}	{}	2024-04-09 15:07:47.289175+00
fb1708f9-d7b9-4199-a828-bb969d67eebc	Elixir.Trento.Hosts.Events.HostRegistered	a09e0184-9759-491d-92f3-0abfdb1923dc	3a63708d-816e-44e4-83dd-e2aeddb144be	{"health": null, "host_id": "69f4dcbb-efa2-5a16-8bc8-01df7dbb7384", "version": 4, "hostname": "vmiscsi01", "cpu_count": 1, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.100.1.4"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 3421, "installation_source": "unknown", "fully_qualified_domain_name": "vmiscsi01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:05.420615+00
cfab4e33-ecf0-4fa2-91ca-5d5027dde96e	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	562ca855-9ac6-4d2f-b3b4-e0bfe4f0b7a2	b2b77571-ae1f-417d-ac4d-2b4854f2edf8	{"host_id": "69f4dcbb-efa2-5a16-8bc8-01df7dbb7384", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "69f4dcbb-efa2-5a16-8bc8-01df7dbb7384", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "69f4dcbb-efa2-5a16-8bc8-01df7dbb7384", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "69f4dcbb-efa2-5a16-8bc8-01df7dbb7384", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "69f4dcbb-efa2-5a16-8bc8-01df7dbb7384", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "69f4dcbb-efa2-5a16-8bc8-01df7dbb7384", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "69f4dcbb-efa2-5a16-8bc8-01df7dbb7384", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "69f4dcbb-efa2-5a16-8bc8-01df7dbb7384", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:05.662866+00
3e7f232b-fedd-4201-a331-1716afc60128	Elixir.Trento.Hosts.Events.ProviderUpdated	12df1e33-0b80-4437-90ee-b9cc3e5beb20	cf65fed8-e60c-49b1-9d96-3b2951965400	{"host_id": "69f4dcbb-efa2-5a16-8bc8-01df7dbb7384", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmiscsi01", "vm_size": "Standard_DS1_v2", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}}	{}	2024-04-09 15:07:06.428855+00
110cc0b8-ed10-4816-bc62-7602d876c235	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	b5b5db44-f1b2-4d67-b1d6-6166e081380e	8cc7eb83-44bc-4f64-9e35-ec3b1d825164	{"host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:06.561715+00
1b469bfe-b6ab-49dc-9814-a919f3efad08	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	19031ffd-dd05-4307-960c-2a747ad1f555	44eb9832-6ff2-4653-a561-f70f6bee523e	{"status": {"staging": null, "services": [], "tuning_state": null, "applied_notes": [], "enabled_notes": [], "package_version": "3.0.0", "applied_solution": null, "enabled_solution": null, "configured_version": null}, "host_id": "21de186a-e38f-5804-b643-7f4ef22fecfd", "version": 1}	{}	2024-04-09 15:07:07.067338+00
f15f31db-23dd-46c4-9b02-0f1ee0a493d7	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	19031ffd-dd05-4307-960c-2a747ad1f555	44eb9832-6ff2-4653-a561-f70f6bee523e	{"host_id": "21de186a-e38f-5804-b643-7f4ef22fecfd", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:07:07.067347+00
257d6913-9b20-44a7-baf7-b6b90c106f1e	Elixir.Trento.Hosts.Events.HostRegistered	1a398ddd-1a05-4403-921d-f2b7425359f2	7de06b38-6fab-4472-8d03-0aaf2c781d15	{"health": null, "host_id": "a09d9cf3-46c1-505c-8fb8-4b0a71a9114e", "version": 4, "hostname": "vmdrbdprd01", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.80.1.31", "10.80.1.33"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmdrbdprd01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:07.198996+00
4087611f-634a-4c19-bcce-5f3b2974685c	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	a8115c94-82e3-4699-820f-2e1ac6001d0e	02ab418a-16e8-4293-bde1-4bbef6ec9139	{"sid": "NWD", "health": "passing", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "features": "ABAP|GATEWAY|ICMAN|IGS", "http_port": 50113, "https_port": 50114, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "start_priority": "3", "instance_number": "01", "instance_hostname": "sapnwdpas"}	{}	2024-04-09 15:07:07.338203+00
c390bcd9-c572-4927-95f1-e5afd9f2ab6c	Elixir.Trento.SapSystems.Events.DatabaseInstanceRegistered	63ac4507-4aeb-434f-a669-f20783479ae4	b59f2c97-7925-4531-abd2-b4557bbc2722	{"sid": "HDQ", "health": "passing", "tenant": "HDQ", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1, "features": "HDB|HDB_WORKER", "http_port": 51013, "https_port": 51014, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "start_priority": "0.3", "instance_number": "10", "instance_hostname": "vmhdbqas01", "system_replication": "Primary", "system_replication_status": "ACTIVE"}	{}	2024-04-09 15:07:09.897503+00
2a016def-a844-402a-b4eb-45f4487fbf9c	Elixir.Trento.Hosts.Events.ProviderUpdated	a69673c1-2762-4f0d-a221-f06f092c7032	455178cf-cbe6-4141-9d4f-5fb790e50917	{"host_id": "422686d6-b2d1-5092-93e8-a744854f5085", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmdrbdqas02", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}}	{}	2024-04-09 15:07:15.796874+00
715693ad-0af0-4b7c-83b6-5892ea464577	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	ec63f831-7b6e-4318-8ae7-22cbf6e54312	9f17f736-c979-40e3-b922-b0d9c8bd4523	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:07.67573+00
af286f2c-8e15-477c-9edc-5d355c7c35c5	Elixir.Trento.Clusters.Events.HostAddedToCluster	ae6f2056-3894-4850-810a-1802a97bbfb3	fdd30132-90bd-45ed-b2bc-fbad6a5c87c0	{"host_id": "3711ea88-9ccc-5b07-8f9d-042be449d72b", "version": 1, "cluster_id": "fb861bce-d212-56b5-8786-74afd6eb58cb"}	{}	2024-04-09 15:07:11.201605+00
3bc02323-1104-4023-8ed4-110bfbd6f2dc	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	aa9cb97b-4612-4271-b153-463de90c40ec	b9ada5ca-8ecc-40ad-946c-3f658346c269	{"host_id": "69f4dcbb-efa2-5a16-8bc8-01df7dbb7384", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:07:11.985531+00
4a9ef8a8-fb9e-47b5-bc2c-f5eafc66ba75	Elixir.Trento.Hosts.Events.ProviderUpdated	5bad8e9c-3a0d-4575-a74e-b468a6052868	43931d28-10e2-45a2-bc0a-c981334b84e9	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwdev03", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}}	{}	2024-04-09 15:07:13.943781+00
0b36464b-60df-4b6c-bb02-ae00eecffcd1	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	fcf333ab-a2cd-4194-a8fd-5c61cb29cbf1	0bcbabb1-dfd8-44be-92d4-9a1aa92e894b	{"sid": "NWQ", "health": "passing", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "features": "MESSAGESERVER|ENQUE", "http_port": 50013, "https_port": 50014, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "start_priority": "1", "instance_number": "00", "instance_hostname": "sapnwqas"}	{}	2024-04-09 15:07:14.872238+00
d7d7a5e1-4408-4cfb-a631-1b7d1255ad42	Elixir.Trento.SapSystems.Events.SapSystemRegistered	fcf333ab-a2cd-4194-a8fd-5c61cb29cbf1	0bcbabb1-dfd8-44be-92d4-9a1aa92e894b	{"sid": "NWQ", "health": "passing", "tenant": "HDQ", "db_host": "10.90.1.13", "version": 1, "ensa_version": "ensa1", "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff"}	{}	2024-04-09 15:07:14.872245+00
4eb15e2c-c24c-405d-9622-dffb4eb985d1	Elixir.Trento.Hosts.Events.ProviderUpdated	15031e5b-e009-49d1-ab9f-d084f5bc6c22	a3f28866-4fb8-42fc-a084-477c8cdb8dac	{"host_id": "0fc07435-7ee2-54ca-b0de-fb27ffdc5deb", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwprd04", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}}	{}	2024-04-09 15:07:15.344563+00
11696139-3107-4fb3-9aa0-58a531de3f55	Elixir.Trento.Hosts.Events.ProviderUpdated	f07dcc82-1d14-4aa3-a630-526aa1ec800c	512a9397-d92e-4897-ae22-fd887ca49465	{"host_id": "ddcb7992-2ffb-5c10-8b39-80685f6eaaba", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmdrbdqas01", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}}	{}	2024-04-09 15:07:16.062413+00
bf6de04a-f762-432a-8672-1e392edc3051	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	3316bf45-1931-4845-8dcf-2bd47da3c950	89ff74f6-077e-42d8-8302-aad6330fff1a	{"host_id": "e0c182db-32ff-55c6-a9eb-2b82dd21bc8b", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "e0c182db-32ff-55c6-a9eb-2b82dd21bc8b", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "e0c182db-32ff-55c6-a9eb-2b82dd21bc8b", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "e0c182db-32ff-55c6-a9eb-2b82dd21bc8b", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "e0c182db-32ff-55c6-a9eb-2b82dd21bc8b", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "e0c182db-32ff-55c6-a9eb-2b82dd21bc8b", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "e0c182db-32ff-55c6-a9eb-2b82dd21bc8b", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "e0c182db-32ff-55c6-a9eb-2b82dd21bc8b", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:16.457093+00
27ed4a55-3545-4dc2-8b89-1c0682af7901	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	d59fa50c-fcd6-46e7-88a4-e025dd31c099	5b096940-bde5-421d-a97f-68cc31cbeb9f	{"sid": "NWD", "health": "passing", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1, "features": "MESSAGESERVER|ENQUE", "http_port": 50013, "https_port": 50014, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "start_priority": "1", "instance_number": "00", "instance_hostname": "sapnwdas"}	{}	2024-04-09 15:07:16.58751+00
81a942eb-1441-41a9-ab28-c4e714c35767	Elixir.Trento.SapSystems.Events.SapSystemRegistered	d59fa50c-fcd6-46e7-88a4-e025dd31c099	5b096940-bde5-421d-a97f-68cc31cbeb9f	{"sid": "NWD", "health": "passing", "tenant": "HDD", "db_host": "10.100.1.13", "version": 1, "ensa_version": "ensa1", "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c"}	{}	2024-04-09 15:07:16.587515+00
f9191020-5fff-42d3-b6e8-a28d33a03163	Elixir.Trento.Hosts.Events.HostDeregistered	5e0872db-7d51-433b-aaa1-eed11fe3bd5e	d5c4deba-6737-4fbb-b3a5-a5336986ffde	{"host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1, "deregistered_at": "2024-04-09T15:07:47.267816Z"}	{}	2024-04-09 15:07:47.289185+00
7085014b-5c9f-4569-b00b-3ca7f18217fb	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	213aac65-bb6d-4bb3-9d25-88ef4db06e28	5dd3356e-fbfe-479a-9692-2255385e5206	{"host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:08.541888+00
147f89ab-859a-4e08-ae4a-ca0b8ad7a567	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	fe3a463c-1d96-4e24-99d6-a18436c47a82	1fc5ce2f-3b01-4508-8d9a-642f94fc0033	{"host_id": "098fc159-3ed6-58e7-91be-38fda8a833ea", "version": 1, "subscriptions": [{"arch": "x86_64", "type": null, "status": "Not Registered", "host_id": "098fc159-3ed6-58e7-91be-38fda8a833ea", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "SLES_SAP", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Not Registered", "host_id": "098fc159-3ed6-58e7-91be-38fda8a833ea", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Not Registered", "host_id": "098fc159-3ed6-58e7-91be-38fda8a833ea", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Not Registered", "host_id": "098fc159-3ed6-58e7-91be-38fda8a833ea", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Not Registered", "host_id": "098fc159-3ed6-58e7-91be-38fda8a833ea", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-ha", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Not Registered", "host_id": "098fc159-3ed6-58e7-91be-38fda8a833ea", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Not Registered", "host_id": "098fc159-3ed6-58e7-91be-38fda8a833ea", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:09.318946+00
c202af17-f3c5-40aa-89a4-9a0908077077	Elixir.Trento.Hosts.Events.HostRegistered	596700c1-3c95-4cc8-bb1c-6f94d2c7c960	4395eb72-bb21-4ae5-ae5e-436b3fd788a0	{"health": null, "host_id": "e0c182db-32ff-55c6-a9eb-2b82dd21bc8b", "version": 4, "hostname": "vmhdbqas02", "cpu_count": 4, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.90.1.12"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 32107, "installation_source": "unknown", "fully_qualified_domain_name": "vmhdbqas02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:09.746221+00
9a88dd3a-278f-48d8-9bdc-38b7f0a54ca4	Elixir.Trento.Hosts.Events.HostRegistered	4b1f754d-0686-4d99-bd0c-e5d68dcf29d3	6e002403-b6cd-4087-aae0-189d2e64655b	{"health": null, "host_id": "f0c808b3-d869-5192-a944-20f66a6a8449", "version": 4, "hostname": "vmiscsi01", "cpu_count": 1, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.90.1.4"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 3422, "installation_source": "unknown", "fully_qualified_domain_name": "vmiscsi01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:10.398519+00
1801b636-9e3d-42d8-a7de-8afede7736a0	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	ee993d7c-a033-4fe8-9932-a4e94d515f98	ce6644d0-3a8c-4fb0-8222-fee1f6d91e9e	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "saptune_health": "warning"}	{}	2024-04-09 15:07:10.801003+00
cbba12b1-1401-4bbb-a4c5-77d948e4ee90	Elixir.Trento.Clusters.Events.HostAddedToCluster	e0829a0c-b347-4f8a-8242-862bf454a492	e3ba7f5e-c1da-4372-96ec-bd8d9999e0c3	{"host_id": "a09d9cf3-46c1-505c-8fb8-4b0a71a9114e", "version": 1, "cluster_id": "c7a1e943-bf46-590b-bd26-bfc7c78def97"}	{}	2024-04-09 15:07:11.33444+00
e9da714c-f987-4b6d-b7e4-3a00ce756cdb	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	06499d85-bb86-4ac0-9d0c-0fb74c7a7d40	c6889938-247d-4808-8671-cfb7b6aaed9a	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:12.918679+00
65490fcd-a4e7-4743-843c-b0190235f360	Elixir.Trento.Hosts.Events.ProviderUpdated	a9527179-99c6-4ede-8696-25acae6af539	8bc86586-13c4-43ac-b67f-d09d942626da	{"host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmhdbdev02", "vm_size": "Standard_E4s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 7}}	{}	2024-04-09 15:07:13.168924+00
14d931cb-0fce-465f-887d-b3d742342222	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	f24cdc8c-10c2-434c-a01f-d924045cc9cd	49b60cc4-0a4c-416c-a6c8-63e7af016331	{"host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:10.52451+00
bc9e7dc8-3abc-442e-90da-333a1d60e8fa	Elixir.Trento.Hosts.Events.HostRegistered	0a6c2aa7-791a-4377-b6c3-a40bf8360cda	18d89fbe-6e8a-4e84-8f87-cf8cd24dae94	{"health": null, "host_id": "240f96b1-8d26-53b7-9e99-ffb0f2e735bf", "version": 4, "hostname": "vmdrbddev01", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.100.1.31", "10.100.1.33"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmdrbddev01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:12.114624+00
724cba0f-6f1c-45fd-b898-2e8b335fde5a	Elixir.Trento.Clusters.Events.HostAddedToCluster	685b41b9-6d32-49c3-8132-4279bcc53342	0b90ab36-6fde-4133-ad57-7cd71eb3f2d9	{"host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1, "cluster_id": "fa0d74a3-9240-5d9e-99fa-61c4137acf81"}	{}	2024-04-09 15:07:12.623274+00
34951626-3a28-4b9c-8584-c33fbba30877	Elixir.Trento.Clusters.Events.ClusterDetailsUpdated	685b41b9-6d32-49c3-8132-4279bcc53342	0b90ab36-6fde-4133-ad57-7cd71eb3f2d9	{"sid": "HDQ", "name": "hana_cluster_2", "type": "hana_scale_up", "details": {"nodes": [{"name": "vmhdbqas01", "site": "NBG", "status": "Online", "resources": [{"id": "stonith-sbd", "role": "Started", "type": "stonith:external/sbd", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHana_HDQ_HDB10", "role": "Master", "type": "ocf::suse:SAPHana", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHanaTopology_HDQ_HDB10", "role": "Started", "type": "ocf::suse:SAPHanaTopology", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_ip_HDQ_HDB10", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_HDQ_HDB10", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"lpa_hdq_lpt": "1643125033", "hana_hdq_site": "NBG", "hana_hdq_roles": "4:P:master1:master:worker:master", "hana_hdq_vhost": "vmhdbqas01", "hana_hdq_srmode": "sync", "hana_hdq_op_mode": "logreplay", "hana_hdq_version": "2.00.057.00.1629894416", "hana_hdq_remoteHost": "vmhdbqas02", "hana_hdq_sync_state": "PRIM", "hana_hdq_clone_state": "PROMOTED", "master-rsc_SAPHana_HDQ_HDB10": "150"}, "virtual_ip": "10.90.1.13", "hana_status": "Primary", "nameserver_actual_role": "master", "indexserver_actual_role": "master"}, {"name": "vmhdbqas02", "site": "WDF", "status": "Online", "resources": [{"id": "rsc_SAPHana_HDQ_HDB10", "role": "Slave", "type": "ocf::suse:SAPHana", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHanaTopology_HDQ_HDB10", "role": "Started", "type": "ocf::suse:SAPHanaTopology", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"lpa_hdq_lpt": "30", "hana_hdq_site": "WDF", "hana_hdq_roles": "4:S:master1:master:worker:master", "hana_hdq_vhost": "vmhdbqas02", "hana_hdq_srmode": "sync", "hana_hdq_op_mode": "logreplay", "hana_hdq_version": "2.00.057.00.1629894416", "hana_hdq_remoteHost": "vmhdbqas01", "hana_hdq_sync_state": "SOK", "hana_hdq_clone_state": "DEMOTED", "master-rsc_SAPHana_HDQ_HDB10": "100"}, "virtual_ip": null, "hana_status": "Secondary", "nameserver_actual_role": "master", "indexserver_actual_role": "master"}], "sites": [{"name": "NBG", "state": "Primary", "sr_health_state": "4"}, {"name": "WDF", "state": "Secondary", "sr_health_state": "4"}], "sbd_devices": [{"device": "/dev/disk/by-id/scsi-360014058d88c7795c6a4b66bc024f4bd", "status": "healthy"}], "fencing_type": "external/sbd", "sr_health_state": "4", "maintenance_mode": false, "stopped_resources": [], "secondary_sync_state": "SOK", "system_replication_mode": "sync", "system_replication_operation_mode": "logreplay"}, "version": 1, "provider": "azure", "cluster_id": "fa0d74a3-9240-5d9e-99fa-61c4137acf81", "hosts_number": 2, "additional_sids": [], "resources_number": 7}	{}	2024-04-09 15:07:12.623283+00
99d6da1b-b55d-46c5-aa43-dff385042968	Elixir.Trento.Clusters.Events.ClusterDiscoveredHealthChanged	685b41b9-6d32-49c3-8132-4279bcc53342	0b90ab36-6fde-4133-ad57-7cd71eb3f2d9	{"version": 1, "cluster_id": "fa0d74a3-9240-5d9e-99fa-61c4137acf81", "discovered_health": "passing"}	{}	2024-04-09 15:07:12.623285+00
5ba32040-209f-4b15-b406-d05822f6fbc9	Elixir.Trento.Clusters.Events.ClusterHealthChanged	685b41b9-6d32-49c3-8132-4279bcc53342	0b90ab36-6fde-4133-ad57-7cd71eb3f2d9	{"health": "passing", "version": 1, "cluster_id": "fa0d74a3-9240-5d9e-99fa-61c4137acf81"}	{}	2024-04-09 15:07:12.623287+00
fbdc767d-e4b1-474f-94be-cb59739e80ea	Elixir.Trento.Hosts.Events.ProviderUpdated	6314ed0e-50ea-4b35-a2cc-532206df2a4b	34098d66-1268-4f06-97a0-9dd326e99787	{"host_id": "9a26b6d0-6e72-597c-9fe5-152a6875f214", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmiscsi01", "vm_size": "Standard_DS1_v2", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}}	{}	2024-04-09 15:07:12.774248+00
2cce34a8-21f5-420c-9e6a-00822f41db9d	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	aa7142d9-0010-4778-bcc3-abceabcbcc16	49b909b7-4b1c-4cb9-91b7-645c6392aa4d	{"host_id": "4b30a6af-4b52-5bda-bccb-f2248a12c992", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "4b30a6af-4b52-5bda-bccb-f2248a12c992", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "4b30a6af-4b52-5bda-bccb-f2248a12c992", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "4b30a6af-4b52-5bda-bccb-f2248a12c992", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "4b30a6af-4b52-5bda-bccb-f2248a12c992", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "4b30a6af-4b52-5bda-bccb-f2248a12c992", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "4b30a6af-4b52-5bda-bccb-f2248a12c992", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "4b30a6af-4b52-5bda-bccb-f2248a12c992", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:16.197292+00
b6d02322-618e-4535-a63d-ee65efc026db	Elixir.Trento.Hosts.Events.ProviderUpdated	a3820550-7f3f-4b58-911f-1a5ef711c90e	abb40fd8-7a92-4345-9e91-c3572e0c227f	{"host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmhdbprd01", "vm_size": "Standard_E4s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 7}}	{}	2024-04-09 15:07:16.324723+00
9c24520a-0893-4393-8f34-e19ef1a1466a	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	1ff8b468-7a81-4c32-9039-dc6668394d88	74262e3e-92f0-4539-ab42-8e9e7b634ccb	{"host_id": "116d49bd-85e1-5e59-b820-83f66db8800c", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "116d49bd-85e1-5e59-b820-83f66db8800c", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "116d49bd-85e1-5e59-b820-83f66db8800c", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "116d49bd-85e1-5e59-b820-83f66db8800c", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "116d49bd-85e1-5e59-b820-83f66db8800c", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "116d49bd-85e1-5e59-b820-83f66db8800c", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "116d49bd-85e1-5e59-b820-83f66db8800c", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "116d49bd-85e1-5e59-b820-83f66db8800c", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:10.665898+00
e1913042-81c2-46f1-aa86-1c4664a7ce33	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	9f2013ff-9eb4-435e-b780-951b6347b122	f4451f80-20f6-4d96-a0a8-9e4e5f6710e3	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:11.070605+00
1ba9b86c-412a-4497-a08b-3f4a0c304f33	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	225305cf-7190-4503-8803-bce73e6512d6	aea147e9-5ccc-4eec-bf4d-250ee7a4da61	{"sid": "NWQ", "health": "passing", "host_id": "81e9b629-c1e7-538f-bff1-47d3a6580522", "version": 1, "features": "ABAP|GATEWAY|ICMAN|IGS", "http_port": 50213, "https_port": 50214, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "start_priority": "3", "instance_number": "02", "instance_hostname": "sapnwqaas1"}	{}	2024-04-09 15:07:12.486048+00
221cc61d-ff5d-4448-9b98-8288f97b9dba	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	d431c958-b900-4a17-a1cb-429c2e61fa17	ec8b121f-0129-4a2c-972b-e629e70a3ad4	{"status": {"staging": {"notes": [], "enabled": false, "solutions_ids": []}, "services": [{"name": "sapconf", "active": null, "enabled": null}, {"name": "saptune", "active": "active", "enabled": "enabled"}, {"name": "tuned", "active": null, "enabled": null}], "tuning_state": "not compliant", "applied_notes": [{"id": "941735", "additionally_enabled": false}, {"id": "1771258", "additionally_enabled": false}, {"id": "2578899", "additionally_enabled": false}, {"id": "2993054", "additionally_enabled": false}, {"id": "1656250", "additionally_enabled": false}, {"id": "900929", "additionally_enabled": false}], "enabled_notes": [{"id": "941735", "additionally_enabled": false}, {"id": "1771258", "additionally_enabled": false}, {"id": "2578899", "additionally_enabled": false}, {"id": "2993054", "additionally_enabled": false}, {"id": "1656250", "additionally_enabled": false}, {"id": "900929", "additionally_enabled": false}], "package_version": "3.1.0", "applied_solution": {"id": "NETWEAVER", "notes": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "partial": false}, "enabled_solution": {"id": "NETWEAVER", "notes": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "partial": false}, "configured_version": "3"}, "host_id": "0fc07435-7ee2-54ca-b0de-fb27ffdc5deb", "version": 1}	{}	2024-04-09 15:07:13.669967+00
aa1c0ae1-59cc-4bbf-b299-557f5d035e4c	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	d431c958-b900-4a17-a1cb-429c2e61fa17	ec8b121f-0129-4a2c-972b-e629e70a3ad4	{"host_id": "0fc07435-7ee2-54ca-b0de-fb27ffdc5deb", "version": 1, "saptune_health": "critical"}	{}	2024-04-09 15:07:13.669973+00
d3faa574-026d-45aa-8b87-e7a86b41fb3b	Elixir.Trento.Hosts.Events.HostRegistered	1d0d7435-c869-450b-ab4e-aaa343628fae	1d82482a-4363-471a-9c18-67c9c5c5ed06	{"health": null, "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 4, "hostname": "vmnwdev02", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.100.1.22", "10.100.1.26"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwdev02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:14.339613+00
aa6732dd-5aae-4309-92ec-e4da86046e4f	Elixir.Trento.Hosts.Events.HostRegistered	63ecfb49-ee5f-48c2-8591-966bc78cd831	c688f577-f490-4a19-9ee2-5fecf27194fb	{"health": null, "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 4, "hostname": "vmnwdev01", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "ip_addresses": ["10.100.1.21", "10.100.1.25"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwdev01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	{}	2024-04-09 15:07:15.064217+00
4e5b78b5-a5ac-4168-8318-67a660c11e96	Elixir.Trento.Hosts.Events.ProviderUpdated	40afb71d-a7f9-4e8a-af55-88916c178394	80448de2-7bb1-41ca-b376-f22fd80f5a22	{"host_id": "240f96b1-8d26-53b7-9e99-ffb0f2e735bf", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmdrbddev01", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}}	{}	2024-04-09 15:07:17.455168+00
adfdda8a-7992-4758-875f-27dacc96dcb8	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	143ab990-4838-49a8-8f06-c72c40834c22	3a633c1d-c3ce-4079-8b55-24ef48f36f32	{"host_id": "9a26b6d0-6e72-597c-9fe5-152a6875f214", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9a26b6d0-6e72-597c-9fe5-152a6875f214", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a26b6d0-6e72-597c-9fe5-152a6875f214", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a26b6d0-6e72-597c-9fe5-152a6875f214", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a26b6d0-6e72-597c-9fe5-152a6875f214", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9a26b6d0-6e72-597c-9fe5-152a6875f214", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a26b6d0-6e72-597c-9fe5-152a6875f214", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a26b6d0-6e72-597c-9fe5-152a6875f214", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:14.206729+00
16d38910-2b77-4b29-b4c1-c6dcfda7fd68	Elixir.Trento.Hosts.Events.ProviderUpdated	83a1efa4-e1e9-4801-ad4e-f7c022c0e039	912ef6ed-ef99-4810-b5ce-769ed373f498	{"host_id": "f0c808b3-d869-5192-a944-20f66a6a8449", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmiscsi01", "vm_size": "Standard_DS1_v2", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}}	{}	2024-04-09 15:07:14.608585+00
1f36bf5f-5bea-4a6d-8c04-d0df3cb7fe27	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	6947877b-1546-465c-b442-27da806cded9	3cea0242-b2b1-4d57-912b-5c0678924ac6	{"status": {"staging": {"notes": [], "enabled": false, "solutions_ids": []}, "services": [{"name": "sapconf", "active": null, "enabled": null}, {"name": "saptune", "active": "active", "enabled": "enabled"}, {"name": "tuned", "active": null, "enabled": null}], "tuning_state": "not compliant", "applied_notes": [{"id": "941735", "additionally_enabled": false}, {"id": "1771258", "additionally_enabled": false}, {"id": "2578899", "additionally_enabled": false}, {"id": "2993054", "additionally_enabled": false}, {"id": "1656250", "additionally_enabled": false}, {"id": "900929", "additionally_enabled": false}], "enabled_notes": [{"id": "941735", "additionally_enabled": false}, {"id": "1771258", "additionally_enabled": false}, {"id": "2578899", "additionally_enabled": false}, {"id": "2993054", "additionally_enabled": false}, {"id": "1656250", "additionally_enabled": false}, {"id": "900929", "additionally_enabled": false}], "package_version": "3.1.0", "applied_solution": {"id": "NETWEAVER", "notes": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "partial": false}, "enabled_solution": {"id": "NETWEAVER", "notes": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "partial": false}, "configured_version": "3"}, "host_id": "116d49bd-85e1-5e59-b820-83f66db8800c", "version": 1}	{}	2024-04-09 15:07:15.204422+00
b5f695c8-dade-4fa3-8971-eda530bc2826	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	6947877b-1546-465c-b442-27da806cded9	3cea0242-b2b1-4d57-912b-5c0678924ac6	{"host_id": "116d49bd-85e1-5e59-b820-83f66db8800c", "version": 1, "saptune_health": "critical"}	{}	2024-04-09 15:07:15.204429+00
7ff3b29e-5c92-453e-a453-dc404583582a	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	49e95793-0353-4a4b-82f5-a7ad8b4dc5d0	05beec62-d089-48d9-86f4-ee024bd5863d	{"host_id": "f0c808b3-d869-5192-a944-20f66a6a8449", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "f0c808b3-d869-5192-a944-20f66a6a8449", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "f0c808b3-d869-5192-a944-20f66a6a8449", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "f0c808b3-d869-5192-a944-20f66a6a8449", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "f0c808b3-d869-5192-a944-20f66a6a8449", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "f0c808b3-d869-5192-a944-20f66a6a8449", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "f0c808b3-d869-5192-a944-20f66a6a8449", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "f0c808b3-d869-5192-a944-20f66a6a8449", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:15.484226+00
25feb3d2-7bed-4c42-85f6-4221c21d8d60	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	c78b1c98-199b-4713-92c5-0dcf7eb278e4	91318ec8-fd4b-44bd-b604-1c5e27dc0d2c	{"status": {"staging": null, "services": [], "tuning_state": null, "applied_notes": [], "enabled_notes": [], "package_version": "3.0.0", "applied_solution": null, "enabled_solution": null, "configured_version": null}, "host_id": "ddcb7992-2ffb-5c10-8b39-80685f6eaaba", "version": 1}	{}	2024-04-09 15:07:15.927454+00
e3fda909-648c-4913-9baf-48e1c9154a3c	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	c78b1c98-199b-4713-92c5-0dcf7eb278e4	91318ec8-fd4b-44bd-b604-1c5e27dc0d2c	{"host_id": "ddcb7992-2ffb-5c10-8b39-80685f6eaaba", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:07:15.927464+00
532b3de6-ca4d-42d0-9758-f66392edc4f9	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	9a58c478-37d2-48e4-91b8-7924a1445e2f	bb2c586f-0aab-4a19-a642-4fba18db19a1	{"sid": "NWD", "health": "passing", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1, "features": "ENQREP", "http_port": 51013, "https_port": 51014, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "start_priority": "0.5", "instance_number": "10", "instance_hostname": "sapnwder"}	{}	2024-04-09 15:07:16.87453+00
56bdfd2a-e174-4aa4-9d2f-557fd673e0a7	Elixir.Trento.Hosts.Events.ProviderUpdated	b2feb78b-35f7-420a-b170-7e19cdbe10c1	40646998-a7af-4cec-8920-94f67146a6b8	{"host_id": "927901fa-2c87-524e-b18c-3ef5187f504f", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmdrbdprd02", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}}	{}	2024-04-09 15:07:17.146351+00
5e59dfc1-fbec-40f0-8048-117eac55cc59	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	0f75493b-35f9-4a93-925d-f3b021c16ca7	df7088f6-b50f-425e-8463-eda74890e64d	{"host_id": "3711ea88-9ccc-5b07-8f9d-042be449d72b", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "3711ea88-9ccc-5b07-8f9d-042be449d72b", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "3711ea88-9ccc-5b07-8f9d-042be449d72b", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "3711ea88-9ccc-5b07-8f9d-042be449d72b", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "3711ea88-9ccc-5b07-8f9d-042be449d72b", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "3711ea88-9ccc-5b07-8f9d-042be449d72b", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "3711ea88-9ccc-5b07-8f9d-042be449d72b", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "3711ea88-9ccc-5b07-8f9d-042be449d72b", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:16.725662+00
297cad94-0f70-4267-928d-22a40bdb4709	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	de78ffa2-d2d5-4d4c-b20b-0dd3666066c7	79047ee7-af34-4f50-9f69-eb83da69d106	{"status": {"staging": {"notes": [], "enabled": false, "solutions_ids": []}, "services": [{"name": "sapconf", "active": null, "enabled": null}, {"name": "saptune", "active": "active", "enabled": "enabled"}, {"name": "tuned", "active": null, "enabled": null}], "tuning_state": "not compliant", "applied_notes": [{"id": "941735", "additionally_enabled": false}, {"id": "1771258", "additionally_enabled": false}, {"id": "2578899", "additionally_enabled": false}, {"id": "2993054", "additionally_enabled": false}, {"id": "1656250", "additionally_enabled": false}, {"id": "900929", "additionally_enabled": false}], "enabled_notes": [{"id": "941735", "additionally_enabled": false}, {"id": "1771258", "additionally_enabled": false}, {"id": "2578899", "additionally_enabled": false}, {"id": "2993054", "additionally_enabled": false}, {"id": "1656250", "additionally_enabled": false}, {"id": "900929", "additionally_enabled": false}], "package_version": "3.1.0", "applied_solution": {"id": "NETWEAVER", "notes": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "partial": false}, "enabled_solution": {"id": "NETWEAVER", "notes": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "partial": false}, "configured_version": "3"}, "host_id": "4b30a6af-4b52-5bda-bccb-f2248a12c992", "version": 1}	{}	2024-04-09 15:07:18.42884+00
f2a1e4b3-7c89-4b3d-b39b-3835f7d8450b	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	de78ffa2-d2d5-4d4c-b20b-0dd3666066c7	79047ee7-af34-4f50-9f69-eb83da69d106	{"host_id": "4b30a6af-4b52-5bda-bccb-f2248a12c992", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:07:18.428851+00
9b404c85-cbae-49d5-b4ba-38118c381b90	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	44b45548-0140-445a-b3f9-50e167bc5317	c108c1e7-0bbe-4ffb-80ab-1f4ed28d0b53	{"status": {"staging": {"notes": [], "enabled": false, "solutions_ids": []}, "services": [{"name": "sapconf", "active": null, "enabled": null}, {"name": "saptune", "active": "active", "enabled": "enabled"}, {"name": "tuned", "active": null, "enabled": null}], "tuning_state": "compliant", "applied_notes": [{"id": "941735", "additionally_enabled": false}, {"id": "1771258", "additionally_enabled": false}, {"id": "1868829", "additionally_enabled": false}, {"id": "1980196", "additionally_enabled": false}, {"id": "2578899", "additionally_enabled": false}, {"id": "2684254", "additionally_enabled": false}, {"id": "2382421", "additionally_enabled": false}, {"id": "2534844", "additionally_enabled": false}, {"id": "2993054", "additionally_enabled": false}, {"id": "1656250", "additionally_enabled": false}], "enabled_notes": [{"id": "941735", "additionally_enabled": false}, {"id": "1771258", "additionally_enabled": false}, {"id": "1868829", "additionally_enabled": false}, {"id": "1980196", "additionally_enabled": false}, {"id": "2578899", "additionally_enabled": false}, {"id": "2684254", "additionally_enabled": false}, {"id": "2382421", "additionally_enabled": false}, {"id": "2534844", "additionally_enabled": false}, {"id": "2993054", "additionally_enabled": false}, {"id": "1656250", "additionally_enabled": false}], "package_version": "3.1.0", "applied_solution": {"id": "HANA", "notes": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "partial": false}, "enabled_solution": {"id": "HANA", "notes": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "partial": false}, "configured_version": "3"}, "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": 1}	{}	2024-04-09 15:07:19.156875+00
b060d972-4df3-4f5c-a6fd-d0d6a1cfa3dd	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	44b45548-0140-445a-b3f9-50e167bc5317	c108c1e7-0bbe-4ffb-80ab-1f4ed28d0b53	{"host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:07:19.156884+00
b2fbce55-5f40-483f-9851-d3a682c20610	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	6ed169da-90b1-42a8-89fb-ddc111adac34	fd2bdb86-2fda-432a-9f88-3db8b2fdea93	{"host_id": "ddcb7992-2ffb-5c10-8b39-80685f6eaaba", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "ddcb7992-2ffb-5c10-8b39-80685f6eaaba", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "ddcb7992-2ffb-5c10-8b39-80685f6eaaba", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "ddcb7992-2ffb-5c10-8b39-80685f6eaaba", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "ddcb7992-2ffb-5c10-8b39-80685f6eaaba", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "ddcb7992-2ffb-5c10-8b39-80685f6eaaba", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "ddcb7992-2ffb-5c10-8b39-80685f6eaaba", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "ddcb7992-2ffb-5c10-8b39-80685f6eaaba", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:19.562242+00
4d6726c3-a783-494f-b34d-26a1365131ee	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	5a4d6cb1-5f04-4c23-b48f-edd4d00fde57	0c077222-4366-4da4-b1b6-2e06f8be2223	{"host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1, "saptune_health": "warning"}	{}	2024-04-09 15:07:20.904819+00
6c312c88-f792-470b-8115-b23fd84bc385	Elixir.Trento.Hosts.Events.ProviderUpdated	50e3368c-9791-4d64-8470-09016ea639f1	1d885add-9a8d-40af-a56a-b31b6b3b1cfd	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwqas01", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 0}}	{}	2024-04-09 15:07:21.035703+00
8de69742-3cac-48fe-a2f5-7d48a4b5a573	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	f6b0c3e7-ed7e-4567-840a-ee28eec1bdbc	2d69b77c-e92e-4726-bd17-294a290e37bc	{"status": {"staging": null, "services": [], "tuning_state": null, "applied_notes": [], "enabled_notes": [], "package_version": "3.0.0", "applied_solution": null, "enabled_solution": null, "configured_version": null}, "host_id": "3711ea88-9ccc-5b07-8f9d-042be449d72b", "version": 1}	{}	2024-04-09 15:07:21.440891+00
54c3c7b8-3458-4683-8859-e5edf2fae34e	Elixir.Trento.SapSystems.Events.DatabaseInstanceRegistered	c7574ac8-6d8a-47cf-b8ac-58d7e142e90a	fa936577-ff5f-47ba-910b-9e078f61b7e3	{"sid": "HDQ", "health": "passing", "tenant": "HDQ", "host_id": "e0c182db-32ff-55c6-a9eb-2b82dd21bc8b", "version": 1, "features": "HDB|HDB_WORKER", "http_port": 51013, "https_port": 51014, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "start_priority": "0.3", "instance_number": "10", "instance_hostname": "vmhdbqas02", "system_replication": "Secondary", "system_replication_status": null}	{}	2024-04-09 15:07:17.006501+00
79c8a577-4540-4f87-a22f-9ca7fa5fe928	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	aeac95a0-22e2-480d-bd8f-922c03bd4270	274572a3-1118-41a7-ba71-0f8ea8a83c6e	{"status": {"staging": null, "services": [], "tuning_state": null, "applied_notes": [], "enabled_notes": [], "package_version": "3.0.0", "applied_solution": null, "enabled_solution": null, "configured_version": null}, "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1}	{}	2024-04-09 15:07:17.306509+00
f16f1fc4-ea5f-4653-be90-9e7e2e75ada4	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	aeac95a0-22e2-480d-bd8f-922c03bd4270	274572a3-1118-41a7-ba71-0f8ea8a83c6e	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "saptune_health": "warning"}	{}	2024-04-09 15:07:17.306522+00
75cf5dc2-ff51-43d9-b062-6437e36839b6	Elixir.Trento.Hosts.Events.ProviderUpdated	f4410dc7-d8d0-48a9-93b1-63d7c1be8b11	56258d6c-2065-4d87-bab5-951c88568534	{"host_id": "21de186a-e38f-5804-b643-7f4ef22fecfd", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmdrbddev02", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}}	{}	2024-04-09 15:07:17.795371+00
43ed6612-4fcf-448d-b6b2-7d57f4c2c8c4	Elixir.Trento.Hosts.Events.ProviderUpdated	06a46bb2-6c3d-46ff-b6dc-2170be2a4909	1b4aac2d-2b83-4e9a-9f9d-6c95faeac9f8	{"host_id": "4b30a6af-4b52-5bda-bccb-f2248a12c992", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwprd02", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 0}}	{}	2024-04-09 15:07:17.94115+00
800e06e5-0af1-4db3-9acf-d48456f95d8b	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	42f6fb17-36ba-4038-9013-80214a470f7d	3a14c987-1cd6-429c-8f63-d8e65bd97a49	{"host_id": "b767b3e9-e802-587e-a442-541d093b86b9", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "b767b3e9-e802-587e-a442-541d093b86b9", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "b767b3e9-e802-587e-a442-541d093b86b9", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "b767b3e9-e802-587e-a442-541d093b86b9", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "b767b3e9-e802-587e-a442-541d093b86b9", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "b767b3e9-e802-587e-a442-541d093b86b9", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "b767b3e9-e802-587e-a442-541d093b86b9", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "b767b3e9-e802-587e-a442-541d093b86b9", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:18.095811+00
9df423d5-b31a-43ba-8067-b7219df7c067	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	638fc7bb-e1d6-4023-9a73-57ed748553a4	dec79755-29f1-4046-85a4-8fdb3adfdf8d	{"status": {"staging": null, "services": [], "tuning_state": null, "applied_notes": [], "enabled_notes": [], "package_version": "3.0.0", "applied_solution": null, "enabled_solution": null, "configured_version": null}, "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1}	{}	2024-04-09 15:07:18.26983+00
3db9c6e8-5a93-4bbe-bf0f-5ea056b6e6b3	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	638fc7bb-e1d6-4023-9a73-57ed748553a4	dec79755-29f1-4046-85a4-8fdb3adfdf8d	{"host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1, "saptune_health": "warning"}	{}	2024-04-09 15:07:18.26984+00
61179a1b-a442-40cd-90c7-d4dbb16c1dcb	Elixir.Trento.SapSystems.Events.DatabaseInstanceRegistered	e7e7757e-e8a7-4c54-a3ac-b80a0b64359b	f625ed14-1516-440c-a3dd-019f60584a9c	{"sid": "HDP", "health": "passing", "tenant": "HDP", "host_id": "b767b3e9-e802-587e-a442-541d093b86b9", "version": 1, "features": "HDB|HDB_WORKER", "http_port": 51013, "https_port": 51014, "sap_system_id": "6c9208eb-a5bb-57ef-be5c-6422dedab602", "start_priority": "0.3", "instance_number": "10", "instance_hostname": "vmhdbprd02", "system_replication": "Secondary", "system_replication_status": null}	{}	2024-04-09 15:07:19.706573+00
e5748155-e257-4aea-a10d-e0062196e6ae	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	0b8452f6-91e0-43c2-bb68-690c5bd60b59	70ad8917-1ed9-4dc8-ac9b-b194fc628936	{"host_id": "422686d6-b2d1-5092-93e8-a744854f5085", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "422686d6-b2d1-5092-93e8-a744854f5085", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "422686d6-b2d1-5092-93e8-a744854f5085", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "422686d6-b2d1-5092-93e8-a744854f5085", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "422686d6-b2d1-5092-93e8-a744854f5085", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "422686d6-b2d1-5092-93e8-a744854f5085", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "422686d6-b2d1-5092-93e8-a744854f5085", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "422686d6-b2d1-5092-93e8-a744854f5085", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:19.966638+00
1674d764-f7ae-463e-9fb9-f06e4977e0d3	Elixir.Trento.Hosts.Events.ProviderUpdated	5f76329b-e19b-499f-b1b9-28805f8f9c63	d694a902-1918-4494-975e-5adc5e022097	{"host_id": "e0c182db-32ff-55c6-a9eb-2b82dd21bc8b", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmhdbqas02", "vm_size": "Standard_E4s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 7}}	{}	2024-04-09 15:07:20.292012+00
b116b0f8-d243-4345-b12f-3ab226da506a	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	2335ccd6-703b-43a2-a7bc-b418c5fe576f	fba0dc0e-dec0-41e8-9047-686270491c00	{"status": {"staging": {"notes": [], "enabled": false, "solutions_ids": []}, "services": [{"name": "sapconf", "active": null, "enabled": null}, {"name": "saptune", "active": "inactive", "enabled": "enabled"}, {"name": "tuned", "active": null, "enabled": null}], "tuning_state": "not tuned", "applied_notes": [], "enabled_notes": [], "package_version": "3.1.0", "applied_solution": null, "enabled_solution": null, "configured_version": "3"}, "host_id": "927901fa-2c87-524e-b18c-3ef5187f504f", "version": 1}	{}	2024-04-09 15:07:17.596868+00
44985c30-8bdf-41d0-9db0-6560c244804d	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	2335ccd6-703b-43a2-a7bc-b418c5fe576f	fba0dc0e-dec0-41e8-9047-686270491c00	{"host_id": "927901fa-2c87-524e-b18c-3ef5187f504f", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:07:17.596877+00
7f26570b-fb85-4acd-85bc-0dee7f7ecc20	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	6d205f9b-edeb-41d2-931f-8a84b5647bdd	cd4ab619-7856-4c68-8514-8c7383f23f94	{"status": {"staging": null, "services": [], "tuning_state": null, "applied_notes": [], "enabled_notes": [], "package_version": "3.0.0", "applied_solution": null, "enabled_solution": null, "configured_version": null}, "host_id": "e0c182db-32ff-55c6-a9eb-2b82dd21bc8b", "version": 1}	{}	2024-04-09 15:07:19.429368+00
6a3302aa-3afb-43c9-b0e1-433e76c3d3e8	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	6d205f9b-edeb-41d2-931f-8a84b5647bdd	cd4ab619-7856-4c68-8514-8c7383f23f94	{"host_id": "e0c182db-32ff-55c6-a9eb-2b82dd21bc8b", "version": 1, "saptune_health": "warning"}	{}	2024-04-09 15:07:19.429377+00
b5accf16-6145-4fb2-8b90-08269bedc55a	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	f16c0f8f-16d7-4583-ab8b-e4c271bd6e81	89399fa4-f3cf-4959-b0ec-08a7fdbed179	{"status": {"staging": {"notes": [], "enabled": false, "solutions_ids": []}, "services": [{"name": "sapconf", "active": null, "enabled": null}, {"name": "saptune", "active": "inactive", "enabled": "enabled"}, {"name": "tuned", "active": null, "enabled": null}], "tuning_state": "not tuned", "applied_notes": [], "enabled_notes": [], "package_version": "3.1.0", "applied_solution": null, "enabled_solution": null, "configured_version": "3"}, "host_id": "a09d9cf3-46c1-505c-8fb8-4b0a71a9114e", "version": 1}	{}	2024-04-09 15:07:20.423888+00
a518a774-5e58-4295-8e63-c12a1896cd47	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	f16c0f8f-16d7-4583-ab8b-e4c271bd6e81	89399fa4-f3cf-4959-b0ec-08a7fdbed179	{"host_id": "a09d9cf3-46c1-505c-8fb8-4b0a71a9114e", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:07:20.423908+00
39d73778-de57-4d3b-80b6-fdb1b4448339	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	38565794-c5db-46c4-8c39-a2cd5ebaf069	45ba204d-52d4-483b-b70e-ddb820765bf9	{"sid": "NWP", "health": "passing", "host_id": "4b30a6af-4b52-5bda-bccb-f2248a12c992", "version": 1, "features": "ENQREP", "http_port": 51013, "https_port": 51014, "sap_system_id": "6c9208eb-a5bb-57ef-be5c-6422dedab602", "start_priority": "0.5", "instance_number": "10", "instance_hostname": "sapnwper"}	{}	2024-04-09 15:07:20.76699+00
aa4a6b59-f88b-462f-a16f-f57e8c0da09a	Elixir.Trento.Hosts.Events.ProviderUpdated	3903d531-7d5a-4bf0-a1c2-a2f46a3f11d0	a6838fa5-d8ae-4ff0-9539-e0c1ccb2e4cd	{"host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwdev02", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 0}}	{}	2024-04-09 15:07:21.174191+00
0cfd24fb-9e7e-4bdb-8079-bcdb421b0adc	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	4b3fbed2-819d-466c-b195-5fa0e9c60e31	6869f077-9f7b-4696-a9a9-34d13ec11c8f	{"host_id": "81e9b629-c1e7-538f-bff1-47d3a6580522", "version": 1, "subscriptions": [{"arch": "x86_64", "type": null, "status": "Not Registered", "host_id": "81e9b629-c1e7-538f-bff1-47d3a6580522", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "SLES_SAP", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Not Registered", "host_id": "81e9b629-c1e7-538f-bff1-47d3a6580522", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Not Registered", "host_id": "81e9b629-c1e7-538f-bff1-47d3a6580522", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Not Registered", "host_id": "81e9b629-c1e7-538f-bff1-47d3a6580522", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Not Registered", "host_id": "81e9b629-c1e7-538f-bff1-47d3a6580522", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-ha", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Not Registered", "host_id": "81e9b629-c1e7-538f-bff1-47d3a6580522", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Not Registered", "host_id": "81e9b629-c1e7-538f-bff1-47d3a6580522", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:22.320675+00
32adcaff-bf40-4240-9f98-fef309a5a600	Elixir.Trento.SapSystems.Events.ApplicationInstanceDeregistered	f1b8a204-91bb-49b7-945a-710f0b9fbd4b	48729931-8469-4f1d-8ebc-d30a1df96400	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:07:42.119934Z", "instance_number": "02"}	{}	2024-04-09 15:07:42.1387+00
96cd5c39-2544-41b6-9b80-9e03baefae78	Elixir.Trento.Hosts.Events.HostRollUpRequested	35795941-da97-4dbe-9568-6ddbead68a18	c761bf23-60d6-4b93-b25b-c20d77ef911c	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "snapshot": {"health": "unknown", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "hostname": "vmnwdev03", "provider": "azure", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.100.1.23", "10.100.1.27"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwdev03", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "passing", "saptune_status": null, "deregistered_at": "2024-04-09T15:07:44.714417Z", "selected_checks": [], "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwdev03.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:07:44.735107+00
c5d1d2d6-e76d-464a-969a-71aa45336b13	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	43a3c7a6-f50c-431a-affd-9c8e4bd4d5e0	08b1c9b7-b024-49e0-a49a-d29c1f71db47	{"sid": "NWP", "health": "passing", "host_id": "a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12", "version": 1, "features": "ABAP|GATEWAY|ICMAN|IGS", "http_port": 50113, "https_port": 50114, "sap_system_id": "6c9208eb-a5bb-57ef-be5c-6422dedab602", "start_priority": "3", "instance_number": "01", "instance_hostname": "sapnwppas"}	{}	2024-04-09 15:07:18.609599+00
0cd49cdd-242a-4eed-8137-cb1a890c9ecc	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	ba88dce6-c3b6-45ca-8728-b05142b5e62c	30284cc8-faef-4765-838f-7c42b30926a3	{"sid": "NWQ", "health": "passing", "host_id": "098fc159-3ed6-58e7-91be-38fda8a833ea", "version": 1, "features": "ABAP|GATEWAY|ICMAN|IGS", "http_port": 50113, "https_port": 50114, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "start_priority": "3", "instance_number": "01", "instance_hostname": "sapnwqpas"}	{}	2024-04-09 15:07:18.759061+00
af4adae4-9973-41a5-97cc-51ddf2646ce3	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	1352aa92-d311-4ad9-a22f-f0f9e56e2fec	a2f8e8eb-8246-4544-b41e-06efd60bc762	{"sid": "NWD", "health": "passing", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "features": "ABAP|GATEWAY|ICMAN|IGS", "http_port": 50213, "https_port": 50214, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "start_priority": "3", "instance_number": "02", "instance_hostname": "sapnwdaas1"}	{}	2024-04-09 15:07:18.898854+00
32a7d617-da46-492d-b4ec-3b8831a4f9e3	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	01c5a7b0-13db-4ea6-ad56-d99032ecd2e0	7f2c609d-cbb1-4d72-9327-704a92ec90e2	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:19.026818+00
e67cd344-ee50-4931-be16-63edb6c6a227	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	f57c4a04-9cbf-48db-be02-7169e8888a15	405a0a68-9dd3-4b86-84b5-f51f245282a7	{"host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1, "saptune_health": "warning"}	{}	2024-04-09 15:07:19.293008+00
04f5fee8-12b9-4a3e-a1fe-26a4810d993a	Elixir.Trento.Hosts.Events.ProviderUpdated	c0a57826-49cb-4029-9763-0ea61da71209	202be506-7990-43ec-a641-25439745ce69	{"host_id": "b767b3e9-e802-587e-a442-541d093b86b9", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmhdbprd02", "vm_size": "Standard_E4s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 7}}	{}	2024-04-09 15:07:20.626121+00
213cfbe2-14b0-4640-b584-764cda3a2640	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	c10d35d3-2323-421e-9ad5-9c67ebe966bf	0af82f09-e645-4fab-af78-e078fbcefe57	{"host_id": "0fc07435-7ee2-54ca-b0de-fb27ffdc5deb", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "0fc07435-7ee2-54ca-b0de-fb27ffdc5deb", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0fc07435-7ee2-54ca-b0de-fb27ffdc5deb", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0fc07435-7ee2-54ca-b0de-fb27ffdc5deb", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0fc07435-7ee2-54ca-b0de-fb27ffdc5deb", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "0fc07435-7ee2-54ca-b0de-fb27ffdc5deb", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0fc07435-7ee2-54ca-b0de-fb27ffdc5deb", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0fc07435-7ee2-54ca-b0de-fb27ffdc5deb", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:21.308116+00
07efa33b-56e8-4bf7-af89-b57c8bc85240	Elixir.Trento.Hosts.Events.ProviderUpdated	f8722407-5efa-49f7-8faa-cda8c2b5af78	5e023588-5ff1-487c-90c8-68919fbb9e5b	{"host_id": "3711ea88-9ccc-5b07-8f9d-042be449d72b", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwqas02", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 0}}	{}	2024-04-09 15:07:21.584589+00
9dcf1c0e-87b8-43a1-858e-6124d0eeaa59	Elixir.Trento.Hosts.Events.ProviderUpdated	d6b4b970-8021-457e-99ac-2365dddd2ac3	8054d974-3241-4b5c-b312-ea205f45cc56	{"host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1, "provider": "azure", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwdev01", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 0}}	{}	2024-04-09 15:07:22.030159+00
f9a79472-0305-4a78-b26e-f6d613b7df4b	Elixir.Trento.Hosts.Events.HostTombstoned	5e0872db-7d51-433b-aaa1-eed11fe3bd5e	d5c4deba-6737-4fbb-b3a5-a5336986ffde	{"host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1}	{}	2024-04-09 15:07:47.289187+00
a6e81307-c1ab-4a63-beee-4aae3fe51969	Elixir.Trento.Hosts.Events.HostDeregistrationRequested	76285bad-6a02-4d5e-be10-e759d44dd2a8	e7589b72-55e4-4f31-ae32-db80b9584870	{"host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1, "requested_at": "2024-04-09T15:07:50.068043Z"}	{}	2024-04-09 15:07:50.070864+00
19339468-c3b1-40f3-a31b-6f9a9d78108f	Elixir.Trento.SapSystems.Events.ApplicationInstanceDeregistered	4bca31b3-bb62-41e5-a804-db2ef8a33ff0	e7589b72-55e4-4f31-ae32-db80b9584870	{"host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:07:50.068043Z", "instance_number": "00"}	{}	2024-04-09 15:07:50.07905+00
824d131b-f66a-451a-8e62-d43e7ec9a8ec	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	dd519621-3356-4a0e-938a-990b95fd5caf	6a99f18e-4bd5-42c8-977e-9995276931dc	{"host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:19.837107+00
afe9d3af-48f9-49b8-9e93-e9265458b2f5	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	d486f2df-d667-4c92-9dcc-99ced3666f60	66d0573b-f1d7-458b-b8e8-27e08f1b1a51	{"host_id": "927901fa-2c87-524e-b18c-3ef5187f504f", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "927901fa-2c87-524e-b18c-3ef5187f504f", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "927901fa-2c87-524e-b18c-3ef5187f504f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "927901fa-2c87-524e-b18c-3ef5187f504f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "927901fa-2c87-524e-b18c-3ef5187f504f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "927901fa-2c87-524e-b18c-3ef5187f504f", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "927901fa-2c87-524e-b18c-3ef5187f504f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "927901fa-2c87-524e-b18c-3ef5187f504f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:20.110115+00
8260a9b0-cdc0-45bf-90ed-dccd2a97e0bf	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	bfb4dd98-72f1-414c-88c7-7e09ee7590bd	722a1373-d467-4e5f-8309-3f407c36ecbf	{"host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:21.769597+00
220f4e4d-acde-40e9-ae95-17718f9a651e	Elixir.Trento.Hosts.Events.SaptuneStatusUpdated	d0f6c762-cdc3-4bc1-8b90-ddd97393ffb6	c227de67-fc1e-40ac-971b-7d6567b7a9dd	{"status": {"staging": null, "services": [], "tuning_state": null, "applied_notes": [], "enabled_notes": [], "package_version": "3.0.0", "applied_solution": null, "enabled_solution": null, "configured_version": null}, "host_id": "240f96b1-8d26-53b7-9e99-ffb0f2e735bf", "version": 1}	{}	2024-04-09 15:07:21.908466+00
11a41385-7e9d-49d3-8f49-90a647ce2458	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	d0f6c762-cdc3-4bc1-8b90-ddd97393ffb6	c227de67-fc1e-40ac-971b-7d6567b7a9dd	{"host_id": "240f96b1-8d26-53b7-9e99-ffb0f2e735bf", "version": 1, "saptune_health": "passing"}	{}	2024-04-09 15:07:21.908473+00
8e2e7df8-e7a4-400e-90d4-c4b489db6636	Elixir.Trento.Hosts.Events.SoftwareUpdatesDiscoveryCleared	5f0f5dad-7fc7-4295-9398-7e85132162b6	48729931-8469-4f1d-8ebc-d30a1df96400	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1}	{}	2024-04-09 15:07:42.143236+00
87eb61ad-9d63-48fc-abab-91a4c29b49c3	Elixir.Trento.Hosts.Events.HostDeregistered	5f0f5dad-7fc7-4295-9398-7e85132162b6	48729931-8469-4f1d-8ebc-d30a1df96400	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "deregistered_at": "2024-04-09T15:07:42.119934Z"}	{}	2024-04-09 15:07:42.143244+00
0406c959-63e5-475d-a7fc-80039cd7a2a5	Elixir.Trento.Hosts.Events.HostTombstoned	5f0f5dad-7fc7-4295-9398-7e85132162b6	48729931-8469-4f1d-8ebc-d30a1df96400	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1}	{}	2024-04-09 15:07:42.143246+00
586aa07e-f8e0-4e50-b004-cb5ebe2c4a0f	Elixir.Trento.Hosts.Events.SoftwareUpdatesDiscoveryCleared	f1b1e846-329b-4634-96b2-fa64eb4a9d1b	bfa5fd42-bc15-4068-805c-5c892d2b0a44	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1}	{}	2024-04-09 15:07:44.726576+00
2d4685c2-897f-47c6-905f-bf49482e39b1	Elixir.Trento.Hosts.Events.HostDeregistered	f1b1e846-329b-4634-96b2-fa64eb4a9d1b	bfa5fd42-bc15-4068-805c-5c892d2b0a44	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "deregistered_at": "2024-04-09T15:07:44.714417Z"}	{}	2024-04-09 15:07:44.726582+00
03121a42-5c45-46b5-9a0b-be963295de79	Elixir.Trento.Hosts.Events.HostTombstoned	f1b1e846-329b-4634-96b2-fa64eb4a9d1b	bfa5fd42-bc15-4068-805c-5c892d2b0a44	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1}	{}	2024-04-09 15:07:44.726584+00
7ffca23c-2f1e-42d0-ab52-4c876374356f	Elixir.Trento.Hosts.Events.SlesSubscriptionsUpdated	fc9fe7e4-b7e8-45ee-9fbe-16e53427fccc	3454c2cc-d63a-4a25-b850-fd21db27d186	{"host_id": "240f96b1-8d26-53b7-9e99-ffb0f2e735bf", "version": 1, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "240f96b1-8d26-53b7-9e99-ffb0f2e735bf", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "240f96b1-8d26-53b7-9e99-ffb0f2e735bf", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "240f96b1-8d26-53b7-9e99-ffb0f2e735bf", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "240f96b1-8d26-53b7-9e99-ffb0f2e735bf", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "240f96b1-8d26-53b7-9e99-ffb0f2e735bf", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "240f96b1-8d26-53b7-9e99-ffb0f2e735bf", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "240f96b1-8d26-53b7-9e99-ffb0f2e735bf", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}]}	{}	2024-04-09 15:07:22.154934+00
3dc37873-9314-47c5-afbf-b9f815d57623	Elixir.Trento.Hosts.Events.HostDeregistrationRequested	f8fa0976-8888-4e63-8caa-01cb29e4a108	48729931-8469-4f1d-8ebc-d30a1df96400	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "requested_at": "2024-04-09T15:07:42.119934Z"}	{}	2024-04-09 15:07:42.125483+00
5aed2ea7-351c-4be8-99d0-68b3b44d4b4a	Elixir.Trento.Hosts.Events.HostRollUpRequested	eae305d8-f8d4-4100-bdc3-3ce97905165d	2fab1b01-da80-4f59-9ddb-64ef53e167c1	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "snapshot": {"health": "unknown", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "hostname": "vmnwdev04", "provider": "azure", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.100.1.24", "10.100.1.28"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwdev04", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "passing", "saptune_status": null, "deregistered_at": "2024-04-09T15:07:42.119934Z", "selected_checks": [], "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwdev04.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:07:42.164149+00
49500b4e-dd8c-4f3b-9043-74d55676feee	Elixir.Trento.Hosts.Events.HostRolledUp	6050c375-5977-4fd8-8379-6114cb18ed4c	05c671dc-29b0-454c-9003-6615f6d8f7ae	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "snapshot": {"health": "unknown", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "hostname": "vmnwdev04", "provider": "azure", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.100.1.24", "10.100.1.28"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwdev04", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "passing", "saptune_status": null, "deregistered_at": "2024-04-09T15:07:42.119934Z", "selected_checks": [], "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwdev04.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:07:42.180652+00
393bfb43-9933-4713-9f1c-9981db1e39c6	Elixir.Trento.Hosts.Events.HostDeregistrationRequested	444be093-f631-454d-b3eb-8f22ea392059	bfa5fd42-bc15-4068-805c-5c892d2b0a44	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "requested_at": "2024-04-09T15:07:44.714417Z"}	{}	2024-04-09 15:07:44.717251+00
f305b431-db10-46c5-b216-96a1cdd3e772	Elixir.Trento.SapSystems.Events.ApplicationInstanceDeregistered	208d51a4-8426-4d65-9d30-cadbcc0e6f64	bfa5fd42-bc15-4068-805c-5c892d2b0a44	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:07:44.714417Z", "instance_number": "01"}	{}	2024-04-09 15:07:44.723721+00
5aa77707-f93b-41ff-b657-ccea730bd12f	Elixir.Trento.SapSystems.Events.SapSystemDeregistered	208d51a4-8426-4d65-9d30-cadbcc0e6f64	bfa5fd42-bc15-4068-805c-5c892d2b0a44	{"version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:07:44.714417Z"}	{}	2024-04-09 15:07:44.723728+00
e335b65f-9a46-46c1-b661-b2e2b6d90c11	Elixir.Trento.Hosts.Events.HostRolledUp	fb520aae-0ae3-425f-a13b-3c8679838f2b	07352863-0fc3-402a-b7b6-d9b000c147fd	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "snapshot": {"health": "unknown", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "hostname": "vmnwdev03", "provider": "azure", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.100.1.23", "10.100.1.27"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwdev03", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "passing", "saptune_status": null, "deregistered_at": "2024-04-09T15:07:44.714417Z", "selected_checks": [], "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwdev03.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:07:44.748805+00
e83144ee-ec2b-4108-b3b0-1f8143a98aea	Elixir.Trento.Hosts.Events.HostDeregistrationRequested	8e3b1d45-93c8-4951-a634-51d2f9664878	d5c4deba-6737-4fbb-b3a5-a5336986ffde	{"host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1, "requested_at": "2024-04-09T15:07:47.267816Z"}	{}	2024-04-09 15:07:47.27079+00
bdccb39a-7aa2-480c-a3dd-5b314f6b1309	Elixir.Trento.SapSystems.Events.ApplicationInstanceDeregistered	c458a28e-b753-4c3a-992a-4f5d66f220bc	d5c4deba-6737-4fbb-b3a5-a5336986ffde	{"host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:07:47.267816Z", "instance_number": "10"}	{}	2024-04-09 15:07:47.277922+00
1cd4752b-3c1e-4288-bd8a-79335c8ba5c6	Elixir.Trento.Clusters.Events.HostRemovedFromCluster	d1d07c05-8c54-4584-a497-c19524341dd8	d5c4deba-6737-4fbb-b3a5-a5336986ffde	{"host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1, "cluster_id": "5284f376-c1f4-5178-8966-d490df3dab4f", "deregistered_at": null}	{}	2024-04-09 15:07:47.284722+00
523cb3c5-a2f2-4a4e-bcd1-4ab99015241d	Elixir.Trento.Hosts.Events.HostRollUpRequested	13eb37f0-f326-494b-a077-34057eee805d	80932240-f524-443d-b7fe-796515476d69	{"host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1, "snapshot": {"health": "unknown", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "hostname": "vmnwdev02", "provider": "azure", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.100.1.22", "10.100.1.26"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwdev02", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 0}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "warning", "saptune_status": null, "deregistered_at": "2024-04-09T15:07:47.267816Z", "selected_checks": [], "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwdev02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:07:47.298587+00
19c8b8d5-af43-4162-bc58-8068fc534db5	Elixir.Trento.Hosts.Events.HostRolledUp	44c3ec24-f2c2-4c5f-a09a-3a4e3f9fa901	9a9a9a49-0ef8-46c1-8722-0b0e53235035	{"host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1, "snapshot": {"health": "unknown", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "hostname": "vmnwdev02", "provider": "azure", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.100.1.22", "10.100.1.26"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwdev02", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 0}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "warning", "saptune_status": null, "deregistered_at": "2024-04-09T15:07:47.267816Z", "selected_checks": [], "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwdev02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:07:47.310804+00
ddd6ec27-1a54-4921-9563-1b25a94551d9	Elixir.Trento.Clusters.Events.HostRemovedFromCluster	3d35b8a0-a380-4fe3-92d9-c300b1cba4ad	e7589b72-55e4-4f31-ae32-db80b9584870	{"host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1, "cluster_id": "5284f376-c1f4-5178-8966-d490df3dab4f", "deregistered_at": null}	{}	2024-04-09 15:07:50.080705+00
4aba5103-6c26-4434-a871-d9f5ecc3cc9b	Elixir.Trento.Clusters.Events.ClusterDeregistered	3d35b8a0-a380-4fe3-92d9-c300b1cba4ad	e7589b72-55e4-4f31-ae32-db80b9584870	{"version": 1, "cluster_id": "5284f376-c1f4-5178-8966-d490df3dab4f", "deregistered_at": "2024-04-09T15:07:50.068043Z"}	{}	2024-04-09 15:07:50.080724+00
08b3adac-059f-42df-9194-00b48863e8ef	Elixir.Trento.Clusters.Events.ClusterTombstoned	3d35b8a0-a380-4fe3-92d9-c300b1cba4ad	e7589b72-55e4-4f31-ae32-db80b9584870	{"version": 1, "cluster_id": "5284f376-c1f4-5178-8966-d490df3dab4f"}	{}	2024-04-09 15:07:50.080728+00
6b871c5d-9aec-41eb-870d-092cb358dee0	Elixir.Trento.Hosts.Events.SoftwareUpdatesDiscoveryCleared	5181cb7e-852f-4603-9b6d-ec1786b92d2f	e7589b72-55e4-4f31-ae32-db80b9584870	{"host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1}	{}	2024-04-09 15:07:50.086397+00
43d06dad-6de6-4b49-832c-59d6dd1492e6	Elixir.Trento.Hosts.Events.HostDeregistered	5181cb7e-852f-4603-9b6d-ec1786b92d2f	e7589b72-55e4-4f31-ae32-db80b9584870	{"host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1, "deregistered_at": "2024-04-09T15:07:50.068043Z"}	{}	2024-04-09 15:07:50.08641+00
759f6452-5df8-4a59-b5ac-e4a71556f893	Elixir.Trento.Hosts.Events.HostTombstoned	5181cb7e-852f-4603-9b6d-ec1786b92d2f	e7589b72-55e4-4f31-ae32-db80b9584870	{"host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1}	{}	2024-04-09 15:07:50.086418+00
febc5cd6-47f8-4483-a558-687ade8df363	Elixir.Trento.Clusters.Events.ClusterRollUpRequested	aa46dde8-e1a4-4d4a-96b9-360dbf61c661	2d9a603f-961e-4737-8a64-c4bd7a8dd6e0	{"version": 1, "snapshot": {"sid": null, "name": "netweaver_cluster", "type": "ascs_ers", "hosts": [], "health": "passing", "details": {"sap_systems": [{"sid": "NWD", "nodes": [{"name": "vmnwdev01", "roles": ["ascs"], "status": "Online", "resources": [{"id": "rsc_ip_NWD_ASCS00", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_fs_NWD_ASCS00", "role": "Started", "type": "ocf::heartbeat:Filesystem", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_sap_NWD_ASCS00", "role": "Started", "type": "ocf::heartbeat:SAPInstance", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_NWD_ASCS00", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {}, "filesystems": ["/usr/sap/NWD/ASCS00"], "virtual_ips": ["10.100.1.25"]}, {"name": "vmnwdev02", "roles": ["ers"], "status": "Online", "resources": [{"id": "rsc_ip_NWD_ERS10", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_fs_NWD_ERS10", "role": "Started", "type": "ocf::heartbeat:Filesystem", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_sap_NWD_ERS10", "role": "Started", "type": "ocf::heartbeat:SAPInstance", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_NWD_ERS10", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"runs_ers_NWD": "1"}, "filesystems": ["/usr/sap/NWD/ERS10"], "virtual_ips": ["10.100.1.26"]}], "distributed": true, "filesystem_resource_based": true}], "sbd_devices": [{"device": "/dev/disk/by-id/scsi-36001405f01eb5f4c5c941e499beb055d", "status": "healthy"}], "fencing_type": "external/sbd", "maintenance_mode": false, "stopped_resources": []}, "provider": "azure", "cluster_id": "5284f376-c1f4-5178-8966-d490df3dab4f", "rolling_up": false, "hosts_number": 2, "checks_health": "unknown", "additional_sids": ["NWD"], "deregistered_at": "2024-04-09T15:07:50.068043Z", "selected_checks": [], "resources_number": 9, "discovered_health": "passing"}, "cluster_id": "5284f376-c1f4-5178-8966-d490df3dab4f"}	{}	2024-04-09 15:07:50.095915+00
c2b4950c-7408-4e20-b7e1-2752618fb9ca	Elixir.Trento.Clusters.Events.ClusterRolledUp	72f93a0c-d61f-4f6f-88a3-55157159aeeb	82761355-267d-424b-968f-fefed33834a7	{"version": 1, "snapshot": {"sid": null, "name": "netweaver_cluster", "type": "ascs_ers", "hosts": [], "health": "passing", "details": {"sap_systems": [{"sid": "NWD", "nodes": [{"name": "vmnwdev01", "roles": ["ascs"], "status": "Online", "resources": [{"id": "rsc_ip_NWD_ASCS00", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_fs_NWD_ASCS00", "role": "Started", "type": "ocf::heartbeat:Filesystem", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_sap_NWD_ASCS00", "role": "Started", "type": "ocf::heartbeat:SAPInstance", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_NWD_ASCS00", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {}, "filesystems": ["/usr/sap/NWD/ASCS00"], "virtual_ips": ["10.100.1.25"]}, {"name": "vmnwdev02", "roles": ["ers"], "status": "Online", "resources": [{"id": "rsc_ip_NWD_ERS10", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_fs_NWD_ERS10", "role": "Started", "type": "ocf::heartbeat:Filesystem", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_sap_NWD_ERS10", "role": "Started", "type": "ocf::heartbeat:SAPInstance", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_NWD_ERS10", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"runs_ers_NWD": "1"}, "filesystems": ["/usr/sap/NWD/ERS10"], "virtual_ips": ["10.100.1.26"]}], "distributed": true, "filesystem_resource_based": true}], "sbd_devices": [{"device": "/dev/disk/by-id/scsi-36001405f01eb5f4c5c941e499beb055d", "status": "healthy"}], "fencing_type": "external/sbd", "maintenance_mode": false, "stopped_resources": []}, "provider": "azure", "cluster_id": "5284f376-c1f4-5178-8966-d490df3dab4f", "rolling_up": false, "hosts_number": 2, "checks_health": "unknown", "additional_sids": ["NWD"], "deregistered_at": "2024-04-09T15:07:50.068043Z", "selected_checks": [], "resources_number": 9, "discovered_health": "passing"}, "cluster_id": "5284f376-c1f4-5178-8966-d490df3dab4f"}	{}	2024-04-09 15:07:50.111145+00
ee3205b8-92cb-4d14-a51a-a9a6fd342715	Elixir.Trento.Hosts.Events.HostDeregistrationRequested	d8b1b646-77e7-47af-a8f0-27a2ab9ee59e	857674c4-5bfc-4126-838d-282b6d4bdbaf	{"host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1, "requested_at": "2024-04-09T15:07:52.747424Z"}	{}	2024-04-09 15:07:52.750678+00
0d277d94-e747-4682-bd6a-f307229cbf25	Elixir.Trento.SapSystems.Events.DatabaseInstanceDeregistered	e899caaf-d6f5-4aa6-a3a1-066a1135872d	857674c4-5bfc-4126-838d-282b6d4bdbaf	{"host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:07:52.747424Z", "instance_number": "10"}	{}	2024-04-09 15:07:52.762672+00
99da1ff9-616b-4127-961e-e8cbe610bf8d	Elixir.Trento.Clusters.Events.HostRemovedFromCluster	c13414d7-586c-433d-ad80-12a257de5aa7	857674c4-5bfc-4126-838d-282b6d4bdbaf	{"host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1, "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714", "deregistered_at": null}	{}	2024-04-09 15:07:52.766371+00
6c2b7b8f-777c-4450-a6d2-68bc01dbf409	Elixir.Trento.Hosts.Events.SoftwareUpdatesDiscoveryCleared	cbf612af-f6c1-4153-a0fd-c3b2eaa63c7d	857674c4-5bfc-4126-838d-282b6d4bdbaf	{"host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1}	{}	2024-04-09 15:07:52.76788+00
7dfb1bfa-5982-4ee1-91a7-6f37325e322a	Elixir.Trento.Hosts.Events.HostRollUpRequested	a02123f5-fcfa-42d0-bfa9-29b035fdf731	847f0273-5d7e-4c72-9d15-1fcfbfed6214	{"host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1, "snapshot": {"health": "unknown", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "hostname": "vmnwdev01", "provider": "azure", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.100.1.21", "10.100.1.25"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwdev01", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 0}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "warning", "saptune_status": null, "deregistered_at": "2024-04-09T15:07:50.068043Z", "selected_checks": [], "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwdev01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:07:50.119252+00
1c6c0025-681c-4fec-af38-31883690d71f	Elixir.Trento.Hosts.Events.HostRolledUp	14273ce7-8b16-4194-82b3-c1c262176354	ffa74916-fb01-49d3-a0b1-8aefecb16aff	{"host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1, "snapshot": {"health": "unknown", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "hostname": "vmnwdev01", "provider": "azure", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.100.1.21", "10.100.1.25"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwdev01", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 0}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "warning", "saptune_status": null, "deregistered_at": "2024-04-09T15:07:50.068043Z", "selected_checks": [], "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwdev01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:07:50.128627+00
afc84157-c2aa-47ff-930e-8f1c2d8177d4	Elixir.Trento.SapSystems.Events.DatabaseInstanceDeregistered	86f86c70-6dd6-44b0-afba-22dc9067c894	7dde8f03-a8bc-4979-a3d5-650b469ffe63	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:07:55.420830Z", "instance_number": "10"}	{}	2024-04-09 15:07:55.43347+00
8ae44d44-15d5-4d19-9ead-b5aa2a25781c	Elixir.Trento.SapSystems.Events.DatabaseDeregistered	86f86c70-6dd6-44b0-afba-22dc9067c894	7dde8f03-a8bc-4979-a3d5-650b469ffe63	{"version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:07:55.420830Z"}	{}	2024-04-09 15:07:55.433476+00
9bbebd30-54d6-4aa4-bf4f-a0bb959eda06	Elixir.Trento.SapSystems.Events.SapSystemTombstoned	86f86c70-6dd6-44b0-afba-22dc9067c894	7dde8f03-a8bc-4979-a3d5-650b469ffe63	{"version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c"}	{}	2024-04-09 15:07:55.433478+00
f2119f82-be66-4a78-bdda-d771ff1677da	Elixir.Trento.Hosts.Events.SoftwareUpdatesDiscoveryCleared	fbd6481e-99d4-45b7-a246-50e2fb7993eb	7dde8f03-a8bc-4979-a3d5-650b469ffe63	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1}	{}	2024-04-09 15:07:55.440353+00
5fc76516-10fe-4893-af4d-60b49de25013	Elixir.Trento.Hosts.Events.HostDeregistered	fbd6481e-99d4-45b7-a246-50e2fb7993eb	7dde8f03-a8bc-4979-a3d5-650b469ffe63	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "deregistered_at": "2024-04-09T15:07:55.420830Z"}	{}	2024-04-09 15:07:55.440361+00
d7fc273a-f804-439a-b203-23e2546f1d0e	Elixir.Trento.Hosts.Events.HostTombstoned	fbd6481e-99d4-45b7-a246-50e2fb7993eb	7dde8f03-a8bc-4979-a3d5-650b469ffe63	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1}	{}	2024-04-09 15:07:55.440364+00
3ef5e387-dd1e-4f36-a1d7-6c2238905b27	Elixir.Trento.Hosts.Events.HostRestored	4f42a26d-8599-43f8-a795-f3ce4c805703	b7f53c18-0857-4630-8a8e-60138c76494a	{"host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1}	{}	2024-04-09 15:08:26.502592+00
fdd6d212-3387-4b9f-858f-df0daf4e44b6	Elixir.Trento.SapSystems.Events.DatabaseInstanceMarkedAbsent	83e0df44-5bb9-492e-a982-2bf1795b0e1f	ca1487e0-5742-43eb-9379-a07655f3c59b	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "absent_at": "2024-04-09T15:08:42.021899Z", "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "10"}	{}	2024-04-09 15:08:42.037321+00
f2e2a42b-14e5-43c3-bccd-d2d6d894b9a6	Elixir.Trento.Hosts.Events.HostDeregistered	cbf612af-f6c1-4153-a0fd-c3b2eaa63c7d	857674c4-5bfc-4126-838d-282b6d4bdbaf	{"host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1, "deregistered_at": "2024-04-09T15:07:52.747424Z"}	{}	2024-04-09 15:07:52.767886+00
a23ab890-c2f3-4ddd-a2c9-6d77dffc2cc2	Elixir.Trento.Hosts.Events.HostTombstoned	cbf612af-f6c1-4153-a0fd-c3b2eaa63c7d	857674c4-5bfc-4126-838d-282b6d4bdbaf	{"host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1}	{}	2024-04-09 15:07:52.767888+00
fb1d79f3-df37-4bbf-817f-8e6aaa520b59	Elixir.Trento.Hosts.Events.HostDeregistrationRequested	7b2b04eb-0b23-45b6-940a-6ee2cf9aabb0	7dde8f03-a8bc-4979-a3d5-650b469ffe63	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "requested_at": "2024-04-09T15:07:55.420830Z"}	{}	2024-04-09 15:07:55.423428+00
6625812b-ee52-45cd-b480-42f33a8ce7fd	Elixir.Trento.Hosts.Events.HostRestored	01fcdaf7-191c-49fa-8913-247541829655	62bfcbb8-de55-433a-b96c-2393d65bfd8b	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1}	{}	2024-04-09 15:08:16.771512+00
3c1b70ae-d96f-481d-87a8-73a190e1f070	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	5f0fc18c-2766-46ec-bb22-75a35bdee20d	1e4eda74-d78c-4f9d-bd7d-5cf72a386ae8	{"host_id": "098fc159-3ed6-58e7-91be-38fda8a833ea", "version": 1, "saptune_health": "warning"}	{}	2024-04-09 15:08:17.283004+00
7dfc3283-9f25-4839-a36e-d636a386ae4f	Elixir.Trento.Clusters.Events.ClusterRestored	68961d7c-a37c-463a-8252-ef306fb0fcc4	35aadf7b-8403-46cd-905e-975c2b59d177	{"version": 1, "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714"}	{}	2024-04-09 15:08:20.752061+00
4b8048be-ea37-4306-9956-e387b5039880	Elixir.Trento.Clusters.Events.HostAddedToCluster	68961d7c-a37c-463a-8252-ef306fb0fcc4	35aadf7b-8403-46cd-905e-975c2b59d177	{"host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1, "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714"}	{}	2024-04-09 15:08:20.752068+00
e76eae8a-2642-4761-9d63-c88514d6a2b8	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	cfd5947f-f150-4839-bbd3-d1c9e0fd623e	049e2193-9a2e-4856-950f-f7ef40978be7	{"host_id": "4b30a6af-4b52-5bda-bccb-f2248a12c992", "version": 1, "saptune_health": "critical"}	{}	2024-04-09 15:08:21.000562+00
48d6557e-834d-432c-92c5-b599119da4b3	Elixir.Trento.Clusters.Events.ClusterRestored	47ecf94e-8ff4-4641-9b6f-f24f8d9411f6	f2a4153b-5ee7-4346-b47a-965bd59a4ddc	{"version": 1, "cluster_id": "5284f376-c1f4-5178-8966-d490df3dab4f"}	{}	2024-04-09 15:08:21.133742+00
5e53d685-f975-4956-986e-9735b44be01e	Elixir.Trento.Clusters.Events.HostAddedToCluster	47ecf94e-8ff4-4641-9b6f-f24f8d9411f6	f2a4153b-5ee7-4346-b47a-965bd59a4ddc	{"host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1, "cluster_id": "5284f376-c1f4-5178-8966-d490df3dab4f"}	{}	2024-04-09 15:08:21.133748+00
19412378-89b8-4f26-983d-dd56984b7cf2	Elixir.Trento.Clusters.Events.HostAddedToCluster	cc94b6bc-53a6-4ab5-931d-e67d9edfa046	72ada7bb-c088-4dc5-9ae2-cf81d7bd14ad	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714"}	{}	2024-04-09 15:08:25.404741+00
3b7d62af-18eb-46c5-9fc0-a8ff5a389856	Elixir.Trento.Hosts.Events.HostRestored	536ef7a9-2501-4186-b3bb-ca7977d3b2bf	fc0f37af-80e1-4bac-b7a7-02c8fdc2edef	{"host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1}	{}	2024-04-09 15:08:35.511464+00
d8daedb3-60a2-4483-a5d7-eb214647a996	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	2f6d9301-e5c8-4379-8521-257d0352e764	c3628987-95ba-4198-966a-6b80770a763e	{"sid": "NWD", "health": "passing", "host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1, "features": "MESSAGESERVER|ENQUE", "http_port": 50013, "https_port": 50014, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "start_priority": "1", "instance_number": "00", "instance_hostname": "sapnwdas"}	{}	2024-04-09 15:08:36.315627+00
b2595476-618a-4ad5-b4e0-1590c250e60b	Elixir.Trento.SapSystems.Events.SapSystemRestored	2f6d9301-e5c8-4379-8521-257d0352e764	c3628987-95ba-4198-966a-6b80770a763e	{"health": "passing", "tenant": "HDD", "db_host": "10.100.1.13", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c"}	{}	2024-04-09 15:08:36.315636+00
39400968-b74c-4cd6-a877-ba7a1c0239c5	Elixir.Trento.Hosts.Events.HostDeregistrationRequested	53d8e234-25f4-448c-a029-17460b884323	ba687193-8dd9-408e-b171-3db3f4e7908a	{"host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1, "requested_at": "2024-04-09T15:08:39.911707Z"}	{}	2024-04-09 15:08:39.91529+00
89066c17-3c5a-483c-b4da-11989e982e3f	Elixir.Trento.Clusters.Events.HostRemovedFromCluster	ae984b2e-778c-40a1-a45b-09661af35efb	ba687193-8dd9-408e-b171-3db3f4e7908a	{"host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1, "cluster_id": "fa0d74a3-9240-5d9e-99fa-61c4137acf81", "deregistered_at": null}	{}	2024-04-09 15:08:39.92432+00
048349ea-8056-4b1c-9581-b7a46bcef8fa	Elixir.Trento.Hosts.Events.HostRollUpRequested	d18d9c82-512b-4efc-8883-72ffda5cdc6e	144ca0a0-35e7-469d-b674-f80294b6dd31	{"host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1, "snapshot": {"health": "unknown", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "hostname": "vmhdbqas01", "provider": "azure", "cpu_count": 4, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.90.1.11", "10.90.1.13"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmhdbqas01", "vm_size": "Standard_E4s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 7}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "warning", "saptune_status": {"staging": null, "services": [], "tuning_state": null, "applied_notes": [], "enabled_notes": [], "package_version": "3.0.0", "applied_solution": null, "enabled_solution": null, "configured_version": null}, "deregistered_at": "2024-04-09T15:08:39.911707Z", "selected_checks": [], "total_memory_mb": 32107, "installation_source": "unknown", "fully_qualified_domain_name": "vmhdbqas01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:08:39.951251+00
e6657bcf-e63d-44ef-9799-7fe6ad56de4a	Elixir.Trento.Hosts.Events.HostDeregistrationRequested	3b3571a7-226f-47c5-9d98-22dc702a0265	a22bb7d9-ffbc-475d-a659-46eb9686de58	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "requested_at": "2024-04-09T15:08:41.597535Z"}	{}	2024-04-09 15:08:41.60014+00
48e65eab-a66a-4203-95b2-4ea898391aed	Elixir.Trento.Hosts.Events.HostRollUpRequested	922b10a1-fbd7-4142-a319-c2105cfbdb38	b278a903-9fc2-4224-8ff9-9fa0dd49372d	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "snapshot": {"health": "unknown", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "hostname": "vmnwqas01", "provider": "azure", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.90.1.21", "10.90.1.25"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwqas01", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 0}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "warning", "saptune_status": {"staging": null, "services": [], "tuning_state": null, "applied_notes": [], "enabled_notes": [], "package_version": "3.0.0", "applied_solution": null, "enabled_solution": null, "configured_version": null}, "deregistered_at": "2024-04-09T15:08:41.597535Z", "selected_checks": [], "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwqas01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:08:41.616731+00
225363c5-648a-4ac2-af78-0932be1603bd	Elixir.Trento.Hosts.Events.HostRollUpRequested	3de6c4dc-16fa-4720-afb9-d93ac68e00cc	e7e18f4a-f5bd-4fb5-9092-b125c042ba19	{"host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1, "snapshot": {"health": "unknown", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "hostname": "vmhdbdev02", "provider": "azure", "cpu_count": 4, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.100.1.12"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmhdbdev02", "vm_size": "Standard_E4s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 7}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "passing", "saptune_status": null, "deregistered_at": "2024-04-09T15:07:52.747424Z", "selected_checks": [], "total_memory_mb": 32107, "installation_source": "unknown", "fully_qualified_domain_name": "vmhdbdev02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:07:52.778014+00
7c2ded68-7c69-4724-9251-203493c9a41a	Elixir.Trento.Hosts.Events.HostRolledUp	8f3a7540-a049-4255-8193-5b503bc8b4cb	4a62e832-62cd-4a37-899d-726eb34dbd6b	{"host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1, "snapshot": {"health": "unknown", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "hostname": "vmhdbdev02", "provider": "azure", "cpu_count": 4, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.100.1.12"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmhdbdev02", "vm_size": "Standard_E4s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 7}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "passing", "saptune_status": null, "deregistered_at": "2024-04-09T15:07:52.747424Z", "selected_checks": [], "total_memory_mb": 32107, "installation_source": "unknown", "fully_qualified_domain_name": "vmhdbdev02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:07:52.789512+00
14d9c945-37d9-4814-84ad-b53b099ddd72	Elixir.Trento.SapSystems.Events.SapSystemRollUpRequested	1f4b0cde-0b9e-4475-8f7c-fc5de9193cc5	412bcadb-5586-48a9-859c-558e99ad06ce	{"version": 1, "snapshot": {"sid": "NWD", "health": "passing", "database": {"sid": "HDD", "health": "passing", "instances": [], "deregistered_at": "2024-04-09T15:07:55.420830Z"}, "rolling_up": false, "application": {"sid": "NWD", "instances": []}, "ensa_version": "ensa1", "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:07:44.714417Z"}, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c"}	{}	2024-04-09 15:07:55.452858+00
3e5f11c0-a98d-4428-a221-1f1f11c1f936	Elixir.Trento.Clusters.Events.ClusterRollUpRequested	d3edaeef-06ac-42cf-8c62-ac4e446a5187	f300f416-2016-4e71-996f-6d6ee865f022	{"version": 1, "snapshot": {"sid": "HDD", "name": "hana_cluster_1", "type": "hana_scale_up", "hosts": [], "health": "critical", "details": {"nodes": [{"name": "vmhdbdev01", "site": "NBG", "status": "Online", "resources": [{"id": "stonith-sbd", "role": "Started", "type": "stonith:external/sbd", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHanaTopology_HDD_HDB10", "role": "Started", "type": "ocf::suse:SAPHanaTopology", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"lpa_hdd_lpt": "10", "hana_hdd_site": "NBG", "hana_hdd_roles": "1:P:master1::worker:", "hana_hdd_vhost": "vmhdbdev01", "hana_hdd_srmode": "sync", "hana_hdd_op_mode": "logreplay", "hana_hdd_version": "2.00.057.00.1629894416", "hana_hdd_remoteHost": "vmhdbdev02", "hana_hdd_sync_state": "SFAIL", "hana_hdd_clone_state": "UNDEFINED", "master-rsc_SAPHana_HDD_HDB10": "-9000"}, "virtual_ip": null, "hana_status": "Failed", "nameserver_actual_role": null, "indexserver_actual_role": null}, {"name": "vmhdbdev02", "site": "WDF", "status": "Online", "resources": [{"id": "rsc_SAPHana_HDD_HDB10", "role": "Master", "type": "ocf::suse:SAPHana", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHanaTopology_HDD_HDB10", "role": "Started", "type": "ocf::suse:SAPHanaTopology", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_ip_HDD_HDB10", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_HDD_HDB10", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"lpa_hdd_lpt": "1643125026", "hana_hdd_site": "WDF", "hana_hdd_roles": "4:P:master1:master:worker:master", "hana_hdd_vhost": "vmhdbdev02", "hana_hdd_srmode": "sync", "hana_hdd_op_mode": "logreplay", "hana_hdd_version": "2.00.057.00.1629894416", "hana_hdd_remoteHost": "vmhdbdev01", "hana_hdd_sync_state": "PRIM", "hana_hdd_clone_state": "PROMOTED", "master-rsc_SAPHana_HDD_HDB10": "150"}, "virtual_ip": "10.100.1.13", "hana_status": "Primary", "nameserver_actual_role": "master", "indexserver_actual_role": "master"}], "sites": [{"name": "NBG", "state": "Failed", "sr_health_state": "1"}, {"name": "WDF", "state": "Primary", "sr_health_state": "4"}], "sbd_devices": [{"device": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:182cb1b1-a815-4b82-b538-7a166b9bbb4a", "status": "healthy"}], "fencing_type": "external/sbd", "sr_health_state": "1", "maintenance_mode": false, "stopped_resources": [{"id": "rsc_SAPHana_HDD_HDB10", "role": "Stopped", "type": "ocf::suse:SAPHana", "status": null, "managed": null, "fail_count": null}], "secondary_sync_state": "SFAIL", "system_replication_mode": "sync", "system_replication_operation_mode": "logreplay"}, "provider": "azure", "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714", "rolling_up": false, "hosts_number": 2, "checks_health": "unknown", "additional_sids": [], "deregistered_at": "2024-04-09T15:07:55.420830Z", "selected_checks": [], "resources_number": 7, "discovered_health": "critical"}, "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714"}	{}	2024-04-09 15:07:55.484024+00
62e9479c-0b19-435d-bc19-9b5ac1a4e801	Elixir.Trento.Clusters.Events.HostAddedToCluster	62297fa5-4d31-4a96-ac42-91c9ae6a1361	bac6957e-f3f6-4ce7-8488-098ef36e414a	{"host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1, "cluster_id": "5284f376-c1f4-5178-8966-d490df3dab4f"}	{}	2024-04-09 15:08:22.956553+00
e971b69a-9d65-4335-9837-c0817a183c40	Elixir.Trento.SapSystems.Events.DatabaseInstanceRegistered	c2847d4e-a1a7-4418-aa75-da1c762c9a1f	0c490c9b-ed1b-430c-8169-e8b5f41cdead	{"sid": "HDD", "health": "passing", "tenant": "HDD", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "features": "HDB|HDB_WORKER", "http_port": 51013, "https_port": 51014, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "start_priority": "0.3", "instance_number": "10", "instance_hostname": "vmhdbdev01", "system_replication": "Primary", "system_replication_status": "ACTIVE"}	{}	2024-04-09 15:08:27.03466+00
c05d1cb3-6de8-49a7-9332-31ecdb733b34	Elixir.Trento.SapSystems.Events.DatabaseRestored	c2847d4e-a1a7-4418-aa75-da1c762c9a1f	0c490c9b-ed1b-430c-8169-e8b5f41cdead	{"health": "passing", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c"}	{}	2024-04-09 15:08:27.034666+00
e376f76d-66bf-4407-ae73-f97d407be614	Elixir.Trento.SapSystems.Events.DatabaseInstanceRegistered	a6bf4962-8be3-4e47-b183-6c8c0cadd258	f885f13b-0d73-4601-a20c-10b278fc3dd2	{"sid": "HDD", "health": "passing", "tenant": "HDD", "host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1, "features": "HDB|HDB_WORKER", "http_port": 51013, "https_port": 51014, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "start_priority": "0.3", "instance_number": "10", "instance_hostname": "vmhdbdev02", "system_replication": "Secondary", "system_replication_status": null}	{}	2024-04-09 15:08:32.895241+00
b052acc6-5cc3-4db1-b416-a2eb03b8a926	Elixir.Trento.SapSystems.Events.DatabaseInstanceDeregistered	d7dc8f42-cbf0-40e4-b537-518598a7bda7	ba687193-8dd9-408e-b171-3db3f4e7908a	{"host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "deregistered_at": "2024-04-09T15:08:39.911707Z", "instance_number": "10"}	{}	2024-04-09 15:08:39.922375+00
f6237ef4-3e56-4caf-9386-39b4fb2de168	Elixir.Trento.SapSystems.Events.DatabaseDeregistered	d7dc8f42-cbf0-40e4-b537-518598a7bda7	ba687193-8dd9-408e-b171-3db3f4e7908a	{"version": 1, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "deregistered_at": "2024-04-09T15:08:39.911707Z"}	{}	2024-04-09 15:08:39.922381+00
cc8920c2-5ce4-4bf6-8e39-0686e5fb07aa	Elixir.Trento.SapSystems.Events.SapSystemDeregistered	d7dc8f42-cbf0-40e4-b537-518598a7bda7	ba687193-8dd9-408e-b171-3db3f4e7908a	{"version": 1, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "deregistered_at": "2024-04-09T15:08:39.911707Z"}	{}	2024-04-09 15:08:39.922384+00
dd96ae1f-45a8-46ca-960b-7d42da93cf81	Elixir.Trento.Clusters.Events.HostAddedToCluster	47bd666e-e29d-4c4a-8ae7-aa2d4a72dba3	4dfd71f4-8390-457e-b200-1b0b114f6011	{"host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1, "cluster_id": "fa0d74a3-9240-5d9e-99fa-61c4137acf81"}	{}	2024-04-09 15:08:40.83558+00
bc3037fa-96c0-4eb5-9404-5b7623c84a22	Elixir.Trento.Clusters.Events.HostRemovedFromCluster	ca975ce5-275f-42b6-aa86-8bf963f7cd08	7dde8f03-a8bc-4979-a3d5-650b469ffe63	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714", "deregistered_at": null}	{}	2024-04-09 15:07:55.43824+00
76d8bb54-727b-4051-8788-e29a980b5b16	Elixir.Trento.Clusters.Events.ClusterDeregistered	ca975ce5-275f-42b6-aa86-8bf963f7cd08	7dde8f03-a8bc-4979-a3d5-650b469ffe63	{"version": 1, "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714", "deregistered_at": "2024-04-09T15:07:55.420830Z"}	{}	2024-04-09 15:07:55.438249+00
e491428c-1aee-461e-89f6-4f06a26b2334	Elixir.Trento.Clusters.Events.ClusterTombstoned	ca975ce5-275f-42b6-aa86-8bf963f7cd08	7dde8f03-a8bc-4979-a3d5-650b469ffe63	{"version": 1, "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714"}	{}	2024-04-09 15:07:55.438252+00
950c44ab-6814-4e28-9627-6046523bce45	Elixir.Trento.SapSystems.Events.SapSystemRolledUp	c7e1aa07-e83f-4298-b1ec-f19cbf27547b	ac548eb9-2b94-4ed3-8d27-fbfb3f4e7979	{"version": 1, "snapshot": {"sid": "NWD", "health": "passing", "database": {"sid": "HDD", "health": "passing", "instances": [], "deregistered_at": "2024-04-09T15:07:55.420830Z"}, "rolling_up": false, "application": {"sid": "NWD", "instances": []}, "ensa_version": "ensa1", "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:07:44.714417Z"}, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c"}	{}	2024-04-09 15:07:55.476076+00
9458cafa-dbef-414e-a322-aa3b171e9b06	Elixir.Trento.Clusters.Events.ClusterRolledUp	84323cfb-aaf4-4cea-a422-1eec16944aa9	726114d9-30ea-4390-a048-9bd233608f3a	{"version": 1, "snapshot": {"sid": "HDD", "name": "hana_cluster_1", "type": "hana_scale_up", "hosts": [], "health": "critical", "details": {"nodes": [{"name": "vmhdbdev01", "site": "NBG", "status": "Online", "resources": [{"id": "stonith-sbd", "role": "Started", "type": "stonith:external/sbd", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHanaTopology_HDD_HDB10", "role": "Started", "type": "ocf::suse:SAPHanaTopology", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"lpa_hdd_lpt": "10", "hana_hdd_site": "NBG", "hana_hdd_roles": "1:P:master1::worker:", "hana_hdd_vhost": "vmhdbdev01", "hana_hdd_srmode": "sync", "hana_hdd_op_mode": "logreplay", "hana_hdd_version": "2.00.057.00.1629894416", "hana_hdd_remoteHost": "vmhdbdev02", "hana_hdd_sync_state": "SFAIL", "hana_hdd_clone_state": "UNDEFINED", "master-rsc_SAPHana_HDD_HDB10": "-9000"}, "virtual_ip": null, "hana_status": "Failed", "nameserver_actual_role": null, "indexserver_actual_role": null}, {"name": "vmhdbdev02", "site": "WDF", "status": "Online", "resources": [{"id": "rsc_SAPHana_HDD_HDB10", "role": "Master", "type": "ocf::suse:SAPHana", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHanaTopology_HDD_HDB10", "role": "Started", "type": "ocf::suse:SAPHanaTopology", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_ip_HDD_HDB10", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_HDD_HDB10", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"lpa_hdd_lpt": "1643125026", "hana_hdd_site": "WDF", "hana_hdd_roles": "4:P:master1:master:worker:master", "hana_hdd_vhost": "vmhdbdev02", "hana_hdd_srmode": "sync", "hana_hdd_op_mode": "logreplay", "hana_hdd_version": "2.00.057.00.1629894416", "hana_hdd_remoteHost": "vmhdbdev01", "hana_hdd_sync_state": "PRIM", "hana_hdd_clone_state": "PROMOTED", "master-rsc_SAPHana_HDD_HDB10": "150"}, "virtual_ip": "10.100.1.13", "hana_status": "Primary", "nameserver_actual_role": "master", "indexserver_actual_role": "master"}], "sites": [{"name": "NBG", "state": "Failed", "sr_health_state": "1"}, {"name": "WDF", "state": "Primary", "sr_health_state": "4"}], "sbd_devices": [{"device": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:182cb1b1-a815-4b82-b538-7a166b9bbb4a", "status": "healthy"}], "fencing_type": "external/sbd", "sr_health_state": "1", "maintenance_mode": false, "stopped_resources": [{"id": "rsc_SAPHana_HDD_HDB10", "role": "Stopped", "type": "ocf::suse:SAPHana", "status": null, "managed": null, "fail_count": null}], "secondary_sync_state": "SFAIL", "system_replication_mode": "sync", "system_replication_operation_mode": "logreplay"}, "provider": "azure", "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714", "rolling_up": false, "hosts_number": 2, "checks_health": "unknown", "additional_sids": [], "deregistered_at": "2024-04-09T15:07:55.420830Z", "selected_checks": [], "resources_number": 7, "discovered_health": "critical"}, "cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714"}	{}	2024-04-09 15:07:55.49861+00
94afbb52-adbe-401b-87c4-5418401df631	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	3b736282-a809-4a20-8c4c-d4415f7d000e	6a59e4d9-abe1-4b45-9ee3-e3aaee01e777	{"sid": "NWD", "health": "passing", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1, "features": "ENQREP", "http_port": 51013, "https_port": 51014, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "start_priority": "0.5", "instance_number": "10", "instance_hostname": "sapnwder"}	{}	2024-04-09 15:08:36.449334+00
d1799f71-3efb-4fba-9ea5-d61f7f368209	Elixir.Trento.SapSystems.Events.ApplicationInstanceDeregistered	91b509ce-0c64-4f76-b648-c74c3b785a85	a22bb7d9-ffbc-475d-a659-46eb9686de58	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "deregistered_at": "2024-04-09T15:08:41.597535Z", "instance_number": "00"}	{}	2024-04-09 15:08:41.605959+00
985742e7-f138-44e6-80c8-9bae62f4ae54	Elixir.Trento.SapSystems.Events.DatabaseInstanceMarkedPresent	ad36e64f-6251-45df-8988-534c49ec5f81	14cb9755-20f7-49fd-94be-79676e2cd8b9	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "10"}	{}	2024-04-09 15:08:42.313586+00
a3f3b8a9-ebb9-40f1-9d52-776faf12f776	Elixir.Trento.SapSystems.Events.DatabaseInstanceMarkedAbsent	4966f960-f963-485b-b2b7-ac435a094bb5	159b08b4-f358-465a-a020-cdbeefedf568	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "absent_at": "2024-04-09T15:08:42.601145Z", "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "10"}	{}	2024-04-09 15:08:42.606851+00
396fff0a-fc71-4e80-8a66-d27cc107e715	Elixir.Trento.Hosts.Events.HostRollUpRequested	cfa3f109-582d-446f-8716-c6769dfa3c93	0d7386a3-dcd5-4fdf-a78e-e087d1e5f041	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "snapshot": {"health": "unknown", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "hostname": "vmhdbdev01", "provider": "azure", "cpu_count": 4, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.100.1.11", "10.100.1.13"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmhdbdev01", "vm_size": "Standard_E4s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 7}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "warning", "saptune_status": null, "deregistered_at": "2024-04-09T15:07:55.420830Z", "selected_checks": [], "total_memory_mb": 32107, "installation_source": "unknown", "fully_qualified_domain_name": "vmhdbdev01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:07:55.504899+00
160d4374-8c70-453e-ac0c-59723f141597	Elixir.Trento.Hosts.Events.HostRolledUp	23caf6a0-99b8-46a0-bedb-00dfc4d41355	a773a914-3c52-4b0f-82b4-89f5cdf02bd5	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "snapshot": {"health": "unknown", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "hostname": "vmhdbdev01", "provider": "azure", "cpu_count": 4, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.100.1.11", "10.100.1.13"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmhdbdev01", "vm_size": "Standard_E4s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 7}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "warning", "saptune_status": null, "deregistered_at": "2024-04-09T15:07:55.420830Z", "selected_checks": [], "total_memory_mb": 32107, "installation_source": "unknown", "fully_qualified_domain_name": "vmhdbdev01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:07:55.513622+00
210ab3c4-6509-46f0-8ed5-5d9517d4a038	Elixir.Trento.Hosts.Events.HostRestored	902438ef-0566-44c4-b63a-0f566a1cd4c6	2832bc17-eaee-42bb-97cb-a48954f97d68	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1}	{}	2024-04-09 15:08:16.386512+00
8ccd0082-3076-483c-ad1b-f263b3e34883	Elixir.Trento.Hosts.Events.HostRestored	eae269da-4df5-43f3-b3bf-9fc654c949d0	f7338d4c-2e7c-43a1-9aaa-57ef6c82a03f	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1}	{}	2024-04-09 15:08:17.147208+00
da5e8259-b88d-4b26-b0c0-543f224e273e	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	aa292e2b-7dca-4ad0-b17a-09fb4582d80c	b9bb2034-e255-404d-8f67-c5acf596a6df	{"host_id": "a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12", "version": 1, "saptune_health": "critical"}	{}	2024-04-09 15:08:23.946026+00
c2c5e200-2cb4-434a-a3b1-b1bfb4004b8e	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	939a7abf-3b75-4702-b9c6-a15c30861e66	791da5ea-99e1-4142-b635-bf5eaa05d66a	{"sid": "NWD", "health": "passing", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "features": "ABAP|GATEWAY|ICMAN|IGS", "http_port": 50113, "https_port": 50114, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "start_priority": "3", "instance_number": "01", "instance_hostname": "sapnwdpas"}	{}	2024-04-09 15:08:28.587906+00
f7dd7f5f-aba7-48ce-b4d5-fb3cb0c81cc0	Elixir.Trento.Hosts.Events.HostRestored	565de230-2e63-4690-b578-e0736fb6a523	f394caee-351d-4699-a349-e7443db4d332	{"host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1}	{}	2024-04-09 15:08:36.185055+00
d0d57a4b-da1f-4168-81cc-3101c34a3596	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	495c16ea-b4f9-46d0-8115-eae3526729f9	43392867-de88-450e-bc23-d17ee7429f36	{"sid": "NWD", "health": "passing", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "features": "ABAP|GATEWAY|ICMAN|IGS", "http_port": 50213, "https_port": 50214, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "start_priority": "3", "instance_number": "02", "instance_hostname": "sapnwdaas1"}	{}	2024-04-09 15:08:36.594021+00
bea37245-bf57-4a18-9f0e-bb92d57a7f19	Elixir.Trento.Hosts.Events.SoftwareUpdatesDiscoveryCleared	da81430c-ad17-49b2-86e0-620e670f76d4	ba687193-8dd9-408e-b171-3db3f4e7908a	{"host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1}	{}	2024-04-09 15:08:39.928774+00
515eda9c-79c0-4ed8-819c-ab6681bb303a	Elixir.Trento.Hosts.Events.HostDeregistered	da81430c-ad17-49b2-86e0-620e670f76d4	ba687193-8dd9-408e-b171-3db3f4e7908a	{"host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1, "deregistered_at": "2024-04-09T15:08:39.911707Z"}	{}	2024-04-09 15:08:39.928785+00
05ea6309-3a62-484e-8177-332189e23038	Elixir.Trento.Hosts.Events.HostTombstoned	da81430c-ad17-49b2-86e0-620e670f76d4	ba687193-8dd9-408e-b171-3db3f4e7908a	{"host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1}	{}	2024-04-09 15:08:39.928792+00
beffa190-84a5-4698-a883-b1f2cff04b6c	Elixir.Trento.Hosts.Events.HostRolledUp	7f7edd25-386d-4d60-983b-da8590b988ad	5185205a-a4bb-4fd6-a6ce-2b50e0b3b1f3	{"host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1, "snapshot": {"health": "unknown", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "hostname": "vmhdbqas01", "provider": "azure", "cpu_count": 4, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.90.1.11", "10.90.1.13"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmhdbqas01", "vm_size": "Standard_E4s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 7}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "warning", "saptune_status": {"staging": null, "services": [], "tuning_state": null, "applied_notes": [], "enabled_notes": [], "package_version": "3.0.0", "applied_solution": null, "enabled_solution": null, "configured_version": null}, "deregistered_at": "2024-04-09T15:08:39.911707Z", "selected_checks": [], "total_memory_mb": 32107, "installation_source": "unknown", "fully_qualified_domain_name": "vmhdbqas01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:08:39.972362+00
83afc0c0-22f1-4031-8cc3-0ceeb8c552e5	Elixir.Trento.Hosts.Events.HostRestored	33efc053-a6c1-4a21-9131-8dbd0c6d52ba	77b44477-32ca-47eb-8cd1-2861b446c401	{"host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1}	{}	2024-04-09 15:08:40.364851+00
d52b49e0-c4ed-4cf5-bdd3-4603742e7733	Elixir.Trento.Clusters.Events.HostRemovedFromCluster	e0f57116-8dac-4f1a-a828-a86c9747bf2c	a22bb7d9-ffbc-475d-a659-46eb9686de58	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "cluster_id": "fb861bce-d212-56b5-8786-74afd6eb58cb", "deregistered_at": null}	{}	2024-04-09 15:08:41.607434+00
a3fbe1e2-d96a-4436-a14d-b14169f6f653	Elixir.Trento.SapSystems.Events.DatabaseInstanceRegistered	3c0822b7-6f5f-493a-a3cf-331aa21c9d5b	583ab7f5-c2fe-4027-a754-68155dabc56d	{"sid": "HDQ", "health": "passing", "tenant": "HDQ", "host_id": "99cf8a3a-48d6-57a4-b302-6e4482227ab6", "version": 1, "features": "HDB|HDB_WORKER", "http_port": 51013, "https_port": 51014, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "start_priority": "0.3", "instance_number": "10", "instance_hostname": "vmhdbqas01", "system_replication": "Primary", "system_replication_status": "ACTIVE"}	{}	2024-04-09 15:08:40.974428+00
a3adb218-b295-412f-bceb-7378e1109b76	Elixir.Trento.SapSystems.Events.DatabaseRestored	3c0822b7-6f5f-493a-a3cf-331aa21c9d5b	583ab7f5-c2fe-4027-a754-68155dabc56d	{"health": "passing", "version": 1, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff"}	{}	2024-04-09 15:08:40.974439+00
e9635334-7461-41c2-9ca3-7f8b06e415a0	Elixir.Trento.Hosts.Events.SoftwareUpdatesDiscoveryCleared	71e49117-55c2-4de2-82c0-3f1d790df119	a22bb7d9-ffbc-475d-a659-46eb9686de58	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1}	{}	2024-04-09 15:08:41.609734+00
f88ccc42-dbe2-4c6f-8420-49db2a0ab430	Elixir.Trento.Hosts.Events.HostDeregistered	71e49117-55c2-4de2-82c0-3f1d790df119	a22bb7d9-ffbc-475d-a659-46eb9686de58	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "deregistered_at": "2024-04-09T15:08:41.597535Z"}	{}	2024-04-09 15:08:41.609741+00
ddde0367-844c-409d-a3e8-9c6e568e33b0	Elixir.Trento.Hosts.Events.HostTombstoned	71e49117-55c2-4de2-82c0-3f1d790df119	a22bb7d9-ffbc-475d-a659-46eb9686de58	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1}	{}	2024-04-09 15:08:41.609743+00
46b101d6-5b13-4864-ae16-c97acaf35f8f	Elixir.Trento.Hosts.Events.HostRolledUp	62459197-2dd7-41cd-9490-84a836a9e405	0ca9ac0d-0262-4c52-a626-6e8a36f13488	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "snapshot": {"health": "unknown", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "hostname": "vmnwqas01", "provider": "azure", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.90.1.21", "10.90.1.25"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwqas01", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 0}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "warning", "saptune_status": {"staging": null, "services": [], "tuning_state": null, "applied_notes": [], "enabled_notes": [], "package_version": "3.0.0", "applied_solution": null, "enabled_solution": null, "configured_version": null}, "deregistered_at": "2024-04-09T15:08:41.597535Z", "selected_checks": [], "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwqas01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:08:41.629755+00
2b1dc300-37fb-429a-8d98-2c34a960e905	Elixir.Trento.SapSystems.Events.DatabaseInstanceDeregistered	8b02ba46-2b52-4edf-8f47-b408f53e36f2	41a089f4-884c-42d3-a9ea-e70cc5946621	{"host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:08:43.014652Z", "instance_number": "10"}	{}	2024-04-09 15:08:43.016707+00
aa7edd5c-a17e-47bb-b4ec-a748d5c79682	Elixir.Trento.SapSystems.Events.DatabaseDeregistered	8b02ba46-2b52-4edf-8f47-b408f53e36f2	41a089f4-884c-42d3-a9ea-e70cc5946621	{"version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:08:43.014652Z"}	{}	2024-04-09 15:08:43.016722+00
de96a398-876d-4626-a477-8636d2dcc726	Elixir.Trento.SapSystems.Events.SapSystemDeregistered	8b02ba46-2b52-4edf-8f47-b408f53e36f2	41a089f4-884c-42d3-a9ea-e70cc5946621	{"version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:08:43.014652Z"}	{}	2024-04-09 15:08:43.016724+00
c674dc9c-9263-4502-baf0-07b25b966ca0	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	886bb958-9589-4ce3-9268-99fed57ef5a9	55b75888-997f-4d1b-93a2-40034c254af7	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "saptune_health": "warning"}	{}	2024-04-09 15:09:12.053757+00
11326261-d0aa-4714-9373-d96ee950f96d	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	193d0b35-b745-4cca-831d-a3e843fe7f54	457cfbc3-b129-4c05-b787-b2ea76868cb9	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "saptune_health": "warning"}	{}	2024-04-09 15:09:16.299846+00
f0094c1c-4c26-4df1-911a-365bb916a56e	Elixir.Trento.Clusters.Events.HostAddedToCluster	4d7daafb-13ec-497e-be4b-4a1f239144ee	449e7161-b096-4651-bb71-022c29867ac6	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "cluster_id": "fb861bce-d212-56b5-8786-74afd6eb58cb"}	{}	2024-04-09 15:09:17.087755+00
8383bd9a-2f0b-466f-895f-8241ca31fdc3	Elixir.Trento.SapSystems.Events.DatabaseInstanceRegistered	95576c93-6b21-4c2f-aa1a-bbcd33983ec9	5466d6d1-01ba-470a-b157-7e044f82ed11	{"sid": "HDD", "health": "passing", "tenant": "HDD", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "features": "HDB|HDB_WORKER", "http_port": 51013, "https_port": 51014, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "start_priority": "0.3", "instance_number": "10", "instance_hostname": "vmhdbdev01", "system_replication": "Primary", "system_replication_status": "ACTIVE"}	{}	2024-04-09 15:09:20.652392+00
4fd530b0-51af-4f74-af97-17a2fb3b3b31	Elixir.Trento.SapSystems.Events.DatabaseRestored	95576c93-6b21-4c2f-aa1a-bbcd33983ec9	5466d6d1-01ba-470a-b157-7e044f82ed11	{"health": "passing", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c"}	{}	2024-04-09 15:09:20.652404+00
2cf67815-cc13-4856-a574-0702c2225212	Elixir.Trento.SapSystems.Events.SapSystemRestored	92c6994d-3960-4df3-85e5-195e660479da	5e719dfc-67ac-442b-95eb-155d434d29d3	{"health": "passing", "tenant": "HDD", "db_host": "10.100.1.13", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c"}	{}	2024-04-09 15:09:22.253104+00
fcea2eac-82c0-4764-82f1-85d9c9b30021	Elixir.Trento.Hosts.Events.HostSaptuneHealthChanged	95ccb44c-4342-4e42-89ab-eb11a911480a	b00e67cc-fd8b-4872-ac85-1aeb254c37ed	{"host_id": "0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4", "version": 1, "saptune_health": "warning"}	{}	2024-04-09 15:09:22.668145+00
3fc1982f-8a23-4cd0-9347-94a065992a39	Elixir.Trento.Hosts.Events.HostRestored	4ff34dfc-e39e-447d-8828-2dea54a12811	109d58a5-9528-483b-bff6-571dd4ca06b5	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1}	{}	2024-04-09 15:09:26.414184+00
bc8eff6b-e3a8-46ab-b368-e318769fac09	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	27d579ce-02e7-4033-bbd2-42fe42394d2a	7f008d16-d10a-4506-b24b-074f4b1b07d4	{"sid": "NWQ", "health": "passing", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "features": "MESSAGESERVER|ENQUE", "http_port": 50013, "https_port": 50014, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "start_priority": "1", "instance_number": "00", "instance_hostname": "sapnwqas"}	{}	2024-04-09 15:09:29.728207+00
8ccff23c-bd46-4995-847b-964eff8d829b	Elixir.Trento.SapSystems.Events.SapSystemRestored	27d579ce-02e7-4033-bbd2-42fe42394d2a	7f008d16-d10a-4506-b24b-074f4b1b07d4	{"health": "passing", "tenant": "HDQ", "db_host": "10.90.1.13", "version": 1, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff"}	{}	2024-04-09 15:09:29.728221+00
152ff5a3-5bb1-456d-9ced-4d6ee778fcc9	Elixir.Trento.SapSystems.Events.ApplicationInstanceHealthChanged	c7dad2c4-2954-432d-8c6d-e785fa17394c	5435f76c-c1a0-4e56-87b9-5552245432d8	{"health": "warning", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "01"}	{}	2024-04-09 15:09:46.706049+00
0b551622-73bd-4fab-803c-3e318eb64a4b	Elixir.Trento.SapSystems.Events.SapSystemHealthChanged	c7dad2c4-2954-432d-8c6d-e785fa17394c	5435f76c-c1a0-4e56-87b9-5552245432d8	{"health": "warning", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c"}	{}	2024-04-09 15:09:46.706057+00
ab71713a-e942-43e3-8af9-dc0d94bfd122	Elixir.Trento.SapSystems.Events.ApplicationInstanceHealthChanged	2435f512-913c-4dce-bbcf-acbaf126732a	20ed351d-ebd0-466e-b6fa-e2786ac6fd5c	{"health": "critical", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "02"}	{}	2024-04-09 15:09:47.451113+00
d5b32741-40e5-4b09-8fb2-dab8768384ca	Elixir.Trento.SapSystems.Events.SapSystemHealthChanged	2435f512-913c-4dce-bbcf-acbaf126732a	20ed351d-ebd0-466e-b6fa-e2786ac6fd5c	{"health": "critical", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c"}	{}	2024-04-09 15:09:47.451127+00
82799ef8-43d3-4022-b9c3-129c07ef9009	Elixir.Trento.SapSystems.Events.ApplicationInstanceHealthChanged	ad74e8e9-ed99-46c2-8b2f-00ff1bff22cf	91499f2e-4fa2-4054-a1c9-aeed887c906f	{"health": "unknown", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "10"}	{}	2024-04-09 15:09:48.216339+00
cfba53f1-0246-4bed-a670-d4bf7c09fe7a	Elixir.Trento.SapSystems.Events.SapSystemHealthChanged	ad74e8e9-ed99-46c2-8b2f-00ff1bff22cf	91499f2e-4fa2-4054-a1c9-aeed887c906f	{"health": "unknown", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c"}	{}	2024-04-09 15:09:48.216348+00
9f730a2f-e644-4004-a446-82df0121b1e4	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	b2283024-5540-4bc6-b7be-92a505e534f0	94a676d2-b937-4a30-8250-31c38c904b43	{"sid": "NWD", "health": "passing", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "features": "ABAP|GATEWAY|ICMAN|IGS", "http_port": 50213, "https_port": 50214, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "start_priority": "3", "instance_number": "02", "instance_hostname": "sapnwdaas1"}	{}	2024-04-09 15:09:50.556949+00
d10265ec-6905-4d28-9607-f709af6ea450	Elixir.Trento.Hosts.Events.HostDeregistrationRequested	f91820b4-1d55-4754-b627-1ecb08cba3cd	c4d50fef-8425-4f1e-ad5e-88fb8bdac888	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "requested_at": "2024-04-09T15:09:57.027722Z"}	{}	2024-04-09 15:09:57.03128+00
1c7f0f59-5465-44f9-95f8-763e157d7dc8	Elixir.Trento.Hosts.Events.SoftwareUpdatesDiscoveryCleared	313d7c40-7cd4-4390-91e3-b10467272c98	c4d50fef-8425-4f1e-ad5e-88fb8bdac888	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1}	{}	2024-04-09 15:09:57.052931+00
82183162-40ee-47f1-b1c8-28b728745507	Elixir.Trento.Hosts.Events.HostDeregistered	313d7c40-7cd4-4390-91e3-b10467272c98	c4d50fef-8425-4f1e-ad5e-88fb8bdac888	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "deregistered_at": "2024-04-09T15:09:57.027722Z"}	{}	2024-04-09 15:09:57.052938+00
563d4746-adf1-42dc-b9fe-8f26652b0a26	Elixir.Trento.Hosts.Events.HostTombstoned	313d7c40-7cd4-4390-91e3-b10467272c98	c4d50fef-8425-4f1e-ad5e-88fb8bdac888	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1}	{}	2024-04-09 15:09:57.05294+00
181f10fa-9a80-464c-814d-5b9beaf9a776	Elixir.Trento.Hosts.Events.HostDeregistrationRequested	b7a5daa9-e436-4a35-b350-06d2118f676d	51cfc415-60e3-47ee-872b-462c219ee7aa	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "requested_at": "2024-04-09T15:10:02.860179Z"}	{}	2024-04-09 15:10:02.863138+00
f9966a70-36be-465e-9f00-8e2a680468c1	Elixir.Trento.Hosts.Events.SoftwareUpdatesDiscoveryCleared	45262c91-e3ef-4915-842d-479e8d7f5759	51cfc415-60e3-47ee-872b-462c219ee7aa	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1}	{}	2024-04-09 15:10:02.875632+00
da238b51-dac3-4368-bdd6-f241f5b7b735	Elixir.Trento.Hosts.Events.HostDeregistered	45262c91-e3ef-4915-842d-479e8d7f5759	51cfc415-60e3-47ee-872b-462c219ee7aa	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "deregistered_at": "2024-04-09T15:10:02.860179Z"}	{}	2024-04-09 15:10:02.875645+00
3f11fbfe-d049-49f1-92bd-0d7b4b371437	Elixir.Trento.Hosts.Events.HostTombstoned	45262c91-e3ef-4915-842d-479e8d7f5759	51cfc415-60e3-47ee-872b-462c219ee7aa	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1}	{}	2024-04-09 15:10:02.875647+00
be2f0d42-84fd-49b7-8750-c8f99c60df0f	Elixir.Trento.Hosts.Events.HostRestored	eb626bde-e480-431a-ba98-be04550f27f1	e865c57d-b162-4285-b90e-25eb6ad1ad8a	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1}	{}	2024-04-09 15:10:09.680455+00
68dcfaa5-902a-41ea-949c-d26e0f5e7ba8	Elixir.Trento.Hosts.Events.HostRestored	675bd3c8-008b-4dda-b4b6-cf933788b6f0	fc7c6de4-fc6f-485e-8b15-34f4f1695b39	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1}	{}	2024-04-09 15:10:10.238737+00
4aee9659-2e0a-4fab-a5d8-07959c5d48c9	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	19dc2497-c68f-4b57-891e-dc1c6c4fc4b1	47695ece-1aae-4461-b683-a68511c5c466	{"sid": "NWD", "health": "passing", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "features": "ABAP|GATEWAY|ICMAN|IGS", "http_port": 50213, "https_port": 50214, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "start_priority": "3", "instance_number": "02", "instance_hostname": "sapnwdaas1"}	{}	2024-04-09 15:10:10.382859+00
fb3d4457-341c-4bc4-b6e4-264108a5a40e	Elixir.Trento.SapSystems.Events.SapSystemHealthChanged	19dc2497-c68f-4b57-891e-dc1c6c4fc4b1	47695ece-1aae-4461-b683-a68511c5c466	{"health": "critical", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c"}	{}	2024-04-09 15:10:10.382867+00
44c85031-e4d4-4921-a763-6dc8269cf978	Elixir.Trento.SapSystems.Events.ApplicationInstanceMarkedPresent	db582ecd-a9d8-4cbb-b896-042fc19047df	c84acde6-c2a2-48b5-b530-f78f0addeeb7	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "01"}	{}	2024-04-09 15:10:11.430052+00
f0dac76b-c1e3-4ecd-aa5a-908406d08ad7	Elixir.Trento.SapSystems.Events.ApplicationInstanceMarkedAbsent	bf7fd5ef-2310-4bec-baf8-fc97704716be	21159920-d455-4085-be19-74318cf6c8c4	{"host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1, "absent_at": "2024-04-09T15:10:12.349608Z", "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "00"}	{}	2024-04-09 15:10:12.355016+00
75447ca9-7577-479d-a199-3a243f246f46	Elixir.Trento.SapSystems.Events.ApplicationInstanceDeregistered	c9e57390-6fcc-41b5-b43f-1602f0177c0e	b651b6d4-d951-4f3d-abf5-e1eddf2d87c9	{"host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:10:12.695609Z", "instance_number": "00"}	{}	2024-04-09 15:10:12.697591+00
111408d0-10f8-4b44-8f11-08b5d9e53658	Elixir.Trento.SapSystems.Events.SapSystemDeregistered	c9e57390-6fcc-41b5-b43f-1602f0177c0e	b651b6d4-d951-4f3d-abf5-e1eddf2d87c9	{"version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:10:12.695609Z"}	{}	2024-04-09 15:10:12.697601+00
aaaf7250-b1e0-406b-b6cd-f20e93608a85	Elixir.Trento.SapSystems.Events.DatabaseInstanceHealthChanged	0d6d5d61-5050-4262-b699-bb86efa4c306	ae7d60aa-a78f-4fc5-85ac-6b29b4511bf3	{"health": "critical", "host_id": "13e8c25c-3180-5a9a-95c8-51ec38e50cfc", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "10"}	{}	2024-04-09 15:09:48.978414+00
386c0491-ea2a-4a28-9484-11558595d20e	Elixir.Trento.SapSystems.Events.DatabaseHealthChanged	0d6d5d61-5050-4262-b699-bb86efa4c306	ae7d60aa-a78f-4fc5-85ac-6b29b4511bf3	{"health": "critical", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c"}	{}	2024-04-09 15:09:48.978422+00
b7dff670-4e7b-4d92-9995-0838546c4f07	Elixir.Trento.Hosts.Events.HostDeregistrationRequested	08c5ba13-a237-4f3f-8378-2f40264fcd5d	30635395-b603-4f55-afa1-d10d17505713	{"host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": 1, "requested_at": "2024-04-09T15:09:51.521250Z"}	{}	2024-04-09 15:09:51.523812+00
ff5a9948-7f5c-4e75-8276-824337374869	Elixir.Trento.SapSystems.Events.DatabaseInstanceDeregistered	b8e7a747-439b-44e4-a5a3-43bbb8b32700	30635395-b603-4f55-afa1-d10d17505713	{"host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": 1, "sap_system_id": "6c9208eb-a5bb-57ef-be5c-6422dedab602", "deregistered_at": "2024-04-09T15:09:51.521250Z", "instance_number": "10"}	{}	2024-04-09 15:09:51.533395+00
8ea6fceb-9895-423e-a4eb-ef774eb8264d	Elixir.Trento.SapSystems.Events.DatabaseDeregistered	b8e7a747-439b-44e4-a5a3-43bbb8b32700	30635395-b603-4f55-afa1-d10d17505713	{"version": 1, "sap_system_id": "6c9208eb-a5bb-57ef-be5c-6422dedab602", "deregistered_at": "2024-04-09T15:09:51.521250Z"}	{}	2024-04-09 15:09:51.533402+00
da90ee43-74e3-4c9e-b1e7-0fcc069548d9	Elixir.Trento.SapSystems.Events.SapSystemDeregistered	b8e7a747-439b-44e4-a5a3-43bbb8b32700	30635395-b603-4f55-afa1-d10d17505713	{"version": 1, "sap_system_id": "6c9208eb-a5bb-57ef-be5c-6422dedab602", "deregistered_at": "2024-04-09T15:09:51.521250Z"}	{}	2024-04-09 15:09:51.533405+00
4ca0c802-bcc6-42d7-a6ea-06efa4ac8f76	Elixir.Trento.SapSystems.Events.ApplicationInstanceDeregistered	7d86b595-ea0c-495b-8fb6-7ec48c843b02	c4d50fef-8425-4f1e-ad5e-88fb8bdac888	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "deregistered_at": "2024-04-09T15:09:57.027722Z", "instance_number": "00"}	{}	2024-04-09 15:09:57.048022+00
13e17734-9d98-425a-bd7e-970412ed726f	Elixir.Trento.SapSystems.Events.SapSystemDeregistered	7d86b595-ea0c-495b-8fb6-7ec48c843b02	c4d50fef-8425-4f1e-ad5e-88fb8bdac888	{"version": 1, "sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "deregistered_at": "2024-04-09T15:09:57.027722Z"}	{}	2024-04-09 15:09:57.048028+00
834266af-ab34-42ad-ad08-fd490391fe82	Elixir.Trento.SapSystems.Events.ApplicationInstanceMarkedAbsent	37ac4aaf-0c07-4baa-8e40-8c5a089e9d87	eac8835f-8f3a-44b5-9473-d70377f3ae25	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "absent_at": "2024-04-09T15:10:11.702955Z", "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "01"}	{}	2024-04-09 15:10:11.708628+00
79648e9d-7bae-48a6-a8ee-25f275b58ef4	Elixir.Trento.SapSystems.Events.ApplicationInstanceMoved	505b35ce-cd2f-4847-b47b-7d8e1c60c2a3	12e271b5-36f2-45f8-9437-9e83cebf0b67	{"version": 1, "new_host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "old_host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "00"}	{}	2024-04-09 15:09:49.973301+00
da438df4-147e-4b2c-af23-0ee5b454d2c3	Elixir.Trento.SapSystems.Events.ApplicationInstanceHealthChanged	33896f2d-447e-44b0-9c26-1438bae9c31d	a4bb30aa-7331-4e27-968a-958754f9e223	{"health": "passing", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "01"}	{}	2024-04-09 15:09:50.553758+00
4a175f4d-f930-4b6e-b7ff-dddca617db8e	Elixir.Trento.SapSystems.Events.ApplicationInstanceDeregistered	1ef23430-e535-4347-868c-2ccede4d12a3	816f6b81-35b4-4ce6-a889-cad7362ed445	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:09:51.171553Z", "instance_number": "02"}	{}	2024-04-09 15:09:51.172936+00
01914ae8-6ea5-4580-bbe7-e0a828630dae	Elixir.Trento.Hosts.Events.HostRollUpRequested	91fa3e84-c7de-4215-9161-b6b9721e4d20	601c88f7-1094-4d0a-acbe-44afcbdb02d5	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "snapshot": {"health": "unknown", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "hostname": "vmnwqas01", "provider": "azure", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.90.1.21", "10.90.1.25"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwqas01", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 0}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "warning", "saptune_status": {"staging": null, "services": [], "tuning_state": null, "applied_notes": [], "enabled_notes": [], "package_version": "3.0.0", "applied_solution": null, "enabled_solution": null, "configured_version": null}, "deregistered_at": "2024-04-09T15:09:57.027722Z", "selected_checks": [], "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwqas01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:09:57.061855+00
2f66f649-5499-4479-99b7-c7f285c1c0ee	Elixir.Trento.Hosts.Events.SoftwareUpdatesDiscoveryCleared	31bfa568-2300-476c-8173-f474b557fc1a	0c468287-b2f5-4379-be20-2e53fbc2c948	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1}	{}	2024-04-09 15:10:02.529913+00
889c6bd9-766d-492e-af36-a7d43621ce83	Elixir.Trento.Hosts.Events.HostDeregistered	31bfa568-2300-476c-8173-f474b557fc1a	0c468287-b2f5-4379-be20-2e53fbc2c948	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "deregistered_at": "2024-04-09T15:10:02.515458Z"}	{}	2024-04-09 15:10:02.529919+00
2df78e0d-8912-4388-9ef3-b453994cae9c	Elixir.Trento.Hosts.Events.HostTombstoned	31bfa568-2300-476c-8173-f474b557fc1a	0c468287-b2f5-4379-be20-2e53fbc2c948	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1}	{}	2024-04-09 15:10:02.529921+00
18aa48e4-c4f2-4b8e-8ace-0aa41249b0d1	Elixir.Trento.SapSystems.Events.ApplicationInstanceDeregistered	334a4beb-2c5f-46cb-99b5-8423a26cf522	15c8933a-c51c-415d-8d91-2ce6baea1320	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:10:12.054079Z", "instance_number": "01"}	{}	2024-04-09 15:10:12.056137+00
9c2274f4-8c34-4f88-864d-9d60b9baa4e7	Elixir.Trento.SapSystems.Events.ApplicationInstanceHealthChanged	b7e47db7-a8f2-4570-b897-47b8739acc89	d023ed37-f4e1-4feb-956f-802645596dbf	{"health": "passing", "host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "10"}	{}	2024-04-09 15:09:49.977311+00
2d045869-7d42-4f8b-b6ba-36706786a0fd	Elixir.Trento.SapSystems.Events.SapSystemHealthChanged	b7e47db7-a8f2-4570-b897-47b8739acc89	d023ed37-f4e1-4feb-956f-802645596dbf	{"health": "critical", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c"}	{}	2024-04-09 15:09:49.977317+00
61453356-fd61-4ece-bad2-cce36f65570c	Elixir.Trento.Clusters.Events.HostRemovedFromCluster	8b47ed68-412f-4f48-9f7a-43e11d40897f	30635395-b603-4f55-afa1-d10d17505713	{"host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": 1, "cluster_id": "469e7be5-4e20-5007-b044-c6f540a87493", "deregistered_at": null}	{}	2024-04-09 15:09:51.534963+00
b10d5dae-1796-4d46-9c7e-a5540bc8f815	Elixir.Trento.Hosts.Events.HostRollUpRequested	a7a65453-7848-42af-a459-3e76284e94c0	4930dc2c-2858-4015-b3fb-f375ee5485c9	{"host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": 1, "snapshot": {"health": "unknown", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "hostname": "vmhdbprd01", "provider": "azure", "cpu_count": 4, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.80.1.11", "10.80.1.13"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmhdbprd01", "vm_size": "Standard_E4s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 7}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "passing", "saptune_status": {"staging": {"notes": [], "enabled": false, "solutions_ids": []}, "services": [{"name": "sapconf", "active": null, "enabled": null}, {"name": "saptune", "active": "active", "enabled": "enabled"}, {"name": "tuned", "active": null, "enabled": null}], "tuning_state": "compliant", "applied_notes": [{"id": "941735", "additionally_enabled": false}, {"id": "1771258", "additionally_enabled": false}, {"id": "1868829", "additionally_enabled": false}, {"id": "1980196", "additionally_enabled": false}, {"id": "2578899", "additionally_enabled": false}, {"id": "2684254", "additionally_enabled": false}, {"id": "2382421", "additionally_enabled": false}, {"id": "2534844", "additionally_enabled": false}, {"id": "2993054", "additionally_enabled": false}, {"id": "1656250", "additionally_enabled": false}], "enabled_notes": [{"id": "941735", "additionally_enabled": false}, {"id": "1771258", "additionally_enabled": false}, {"id": "1868829", "additionally_enabled": false}, {"id": "1980196", "additionally_enabled": false}, {"id": "2578899", "additionally_enabled": false}, {"id": "2684254", "additionally_enabled": false}, {"id": "2382421", "additionally_enabled": false}, {"id": "2534844", "additionally_enabled": false}, {"id": "2993054", "additionally_enabled": false}, {"id": "1656250", "additionally_enabled": false}], "package_version": "3.1.0", "applied_solution": {"id": "HANA", "notes": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "partial": false}, "enabled_solution": {"id": "HANA", "notes": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "partial": false}, "configured_version": "3"}, "deregistered_at": "2024-04-09T15:09:51.521250Z", "selected_checks": [], "total_memory_mb": 32107, "installation_source": "unknown", "fully_qualified_domain_name": "vmhdbprd01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:09:51.556278+00
e135273a-81b8-481d-9640-203738865343	Elixir.Trento.Clusters.Events.HostRemovedFromCluster	b67fefa7-7c58-48c1-b5b3-699153f0ac92	c4d50fef-8425-4f1e-ad5e-88fb8bdac888	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "cluster_id": "fb861bce-d212-56b5-8786-74afd6eb58cb", "deregistered_at": null}	{}	2024-04-09 15:09:57.05086+00
14c5423f-175f-4532-90c6-ce41fb1ded32	Elixir.Trento.Hosts.Events.HostDeregistrationRequested	15e5d0a8-f926-4304-8872-e9c14219c3ed	0c468287-b2f5-4379-be20-2e53fbc2c948	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "requested_at": "2024-04-09T15:10:02.515458Z"}	{}	2024-04-09 15:10:02.517863+00
b28e1a73-568d-4298-a44c-a1ef5f2918a9	Elixir.Trento.SapSystems.Events.ApplicationInstanceDeregistered	a7974c6a-347e-4da2-8259-31fe07d8b7f5	0c468287-b2f5-4379-be20-2e53fbc2c948	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:10:02.515458Z", "instance_number": "01"}	{}	2024-04-09 15:10:02.528454+00
ab344a93-6031-493c-8812-19bf3ffec863	Elixir.Trento.Hosts.Events.HostRollUpRequested	5bd4733c-e5c2-4e5a-8f5c-3a5860e6adc3	3aff6db2-3e25-4276-8425-39c4849ee09d	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "snapshot": {"health": "unknown", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "hostname": "vmnwdev04", "provider": "azure", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.100.1.24", "10.100.1.28"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwdev04", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "warning", "saptune_status": null, "deregistered_at": "2024-04-09T15:10:02.860179Z", "selected_checks": [], "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwdev04.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:10:02.884142+00
c3643824-b445-4ba5-9c63-23e81db706ee	Elixir.Trento.SapSystems.Events.ApplicationInstanceMoved	745245f0-0df8-43f2-a694-f1c5614e5201	0a6638cb-5e83-4f64-833d-e969cb64c1ac	{"version": 1, "new_host_id": "7269ee51-5007-5849-aaa7-7c4a98b0c9ce", "old_host_id": "fb2c6b8a-9915-5969-a6b7-8b5a42de1971", "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "00"}	{}	2024-04-09 15:09:50.301367+00
bce5e0bb-8741-4459-9610-b6ef2f208d44	Elixir.Trento.SapSystems.Events.ApplicationInstanceMarkedAbsent	0c23f011-6cff-4f04-9b9f-070ce85b0eb5	91c114fb-86be-4d00-88d7-99558ebce45c	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "absent_at": "2024-04-09T15:09:50.822488Z", "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "02"}	{}	2024-04-09 15:09:50.829834+00
9438599e-48bb-407b-96c3-4faf5d76e507	Elixir.Trento.Hosts.Events.SoftwareUpdatesDiscoveryCleared	243fb2eb-4f3f-4757-b80e-a8565cb8abbd	30635395-b603-4f55-afa1-d10d17505713	{"host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": 1}	{}	2024-04-09 15:09:51.537093+00
3c4944f4-3ae8-4d71-bbfd-58fb70897f9b	Elixir.Trento.Hosts.Events.HostDeregistered	243fb2eb-4f3f-4757-b80e-a8565cb8abbd	30635395-b603-4f55-afa1-d10d17505713	{"host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": 1, "deregistered_at": "2024-04-09T15:09:51.521250Z"}	{}	2024-04-09 15:09:51.537099+00
7ff9c6c5-bd70-462d-8593-774bfdb31d58	Elixir.Trento.Hosts.Events.HostTombstoned	243fb2eb-4f3f-4757-b80e-a8565cb8abbd	30635395-b603-4f55-afa1-d10d17505713	{"host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": 1}	{}	2024-04-09 15:09:51.53711+00
1022a58d-ed49-4563-b987-44867ecb5147	Elixir.Trento.Hosts.Events.HostRolledUp	b4271336-5c0a-4d42-ad1d-166b89bfebf9	1156a90d-4c84-408e-b483-1a5efa16aadc	{"host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": 1, "snapshot": {"health": "unknown", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "hostname": "vmhdbprd01", "provider": "azure", "cpu_count": 4, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.80.1.11", "10.80.1.13"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmhdbprd01", "vm_size": "Standard_E4s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 7}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9cd46919-5f19-59aa-993e-cf3736c71053", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "passing", "saptune_status": {"staging": {"notes": [], "enabled": false, "solutions_ids": []}, "services": [{"name": "sapconf", "active": null, "enabled": null}, {"name": "saptune", "active": "active", "enabled": "enabled"}, {"name": "tuned", "active": null, "enabled": null}], "tuning_state": "compliant", "applied_notes": [{"id": "941735", "additionally_enabled": false}, {"id": "1771258", "additionally_enabled": false}, {"id": "1868829", "additionally_enabled": false}, {"id": "1980196", "additionally_enabled": false}, {"id": "2578899", "additionally_enabled": false}, {"id": "2684254", "additionally_enabled": false}, {"id": "2382421", "additionally_enabled": false}, {"id": "2534844", "additionally_enabled": false}, {"id": "2993054", "additionally_enabled": false}, {"id": "1656250", "additionally_enabled": false}], "enabled_notes": [{"id": "941735", "additionally_enabled": false}, {"id": "1771258", "additionally_enabled": false}, {"id": "1868829", "additionally_enabled": false}, {"id": "1980196", "additionally_enabled": false}, {"id": "2578899", "additionally_enabled": false}, {"id": "2684254", "additionally_enabled": false}, {"id": "2382421", "additionally_enabled": false}, {"id": "2534844", "additionally_enabled": false}, {"id": "2993054", "additionally_enabled": false}, {"id": "1656250", "additionally_enabled": false}], "package_version": "3.1.0", "applied_solution": {"id": "HANA", "notes": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "partial": false}, "enabled_solution": {"id": "HANA", "notes": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "partial": false}, "configured_version": "3"}, "deregistered_at": "2024-04-09T15:09:51.521250Z", "selected_checks": [], "total_memory_mb": 32107, "installation_source": "unknown", "fully_qualified_domain_name": "vmhdbprd01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:09:51.569419+00
83354969-50b5-4f85-a629-f68dcdd69ec5	Elixir.Trento.Hosts.Events.HostRolledUp	83328084-f553-4966-84cd-44f538b7d1e0	e5492b4a-d25b-4bda-91a7-14b492ea1939	{"host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": 1, "snapshot": {"health": "unknown", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "hostname": "vmnwqas01", "provider": "azure", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.90.1.21", "10.90.1.25"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwqas01", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 0}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "25677e37-fd33-5005-896c-9275b1284534", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "warning", "saptune_status": {"staging": null, "services": [], "tuning_state": null, "applied_notes": [], "enabled_notes": [], "package_version": "3.0.0", "applied_solution": null, "enabled_solution": null, "configured_version": null}, "deregistered_at": "2024-04-09T15:09:57.027722Z", "selected_checks": [], "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwqas01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:09:57.076403+00
250ba22f-b38e-4bcf-a23f-efefb5d668cc	Elixir.Trento.Hosts.Events.HostRollUpRequested	21a2841a-98e9-4d47-8b0f-1c1b74b25523	75c6b24d-25dc-4fb5-880b-b539539fc994	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "snapshot": {"health": "unknown", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "hostname": "vmnwdev03", "provider": "azure", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.100.1.23", "10.100.1.27"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwdev03", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "warning", "saptune_status": null, "deregistered_at": "2024-04-09T15:10:02.515458Z", "selected_checks": [], "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwdev03.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:10:02.550226+00
caac845d-693b-4c29-8e4d-3dcbe8e6e8aa	Elixir.Trento.Hosts.Events.HostRolledUp	63682ad0-0a37-468c-b9cc-bf274cffda83	5eb75781-6cc9-41e1-b39f-e05f3edd7bd5	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "snapshot": {"health": "unknown", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "hostname": "vmnwdev03", "provider": "azure", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.100.1.23", "10.100.1.27"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwdev03", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "warning", "saptune_status": null, "deregistered_at": "2024-04-09T15:10:02.515458Z", "selected_checks": [], "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwdev03.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:10:02.563147+00
0447f2f8-ad37-449a-ad6f-14ea02cfe1c7	Elixir.Trento.SapSystems.Events.ApplicationInstanceDeregistered	cbc3ada7-7892-4007-aa9d-85276411b61e	51cfc415-60e3-47ee-872b-462c219ee7aa	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:10:02.860179Z", "instance_number": "02"}	{}	2024-04-09 15:10:02.873728+00
630cc41d-0488-40ab-a1e6-7cf6cf16f2ce	Elixir.Trento.SapSystems.Events.SapSystemDeregistered	cbc3ada7-7892-4007-aa9d-85276411b61e	51cfc415-60e3-47ee-872b-462c219ee7aa	{"version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "deregistered_at": "2024-04-09T15:10:02.860179Z"}	{}	2024-04-09 15:10:02.873736+00
56a4d480-8e93-420f-bd96-9a13159e106e	Elixir.Trento.Hosts.Events.HostRolledUp	33935ca3-6069-4a07-bb86-2b20b625478f	3675d1fb-7acd-4079-a2c6-08bcda6b3be8	{"host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": 1, "snapshot": {"health": "unknown", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "hostname": "vmnwdev04", "provider": "azure", "cpu_count": 2, "heartbeat": "unknown", "os_version": "15-SP3", "rolling_up": false, "ip_addresses": ["10.100.1.24", "10.100.1.28"], "socket_count": 1, "agent_version": "2.1.0", "checks_health": "unknown", "provider_data": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "vm_name": "vmnwdev04", "vm_size": "Standard_D2s_v3", "location": "westeurope", "admin_username": "cloudadmin", "resource_group": "resourceGroupName", "data_disk_number": 1}, "subscriptions": [{"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-basesystem", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-desktop-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-server-applications", "subscription_status": null}, {"arch": "x86_64", "type": "internal", "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-sap-applications", "subscription_status": null}, {"arch": "x86_64", "type": null, "status": "Registered", "host_id": "1b0e9297-97dd-55d6-9874-8efde4d84c90", "version": "15.3", "starts_at": null, "expires_at": null, "identifier": "sle-module-public-cloud", "subscription_status": null}], "saptune_health": "warning", "saptune_status": null, "deregistered_at": "2024-04-09T15:10:02.860179Z", "selected_checks": [], "total_memory_mb": 7951, "installation_source": "unknown", "fully_qualified_domain_name": "vmnwdev04.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net", "software_updates_discovery_health": "unknown"}}	{}	2024-04-09 15:10:02.897647+00
3b07d2cc-7062-483c-9977-dcbc4b4e4767	Elixir.Trento.SapSystems.Events.ApplicationInstanceRegistered	9326ec1d-7fc3-4d1f-96cd-6046c97e153f	997d7125-08c7-4ba6-9f8c-f03e3fb4bb03	{"sid": "NWD", "health": "passing", "host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "features": "ABAP|GATEWAY|ICMAN|IGS", "http_port": 50113, "https_port": 50114, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "start_priority": "3", "instance_number": "01", "instance_hostname": "sapnwdpas"}	{}	2024-04-09 15:10:09.8242+00
71a556bd-6328-46d3-b14c-dc9dea0cd454	Elixir.Trento.SapSystems.Events.SapSystemRestored	9326ec1d-7fc3-4d1f-96cd-6046c97e153f	997d7125-08c7-4ba6-9f8c-f03e3fb4bb03	{"health": "passing", "tenant": "HDD", "db_host": "10.100.1.13", "version": 1, "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c"}	{}	2024-04-09 15:10:09.824208+00
06a64bf3-7453-4ad7-83a4-9b669e1c605c	Elixir.Trento.SapSystems.Events.ApplicationInstanceMarkedAbsent	3f699450-2582-4d2e-817d-60a159cf0330	cf9699ef-7867-4d39-94b4-2479bba2f845	{"host_id": "9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f", "version": 1, "absent_at": "2024-04-09T15:10:11.166022Z", "sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "01"}	{}	2024-04-09 15:10:11.171863+00
\.


--
-- Data for Name: schema_migrations; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.schema_migrations (major_version, minor_version, patch_version, migrated_at) FROM stdin;
1	3	2	2024-04-09 15:05:24.895599+00
\.


--
-- Data for Name: snapshots; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.snapshots (source_uuid, source_version, source_type, data, metadata, created_at) FROM stdin;
"deregistration_process_manager"-"9a26b6d0-6e72-597c-9fe5-152a6875f214"	2	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": null, "database_instances": [], "application_instances": []}	\N	2024-04-09 15:06:55.889368+00
"deregistration_process_manager"-"21de186a-e38f-5804-b643-7f4ef22fecfd"	32	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": "6bd7ec60-8cb1-5c6b-a892-29e1fd2f8380", "database_instances": [], "application_instances": []}	\N	2024-04-09 15:07:00.944951+00
"deregistration_process_manager"-"422686d6-b2d1-5092-93e8-a744854f5085"	39	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": "8a66f8fb-5fe9-51b3-a34c-24321271a4e3", "database_instances": [], "application_instances": []}	\N	2024-04-09 15:06:58.688552+00
"deregistration_process_manager"-"240f96b1-8d26-53b7-9e99-ffb0f2e735bf"	97	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": "6bd7ec60-8cb1-5c6b-a892-29e1fd2f8380", "database_instances": [], "application_instances": []}	\N	2024-04-09 15:07:00.823102+00
"deregistration_process_manager"-"69f4dcbb-efa2-5a16-8bc8-01df7dbb7384"	52	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": null, "database_instances": [], "application_instances": []}	\N	2024-04-09 15:07:05.427158+00
"deregistration_process_manager"-"927901fa-2c87-524e-b18c-3ef5187f504f"	69	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": "c7a1e943-bf46-590b-bd26-bfc7c78def97", "database_instances": [], "application_instances": []}	\N	2024-04-09 15:06:59.488628+00
"deregistration_process_manager"-"e0c182db-32ff-55c6-a9eb-2b82dd21bc8b"	143	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": "fa0d74a3-9240-5d9e-99fa-61c4137acf81", "database_instances": [{"sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "instance_number": "10"}], "application_instances": []}	\N	2024-04-09 15:07:02.398591+00
"deregistration_process_manager"-"ddcb7992-2ffb-5c10-8b39-80685f6eaaba"	80	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": "8a66f8fb-5fe9-51b3-a34c-24321271a4e3", "database_instances": [], "application_instances": []}	\N	2024-04-09 15:07:08.15118+00
"deregistration_process_manager"-"a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12"	157	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": null, "database_instances": [], "application_instances": [{"sap_system_id": "6c9208eb-a5bb-57ef-be5c-6422dedab602", "instance_number": "01"}]}	\N	2024-04-09 15:06:58.433408+00
"deregistration_process_manager"-"116d49bd-85e1-5e59-b820-83f66db8800c"	109	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": "0eac831a-aa66-5f45-89a4-007fbd2c5714", "database_instances": [], "application_instances": [{"sap_system_id": "6c9208eb-a5bb-57ef-be5c-6422dedab602", "instance_number": "00"}]}	\N	2024-04-09 15:06:59.027486+00
"deregistration_process_manager"-"4b30a6af-4b52-5bda-bccb-f2248a12c992"	175	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": "0eac831a-aa66-5f45-89a4-007fbd2c5714", "database_instances": [], "application_instances": [{"sap_system_id": "6c9208eb-a5bb-57ef-be5c-6422dedab602", "instance_number": "10"}]}	\N	2024-04-09 15:06:57.271062+00
"deregistration_process_manager"-"a09d9cf3-46c1-505c-8fb8-4b0a71a9114e"	92	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": "c7a1e943-bf46-590b-bd26-bfc7c78def97", "database_instances": [], "application_instances": []}	\N	2024-04-09 15:07:07.205547+00
"deregistration_process_manager"-"098fc159-3ed6-58e7-91be-38fda8a833ea"	158	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": null, "database_instances": [], "application_instances": [{"sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "instance_number": "01"}]}	\N	2024-04-09 15:07:01.72593+00
"deregistration_process_manager"-"3711ea88-9ccc-5b07-8f9d-042be449d72b"	122	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": "fb861bce-d212-56b5-8786-74afd6eb58cb", "database_instances": [], "application_instances": [{"sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "instance_number": "10"}]}	\N	2024-04-09 15:07:09.076543+00
"deregistration_process_manager"-"f0c808b3-d869-5192-a944-20f66a6a8449"	86	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": null, "database_instances": [], "application_instances": []}	\N	2024-04-09 15:07:10.404505+00
"deregistration_process_manager"-"0fc07435-7ee2-54ca-b0de-fb27ffdc5deb"	107	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": null, "database_instances": [], "application_instances": [{"sap_system_id": "6c9208eb-a5bb-57ef-be5c-6422dedab602", "instance_number": "02"}]}	\N	2024-04-09 15:07:10.280092+00
"deregistration_process_manager"-"b767b3e9-e802-587e-a442-541d093b86b9"	167	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": "469e7be5-4e20-5007-b044-c6f540a87493", "database_instances": [{"sap_system_id": "6c9208eb-a5bb-57ef-be5c-6422dedab602", "instance_number": "10"}], "application_instances": []}	\N	2024-04-09 15:06:57.129192+00
"deregistration_process_manager"-"81e9b629-c1e7-538f-bff1-47d3a6580522"	113	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": null, "database_instances": [], "application_instances": [{"sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "instance_number": "02"}]}	\N	2024-04-09 15:07:12.492386+00
"deregistration_process_manager"-"25677e37-fd33-5005-896c-9275b1284534"	343	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": null, "database_instances": [], "application_instances": []}	\N	2024-04-09 15:09:57.082144+00
"deregistration_process_manager"-"99cf8a3a-48d6-57a4-b302-6e4482227ab6"	283	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": "fa0d74a3-9240-5d9e-99fa-61c4137acf81", "database_instances": [{"sap_system_id": "cd52e571-c897-5bba-b0f9-e155ceca1fff", "instance_number": "10"}], "application_instances": []}	\N	2024-04-09 15:08:39.985761+00
"deregistration_process_manager"-"13e8c25c-3180-5a9a-95c8-51ec38e50cfc"	302	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714", "database_instances": [{"sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "10"}], "application_instances": []}	\N	2024-04-09 15:07:55.523325+00
"deregistration_process_manager"-"0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4"	264	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": "7965f822-0254-5858-abca-f6e8b4c27714", "database_instances": [{"sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "10"}], "application_instances": []}	\N	2024-04-09 15:07:52.794716+00
"deregistration_process_manager"-"fb2c6b8a-9915-5969-a6b7-8b5a42de1971"	269	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": "5284f376-c1f4-5178-8966-d490df3dab4f", "database_instances": [], "application_instances": [{"sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "10"}]}	\N	2024-04-09 15:07:47.315621+00
"deregistration_process_manager"-"1b0e9297-97dd-55d6-9874-8efde4d84c90"	363	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": null, "database_instances": [], "application_instances": [{"sap_system_id": "f534a4ad-cef7-5234-b196-e67082ffb50c", "instance_number": "02"}]}	\N	2024-04-09 15:10:02.903618+00
"deregistration_process_manager"-"9cd46919-5f19-59aa-993e-cf3736c71053"	334	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": null, "database_instances": [], "application_instances": []}	\N	2024-04-09 15:09:51.57538+00
"deregistration_process_manager"-"9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f"	368	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": null, "database_instances": [], "application_instances": []}	\N	2024-04-09 15:10:02.568973+00
"deregistration_process_manager"-"7269ee51-5007-5849-aaa7-7c4a98b0c9ce"	370	Elixir.Trento.Infrastructure.Commanded.ProcessManagers.DeregistrationProcessManager	{"cluster_id": "5284f376-c1f4-5178-8966-d490df3dab4f", "database_instances": [], "application_instances": []}	\N	2024-04-09 15:07:50.13981+00
\.


--
-- Data for Name: stream_events; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.stream_events (event_id, stream_id, stream_version, original_stream_id, original_stream_version) FROM stdin;
a4a2fe85-23e6-4f7c-9459-7de33a581232	1	1	1	1
a460c824-d0a8-4bdc-9460-fa78b4e8191c	0	2	2	1
a460c824-d0a8-4bdc-9460-fa78b4e8191c	2	1	2	1
4bacb6ea-0608-450b-b3af-fb22c9127325	3	1	3	1
7faa0205-02be-430d-b8e4-34ddfb79280c	4	1	4	1
e09fd979-c816-4396-8267-add1eec24914	0	5	5	1
4c4f2485-f8ce-46ec-bb5e-3b0787975761	0	6	5	2
e09fd979-c816-4396-8267-add1eec24914	5	1	5	1
4c4f2485-f8ce-46ec-bb5e-3b0787975761	5	2	5	2
701791de-b9d2-485d-a02a-7b0f85b63eca	0	7	6	1
6ae44389-074e-4389-862d-edfb5df60992	0	8	6	2
701791de-b9d2-485d-a02a-7b0f85b63eca	6	1	6	1
6ae44389-074e-4389-862d-edfb5df60992	6	2	6	2
9008a583-6dac-40fa-8831-86ba89166e32	3	2	3	2
d1a04a2e-98af-46a1-92fc-808587be031f	0	10	7	1
d1a04a2e-98af-46a1-92fc-808587be031f	7	1	7	1
11865212-87d7-47e4-967f-12c17400a4c6	0	11	8	1
8b44c110-ea90-49fc-9637-a75c435d54eb	0	12	8	2
11865212-87d7-47e4-967f-12c17400a4c6	8	1	8	1
8b44c110-ea90-49fc-9637-a75c435d54eb	8	2	8	2
005397e5-3378-44ba-8911-a4d1f98fad56	0	13	9	1
005397e5-3378-44ba-8911-a4d1f98fad56	9	1	9	1
47ca5cea-7cb1-4fd9-be19-da7d04b7cc61	0	14	10	1
a1643268-6a05-4f08-bdba-a02f0baad9b4	0	15	10	2
47ca5cea-7cb1-4fd9-be19-da7d04b7cc61	10	1	10	1
a1643268-6a05-4f08-bdba-a02f0baad9b4	10	2	10	2
b3806400-6aaf-4541-be78-659ca828404e	11	1	11	1
f9b6596b-956a-4219-b9e3-650df0ef88e4	11	2	11	2
415a54e4-708e-410c-b138-43ddea394646	12	1	12	1
e7200256-5ca7-4c5e-97f5-351fbd9155b3	12	2	12	2
365eca43-2838-47d8-bfe4-19387b64572f	13	1	13	1
451ced12-7765-4b67-a843-4c81678a8291	0	21	14	1
88f285f2-ade4-4322-aac4-70a5dc6502cb	0	22	14	2
451ced12-7765-4b67-a843-4c81678a8291	14	1	14	1
88f285f2-ade4-4322-aac4-70a5dc6502cb	14	2	14	2
fb56bd31-ab82-4940-b01a-69f9c3e66e0b	0	23	15	1
fb56bd31-ab82-4940-b01a-69f9c3e66e0b	15	1	15	1
245a0888-3c76-4136-a3b5-fea63426fa31	4	2	4	2
1d6d4e85-c252-432e-82c9-4c2630ebb433	0	25	7	2
1d6d4e85-c252-432e-82c9-4c2630ebb433	7	2	7	2
dcfe216a-d3a7-4a8a-a738-e60c3ed73f99	0	26	16	1
dcfe216a-d3a7-4a8a-a738-e60c3ed73f99	16	1	16	1
0182e0b4-db1e-4ef5-a330-c300f241fccc	12	3	12	3
b98199ac-dfbd-4083-81f2-c0c39dfe58a6	0	28	17	1
ea6b9206-23b4-4320-a37e-62e6333c69e4	0	29	17	2
b98199ac-dfbd-4083-81f2-c0c39dfe58a6	17	1	17	1
ea6b9206-23b4-4320-a37e-62e6333c69e4	17	2	17	2
33afa053-6e3f-45db-8e65-f08f04d7bf4e	0	30	18	1
b3773ca8-054c-45de-a883-6e409b547d88	0	31	18	2
33afa053-6e3f-45db-8e65-f08f04d7bf4e	18	1	18	1
b3773ca8-054c-45de-a883-6e409b547d88	18	2	18	2
0d639479-98f2-44cf-83e2-03033bdc0a87	0	32	14	3
8f070d65-b07b-4391-b13c-9334ca1ca518	0	33	14	4
0d639479-98f2-44cf-83e2-03033bdc0a87	14	3	14	3
8f070d65-b07b-4391-b13c-9334ca1ca518	14	4	14	4
73c9e97d-f590-411e-8038-7ba9f3d736ce	0	34	7	3
0a5aab8b-5586-4b24-9ed0-bfce5601831c	0	35	7	4
73c9e97d-f590-411e-8038-7ba9f3d736ce	7	3	7	3
0a5aab8b-5586-4b24-9ed0-bfce5601831c	7	4	7	4
fefb784a-22e6-4ebd-933a-a4d1a1e7bd3d	0	36	7	5
fefb784a-22e6-4ebd-933a-a4d1a1e7bd3d	7	5	7	5
c796a37f-d29c-48a1-bbcf-404c2a2ab46d	4	3	4	3
95712dd5-335f-4121-9365-9ea55bc74269	13	2	13	2
6853cc76-a193-4bdb-a878-9f826ec7b3d6	0	39	19	1
6853cc76-a193-4bdb-a878-9f826ec7b3d6	19	1	19	1
53f26459-c0b8-4439-9ead-285d9609ae48	20	1	20	1
4229ba10-3fea-4bc3-b72b-c6210f2b2990	11	3	11	3
e7dac3b2-5316-4f12-a428-ba0e206474ae	11	4	11	4
e46a6aac-671a-4453-b336-e846c8c76d4f	11	5	11	5
f4dca10c-2815-4217-bd3d-fab4e5840c18	11	6	11	6
61422752-9b41-482a-ac75-788e6bcfeb73	0	45	21	1
61422752-9b41-482a-ac75-788e6bcfeb73	21	1	21	1
35eced1f-db7b-4e1e-81a4-5525e7a56199	1	2	1	2
fa9dd9af-f858-403d-817f-b61ec785b35f	0	47	5	3
add5a929-a421-4ba7-bde1-7a379e5b9b10	0	48	5	4
06b40fe6-8e30-4845-bf37-e650c11b3a88	0	49	5	5
d2b059bc-4833-44ce-906d-da647faa4cfa	0	50	5	6
fa9dd9af-f858-403d-817f-b61ec785b35f	5	3	5	3
add5a929-a421-4ba7-bde1-7a379e5b9b10	5	4	5	4
06b40fe6-8e30-4845-bf37-e650c11b3a88	5	5	5	5
d2b059bc-4833-44ce-906d-da647faa4cfa	5	6	5	6
b80b5bcd-6acb-4adb-bd73-a7b58d703923	22	1	22	1
fb1708f9-d7b9-4199-a828-bb969d67eebc	0	52	23	1
fb1708f9-d7b9-4199-a828-bb969d67eebc	23	1	23	1
cfab4e33-ecf0-4fa2-91ca-5d5027dde96e	0	53	23	2
cfab4e33-ecf0-4fa2-91ca-5d5027dde96e	23	2	23	2
6939c71d-dfd1-4da1-a050-775a04667029	24	1	24	1
7e4d81cf-356a-4734-a8db-5ab2ac0d5c07	24	2	24	2
82b7087d-b877-4eb4-8e52-124a42caf1c4	0	58	25	1
f202b991-9795-4056-8acb-3b1f70bee285	0	59	25	2
82b7087d-b877-4eb4-8e52-124a42caf1c4	25	1	25	1
f202b991-9795-4056-8acb-3b1f70bee285	25	2	25	2
946f8794-261b-421f-b20e-3eb355132332	0	67	8	3
946f8794-261b-421f-b20e-3eb355132332	8	3	8	3
4abef3e5-f728-4734-bf5c-4141fdb99b97	0	75	19	2
2e0c7a12-a051-48f0-94fa-b0780be8397a	0	76	19	3
4abef3e5-f728-4734-bf5c-4141fdb99b97	19	2	19	2
2e0c7a12-a051-48f0-94fa-b0780be8397a	19	3	19	3
8c626e13-fd84-4d0f-ac81-a7b90e1073e0	0	77	28	1
8c626e13-fd84-4d0f-ac81-a7b90e1073e0	28	1	28	1
bf5837db-a9c2-4973-9d24-5ace518d9a64	0	82	31	1
c390bcd9-c572-4927-95f1-e5afd9f2ab6c	0	83	31	2
bf5837db-a9c2-4973-9d24-5ace518d9a64	31	1	31	1
c390bcd9-c572-4927-95f1-e5afd9f2ab6c	31	2	31	2
14d931cb-0fce-465f-887d-b3d742342222	22	3	22	3
bc9e7dc8-3abc-442e-90da-333a1d60e8fa	0	97	35	1
bc9e7dc8-3abc-442e-90da-333a1d60e8fa	35	1	35	1
724cba0f-6f1c-45fd-b898-2e8b335fde5a	0	100	18	3
34951626-3a28-4b9c-8584-c33fbba30877	0	101	18	4
99d6da1b-b55d-46c5-aa43-dff385042968	0	102	18	5
5ba32040-209f-4b15-b406-d05822f6fbc9	0	103	18	6
724cba0f-6f1c-45fd-b898-2e8b335fde5a	18	3	18	3
34951626-3a28-4b9c-8584-c33fbba30877	18	4	18	4
99d6da1b-b55d-46c5-aa43-dff385042968	18	5	18	5
5ba32040-209f-4b15-b406-d05822f6fbc9	18	6	18	6
fbdc767d-e4b1-474f-94be-cb59739e80ea	0	104	2	3
fbdc767d-e4b1-474f-94be-cb59739e80ea	2	3	2	3
2cce34a8-21f5-420c-9e6a-00822f41db9d	0	136	21	2
2cce34a8-21f5-420c-9e6a-00822f41db9d	21	2	21	2
b6d02322-618e-4535-a63d-ee65efc026db	20	3	20	3
54c3c7b8-3458-4683-8859-e5edf2fae34e	0	143	31	7
54c3c7b8-3458-4683-8859-e5edf2fae34e	31	7	31	7
79c8a577-4540-4f87-a22f-9ca7fa5fe928	34	2	34	2
f16f1fc4-ea5f-4653-be90-9e7e2e75ada4	34	3	34	3
75cf5dc2-ff51-43d9-b062-6437e36839b6	0	150	15	5
75cf5dc2-ff51-43d9-b062-6437e36839b6	15	5	15	5
43ed6612-4fcf-448d-b6b2-7d57f4c2c8c4	0	151	21	3
43ed6612-4fcf-448d-b6b2-7d57f4c2c8c4	21	3	21	3
800e06e5-0af1-4db3-9acf-d48456f95d8b	0	152	32	4
800e06e5-0af1-4db3-9acf-d48456f95d8b	32	4	32	4
9df423d5-b31a-43ba-8067-b7219df7c067	13	4	13	4
3db9c6e8-5a93-4bbe-bf0f-5ea056b6e6b3	13	5	13	5
61179a1b-a442-40cd-90c7-d4dbb16c1dcb	0	167	25	7
61179a1b-a442-40cd-90c7-d4dbb16c1dcb	25	7	25	7
e5748155-e257-4aea-a10d-e0062196e6ae	0	169	19	5
e5748155-e257-4aea-a10d-e0062196e6ae	19	5	19	5
1674d764-f7ae-463e-9fb9-f06e4977e0d3	0	171	30	5
1674d764-f7ae-463e-9fb9-f06e4977e0d3	30	5	30	5
4d6726c3-a783-494f-b34d-26a1365131ee	38	2	38	2
6c312c88-f792-470b-8115-b23fd84bc385	34	5	34	5
8de69742-3cac-48fe-a2f5-7d48a4b5a573	0	180	28	3
dbc33cf0-e555-4919-bbc3-881d7a008b41	0	181	28	4
8de69742-3cac-48fe-a2f5-7d48a4b5a573	28	3	28	3
dbc33cf0-e555-4919-bbc3-881d7a008b41	28	4	28	4
7ffca23c-2f1e-42d0-ab52-4c876374356f	0	187	35	5
7ffca23c-2f1e-42d0-ab52-4c876374356f	35	5	35	5
3dc37873-9314-47c5-afbf-b9f815d57623	4	5	4	5
5aed2ea7-351c-4be8-99d0-68b3b44d4b4a	4	9	4	9
393bfb43-9933-4713-9f1c-9981db1e39c6	3	5	3	5
f305b431-db10-46c5-b216-96a1cdd3e772	24	10	24	10
5aa77707-f93b-41ff-b657-ccea730bd12f	24	11	24	11
3e7f232b-fedd-4201-a331-1716afc60128	0	56	23	3
3e7f232b-fedd-4201-a331-1716afc60128	23	3	23	3
110cc0b8-ed10-4816-bc62-7602d876c235	20	2	20	2
1b469bfe-b6ab-49dc-9814-a919f3efad08	0	60	15	2
f15f31db-23dd-46c4-9b02-0f1ee0a493d7	0	61	15	3
1b469bfe-b6ab-49dc-9814-a919f3efad08	15	2	15	2
f15f31db-23dd-46c4-9b02-0f1ee0a493d7	15	3	15	3
257d6913-9b20-44a7-baf7-b6b90c106f1e	0	62	26	1
257d6913-9b20-44a7-baf7-b6b90c106f1e	26	1	26	1
4087611f-634a-4c19-bcce-5f3b2974685c	24	3	24	3
715693ad-0af0-4b7c-83b6-5892ea464577	4	4	4	4
af286f2c-8e15-477c-9edc-5d355c7c35c5	0	91	17	3
af286f2c-8e15-477c-9edc-5d355c7c35c5	17	3	17	3
3bc02323-1104-4023-8ed4-110bfbd6f2dc	0	96	23	4
3bc02323-1104-4023-8ed4-110bfbd6f2dc	23	4	23	4
4a9ef8a8-fb9e-47b5-bc2c-f5eafc66ba75	3	4	3	4
0b36464b-60df-4b6c-bb02-ae00eecffcd1	0	123	31	5
d7d7a5e1-4408-4cfb-a631-1b7d1255ad42	0	124	31	6
0b36464b-60df-4b6c-bb02-ae00eecffcd1	31	5	31	5
d7d7a5e1-4408-4cfb-a631-1b7d1255ad42	31	6	31	6
4eb15e2c-c24c-405d-9622-dffb4eb985d1	0	128	36	4
4eb15e2c-c24c-405d-9622-dffb4eb985d1	36	4	36	4
11696139-3107-4fb3-9aa0-58a531de3f55	0	135	29	4
11696139-3107-4fb3-9aa0-58a531de3f55	29	4	29	4
bf6de04a-f762-432a-8672-1e392edc3051	0	138	30	2
bf6de04a-f762-432a-8672-1e392edc3051	30	2	30	2
27ed4a55-3545-4dc2-8b89-1c0682af7901	24	5	24	5
81a942eb-1441-41a9-ab28-c4e714c35767	24	6	24	6
56bdfd2a-e174-4aa4-9d2f-557fd673e0a7	0	144	27	2
56bdfd2a-e174-4aa4-9d2f-557fd673e0a7	27	2	27	2
9dcf1c0e-87b8-43a1-858e-6124d0eeaa59	39	4	39	4
ddbeeff3-8609-4163-940a-097a62db2729	0	64	26	2
ddbeeff3-8609-4163-940a-097a62db2729	26	2	26	2
6e1e6f03-b25b-4c2d-a233-bdeebd2e5434	0	69	27	1
6e1e6f03-b25b-4c2d-a233-bdeebd2e5434	27	1	27	1
7085014b-5c9f-4569-b00b-3ca7f18217fb	13	3	13	3
147f89ab-859a-4e08-ae4a-ca0b8ad7a567	0	78	16	2
147f89ab-859a-4e08-ae4a-ca0b8ad7a567	16	2	16	2
c202af17-f3c5-40aa-89a4-9a0908077077	0	81	30	1
c202af17-f3c5-40aa-89a4-9a0908077077	30	1	30	1
9a88dd3a-278f-48d8-9bdc-38b7f0a54ca4	0	86	33	1
9a88dd3a-278f-48d8-9bdc-38b7f0a54ca4	33	1	33	1
1801b636-9e3d-42d8-a7de-8afede7736a0	1	3	1	3
cbba12b1-1401-4bbb-a4c5-77d948e4ee90	0	92	10	3
cbba12b1-1401-4bbb-a4c5-77d948e4ee90	10	3	10	3
e9da714c-f987-4b6d-b7e4-3a00ce756cdb	3	3	3	3
65490fcd-a4e7-4743-843c-b0190235f360	22	4	22	4
a22c7426-5cfa-4042-a0c9-45f230a43700	0	119	37	2
a703a933-7a33-47c5-acd5-4411a00d4d99	0	120	37	3
a22c7426-5cfa-4042-a0c9-45f230a43700	37	2	37	2
a703a933-7a33-47c5-acd5-4411a00d4d99	37	3	37	3
27783f73-5ed3-46dc-8910-fa4ab3663b6d	0	122	31	4
27783f73-5ed3-46dc-8910-fa4ab3663b6d	31	4	31	4
acf18974-9866-422f-b698-f81b80653c90	0	130	16	3
b288a55a-aa7f-457d-885d-4d9a36e83060	0	131	16	4
acf18974-9866-422f-b698-f81b80653c90	16	3	16	3
b288a55a-aa7f-457d-885d-4d9a36e83060	16	4	16	4
2a016def-a844-402a-b4eb-45f4487fbf9c	0	132	19	4
2a016def-a844-402a-b4eb-45f4487fbf9c	19	4	19	4
532b3de6-ca4d-42d0-9758-f66392edc4f9	24	7	24	7
b116b0f8-d243-4345-b12f-3ab226da506a	0	148	27	3
44985c30-8bdf-41d0-9db0-6560c244804d	0	149	27	4
b116b0f8-d243-4345-b12f-3ab226da506a	27	3	27	3
44985c30-8bdf-41d0-9db0-6560c244804d	27	4	27	4
7f26570b-fb85-4acd-85bc-0dee7f7ecc20	0	164	30	3
6a3302aa-3afb-43c9-b0e1-433e76c3d3e8	0	165	30	4
7f26570b-fb85-4acd-85bc-0dee7f7ecc20	30	3	30	3
6a3302aa-3afb-43c9-b0e1-433e76c3d3e8	30	4	30	4
b5accf16-6145-4fb2-8b90-08269bedc55a	0	172	26	4
a518a774-5e58-4295-8e63-c12a1896cd47	0	173	26	5
b5accf16-6145-4fb2-8b90-08269bedc55a	26	4	26	4
a518a774-5e58-4295-8e63-c12a1896cd47	26	5	26	5
39d73778-de57-4d3b-80b6-fdb1b4448339	0	175	25	8
39d73778-de57-4d3b-80b6-fdb1b4448339	25	8	25	8
aa4a6b59-f88b-462f-a16f-f57e8c0da09a	38	3	38	3
0cfd24fb-9e7e-4bdb-8079-bcdb421b0adc	0	188	37	4
0cfd24fb-9e7e-4bdb-8079-bcdb421b0adc	37	4	37	4
32adcaff-bf40-4240-9f98-fef309a5a600	24	9	24	9
96cd5c39-2544-41b6-9b80-9e03baefae78	3	9	3	9
8571ace6-d7b9-4d22-8d50-5252ad67a210	22	2	22	2
5d9e69ab-de22-494b-83e6-6424623a7391	0	68	15	4
5d9e69ab-de22-494b-83e6-6424623a7391	15	4	15	4
7dd77b69-ccf9-4cea-b3bb-3f1d656ac8cc	0	71	6	3
3d81c2d7-06c7-4283-8be6-62f0f61516e1	0	72	6	4
93a63871-a7c4-424d-91a6-6fc728a4ece2	0	73	6	5
df435fdd-45f4-47da-bf86-c14407e5e706	0	74	6	6
7dd77b69-ccf9-4cea-b3bb-3f1d656ac8cc	6	3	6	3
3d81c2d7-06c7-4283-8be6-62f0f61516e1	6	4	6	4
93a63871-a7c4-424d-91a6-6fc728a4ece2	6	5	6	5
df435fdd-45f4-47da-bf86-c14407e5e706	6	6	6	6
ee58cff4-2a79-41df-b122-cec9aafa713b	0	80	29	1
ee58cff4-2a79-41df-b122-cec9aafa713b	29	1	29	1
f17b8529-1305-4a20-bd95-ad72c24e4350	0	85	25	3
f17b8529-1305-4a20-bd95-ad72c24e4350	25	3	25	3
9c24520a-0893-4393-8f34-e19ef1a1466a	0	88	9	3
9c24520a-0893-4393-8f34-e19ef1a1466a	9	3	9	3
e1913042-81c2-46f1-aa86-1c4664a7ce33	1	4	1	4
1ba9b86c-412a-4497-a08b-3f4a0c304f33	0	99	31	3
1ba9b86c-412a-4497-a08b-3f4a0c304f33	31	3	31	3
221cc61d-ff5d-4448-9b98-8288f97b9dba	0	111	36	2
aa1c0ae1-59cc-4bbf-b299-557f5d035e4c	0	112	36	3
221cc61d-ff5d-4448-9b98-8288f97b9dba	36	2	36	2
aa1c0ae1-59cc-4bbf-b299-557f5d035e4c	36	3	36	3
d3faa574-026d-45aa-8b87-e7a86b41fb3b	38	1	38	1
aa6732dd-5aae-4309-92ec-e4da86046e4f	39	1	39	1
4e5b78b5-a5ac-4168-8318-67a660c11e96	0	147	35	2
4e5b78b5-a5ac-4168-8318-67a660c11e96	35	2	35	2
c5d1d2d6-e76d-464a-969a-71aa45336b13	0	157	25	6
c5d1d2d6-e76d-464a-969a-71aa45336b13	25	6	25	6
0cd49cdd-242a-4eed-8137-cb1a890c9ecc	0	158	31	8
0cd49cdd-242a-4eed-8137-cb1a890c9ecc	31	8	31	8
af4adae4-9973-41a5-97cc-51ddf2646ce3	24	8	24	8
32a7d617-da46-492d-b4ec-3b8831a4f9e3	34	4	34	4
e67cd344-ee50-4931-be16-63edb6c6a227	39	2	39	2
04f5fee8-12b9-4a3e-a1fe-26a4810d993a	0	174	32	5
04f5fee8-12b9-4a3e-a1fe-26a4810d993a	32	5	32	5
213cfbe2-14b0-4640-b584-764cda3a2640	0	179	36	5
213cfbe2-14b0-4640-b584-764cda3a2640	36	5	36	5
07efa33b-56e8-4bf7-af89-b57c8bc85240	0	182	28	5
07efa33b-56e8-4bf7-af89-b57c8bc85240	28	5	28	5
8260a9b0-cdc0-45bf-90ed-dccd2a97e0bf	38	4	38	4
220f4e4d-acde-40e9-ae95-17718f9a651e	0	184	35	3
11a41385-7e9d-49d3-8f49-90a647ce2458	0	185	35	4
220f4e4d-acde-40e9-ae95-17718f9a651e	35	3	35	3
11a41385-7e9d-49d3-8f49-90a647ce2458	35	4	35	4
8e2e7df8-e7a4-400e-90d4-c4b489db6636	4	6	4	6
87eb61ad-9d63-48fc-abab-91a4c29b49c3	4	7	4	7
0406c959-63e5-475d-a7fc-80039cd7a2a5	4	8	4	8
586aa07e-f8e0-4e50-b004-cb5ebe2c4a0f	3	6	3	6
2d4685c2-897f-47c6-905f-bf49482e39b1	3	7	3	7
03121a42-5c45-46b5-9a0b-be963295de79	3	8	3	8
a3e9f936-5d44-4d05-b19d-7beed0dd911a	0	79	9	2
a3e9f936-5d44-4d05-b19d-7beed0dd911a	9	2	9	2
135323aa-23e6-498a-b275-430bfbd1689f	0	84	32	1
135323aa-23e6-498a-b275-430bfbd1689f	32	1	32	1
4e336802-51c8-4a74-b63a-3e887950cab8	0	93	26	3
4e336802-51c8-4a74-b63a-3e887950cab8	26	3	26	3
3c03d194-d73c-4f93-b898-f6d37aa3f3e2	34	1	34	1
019d2480-3153-4be0-8606-dd8f53d81572	24	4	24	4
f12a2585-7831-4dc1-bd2f-c7f7a9d42d4b	0	98	2	2
f12a2585-7831-4dc1-bd2f-c7f7a9d42d4b	2	2	2	2
a8b79302-97d5-4435-aaf5-881e00c58d2b	0	107	36	1
a8b79302-97d5-4435-aaf5-881e00c58d2b	36	1	36	1
aa018240-3ec2-491b-96ce-9a017ed48ec7	0	108	33	2
aa018240-3ec2-491b-96ce-9a017ed48ec7	33	2	33	2
84918b3f-3dc9-4f95-adb5-e45ec36100ed	0	109	25	4
cf1e0ab5-58d8-4972-9e06-21ce3db2a370	0	110	25	5
84918b3f-3dc9-4f95-adb5-e45ec36100ed	25	4	25	4
cf1e0ab5-58d8-4972-9e06-21ce3db2a370	25	5	25	5
fdd798d7-dd62-485a-8630-88aa62076daa	0	113	37	1
fdd798d7-dd62-485a-8630-88aa62076daa	37	1	37	1
67dcc925-3e7d-46df-924b-57b12fe0d770	0	115	32	2
89640bb7-bb3e-4cd8-b0a8-240f37f5abe2	0	116	32	3
67dcc925-3e7d-46df-924b-57b12fe0d770	32	2	32	2
89640bb7-bb3e-4cd8-b0a8-240f37f5abe2	32	3	32	3
adfdda8a-7992-4758-875f-27dacc96dcb8	0	117	2	4
adfdda8a-7992-4758-875f-27dacc96dcb8	2	4	2	4
16d38910-2b77-4b29-b4c1-c6dcfda7fd68	0	121	33	3
16d38910-2b77-4b29-b4c1-c6dcfda7fd68	33	3	33	3
1f36bf5f-5bea-4a6d-8c04-d0df3cb7fe27	0	126	9	4
b5f695c8-dade-4fa3-8971-eda530bc2826	0	127	9	5
1f36bf5f-5bea-4a6d-8c04-d0df3cb7fe27	9	4	9	4
b5f695c8-dade-4fa3-8971-eda530bc2826	9	5	9	5
7ff3b29e-5c92-453e-a453-dc404583582a	0	129	33	4
7ff3b29e-5c92-453e-a453-dc404583582a	33	4	33	4
25feb3d2-7bed-4c42-85f6-4221c21d8d60	0	133	29	2
e3fda909-648c-4913-9baf-48e1c9154a3c	0	134	29	3
25feb3d2-7bed-4c42-85f6-4221c21d8d60	29	2	29	2
e3fda909-648c-4913-9baf-48e1c9154a3c	29	3	29	3
5e59dfc1-fbec-40f0-8048-117eac55cc59	0	141	28	2
5e59dfc1-fbec-40f0-8048-117eac55cc59	28	2	28	2
297cad94-0f70-4267-928d-22a40bdb4709	0	155	21	4
f2a1e4b3-7c89-4b3d-b39b-3835f7d8450b	0	156	21	5
297cad94-0f70-4267-928d-22a40bdb4709	21	4	21	4
f2a1e4b3-7c89-4b3d-b39b-3835f7d8450b	21	5	21	5
9b404c85-cbae-49d5-b4ba-38118c381b90	20	4	20	4
b060d972-4df3-4f5c-a6fd-d0d6a1cfa3dd	20	5	20	5
b2fbce55-5f40-483f-9851-d3a682c20610	0	166	29	5
b2fbce55-5f40-483f-9851-d3a682c20610	29	5	29	5
824d131b-f66a-451a-8e62-d43e7ec9a8ec	39	3	39	3
afe9d3af-48f9-49b8-9e93-e9265458b2f5	0	170	27	5
afe9d3af-48f9-49b8-9e93-e9265458b2f5	27	5	27	5
49500b4e-dd8c-4f3b-9043-74d55676feee	40	1	40	1
e335b65f-9a46-46c1-b661-b2e2b6d90c11	41	1	41	1
e83144ee-ec2b-4108-b3b0-1f8143a98aea	38	5	38	5
bdccb39a-7aa2-480c-a3dd-5b314f6b1309	24	12	24	12
1cd4752b-3c1e-4288-bd8a-79335c8ba5c6	12	4	12	4
b961a930-8fd7-40af-95d2-48e6d4a71d41	38	6	38	6
f9191020-5fff-42d3-b6e8-a28d33a03163	38	7	38	7
f9a79472-0305-4a78-b26e-f6d613b7df4b	38	8	38	8
523cb3c5-a2f2-4a4e-bcd1-4ab99015241d	38	9	38	9
19c8b8d5-af43-4162-bc58-8068fc534db5	0	211	42	1
19c8b8d5-af43-4162-bc58-8068fc534db5	42	1	42	1
a6e81307-c1ab-4a63-beee-4aae3fe51969	39	5	39	5
19339468-c3b1-40f3-a31b-6f9a9d78108f	24	13	24	13
ddd6ec27-1a54-4921-9563-1b25a94551d9	12	5	12	5
4aba5103-6c26-4434-a871-d9f5ecc3cc9b	12	6	12	6
08b3adac-059f-42df-9194-00b48863e8ef	12	7	12	7
6b871c5d-9aec-41eb-870d-092cb358dee0	39	6	39	6
43d06dad-6de6-4b49-832c-59d6dd1492e6	39	7	39	7
759f6452-5df8-4a59-b5ac-e4a71556f893	39	8	39	8
febc5cd6-47f8-4483-a558-687ade8df363	12	8	12	8
c2b4950c-7408-4e20-b7e1-2752618fb9ca	0	221	43	1
c2b4950c-7408-4e20-b7e1-2752618fb9ca	43	1	43	1
7dfb1bfa-5982-4ee1-91a7-6f37325e322a	39	9	39	9
1c6c0025-681c-4fec-af38-31883690d71f	0	223	44	1
1c6c0025-681c-4fec-af38-31883690d71f	44	1	44	1
ee3205b8-92cb-4d14-a51a-a9a6fd342715	22	5	22	5
0d277d94-e747-4682-bd6a-f307229cbf25	24	14	24	14
99da1ff9-616b-4127-961e-e8cbe610bf8d	11	7	11	7
6c2b7b8f-777c-4450-a6d2-68bc01dbf409	22	6	22	6
f2e2a42b-14e5-43c3-bccd-d2d6d894b9a6	22	7	22	7
a23ab890-c2f3-4ddd-a2c9-6d77dffc2cc2	22	8	22	8
225363c5-648a-4ac2-af78-0932be1603bd	22	9	22	9
7c2ded68-7c69-4724-9251-203493c9a41a	0	231	45	1
7c2ded68-7c69-4724-9251-203493c9a41a	45	1	45	1
fb1d79f3-df37-4bbf-817f-8e6aaa520b59	1	5	1	5
afc84157-c2aa-47ff-930e-8f1c2d8177d4	24	15	24	15
8ae44d44-15d5-4d19-9ead-b5aa2a25781c	24	16	24	16
9bbebd30-54d6-4aa4-bf4f-a0bb959eda06	24	17	24	17
396fff0a-fc71-4e80-8a66-d27cc107e715	1	9	1	9
210ab3c4-6509-46f0-8ed5-5d9517d4a038	0	248	48	2
210ab3c4-6509-46f0-8ed5-5d9517d4a038	48	2	48	2
6625812b-ee52-45cd-b480-42f33a8ce7fd	41	2	41	2
8ccd0082-3076-483c-ad1b-f263b3e34883	40	2	40	2
3c1b70ae-d96f-481d-87a8-73a190e1f070	0	251	16	5
3c1b70ae-d96f-481d-87a8-73a190e1f070	16	5	16	5
7dfc3283-9f25-4839-a36e-d636a386ae4f	0	252	47	2
4b8048be-ea37-4306-9956-e387b5039880	0	253	47	3
bc3037fa-96c0-4eb5-9404-5b7623c84a22	11	8	11	8
76d8bb54-727b-4051-8788-e29a980b5b16	11	9	11	9
e491428c-1aee-461e-89f6-4f06a26b2334	11	10	11	10
94afbb52-adbe-401b-87c4-5418401df631	0	269	46	8
94afbb52-adbe-401b-87c4-5418401df631	46	8	46	8
d1799f71-3efb-4fba-9ea5-d61f7f368209	0	286	31	14
d1799f71-3efb-4fba-9ea5-d61f7f368209	31	14	31	14
985742e7-f138-44e6-80c8-9bae62f4ae54	0	294	46	11
985742e7-f138-44e6-80c8-9bae62f4ae54	46	11	46	11
a3f3b8a9-ebb9-40f1-9d52-776faf12f776	0	295	46	12
a3f3b8a9-ebb9-40f1-9d52-776faf12f776	46	12	46	12
f2119f82-be66-4a78-bdda-d771ff1677da	1	6	1	6
5fc76516-10fe-4893-af4d-60b49de25013	1	7	1	7
d7fc273a-f804-439a-b203-23e2546f1d0e	1	8	1	8
3ef5e387-dd1e-4f36-a1d7-6c2238905b27	0	260	45	2
3ef5e387-dd1e-4f36-a1d7-6c2238905b27	45	2	45	2
fdd6d212-3387-4b9f-858f-df0daf4e44b6	0	293	46	10
fdd6d212-3387-4b9f-858f-df0daf4e44b6	46	10	46	10
14d9c945-37d9-4814-84ad-b53b099ddd72	24	18	24	18
950c44ab-6814-4e28-9627-6046523bce45	0	243	46	1
950c44ab-6814-4e28-9627-6046523bce45	46	1	46	1
3e5f11c0-a98d-4428-a221-1f1f11c1f936	11	11	11	11
9458cafa-dbef-414e-a322-aa3b171e9b06	0	245	47	1
9458cafa-dbef-414e-a322-aa3b171e9b06	47	1	47	1
160d4374-8c70-453e-ac0c-59723f141597	0	247	48	1
160d4374-8c70-453e-ac0c-59723f141597	48	1	48	1
62e9479c-0b19-435d-bc19-9b5ac1a4e801	0	257	43	4
62e9479c-0b19-435d-bc19-9b5ac1a4e801	43	4	43	4
e971b69a-9d65-4335-9837-c0817a183c40	0	261	46	2
c05d1cb3-6de8-49a7-9332-31ecdb733b34	0	262	46	3
e971b69a-9d65-4335-9837-c0817a183c40	46	2	46	2
c05d1cb3-6de8-49a7-9332-31ecdb733b34	46	3	46	3
e376f76d-66bf-4407-ae73-f97d407be614	0	264	46	5
e376f76d-66bf-4407-ae73-f97d407be614	46	5	46	5
b052acc6-5cc3-4db1-b416-a2eb03b8a926	0	272	31	9
f6237ef4-3e56-4caf-9386-39b4fb2de168	0	273	31	10
cc8920c2-5ce4-4bf6-8e39-0686e5fb07aa	0	274	31	11
b052acc6-5cc3-4db1-b416-a2eb03b8a926	31	9	31	9
f6237ef4-3e56-4caf-9386-39b4fb2de168	31	10	31	10
cc8920c2-5ce4-4bf6-8e39-0686e5fb07aa	31	11	31	11
dd96ae1f-45a8-46ca-960b-7d42da93cf81	0	282	18	8
dd96ae1f-45a8-46ca-960b-7d42da93cf81	18	8	18	8
a3fbe1e2-d96a-4436-a14d-b14169f6f653	0	283	31	12
a3adb218-b295-412f-bceb-7378e1109b76	0	284	31	13
a3fbe1e2-d96a-4436-a14d-b14169f6f653	31	12	31	12
a3adb218-b295-412f-bceb-7378e1109b76	31	13	31	13
e9635334-7461-41c2-9ca3-7f8b06e415a0	34	7	34	7
f88ccc42-dbe2-4c6f-8420-49db2a0ab430	34	8	34	8
ddde0367-844c-409d-a3e8-9c6e568e33b0	34	9	34	9
2b1dc300-37fb-429a-8d98-2c34a960e905	0	296	46	13
aa7edd5c-a17e-47bb-b4ec-a748d5c79682	0	297	46	14
de96a398-876d-4626-a477-8636d2dcc726	0	298	46	15
2b1dc300-37fb-429a-8d98-2c34a960e905	46	13	46	13
aa7edd5c-a17e-47bb-b4ec-a748d5c79682	46	14	46	14
de96a398-876d-4626-a477-8636d2dcc726	46	15	46	15
7dfc3283-9f25-4839-a36e-d636a386ae4f	47	2	47	2
4b8048be-ea37-4306-9956-e387b5039880	47	3	47	3
e76eae8a-2642-4761-9d63-c88514d6a2b8	0	254	21	6
e76eae8a-2642-4761-9d63-c88514d6a2b8	21	6	21	6
48d6557e-834d-432c-92c5-b599119da4b3	0	255	43	2
5e53d685-f975-4956-986e-9735b44be01e	0	256	43	3
48d6557e-834d-432c-92c5-b599119da4b3	43	2	43	2
5e53d685-f975-4956-986e-9735b44be01e	43	3	43	3
19412378-89b8-4f26-983d-dd56984b7cf2	0	259	47	4
19412378-89b8-4f26-983d-dd56984b7cf2	47	4	47	4
3b7d62af-18eb-46c5-9fc0-a8ff5a389856	0	265	42	2
3b7d62af-18eb-46c5-9fc0-a8ff5a389856	42	2	42	2
d8daedb3-60a2-4483-a5d7-eb214647a996	0	267	46	6
b2595476-618a-4ad5-b4e0-1590c250e60b	0	268	46	7
d8daedb3-60a2-4483-a5d7-eb214647a996	46	6	46	6
b2595476-618a-4ad5-b4e0-1590c250e60b	46	7	46	7
39400968-b74c-4cd6-a877-ba7a1c0239c5	13	6	13	6
89066c17-3c5a-483c-b4da-11989e982e3f	0	275	18	7
89066c17-3c5a-483c-b4da-11989e982e3f	18	7	18	7
048349ea-8056-4b1c-9581-b7a46bcef8fa	13	10	13	10
e6657bcf-e63d-44ef-9799-7fe6ad56de4a	34	6	34	6
48e65eab-a66a-4203-95b2-4ea898391aed	34	10	34	10
da5e8259-b88d-4b26-b0c0-543f224e273e	0	258	7	6
da5e8259-b88d-4b26-b0c0-543f224e273e	7	6	7	6
c2c5e200-2cb4-434a-a3b1-b1bfb4004b8e	0	263	46	4
c2c5e200-2cb4-434a-a3b1-b1bfb4004b8e	46	4	46	4
f7dd7f5f-aba7-48ce-b4d5-fb3cb0c81cc0	0	266	44	2
f7dd7f5f-aba7-48ce-b4d5-fb3cb0c81cc0	44	2	44	2
d0d57a4b-da1f-4168-81cc-3101c34a3596	0	270	46	9
d0d57a4b-da1f-4168-81cc-3101c34a3596	46	9	46	9
bea37245-bf57-4a18-9f0e-bb92d57a7f19	13	7	13	7
515eda9c-79c0-4ed8-819c-ab6681bb303a	13	8	13	8
05ea6309-3a62-484e-8177-332189e23038	13	9	13	9
beffa190-84a5-4698-a883-b1f2cff04b6c	0	280	49	1
beffa190-84a5-4698-a883-b1f2cff04b6c	49	1	49	1
83afc0c0-22f1-4031-8cc3-0ceeb8c552e5	0	281	49	2
83afc0c0-22f1-4031-8cc3-0ceeb8c552e5	49	2	49	2
d52b49e0-c4ed-4cf5-bdd3-4603742e7733	0	287	17	4
d52b49e0-c4ed-4cf5-bdd3-4603742e7733	17	4	17	4
46b101d6-5b13-4864-ae16-c97acaf35f8f	50	1	50	1
c674dc9c-9263-4502-baf0-07b25b966ca0	41	3	41	3
11326261-d0aa-4714-9373-d96ee950f96d	40	3	40	3
f0094c1c-4c26-4df1-911a-365bb916a56e	0	301	17	5
f0094c1c-4c26-4df1-911a-365bb916a56e	17	5	17	5
8383bd9a-2f0b-466f-895f-8241ca31fdc3	0	302	46	16
4fd530b0-51af-4f74-af97-17a2fb3b3b31	0	303	46	17
8383bd9a-2f0b-466f-895f-8241ca31fdc3	46	16	46	16
4fd530b0-51af-4f74-af97-17a2fb3b3b31	46	17	46	17
2cf67815-cc13-4856-a574-0702c2225212	0	304	46	18
2cf67815-cc13-4856-a574-0702c2225212	46	18	46	18
fcea2eac-82c0-4764-82f1-85d9c9b30021	0	305	45	3
fcea2eac-82c0-4764-82f1-85d9c9b30021	45	3	45	3
3fc1982f-8a23-4cd0-9347-94a065992a39	50	2	50	2
bc8eff6b-e3a8-46ab-b368-e318769fac09	0	307	31	15
8ccff23c-bd46-4995-847b-964eff8d829b	0	308	31	16
bc8eff6b-e3a8-46ab-b368-e318769fac09	31	15	31	15
8ccff23c-bd46-4995-847b-964eff8d829b	31	16	31	16
152ff5a3-5bb1-456d-9ced-4d6ee778fcc9	0	309	46	19
0b551622-73bd-4fab-803c-3e318eb64a4b	0	310	46	20
152ff5a3-5bb1-456d-9ced-4d6ee778fcc9	46	19	46	19
0b551622-73bd-4fab-803c-3e318eb64a4b	46	20	46	20
ab71713a-e942-43e3-8af9-dc0d94bfd122	0	311	46	21
d5b32741-40e5-4b09-8fb2-dab8768384ca	0	312	46	22
ab71713a-e942-43e3-8af9-dc0d94bfd122	46	21	46	21
d5b32741-40e5-4b09-8fb2-dab8768384ca	46	22	46	22
82799ef8-43d3-4022-b9c3-129c07ef9009	0	313	46	23
cfba53f1-0246-4bed-a670-d4bf7c09fe7a	0	314	46	24
82799ef8-43d3-4022-b9c3-129c07ef9009	46	23	46	23
cfba53f1-0246-4bed-a670-d4bf7c09fe7a	46	24	46	24
aaaf7250-b1e0-406b-b6cd-f20e93608a85	0	315	46	25
386c0491-ea2a-4a28-9484-11558595d20e	0	316	46	26
aaaf7250-b1e0-406b-b6cd-f20e93608a85	46	25	46	25
386c0491-ea2a-4a28-9484-11558595d20e	46	26	46	26
79648e9d-7bae-48a6-a8ee-25f275b58ef4	0	317	46	27
79648e9d-7bae-48a6-a8ee-25f275b58ef4	46	27	46	27
9c2274f4-8c34-4f88-864d-9d60b9baa4e7	0	318	46	28
2d045869-7d42-4f8b-b6ba-36706786a0fd	0	319	46	29
9c2274f4-8c34-4f88-864d-9d60b9baa4e7	46	28	46	28
2d045869-7d42-4f8b-b6ba-36706786a0fd	46	29	46	29
c3643824-b445-4ba5-9c63-23e81db706ee	0	320	46	30
c3643824-b445-4ba5-9c63-23e81db706ee	46	30	46	30
da438df4-147e-4b2c-af23-0ee5b454d2c3	0	321	46	31
da438df4-147e-4b2c-af23-0ee5b454d2c3	46	31	46	31
9f730a2f-e644-4004-a446-82df0121b1e4	0	322	46	32
9f730a2f-e644-4004-a446-82df0121b1e4	46	32	46	32
bce5e0bb-8741-4459-9610-b6ef2f208d44	0	323	46	33
bce5e0bb-8741-4459-9610-b6ef2f208d44	46	33	46	33
4a175f4d-f930-4b6e-b7ff-dddca617db8e	0	324	46	34
4a175f4d-f930-4b6e-b7ff-dddca617db8e	46	34	46	34
b7dff670-4e7b-4d92-9995-0838546c4f07	20	6	20	6
ff5a9948-7f5c-4e75-8276-824337374869	0	326	25	9
8ea6fceb-9895-423e-a4eb-ef774eb8264d	0	327	25	10
da90ee43-74e3-4c9e-b1e7-0fcc069548d9	0	328	25	11
ff5a9948-7f5c-4e75-8276-824337374869	25	9	25	9
8ea6fceb-9895-423e-a4eb-ef774eb8264d	25	10	25	10
da90ee43-74e3-4c9e-b1e7-0fcc069548d9	25	11	25	11
61453356-fd61-4ece-bad2-cce36f65570c	0	329	5	7
61453356-fd61-4ece-bad2-cce36f65570c	5	7	5	7
9438599e-48bb-407b-96c3-4faf5d76e507	20	7	20	7
3c4944f4-3ae8-4d71-bbfd-58fb70897f9b	20	8	20	8
7ff9c6c5-bd70-462d-8593-774bfdb31d58	20	9	20	9
b10d5dae-1796-4d46-9c7e-a5540bc8f815	20	10	20	10
1022a58d-ed49-4563-b987-44867ecb5147	0	334	51	1
1022a58d-ed49-4563-b987-44867ecb5147	51	1	51	1
d10265ec-6905-4d28-9607-f709af6ea450	50	3	50	3
4ca0c802-bcc6-42d7-a6ea-06efa4ac8f76	0	336	31	17
13e17734-9d98-425a-bd7e-970412ed726f	0	337	31	18
4ca0c802-bcc6-42d7-a6ea-06efa4ac8f76	31	17	31	17
13e17734-9d98-425a-bd7e-970412ed726f	31	18	31	18
e135273a-81b8-481d-9640-203738865343	0	338	17	6
e135273a-81b8-481d-9640-203738865343	17	6	17	6
1c7f0f59-5465-44f9-95f8-763e157d7dc8	50	4	50	4
82183162-40ee-47f1-b1c8-28b728745507	50	5	50	5
563d4746-adf1-42dc-b9fe-8f26652b0a26	50	6	50	6
01914ae8-6ea5-4580-bbe7-e0a828630dae	50	7	50	7
83354969-50b5-4f85-a629-f68dcdd69ec5	0	343	52	1
83354969-50b5-4f85-a629-f68dcdd69ec5	52	1	52	1
14c5423f-175f-4532-90c6-ce41fb1ded32	41	4	41	4
b28e1a73-568d-4298-a44c-a1ef5f2918a9	0	345	46	35
b28e1a73-568d-4298-a44c-a1ef5f2918a9	46	35	46	35
2f66f649-5499-4479-99b7-c7f285c1c0ee	41	5	41	5
889c6bd9-766d-492e-af36-a7d43621ce83	41	6	41	6
181f10fa-9a80-464c-814d-5b9beaf9a776	40	4	40	4
834266af-ab34-42ad-ad08-fd490391fe82	0	367	46	44
834266af-ab34-42ad-ad08-fd490391fe82	46	44	46	44
2df78e0d-8912-4388-9ef3-b453994cae9c	41	7	41	7
18aa48e4-c4f2-4b8e-8ace-0aa41249b0d1	0	368	46	45
18aa48e4-c4f2-4b8e-8ace-0aa41249b0d1	46	45	46	45
250ba22f-b38e-4bcf-a23f-efefb5d668cc	41	8	41	8
caac845d-693b-4c29-8e4d-3dcbe8e6e8aa	0	350	53	1
caac845d-693b-4c29-8e4d-3dcbe8e6e8aa	53	1	53	1
0447f2f8-ad37-449a-ad6f-14ea02cfe1c7	0	352	46	36
630cc41d-0488-40ab-a1e6-7cf6cf16f2ce	0	353	46	37
0447f2f8-ad37-449a-ad6f-14ea02cfe1c7	46	36	46	36
630cc41d-0488-40ab-a1e6-7cf6cf16f2ce	46	37	46	37
3b07d2cc-7062-483c-9977-dcbc4b4e4767	0	360	46	38
71a556bd-6328-46d3-b14c-dc9dea0cd454	0	361	46	39
3b07d2cc-7062-483c-9977-dcbc4b4e4767	46	38	46	38
71a556bd-6328-46d3-b14c-dc9dea0cd454	46	39	46	39
06a64bf3-7453-4ad7-83a4-9b669e1c605c	0	365	46	42
06a64bf3-7453-4ad7-83a4-9b669e1c605c	46	42	46	42
f9966a70-36be-465e-9f00-8e2a680468c1	40	5	40	5
da238b51-dac3-4368-bdd6-f241f5b7b735	40	6	40	6
3f11fbfe-d049-49f1-92bd-0d7b4b371437	40	7	40	7
be2f0d42-84fd-49b7-8750-c8f99c60df0f	0	359	53	2
be2f0d42-84fd-49b7-8750-c8f99c60df0f	53	2	53	2
68dcfaa5-902a-41ea-949c-d26e0f5e7ba8	0	362	54	2
68dcfaa5-902a-41ea-949c-d26e0f5e7ba8	54	2	54	2
4aee9659-2e0a-4fab-a5d8-07959c5d48c9	0	363	46	40
fb3d4457-341c-4bc4-b6e4-264108a5a40e	0	364	46	41
4aee9659-2e0a-4fab-a5d8-07959c5d48c9	46	40	46	40
fb3d4457-341c-4bc4-b6e4-264108a5a40e	46	41	46	41
44c85031-e4d4-4921-a763-6dc8269cf978	0	366	46	43
44c85031-e4d4-4921-a763-6dc8269cf978	46	43	46	43
f0dac76b-c1e3-4ecd-aa5a-908406d08ad7	0	369	46	46
f0dac76b-c1e3-4ecd-aa5a-908406d08ad7	46	46	46	46
75447ca9-7577-479d-a199-3a243f246f46	0	370	46	47
111408d0-10f8-4b44-8f11-08b5d9e53658	0	371	46	48
75447ca9-7577-479d-a199-3a243f246f46	46	47	46	47
111408d0-10f8-4b44-8f11-08b5d9e53658	46	48	46	48
ab344a93-6031-493c-8812-19bf3ffec863	40	8	40	8
56a4d480-8e93-420f-bd96-9a13159e106e	0	358	54	1
56a4d480-8e93-420f-bd96-9a13159e106e	54	1	54	1
\.


--
-- Data for Name: streams; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.streams (stream_id, stream_uuid, stream_version, created_at, deleted_at) FROM stdin;
22	0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4-archived-2024-04-09T15:07:52.783014Z	9	2024-04-09 15:07:05.282048+00	\N
51	9cd46919-5f19-59aa-993e-cf3736c71053	1	2024-04-09 15:09:51.565755+00	\N
6	0eac831a-aa66-5f45-89a4-007fbd2c5714	6	2024-04-09 15:06:57.263788+00	\N
21	4b30a6af-4b52-5bda-bccb-f2248a12c992	6	2024-04-09 15:07:04.37337+00	\N
31	cd52e571-c897-5bba-b0f9-e155ceca1fff	18	2024-04-09 15:07:09.897599+00	\N
43	5284f376-c1f4-5178-8966-d490df3dab4f	4	2024-04-09 15:07:50.107836+00	\N
36	0fc07435-7ee2-54ca-b0de-fb27ffdc5deb	5	2024-04-09 15:07:13.294651+00	\N
7	a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12	6	2024-04-09 15:06:58.427468+00	\N
2	9a26b6d0-6e72-597c-9fe5-152a6875f214	4	2024-04-09 15:06:55.881608+00	\N
15	21de186a-e38f-5804-b643-7f4ef22fecfd	5	2024-04-09 15:07:00.938977+00	\N
17	fb861bce-d212-56b5-8786-74afd6eb58cb	6	2024-04-09 15:07:02.125026+00	\N
38	fb2c6b8a-9915-5969-a6b7-8b5a42de1971-archived-2024-04-09T15:07:47.304197Z	9	2024-04-09 15:07:14.339726+00	\N
47	7965f822-0254-5858-abca-f6e8b4c27714	4	2024-04-09 15:07:55.495636+00	\N
14	6bd7ec60-8cb1-5c6b-a892-29e1fd2f8380	4	2024-04-09 15:07:00.817152+00	\N
28	3711ea88-9ccc-5b07-8f9d-042be449d72b	5	2024-04-09 15:07:09.070539+00	\N
13	99cf8a3a-48d6-57a4-b302-6e4482227ab6-archived-2024-04-09T15:08:39.962718Z	10	2024-04-09 15:07:00.221726+00	\N
24	f534a4ad-cef7-5234-b196-e67082ffb50c-archived-2024-04-09T15:07:55.470163Z	18	2024-04-09 15:07:05.809332+00	\N
49	99cf8a3a-48d6-57a4-b302-6e4482227ab6	2	2024-04-09 15:08:39.967296+00	\N
18	fa0d74a3-9240-5d9e-99fa-61c4137acf81	8	2024-04-09 15:07:02.391945+00	\N
11	7965f822-0254-5858-abca-f6e8b4c27714-archived-2024-04-09T15:07:55.492479Z	11	2024-04-09 15:06:59.720003+00	\N
10	c7a1e943-bf46-590b-bd26-bfc7c78def97	3	2024-04-09 15:06:59.481885+00	\N
9	116d49bd-85e1-5e59-b820-83f66db8800c	5	2024-04-09 15:06:59.021804+00	\N
40	1b0e9297-97dd-55d6-9874-8efde4d84c90-archived-2024-04-09T15:10:02.889619Z	8	2024-04-09 15:07:42.176473+00	\N
50	25677e37-fd33-5005-896c-9275b1284534-archived-2024-04-09T15:09:57.068090Z	7	2024-04-09 15:08:41.625797+00	\N
35	240f96b1-8d26-53b7-9e99-ffb0f2e735bf	5	2024-04-09 15:07:12.114705+00	\N
0	$all	371	2024-04-09 15:05:24.895599+00	\N
52	25677e37-fd33-5005-896c-9275b1284534	1	2024-04-09 15:09:57.072294+00	\N
33	f0c808b3-d869-5192-a944-20f66a6a8449	4	2024-04-09 15:07:10.398613+00	\N
23	69f4dcbb-efa2-5a16-8bc8-01df7dbb7384	4	2024-04-09 15:07:05.420718+00	\N
1	13e8c25c-3180-5a9a-95c8-51ec38e50cfc-archived-2024-04-09T15:07:55.507960Z	9	2024-04-09 15:06:55.5994+00	\N
37	81e9b629-c1e7-538f-bff1-47d3a6580522	4	2024-04-09 15:07:13.799921+00	\N
42	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	2	2024-04-09 15:07:47.307397+00	\N
46	f534a4ad-cef7-5234-b196-e67082ffb50c	48	2024-04-09 15:07:55.473074+00	\N
12	5284f376-c1f4-5178-8966-d490df3dab4f-archived-2024-04-09T15:07:50.104563Z	8	2024-04-09 15:07:00.091414+00	\N
53	9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f	2	2024-04-09 15:10:02.558493+00	\N
48	13e8c25c-3180-5a9a-95c8-51ec38e50cfc	2	2024-04-09 15:07:55.51069+00	\N
8	8a66f8fb-5fe9-51b3-a34c-24321271a4e3	3	2024-04-09 15:06:58.680875+00	\N
39	7269ee51-5007-5849-aaa7-7c4a98b0c9ce-archived-2024-04-09T15:07:50.122386Z	9	2024-04-09 15:07:15.064321+00	\N
44	7269ee51-5007-5849-aaa7-7c4a98b0c9ce	2	2024-04-09 15:07:50.125418+00	\N
4	1b0e9297-97dd-55d6-9874-8efde4d84c90-archived-2024-04-09T15:07:42.172047Z	9	2024-04-09 15:06:56.369486+00	\N
29	ddcb7992-2ffb-5c10-8b39-80685f6eaaba	5	2024-04-09 15:07:09.597827+00	\N
45	0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4	3	2024-04-09 15:07:52.786141+00	\N
25	6c9208eb-a5bb-57ef-be5c-6422dedab602	11	2024-04-09 15:07:06.937432+00	\N
16	098fc159-3ed6-58e7-91be-38fda8a833ea	5	2024-04-09 15:07:01.718783+00	\N
54	1b0e9297-97dd-55d6-9874-8efde4d84c90	2	2024-04-09 15:10:02.89386+00	\N
19	422686d6-b2d1-5092-93e8-a744854f5085	5	2024-04-09 15:07:03.80852+00	\N
27	927901fa-2c87-524e-b18c-3ef5187f504f	5	2024-04-09 15:07:08.415987+00	\N
34	25677e37-fd33-5005-896c-9275b1284534-archived-2024-04-09T15:08:41.622095Z	10	2024-04-09 15:07:11.586061+00	\N
5	469e7be5-4e20-5007-b044-c6f540a87493	7	2024-04-09 15:06:57.118893+00	\N
41	9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f-archived-2024-04-09T15:10:02.554552Z	8	2024-04-09 15:07:44.7445+00	\N
30	e0c182db-32ff-55c6-a9eb-2b82dd21bc8b	5	2024-04-09 15:07:09.746311+00	\N
3	9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f-archived-2024-04-09T15:07:44.740692Z	9	2024-04-09 15:06:56.008658+00	\N
26	a09d9cf3-46c1-505c-8fb8-4b0a71a9114e	5	2024-04-09 15:07:07.199085+00	\N
32	b767b3e9-e802-587e-a442-541d093b86b9	5	2024-04-09 15:07:10.026452+00	\N
20	9cd46919-5f19-59aa-993e-cf3736c71053-archived-2024-04-09T15:09:51.561439Z	10	2024-04-09 15:07:03.937747+00	\N
\.


--
-- Data for Name: subscriptions; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.subscriptions (subscription_id, stream_uuid, subscription_name, last_seen, created_at) FROM stdin;
6	$all	sles_subscription_projector	371	2024-04-09 15:05:25.293356+00
1	$all	database_projector	371	2024-04-09 15:05:25.28916+00
8	$all	stream_roll_up_event_handler	371	2024-04-09 15:05:25.293901+00
3	$all	host_projector	371	2024-04-09 15:05:25.289289+00
4	$all	sap_system_projector	371	2024-04-09 15:05:25.289329+00
5	$all	roll_up_event_handler	371	2024-04-09 15:05:25.289242+00
9	$all	deregistration_process_manager	371	2024-04-09 15:05:25.294649+00
2	$all	alerts_event_handler	371	2024-04-09 15:05:25.289202+00
7	$all	cluster_projector	371	2024-04-09 15:05:25.29387+00
\.


--
-- Name: streams_stream_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.streams_stream_id_seq', 54, true);


--
-- Name: subscriptions_subscription_id_seq; Type: SEQUENCE SET; Schema: public; Owner: postgres
--

SELECT pg_catalog.setval('public.subscriptions_subscription_id_seq', 9, true);


--
-- Name: events events_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.events
    ADD CONSTRAINT events_pkey PRIMARY KEY (event_id);


--
-- Name: schema_migrations schema_migrations_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.schema_migrations
    ADD CONSTRAINT schema_migrations_pkey PRIMARY KEY (major_version, minor_version, patch_version);


--
-- Name: snapshots snapshots_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.snapshots
    ADD CONSTRAINT snapshots_pkey PRIMARY KEY (source_uuid);


--
-- Name: stream_events stream_events_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stream_events
    ADD CONSTRAINT stream_events_pkey PRIMARY KEY (event_id, stream_id);


--
-- Name: streams streams_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.streams
    ADD CONSTRAINT streams_pkey PRIMARY KEY (stream_id);


--
-- Name: subscriptions subscriptions_pkey; Type: CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.subscriptions
    ADD CONSTRAINT subscriptions_pkey PRIMARY KEY (subscription_id);


--
-- Name: ix_stream_events; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX ix_stream_events ON public.stream_events USING btree (stream_id, stream_version);


--
-- Name: ix_streams_stream_uuid; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX ix_streams_stream_uuid ON public.streams USING btree (stream_uuid);


--
-- Name: ix_subscriptions_stream_uuid_subscription_name; Type: INDEX; Schema: public; Owner: postgres
--

CREATE UNIQUE INDEX ix_subscriptions_stream_uuid_subscription_name ON public.subscriptions USING btree (stream_uuid, subscription_name);


--
-- Name: streams event_notification; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER event_notification AFTER INSERT OR UPDATE ON public.streams FOR EACH ROW EXECUTE FUNCTION public.notify_events();


--
-- Name: events no_delete_events; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER no_delete_events BEFORE DELETE ON public.events FOR EACH STATEMENT EXECUTE FUNCTION public.event_store_delete('Cannot delete events');


--
-- Name: stream_events no_delete_stream_events; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER no_delete_stream_events BEFORE DELETE ON public.stream_events FOR EACH STATEMENT EXECUTE FUNCTION public.event_store_delete('Cannot delete stream events');


--
-- Name: streams no_delete_streams; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER no_delete_streams BEFORE DELETE ON public.streams FOR EACH STATEMENT EXECUTE FUNCTION public.event_store_delete('Cannot delete streams');


--
-- Name: events no_update_events; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER no_update_events BEFORE UPDATE ON public.events FOR EACH STATEMENT EXECUTE FUNCTION public.event_store_exception('Cannot update events');


--
-- Name: stream_events no_update_stream_events; Type: TRIGGER; Schema: public; Owner: postgres
--

CREATE TRIGGER no_update_stream_events BEFORE UPDATE ON public.stream_events FOR EACH STATEMENT EXECUTE FUNCTION public.event_store_exception('Cannot update stream events');


--
-- Name: stream_events stream_events_event_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stream_events
    ADD CONSTRAINT stream_events_event_id_fkey FOREIGN KEY (event_id) REFERENCES public.events(event_id);


--
-- Name: stream_events stream_events_original_stream_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stream_events
    ADD CONSTRAINT stream_events_original_stream_id_fkey FOREIGN KEY (original_stream_id) REFERENCES public.streams(stream_id);


--
-- Name: stream_events stream_events_stream_id_fkey; Type: FK CONSTRAINT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.stream_events
    ADD CONSTRAINT stream_events_stream_id_fkey FOREIGN KEY (stream_id) REFERENCES public.streams(stream_id);


--
-- PostgreSQL database dump complete
--

