--
-- PostgreSQL database dump
--

-- Dumped from database version 15.6 (Debian 15.6-1.pgdg120+2)
-- Dumped by pg_dump version 15.6 (Debian 15.6-1.pgdg120+2)

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

--
-- Name: trento_dev; Type: DATABASE; Schema: -; Owner: postgres
--

CREATE DATABASE trento_dev WITH TEMPLATE = template0 ENCODING = 'UTF8' LOCALE_PROVIDER = libc LOCALE = 'en_US.utf8';


ALTER DATABASE trento_dev OWNER TO postgres;

\connect trento_dev

SET statement_timeout = 0;
SET lock_timeout = 0;
SET idle_in_transaction_session_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SELECT pg_catalog.set_config('search_path', '', false);
SET check_function_bodies = false;
SET xmloption = content;
SET client_min_messages = warning;
SET row_security = off;

SET default_tablespace = '';

SET default_table_access_method = heap;

--
-- Name: application_instances; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.application_instances (
    sap_system_id uuid NOT NULL,
    host_id uuid NOT NULL,
    instance_number character varying(255) NOT NULL,
    instance_hostname character varying(255),
    sid character varying(255),
    features character varying(255),
    http_port integer,
    https_port integer,
    start_priority character varying(255),
    health character varying(255),
    absent_at timestamp without time zone,
    inserted_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL,
    updated_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL
);


ALTER TABLE public.application_instances OWNER TO postgres;

--
-- Name: clusters; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.clusters (
    id uuid NOT NULL,
    name character varying(255),
    sid character varying(255),
    type character varying(255),
    selected_checks character varying(255)[],
    health character varying(255),
    details jsonb,
    checks_execution character varying(255),
    resources_number integer,
    hosts_number integer,
    provider character varying(255),
    deregistered_at timestamp without time zone,
    additional_sids character varying(255)[] DEFAULT ARRAY[]::character varying[],
    inserted_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL,
    updated_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL
);


ALTER TABLE public.clusters OWNER TO postgres;

--
-- Name: clusters_enrichment_data; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.clusters_enrichment_data (
    cluster_id uuid NOT NULL,
    cib_last_written character varying(255),
    inserted_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL,
    updated_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL
);


ALTER TABLE public.clusters_enrichment_data OWNER TO postgres;

--
-- Name: database_instances; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.database_instances (
    sap_system_id uuid NOT NULL,
    host_id uuid NOT NULL,
    instance_number character varying(255) NOT NULL,
    instance_hostname character varying(255),
    sid character varying(255),
    tenant character varying(255),
    features character varying(255),
    http_port integer,
    https_port integer,
    start_priority character varying(255),
    health character varying(255),
    system_replication character varying(255),
    system_replication_status character varying(255),
    absent_at timestamp without time zone,
    inserted_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL,
    updated_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL
);


ALTER TABLE public.database_instances OWNER TO postgres;

--
-- Name: databases; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.databases (
    id uuid NOT NULL,
    sid character varying(255),
    health character varying(255),
    deregistered_at timestamp without time zone,
    inserted_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL,
    updated_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL
);


ALTER TABLE public.databases OWNER TO postgres;

--
-- Name: discarded_discovery_events; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.discarded_discovery_events (
    id bigint NOT NULL,
    payload jsonb,
    reason text,
    inserted_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL,
    updated_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL
);


ALTER TABLE public.discarded_discovery_events OWNER TO postgres;

--
-- Name: discarded_discovery_events_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.discarded_discovery_events_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.discarded_discovery_events_id_seq OWNER TO postgres;

--
-- Name: discarded_discovery_events_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.discarded_discovery_events_id_seq OWNED BY public.discarded_discovery_events.id;


--
-- Name: discovery_events; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.discovery_events (
    id bigint NOT NULL,
    agent_id uuid,
    discovery_type character varying(255),
    payload jsonb,
    inserted_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL,
    updated_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL
);


ALTER TABLE public.discovery_events OWNER TO postgres;

--
-- Name: discovery_events_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.discovery_events_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.discovery_events_id_seq OWNER TO postgres;

--
-- Name: discovery_events_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.discovery_events_id_seq OWNED BY public.discovery_events.id;


--
-- Name: fun_with_flags_toggles; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.fun_with_flags_toggles (
    id bigint NOT NULL,
    flag_name character varying(255) NOT NULL,
    gate_type character varying(255) NOT NULL,
    target character varying(255) NOT NULL,
    enabled boolean NOT NULL
);


ALTER TABLE public.fun_with_flags_toggles OWNER TO postgres;

--
-- Name: fun_with_flags_toggles_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.fun_with_flags_toggles_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.fun_with_flags_toggles_id_seq OWNER TO postgres;

--
-- Name: fun_with_flags_toggles_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.fun_with_flags_toggles_id_seq OWNED BY public.fun_with_flags_toggles.id;


--
-- Name: heartbeats; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.heartbeats (
    agent_id character varying(255) NOT NULL,
    "timestamp" timestamp without time zone,
    inserted_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL,
    updated_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL
);


ALTER TABLE public.heartbeats OWNER TO postgres;

--
-- Name: hosts; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.hosts (
    id uuid NOT NULL,
    hostname character varying(255),
    ip_addresses character varying(255)[],
    agent_version character varying(255),
    heartbeat character varying(255),
    provider character varying(255),
    cluster_id uuid,
    provider_data jsonb,
    deregistered_at timestamp without time zone,
    selected_checks character varying(255)[] DEFAULT ARRAY[]::character varying[],
    saptune_status jsonb,
    health character varying(255),
    fully_qualified_domain_name character varying(255),
    inserted_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL,
    updated_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL
);


ALTER TABLE public.hosts OWNER TO postgres;

--
-- Name: projection_versions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.projection_versions (
    projection_name text NOT NULL,
    last_seen_event_number bigint,
    inserted_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL,
    updated_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL
);


ALTER TABLE public.projection_versions OWNER TO postgres;

--
-- Name: sap_systems; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sap_systems (
    id uuid NOT NULL,
    sid character varying(255),
    tenant character varying(255),
    db_host character varying(255),
    health character varying(255),
    deregistered_at timestamp without time zone,
    ensa_version character varying(255),
    inserted_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL,
    updated_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL
);


ALTER TABLE public.sap_systems OWNER TO postgres;

--
-- Name: schema_migrations; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.schema_migrations (
    version bigint NOT NULL,
    inserted_at timestamp(0) without time zone
);


ALTER TABLE public.schema_migrations OWNER TO postgres;

--
-- Name: settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.settings (
    installation_settings_installation_id uuid,
    installation_settings_eula_accepted boolean DEFAULT false,
    inserted_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL,
    updated_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL,
    id uuid NOT NULL,
    type character varying(255) NOT NULL,
    api_key_settings_jti uuid,
    api_key_settings_created_at timestamp without time zone,
    api_key_settings_expire_at timestamp without time zone
);


ALTER TABLE public.settings OWNER TO postgres;

--
-- Name: sles_subscriptions; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.sles_subscriptions (
    host_id uuid NOT NULL,
    identifier character varying(255) NOT NULL,
    version character varying(255),
    arch character varying(255),
    status character varying(255),
    subscription_status character varying(255),
    type character varying(255),
    starts_at character varying(255),
    expires_at character varying(255),
    inserted_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL,
    updated_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL
);


ALTER TABLE public.sles_subscriptions OWNER TO postgres;

--
-- Name: software_update_settings; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.software_update_settings (
    id uuid DEFAULT '27f86af8-a227-4d53-b2bf-28e3178a5dc0'::uuid NOT NULL,
    url character varying(255) DEFAULT NULL::character varying,
    username character varying(255) DEFAULT NULL::character varying,
    password bytea,
    ca_cert bytea,
    ca_uploaded_at timestamp without time zone,
    inserted_at timestamp(0) without time zone NOT NULL,
    updated_at timestamp(0) without time zone NOT NULL,
    CONSTRAINT only_one_record CHECK ((id = '27f86af8-a227-4d53-b2bf-28e3178a5dc0'::uuid))
);


ALTER TABLE public.software_update_settings OWNER TO postgres;

--
-- Name: tags; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.tags (
    id bigint NOT NULL,
    value character varying(255),
    resource_id uuid,
    resource_type character varying(255),
    inserted_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL,
    updated_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL
);


ALTER TABLE public.tags OWNER TO postgres;

--
-- Name: tags_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.tags_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.tags_id_seq OWNER TO postgres;

--
-- Name: tags_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.tags_id_seq OWNED BY public.tags.id;


--
-- Name: users; Type: TABLE; Schema: public; Owner: postgres
--

CREATE TABLE public.users (
    id bigint NOT NULL,
    username character varying(255) NOT NULL,
    password_hash character varying(255),
    inserted_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL,
    updated_at timestamp without time zone DEFAULT '2024-04-09 15:05:22.873727'::timestamp without time zone NOT NULL
);


ALTER TABLE public.users OWNER TO postgres;

--
-- Name: users_id_seq; Type: SEQUENCE; Schema: public; Owner: postgres
--

CREATE SEQUENCE public.users_id_seq
    START WITH 1
    INCREMENT BY 1
    NO MINVALUE
    NO MAXVALUE
    CACHE 1;


ALTER TABLE public.users_id_seq OWNER TO postgres;

--
-- Name: users_id_seq; Type: SEQUENCE OWNED BY; Schema: public; Owner: postgres
--

ALTER SEQUENCE public.users_id_seq OWNED BY public.users.id;


--
-- Name: discarded_discovery_events id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.discarded_discovery_events ALTER COLUMN id SET DEFAULT nextval('public.discarded_discovery_events_id_seq'::regclass);


--
-- Name: discovery_events id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.discovery_events ALTER COLUMN id SET DEFAULT nextval('public.discovery_events_id_seq'::regclass);


--
-- Name: fun_with_flags_toggles id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.fun_with_flags_toggles ALTER COLUMN id SET DEFAULT nextval('public.fun_with_flags_toggles_id_seq'::regclass);


--
-- Name: tags id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.tags ALTER COLUMN id SET DEFAULT nextval('public.tags_id_seq'::regclass);


--
-- Name: users id; Type: DEFAULT; Schema: public; Owner: postgres
--

ALTER TABLE ONLY public.users ALTER COLUMN id SET DEFAULT nextval('public.users_id_seq'::regclass);


--
-- Data for Name: application_instances; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.application_instances (sap_system_id, host_id, instance_number, instance_hostname, sid, features, http_port, https_port, start_priority, health, absent_at, inserted_at, updated_at) FROM stdin;
6c9208eb-a5bb-57ef-be5c-6422dedab602	0fc07435-7ee2-54ca-b0de-fb27ffdc5deb	02	sapnwpaas1	NWP	ABAP|GATEWAY|ICMAN|IGS	50213	50214	3	passing	\N	2024-04-09 15:07:10.279416	2024-04-09 15:07:10.279416
cd52e571-c897-5bba-b0f9-e155ceca1fff	81e9b629-c1e7-538f-bff1-47d3a6580522	02	sapnwqaas1	NWQ	ABAP|GATEWAY|ICMAN|IGS	50213	50214	3	passing	\N	2024-04-09 15:07:12.491693	2024-04-09 15:07:12.491693
6c9208eb-a5bb-57ef-be5c-6422dedab602	116d49bd-85e1-5e59-b820-83f66db8800c	00	sapnwpas	NWP	MESSAGESERVER|ENQUE	50013	50014	1	passing	\N	2024-04-09 15:07:13.550958	2024-04-09 15:07:13.550958
cd52e571-c897-5bba-b0f9-e155ceca1fff	3711ea88-9ccc-5b07-8f9d-042be449d72b	10	sapnwqer	NWQ	ENQREP	51013	51014	0.5	passing	\N	2024-04-09 15:07:14.748525	2024-04-09 15:07:14.748525
6c9208eb-a5bb-57ef-be5c-6422dedab602	a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12	01	sapnwppas	NWP	ABAP|GATEWAY|ICMAN|IGS	50113	50114	3	passing	\N	2024-04-09 15:07:18.615667	2024-04-09 15:07:18.615667
cd52e571-c897-5bba-b0f9-e155ceca1fff	098fc159-3ed6-58e7-91be-38fda8a833ea	01	sapnwqpas	NWQ	ABAP|GATEWAY|ICMAN|IGS	50113	50114	3	passing	\N	2024-04-09 15:07:18.764257	2024-04-09 15:07:18.764257
6c9208eb-a5bb-57ef-be5c-6422dedab602	4b30a6af-4b52-5bda-bccb-f2248a12c992	10	sapnwper	NWP	ENQREP	51013	51014	0.5	passing	\N	2024-04-09 15:07:20.772301	2024-04-09 15:07:20.772301
f534a4ad-cef7-5234-b196-e67082ffb50c	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	10	sapnwder	NWD	ENQREP	51013	51014	0.5	passing	\N	2024-04-09 15:08:36.455364	2024-04-09 15:09:49.987725
f534a4ad-cef7-5234-b196-e67082ffb50c	1b0e9297-97dd-55d6-9874-8efde4d84c90	02	sapnwdaas1	NWD	ABAP|GATEWAY|ICMAN|IGS	50213	50214	3	passing	\N	2024-04-09 15:10:10.389234	2024-04-09 15:10:10.389234
\.


--
-- Data for Name: clusters; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.clusters (id, name, sid, type, selected_checks, health, details, checks_execution, resources_number, hosts_number, provider, deregistered_at, additional_sids, inserted_at, updated_at) FROM stdin;
8a66f8fb-5fe9-51b3-a34c-24321271a4e3	drbd_cluster	\N	unknown	{}	unknown	\N	\N	9	2	azure	\N	{}	2024-04-09 15:06:58.68595	2024-04-09 15:06:58.68595
c7a1e943-bf46-590b-bd26-bfc7c78def97	drbd_cluster	\N	unknown	{}	unknown	\N	\N	9	2	azure	\N	{}	2024-04-09 15:06:59.485933	2024-04-09 15:06:59.485933
fb861bce-d212-56b5-8786-74afd6eb58cb	netweaver_cluster	\N	ascs_ers	{}	passing	{"sap_systems": [{"sid": "NWQ", "nodes": [{"name": "vmnwqas01", "roles": ["ascs"], "status": "Online", "resources": [{"id": "rsc_ip_NWQ_ASCS00", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_fs_NWQ_ASCS00", "role": "Started", "type": "ocf::heartbeat:Filesystem", "status": "Active", "managed": true, "fail_count": 1}, {"id": "rsc_sap_NWQ_ASCS00", "role": "Started", "type": "ocf::heartbeat:SAPInstance", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_NWQ_ASCS00", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {}, "filesystems": ["/usr/sap/NWQ/ASCS00"], "virtual_ips": ["10.90.1.25"]}, {"name": "vmnwqas02", "roles": ["ers"], "status": "Online", "resources": [{"id": "rsc_ip_NWQ_ERS10", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_fs_NWQ_ERS10", "role": "Started", "type": "ocf::heartbeat:Filesystem", "status": "Active", "managed": true, "fail_count": 1}, {"id": "rsc_sap_NWQ_ERS10", "role": "Started", "type": "ocf::heartbeat:SAPInstance", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_NWQ_ERS10", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"runs_ers_NWQ": "1"}, "filesystems": ["/usr/sap/NWQ/ERS10"], "virtual_ips": ["10.90.1.26"]}], "distributed": true, "filesystem_resource_based": true}], "sbd_devices": [{"device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_813ace38-2d4f-48f6-8aa2-5360252ca492", "status": "healthy"}], "fencing_type": "external/sbd", "maintenance_mode": false, "stopped_resources": []}	\N	9	2	azure	\N	{NWQ}	2024-04-09 15:07:02.131094	2024-04-09 15:07:02.131094
6bd7ec60-8cb1-5c6b-a892-29e1fd2f8380	drbd_cluster	\N	unknown	{}	unknown	\N	\N	9	2	azure	\N	{}	2024-04-09 15:07:00.821702	2024-04-09 15:07:02.537695
469e7be5-4e20-5007-b044-c6f540a87493	hana_cluster_3	HDP	hana_scale_up	{}	passing	{"nodes": [{"name": "vmhdbprd01", "site": "NBG", "status": "Online", "resources": [{"id": "stonith-sbd", "role": "Started", "type": "stonith:external/sbd", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHana_HDP_HDB10", "role": "Master", "type": "ocf::suse:SAPHana", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHanaTopology_HDP_HDB10", "role": "Started", "type": "ocf::suse:SAPHanaTopology", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_ip_HDP_HDB10", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_HDP_HDB10", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"lpa_hdp_lpt": "1643125019", "hana_hdp_site": "NBG", "hana_hdp_roles": "4:P:master1:master:worker:master", "hana_hdp_vhost": "vmhdbprd01", "hana_hdp_srmode": "sync", "hana_hdp_op_mode": "logreplay", "hana_hdp_version": "2.00.057.00.1629894416", "hana_hdp_remoteHost": "vmhdbprd02", "hana_hdp_sync_state": "PRIM", "hana_hdp_clone_state": "PROMOTED", "master-rsc_SAPHana_HDP_HDB10": "150"}, "virtual_ip": "10.80.1.13", "hana_status": "Primary", "nameserver_actual_role": "master", "indexserver_actual_role": "master"}, {"name": "vmhdbprd02", "site": "WDF", "status": "Online", "resources": [{"id": "rsc_SAPHana_HDP_HDB10", "role": "Slave", "type": "ocf::suse:SAPHana", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHanaTopology_HDP_HDB10", "role": "Started", "type": "ocf::suse:SAPHanaTopology", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"lpa_hdp_lpt": "30", "hana_hdp_site": "WDF", "hana_hdp_roles": "4:S:master1:master:worker:master", "hana_hdp_vhost": "vmhdbprd02", "hana_hdp_srmode": "sync", "hana_hdp_op_mode": "logreplay", "hana_hdp_version": "2.00.057.00.1629894416", "hana_hdp_remoteHost": "vmhdbprd01", "hana_hdp_sync_state": "SOK", "hana_hdp_clone_state": "DEMOTED", "master-rsc_SAPHana_HDP_HDB10": "100"}, "virtual_ip": null, "hana_status": "Secondary", "nameserver_actual_role": "master", "indexserver_actual_role": "master"}], "sites": [{"name": "NBG", "state": "Primary", "sr_health_state": "4"}, {"name": "WDF", "state": "Secondary", "sr_health_state": "4"}], "sbd_devices": [{"device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b924e77", "status": "healthy"}, {"device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b912345", "status": "unhealthy"}, {"device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b954321", "status": "unknown"}], "fencing_type": "external/sbd", "sr_health_state": "4", "maintenance_mode": false, "stopped_resources": [], "secondary_sync_state": "SOK", "system_replication_mode": "sync", "system_replication_operation_mode": "logreplay"}	\N	7	2	azure	\N	{}	2024-04-09 15:06:57.13028	2024-04-09 15:07:05.142676
7965f822-0254-5858-abca-f6e8b4c27714	hana_cluster_1	HDD	hana_scale_up	{}	critical	{"nodes": [{"name": "vmhdbdev01", "site": "NBG", "status": "Online", "resources": [{"id": "stonith-sbd", "role": "Started", "type": "stonith:external/sbd", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHanaTopology_HDD_HDB10", "role": "Started", "type": "ocf::suse:SAPHanaTopology", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"lpa_hdd_lpt": "10", "hana_hdd_site": "NBG", "hana_hdd_roles": "1:P:master1::worker:", "hana_hdd_vhost": "vmhdbdev01", "hana_hdd_srmode": "sync", "hana_hdd_op_mode": "logreplay", "hana_hdd_version": "2.00.057.00.1629894416", "hana_hdd_remoteHost": "vmhdbdev02", "hana_hdd_sync_state": "SFAIL", "hana_hdd_clone_state": "UNDEFINED", "master-rsc_SAPHana_HDD_HDB10": "-9000"}, "virtual_ip": null, "hana_status": "Failed", "nameserver_actual_role": null, "indexserver_actual_role": null}, {"name": "vmhdbdev02", "site": "WDF", "status": "Online", "resources": [{"id": "rsc_SAPHana_HDD_HDB10", "role": "Master", "type": "ocf::suse:SAPHana", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHanaTopology_HDD_HDB10", "role": "Started", "type": "ocf::suse:SAPHanaTopology", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_ip_HDD_HDB10", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_HDD_HDB10", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"lpa_hdd_lpt": "1643125026", "hana_hdd_site": "WDF", "hana_hdd_roles": "4:P:master1:master:worker:master", "hana_hdd_vhost": "vmhdbdev02", "hana_hdd_srmode": "sync", "hana_hdd_op_mode": "logreplay", "hana_hdd_version": "2.00.057.00.1629894416", "hana_hdd_remoteHost": "vmhdbdev01", "hana_hdd_sync_state": "PRIM", "hana_hdd_clone_state": "PROMOTED", "master-rsc_SAPHana_HDD_HDB10": "150"}, "virtual_ip": "10.100.1.13", "hana_status": "Primary", "nameserver_actual_role": "master", "indexserver_actual_role": "master"}], "sites": [{"name": "NBG", "state": "Failed", "sr_health_state": "1"}, {"name": "WDF", "state": "Primary", "sr_health_state": "4"}], "sbd_devices": [{"device": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:182cb1b1-a815-4b82-b538-7a166b9bbb4a", "status": "healthy"}], "fencing_type": "external/sbd", "sr_health_state": "1", "maintenance_mode": false, "stopped_resources": [{"id": "rsc_SAPHana_HDD_HDB10", "role": "Stopped", "type": "ocf::suse:SAPHana", "status": null, "managed": null, "fail_count": null}], "secondary_sync_state": "SFAIL", "system_replication_mode": "sync", "system_replication_operation_mode": "logreplay"}	\N	7	2	azure	\N	{}	2024-04-09 15:06:59.724417	2024-04-09 15:08:20.757052
0eac831a-aa66-5f45-89a4-007fbd2c5714	netweaver_cluster	\N	ascs_ers	{}	passing	{"sap_systems": [{"sid": "NWP", "nodes": [{"name": "vmnwprd01", "roles": ["ascs"], "status": "Online", "resources": [{"id": "rsc_ip_NWP_ASCS00", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_fs_NWP_ASCS00", "role": "Started", "type": "ocf::heartbeat:Filesystem", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_sap_NWP_ASCS00", "role": "Started", "type": "ocf::heartbeat:SAPInstance", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_NWP_ASCS00", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {}, "filesystems": ["/usr/sap/NWP/ASCS00"], "virtual_ips": ["10.80.1.25"]}, {"name": "vmnwprd02", "roles": ["ers"], "status": "Online", "resources": [{"id": "rsc_ip_NWP_ERS10", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_fs_NWP_ERS10", "role": "Started", "type": "ocf::heartbeat:Filesystem", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_sap_NWP_ERS10", "role": "Started", "type": "ocf::heartbeat:SAPInstance", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_NWP_ERS10", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"runs_ers_NWP": "1"}, "filesystems": ["/usr/sap/NWP/ERS10"], "virtual_ips": ["10.80.1.26"]}], "distributed": true, "filesystem_resource_based": true}], "sbd_devices": [{"device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_e34218cd-0d9a-4b21-b6d5-a313980baa82", "status": "healthy"}], "fencing_type": "external/sbd", "maintenance_mode": false, "stopped_resources": []}	\N	9	2	azure	\N	{NWP}	2024-04-09 15:06:57.267909	2024-04-09 15:07:08.824204
5284f376-c1f4-5178-8966-d490df3dab4f	netweaver_cluster	\N	ascs_ers	{}	passing	{"sap_systems": [{"sid": "NWD", "nodes": [{"name": "vmnwdev01", "roles": ["ascs"], "status": "Online", "resources": [{"id": "rsc_ip_NWD_ASCS00", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_fs_NWD_ASCS00", "role": "Started", "type": "ocf::heartbeat:Filesystem", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_sap_NWD_ASCS00", "role": "Started", "type": "ocf::heartbeat:SAPInstance", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_NWD_ASCS00", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {}, "filesystems": ["/usr/sap/NWD/ASCS00"], "virtual_ips": ["10.100.1.25"]}, {"name": "vmnwdev02", "roles": ["ers"], "status": "Online", "resources": [{"id": "rsc_ip_NWD_ERS10", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_fs_NWD_ERS10", "role": "Started", "type": "ocf::heartbeat:Filesystem", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_sap_NWD_ERS10", "role": "Started", "type": "ocf::heartbeat:SAPInstance", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_NWD_ERS10", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"runs_ers_NWD": "1"}, "filesystems": ["/usr/sap/NWD/ERS10"], "virtual_ips": ["10.100.1.26"]}], "distributed": true, "filesystem_resource_based": true}], "sbd_devices": [{"device": "/dev/disk/by-id/scsi-36001405f01eb5f4c5c941e499beb055d", "status": "healthy"}], "fencing_type": "external/sbd", "maintenance_mode": false, "stopped_resources": []}	\N	9	2	azure	\N	{NWD}	2024-04-09 15:07:00.100541	2024-04-09 15:08:21.136588
fa0d74a3-9240-5d9e-99fa-61c4137acf81	hana_cluster_2	HDQ	hana_scale_up	{}	passing	{"nodes": [{"name": "vmhdbqas01", "site": "NBG", "status": "Online", "resources": [{"id": "stonith-sbd", "role": "Started", "type": "stonith:external/sbd", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHana_HDQ_HDB10", "role": "Master", "type": "ocf::suse:SAPHana", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHanaTopology_HDQ_HDB10", "role": "Started", "type": "ocf::suse:SAPHanaTopology", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_ip_HDQ_HDB10", "role": "Started", "type": "ocf::heartbeat:IPaddr2", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_socat_HDQ_HDB10", "role": "Started", "type": "ocf::heartbeat:azure-lb", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"lpa_hdq_lpt": "1643125033", "hana_hdq_site": "NBG", "hana_hdq_roles": "4:P:master1:master:worker:master", "hana_hdq_vhost": "vmhdbqas01", "hana_hdq_srmode": "sync", "hana_hdq_op_mode": "logreplay", "hana_hdq_version": "2.00.057.00.1629894416", "hana_hdq_remoteHost": "vmhdbqas02", "hana_hdq_sync_state": "PRIM", "hana_hdq_clone_state": "PROMOTED", "master-rsc_SAPHana_HDQ_HDB10": "150"}, "virtual_ip": "10.90.1.13", "hana_status": "Primary", "nameserver_actual_role": "master", "indexserver_actual_role": "master"}, {"name": "vmhdbqas02", "site": "WDF", "status": "Online", "resources": [{"id": "rsc_SAPHana_HDQ_HDB10", "role": "Slave", "type": "ocf::suse:SAPHana", "status": "Active", "managed": true, "fail_count": 0}, {"id": "rsc_SAPHanaTopology_HDQ_HDB10", "role": "Started", "type": "ocf::suse:SAPHanaTopology", "status": "Active", "managed": true, "fail_count": 0}], "attributes": {"lpa_hdq_lpt": "30", "hana_hdq_site": "WDF", "hana_hdq_roles": "4:S:master1:master:worker:master", "hana_hdq_vhost": "vmhdbqas02", "hana_hdq_srmode": "sync", "hana_hdq_op_mode": "logreplay", "hana_hdq_version": "2.00.057.00.1629894416", "hana_hdq_remoteHost": "vmhdbqas01", "hana_hdq_sync_state": "SOK", "hana_hdq_clone_state": "DEMOTED", "master-rsc_SAPHana_HDQ_HDB10": "100"}, "virtual_ip": null, "hana_status": "Secondary", "nameserver_actual_role": "master", "indexserver_actual_role": "master"}], "sites": [{"name": "NBG", "state": "Primary", "sr_health_state": "4"}, {"name": "WDF", "state": "Secondary", "sr_health_state": "4"}], "sbd_devices": [{"device": "/dev/disk/by-id/scsi-360014058d88c7795c6a4b66bc024f4bd", "status": "healthy"}], "fencing_type": "external/sbd", "sr_health_state": "4", "maintenance_mode": false, "stopped_resources": [], "secondary_sync_state": "SOK", "system_replication_mode": "sync", "system_replication_operation_mode": "logreplay"}	\N	7	2	azure	\N	{}	2024-04-09 15:07:02.3963	2024-04-09 15:07:12.656831
\.


--
-- Data for Name: clusters_enrichment_data; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.clusters_enrichment_data (cluster_id, cib_last_written, inserted_at, updated_at) FROM stdin;
469e7be5-4e20-5007-b044-c6f540a87493	Tue Jan 25 15:36:59 2022	2024-04-09 15:06:57.112813	2024-04-09 15:06:57.112813
0eac831a-aa66-5f45-89a4-007fbd2c5714	Tue Jan 11 13:43:06 2022	2024-04-09 15:06:57.260651	2024-04-09 15:06:57.260651
8a66f8fb-5fe9-51b3-a34c-24321271a4e3	Tue Jan 11 12:20:56 2022	2024-04-09 15:06:58.677361	2024-04-09 15:06:58.677361
c7a1e943-bf46-590b-bd26-bfc7c78def97	Tue Jan 11 13:24:06 2022	2024-04-09 15:06:59.47896	2024-04-09 15:06:59.47896
7965f822-0254-5858-abca-f6e8b4c27714	Tue Jan 25 15:37:06 2022	2024-04-09 15:06:59.716601	2024-04-09 15:06:59.716601
5284f376-c1f4-5178-8966-d490df3dab4f	Tue Jan 11 12:55:06 2022	2024-04-09 15:07:00.088168	2024-04-09 15:07:00.088168
6bd7ec60-8cb1-5c6b-a892-29e1fd2f8380	Tue Jan 11 12:50:53 2022	2024-04-09 15:07:00.814352	2024-04-09 15:07:00.814352
fb861bce-d212-56b5-8786-74afd6eb58cb	Mon Jan 17 12:41:40 2022	2024-04-09 15:07:02.121706	2024-04-09 15:07:02.121706
fa0d74a3-9240-5d9e-99fa-61c4137acf81	Tue Jan 25 15:37:13 2022	2024-04-09 15:07:02.388652	2024-04-09 15:07:02.388652
\.


--
-- Data for Name: database_instances; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.database_instances (sap_system_id, host_id, instance_number, instance_hostname, sid, tenant, features, http_port, https_port, start_priority, health, system_replication, system_replication_status, absent_at, inserted_at, updated_at) FROM stdin;
cd52e571-c897-5bba-b0f9-e155ceca1fff	e0c182db-32ff-55c6-a9eb-2b82dd21bc8b	10	vmhdbqas02	HDQ	HDQ	HDB|HDB_WORKER	51013	51014	0.3	passing	Secondary	\N	\N	2024-04-09 15:07:17.011874	2024-04-09 15:07:17.011874
6c9208eb-a5bb-57ef-be5c-6422dedab602	b767b3e9-e802-587e-a442-541d093b86b9	10	vmhdbprd02	HDP	HDP	HDB|HDB_WORKER	51013	51014	0.3	passing	Secondary	\N	\N	2024-04-09 15:07:19.711474	2024-04-09 15:07:19.711474
f534a4ad-cef7-5234-b196-e67082ffb50c	0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4	10	vmhdbdev02	HDD	HDD	HDB|HDB_WORKER	51013	51014	0.3	passing	Secondary	\N	\N	2024-04-09 15:08:32.900404	2024-04-09 15:08:32.900404
cd52e571-c897-5bba-b0f9-e155ceca1fff	99cf8a3a-48d6-57a4-b302-6e4482227ab6	10	vmhdbqas01	HDQ	HDQ	HDB|HDB_WORKER	51013	51014	0.3	passing	Primary	ACTIVE	\N	2024-04-09 15:08:40.98058	2024-04-09 15:08:40.98058
f534a4ad-cef7-5234-b196-e67082ffb50c	13e8c25c-3180-5a9a-95c8-51ec38e50cfc	10	vmhdbdev01	HDD	HDD	HDB|HDB_WORKER	51013	51014	0.3	critical	Primary	ACTIVE	\N	2024-04-09 15:09:20.659205	2024-04-09 15:09:48.990053
\.


--
-- Data for Name: databases; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.databases (id, sid, health, deregistered_at, inserted_at, updated_at) FROM stdin;
cd52e571-c897-5bba-b0f9-e155ceca1fff	HDQ	passing	\N	2024-04-09 15:07:09.903133	2024-04-09 15:08:40.984404
f534a4ad-cef7-5234-b196-e67082ffb50c	HDD	critical	\N	2024-04-09 15:07:05.819784	2024-04-09 15:09:48.993151
6c9208eb-a5bb-57ef-be5c-6422dedab602	HDP	passing	2024-04-09 15:09:51.52125	2024-04-09 15:07:06.942765	2024-04-09 15:09:51.544525
\.


--
-- Data for Name: discarded_discovery_events; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.discarded_discovery_events (id, payload, reason, inserted_at, updated_at) FROM stdin;
\.


--
-- Data for Name: discovery_events; Type: TABLE DATA; Schema: public; Owner: postgres
--

COPY public.discovery_events (id, agent_id, discovery_type, payload, inserted_at, updated_at) FROM stdin;
1	13e8c25c-3180-5a9a-95c8-51ec38e50cfc	host_discovery	{"hostname": "vmhdbdev01", "cpu_count": 4, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.100.1.11", "10.100.1.13", "fe80::6245:bdff:fe8d:9b69"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 32107, "fully_qualified_domain_name": "vmhdbdev01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:06:55.573496	2024-04-09 15:06:55.573496
2	116d49bd-85e1-5e59-b820-83f66db8800c	saptune_discovery	{"status": {"pid": 24623, "argv": "saptune --format json status", "result": {"staging": {"Notes staged": [], "staging enabled": false, "Solutions staged": []}, "services": {"tuned": [], "sapconf": [], "saptune": ["enabled", "active"]}, "tuning state": "not compliant", "Notes applied": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Notes enabled": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "virtualization": "oracle", "package version": "3.1.0", "Solution applied": [{"Solution ID": "NETWEAVER", "applied partially": false}], "Solution enabled": ["NETWEAVER"], "remember message": "\\nRegarding the tuning state of the system please use 'saptune note verify' for detailed information.\\n\\n", "configured version": "3", "systemd system state": "running", "Notes applied by Solution": [{"Note list": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Solution ID": "NETWEAVER"}], "Notes enabled by Solution": [{"Note list": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Solution ID": "NETWEAVER"}], "Notes enabled additionally": []}, "$schema": "file:///usr/share/saptune/schemas/1.0/saptune_status.schema.json", "command": "status", "messages": [{"message": "actions.go:85: ATTENTION: You are running a test version (3.1.0 from 2022/11/28) of saptune which is not supported for production use\\n", "priority": "NOTICE"}, {"message": "sysctl.go:73: Parameter 'kernel.shmmax' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0xffffffffffffffff), /boot/sysctl.conf-5.3.18-150300.59.93-default(0xffffffffffffffff).\\n", "priority": "WARNING"}, {"message": "sysctl.go:73: Parameter 'kernel.shmall' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0x0fffffffffffff00), /boot/sysctl.conf-5.3.18-150300.59.93-default(0x0fffffffffffff00).\\n", "priority": "WARNING"}, {"message": "ini.go:308: block device related section settings detected: Traversing all block devices can take a considerable amount of time.\\n", "priority": "NOTICE"}], "exit code": 4, "publish time": "2023-04-24 12:41:56.612"}, "package_version": "3.1.0", "saptune_installed": true}	2024-04-09 15:06:55.752741	2024-04-09 15:06:55.752741
3	9a26b6d0-6e72-597c-9fe5-152a6875f214	host_discovery	{"hostname": "vmiscsi01", "cpu_count": 1, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.80.1.4", "fe80::20d:3aff:fe2e:835a"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 3421, "fully_qualified_domain_name": "vmiscsi01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:06:55.875356	2024-04-09 15:06:55.875356
4	9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f	host_discovery	{"hostname": "vmnwdev03", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.100.1.23", "10.100.1.27", "fe80::6245:bdff:fe8d:9ef4"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwdev03.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:06:56.00261	2024-04-09 15:06:56.00261
5	0fc07435-7ee2-54ca-b0de-fb27ffdc5deb	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwprd04", "plan": {}, "tags": "fake-tags", "vmId": "a7321bd7-c191-4650-b368-9c0b7bf04de6", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwprd04", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver04-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-netweaver02-App", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Attach", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.24"}, {"privateIpAddress": "10.80.1.28"}]}, "ipv6": {}, "macAddress": "000D3A2E8FAD"}]}}, "Provider": "azure"}	2024-04-09 15:06:56.133394	2024-04-09 15:06:56.133394
6	f0c808b3-d869-5192-a944-20f66a6a8449	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:06:56.249684	2024-04-09 15:06:56.249684
7	1b0e9297-97dd-55d6-9874-8efde4d84c90	host_discovery	{"hostname": "vmnwdev04", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.100.1.24", "10.100.1.28", "fe80::6245:bdff:fe8d:9a74"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwdev04.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:06:56.363911	2024-04-09 15:06:56.363911
8	098fc159-3ed6-58e7-91be-38fda8a833ea	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:06:56.486685	2024-04-09 15:06:56.486685
9	422686d6-b2d1-5092-93e8-a744854f5085	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmdrbdqas02", "plan": {}, "tags": "fake-tags", "vmId": "cee2a7db-7fb7-4c51-928e-214966364f8f", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmdrbdqas02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmdrbdqas02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmdrbdqas02-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Standard_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.90.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.90.1.32"}]}, "ipv6": {}, "macAddress": "6045BD8D0523"}]}}, "Provider": "azure"}	2024-04-09 15:06:56.59948	2024-04-09 15:06:56.59948
10	ddcb7992-2ffb-5c10-8b39-80685f6eaaba	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:06:56.717341	2024-04-09 15:06:56.717341
11	ddcb7992-2ffb-5c10-8b39-80685f6eaaba	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmdrbdqas01", "plan": {}, "tags": "fake-tags", "vmId": "9c5b4666-5356-4347-b688-6954027283a1", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmdrbdqas01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmdrbdqas01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmdrbdqas01-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Standard_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.90.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.90.1.31"}]}, "ipv6": {}, "macAddress": "6045BD8D00C2"}]}}, "Provider": "azure"}	2024-04-09 15:06:56.830246	2024-04-09 15:06:56.830246
12	4b30a6af-4b52-5bda-bccb-f2248a12c992	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:06:56.952154	2024-04-09 15:06:56.952154
13	b767b3e9-e802-587e-a442-541d093b86b9	ha_cluster_discovery	{"DC": false, "Id": "9c832998801e28cd70ad77380e82a5c0", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmhdbprd01", "InstanceAttributes": [{"Id": "nodes-1-lpa_hdp_lpt", "Name": "lpa_hdp_lpt", "Value": "1643125019"}, {"Id": "nodes-1-hana_hdp_vhost", "Name": "hana_hdp_vhost", "Value": "vmhdbprd01"}, {"Id": "nodes-1-hana_hdp_site", "Name": "hana_hdp_site", "Value": "NBG"}, {"Id": "nodes-1-hana_hdp_op_mode", "Name": "hana_hdp_op_mode", "Value": "logreplay"}, {"Id": "nodes-1-hana_hdp_srmode", "Name": "hana_hdp_srmode", "Value": "sync"}, {"Id": "nodes-1-hana_hdp_remoteHost", "Name": "hana_hdp_remoteHost", "Value": "vmhdbprd02"}]}, {"Id": "2", "Uname": "vmhdbprd02", "InstanceAttributes": [{"Id": "nodes-2-lpa_hdp_lpt", "Name": "lpa_hdp_lpt", "Value": "30"}, {"Id": "nodes-2-hana_hdp_op_mode", "Name": "hana_hdp_op_mode", "Value": "logreplay"}, {"Id": "nodes-2-hana_hdp_vhost", "Name": "hana_hdp_vhost", "Value": "vmhdbprd02"}, {"Id": "nodes-2-hana_hdp_remoteHost", "Name": "hana_hdp_remoteHost", "Value": "vmhdbprd01"}, {"Id": "nodes-2-hana_hdp_site", "Name": "hana_hdp_site", "Value": "WDF"}, {"Id": "nodes-2-hana_hdp_srmode", "Name": "hana_hdp_srmode", "Value": "sync"}]}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "hana_cluster_3"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "24"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}, {"Id": "SAPHanaSR-hana_hdp_site_srHook_WDF", "Name": "hana_hdp_site_srHook_WDF", "Value": "SOK"}]}, "Resources": {"Clones": [{"Id": "cln_SAPHanaTopology_HDP_HDB10", "Primitive": {"Id": "rsc_SAPHanaTopology_HDP_HDB10", "Type": "SAPHanaTopology", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHanaTopology_HDP_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "600", "Interval": "10"}, {"Id": "rsc_SAPHanaTopology_HDP_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "600", "Interval": "0"}, {"Id": "rsc_SAPHanaTopology_HDP_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "300", "Interval": "0"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHanaTopology_HDP_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDP"}, {"Id": "rsc_SAPHanaTopology_HDP_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}]}, "MetaAttributes": [{"Id": "cln_SAPHanaTopology_HDP_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "cln_SAPHanaTopology_HDP_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g_ip_HDP_HDB10", "Primitives": [{"Id": "rsc_ip_HDP_HDB10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_HDP_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDP_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDP_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_HDP_HDB10-instance_attributes-ip", "Name": "ip", "Value": "10.80.1.13"}, {"Id": "rsc_ip_HDP_HDB10-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "24"}, {"Id": "rsc_ip_HDP_HDB10-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "rsc_socat_HDP_HDB10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_HDP_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_HDP_HDB10-instance_attributes-port", "Name": "port", "Value": "62510"}]}]}], "Masters": [{"Id": "msl_SAPHana_HDP_HDB10", "Primitive": {"Id": "rsc_SAPHana_HDP_HDB10", "Type": "SAPHana", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHana_HDP_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDP_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDP_HDB10-promote-0", "Name": "promote", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDP_HDB10-monitor-60", "Name": "monitor", "Role": "Master", "Timeout": "700", "Interval": "60"}, {"Id": "rsc_SAPHana_HDP_HDB10-monitor-61", "Name": "monitor", "Role": "Slave", "Timeout": "700", "Interval": "61"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDP"}, {"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}, {"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-PREFER_SITE_TAKEOVER", "Name": "PREFER_SITE_TAKEOVER", "Value": "True"}, {"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-AUTOMATED_REGISTER", "Name": "AUTOMATED_REGISTER", "Value": "False"}, {"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-DUPLICATE_PRIMARY_TIMEOUT", "Name": "DUPLICATE_PRIMARY_TIMEOUT", "Value": "7200"}]}, "MetaAttributes": [{"Id": "msl_SAPHana_HDP_HDB10-meta_attributes-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "msl_SAPHana_HDP_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "msl_SAPHana_HDP_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": [{"Id": "stonith-sbd-monitor-15", "Name": "monitor", "Role": "", "Timeout": "15", "Interval": "15"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "15"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b924e77", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "a7a18c6b-7c8e-4bda-bb77-45e4b5dc8478", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmhdbprd01", "Status": "clear"}, {"Id": 1, "Name": "vmhdbprd02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b924e77", "Status": "healthy"}]}, "Name": "hana_cluster_3", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmhdbprd01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 5}, {"DC": false, "Id": "2", "Name": "vmhdbprd02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}], "Clones": [{"Id": "msl_SAPHana_HDP_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHana_HDP_HDB10", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Master", "Agent": "ocf::suse:SAPHana", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHana_HDP_HDB10", "Node": {"Id": "2", "Name": "vmhdbprd02", "Cached": true}, "Role": "Slave", "Agent": "ocf::suse:SAPHana", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": true, "FailureIgnored": false}, {"Id": "cln_SAPHanaTopology_HDP_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHanaTopology_HDP_HDB10", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHanaTopology_HDP_HDB10", "Node": {"Id": "2", "Name": "vmhdbprd02", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g_ip_HDP_HDB10", "Resources": [{"Id": "rsc_ip_HDP_HDB10", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_HDP_HDB10", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 7, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 25 15:36:59 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmhdbprd01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_ip_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHana_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmhdbprd02", "ResourceHistory": [{"Name": "rsc_SAPHana_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmhdbprd01", "Attributes": [{"Name": "hana_hdp_clone_state", "Value": "PROMOTED"}, {"Name": "hana_hdp_op_mode", "Value": "logreplay"}, {"Name": "hana_hdp_remoteHost", "Value": "vmhdbprd02"}, {"Name": "hana_hdp_roles", "Value": "4:P:master1:master:worker:master"}, {"Name": "hana_hdp_site", "Value": "NBG"}, {"Name": "hana_hdp_srmode", "Value": "sync"}, {"Name": "hana_hdp_sync_state", "Value": "PRIM"}, {"Name": "hana_hdp_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdp_vhost", "Value": "vmhdbprd01"}, {"Name": "lpa_hdp_lpt", "Value": "1643125019"}, {"Name": "master-rsc_SAPHana_HDP_HDB10", "Value": "150"}]}, {"Name": "vmhdbprd02", "Attributes": [{"Name": "hana_hdp_clone_state", "Value": "DEMOTED"}, {"Name": "hana_hdp_op_mode", "Value": "logreplay"}, {"Name": "hana_hdp_remoteHost", "Value": "vmhdbprd01"}, {"Name": "hana_hdp_roles", "Value": "4:S:master1:master:worker:master"}, {"Name": "hana_hdp_site", "Value": "WDF"}, {"Name": "hana_hdp_srmode", "Value": "sync"}, {"Name": "hana_hdp_sync_state", "Value": "SOK"}, {"Name": "hana_hdp_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdp_vhost", "Value": "vmhdbprd02"}, {"Name": "lpa_hdp_lpt", "Value": "30"}, {"Name": "master-rsc_SAPHana_HDP_HDB10", "Value": "100"}]}]}}, "Provider": "azure"}	2024-04-09 15:06:57.106111	2024-04-09 15:06:57.106111
14	4b30a6af-4b52-5bda-bccb-f2248a12c992	ha_cluster_discovery	{"DC": false, "Id": "8bca366a6cb7816555538092a1ddd5aa", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmnwprd01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmnwprd02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "netweaver_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": null, "Groups": [{"Id": "grp_NWP_ASCS00", "Primitives": [{"Id": "rsc_ip_NWP_ASCS00", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWP_ASCS00-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWP_ASCS00-instance_attributes-ip", "Name": "ip", "Value": "10.80.1.25"}]}, {"Id": "rsc_fs_NWP_ASCS00", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWP_ASCS00-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWP_ASCS00-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWP_ASCS00-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWP_ASCS00-instance_attributes-device", "Name": "device", "Value": "10.80.1.33:/NWP/ASCS"}, {"Id": "rsc_fs_NWP_ASCS00-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWP/ASCS00"}, {"Id": "rsc_fs_NWP_ASCS00-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWP_ASCS00", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWP_ASCS00-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWP_ASCS00-meta_attributes-resource-stickiness", "Name": "resource-stickiness", "Value": "5000"}, {"Id": "rsc_sap_NWP_ASCS00-meta_attributes-failure-timeout", "Name": "failure-timeout", "Value": "60"}, {"Id": "rsc_sap_NWP_ASCS00-meta_attributes-migration-threshold", "Name": "migration-threshold", "Value": "1"}, {"Id": "rsc_sap_NWP_ASCS00-meta_attributes-priority", "Name": "priority", "Value": "10"}], "InstanceAttributes": [{"Id": "rsc_sap_NWP_ASCS00-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWP_ASCS00_sapnwpas"}, {"Id": "rsc_sap_NWP_ASCS00-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWP/profile/NWP_ASCS00_sapnwpas"}, {"Id": "rsc_sap_NWP_ASCS00-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}]}, {"Id": "rsc_socat_NWP_ASCS00", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWP_ASCS00-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWP_ASCS00-instance_attributes-port", "Name": "port", "Value": "62000"}]}]}, {"Id": "grp_NWP_ERS10", "Primitives": [{"Id": "rsc_ip_NWP_ERS10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWP_ERS10-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWP_ERS10-instance_attributes-ip", "Name": "ip", "Value": "10.80.1.26"}]}, {"Id": "rsc_fs_NWP_ERS10", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWP_ERS10-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWP_ERS10-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWP_ERS10-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWP_ERS10-instance_attributes-device", "Name": "device", "Value": "10.80.1.33:/NWP/ERS"}, {"Id": "rsc_fs_NWP_ERS10-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWP/ERS10"}, {"Id": "rsc_fs_NWP_ERS10-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWP_ERS10", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWP_ERS10-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWP_ERS10-meta_attributes-priority", "Name": "priority", "Value": "1000"}], "InstanceAttributes": [{"Id": "rsc_sap_NWP_ERS10-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWP_ERS10_sapnwper"}, {"Id": "rsc_sap_NWP_ERS10-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWP/profile/NWP_ERS10_sapnwper"}, {"Id": "rsc_sap_NWP_ERS10-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}, {"Id": "rsc_sap_NWP_ERS10-instance_attributes-IS_ERS", "Name": "IS_ERS", "Value": "true"}]}, {"Id": "rsc_socat_NWP_ERS10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWP_ERS10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWP_ERS10-instance_attributes-port", "Name": "port", "Value": "62110"}]}]}], "Masters": null, "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": [{"Id": "loc_sap_NWP_failover_to_ers", "Node": "", "Role": "", "Score": "", "Resource": "rsc_sap_NWP_ASCS00"}]}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_e34218cd-0d9a-4b21-b6d5-a313980baa82", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "e0c97fe2-f63a-4fd1-83df-9a736a03b49b", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmnwprd01", "Status": "clear"}, {"Id": 1, "Name": "vmnwprd02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_e34218cd-0d9a-4b21-b6d5-a313980baa82", "Status": "healthy"}]}, "Name": "netweaver_cluster", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmnwprd01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 5}, {"DC": false, "Id": "2", "Name": "vmnwprd02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 4}], "Clones": null, "Groups": [{"Id": "grp_NWP_ASCS00", "Resources": [{"Id": "rsc_ip_NWP_ASCS00", "Node": {"Id": "1", "Name": "vmnwprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWP_ASCS00", "Node": {"Id": "1", "Name": "vmnwprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWP_ASCS00", "Node": {"Id": "1", "Name": "vmnwprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWP_ASCS00", "Node": {"Id": "1", "Name": "vmnwprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}, {"Id": "grp_NWP_ERS10", "Resources": [{"Id": "rsc_ip_NWP_ERS10", "Node": {"Id": "2", "Name": "vmnwprd02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWP_ERS10", "Node": {"Id": "2", "Name": "vmnwprd02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWP_ERS10", "Node": {"Id": "2", "Name": "vmnwprd02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWP_ERS10", "Node": {"Id": "2", "Name": "vmnwprd02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 13:43:06 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmnwprd01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmnwprd01", "ResourceHistory": [{"Name": "rsc_ip_NWP_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_socat_NWP_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWP_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWP_ASCS00", "FailCount": 0, "MigrationThreshold": 1}]}, {"Name": "vmnwprd02", "ResourceHistory": [{"Name": "rsc_ip_NWP_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWP_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWP_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_socat_NWP_ERS10", "FailCount": 0, "MigrationThreshold": 3}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmnwprd02", "Attributes": [{"Name": "runs_ers_NWP", "Value": "1"}]}]}}, "Provider": "azure"}	2024-04-09 15:06:57.2545	2024-04-09 15:06:57.2545
18	7269ee51-5007-5849-aaa7-7c4a98b0c9ce	sap_system_discovery	[{"Id": "a1e80e3e152a903662f7882fb3f8a851", "SID": "NWD", "Type": 2, "Profile": {"SAPDBHOST": "10.100.1.13", "dbms/name": "HDD", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwdas", "rdisp/msserv": "sapmsNWD", "SAPGLOBALHOST": "sapnwdas", "SAPSYSTEMNAME": "NWD", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDD", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwdas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.100.1.13", "Databases": null, "Instances": [{"Host": "vmnwdev01", "Name": "ASCS00", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwdas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwder", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 7379, "name": "enserver", "starttime": "2022 01 11 12:55:17", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "EnqueueServer", "elapsedtime": "151:56:46"}, {"pid": 7378, "name": "msg_server", "starttime": "2022 01 11 12:55:17", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "MessageServer", "elapsedtime": "151:56:46"}], "Properties": [{"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "00", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "EnqGetLockTable", "property": "Enque Locks", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwdas", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "ASCS00", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWD", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "1", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "YES", "property": "CentralServices", "propertytype": "Attribute"}, {"value": "EnqGetStatistic", "property": "Enque Statistic", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://sapnwdas:50013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}, {"value": "YES", "property": "SupportsUpdateSCSInstance", "propertytype": "Attribute"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:06:57.749424	2024-04-09 15:06:57.749424
19	927901fa-2c87-524e-b18c-3ef5187f504f	sap_system_discovery	[]	2024-04-09 15:06:57.859926	2024-04-09 15:06:57.859926
20	3711ea88-9ccc-5b07-8f9d-042be449d72b	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:06:57.969049	2024-04-09 15:06:57.969049
25	25677e37-fd33-5005-896c-9275b1284534	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:06:58.542749	2024-04-09 15:06:58.542749
26	422686d6-b2d1-5092-93e8-a744854f5085	ha_cluster_discovery	{"DC": true, "Id": "a034a158905404befe08775682910ee1", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmdrbdqas01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmdrbdqas02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "drbd_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": [{"Id": "cl-nfsserver", "Primitive": {"Id": "nfsserver", "Type": "nfs-server", "Class": "systemd", "Provider": "", "Operations": [{"Id": "nfsserver-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": null}, "MetaAttributes": [{"Id": "cl-nfsserver-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g-nfs_sapdata", "Primitives": [{"Id": "fs_sapdata", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "fs_sapdata-monitor-20", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "fs_sapdata-instance_attributes-device", "Name": "device", "Value": "/dev/drbd1"}, {"Id": "fs_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWQ"}, {"Id": "fs_sapdata-instance_attributes-fstype", "Name": "fstype", "Value": "xfs"}, {"Id": "fs_sapdata-instance_attributes-options", "Name": "options", "Value": "noatime,nodiratime"}]}, {"Id": "vip_sapdata_nfs", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "vip_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "vip_sapdata_nfs-instance_attributes-ip", "Name": "ip", "Value": "10.90.1.33"}, {"Id": "vip_sapdata_nfs-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "32"}, {"Id": "vip_sapdata_nfs-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "exportfs_work_sapdata", "Type": "exportfs", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "exportfs_work_sapdata-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "exportfs_work_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWQ"}, {"Id": "exportfs_work_sapdata-instance_attributes-fsid", "Name": "fsid", "Value": "1"}, {"Id": "exportfs_work_sapdata-instance_attributes-options", "Name": "options", "Value": "rw,no_root_squash"}, {"Id": "exportfs_work_sapdata-instance_attributes-clientspec", "Name": "clientspec", "Value": "*"}, {"Id": "exportfs_work_sapdata-instance_attributes-wait_for_leasetime_on_stop", "Name": "wait_for_leasetime_on_stop", "Value": "true"}]}, {"Id": "rsc_socat_sapdata_nfs", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_sapdata_nfs-instance_attributes-port", "Name": "port", "Value": "61000"}]}]}], "Masters": [{"Id": "ms_sapdata", "Primitive": {"Id": "drbd-sapdata", "Type": "drbd", "Class": "ocf", "Provider": "linbit", "Operations": [{"Id": "drbd-sapdata-monitor-15", "Name": "monitor", "Role": "Master", "Timeout": "", "Interval": "15"}, {"Id": "drbd-sapdata-monitor-30", "Name": "monitor", "Role": "Slave", "Timeout": "", "Interval": "30"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "drbd-sapdata-instance_attributes-drbd_resource", "Name": "drbd_resource", "Value": "sapdata"}]}, "MetaAttributes": [{"Id": "ms_sapdata-meta_attributes-master-max", "Name": "master-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-master-node-max", "Name": "master-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-0-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "ms_sapdata-meta_attributes-0-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-1-notify", "Name": "notify", "Value": "true"}, {"Id": "ms_sapdata-meta_attributes-1-target-role", "Name": "target-role", "Value": "Started"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:c1c003f5-4e45-4d6f-8d81-e338f666365c", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "f5991966-5a7f-45d6-90d1-bfcedb265df6", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmdrbdqas01", "Status": "clear"}, {"Id": 1, "Name": "vmdrbdqas02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:c1c003f5-4e45-4d6f-8d81-e338f666365c", "Status": "healthy"}]}, "Name": "drbd_cluster", "Crmmon": {"Nodes": [{"DC": false, "Id": "1", "Name": "vmdrbdqas01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 7}, {"DC": true, "Id": "2", "Name": "vmdrbdqas02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}], "Clones": [{"Id": "ms_sapdata", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "drbd-sapdata", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Master", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "drbd-sapdata", "Node": {"Id": "2", "Name": "vmdrbdqas02", "Cached": true}, "Role": "Slave", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": true, "FailureIgnored": false}, {"Id": "cl-nfsserver", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "nfsserver", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "nfsserver", "Node": {"Id": "2", "Name": "vmdrbdqas02", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g-nfs_sapdata", "Resources": [{"Id": "fs_sapdata", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "vip_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "exportfs_work_sapdata", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:exportfs", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 12:20:56 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmdrbdqas01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "fs_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "vip_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "exportfs_work_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmdrbdqas02", "ResourceHistory": [{"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmdrbdqas01", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}, {"Name": "vmdrbdqas02", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}]}}, "Provider": "azure"}	2024-04-09 15:06:58.671467	2024-04-09 15:06:58.671467
27	240f96b1-8d26-53b7-9e99-ffb0f2e735bf	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmdrbddev01", "plan": {}, "tags": "fake-tags", "vmId": "5e294482-9554-4989-8b9e-a0a2d3991c09", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmdrbddev01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmdrbddev01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmdrbddev01-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Standard_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.100.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.100.1.31"}]}, "ipv6": {}, "macAddress": "6045BD8A5969"}]}}, "Provider": "azure"}	2024-04-09 15:06:58.798711	2024-04-09 15:06:58.798711
28	69f4dcbb-efa2-5a16-8bc8-01df7dbb7384	sap_system_discovery	[]	2024-04-09 15:06:58.914189	2024-04-09 15:06:58.914189
29	116d49bd-85e1-5e59-b820-83f66db8800c	host_discovery	{"hostname": "vmnwprd01", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.80.1.21", "10.80.1.25", "fe80::20d:3aff:fe2e:8f04"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwprd01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:06:59.01727	2024-04-09 15:06:59.01727
35	0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4	ha_cluster_discovery	{"DC": false, "Id": "04b8f8c21f9fd8991224478e8c4362f8", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmhdbdev01", "InstanceAttributes": [{"Id": "nodes-1-lpa_hdd_lpt", "Name": "lpa_hdd_lpt", "Value": "10"}, {"Id": "nodes-1-hana_hdd_vhost", "Name": "hana_hdd_vhost", "Value": "vmhdbdev01"}, {"Id": "nodes-1-hana_hdd_site", "Name": "hana_hdd_site", "Value": "NBG"}, {"Id": "nodes-1-hana_hdd_op_mode", "Name": "hana_hdd_op_mode", "Value": "logreplay"}, {"Id": "nodes-1-hana_hdd_srmode", "Name": "hana_hdd_srmode", "Value": "sync"}, {"Id": "nodes-1-hana_hdd_remoteHost", "Name": "hana_hdd_remoteHost", "Value": "vmhdbdev02"}]}, {"Id": "2", "Uname": "vmhdbdev02", "InstanceAttributes": [{"Id": "nodes-2-lpa_hdd_lpt", "Name": "lpa_hdd_lpt", "Value": "1643125026"}, {"Id": "nodes-2-hana_hdd_op_mode", "Name": "hana_hdd_op_mode", "Value": "logreplay"}, {"Id": "nodes-2-hana_hdd_vhost", "Name": "hana_hdd_vhost", "Value": "vmhdbdev02"}, {"Id": "nodes-2-hana_hdd_remoteHost", "Name": "hana_hdd_remoteHost", "Value": "vmhdbdev01"}, {"Id": "nodes-2-hana_hdd_site", "Name": "hana_hdd_site", "Value": "WDF"}, {"Id": "nodes-2-hana_hdd_srmode", "Name": "hana_hdd_srmode", "Value": "sync"}]}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "hana_cluster_1"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}, {"Id": "SAPHanaSR-hana_hdd_site_srHook_WDF", "Name": "hana_hdd_site_srHook_WDF", "Value": "PRIM"}]}, "Resources": {"Clones": [{"Id": "cln_SAPHanaTopology_HDD_HDB10", "Primitive": {"Id": "rsc_SAPHanaTopology_HDD_HDB10", "Type": "SAPHanaTopology", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHanaTopology_HDD_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "600", "Interval": "10"}, {"Id": "rsc_SAPHanaTopology_HDD_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "600", "Interval": "0"}, {"Id": "rsc_SAPHanaTopology_HDD_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "300", "Interval": "0"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHanaTopology_HDD_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDD"}, {"Id": "rsc_SAPHanaTopology_HDD_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}]}, "MetaAttributes": [{"Id": "cln_SAPHanaTopology_HDD_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "cln_SAPHanaTopology_HDD_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g_ip_HDD_HDB10", "Primitives": [{"Id": "rsc_ip_HDD_HDB10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_HDD_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDD_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDD_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_HDD_HDB10-instance_attributes-ip", "Name": "ip", "Value": "10.100.1.13"}, {"Id": "rsc_ip_HDD_HDB10-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "24"}, {"Id": "rsc_ip_HDD_HDB10-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "rsc_socat_HDD_HDB10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_HDD_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_HDD_HDB10-instance_attributes-port", "Name": "port", "Value": "62510"}]}]}], "Masters": [{"Id": "msl_SAPHana_HDD_HDB10", "Primitive": {"Id": "rsc_SAPHana_HDD_HDB10", "Type": "SAPHana", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHana_HDD_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDD_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDD_HDB10-promote-0", "Name": "promote", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDD_HDB10-monitor-60", "Name": "monitor", "Role": "Master", "Timeout": "700", "Interval": "60"}, {"Id": "rsc_SAPHana_HDD_HDB10-monitor-61", "Name": "monitor", "Role": "Slave", "Timeout": "700", "Interval": "61"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDD"}, {"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}, {"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-PREFER_SITE_TAKEOVER", "Name": "PREFER_SITE_TAKEOVER", "Value": "True"}, {"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-AUTOMATED_REGISTER", "Name": "AUTOMATED_REGISTER", "Value": "False"}, {"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-DUPLICATE_PRIMARY_TIMEOUT", "Name": "DUPLICATE_PRIMARY_TIMEOUT", "Value": "7200"}]}, "MetaAttributes": [{"Id": "msl_SAPHana_HDD_HDB10-meta_attributes-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "msl_SAPHana_HDD_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "msl_SAPHana_HDD_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": [{"Id": "stonith-sbd-monitor-15", "Name": "monitor", "Role": "", "Timeout": "15", "Interval": "15"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "15"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:182cb1b1-a815-4b82-b538-7a166b9bbb4a", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "cc39771e-ea2f-4fb1-8968-a6176aee3d0a", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmhdbdev01", "Status": "clear"}, {"Id": 1, "Name": "vmhdbdev02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:182cb1b1-a815-4b82-b538-7a166b9bbb4a", "Status": "healthy"}]}, "Name": "hana_cluster_1", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmhdbdev01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}, {"DC": false, "Id": "2", "Name": "vmhdbdev02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 4}], "Clones": [{"Id": "msl_SAPHana_HDD_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHana_HDD_HDB10", "Node": {"Id": "2", "Name": "vmhdbdev02", "Cached": true}, "Role": "Master", "Agent": "ocf::suse:SAPHana", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHana_HDD_HDB10", "Node": null, "Role": "Stopped", "Agent": "ocf::suse:SAPHana", "Active": false, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 0}], "MultiState": true, "FailureIgnored": false}, {"Id": "cln_SAPHanaTopology_HDD_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHanaTopology_HDD_HDB10", "Node": {"Id": "2", "Name": "vmhdbdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHanaTopology_HDD_HDB10", "Node": {"Id": "1", "Name": "vmhdbdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g_ip_HDD_HDB10", "Resources": [{"Id": "rsc_ip_HDD_HDB10", "Node": {"Id": "2", "Name": "vmhdbdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_HDD_HDB10", "Node": {"Id": "2", "Name": "vmhdbdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 7, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 25 15:37:06 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmhdbdev01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmhdbdev02", "ResourceHistory": [{"Name": "rsc_ip_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHana_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmhdbdev01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_ip_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHana_HDD_HDB10", "FailCount": 1000000, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmhdbdev01", "Attributes": [{"Name": "hana_hdd_clone_state", "Value": "UNDEFINED"}, {"Name": "hana_hdd_op_mode", "Value": "logreplay"}, {"Name": "hana_hdd_remoteHost", "Value": "vmhdbdev02"}, {"Name": "hana_hdd_roles", "Value": "1:P:master1::worker:"}, {"Name": "hana_hdd_site", "Value": "NBG"}, {"Name": "hana_hdd_srmode", "Value": "sync"}, {"Name": "hana_hdd_sync_state", "Value": "SFAIL"}, {"Name": "hana_hdd_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdd_vhost", "Value": "vmhdbdev01"}, {"Name": "lpa_hdd_lpt", "Value": "10"}, {"Name": "master-rsc_SAPHana_HDD_HDB10", "Value": "-9000"}]}, {"Name": "vmhdbdev02", "Attributes": [{"Name": "hana_hdd_clone_state", "Value": "PROMOTED"}, {"Name": "hana_hdd_op_mode", "Value": "logreplay"}, {"Name": "hana_hdd_remoteHost", "Value": "vmhdbdev01"}, {"Name": "hana_hdd_roles", "Value": "4:P:master1:master:worker:master"}, {"Name": "hana_hdd_site", "Value": "WDF"}, {"Name": "hana_hdd_srmode", "Value": "sync"}, {"Name": "hana_hdd_sync_state", "Value": "PRIM"}, {"Name": "hana_hdd_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdd_vhost", "Value": "vmhdbdev02"}, {"Name": "lpa_hdd_lpt", "Value": "1643125026"}, {"Name": "master-rsc_SAPHana_HDD_HDB10", "Value": "150"}]}]}}, "Provider": "azure"}	2024-04-09 15:06:59.710111	2024-04-09 15:06:59.710111
36	99cf8a3a-48d6-57a4-b302-6e4482227ab6	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:06:59.843523	2024-04-09 15:06:59.843523
38	7269ee51-5007-5849-aaa7-7c4a98b0c9ce	ha_cluster_discovery	{"DC": true, "Id": "057f083c3be591f4398eed816d4c8cd7", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmnwdev01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmnwdev02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "netweaver_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": null, "Groups": [{"Id": "grp_NWD_ASCS00", "Primitives": [{"Id": "rsc_ip_NWD_ASCS00", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWD_ASCS00-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWD_ASCS00-instance_attributes-ip", "Name": "ip", "Value": "10.100.1.25"}]}, {"Id": "rsc_fs_NWD_ASCS00", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWD_ASCS00-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWD_ASCS00-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWD_ASCS00-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWD_ASCS00-instance_attributes-device", "Name": "device", "Value": "10.100.1.33:/NWD/ASCS"}, {"Id": "rsc_fs_NWD_ASCS00-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWD/ASCS00"}, {"Id": "rsc_fs_NWD_ASCS00-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWD_ASCS00", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWD_ASCS00-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWD_ASCS00-meta_attributes-resource-stickiness", "Name": "resource-stickiness", "Value": "5000"}, {"Id": "rsc_sap_NWD_ASCS00-meta_attributes-failure-timeout", "Name": "failure-timeout", "Value": "60"}, {"Id": "rsc_sap_NWD_ASCS00-meta_attributes-migration-threshold", "Name": "migration-threshold", "Value": "1"}, {"Id": "rsc_sap_NWD_ASCS00-meta_attributes-priority", "Name": "priority", "Value": "10"}], "InstanceAttributes": [{"Id": "rsc_sap_NWD_ASCS00-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWD_ASCS00_sapnwdas"}, {"Id": "rsc_sap_NWD_ASCS00-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWD/profile/NWD_ASCS00_sapnwdas"}, {"Id": "rsc_sap_NWD_ASCS00-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}]}, {"Id": "rsc_socat_NWD_ASCS00", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWD_ASCS00-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWD_ASCS00-instance_attributes-port", "Name": "port", "Value": "62000"}]}]}, {"Id": "grp_NWD_ERS10", "Primitives": [{"Id": "rsc_ip_NWD_ERS10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWD_ERS10-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWD_ERS10-instance_attributes-ip", "Name": "ip", "Value": "10.100.1.26"}]}, {"Id": "rsc_fs_NWD_ERS10", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWD_ERS10-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWD_ERS10-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWD_ERS10-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWD_ERS10-instance_attributes-device", "Name": "device", "Value": "10.100.1.33:/NWD/ERS"}, {"Id": "rsc_fs_NWD_ERS10-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWD/ERS10"}, {"Id": "rsc_fs_NWD_ERS10-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWD_ERS10", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWD_ERS10-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWD_ERS10-meta_attributes-priority", "Name": "priority", "Value": "1000"}], "InstanceAttributes": [{"Id": "rsc_sap_NWD_ERS10-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWD_ERS10_sapnwder"}, {"Id": "rsc_sap_NWD_ERS10-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWD/profile/NWD_ERS10_sapnwder"}, {"Id": "rsc_sap_NWD_ERS10-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}, {"Id": "rsc_sap_NWD_ERS10-instance_attributes-IS_ERS", "Name": "IS_ERS", "Value": "true"}]}, {"Id": "rsc_socat_NWD_ERS10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWD_ERS10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWD_ERS10-instance_attributes-port", "Name": "port", "Value": "62110"}]}]}], "Masters": null, "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": [{"Id": "loc_sap_NWD_failover_to_ers", "Node": "", "Role": "", "Score": "", "Resource": "rsc_sap_NWD_ASCS00"}]}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-36001405f01eb5f4c5c941e499beb055d", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "4e8adda1-da35-4ee4-92b9-a134494861f0", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmnwdev01", "Status": "clear"}, {"Id": 1, "Name": "vmnwdev02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-36001405f01eb5f4c5c941e499beb055d", "Status": "healthy"}]}, "Name": "netweaver_cluster", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmnwdev01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 5}, {"DC": false, "Id": "2", "Name": "vmnwdev02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 4}], "Clones": null, "Groups": [{"Id": "grp_NWD_ASCS00", "Resources": [{"Id": "rsc_ip_NWD_ASCS00", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWD_ASCS00", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWD_ASCS00", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWD_ASCS00", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}, {"Id": "grp_NWD_ERS10", "Resources": [{"Id": "rsc_ip_NWD_ERS10", "Node": {"Id": "2", "Name": "vmnwdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWD_ERS10", "Node": {"Id": "2", "Name": "vmnwdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWD_ERS10", "Node": {"Id": "2", "Name": "vmnwdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWD_ERS10", "Node": {"Id": "2", "Name": "vmnwdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 12:55:06 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmnwdev01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWD_ASCS00", "FailCount": 0, "MigrationThreshold": 1}, {"Name": "rsc_socat_NWD_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_ip_NWD_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWD_ASCS00", "FailCount": 0, "MigrationThreshold": 3}]}, {"Name": "vmnwdev02", "ResourceHistory": [{"Name": "rsc_ip_NWD_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWD_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWD_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_socat_NWD_ERS10", "FailCount": 0, "MigrationThreshold": 3}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmnwdev02", "Attributes": [{"Name": "runs_ers_NWD", "Value": "1"}]}]}}, "Provider": "azure"}	2024-04-09 15:07:00.082527	2024-04-09 15:07:00.082527
40	21de186a-e38f-5804-b643-7f4ef22fecfd	sap_system_discovery	[]	2024-04-09 15:07:00.341005	2024-04-09 15:07:00.341005
42	098fc159-3ed6-58e7-91be-38fda8a833ea	sap_system_discovery	[{"Id": "d01fdc69aeba7bd5133b210eb2884853", "SID": "NWQ", "Type": 2, "Profile": {"SAPDBHOST": "ha-cluster.suse.de", "dbms/name": "HDQ", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwqas", "rdisp/msserv": "sapmsNWQ", "SAPGLOBALHOST": "sapnwqas", "SAPSYSTEMNAME": "NWQ", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDQ", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwqas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.90.1.13", "Databases": null, "Instances": [{"Host": "vmnwqas03", "Name": "D01", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwqas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwqer", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwqpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwqaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 17085, "name": "gwrd", "starttime": "2022 01 17 12:42:04", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Gateway", "elapsedtime": "8:09:29"}, {"pid": 17086, "name": "icman", "starttime": "2022 01 17 12:42:04", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "ICM", "elapsedtime": "8:09:29"}, {"pid": 17081, "name": "igswd_mt", "starttime": "2022 01 17 12:42:03", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "IGS Watchdog", "elapsedtime": "8:09:30"}, {"pid": 17080, "name": "disp+work", "starttime": "2022 01 17 12:42:03", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Dispatcher", "elapsedtime": "8:09:30"}], "Properties": [{"value": "HTTP://sapnwqpas:0/sap/admin/public/index.html", "property": "ICM", "propertytype": "NodeURL"}, {"value": "http://sapnwqpas:40180", "property": "IGS", "propertytype": "NodeURL"}, {"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "ICMGetCacheEntries", "property": "ICM Cache", "propertytype": "NodeWebmethod"}, {"value": "01", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetThreadList", "property": "ICM Threads", "propertytype": "NodeWebmethod"}, {"value": "GetAlertTree", "property": "Open Alerts", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwqpas", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "ABAPGetWPTable", "property": "ABAP WP Table", "propertytype": "NodeWebmethod"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "D01", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWQ", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "GetAlertTree", "property": "Current Status", "propertytype": "NodeWebmethod"}, {"value": "GWGetClientList", "property": "Gateway Clients", "propertytype": "NodeWebmethod"}, {"value": "ICMGetConnectionList", "property": "ICM Connections", "propertytype": "NodeWebmethod"}, {"value": "GetQueueStatistic", "property": "Queue Statistic", "propertytype": "NodeWebmethod"}, {"value": "GWGetConnectionList", "property": "Gateway Connections", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetProxyConnectionList", "property": "ICM Proxy Connections", "propertytype": "NodeWebmethod"}, {"value": "http://sapnwqpas:50113/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:07:00.574256	2024-04-09 15:07:00.574256
43	1b0e9297-97dd-55d6-9874-8efde4d84c90	sap_system_discovery	[{"Id": "a1e80e3e152a903662f7882fb3f8a851", "SID": "NWD", "Type": 2, "Profile": {"SAPDBHOST": "10.100.1.13", "dbms/name": "HDD", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwdas", "rdisp/msserv": "sapmsNWD", "SAPGLOBALHOST": "sapnwdas", "SAPSYSTEMNAME": "NWD", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDD", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwdas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.100.1.13", "Databases": null, "Instances": [{"Host": "vmnwdev04", "Name": "D02", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwdas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwder", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 26496, "name": "gwrd", "starttime": "2022 01 11 13:05:00", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Gateway", "elapsedtime": "151:47:01"}, {"pid": 26497, "name": "icman", "starttime": "2022 01 11 13:05:00", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "ICM", "elapsedtime": "151:47:01"}, {"pid": 26476, "name": "igswd_mt", "starttime": "2022 01 11 13:04:57", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "IGS Watchdog", "elapsedtime": "151:47:04"}, {"pid": 26475, "name": "disp+work", "starttime": "2022 01 11 13:04:57", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Dispatcher", "elapsedtime": "151:47:04"}], "Properties": [{"value": "HTTP://sapnwdaas1:0/sap/admin/public/index.html", "property": "ICM", "propertytype": "NodeURL"}, {"value": "http://sapnwdaas1:40280", "property": "IGS", "propertytype": "NodeURL"}, {"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "ICMGetCacheEntries", "property": "ICM Cache", "propertytype": "NodeWebmethod"}, {"value": "02", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetThreadList", "property": "ICM Threads", "propertytype": "NodeWebmethod"}, {"value": "GetAlertTree", "property": "Open Alerts", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwdaas1", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "ABAPGetWPTable", "property": "ABAP WP Table", "propertytype": "NodeWebmethod"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "D02", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWD", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "GetAlertTree", "property": "Current Status", "propertytype": "NodeWebmethod"}, {"value": "GWGetClientList", "property": "Gateway Clients", "propertytype": "NodeWebmethod"}, {"value": "ICMGetConnectionList", "property": "ICM Connections", "propertytype": "NodeWebmethod"}, {"value": "GetQueueStatistic", "property": "Queue Statistic", "propertytype": "NodeWebmethod"}, {"value": "GWGetConnectionList", "property": "Gateway Connections", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetProxyConnectionList", "property": "ICM Proxy Connections", "propertytype": "NodeWebmethod"}, {"value": "http://sapnwdaas1:50213/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:07:00.689943	2024-04-09 15:07:00.689943
119	13e8c25c-3180-5a9a-95c8-51ec38e50cfc	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:07:10.795218	2024-04-09 15:07:10.795218
15	9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:06:57.388334	2024-04-09 15:06:57.388334
16	9cd46919-5f19-59aa-993e-cf3736c71053	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmhdbprd01", "plan": {}, "tags": "fake-tags", "vmId": "ee7cf44b-d202-4680-b331-1b3996f2f0e7", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_E4s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmhdbprd01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data01", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "1", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data02", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "2", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data03", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "3", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data04", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "4", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data05", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "5", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data06", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "6", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data07", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.11"}]}, "ipv6": {}, "macAddress": "000D3A232C6B"}]}}, "Provider": "azure"}	2024-04-09 15:06:57.510581	2024-04-09 15:06:57.510581
17	e0c182db-32ff-55c6-a9eb-2b82dd21bc8b	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:06:57.625245	2024-04-09 15:06:57.625245
21	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	sap_system_discovery	[{"Id": "a1e80e3e152a903662f7882fb3f8a851", "SID": "NWD", "Type": 2, "Profile": {"SAPDBHOST": "10.100.1.13", "dbms/name": "HDD", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwdas", "rdisp/msserv": "sapmsNWD", "SAPGLOBALHOST": "sapnwdas", "SAPSYSTEMNAME": "NWD", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDD", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwdas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.100.1.13", "Databases": null, "Instances": [{"Host": "vmnwdev02", "Name": "ERS10", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwdas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwder", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 6720, "name": "enrepserver", "starttime": "2022 01 11 12:55:17", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "EnqueueReplicator", "elapsedtime": "151:56:49"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwder", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "ERS10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWD", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.5", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://sapnwder:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:06:58.081347	2024-04-09 15:06:58.081347
33	927901fa-2c87-524e-b18c-3ef5187f504f	ha_cluster_discovery	{"DC": true, "Id": "238a4de1239aae2aa87433eed788b3ad", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmdrbdprd01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmdrbdprd02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "drbd_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": [{"Id": "cl-nfsserver", "Primitive": {"Id": "nfsserver", "Type": "nfs-server", "Class": "systemd", "Provider": "", "Operations": [{"Id": "nfsserver-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": null}, "MetaAttributes": [{"Id": "cl-nfsserver-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g-nfs_sapdata", "Primitives": [{"Id": "fs_sapdata", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "fs_sapdata-monitor-20", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "fs_sapdata-instance_attributes-device", "Name": "device", "Value": "/dev/drbd1"}, {"Id": "fs_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWP"}, {"Id": "fs_sapdata-instance_attributes-fstype", "Name": "fstype", "Value": "xfs"}, {"Id": "fs_sapdata-instance_attributes-options", "Name": "options", "Value": "noatime,nodiratime"}]}, {"Id": "vip_sapdata_nfs", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "vip_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "vip_sapdata_nfs-instance_attributes-ip", "Name": "ip", "Value": "10.80.1.33"}, {"Id": "vip_sapdata_nfs-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "32"}, {"Id": "vip_sapdata_nfs-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "exportfs_work_sapdata", "Type": "exportfs", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "exportfs_work_sapdata-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "exportfs_work_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWP"}, {"Id": "exportfs_work_sapdata-instance_attributes-fsid", "Name": "fsid", "Value": "1"}, {"Id": "exportfs_work_sapdata-instance_attributes-options", "Name": "options", "Value": "rw,no_root_squash"}, {"Id": "exportfs_work_sapdata-instance_attributes-clientspec", "Name": "clientspec", "Value": "*"}, {"Id": "exportfs_work_sapdata-instance_attributes-wait_for_leasetime_on_stop", "Name": "wait_for_leasetime_on_stop", "Value": "true"}]}, {"Id": "rsc_socat_sapdata_nfs", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_sapdata_nfs-instance_attributes-port", "Name": "port", "Value": "61000"}]}]}], "Masters": [{"Id": "ms_sapdata", "Primitive": {"Id": "drbd-sapdata", "Type": "drbd", "Class": "ocf", "Provider": "linbit", "Operations": [{"Id": "drbd-sapdata-monitor-15", "Name": "monitor", "Role": "Master", "Timeout": "", "Interval": "15"}, {"Id": "drbd-sapdata-monitor-30", "Name": "monitor", "Role": "Slave", "Timeout": "", "Interval": "30"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "drbd-sapdata-instance_attributes-drbd_resource", "Name": "drbd_resource", "Value": "sapdata"}]}, "MetaAttributes": [{"Id": "ms_sapdata-meta_attributes-master-max", "Name": "master-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-master-node-max", "Name": "master-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-0-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "ms_sapdata-meta_attributes-0-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-1-notify", "Name": "notify", "Value": "true"}, {"Id": "ms_sapdata-meta_attributes-1-target-role", "Name": "target-role", "Value": "Started"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_b7b1cd3d-776e-4432-a9e5-6fe56e4b4e17", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "28fd9d5e-3685-4cb7-85e9-76c4b140ea3c", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmdrbdprd01", "Status": "clear"}, {"Id": 1, "Name": "vmdrbdprd02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_b7b1cd3d-776e-4432-a9e5-6fe56e4b4e17", "Status": "healthy"}]}, "Name": "drbd_cluster", "Crmmon": {"Nodes": [{"DC": false, "Id": "1", "Name": "vmdrbdprd01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 7}, {"DC": true, "Id": "2", "Name": "vmdrbdprd02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}], "Clones": [{"Id": "ms_sapdata", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "drbd-sapdata", "Node": {"Id": "2", "Name": "vmdrbdprd02", "Cached": true}, "Role": "Slave", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "drbd-sapdata", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Master", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": true, "FailureIgnored": false}, {"Id": "cl-nfsserver", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "nfsserver", "Node": {"Id": "2", "Name": "vmdrbdprd02", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "nfsserver", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g-nfs_sapdata", "Resources": [{"Id": "fs_sapdata", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "vip_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "exportfs_work_sapdata", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:exportfs", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 13:24:06 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmdrbdprd02", "ResourceHistory": [{"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmdrbdprd01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "fs_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "vip_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "exportfs_work_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmdrbdprd01", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}, {"Name": "vmdrbdprd02", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}]}}, "Provider": "azure"}	2024-04-09 15:06:59.475569	2024-04-09 15:06:59.475569
34	b767b3e9-e802-587e-a442-541d093b86b9	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:06:59.593324	2024-04-09 15:06:59.593324
37	4b30a6af-4b52-5bda-bccb-f2248a12c992	saptune_discovery	{"status": {"pid": 24623, "argv": "saptune --format json status", "result": {"staging": {"Notes staged": [], "staging enabled": false, "Solutions staged": []}, "services": {"tuned": [], "sapconf": [], "saptune": ["enabled", "active"]}, "tuning state": "not compliant", "Notes applied": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Notes enabled": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "virtualization": "oracle", "package version": "3.1.0", "Solution applied": [{"Solution ID": "NETWEAVER", "applied partially": false}], "Solution enabled": ["NETWEAVER"], "remember message": "\\nRegarding the tuning state of the system please use 'saptune note verify' for detailed information.\\n\\n", "configured version": "3", "systemd system state": "running", "Notes applied by Solution": [{"Note list": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Solution ID": "NETWEAVER"}], "Notes enabled by Solution": [{"Note list": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Solution ID": "NETWEAVER"}], "Notes enabled additionally": []}, "$schema": "file:///usr/share/saptune/schemas/1.0/saptune_status.schema.json", "command": "status", "messages": [{"message": "actions.go:85: ATTENTION: You are running a test version (3.1.0 from 2022/11/28) of saptune which is not supported for production use\\n", "priority": "NOTICE"}, {"message": "sysctl.go:73: Parameter 'kernel.shmmax' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0xffffffffffffffff), /boot/sysctl.conf-5.3.18-150300.59.93-default(0xffffffffffffffff).\\n", "priority": "WARNING"}, {"message": "sysctl.go:73: Parameter 'kernel.shmall' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0x0fffffffffffff00), /boot/sysctl.conf-5.3.18-150300.59.93-default(0x0fffffffffffff00).\\n", "priority": "WARNING"}, {"message": "ini.go:308: block device related section settings detected: Traversing all block devices can take a considerable amount of time.\\n", "priority": "NOTICE"}], "exit code": 4, "publish time": "2023-04-24 12:41:56.612"}, "package_version": "3.1.0", "saptune_installed": true}	2024-04-09 15:06:59.961561	2024-04-09 15:06:59.961561
39	99cf8a3a-48d6-57a4-b302-6e4482227ab6	host_discovery	{"hostname": "vmhdbqas01", "cpu_count": 4, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.90.1.11", "10.90.1.13", "fe80::6245:bdff:fe8d:1d5"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 32107, "fully_qualified_domain_name": "vmhdbqas01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:00.216125	2024-04-09 15:07:00.216125
49	7269ee51-5007-5849-aaa7-7c4a98b0c9ce	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:07:01.437206	2024-04-09 15:07:01.437206
60	7269ee51-5007-5849-aaa7-7c4a98b0c9ce	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:02.91811	2024-04-09 15:07:02.91811
129	240f96b1-8d26-53b7-9e99-ffb0f2e735bf	host_discovery	{"hostname": "vmdrbddev01", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.100.1.31", "10.100.1.33", "fe80::6245:bdff:fe8a:5969"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmdrbddev01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:12.109058	2024-04-09 15:07:12.109058
22	e0c182db-32ff-55c6-a9eb-2b82dd21bc8b	sap_system_discovery	[{"Id": "9953878f07bb54cac20d5d5d7ff08af2", "SID": "HDQ", "Type": 1, "Profile": {"SAPGLOBALHOST": "vmhdbqas02", "SAPSYSTEMNAME": "HDQ", "hdbConfigType": "DEFAULT", "ssl/ciphersuites": "135:PFS:HIGH::EC_P256:EC_HIGH", "HDB_LINKED_BINARIES": "yes", "HDB_SHARED_BINARIES": "yes"}, "Databases": [{"Host": "vmhdbqas02", "User": "", "Group": "", "Active": "yes", "UserId": "", "GroupId": "", "SqlPort": "31015", "Database": "HDQ", "Container": ""}], "Instances": [{"Host": "vmhdbqas02", "Name": "HDB10", "Type": 1, "SAPControl": {"Instances": [{"features": "HDB|HDB_WORKER", "hostname": "vmhdbqas02", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.3"}], "Processes": [{"pid": 29597, "name": "hdbdaemon", "starttime": "2022 01 11 12:30:14", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Daemon", "elapsedtime": "152:21:46"}, {"pid": 30148, "name": "hdbxsengine", "starttime": "2022 01 11 12:30:27", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB XSEngine-HDQ", "elapsedtime": "152:21:33"}, {"pid": 29727, "name": "hdbnameserver", "starttime": "2022 01 11 12:30:14", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Nameserver", "elapsedtime": "152:21:46"}, {"pid": 30145, "name": "hdbindexserver", "starttime": "2022 01 11 12:30:27", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Indexserver-HDQ", "elapsedtime": "152:21:33"}, {"pid": 30047, "name": "hdbpreprocessor", "starttime": "2022 01 11 12:30:26", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Preprocessor", "elapsedtime": "152:21:34"}, {"pid": 30044, "name": "hdbcompileserver", "starttime": "2022 01 11 12:30:26", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Compileserver", "elapsedtime": "152:21:34"}, {"pid": 30855, "name": "hdbwebdispatcher", "starttime": "2022 01 11 12:30:35", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Web Dispatcher", "elapsedtime": "152:21:25"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "YES", "property": "DBServices", "propertytype": "Attribute"}, {"value": "worker", "property": "HANA Roles", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "vmhdbqas02", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "HDB10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "HDQ", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://vmhdbqas02:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": {"mode": "sync", "online": "true", "site_id": "2", "isSource": "false", "site_name": "WDF", "isConsumer": "true", "replayMode": "auto", "hasConsumers": "false", "siteTier/NBG": "1", "siteTier/WDF": "2", "operation_mode": "logreplay", "primary_masters": "vmhdbqas01", "siteMapping/NBG": "WDF", "isTakeoverActive": "false", "isPrimarySuspended": "false", "mapping/vmhdbqas02": ["WDF/vmhdbqas02", "NBG/vmhdbqas01"], "active_primary_site": "1", "isTimetravelEnabled": "false", "siteOperationMode/NBG": "primary", "siteOperationMode/WDF": "logreplay", "siteReplicationMode/NBG": "primary", "siteReplicationMode/WDF": "sync"}, "HostConfiguration": {"host": "vmhdbqas02", "hostActive": "yes", "hostStatus": "ok", "removeStatus": "", "failoverStatus": "", "hostActualRoles": "worker", "hostConfigRoles": "worker", "storagePartition": "1", "workerActualGroups": "default", "workerConfigGroups": "default", "failoverActualGroup": "default", "failoverConfigGroup": "default", "nameServerActualRole": "master", "nameServerConfigRole": "master 1", "indexServerActualRole": "master", "indexServerConfigRole": "worker", "storageActualPartition": "1", "storageConfigPartition": "1"}, "SystemReplication": {"local_site_id": "2", "site/2/SITE_NAME": "WDF", "site/2/SOURCE_SITE_ID": "1", "site/2/PRIMARY_MASTERS": "vmhdbqas01", "site/2/REPLICATION_MODE": "SYNC"}}]}]	2024-04-09 15:06:58.192197	2024-04-09 15:06:58.192197
23	927901fa-2c87-524e-b18c-3ef5187f504f	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmdrbdprd02", "plan": {}, "tags": "fake-tags", "vmId": "f89fef5e-e7e3-469d-b819-a0154be6150c", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmdrbdprd02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmdrbdprd02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmdrbdprd02-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Standard_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.32"}]}, "ipv6": {}, "macAddress": "000D3A2E8B91"}]}}, "Provider": "azure"}	2024-04-09 15:06:58.308645	2024-04-09 15:06:58.308645
24	a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12	host_discovery	{"hostname": "vmnwprd03", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.80.1.23", "10.80.1.27", "fe80::20d:3aff:fe25:7f83"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwprd03.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:06:58.421881	2024-04-09 15:06:58.421881
30	927901fa-2c87-524e-b18c-3ef5187f504f	saptune_discovery	{"status": {"pid": 24623, "argv": "saptune --format json status", "result": {"staging": {"Notes staged": [], "staging enabled": false, "Solutions staged": []}, "services": {"tuned": [], "sapconf": [], "saptune": ["enabled", "inactive"]}, "tuning state": "not tuned", "Notes applied": [], "Notes enabled": [], "virtualization": "oracle", "package version": "3.1.0", "Solution applied": [], "Solution enabled": [], "remember message": "\\nRegarding the tuning state of the system please use 'saptune note verify' for detailed information.\\n\\n", "configured version": "3", "systemd system state": "running", "Notes applied by Solution": [], "Notes enabled by Solution": [], "Notes enabled additionally": []}, "$schema": "file:///usr/share/saptune/schemas/1.0/saptune_status.schema.json", "command": "status", "messages": [], "exit code": 4, "publish time": "2023-04-24 12:41:56.612"}, "package_version": "3.1.0", "saptune_installed": true}	2024-04-09 15:06:59.135474	2024-04-09 15:06:59.135474
31	21de186a-e38f-5804-b643-7f4ef22fecfd	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmdrbddev02", "plan": {}, "tags": "fake-tags", "vmId": "99ef5ab8-73b5-4ca9-8c37-6778e2d6abc1", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmdrbddev02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmdrbddev02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmdrbddev02-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Standard_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.100.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.100.1.32"}]}, "ipv6": {}, "macAddress": "6045BD8D95F1"}]}}, "Provider": "azure"}	2024-04-09 15:06:59.250241	2024-04-09 15:06:59.250241
32	4b30a6af-4b52-5bda-bccb-f2248a12c992	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwprd02", "plan": {}, "tags": "fake-tags", "vmId": "2c54a8bf-b71d-423b-a656-34bcc575970e", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwprd02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.22"}]}, "ipv6": {}, "macAddress": "000D3A2E8038"}]}}, "Provider": "azure"}	2024-04-09 15:06:59.36261	2024-04-09 15:06:59.36261
41	a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12	sap_system_discovery	[{"Id": "97a1e70aeff3c0685d65c4c3d32d533b", "SID": "NWP", "Type": 2, "Profile": {"SAPDBHOST": "10.80.1.13", "dbms/name": "HDP", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwpas", "rdisp/msserv": "sapmsNWP", "SAPGLOBALHOST": "sapnwpas", "SAPSYSTEMNAME": "NWP", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDP", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwpas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.80.1.13", "Databases": null, "Instances": [{"Host": "vmnwprd03", "Name": "D01", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwpas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwper", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwppas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwpaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 9752, "name": "gwrd", "starttime": "2022 01 11 13:44:51", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Gateway", "elapsedtime": "151:07:13"}, {"pid": 9753, "name": "icman", "starttime": "2022 01 11 13:44:51", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "ICM", "elapsedtime": "151:07:13"}, {"pid": 9732, "name": "igswd_mt", "starttime": "2022 01 11 13:44:49", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "IGS Watchdog", "elapsedtime": "151:07:15"}, {"pid": 9731, "name": "disp+work", "starttime": "2022 01 11 13:44:49", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Dispatcher", "elapsedtime": "151:07:15"}], "Properties": [{"value": "HTTP://sapnwppas:0/sap/admin/public/index.html", "property": "ICM", "propertytype": "NodeURL"}, {"value": "http://sapnwppas:40180", "property": "IGS", "propertytype": "NodeURL"}, {"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "ICMGetCacheEntries", "property": "ICM Cache", "propertytype": "NodeWebmethod"}, {"value": "01", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetThreadList", "property": "ICM Threads", "propertytype": "NodeWebmethod"}, {"value": "GetAlertTree", "property": "Open Alerts", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwppas", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "ABAPGetWPTable", "property": "ABAP WP Table", "propertytype": "NodeWebmethod"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "D01", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWP", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "GetAlertTree", "property": "Current Status", "propertytype": "NodeWebmethod"}, {"value": "GWGetClientList", "property": "Gateway Clients", "propertytype": "NodeWebmethod"}, {"value": "ICMGetConnectionList", "property": "ICM Connections", "propertytype": "NodeWebmethod"}, {"value": "GetQueueStatistic", "property": "Queue Statistic", "propertytype": "NodeWebmethod"}, {"value": "GWGetConnectionList", "property": "Gateway Connections", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetProxyConnectionList", "property": "ICM Proxy Connections", "propertytype": "NodeWebmethod"}, {"value": "http://sapnwppas:50113/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:07:00.454572	2024-04-09 15:07:00.454572
44	240f96b1-8d26-53b7-9e99-ffb0f2e735bf	ha_cluster_discovery	{"DC": false, "Id": "04a81f89c847e82390e35bece2e25c9b", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmdrbddev01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmdrbddev02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "drbd_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": [{"Id": "cl-nfsserver", "Primitive": {"Id": "nfsserver", "Type": "nfs-server", "Class": "systemd", "Provider": "", "Operations": [{"Id": "nfsserver-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": null}, "MetaAttributes": [{"Id": "cl-nfsserver-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g-nfs_sapdata", "Primitives": [{"Id": "fs_sapdata", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "fs_sapdata-monitor-20", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "fs_sapdata-instance_attributes-device", "Name": "device", "Value": "/dev/drbd1"}, {"Id": "fs_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWD"}, {"Id": "fs_sapdata-instance_attributes-fstype", "Name": "fstype", "Value": "xfs"}, {"Id": "fs_sapdata-instance_attributes-options", "Name": "options", "Value": "noatime,nodiratime"}]}, {"Id": "vip_sapdata_nfs", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "vip_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "vip_sapdata_nfs-instance_attributes-ip", "Name": "ip", "Value": "10.100.1.33"}, {"Id": "vip_sapdata_nfs-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "32"}, {"Id": "vip_sapdata_nfs-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "exportfs_work_sapdata", "Type": "exportfs", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "exportfs_work_sapdata-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "exportfs_work_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWD"}, {"Id": "exportfs_work_sapdata-instance_attributes-fsid", "Name": "fsid", "Value": "1"}, {"Id": "exportfs_work_sapdata-instance_attributes-options", "Name": "options", "Value": "rw,no_root_squash"}, {"Id": "exportfs_work_sapdata-instance_attributes-clientspec", "Name": "clientspec", "Value": "*"}, {"Id": "exportfs_work_sapdata-instance_attributes-wait_for_leasetime_on_stop", "Name": "wait_for_leasetime_on_stop", "Value": "true"}]}, {"Id": "rsc_socat_sapdata_nfs", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_sapdata_nfs-instance_attributes-port", "Name": "port", "Value": "61000"}]}]}], "Masters": [{"Id": "ms_sapdata", "Primitive": {"Id": "drbd-sapdata", "Type": "drbd", "Class": "ocf", "Provider": "linbit", "Operations": [{"Id": "drbd-sapdata-monitor-15", "Name": "monitor", "Role": "Master", "Timeout": "", "Interval": "15"}, {"Id": "drbd-sapdata-monitor-30", "Name": "monitor", "Role": "Slave", "Timeout": "", "Interval": "30"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "drbd-sapdata-instance_attributes-drbd_resource", "Name": "drbd_resource", "Value": "sapdata"}]}, "MetaAttributes": [{"Id": "ms_sapdata-meta_attributes-master-max", "Name": "master-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-master-node-max", "Name": "master-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-0-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "ms_sapdata-meta_attributes-0-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-1-notify", "Name": "notify", "Value": "true"}, {"Id": "ms_sapdata-meta_attributes-1-target-role", "Name": "target-role", "Value": "Started"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:3947fa28-25e0-46d4-bbed-89ce88f977f1", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "27016e64-5f07-4563-90d5-16cb8f9ebc2a", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmdrbddev01", "Status": "clear"}, {"Id": 1, "Name": "vmdrbddev02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:3947fa28-25e0-46d4-bbed-89ce88f977f1", "Status": "healthy"}]}, "Name": "drbd_cluster", "Crmmon": {"Nodes": [{"DC": false, "Id": "1", "Name": "vmdrbddev01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 7}, {"DC": true, "Id": "2", "Name": "vmdrbddev02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}], "Clones": [{"Id": "ms_sapdata", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "drbd-sapdata", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Master", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "drbd-sapdata", "Node": {"Id": "2", "Name": "vmdrbddev02", "Cached": true}, "Role": "Slave", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": true, "FailureIgnored": false}, {"Id": "cl-nfsserver", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "nfsserver", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "nfsserver", "Node": {"Id": "2", "Name": "vmdrbddev02", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g-nfs_sapdata", "Resources": [{"Id": "fs_sapdata", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "vip_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "exportfs_work_sapdata", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:exportfs", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 12:50:53 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmdrbddev01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "fs_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "vip_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "exportfs_work_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmdrbddev02", "ResourceHistory": [{"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmdrbddev01", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}, {"Name": "vmdrbddev02", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}]}}, "Provider": "azure"}	2024-04-09 15:07:00.80866	2024-04-09 15:07:00.80866
51	098fc159-3ed6-58e7-91be-38fda8a833ea	host_discovery	{"hostname": "vmnwqas03", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.90.1.27", "10.90.1.23", "fe80::6245:bdff:fe8d:5d9"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwqas03.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:01.712983	2024-04-09 15:07:01.712983
140	116d49bd-85e1-5e59-b820-83f66db8800c	sap_system_discovery	[{"Id": "97a1e70aeff3c0685d65c4c3d32d533b", "SID": "NWP", "Type": 2, "Profile": {"SAPDBHOST": "10.80.1.13", "dbms/name": "HDP", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwpas", "rdisp/msserv": "sapmsNWP", "SAPGLOBALHOST": "sapnwpas", "SAPSYSTEMNAME": "NWP", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDP", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwpas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.80.1.13", "Databases": null, "Instances": [{"Host": "vmnwprd01", "Name": "ASCS00", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwpas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwper", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwppas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwpaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 24167, "name": "enserver", "starttime": "2022 01 11 13:43:17", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "EnqueueServer", "elapsedtime": "151:08:47"}, {"pid": 24166, "name": "msg_server", "starttime": "2022 01 11 13:43:17", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "MessageServer", "elapsedtime": "151:08:47"}], "Properties": [{"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "00", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "EnqGetLockTable", "property": "Enque Locks", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwpas", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "ASCS00", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWP", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "1", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "YES", "property": "CentralServices", "propertytype": "Attribute"}, {"value": "EnqGetStatistic", "property": "Enque Statistic", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://sapnwpas:50013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}, {"value": "YES", "property": "SupportsUpdateSCSInstance", "propertytype": "Attribute"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:07:13.537984	2024-04-09 15:07:13.537984
255	25677e37-fd33-5005-896c-9275b1284534	ha_cluster_discovery	{"DC": true, "Id": "acf59e7a5338f76f55d5055af3273480", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmnwqas01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmnwqas02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "netweaver_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": null, "Groups": [{"Id": "grp_NWQ_ASCS00", "Primitives": [{"Id": "rsc_ip_NWQ_ASCS00", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWQ_ASCS00-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWQ_ASCS00-instance_attributes-ip", "Name": "ip", "Value": "10.90.1.25"}]}, {"Id": "rsc_fs_NWQ_ASCS00", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWQ_ASCS00-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWQ_ASCS00-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWQ_ASCS00-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWQ_ASCS00-instance_attributes-device", "Name": "device", "Value": "10.90.1.33:/NWQ/ASCS"}, {"Id": "rsc_fs_NWQ_ASCS00-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWQ/ASCS00"}, {"Id": "rsc_fs_NWQ_ASCS00-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWQ_ASCS00", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWQ_ASCS00-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWQ_ASCS00-meta_attributes-resource-stickiness", "Name": "resource-stickiness", "Value": "5000"}, {"Id": "rsc_sap_NWQ_ASCS00-meta_attributes-failure-timeout", "Name": "failure-timeout", "Value": "60"}, {"Id": "rsc_sap_NWQ_ASCS00-meta_attributes-migration-threshold", "Name": "migration-threshold", "Value": "1"}, {"Id": "rsc_sap_NWQ_ASCS00-meta_attributes-priority", "Name": "priority", "Value": "10"}], "InstanceAttributes": [{"Id": "rsc_sap_NWQ_ASCS00-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWQ_ASCS00_sapnwqas"}, {"Id": "rsc_sap_NWQ_ASCS00-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWQ/profile/NWQ_ASCS00_sapnwqas"}, {"Id": "rsc_sap_NWQ_ASCS00-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}]}, {"Id": "rsc_socat_NWQ_ASCS00", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWQ_ASCS00-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWQ_ASCS00-instance_attributes-port", "Name": "port", "Value": "62000"}]}]}, {"Id": "grp_NWQ_ERS10", "Primitives": [{"Id": "rsc_ip_NWQ_ERS10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWQ_ERS10-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWQ_ERS10-instance_attributes-ip", "Name": "ip", "Value": "10.90.1.26"}]}, {"Id": "rsc_fs_NWQ_ERS10", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWQ_ERS10-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWQ_ERS10-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWQ_ERS10-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWQ_ERS10-instance_attributes-device", "Name": "device", "Value": "10.90.1.33:/NWQ/ERS"}, {"Id": "rsc_fs_NWQ_ERS10-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWQ/ERS10"}, {"Id": "rsc_fs_NWQ_ERS10-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWQ_ERS10", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWQ_ERS10-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWQ_ERS10-meta_attributes-priority", "Name": "priority", "Value": "1000"}], "InstanceAttributes": [{"Id": "rsc_sap_NWQ_ERS10-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWQ_ERS10_sapnwqer"}, {"Id": "rsc_sap_NWQ_ERS10-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWQ/profile/NWQ_ERS10_sapnwqer"}, {"Id": "rsc_sap_NWQ_ERS10-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}, {"Id": "rsc_sap_NWQ_ERS10-instance_attributes-IS_ERS", "Name": "IS_ERS", "Value": "true"}]}, {"Id": "rsc_socat_NWQ_ERS10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWQ_ERS10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWQ_ERS10-instance_attributes-port", "Name": "port", "Value": "62110"}]}]}], "Masters": null, "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": [{"Id": "loc_sap_NWQ_failover_to_ers", "Node": "", "Role": "", "Score": "", "Resource": "rsc_sap_NWQ_ASCS00"}]}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_813ace38-2d4f-48f6-8aa2-5360252ca492", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "3365e35e-ba75-4d29-9f5a-1a0379ee7a60", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmnwqas01", "Status": "clear"}, {"Id": 1, "Name": "vmnwqas02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_813ace38-2d4f-48f6-8aa2-5360252ca492", "Status": "healthy"}]}, "Name": "netweaver_cluster", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmnwqas01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 5}, {"DC": false, "Id": "2", "Name": "vmnwqas02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 4}], "Clones": null, "Groups": [{"Id": "grp_NWQ_ASCS00", "Resources": [{"Id": "rsc_ip_NWQ_ASCS00", "Node": {"Id": "1", "Name": "vmnwqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWQ_ASCS00", "Node": {"Id": "1", "Name": "vmnwqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWQ_ASCS00", "Node": {"Id": "1", "Name": "vmnwqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWQ_ASCS00", "Node": {"Id": "1", "Name": "vmnwqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}, {"Id": "grp_NWQ_ERS10", "Resources": [{"Id": "rsc_ip_NWQ_ERS10", "Node": {"Id": "2", "Name": "vmnwqas02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWQ_ERS10", "Node": {"Id": "2", "Name": "vmnwqas02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWQ_ERS10", "Node": {"Id": "2", "Name": "vmnwqas02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWQ_ERS10", "Node": {"Id": "2", "Name": "vmnwqas02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Mon Jan 17 12:41:40 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmnwqas01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmnwqas02", "ResourceHistory": [{"Name": "rsc_sap_NWQ_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_ip_NWQ_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWQ_ERS10", "FailCount": 1, "MigrationThreshold": 3}, {"Name": "rsc_socat_NWQ_ERS10", "FailCount": 0, "MigrationThreshold": 3}]}, {"Name": "vmnwqas01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_ip_NWQ_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWQ_ASCS00", "FailCount": 1, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWQ_ASCS00", "FailCount": 0, "MigrationThreshold": 1}, {"Name": "rsc_socat_NWQ_ASCS00", "FailCount": 0, "MigrationThreshold": 3}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmnwqas02", "Attributes": [{"Name": "runs_ers_NWQ", "Value": "1"}]}]}}, "Provider": "azure"}	2024-04-09 15:08:23.261578	2024-04-09 15:08:23.261578
444	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:09:19.730516	2024-04-09 15:09:19.730516
45	21de186a-e38f-5804-b643-7f4ef22fecfd	host_discovery	{"hostname": "vmdrbddev02", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.100.1.32", "fe80::6245:bdff:fe8d:95f1"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951}	2024-04-09 15:07:00.935652	2024-04-09 15:07:00.935652
48	1b0e9297-97dd-55d6-9874-8efde4d84c90	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:07:01.296491	2024-04-09 15:07:01.296491
53	e0c182db-32ff-55c6-a9eb-2b82dd21bc8b	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:07:01.99109	2024-04-09 15:07:01.99109
58	b767b3e9-e802-587e-a442-541d093b86b9	sap_system_discovery	[{"Id": "1154f7678ac587e5f0f242830a5201f1", "SID": "HDP", "Type": 1, "Profile": {"SAPGLOBALHOST": "vmhdbprd02", "SAPSYSTEMNAME": "HDP", "hdbConfigType": "DEFAULT", "ssl/ciphersuites": "135:PFS:HIGH::EC_P256:EC_HIGH", "HDB_LINKED_BINARIES": "yes", "HDB_SHARED_BINARIES": "yes"}, "Databases": [{"Host": "vmhdbprd02", "User": "", "Group": "", "Active": "yes", "UserId": "", "GroupId": "", "SqlPort": "31015", "Database": "HDP", "Container": ""}], "Instances": [{"Host": "vmhdbprd02", "Name": "HDB10", "Type": 1, "SAPControl": {"Instances": [{"features": "HDB|HDB_WORKER", "hostname": "vmhdbprd02", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.3"}], "Processes": [{"pid": 7464, "name": "hdbdaemon", "starttime": "2022 01 11 13:36:18", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Daemon", "elapsedtime": "151:15:40"}, {"pid": 8467, "name": "hdbxsengine", "starttime": "2022 01 11 13:36:34", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB XSEngine-HDP", "elapsedtime": "151:15:24"}, {"pid": 7484, "name": "hdbnameserver", "starttime": "2022 01 11 13:36:18", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Nameserver", "elapsedtime": "151:15:40"}, {"pid": 8460, "name": "hdbindexserver", "starttime": "2022 01 11 13:36:34", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Indexserver-HDP", "elapsedtime": "151:15:24"}, {"pid": 8253, "name": "hdbpreprocessor", "starttime": "2022 01 11 13:36:33", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Preprocessor", "elapsedtime": "151:15:25"}, {"pid": 8250, "name": "hdbcompileserver", "starttime": "2022 01 11 13:36:33", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Compileserver", "elapsedtime": "151:15:25"}, {"pid": 9083, "name": "hdbwebdispatcher", "starttime": "2022 01 11 13:36:43", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Web Dispatcher", "elapsedtime": "151:15:15"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "YES", "property": "DBServices", "propertytype": "Attribute"}, {"value": "worker", "property": "HANA Roles", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "vmhdbprd02", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "HDB10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "HDP", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://vmhdbprd02:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": {"mode": "sync", "online": "true", "site_id": "2", "isSource": "false", "site_name": "WDF", "isConsumer": "true", "replayMode": "auto", "hasConsumers": "false", "siteTier/NBG": "1", "siteTier/WDF": "2", "operation_mode": "logreplay", "primary_masters": "vmhdbprd01", "siteMapping/NBG": "WDF", "isTakeoverActive": "false", "isPrimarySuspended": "false", "mapping/vmhdbprd02": ["WDF/vmhdbprd02", "NBG/vmhdbprd01"], "active_primary_site": "1", "isTimetravelEnabled": "false", "siteOperationMode/NBG": "primary", "siteOperationMode/WDF": "logreplay", "siteReplicationMode/NBG": "primary", "siteReplicationMode/WDF": "sync"}, "HostConfiguration": {"host": "vmhdbprd02", "hostActive": "yes", "hostStatus": "ok", "removeStatus": "", "failoverStatus": "", "hostActualRoles": "worker", "hostConfigRoles": "worker", "storagePartition": "1", "workerActualGroups": "default", "workerConfigGroups": "default", "failoverActualGroup": "default", "failoverConfigGroup": "default", "nameServerActualRole": "master", "nameServerConfigRole": "master 1", "indexServerActualRole": "master", "indexServerConfigRole": "worker", "storageActualPartition": "1", "storageConfigPartition": "1"}, "SystemReplication": {"local_site_id": "2", "site/2/SITE_NAME": "WDF", "site/2/SOURCE_SITE_ID": "1", "site/2/PRIMARY_MASTERS": "vmhdbprd01", "site/2/REPLICATION_MODE": "SYNC"}}]}]	2024-04-09 15:07:02.654334	2024-04-09 15:07:02.654334
62	422686d6-b2d1-5092-93e8-a744854f5085	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:03.181371	2024-04-09 15:07:03.181371
63	927901fa-2c87-524e-b18c-3ef5187f504f	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:03.30523	2024-04-09 15:07:03.30523
64	1b0e9297-97dd-55d6-9874-8efde4d84c90	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwdev04", "plan": {}, "tags": "fake-tags", "vmId": "48a84b30-7cfb-4b74-ad43-8382ad07ed9b", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwdev04", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver04-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-netweaver02-App", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Attach", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.100.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.100.1.24"}, {"privateIpAddress": "10.100.1.28"}]}, "ipv6": {}, "macAddress": "6045BD8D9A74"}]}}, "Provider": "azure"}	2024-04-09 15:07:03.428918	2024-04-09 15:07:03.428918
68	9cd46919-5f19-59aa-993e-cf3736c71053	host_discovery	{"hostname": "vmhdbprd01", "cpu_count": 4, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.80.1.11", "10.80.1.13", "fe80::20d:3aff:fe23:2c6b"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 32107, "fully_qualified_domain_name": "vmhdbprd01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:03.932424	2024-04-09 15:07:03.932424
73	4b30a6af-4b52-5bda-bccb-f2248a12c992	sap_system_discovery	[{"Id": "97a1e70aeff3c0685d65c4c3d32d533b", "SID": "NWP", "Type": 2, "Profile": {"SAPDBHOST": "10.80.1.13", "dbms/name": "HDP", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwpas", "rdisp/msserv": "sapmsNWP", "SAPGLOBALHOST": "sapnwpas", "SAPSYSTEMNAME": "NWP", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDP", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwpas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.80.1.13", "Databases": null, "Instances": [{"Host": "vmnwprd02", "Name": "ERS10", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwpas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwper", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwppas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwpaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 23289, "name": "enrepserver", "starttime": "2022 01 11 13:43:18", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "EnqueueReplicator", "elapsedtime": "151:08:42"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwper", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "ERS10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWP", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.5", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://sapnwper:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:07:04.626725	2024-04-09 15:07:04.626725
75	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:07:04.88489	2024-04-09 15:07:04.88489
78	0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4	host_discovery	{"hostname": "vmhdbdev02", "cpu_count": 4, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.100.1.12", "fe80::6245:bdff:fe8a:5f6b"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 32107, "fully_qualified_domain_name": "vmhdbdev02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:05.277558	2024-04-09 15:07:05.277558
90	f0c808b3-d869-5192-a944-20f66a6a8449	sap_system_discovery	[]	2024-04-09 15:07:06.812359	2024-04-09 15:07:06.812359
93	a09d9cf3-46c1-505c-8fb8-4b0a71a9114e	host_discovery	{"hostname": "vmdrbdprd01", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.80.1.31", "10.80.1.33", "fe80::20d:3aff:fe25:7df0"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmdrbdprd01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:07.192935	2024-04-09 15:07:07.192935
100	21de186a-e38f-5804-b643-7f4ef22fecfd	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:08.271807	2024-04-09 15:07:08.271807
103	240f96b1-8d26-53b7-9e99-ffb0f2e735bf	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:07:08.671392	2024-04-09 15:07:08.671392
107	9a26b6d0-6e72-597c-9fe5-152a6875f214	sap_system_discovery	[]	2024-04-09 15:07:09.193092	2024-04-09 15:07:09.193092
276	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:08:26.077009	2024-04-09 15:08:26.077009
46	25677e37-fd33-5005-896c-9275b1284534	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:01.059037	2024-04-09 15:07:01.059037
52	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	ha_cluster_discovery	{"DC": false, "Id": "057f083c3be591f4398eed816d4c8cd7", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmnwdev01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmnwdev02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "netweaver_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": null, "Groups": [{"Id": "grp_NWD_ASCS00", "Primitives": [{"Id": "rsc_ip_NWD_ASCS00", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWD_ASCS00-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWD_ASCS00-instance_attributes-ip", "Name": "ip", "Value": "10.100.1.25"}]}, {"Id": "rsc_fs_NWD_ASCS00", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWD_ASCS00-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWD_ASCS00-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWD_ASCS00-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWD_ASCS00-instance_attributes-device", "Name": "device", "Value": "10.100.1.33:/NWD/ASCS"}, {"Id": "rsc_fs_NWD_ASCS00-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWD/ASCS00"}, {"Id": "rsc_fs_NWD_ASCS00-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWD_ASCS00", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWD_ASCS00-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWD_ASCS00-meta_attributes-resource-stickiness", "Name": "resource-stickiness", "Value": "5000"}, {"Id": "rsc_sap_NWD_ASCS00-meta_attributes-failure-timeout", "Name": "failure-timeout", "Value": "60"}, {"Id": "rsc_sap_NWD_ASCS00-meta_attributes-migration-threshold", "Name": "migration-threshold", "Value": "1"}, {"Id": "rsc_sap_NWD_ASCS00-meta_attributes-priority", "Name": "priority", "Value": "10"}], "InstanceAttributes": [{"Id": "rsc_sap_NWD_ASCS00-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWD_ASCS00_sapnwdas"}, {"Id": "rsc_sap_NWD_ASCS00-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWD/profile/NWD_ASCS00_sapnwdas"}, {"Id": "rsc_sap_NWD_ASCS00-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}]}, {"Id": "rsc_socat_NWD_ASCS00", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWD_ASCS00-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWD_ASCS00-instance_attributes-port", "Name": "port", "Value": "62000"}]}]}, {"Id": "grp_NWD_ERS10", "Primitives": [{"Id": "rsc_ip_NWD_ERS10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWD_ERS10-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWD_ERS10-instance_attributes-ip", "Name": "ip", "Value": "10.100.1.26"}]}, {"Id": "rsc_fs_NWD_ERS10", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWD_ERS10-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWD_ERS10-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWD_ERS10-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWD_ERS10-instance_attributes-device", "Name": "device", "Value": "10.100.1.33:/NWD/ERS"}, {"Id": "rsc_fs_NWD_ERS10-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWD/ERS10"}, {"Id": "rsc_fs_NWD_ERS10-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWD_ERS10", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWD_ERS10-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWD_ERS10-meta_attributes-priority", "Name": "priority", "Value": "1000"}], "InstanceAttributes": [{"Id": "rsc_sap_NWD_ERS10-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWD_ERS10_sapnwder"}, {"Id": "rsc_sap_NWD_ERS10-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWD/profile/NWD_ERS10_sapnwder"}, {"Id": "rsc_sap_NWD_ERS10-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}, {"Id": "rsc_sap_NWD_ERS10-instance_attributes-IS_ERS", "Name": "IS_ERS", "Value": "true"}]}, {"Id": "rsc_socat_NWD_ERS10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWD_ERS10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWD_ERS10-instance_attributes-port", "Name": "port", "Value": "62110"}]}]}], "Masters": null, "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": [{"Id": "loc_sap_NWD_failover_to_ers", "Node": "", "Role": "", "Score": "", "Resource": "rsc_sap_NWD_ASCS00"}]}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-36001405f01eb5f4c5c941e499beb055d", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "4e8adda1-da35-4ee4-92b9-a134494861f0", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmnwdev01", "Status": "clear"}, {"Id": 1, "Name": "vmnwdev02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-36001405f01eb5f4c5c941e499beb055d", "Status": "healthy"}]}, "Name": "netweaver_cluster", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmnwdev01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 5}, {"DC": false, "Id": "2", "Name": "vmnwdev02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 4}], "Clones": null, "Groups": [{"Id": "grp_NWD_ASCS00", "Resources": [{"Id": "rsc_ip_NWD_ASCS00", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWD_ASCS00", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWD_ASCS00", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWD_ASCS00", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}, {"Id": "grp_NWD_ERS10", "Resources": [{"Id": "rsc_ip_NWD_ERS10", "Node": {"Id": "2", "Name": "vmnwdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWD_ERS10", "Node": {"Id": "2", "Name": "vmnwdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWD_ERS10", "Node": {"Id": "2", "Name": "vmnwdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWD_ERS10", "Node": {"Id": "2", "Name": "vmnwdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 12:55:06 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmnwdev01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWD_ASCS00", "FailCount": 0, "MigrationThreshold": 1}, {"Name": "rsc_socat_NWD_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_ip_NWD_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWD_ASCS00", "FailCount": 0, "MigrationThreshold": 3}]}, {"Name": "vmnwdev02", "ResourceHistory": [{"Name": "rsc_ip_NWD_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWD_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWD_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_socat_NWD_ERS10", "FailCount": 0, "MigrationThreshold": 3}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmnwdev02", "Attributes": [{"Name": "runs_ers_NWD", "Value": "1"}]}]}}, "Provider": "azure"}	2024-04-09 15:07:01.860605	2024-04-09 15:07:01.860605
54	25677e37-fd33-5005-896c-9275b1284534	ha_cluster_discovery	{"DC": true, "Id": "acf59e7a5338f76f55d5055af3273480", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmnwqas01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmnwqas02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "netweaver_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": null, "Groups": [{"Id": "grp_NWQ_ASCS00", "Primitives": [{"Id": "rsc_ip_NWQ_ASCS00", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWQ_ASCS00-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWQ_ASCS00-instance_attributes-ip", "Name": "ip", "Value": "10.90.1.25"}]}, {"Id": "rsc_fs_NWQ_ASCS00", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWQ_ASCS00-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWQ_ASCS00-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWQ_ASCS00-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWQ_ASCS00-instance_attributes-device", "Name": "device", "Value": "10.90.1.33:/NWQ/ASCS"}, {"Id": "rsc_fs_NWQ_ASCS00-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWQ/ASCS00"}, {"Id": "rsc_fs_NWQ_ASCS00-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWQ_ASCS00", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWQ_ASCS00-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWQ_ASCS00-meta_attributes-resource-stickiness", "Name": "resource-stickiness", "Value": "5000"}, {"Id": "rsc_sap_NWQ_ASCS00-meta_attributes-failure-timeout", "Name": "failure-timeout", "Value": "60"}, {"Id": "rsc_sap_NWQ_ASCS00-meta_attributes-migration-threshold", "Name": "migration-threshold", "Value": "1"}, {"Id": "rsc_sap_NWQ_ASCS00-meta_attributes-priority", "Name": "priority", "Value": "10"}], "InstanceAttributes": [{"Id": "rsc_sap_NWQ_ASCS00-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWQ_ASCS00_sapnwqas"}, {"Id": "rsc_sap_NWQ_ASCS00-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWQ/profile/NWQ_ASCS00_sapnwqas"}, {"Id": "rsc_sap_NWQ_ASCS00-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}]}, {"Id": "rsc_socat_NWQ_ASCS00", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWQ_ASCS00-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWQ_ASCS00-instance_attributes-port", "Name": "port", "Value": "62000"}]}]}, {"Id": "grp_NWQ_ERS10", "Primitives": [{"Id": "rsc_ip_NWQ_ERS10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWQ_ERS10-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWQ_ERS10-instance_attributes-ip", "Name": "ip", "Value": "10.90.1.26"}]}, {"Id": "rsc_fs_NWQ_ERS10", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWQ_ERS10-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWQ_ERS10-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWQ_ERS10-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWQ_ERS10-instance_attributes-device", "Name": "device", "Value": "10.90.1.33:/NWQ/ERS"}, {"Id": "rsc_fs_NWQ_ERS10-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWQ/ERS10"}, {"Id": "rsc_fs_NWQ_ERS10-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWQ_ERS10", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWQ_ERS10-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWQ_ERS10-meta_attributes-priority", "Name": "priority", "Value": "1000"}], "InstanceAttributes": [{"Id": "rsc_sap_NWQ_ERS10-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWQ_ERS10_sapnwqer"}, {"Id": "rsc_sap_NWQ_ERS10-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWQ/profile/NWQ_ERS10_sapnwqer"}, {"Id": "rsc_sap_NWQ_ERS10-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}, {"Id": "rsc_sap_NWQ_ERS10-instance_attributes-IS_ERS", "Name": "IS_ERS", "Value": "true"}]}, {"Id": "rsc_socat_NWQ_ERS10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWQ_ERS10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWQ_ERS10-instance_attributes-port", "Name": "port", "Value": "62110"}]}]}], "Masters": null, "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": [{"Id": "loc_sap_NWQ_failover_to_ers", "Node": "", "Role": "", "Score": "", "Resource": "rsc_sap_NWQ_ASCS00"}]}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_813ace38-2d4f-48f6-8aa2-5360252ca492", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "3365e35e-ba75-4d29-9f5a-1a0379ee7a60", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmnwqas01", "Status": "clear"}, {"Id": 1, "Name": "vmnwqas02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_813ace38-2d4f-48f6-8aa2-5360252ca492", "Status": "healthy"}]}, "Name": "netweaver_cluster", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmnwqas01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 5}, {"DC": false, "Id": "2", "Name": "vmnwqas02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 4}], "Clones": null, "Groups": [{"Id": "grp_NWQ_ASCS00", "Resources": [{"Id": "rsc_ip_NWQ_ASCS00", "Node": {"Id": "1", "Name": "vmnwqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWQ_ASCS00", "Node": {"Id": "1", "Name": "vmnwqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWQ_ASCS00", "Node": {"Id": "1", "Name": "vmnwqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWQ_ASCS00", "Node": {"Id": "1", "Name": "vmnwqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}, {"Id": "grp_NWQ_ERS10", "Resources": [{"Id": "rsc_ip_NWQ_ERS10", "Node": {"Id": "2", "Name": "vmnwqas02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWQ_ERS10", "Node": {"Id": "2", "Name": "vmnwqas02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWQ_ERS10", "Node": {"Id": "2", "Name": "vmnwqas02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWQ_ERS10", "Node": {"Id": "2", "Name": "vmnwqas02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Mon Jan 17 12:41:40 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmnwqas01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmnwqas02", "ResourceHistory": [{"Name": "rsc_sap_NWQ_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_ip_NWQ_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWQ_ERS10", "FailCount": 1, "MigrationThreshold": 3}, {"Name": "rsc_socat_NWQ_ERS10", "FailCount": 0, "MigrationThreshold": 3}]}, {"Name": "vmnwqas01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_ip_NWQ_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWQ_ASCS00", "FailCount": 1, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWQ_ASCS00", "FailCount": 0, "MigrationThreshold": 1}, {"Name": "rsc_socat_NWQ_ASCS00", "FailCount": 0, "MigrationThreshold": 3}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmnwqas02", "Attributes": [{"Name": "runs_ers_NWQ", "Value": "1"}]}]}}, "Provider": "azure"}	2024-04-09 15:07:02.115599	2024-04-09 15:07:02.115599
55	ddcb7992-2ffb-5c10-8b39-80685f6eaaba	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:02.261137	2024-04-09 15:07:02.261137
59	a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12	saptune_discovery	{"status": {"pid": 24623, "argv": "saptune --format json status", "result": {"staging": {"Notes staged": [], "staging enabled": false, "Solutions staged": []}, "services": {"tuned": [], "sapconf": [], "saptune": ["enabled", "active"]}, "tuning state": "not compliant", "Notes applied": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Notes enabled": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "virtualization": "oracle", "package version": "3.1.0", "Solution applied": [{"Solution ID": "NETWEAVER", "applied partially": false}], "Solution enabled": ["NETWEAVER"], "remember message": "\\nRegarding the tuning state of the system please use 'saptune note verify' for detailed information.\\n\\n", "configured version": "3", "systemd system state": "running", "Notes applied by Solution": [{"Note list": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Solution ID": "NETWEAVER"}], "Notes enabled by Solution": [{"Note list": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Solution ID": "NETWEAVER"}], "Notes enabled additionally": []}, "$schema": "file:///usr/share/saptune/schemas/1.0/saptune_status.schema.json", "command": "status", "messages": [{"message": "actions.go:85: ATTENTION: You are running a test version (3.1.0 from 2022/11/28) of saptune which is not supported for production use\\n", "priority": "NOTICE"}, {"message": "sysctl.go:73: Parameter 'kernel.shmmax' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0xffffffffffffffff), /boot/sysctl.conf-5.3.18-150300.59.93-default(0xffffffffffffffff).\\n", "priority": "WARNING"}, {"message": "sysctl.go:73: Parameter 'kernel.shmall' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0x0fffffffffffff00), /boot/sysctl.conf-5.3.18-150300.59.93-default(0x0fffffffffffff00).\\n", "priority": "WARNING"}, {"message": "ini.go:308: block device related section settings detected: Traversing all block devices can take a considerable amount of time.\\n", "priority": "NOTICE"}], "exit code": 4, "publish time": "2023-04-24 12:41:56.612"}, "package_version": "3.1.0", "saptune_installed": true}	2024-04-09 15:07:02.776773	2024-04-09 15:07:02.776773
65	99cf8a3a-48d6-57a4-b302-6e4482227ab6	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmhdbqas01", "plan": {}, "tags": "fake-tags", "vmId": "f01d07fa-c7eb-477a-9de1-eef7e946fdbe", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_E4s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmhdbqas01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmhdbqas01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmhdbqas01-Data01", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "1", "vhd": {"uri": ""}, "name": "disk-vmhdbqas01-Data02", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "2", "vhd": {"uri": ""}, "name": "disk-vmhdbqas01-Data03", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "3", "vhd": {"uri": ""}, "name": "disk-vmhdbqas01-Data04", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "4", "vhd": {"uri": ""}, "name": "disk-vmhdbqas01-Data05", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "5", "vhd": {"uri": ""}, "name": "disk-vmhdbqas01-Data06", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "6", "vhd": {"uri": ""}, "name": "disk-vmhdbqas01-Data07", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.90.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.90.1.11"}]}, "ipv6": {}, "macAddress": "6045BD8D01D5"}]}}, "Provider": "azure"}	2024-04-09 15:07:03.565316	2024-04-09 15:07:03.565316
72	b767b3e9-e802-587e-a442-541d093b86b9	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmhdbprd02", "plan": {}, "tags": "fake-tags", "vmId": "cdec8bb8-ec3f-437a-89dd-3df677e1507e", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_E4s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmhdbprd02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmhdbprd02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmhdbprd02-Data01", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "1", "vhd": {"uri": ""}, "name": "disk-vmhdbprd02-Data02", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "2", "vhd": {"uri": ""}, "name": "disk-vmhdbprd02-Data03", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "3", "vhd": {"uri": ""}, "name": "disk-vmhdbprd02-Data04", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "4", "vhd": {"uri": ""}, "name": "disk-vmhdbprd02-Data05", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "5", "vhd": {"uri": ""}, "name": "disk-vmhdbprd02-Data06", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "6", "vhd": {"uri": ""}, "name": "disk-vmhdbprd02-Data07", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.12"}]}, "ipv6": {}, "macAddress": "000D3A21F108"}]}}, "Provider": "azure"}	2024-04-09 15:07:04.502426	2024-04-09 15:07:04.502426
278	9cd46919-5f19-59aa-993e-cf3736c71053	ha_cluster_discovery	{"DC": true, "Id": "9c832998801e28cd70ad77380e82a5c0", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmhdbprd01", "InstanceAttributes": [{"Id": "nodes-1-lpa_hdp_lpt", "Name": "lpa_hdp_lpt", "Value": "1643125019"}, {"Id": "nodes-1-hana_hdp_vhost", "Name": "hana_hdp_vhost", "Value": "vmhdbprd01"}, {"Id": "nodes-1-hana_hdp_site", "Name": "hana_hdp_site", "Value": "NBG"}, {"Id": "nodes-1-hana_hdp_op_mode", "Name": "hana_hdp_op_mode", "Value": "logreplay"}, {"Id": "nodes-1-hana_hdp_srmode", "Name": "hana_hdp_srmode", "Value": "sync"}, {"Id": "nodes-1-hana_hdp_remoteHost", "Name": "hana_hdp_remoteHost", "Value": "vmhdbprd02"}]}, {"Id": "2", "Uname": "vmhdbprd02", "InstanceAttributes": [{"Id": "nodes-2-lpa_hdp_lpt", "Name": "lpa_hdp_lpt", "Value": "30"}, {"Id": "nodes-2-hana_hdp_op_mode", "Name": "hana_hdp_op_mode", "Value": "logreplay"}, {"Id": "nodes-2-hana_hdp_vhost", "Name": "hana_hdp_vhost", "Value": "vmhdbprd02"}, {"Id": "nodes-2-hana_hdp_remoteHost", "Name": "hana_hdp_remoteHost", "Value": "vmhdbprd01"}, {"Id": "nodes-2-hana_hdp_site", "Name": "hana_hdp_site", "Value": "WDF"}, {"Id": "nodes-2-hana_hdp_srmode", "Name": "hana_hdp_srmode", "Value": "sync"}]}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "hana_cluster_3"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "24"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}, {"Id": "SAPHanaSR-hana_hdp_site_srHook_WDF", "Name": "hana_hdp_site_srHook_WDF", "Value": "SOK"}]}, "Resources": {"Clones": [{"Id": "cln_SAPHanaTopology_HDP_HDB10", "Primitive": {"Id": "rsc_SAPHanaTopology_HDP_HDB10", "Type": "SAPHanaTopology", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHanaTopology_HDP_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "600", "Interval": "10"}, {"Id": "rsc_SAPHanaTopology_HDP_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "600", "Interval": "0"}, {"Id": "rsc_SAPHanaTopology_HDP_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "300", "Interval": "0"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHanaTopology_HDP_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDP"}, {"Id": "rsc_SAPHanaTopology_HDP_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}]}, "MetaAttributes": [{"Id": "cln_SAPHanaTopology_HDP_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "cln_SAPHanaTopology_HDP_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g_ip_HDP_HDB10", "Primitives": [{"Id": "rsc_ip_HDP_HDB10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_HDP_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDP_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDP_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_HDP_HDB10-instance_attributes-ip", "Name": "ip", "Value": "10.80.1.13"}, {"Id": "rsc_ip_HDP_HDB10-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "24"}, {"Id": "rsc_ip_HDP_HDB10-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "rsc_socat_HDP_HDB10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_HDP_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_HDP_HDB10-instance_attributes-port", "Name": "port", "Value": "62510"}]}]}], "Masters": [{"Id": "msl_SAPHana_HDP_HDB10", "Primitive": {"Id": "rsc_SAPHana_HDP_HDB10", "Type": "SAPHana", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHana_HDP_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDP_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDP_HDB10-promote-0", "Name": "promote", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDP_HDB10-monitor-60", "Name": "monitor", "Role": "Master", "Timeout": "700", "Interval": "60"}, {"Id": "rsc_SAPHana_HDP_HDB10-monitor-61", "Name": "monitor", "Role": "Slave", "Timeout": "700", "Interval": "61"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDP"}, {"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}, {"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-PREFER_SITE_TAKEOVER", "Name": "PREFER_SITE_TAKEOVER", "Value": "True"}, {"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-AUTOMATED_REGISTER", "Name": "AUTOMATED_REGISTER", "Value": "False"}, {"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-DUPLICATE_PRIMARY_TIMEOUT", "Name": "DUPLICATE_PRIMARY_TIMEOUT", "Value": "7200"}]}, "MetaAttributes": [{"Id": "msl_SAPHana_HDP_HDB10-meta_attributes-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "msl_SAPHana_HDP_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "msl_SAPHana_HDP_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": [{"Id": "stonith-sbd-monitor-15", "Name": "monitor", "Role": "", "Timeout": "15", "Interval": "15"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "15"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b924e77", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "a7a18c6b-7c8e-4bda-bb77-45e4b5dc8478", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmhdbprd01", "Status": "clear"}, {"Id": 1, "Name": "vmhdbprd02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b924e77", "Status": "healthy"}, {"Dump": {"Uuid": "a7a18c6b-7c8e-4bda-bb77-45e4b5dc8478", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmhdbprd01", "Status": "clear"}, {"Id": 1, "Name": "vmhdbprd02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b912345", "Status": "unhealthy"}, {"Dump": {"Uuid": "a7a18c6b-7c8e-4bda-bb77-45e4b5dc8478", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmhdbprd01", "Status": "clear"}, {"Id": 1, "Name": "vmhdbprd02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b954321", "Status": "unknown"}]}, "Name": "hana_cluster_3", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmhdbprd01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 5}, {"DC": false, "Id": "2", "Name": "vmhdbprd02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}], "Clones": [{"Id": "msl_SAPHana_HDP_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHana_HDP_HDB10", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Master", "Agent": "ocf::suse:SAPHana", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHana_HDP_HDB10", "Node": {"Id": "2", "Name": "vmhdbprd02", "Cached": true}, "Role": "Slave", "Agent": "ocf::suse:SAPHana", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": true, "FailureIgnored": false}, {"Id": "cln_SAPHanaTopology_HDP_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHanaTopology_HDP_HDB10", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHanaTopology_HDP_HDB10", "Node": {"Id": "2", "Name": "vmhdbprd02", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g_ip_HDP_HDB10", "Resources": [{"Id": "rsc_ip_HDP_HDB10", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_HDP_HDB10", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 7, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 25 15:36:59 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmhdbprd01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_ip_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHana_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmhdbprd02", "ResourceHistory": [{"Name": "rsc_SAPHana_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmhdbprd01", "Attributes": [{"Name": "hana_hdp_clone_state", "Value": "PROMOTED"}, {"Name": "hana_hdp_op_mode", "Value": "logreplay"}, {"Name": "hana_hdp_remoteHost", "Value": "vmhdbprd02"}, {"Name": "hana_hdp_roles", "Value": "4:P:master1:master:worker:master"}, {"Name": "hana_hdp_site", "Value": "NBG"}, {"Name": "hana_hdp_srmode", "Value": "sync"}, {"Name": "hana_hdp_sync_state", "Value": "PRIM"}, {"Name": "hana_hdp_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdp_vhost", "Value": "vmhdbprd01"}, {"Name": "lpa_hdp_lpt", "Value": "1643125019"}, {"Name": "master-rsc_SAPHana_HDP_HDB10", "Value": "150"}]}, {"Name": "vmhdbprd02", "Attributes": [{"Name": "hana_hdp_clone_state", "Value": "DEMOTED"}, {"Name": "hana_hdp_op_mode", "Value": "logreplay"}, {"Name": "hana_hdp_remoteHost", "Value": "vmhdbprd01"}, {"Name": "hana_hdp_roles", "Value": "4:S:master1:master:worker:master"}, {"Name": "hana_hdp_site", "Value": "WDF"}, {"Name": "hana_hdp_srmode", "Value": "sync"}, {"Name": "hana_hdp_sync_state", "Value": "SOK"}, {"Name": "hana_hdp_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdp_vhost", "Value": "vmhdbprd02"}, {"Name": "lpa_hdp_lpt", "Value": "30"}, {"Name": "master-rsc_SAPHana_HDP_HDB10", "Value": "100"}]}]}}, "Provider": "azure"}	2024-04-09 15:08:26.37174	2024-04-09 15:08:26.37174
280	69f4dcbb-efa2-5a16-8bc8-01df7dbb7384	host_discovery	{"hostname": "vmiscsi01", "cpu_count": 1, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.100.1.4", "fe80::20d:3aff:fe2a:aabe"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 3421, "fully_qualified_domain_name": "vmiscsi01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:08:26.627417	2024-04-09 15:08:26.627417
47	9cd46919-5f19-59aa-993e-cf3736c71053	saptune_discovery	{"status": {"pid": 24623, "argv": "saptune --format json status", "result": {"staging": {"Notes staged": [], "staging enabled": false, "Solutions staged": []}, "services": {"tuned": [], "sapconf": [], "saptune": ["enabled", "active"]}, "tuning state": "compliant", "Notes applied": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "Notes enabled": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "virtualization": "oracle", "package version": "3.1.0", "Solution applied": [{"Solution ID": "HANA", "applied partially": false}], "Solution enabled": ["HANA"], "remember message": "\\nRegarding the tuning state of the system please use 'saptune note verify' for detailed information.\\n\\n", "configured version": "3", "systemd system state": "running", "Notes applied by Solution": [{"Note list": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "Solution ID": "HANA"}], "Notes enabled by Solution": [{"Note list": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "Solution ID": "HANA"}], "Notes enabled additionally": []}, "$schema": "file:///usr/share/saptune/schemas/1.0/saptune_status.schema.json", "command": "status", "messages": [{"message": "actions.go:85: ATTENTION: You are running a test version (3.1.0 from 2022/11/28) of saptune which is not supported for production use\\n", "priority": "NOTICE"}, {"message": "sysctl.go:73: Parameter 'kernel.shmmax' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0xffffffffffffffff), /boot/sysctl.conf-5.3.18-150300.59.93-default(0xffffffffffffffff).\\n", "priority": "WARNING"}, {"message": "sysctl.go:73: Parameter 'kernel.shmall' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0x0fffffffffffff00), /boot/sysctl.conf-5.3.18-150300.59.93-default(0x0fffffffffffff00).\\n", "priority": "WARNING"}, {"message": "ini.go:308: block device related section settings detected: Traversing all block devices can take a considerable amount of time.\\n", "priority": "NOTICE"}], "exit code": 4, "publish time": "2023-04-24 12:41:56.612"}, "package_version": "3.1.0", "saptune_installed": true}	2024-04-09 15:07:01.177146	2024-04-09 15:07:01.177146
57	21de186a-e38f-5804-b643-7f4ef22fecfd	ha_cluster_discovery	{"DC": true, "Id": "04a81f89c847e82390e35bece2e25c9b", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmdrbddev01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmdrbddev02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "drbd_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": [{"Id": "cl-nfsserver", "Primitive": {"Id": "nfsserver", "Type": "nfs-server", "Class": "systemd", "Provider": "", "Operations": [{"Id": "nfsserver-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": null}, "MetaAttributes": [{"Id": "cl-nfsserver-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g-nfs_sapdata", "Primitives": [{"Id": "fs_sapdata", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "fs_sapdata-monitor-20", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "fs_sapdata-instance_attributes-device", "Name": "device", "Value": "/dev/drbd1"}, {"Id": "fs_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWD"}, {"Id": "fs_sapdata-instance_attributes-fstype", "Name": "fstype", "Value": "xfs"}, {"Id": "fs_sapdata-instance_attributes-options", "Name": "options", "Value": "noatime,nodiratime"}]}, {"Id": "vip_sapdata_nfs", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "vip_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "vip_sapdata_nfs-instance_attributes-ip", "Name": "ip", "Value": "10.100.1.33"}, {"Id": "vip_sapdata_nfs-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "32"}, {"Id": "vip_sapdata_nfs-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "exportfs_work_sapdata", "Type": "exportfs", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "exportfs_work_sapdata-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "exportfs_work_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWD"}, {"Id": "exportfs_work_sapdata-instance_attributes-fsid", "Name": "fsid", "Value": "1"}, {"Id": "exportfs_work_sapdata-instance_attributes-options", "Name": "options", "Value": "rw,no_root_squash"}, {"Id": "exportfs_work_sapdata-instance_attributes-clientspec", "Name": "clientspec", "Value": "*"}, {"Id": "exportfs_work_sapdata-instance_attributes-wait_for_leasetime_on_stop", "Name": "wait_for_leasetime_on_stop", "Value": "true"}]}, {"Id": "rsc_socat_sapdata_nfs", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_sapdata_nfs-instance_attributes-port", "Name": "port", "Value": "61000"}]}]}], "Masters": [{"Id": "ms_sapdata", "Primitive": {"Id": "drbd-sapdata", "Type": "drbd", "Class": "ocf", "Provider": "linbit", "Operations": [{"Id": "drbd-sapdata-monitor-15", "Name": "monitor", "Role": "Master", "Timeout": "", "Interval": "15"}, {"Id": "drbd-sapdata-monitor-30", "Name": "monitor", "Role": "Slave", "Timeout": "", "Interval": "30"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "drbd-sapdata-instance_attributes-drbd_resource", "Name": "drbd_resource", "Value": "sapdata"}]}, "MetaAttributes": [{"Id": "ms_sapdata-meta_attributes-master-max", "Name": "master-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-master-node-max", "Name": "master-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-0-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "ms_sapdata-meta_attributes-0-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-1-notify", "Name": "notify", "Value": "true"}, {"Id": "ms_sapdata-meta_attributes-1-target-role", "Name": "target-role", "Value": "Started"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:3947fa28-25e0-46d4-bbed-89ce88f977f1", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "27016e64-5f07-4563-90d5-16cb8f9ebc2a", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmdrbddev01", "Status": "clear"}, {"Id": 1, "Name": "vmdrbddev02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:3947fa28-25e0-46d4-bbed-89ce88f977f1", "Status": "healthy"}]}, "Name": "drbd_cluster", "Crmmon": {"Nodes": [{"DC": false, "Id": "1", "Name": "vmdrbddev01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 7}, {"DC": true, "Id": "2", "Name": "vmdrbddev02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}], "Clones": [{"Id": "ms_sapdata", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "drbd-sapdata", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Master", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "drbd-sapdata", "Node": {"Id": "2", "Name": "vmdrbddev02", "Cached": true}, "Role": "Slave", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": true, "FailureIgnored": false}, {"Id": "cl-nfsserver", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "nfsserver", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "nfsserver", "Node": {"Id": "2", "Name": "vmdrbddev02", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g-nfs_sapdata", "Resources": [{"Id": "fs_sapdata", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "vip_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "exportfs_work_sapdata", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:exportfs", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 12:50:53 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmdrbddev01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "fs_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "vip_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "exportfs_work_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmdrbddev02", "ResourceHistory": [{"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmdrbddev01", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}, {"Name": "vmdrbddev02", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}]}}, "Provider": "azure"}	2024-04-09 15:07:02.517251	2024-04-09 15:07:02.517251
69	a09d9cf3-46c1-505c-8fb8-4b0a71a9114e	saptune_discovery	{"status": {"pid": 24623, "argv": "saptune --format json status", "result": {"staging": {"Notes staged": [], "staging enabled": false, "Solutions staged": []}, "services": {"tuned": [], "sapconf": [], "saptune": ["enabled", "inactive"]}, "tuning state": "not tuned", "Notes applied": [], "Notes enabled": [], "virtualization": "oracle", "package version": "3.1.0", "Solution applied": [], "Solution enabled": [], "remember message": "\\nRegarding the tuning state of the system please use 'saptune note verify' for detailed information.\\n\\n", "configured version": "3", "systemd system state": "running", "Notes applied by Solution": [], "Notes enabled by Solution": [], "Notes enabled additionally": []}, "$schema": "file:///usr/share/saptune/schemas/1.0/saptune_status.schema.json", "command": "status", "messages": [], "exit code": 4, "publish time": "2023-04-24 12:41:56.612"}, "package_version": "3.1.0", "saptune_installed": true}	2024-04-09 15:07:04.07039	2024-04-09 15:07:04.07039
76	ddcb7992-2ffb-5c10-8b39-80685f6eaaba	sap_system_discovery	[]	2024-04-09 15:07:04.998445	2024-04-09 15:07:04.998445
91	9cd46919-5f19-59aa-993e-cf3736c71053	sap_system_discovery	[{"Id": "1154f7678ac587e5f0f242830a5201f1", "SID": "HDP", "Type": 1, "Profile": {"SAPGLOBALHOST": "vmhdbprd01", "SAPSYSTEMNAME": "HDP", "hdbConfigType": "DEFAULT", "ssl/ciphersuites": "135:PFS:HIGH::EC_P256:EC_HIGH", "HDB_LINKED_BINARIES": "yes", "HDB_SHARED_BINARIES": "yes"}, "Databases": [{"Host": "vmhdbprd01", "User": "", "Group": "", "Active": "yes", "UserId": "", "GroupId": "", "SqlPort": "31015", "Database": "HDP", "Container": ""}], "Instances": [{"Host": "vmhdbprd01", "Name": "HDB10", "Type": 1, "SAPControl": {"Instances": [{"features": "HDB|HDB_WORKER", "hostname": "vmhdbprd01", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.3"}], "Processes": [{"pid": 2186, "name": "hdbdaemon", "starttime": "2022 01 11 13:34:58", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Daemon", "elapsedtime": "151:17:01"}, {"pid": 3720, "name": "hdbxsengine", "starttime": "2022 01 11 13:35:18", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB XSEngine-HDP", "elapsedtime": "151:16:41"}, {"pid": 2245, "name": "hdbnameserver", "starttime": "2022 01 11 13:34:58", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Nameserver", "elapsedtime": "151:17:01"}, {"pid": 3717, "name": "hdbindexserver", "starttime": "2022 01 11 13:35:18", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Indexserver-HDP", "elapsedtime": "151:16:41"}, {"pid": 3617, "name": "hdbpreprocessor", "starttime": "2022 01 11 13:35:17", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Preprocessor", "elapsedtime": "151:16:42"}, {"pid": 3614, "name": "hdbcompileserver", "starttime": "2022 01 11 13:35:17", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Compileserver", "elapsedtime": "151:16:42"}, {"pid": 6387, "name": "hdbwebdispatcher", "starttime": "2022 01 11 13:35:47", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Web Dispatcher", "elapsedtime": "151:16:12"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "YES", "property": "DBServices", "propertytype": "Attribute"}, {"value": "worker", "property": "HANA Roles", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "vmhdbprd01", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "HDB10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "HDP", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://vmhdbprd01:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": {"mode": "primary", "online": "true", "site_id": "1", "isSource": "true", "site_name": "NBG", "isConsumer": "false", "hasConsumers": "true", "siteTier/NBG": "1", "siteTier/WDF": "2", "operation_mode": "primary", "siteMapping/NBG": "WDF", "isTakeoverActive": "false", "isPrimarySuspended": "false", "mapping/vmhdbprd01": ["WDF/vmhdbprd02", "NBG/vmhdbprd01"], "siteOperationMode/NBG": "primary", "siteOperationMode/WDF": "logreplay", "siteReplicationMode/NBG": "primary", "siteReplicationMode/WDF": "sync"}, "HostConfiguration": {"host": "vmhdbprd01", "hostActive": "yes", "hostStatus": "ok", "removeStatus": "", "failoverStatus": "", "hostActualRoles": "worker", "hostConfigRoles": "worker", "storagePartition": "1", "workerActualGroups": "default", "workerConfigGroups": "default", "failoverActualGroup": "default", "failoverConfigGroup": "default", "nameServerActualRole": "master", "nameServerConfigRole": "master 1", "indexServerActualRole": "master", "indexServerConfigRole": "worker", "storageActualPartition": "1", "storageConfigPartition": "1"}, "SystemReplication": {"local_site_id": "1", "site/1/SITE_NAME": "NBG", "site/2/SITE_NAME": "WDF", "site/2/SOURCE_SITE_ID": "1", "site/1/REPLICATION_MODE": "PRIMARY", "site/2/REPLICATION_MODE": "SYNC", "site/2/REPLICATION_STATUS": "ACTIVE", "overall_replication_status": "ACTIVE", "service/vmhdbprd01/31001/HOST": "vmhdbprd01", "service/vmhdbprd01/31001/PORT": "31001", "service/vmhdbprd01/31003/HOST": "vmhdbprd01", "service/vmhdbprd01/31003/PORT": "31003", "service/vmhdbprd01/31007/HOST": "vmhdbprd01", "service/vmhdbprd01/31007/PORT": "31007", "service/vmhdbprd01/31001/SITE_ID": "1", "service/vmhdbprd01/31003/SITE_ID": "1", "service/vmhdbprd01/31007/SITE_ID": "1", "service/vmhdbprd01/31001/DATABASE": "SYSTEMDB", "service/vmhdbprd01/31003/DATABASE": "HDP", "service/vmhdbprd01/31007/DATABASE": "HDP", "service/vmhdbprd01/31001/FULL_SYNC": "DISABLED", "service/vmhdbprd01/31001/SITE_NAME": "NBG", "service/vmhdbprd01/31001/VOLUME_ID": "1", "service/vmhdbprd01/31003/FULL_SYNC": "DISABLED", "service/vmhdbprd01/31003/SITE_NAME": "NBG", "service/vmhdbprd01/31003/VOLUME_ID": "3", "service/vmhdbprd01/31007/FULL_SYNC": "DISABLED", "service/vmhdbprd01/31007/SITE_NAME": "NBG", "service/vmhdbprd01/31007/VOLUME_ID": "2", "service/vmhdbprd01/31001/RESET_COUNT": "0", "service/vmhdbprd01/31003/RESET_COUNT": "0", "service/vmhdbprd01/31007/RESET_COUNT": "0", "service/vmhdbprd01/31001/SERVICE_NAME": "nameserver", "service/vmhdbprd01/31003/SERVICE_NAME": "indexserver", "service/vmhdbprd01/31007/SERVICE_NAME": "xsengine", "service/vmhdbprd01/31001/CREATION_TIME": "2022-01-11 13:35:17.794006", "service/vmhdbprd01/31003/CREATION_TIME": "2022-01-11 13:35:44.241176", "service/vmhdbprd01/31007/CREATION_TIME": "2022-01-11 13:35:48.262371", "service/vmhdbprd01/31001/OPERATION_MODE": "logreplay", "service/vmhdbprd01/31001/SECONDARY_HOST": "vmhdbprd02", "service/vmhdbprd01/31001/SECONDARY_PORT": "31001", "service/vmhdbprd01/31003/OPERATION_MODE": "logreplay", "service/vmhdbprd01/31003/SECONDARY_HOST": "vmhdbprd02", "service/vmhdbprd01/31003/SECONDARY_PORT": "31003", "service/vmhdbprd01/31007/OPERATION_MODE": "logreplay", "service/vmhdbprd01/31007/SECONDARY_HOST": "vmhdbprd02", "service/vmhdbprd01/31007/SECONDARY_PORT": "31007", "service/vmhdbprd01/31001/LAST_RESET_TIME": "2022-01-11 13:35:17.794006", "service/vmhdbprd01/31003/LAST_RESET_TIME": "2022-01-11 13:35:44.241176", "service/vmhdbprd01/31007/LAST_RESET_TIME": "2022-01-11 13:35:48.262371", "service/vmhdbprd01/31001/REPLICATION_MODE": "SYNC", "service/vmhdbprd01/31003/REPLICATION_MODE": "SYNC", "service/vmhdbprd01/31007/REPLICATION_MODE": "SYNC", "service/vmhdbprd01/31001/LAST_LOG_POSITION": "45316224", "service/vmhdbprd01/31001/SECONDARY_SITE_ID": "2", "service/vmhdbprd01/31003/LAST_LOG_POSITION": "249613824", "service/vmhdbprd01/31003/SECONDARY_SITE_ID": "2", "service/vmhdbprd01/31007/LAST_LOG_POSITION": "4700160", "service/vmhdbprd01/31007/SECONDARY_SITE_ID": "2", "service/vmhdbprd01/31001/REPLICATION_STATUS": "ACTIVE", "service/vmhdbprd01/31003/REPLICATION_STATUS": "ACTIVE", "service/vmhdbprd01/31007/REPLICATION_STATUS": "ACTIVE", "service/vmhdbprd01/31001/SECONDARY_SITE_NAME": "WDF", "service/vmhdbprd01/31003/SECONDARY_SITE_NAME": "WDF", "service/vmhdbprd01/31007/SECONDARY_SITE_NAME": "WDF", "service/vmhdbprd01/31001/SHIPPED_LOG_POSITION": "45316224", "service/vmhdbprd01/31003/SHIPPED_LOG_POSITION": "249613824", "service/vmhdbprd01/31007/SHIPPED_LOG_POSITION": "4700160", "service/vmhdbprd01/31001/REPLAYED_LOG_POSITION": "45316224", "service/vmhdbprd01/31003/REPLAYED_LOG_POSITION": "249613824", "service/vmhdbprd01/31007/REPLAYED_LOG_POSITION": "4700101", "service/vmhdbprd01/31001/LAST_LOG_POSITION_TIME": "2022-01-17 20:51:48.550230", "service/vmhdbprd01/31001/LAST_SAVEPOINT_VERSION": "3068", "service/vmhdbprd01/31001/SECONDARY_CONNECT_TIME": "2022-01-11 13:36:31.486904", "service/vmhdbprd01/31003/LAST_LOG_POSITION_TIME": "2022-01-17 20:51:44.595948", "service/vmhdbprd01/31003/LAST_SAVEPOINT_VERSION": "2792", "service/vmhdbprd01/31003/SECONDARY_CONNECT_TIME": "2022-01-11 13:40:09.285107", "service/vmhdbprd01/31007/LAST_LOG_POSITION_TIME": "2022-01-17 20:51:15.066330", "service/vmhdbprd01/31007/LAST_SAVEPOINT_VERSION": "2862", "service/vmhdbprd01/31007/SECONDARY_CONNECT_TIME": "2022-01-11 13:40:08.545290", "service/vmhdbprd01/31001/SECONDARY_ACTIVE_STATUS": "YES", "service/vmhdbprd01/31003/SECONDARY_ACTIVE_STATUS": "YES", "service/vmhdbprd01/31007/SECONDARY_ACTIVE_STATUS": "YES", "service/vmhdbprd01/31001/SECONDARY_FAILOVER_COUNT": "0", "service/vmhdbprd01/31001/SHIPPED_LOG_BUFFERS_SIZE": "554209280", "service/vmhdbprd01/31003/SECONDARY_FAILOVER_COUNT": "0", "service/vmhdbprd01/31003/SHIPPED_LOG_BUFFERS_SIZE": "3611877376", "service/vmhdbprd01/31007/SECONDARY_FAILOVER_COUNT": "0", "service/vmhdbprd01/31007/SHIPPED_LOG_BUFFERS_SIZE": "267542528", "service/vmhdbprd01/31001/LAST_SAVEPOINT_START_TIME": "2022-01-17 20:49:08.441827", "service/vmhdbprd01/31001/SECONDARY_RECONNECT_COUNT": "0", "service/vmhdbprd01/31001/SHIPPED_FULL_REPLICA_SIZE": "0", "service/vmhdbprd01/31001/SHIPPED_LOG_BUFFERS_COUNT": "125120", "service/vmhdbprd01/31001/SHIPPED_LOG_POSITION_TIME": "2022-01-17 20:51:48.550230", "service/vmhdbprd01/31001/SHIPPED_SAVEPOINT_VERSION": "0", "service/vmhdbprd01/31003/LAST_SAVEPOINT_START_TIME": "2022-01-17 20:48:13.337797", "service/vmhdbprd01/31003/SECONDARY_RECONNECT_COUNT": "7", "service/vmhdbprd01/31003/SHIPPED_FULL_REPLICA_SIZE": "0", "service/vmhdbprd01/31003/SHIPPED_LOG_BUFFERS_COUNT": "693785", "service/vmhdbprd01/31003/SHIPPED_LOG_POSITION_TIME": "2022-01-17 20:51:44.595948", "service/vmhdbprd01/31003/SHIPPED_SAVEPOINT_VERSION": "0", "service/vmhdbprd01/31007/LAST_SAVEPOINT_START_TIME": "2022-01-17 20:51:13.839155", "service/vmhdbprd01/31007/SECONDARY_RECONNECT_COUNT": "7", "service/vmhdbprd01/31007/SHIPPED_FULL_REPLICA_SIZE": "0", "service/vmhdbprd01/31007/SHIPPED_LOG_BUFFERS_COUNT": "65318", "service/vmhdbprd01/31007/SHIPPED_LOG_POSITION_TIME": "2022-01-17 20:51:15.066330", "service/vmhdbprd01/31007/SHIPPED_SAVEPOINT_VERSION": "0", "service/vmhdbprd01/31001/REPLAYED_LOG_POSITION_TIME": "2022-01-17 20:51:48.550230", "service/vmhdbprd01/31001/REPLICATION_STATUS_DETAILS": "", "service/vmhdbprd01/31001/SHIPPED_DELTA_REPLICA_SIZE": "0", "service/vmhdbprd01/31001/SHIPPED_FULL_REPLICA_COUNT": "0", "service/vmhdbprd01/31003/REPLAYED_LOG_POSITION_TIME": "2022-01-17 20:51:44.595948", "service/vmhdbprd01/31003/REPLICATION_STATUS_DETAILS": "", "service/vmhdbprd01/31003/SHIPPED_DELTA_REPLICA_SIZE": "0", "service/vmhdbprd01/31003/SHIPPED_FULL_REPLICA_COUNT": "0", "service/vmhdbprd01/31007/REPLAYED_LOG_POSITION_TIME": "2022-01-17 20:51:15.066330", "service/vmhdbprd01/31007/REPLICATION_STATUS_DETAILS": "", "service/vmhdbprd01/31007/SHIPPED_DELTA_REPLICA_SIZE": "0", "service/vmhdbprd01/31007/SHIPPED_FULL_REPLICA_COUNT": "0", "service/vmhdbprd01/31001/LAST_SAVEPOINT_LOG_POSITION": "45312962", "service/vmhdbprd01/31001/SHIPPED_DELTA_REPLICA_COUNT": "0", "service/vmhdbprd01/31003/LAST_SAVEPOINT_LOG_POSITION": "249597314", "service/vmhdbprd01/31003/SHIPPED_DELTA_REPLICA_COUNT": "0", "service/vmhdbprd01/31007/LAST_SAVEPOINT_LOG_POSITION": "4699655", "service/vmhdbprd01/31007/SHIPPED_DELTA_REPLICA_COUNT": "0", "service/vmhdbprd01/31001/SHIPPED_LOG_BUFFERS_DURATION": "357505585", "service/vmhdbprd01/31001/SHIPPED_SAVEPOINT_START_TIME": "-", "service/vmhdbprd01/31003/SHIPPED_LOG_BUFFERS_DURATION": "1885304582", "service/vmhdbprd01/31003/SHIPPED_SAVEPOINT_START_TIME": "-", "service/vmhdbprd01/31007/SHIPPED_LOG_BUFFERS_DURATION": "191364516", "service/vmhdbprd01/31007/SHIPPED_SAVEPOINT_START_TIME": "-", "service/vmhdbprd01/31001/SHIPPED_FULL_REPLICA_DURATION": "0", "service/vmhdbprd01/31003/SHIPPED_FULL_REPLICA_DURATION": "0", "service/vmhdbprd01/31007/SHIPPED_FULL_REPLICA_DURATION": "0", "service/vmhdbprd01/31001/SHIPPED_DELTA_REPLICA_DURATION": "0", "service/vmhdbprd01/31001/SHIPPED_LAST_FULL_REPLICA_SIZE": "0", "service/vmhdbprd01/31001/SHIPPED_SAVEPOINT_LOG_POSITION": "0", "service/vmhdbprd01/31003/SHIPPED_DELTA_REPLICA_DURATION": "0", "service/vmhdbprd01/31003/SHIPPED_LAST_FULL_REPLICA_SIZE": "0", "service/vmhdbprd01/31003/SHIPPED_SAVEPOINT_LOG_POSITION": "0", "service/vmhdbprd01/31007/SHIPPED_DELTA_REPLICA_DURATION": "0", "service/vmhdbprd01/31007/SHIPPED_LAST_FULL_REPLICA_SIZE": "0", "service/vmhdbprd01/31007/SHIPPED_SAVEPOINT_LOG_POSITION": "0", "service/vmhdbprd01/31001/SHIPPED_LAST_DELTA_REPLICA_SIZE": "0", "service/vmhdbprd01/31003/SHIPPED_LAST_DELTA_REPLICA_SIZE": "0", "service/vmhdbprd01/31007/SHIPPED_LAST_DELTA_REPLICA_SIZE": "0", "service/vmhdbprd01/31001/SHIPPED_LAST_FULL_REPLICA_END_TIME": "-", "service/vmhdbprd01/31003/SHIPPED_LAST_FULL_REPLICA_END_TIME": "-", "service/vmhdbprd01/31007/SHIPPED_LAST_FULL_REPLICA_END_TIME": "-", "service/vmhdbprd01/31001/SHIPPED_LAST_DELTA_REPLICA_END_TIME": "-", "service/vmhdbprd01/31003/SHIPPED_LAST_DELTA_REPLICA_END_TIME": "-", "service/vmhdbprd01/31007/SHIPPED_LAST_DELTA_REPLICA_END_TIME": "-", "service/vmhdbprd01/31001/SHIPPED_LAST_FULL_REPLICA_START_TIME": "-", "service/vmhdbprd01/31003/SHIPPED_LAST_FULL_REPLICA_START_TIME": "-", "service/vmhdbprd01/31007/SHIPPED_LAST_FULL_REPLICA_START_TIME": "-", "service/vmhdbprd01/31001/SHIPPED_LAST_DELTA_REPLICA_START_TIME": "-", "service/vmhdbprd01/31003/SHIPPED_LAST_DELTA_REPLICA_START_TIME": "-", "service/vmhdbprd01/31007/SHIPPED_LAST_DELTA_REPLICA_START_TIME": "-"}}]}]	2024-04-09 15:07:06.931305	2024-04-09 15:07:06.931305
92	21de186a-e38f-5804-b643-7f4ef22fecfd	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:07:07.061885	2024-04-09 15:07:07.061885
96	1b0e9297-97dd-55d6-9874-8efde4d84c90	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:07.669977	2024-04-09 15:07:07.669977
99	ddcb7992-2ffb-5c10-8b39-80685f6eaaba	ha_cluster_discovery	{"DC": false, "Id": "a034a158905404befe08775682910ee1", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmdrbdqas01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmdrbdqas02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "drbd_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": [{"Id": "cl-nfsserver", "Primitive": {"Id": "nfsserver", "Type": "nfs-server", "Class": "systemd", "Provider": "", "Operations": [{"Id": "nfsserver-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": null}, "MetaAttributes": [{"Id": "cl-nfsserver-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g-nfs_sapdata", "Primitives": [{"Id": "fs_sapdata", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "fs_sapdata-monitor-20", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "fs_sapdata-instance_attributes-device", "Name": "device", "Value": "/dev/drbd1"}, {"Id": "fs_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWQ"}, {"Id": "fs_sapdata-instance_attributes-fstype", "Name": "fstype", "Value": "xfs"}, {"Id": "fs_sapdata-instance_attributes-options", "Name": "options", "Value": "noatime,nodiratime"}]}, {"Id": "vip_sapdata_nfs", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "vip_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "vip_sapdata_nfs-instance_attributes-ip", "Name": "ip", "Value": "10.90.1.33"}, {"Id": "vip_sapdata_nfs-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "32"}, {"Id": "vip_sapdata_nfs-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "exportfs_work_sapdata", "Type": "exportfs", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "exportfs_work_sapdata-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "exportfs_work_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWQ"}, {"Id": "exportfs_work_sapdata-instance_attributes-fsid", "Name": "fsid", "Value": "1"}, {"Id": "exportfs_work_sapdata-instance_attributes-options", "Name": "options", "Value": "rw,no_root_squash"}, {"Id": "exportfs_work_sapdata-instance_attributes-clientspec", "Name": "clientspec", "Value": "*"}, {"Id": "exportfs_work_sapdata-instance_attributes-wait_for_leasetime_on_stop", "Name": "wait_for_leasetime_on_stop", "Value": "true"}]}, {"Id": "rsc_socat_sapdata_nfs", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_sapdata_nfs-instance_attributes-port", "Name": "port", "Value": "61000"}]}]}], "Masters": [{"Id": "ms_sapdata", "Primitive": {"Id": "drbd-sapdata", "Type": "drbd", "Class": "ocf", "Provider": "linbit", "Operations": [{"Id": "drbd-sapdata-monitor-15", "Name": "monitor", "Role": "Master", "Timeout": "", "Interval": "15"}, {"Id": "drbd-sapdata-monitor-30", "Name": "monitor", "Role": "Slave", "Timeout": "", "Interval": "30"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "drbd-sapdata-instance_attributes-drbd_resource", "Name": "drbd_resource", "Value": "sapdata"}]}, "MetaAttributes": [{"Id": "ms_sapdata-meta_attributes-master-max", "Name": "master-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-master-node-max", "Name": "master-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-0-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "ms_sapdata-meta_attributes-0-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-1-notify", "Name": "notify", "Value": "true"}, {"Id": "ms_sapdata-meta_attributes-1-target-role", "Name": "target-role", "Value": "Started"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:c1c003f5-4e45-4d6f-8d81-e338f666365c", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "f5991966-5a7f-45d6-90d1-bfcedb265df6", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmdrbdqas01", "Status": "clear"}, {"Id": 1, "Name": "vmdrbdqas02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:c1c003f5-4e45-4d6f-8d81-e338f666365c", "Status": "healthy"}]}, "Name": "drbd_cluster", "Crmmon": {"Nodes": [{"DC": false, "Id": "1", "Name": "vmdrbdqas01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 7}, {"DC": true, "Id": "2", "Name": "vmdrbdqas02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}], "Clones": [{"Id": "ms_sapdata", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "drbd-sapdata", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Master", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "drbd-sapdata", "Node": {"Id": "2", "Name": "vmdrbdqas02", "Cached": true}, "Role": "Slave", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": true, "FailureIgnored": false}, {"Id": "cl-nfsserver", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "nfsserver", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "nfsserver", "Node": {"Id": "2", "Name": "vmdrbdqas02", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g-nfs_sapdata", "Resources": [{"Id": "fs_sapdata", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "vip_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "exportfs_work_sapdata", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:exportfs", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 12:20:56 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmdrbdqas01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "fs_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "vip_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "exportfs_work_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmdrbdqas02", "ResourceHistory": [{"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmdrbdqas01", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}, {"Name": "vmdrbdqas02", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}]}}, "Provider": "azure"}	2024-04-09 15:07:08.137304	2024-04-09 15:07:08.137304
110	ddcb7992-2ffb-5c10-8b39-80685f6eaaba	host_discovery	{"hostname": "vmdrbdqas01", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.90.1.31", "10.90.1.33", "fe80::6245:bdff:fe8d:c2"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmdrbdqas01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:09.59193	2024-04-09 15:07:09.59193
112	99cf8a3a-48d6-57a4-b302-6e4482227ab6	sap_system_discovery	[{"Id": "9953878f07bb54cac20d5d5d7ff08af2", "SID": "HDQ", "Type": 1, "Profile": {"SAPGLOBALHOST": "vmhdbqas01", "SAPSYSTEMNAME": "HDQ", "hdbConfigType": "DEFAULT", "ssl/ciphersuites": "135:PFS:HIGH::EC_P256:EC_HIGH", "HDB_LINKED_BINARIES": "yes", "HDB_SHARED_BINARIES": "yes"}, "Databases": [{"Host": "vmhdbqas01", "User": "", "Group": "", "Active": "yes", "UserId": "", "GroupId": "", "SqlPort": "31015", "Database": "HDQ", "Container": ""}], "Instances": [{"Host": "vmhdbqas01", "Name": "HDB10", "Type": 1, "SAPControl": {"Instances": [{"features": "HDB|HDB_WORKER", "hostname": "vmhdbqas01", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.3"}], "Processes": [{"pid": 25408, "name": "hdbdaemon", "starttime": "2022 01 11 12:28:43", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Daemon", "elapsedtime": "152:23:18"}, {"pid": 27262, "name": "hdbxsengine", "starttime": "2022 01 11 12:29:06", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB XSEngine-HDQ", "elapsedtime": "152:22:55"}, {"pid": 25428, "name": "hdbnameserver", "starttime": "2022 01 11 12:28:44", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Nameserver", "elapsedtime": "152:23:17"}, {"pid": 27259, "name": "hdbindexserver", "starttime": "2022 01 11 12:29:06", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Indexserver-HDQ", "elapsedtime": "152:22:55"}, {"pid": 27206, "name": "hdbpreprocessor", "starttime": "2022 01 11 12:29:06", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Preprocessor", "elapsedtime": "152:22:55"}, {"pid": 27203, "name": "hdbcompileserver", "starttime": "2022 01 11 12:29:06", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Compileserver", "elapsedtime": "152:22:55"}, {"pid": 29632, "name": "hdbwebdispatcher", "starttime": "2022 01 11 12:29:37", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Web Dispatcher", "elapsedtime": "152:22:24"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "YES", "property": "DBServices", "propertytype": "Attribute"}, {"value": "worker", "property": "HANA Roles", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "vmhdbqas01", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "HDB10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "HDQ", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://vmhdbqas01:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": {"mode": "primary", "online": "true", "site_id": "1", "isSource": "true", "site_name": "NBG", "isConsumer": "false", "hasConsumers": "true", "siteTier/NBG": "1", "siteTier/WDF": "2", "operation_mode": "primary", "siteMapping/NBG": "WDF", "isTakeoverActive": "false", "isPrimarySuspended": "false", "mapping/vmhdbqas01": ["WDF/vmhdbqas02", "NBG/vmhdbqas01"], "siteOperationMode/NBG": "primary", "siteOperationMode/WDF": "logreplay", "siteReplicationMode/NBG": "primary", "siteReplicationMode/WDF": "sync"}, "HostConfiguration": {"host": "vmhdbqas01", "hostActive": "yes", "hostStatus": "ok", "removeStatus": "", "failoverStatus": "", "hostActualRoles": "worker", "hostConfigRoles": "worker", "storagePartition": "1", "workerActualGroups": "default", "workerConfigGroups": "default", "failoverActualGroup": "default", "failoverConfigGroup": "default", "nameServerActualRole": "master", "nameServerConfigRole": "master 1", "indexServerActualRole": "master", "indexServerConfigRole": "worker", "storageActualPartition": "1", "storageConfigPartition": "1"}, "SystemReplication": {"local_site_id": "1", "site/1/SITE_NAME": "NBG", "site/2/SITE_NAME": "WDF", "site/2/SOURCE_SITE_ID": "1", "site/1/REPLICATION_MODE": "PRIMARY", "site/2/REPLICATION_MODE": "SYNC", "site/2/REPLICATION_STATUS": "ACTIVE", "overall_replication_status": "ACTIVE", "service/vmhdbqas01/31001/HOST": "vmhdbqas01", "service/vmhdbqas01/31001/PORT": "31001", "service/vmhdbqas01/31003/HOST": "vmhdbqas01", "service/vmhdbqas01/31003/PORT": "31003", "service/vmhdbqas01/31007/HOST": "vmhdbqas01", "service/vmhdbqas01/31007/PORT": "31007", "service/vmhdbqas01/31001/SITE_ID": "1", "service/vmhdbqas01/31003/SITE_ID": "1", "service/vmhdbqas01/31007/SITE_ID": "1", "service/vmhdbqas01/31001/DATABASE": "SYSTEMDB", "service/vmhdbqas01/31003/DATABASE": "HDQ", "service/vmhdbqas01/31007/DATABASE": "HDQ", "service/vmhdbqas01/31001/FULL_SYNC": "DISABLED", "service/vmhdbqas01/31001/SITE_NAME": "NBG", "service/vmhdbqas01/31001/VOLUME_ID": "1", "service/vmhdbqas01/31003/FULL_SYNC": "DISABLED", "service/vmhdbqas01/31003/SITE_NAME": "NBG", "service/vmhdbqas01/31003/VOLUME_ID": "3", "service/vmhdbqas01/31007/FULL_SYNC": "DISABLED", "service/vmhdbqas01/31007/SITE_NAME": "NBG", "service/vmhdbqas01/31007/VOLUME_ID": "2", "service/vmhdbqas01/31001/RESET_COUNT": "0", "service/vmhdbqas01/31003/RESET_COUNT": "0", "service/vmhdbqas01/31007/RESET_COUNT": "0", "service/vmhdbqas01/31001/SERVICE_NAME": "nameserver", "service/vmhdbqas01/31003/SERVICE_NAME": "indexserver", "service/vmhdbqas01/31007/SERVICE_NAME": "xsengine", "service/vmhdbqas01/31001/CREATION_TIME": "2022-01-11 12:29:06.391562", "service/vmhdbqas01/31003/CREATION_TIME": "2022-01-11 12:29:33.189016", "service/vmhdbqas01/31007/CREATION_TIME": "2022-01-11 12:29:37.637575", "service/vmhdbqas01/31001/OPERATION_MODE": "logreplay", "service/vmhdbqas01/31001/SECONDARY_HOST": "vmhdbqas02", "service/vmhdbqas01/31001/SECONDARY_PORT": "31001", "service/vmhdbqas01/31003/OPERATION_MODE": "logreplay", "service/vmhdbqas01/31003/SECONDARY_HOST": "vmhdbqas02", "service/vmhdbqas01/31003/SECONDARY_PORT": "31003", "service/vmhdbqas01/31007/OPERATION_MODE": "logreplay", "service/vmhdbqas01/31007/SECONDARY_HOST": "vmhdbqas02", "service/vmhdbqas01/31007/SECONDARY_PORT": "31007", "service/vmhdbqas01/31001/LAST_RESET_TIME": "2022-01-11 12:29:06.391562", "service/vmhdbqas01/31003/LAST_RESET_TIME": "2022-01-11 12:29:33.189016", "service/vmhdbqas01/31007/LAST_RESET_TIME": "2022-01-11 12:29:37.637575", "service/vmhdbqas01/31001/REPLICATION_MODE": "SYNC", "service/vmhdbqas01/31003/REPLICATION_MODE": "SYNC", "service/vmhdbqas01/31007/REPLICATION_MODE": "SYNC", "service/vmhdbqas01/31001/LAST_LOG_POSITION": "45366976", "service/vmhdbqas01/31001/SECONDARY_SITE_ID": "2", "service/vmhdbqas01/31003/LAST_LOG_POSITION": "247682688", "service/vmhdbqas01/31003/SECONDARY_SITE_ID": "2", "service/vmhdbqas01/31007/LAST_LOG_POSITION": "4699712", "service/vmhdbqas01/31007/SECONDARY_SITE_ID": "2", "service/vmhdbqas01/31001/REPLICATION_STATUS": "ACTIVE", "service/vmhdbqas01/31003/REPLICATION_STATUS": "ACTIVE", "service/vmhdbqas01/31007/REPLICATION_STATUS": "ACTIVE", "service/vmhdbqas01/31001/SECONDARY_SITE_NAME": "WDF", "service/vmhdbqas01/31003/SECONDARY_SITE_NAME": "WDF", "service/vmhdbqas01/31007/SECONDARY_SITE_NAME": "WDF", "service/vmhdbqas01/31001/SHIPPED_LOG_POSITION": "45366976", "service/vmhdbqas01/31003/SHIPPED_LOG_POSITION": "247682688", "service/vmhdbqas01/31007/SHIPPED_LOG_POSITION": "4699712", "service/vmhdbqas01/31001/REPLAYED_LOG_POSITION": "45366976", "service/vmhdbqas01/31003/REPLAYED_LOG_POSITION": "247682688", "service/vmhdbqas01/31007/REPLAYED_LOG_POSITION": "4699652", "service/vmhdbqas01/31001/LAST_LOG_POSITION_TIME": "2022-01-17 20:51:57.259967", "service/vmhdbqas01/31001/LAST_SAVEPOINT_VERSION": "3060", "service/vmhdbqas01/31001/SECONDARY_CONNECT_TIME": "2022-01-11 12:30:25.128075", "service/vmhdbqas01/31003/LAST_LOG_POSITION_TIME": "2022-01-17 20:51:46.152250", "service/vmhdbqas01/31003/LAST_SAVEPOINT_VERSION": "2866", "service/vmhdbqas01/31003/SECONDARY_CONNECT_TIME": "2022-01-11 12:35:03.347379", "service/vmhdbqas01/31007/LAST_LOG_POSITION_TIME": "2022-01-17 20:51:44.353141", "service/vmhdbqas01/31007/LAST_SAVEPOINT_VERSION": "2887", "service/vmhdbqas01/31007/SECONDARY_CONNECT_TIME": "2022-01-11 12:35:03.226334", "service/vmhdbqas01/31001/SECONDARY_ACTIVE_STATUS": "YES", "service/vmhdbqas01/31003/SECONDARY_ACTIVE_STATUS": "YES", "service/vmhdbqas01/31007/SECONDARY_ACTIVE_STATUS": "YES", "service/vmhdbqas01/31001/SECONDARY_FAILOVER_COUNT": "0", "service/vmhdbqas01/31001/SHIPPED_LOG_BUFFERS_SIZE": "555925504", "service/vmhdbqas01/31003/SECONDARY_FAILOVER_COUNT": "0", "service/vmhdbqas01/31003/SHIPPED_LOG_BUFFERS_SIZE": "3534827520", "service/vmhdbqas01/31007/SECONDARY_FAILOVER_COUNT": "0", "service/vmhdbqas01/31007/SHIPPED_LOG_BUFFERS_SIZE": "269307904", "service/vmhdbqas01/31001/LAST_SAVEPOINT_START_TIME": "2022-01-17 20:47:57.248689", "service/vmhdbqas01/31001/SECONDARY_RECONNECT_COUNT": "0", "service/vmhdbqas01/31001/SHIPPED_FULL_REPLICA_SIZE": "0", "service/vmhdbqas01/31001/SHIPPED_LOG_BUFFERS_COUNT": "125862", "service/vmhdbqas01/31001/SHIPPED_LOG_POSITION_TIME": "2022-01-17 20:51:57.259967", "service/vmhdbqas01/31001/SHIPPED_SAVEPOINT_VERSION": "0", "service/vmhdbqas01/31003/LAST_SAVEPOINT_START_TIME": "2022-01-17 20:48:26.167454", "service/vmhdbqas01/31003/SECONDARY_RECONNECT_COUNT": "9", "service/vmhdbqas01/31003/SHIPPED_FULL_REPLICA_SIZE": "0", "service/vmhdbqas01/31003/SHIPPED_LOG_BUFFERS_COUNT": "684679", "service/vmhdbqas01/31003/SHIPPED_LOG_POSITION_TIME": "2022-01-17 20:51:46.152250", "service/vmhdbqas01/31003/SHIPPED_SAVEPOINT_VERSION": "0", "service/vmhdbqas01/31007/LAST_SAVEPOINT_START_TIME": "2022-01-17 20:51:44.329775", "service/vmhdbqas01/31007/SECONDARY_RECONNECT_COUNT": "9", "service/vmhdbqas01/31007/SHIPPED_FULL_REPLICA_SIZE": "0", "service/vmhdbqas01/31007/SHIPPED_LOG_BUFFERS_COUNT": "65749", "service/vmhdbqas01/31007/SHIPPED_LOG_POSITION_TIME": "2022-01-17 20:51:44.353141", "service/vmhdbqas01/31007/SHIPPED_SAVEPOINT_VERSION": "0", "service/vmhdbqas01/31001/REPLAYED_LOG_POSITION_TIME": "2022-01-17 20:51:57.259967", "service/vmhdbqas01/31001/REPLICATION_STATUS_DETAILS": "", "service/vmhdbqas01/31001/SHIPPED_DELTA_REPLICA_SIZE": "0", "service/vmhdbqas01/31001/SHIPPED_FULL_REPLICA_COUNT": "0", "service/vmhdbqas01/31003/REPLAYED_LOG_POSITION_TIME": "2022-01-17 20:51:46.152250", "service/vmhdbqas01/31003/REPLICATION_STATUS_DETAILS": "", "service/vmhdbqas01/31003/SHIPPED_DELTA_REPLICA_SIZE": "0", "service/vmhdbqas01/31003/SHIPPED_FULL_REPLICA_COUNT": "0", "service/vmhdbqas01/31007/REPLAYED_LOG_POSITION_TIME": "2022-01-17 20:51:44.353141", "service/vmhdbqas01/31007/REPLICATION_STATUS_DETAILS": "", "service/vmhdbqas01/31007/SHIPPED_DELTA_REPLICA_SIZE": "0", "service/vmhdbqas01/31007/SHIPPED_FULL_REPLICA_COUNT": "0", "service/vmhdbqas01/31001/LAST_SAVEPOINT_LOG_POSITION": "45363330", "service/vmhdbqas01/31001/SHIPPED_DELTA_REPLICA_COUNT": "0", "service/vmhdbqas01/31003/LAST_SAVEPOINT_LOG_POSITION": "247663426", "service/vmhdbqas01/31003/SHIPPED_DELTA_REPLICA_COUNT": "0", "service/vmhdbqas01/31007/LAST_SAVEPOINT_LOG_POSITION": "4699460", "service/vmhdbqas01/31007/SHIPPED_DELTA_REPLICA_COUNT": "0", "service/vmhdbqas01/31001/SHIPPED_LOG_BUFFERS_DURATION": "354670113", "service/vmhdbqas01/31001/SHIPPED_SAVEPOINT_START_TIME": "-", "service/vmhdbqas01/31003/SHIPPED_LOG_BUFFERS_DURATION": "1782503270", "service/vmhdbqas01/31003/SHIPPED_SAVEPOINT_START_TIME": "-", "service/vmhdbqas01/31007/SHIPPED_LOG_BUFFERS_DURATION": "176031371", "service/vmhdbqas01/31007/SHIPPED_SAVEPOINT_START_TIME": "-", "service/vmhdbqas01/31001/SHIPPED_FULL_REPLICA_DURATION": "0", "service/vmhdbqas01/31003/SHIPPED_FULL_REPLICA_DURATION": "0", "service/vmhdbqas01/31007/SHIPPED_FULL_REPLICA_DURATION": "0", "service/vmhdbqas01/31001/SHIPPED_DELTA_REPLICA_DURATION": "0", "service/vmhdbqas01/31001/SHIPPED_LAST_FULL_REPLICA_SIZE": "0", "service/vmhdbqas01/31001/SHIPPED_SAVEPOINT_LOG_POSITION": "0", "service/vmhdbqas01/31003/SHIPPED_DELTA_REPLICA_DURATION": "0", "service/vmhdbqas01/31003/SHIPPED_LAST_FULL_REPLICA_SIZE": "0", "service/vmhdbqas01/31003/SHIPPED_SAVEPOINT_LOG_POSITION": "0", "service/vmhdbqas01/31007/SHIPPED_DELTA_REPLICA_DURATION": "0", "service/vmhdbqas01/31007/SHIPPED_LAST_FULL_REPLICA_SIZE": "0", "service/vmhdbqas01/31007/SHIPPED_SAVEPOINT_LOG_POSITION": "0", "service/vmhdbqas01/31001/SHIPPED_LAST_DELTA_REPLICA_SIZE": "0", "service/vmhdbqas01/31003/SHIPPED_LAST_DELTA_REPLICA_SIZE": "0", "service/vmhdbqas01/31007/SHIPPED_LAST_DELTA_REPLICA_SIZE": "0", "service/vmhdbqas01/31001/SHIPPED_LAST_FULL_REPLICA_END_TIME": "-", "service/vmhdbqas01/31003/SHIPPED_LAST_FULL_REPLICA_END_TIME": "-", "service/vmhdbqas01/31007/SHIPPED_LAST_FULL_REPLICA_END_TIME": "-", "service/vmhdbqas01/31001/SHIPPED_LAST_DELTA_REPLICA_END_TIME": "-", "service/vmhdbqas01/31003/SHIPPED_LAST_DELTA_REPLICA_END_TIME": "-", "service/vmhdbqas01/31007/SHIPPED_LAST_DELTA_REPLICA_END_TIME": "-", "service/vmhdbqas01/31001/SHIPPED_LAST_FULL_REPLICA_START_TIME": "-", "service/vmhdbqas01/31003/SHIPPED_LAST_FULL_REPLICA_START_TIME": "-", "service/vmhdbqas01/31007/SHIPPED_LAST_FULL_REPLICA_START_TIME": "-", "service/vmhdbqas01/31001/SHIPPED_LAST_DELTA_REPLICA_START_TIME": "-", "service/vmhdbqas01/31003/SHIPPED_LAST_DELTA_REPLICA_START_TIME": "-", "service/vmhdbqas01/31007/SHIPPED_LAST_DELTA_REPLICA_START_TIME": "-"}}]}]	2024-04-09 15:07:09.890622	2024-04-09 15:07:09.890622
115	0fc07435-7ee2-54ca-b0de-fb27ffdc5deb	sap_system_discovery	[{"Id": "97a1e70aeff3c0685d65c4c3d32d533b", "SID": "NWP", "Type": 2, "Profile": {"SAPDBHOST": "10.80.1.13", "dbms/name": "HDP", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwpas", "rdisp/msserv": "sapmsNWP", "SAPGLOBALHOST": "sapnwpas", "SAPSYSTEMNAME": "NWP", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDP", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwpas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.80.1.13", "Databases": null, "Instances": [{"Host": "vmnwprd04", "Name": "D02", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwpas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwper", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwppas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwpaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 7759, "name": "gwrd", "starttime": "2022 01 11 13:46:05", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Gateway", "elapsedtime": "151:06:03"}, {"pid": 7760, "name": "icman", "starttime": "2022 01 11 13:46:05", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "ICM", "elapsedtime": "151:06:03"}, {"pid": 7741, "name": "igswd_mt", "starttime": "2022 01 11 13:46:03", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "IGS Watchdog", "elapsedtime": "151:06:05"}, {"pid": 7740, "name": "disp+work", "starttime": "2022 01 11 13:46:03", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Dispatcher", "elapsedtime": "151:06:05"}], "Properties": [{"value": "HTTP://sapnwpaas1:0/sap/admin/public/index.html", "property": "ICM", "propertytype": "NodeURL"}, {"value": "http://sapnwpaas1:40280", "property": "IGS", "propertytype": "NodeURL"}, {"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "ICMGetCacheEntries", "property": "ICM Cache", "propertytype": "NodeWebmethod"}, {"value": "02", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetThreadList", "property": "ICM Threads", "propertytype": "NodeWebmethod"}, {"value": "GetAlertTree", "property": "Open Alerts", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwpaas1", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "ABAPGetWPTable", "property": "ABAP WP Table", "propertytype": "NodeWebmethod"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "D02", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWP", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "GetAlertTree", "property": "Current Status", "propertytype": "NodeWebmethod"}, {"value": "GWGetClientList", "property": "Gateway Clients", "propertytype": "NodeWebmethod"}, {"value": "ICMGetConnectionList", "property": "ICM Connections", "propertytype": "NodeWebmethod"}, {"value": "GetQueueStatistic", "property": "Queue Statistic", "propertytype": "NodeWebmethod"}, {"value": "GWGetConnectionList", "property": "Gateway Connections", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetProxyConnectionList", "property": "ICM Proxy Connections", "propertytype": "NodeWebmethod"}, {"value": "http://sapnwpaas1:50213/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:07:10.267759	2024-04-09 15:07:10.267759
118	116d49bd-85e1-5e59-b820-83f66db8800c	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:10.660245	2024-04-09 15:07:10.660245
122	3711ea88-9ccc-5b07-8f9d-042be449d72b	ha_cluster_discovery	{"DC": false, "Id": "acf59e7a5338f76f55d5055af3273480", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmnwqas01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmnwqas02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "netweaver_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": null, "Groups": [{"Id": "grp_NWQ_ASCS00", "Primitives": [{"Id": "rsc_ip_NWQ_ASCS00", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWQ_ASCS00-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWQ_ASCS00-instance_attributes-ip", "Name": "ip", "Value": "10.90.1.25"}]}, {"Id": "rsc_fs_NWQ_ASCS00", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWQ_ASCS00-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWQ_ASCS00-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWQ_ASCS00-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWQ_ASCS00-instance_attributes-device", "Name": "device", "Value": "10.90.1.33:/NWQ/ASCS"}, {"Id": "rsc_fs_NWQ_ASCS00-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWQ/ASCS00"}, {"Id": "rsc_fs_NWQ_ASCS00-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWQ_ASCS00", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWQ_ASCS00-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWQ_ASCS00-meta_attributes-resource-stickiness", "Name": "resource-stickiness", "Value": "5000"}, {"Id": "rsc_sap_NWQ_ASCS00-meta_attributes-failure-timeout", "Name": "failure-timeout", "Value": "60"}, {"Id": "rsc_sap_NWQ_ASCS00-meta_attributes-migration-threshold", "Name": "migration-threshold", "Value": "1"}, {"Id": "rsc_sap_NWQ_ASCS00-meta_attributes-priority", "Name": "priority", "Value": "10"}], "InstanceAttributes": [{"Id": "rsc_sap_NWQ_ASCS00-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWQ_ASCS00_sapnwqas"}, {"Id": "rsc_sap_NWQ_ASCS00-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWQ/profile/NWQ_ASCS00_sapnwqas"}, {"Id": "rsc_sap_NWQ_ASCS00-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}]}, {"Id": "rsc_socat_NWQ_ASCS00", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWQ_ASCS00-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWQ_ASCS00-instance_attributes-port", "Name": "port", "Value": "62000"}]}]}, {"Id": "grp_NWQ_ERS10", "Primitives": [{"Id": "rsc_ip_NWQ_ERS10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWQ_ERS10-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWQ_ERS10-instance_attributes-ip", "Name": "ip", "Value": "10.90.1.26"}]}, {"Id": "rsc_fs_NWQ_ERS10", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWQ_ERS10-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWQ_ERS10-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWQ_ERS10-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWQ_ERS10-instance_attributes-device", "Name": "device", "Value": "10.90.1.33:/NWQ/ERS"}, {"Id": "rsc_fs_NWQ_ERS10-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWQ/ERS10"}, {"Id": "rsc_fs_NWQ_ERS10-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWQ_ERS10", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWQ_ERS10-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWQ_ERS10-meta_attributes-priority", "Name": "priority", "Value": "1000"}], "InstanceAttributes": [{"Id": "rsc_sap_NWQ_ERS10-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWQ_ERS10_sapnwqer"}, {"Id": "rsc_sap_NWQ_ERS10-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWQ/profile/NWQ_ERS10_sapnwqer"}, {"Id": "rsc_sap_NWQ_ERS10-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}, {"Id": "rsc_sap_NWQ_ERS10-instance_attributes-IS_ERS", "Name": "IS_ERS", "Value": "true"}]}, {"Id": "rsc_socat_NWQ_ERS10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWQ_ERS10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWQ_ERS10-instance_attributes-port", "Name": "port", "Value": "62110"}]}]}], "Masters": null, "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": [{"Id": "loc_sap_NWQ_failover_to_ers", "Node": "", "Role": "", "Score": "", "Resource": "rsc_sap_NWQ_ASCS00"}]}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_813ace38-2d4f-48f6-8aa2-5360252ca492", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "3365e35e-ba75-4d29-9f5a-1a0379ee7a60", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmnwqas01", "Status": "clear"}, {"Id": 1, "Name": "vmnwqas02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_813ace38-2d4f-48f6-8aa2-5360252ca492", "Status": "healthy"}]}, "Name": "netweaver_cluster", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmnwqas01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 5}, {"DC": false, "Id": "2", "Name": "vmnwqas02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 4}], "Clones": null, "Groups": [{"Id": "grp_NWQ_ASCS00", "Resources": [{"Id": "rsc_ip_NWQ_ASCS00", "Node": {"Id": "1", "Name": "vmnwqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWQ_ASCS00", "Node": {"Id": "1", "Name": "vmnwqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWQ_ASCS00", "Node": {"Id": "1", "Name": "vmnwqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWQ_ASCS00", "Node": {"Id": "1", "Name": "vmnwqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}, {"Id": "grp_NWQ_ERS10", "Resources": [{"Id": "rsc_ip_NWQ_ERS10", "Node": {"Id": "2", "Name": "vmnwqas02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWQ_ERS10", "Node": {"Id": "2", "Name": "vmnwqas02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWQ_ERS10", "Node": {"Id": "2", "Name": "vmnwqas02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWQ_ERS10", "Node": {"Id": "2", "Name": "vmnwqas02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Mon Jan 17 12:41:40 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmnwqas01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmnwqas02", "ResourceHistory": [{"Name": "rsc_sap_NWQ_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_ip_NWQ_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWQ_ERS10", "FailCount": 1, "MigrationThreshold": 3}, {"Name": "rsc_socat_NWQ_ERS10", "FailCount": 0, "MigrationThreshold": 3}]}, {"Name": "vmnwqas01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_ip_NWQ_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWQ_ASCS00", "FailCount": 1, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWQ_ASCS00", "FailCount": 0, "MigrationThreshold": 1}, {"Name": "rsc_socat_NWQ_ASCS00", "FailCount": 0, "MigrationThreshold": 3}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmnwqas02", "Attributes": [{"Name": "runs_ers_NWQ", "Value": "1"}]}]}}, "Provider": "azure"}	2024-04-09 15:07:11.193744	2024-04-09 15:07:11.193744
124	a09d9cf3-46c1-505c-8fb8-4b0a71a9114e	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmdrbdprd01", "plan": {}, "tags": "fake-tags", "vmId": "e9ba1f36-712a-4cbf-b279-b0801a4f6506", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmdrbdprd01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmdrbdprd01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmdrbdprd01-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Standard_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.31"}]}, "ipv6": {}, "macAddress": "000D3A257DF0"}]}}, "Provider": "azure"}	2024-04-09 15:07:11.460169	2024-04-09 15:07:11.460169
128	69f4dcbb-efa2-5a16-8bc8-01df7dbb7384	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:07:11.982611	2024-04-09 15:07:11.982611
50	a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwprd03", "plan": {}, "tags": "fake-tags", "vmId": "21d17480-4282-4e38-84aa-3e14716ebc42", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwprd03", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver03-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-netweaver01-App", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Attach", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.23"}, {"privateIpAddress": "10.80.1.27"}]}, "ipv6": {}, "macAddress": "000D3A257F83"}]}}, "Provider": "azure"}	2024-04-09 15:07:01.568071	2024-04-09 15:07:01.568071
56	e0c182db-32ff-55c6-a9eb-2b82dd21bc8b	ha_cluster_discovery	{"DC": false, "Id": "4e905d706da85f5be14f85fa947c1e39", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmhdbqas01", "InstanceAttributes": [{"Id": "nodes-1-lpa_hdq_lpt", "Name": "lpa_hdq_lpt", "Value": "1643125033"}, {"Id": "nodes-1-hana_hdq_vhost", "Name": "hana_hdq_vhost", "Value": "vmhdbqas01"}, {"Id": "nodes-1-hana_hdq_site", "Name": "hana_hdq_site", "Value": "NBG"}, {"Id": "nodes-1-hana_hdq_op_mode", "Name": "hana_hdq_op_mode", "Value": "logreplay"}, {"Id": "nodes-1-hana_hdq_srmode", "Name": "hana_hdq_srmode", "Value": "sync"}, {"Id": "nodes-1-hana_hdq_remoteHost", "Name": "hana_hdq_remoteHost", "Value": "vmhdbqas02"}]}, {"Id": "2", "Uname": "vmhdbqas02", "InstanceAttributes": [{"Id": "nodes-2-lpa_hdq_lpt", "Name": "lpa_hdq_lpt", "Value": "30"}, {"Id": "nodes-2-hana_hdq_op_mode", "Name": "hana_hdq_op_mode", "Value": "logreplay"}, {"Id": "nodes-2-hana_hdq_vhost", "Name": "hana_hdq_vhost", "Value": "vmhdbqas02"}, {"Id": "nodes-2-hana_hdq_remoteHost", "Name": "hana_hdq_remoteHost", "Value": "vmhdbqas01"}, {"Id": "nodes-2-hana_hdq_site", "Name": "hana_hdq_site", "Value": "WDF"}, {"Id": "nodes-2-hana_hdq_srmode", "Name": "hana_hdq_srmode", "Value": "sync"}]}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "hana_cluster_2"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}, {"Id": "SAPHanaSR-hana_hdq_site_srHook_WDF", "Name": "hana_hdq_site_srHook_WDF", "Value": "SOK"}]}, "Resources": {"Clones": [{"Id": "cln_SAPHanaTopology_HDQ_HDB10", "Primitive": {"Id": "rsc_SAPHanaTopology_HDQ_HDB10", "Type": "SAPHanaTopology", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHanaTopology_HDQ_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "600", "Interval": "10"}, {"Id": "rsc_SAPHanaTopology_HDQ_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "600", "Interval": "0"}, {"Id": "rsc_SAPHanaTopology_HDQ_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "300", "Interval": "0"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHanaTopology_HDQ_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDQ"}, {"Id": "rsc_SAPHanaTopology_HDQ_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}]}, "MetaAttributes": [{"Id": "cln_SAPHanaTopology_HDQ_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "cln_SAPHanaTopology_HDQ_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g_ip_HDQ_HDB10", "Primitives": [{"Id": "rsc_ip_HDQ_HDB10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_HDQ_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDQ_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDQ_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_HDQ_HDB10-instance_attributes-ip", "Name": "ip", "Value": "10.90.1.13"}, {"Id": "rsc_ip_HDQ_HDB10-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "24"}, {"Id": "rsc_ip_HDQ_HDB10-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "rsc_socat_HDQ_HDB10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_HDQ_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_HDQ_HDB10-instance_attributes-port", "Name": "port", "Value": "62510"}]}]}], "Masters": [{"Id": "msl_SAPHana_HDQ_HDB10", "Primitive": {"Id": "rsc_SAPHana_HDQ_HDB10", "Type": "SAPHana", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHana_HDQ_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDQ_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDQ_HDB10-promote-0", "Name": "promote", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDQ_HDB10-monitor-60", "Name": "monitor", "Role": "Master", "Timeout": "700", "Interval": "60"}, {"Id": "rsc_SAPHana_HDQ_HDB10-monitor-61", "Name": "monitor", "Role": "Slave", "Timeout": "700", "Interval": "61"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHana_HDQ_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDQ"}, {"Id": "rsc_SAPHana_HDQ_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}, {"Id": "rsc_SAPHana_HDQ_HDB10-instance_attributes-PREFER_SITE_TAKEOVER", "Name": "PREFER_SITE_TAKEOVER", "Value": "True"}, {"Id": "rsc_SAPHana_HDQ_HDB10-instance_attributes-AUTOMATED_REGISTER", "Name": "AUTOMATED_REGISTER", "Value": "False"}, {"Id": "rsc_SAPHana_HDQ_HDB10-instance_attributes-DUPLICATE_PRIMARY_TIMEOUT", "Name": "DUPLICATE_PRIMARY_TIMEOUT", "Value": "7200"}]}, "MetaAttributes": [{"Id": "msl_SAPHana_HDQ_HDB10-meta_attributes-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "msl_SAPHana_HDQ_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "msl_SAPHana_HDQ_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": [{"Id": "stonith-sbd-monitor-15", "Name": "monitor", "Role": "", "Timeout": "15", "Interval": "15"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "15"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-360014058d88c7795c6a4b66bc024f4bd", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "246da75b-af59-4135-b980-90bf87815e2e", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmhdbqas01", "Status": "clear"}, {"Id": 1, "Name": "vmhdbqas02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-360014058d88c7795c6a4b66bc024f4bd", "Status": "healthy"}]}, "Name": "hana_cluster_2", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmhdbqas01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 5}, {"DC": false, "Id": "2", "Name": "vmhdbqas02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}], "Clones": [{"Id": "msl_SAPHana_HDQ_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHana_HDQ_HDB10", "Node": {"Id": "1", "Name": "vmhdbqas01", "Cached": true}, "Role": "Master", "Agent": "ocf::suse:SAPHana", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHana_HDQ_HDB10", "Node": {"Id": "2", "Name": "vmhdbqas02", "Cached": true}, "Role": "Slave", "Agent": "ocf::suse:SAPHana", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": true, "FailureIgnored": false}, {"Id": "cln_SAPHanaTopology_HDQ_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHanaTopology_HDQ_HDB10", "Node": {"Id": "1", "Name": "vmhdbqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHanaTopology_HDQ_HDB10", "Node": {"Id": "2", "Name": "vmhdbqas02", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g_ip_HDQ_HDB10", "Resources": [{"Id": "rsc_ip_HDQ_HDB10", "Node": {"Id": "1", "Name": "vmhdbqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_HDQ_HDB10", "Node": {"Id": "1", "Name": "vmhdbqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 7, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 25 15:37:13 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmhdbqas01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmhdbqas01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_ip_HDQ_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_HDQ_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDQ_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHana_HDQ_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmhdbqas02", "ResourceHistory": [{"Name": "rsc_SAPHana_HDQ_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDQ_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmhdbqas01", "Attributes": [{"Name": "hana_hdq_clone_state", "Value": "PROMOTED"}, {"Name": "hana_hdq_op_mode", "Value": "logreplay"}, {"Name": "hana_hdq_remoteHost", "Value": "vmhdbqas02"}, {"Name": "hana_hdq_roles", "Value": "4:P:master1:master:worker:master"}, {"Name": "hana_hdq_site", "Value": "NBG"}, {"Name": "hana_hdq_srmode", "Value": "sync"}, {"Name": "hana_hdq_sync_state", "Value": "PRIM"}, {"Name": "hana_hdq_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdq_vhost", "Value": "vmhdbqas01"}, {"Name": "lpa_hdq_lpt", "Value": "1643125033"}, {"Name": "master-rsc_SAPHana_HDQ_HDB10", "Value": "150"}]}, {"Name": "vmhdbqas02", "Attributes": [{"Name": "hana_hdq_clone_state", "Value": "DEMOTED"}, {"Name": "hana_hdq_op_mode", "Value": "logreplay"}, {"Name": "hana_hdq_remoteHost", "Value": "vmhdbqas01"}, {"Name": "hana_hdq_roles", "Value": "4:S:master1:master:worker:master"}, {"Name": "hana_hdq_site", "Value": "WDF"}, {"Name": "hana_hdq_srmode", "Value": "sync"}, {"Name": "hana_hdq_sync_state", "Value": "SOK"}, {"Name": "hana_hdq_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdq_vhost", "Value": "vmhdbqas02"}, {"Name": "lpa_hdq_lpt", "Value": "30"}, {"Name": "master-rsc_SAPHana_HDQ_HDB10", "Value": "100"}]}]}}, "Provider": "azure"}	2024-04-09 15:07:02.382909	2024-04-09 15:07:02.382909
71	4b30a6af-4b52-5bda-bccb-f2248a12c992	host_discovery	{"hostname": "vmnwprd02", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.80.1.22", "10.80.1.26", "fe80::20d:3aff:fe2e:8038"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwprd02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:04.37073	2024-04-09 15:07:04.37073
74	13e8c25c-3180-5a9a-95c8-51ec38e50cfc	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmhdbdev01", "plan": {}, "tags": "fake-tags", "vmId": "a187496f-69bd-48fa-81a4-749e51f08b8b", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_E4s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmhdbdev01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmhdbdev01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmhdbdev01-Data01", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "1", "vhd": {"uri": ""}, "name": "disk-vmhdbdev01-Data02", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "2", "vhd": {"uri": ""}, "name": "disk-vmhdbdev01-Data03", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "3", "vhd": {"uri": ""}, "name": "disk-vmhdbdev01-Data04", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "4", "vhd": {"uri": ""}, "name": "disk-vmhdbdev01-Data05", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "5", "vhd": {"uri": ""}, "name": "disk-vmhdbdev01-Data06", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "6", "vhd": {"uri": ""}, "name": "disk-vmhdbdev01-Data07", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.100.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.100.1.11"}]}, "ipv6": {}, "macAddress": "6045BD8D9B69"}]}}, "Provider": "azure"}	2024-04-09 15:07:04.752434	2024-04-09 15:07:04.752434
79	69f4dcbb-efa2-5a16-8bc8-01df7dbb7384	host_discovery	{"hostname": "vmiscsi01", "cpu_count": 1, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.100.1.4", "fe80::20d:3aff:fe2a:aabe"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 3421, "fully_qualified_domain_name": "vmiscsi01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:05.414556	2024-04-09 15:07:05.414556
82	13e8c25c-3180-5a9a-95c8-51ec38e50cfc	sap_system_discovery	[{"Id": "fd44c254ccb14331e54015c720c7a1f2", "SID": "HDD", "Type": 1, "Profile": {"SAPGLOBALHOST": "vmhdbdev01", "SAPSYSTEMNAME": "HDD", "hdbConfigType": "DEFAULT", "ssl/ciphersuites": "135:PFS:HIGH::EC_P256:EC_HIGH", "HDB_LINKED_BINARIES": "yes", "HDB_SHARED_BINARIES": "yes"}, "Databases": [{"Host": "vmhdbdev01", "User": "", "Group": "", "Active": "yes", "UserId": "", "GroupId": "", "SqlPort": "31015", "Database": "HDD", "Container": ""}], "Instances": [{"Host": "vmhdbdev01", "Name": "HDB10", "Type": 1, "SAPControl": {"Instances": [{"features": "HDB|HDB_WORKER", "hostname": "vmhdbdev01", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.3"}], "Processes": [{"pid": 18862, "name": "hdbdaemon", "starttime": "2022 01 11 12:56:11", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Daemon", "elapsedtime": "151:55:49"}, {"pid": 20257, "name": "hdbxsengine", "starttime": "2022 01 11 12:56:29", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB XSEngine-HDD", "elapsedtime": "151:55:31"}, {"pid": 18893, "name": "hdbnameserver", "starttime": "2022 01 11 12:56:12", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Nameserver", "elapsedtime": "151:55:48"}, {"pid": 20254, "name": "hdbindexserver", "starttime": "2022 01 11 12:56:29", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Indexserver-HDD", "elapsedtime": "151:55:31"}, {"pid": 20161, "name": "hdbpreprocessor", "starttime": "2022 01 11 12:56:29", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Preprocessor", "elapsedtime": "151:55:31"}, {"pid": 20158, "name": "hdbcompileserver", "starttime": "2022 01 11 12:56:29", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Compileserver", "elapsedtime": "151:55:31"}, {"pid": 22620, "name": "hdbwebdispatcher", "starttime": "2022 01 11 12:56:58", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Web Dispatcher", "elapsedtime": "151:55:02"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "YES", "property": "DBServices", "propertytype": "Attribute"}, {"value": "worker", "property": "HANA Roles", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "vmhdbdev01", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "HDB10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "HDD", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://vmhdbdev01:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": {"mode": "primary", "online": "true", "site_id": "1", "isSource": "true", "site_name": "NBG", "isConsumer": "false", "hasConsumers": "true", "siteTier/NBG": "1", "siteTier/WDF": "2", "operation_mode": "primary", "siteMapping/NBG": "WDF", "isTakeoverActive": "false", "isPrimarySuspended": "false", "mapping/vmhdbdev01": ["WDF/vmhdbdev02", "NBG/vmhdbdev01"], "siteOperationMode/NBG": "primary", "siteOperationMode/WDF": "logreplay", "siteReplicationMode/NBG": "primary", "siteReplicationMode/WDF": "sync"}, "HostConfiguration": {"host": "vmhdbdev01", "hostActive": "yes", "hostStatus": "ok", "removeStatus": "", "failoverStatus": "", "hostActualRoles": "worker", "hostConfigRoles": "worker", "storagePartition": "1", "workerActualGroups": "default", "workerConfigGroups": "default", "failoverActualGroup": "default", "failoverConfigGroup": "default", "nameServerActualRole": "master", "nameServerConfigRole": "master 1", "indexServerActualRole": "master", "indexServerConfigRole": "worker", "storageActualPartition": "1", "storageConfigPartition": "1"}, "SystemReplication": {"local_site_id": "1", "site/1/SITE_NAME": "NBG", "site/2/SITE_NAME": "WDF", "site/2/SOURCE_SITE_ID": "1", "site/1/REPLICATION_MODE": "PRIMARY", "site/2/REPLICATION_MODE": "SYNC", "site/2/REPLICATION_STATUS": "ACTIVE", "overall_replication_status": "ACTIVE", "service/vmhdbdev01/31001/HOST": "vmhdbdev01", "service/vmhdbdev01/31001/PORT": "31001", "service/vmhdbdev01/31003/HOST": "vmhdbdev01", "service/vmhdbdev01/31003/PORT": "31003", "service/vmhdbdev01/31007/HOST": "vmhdbdev01", "service/vmhdbdev01/31007/PORT": "31007", "service/vmhdbdev01/31001/SITE_ID": "1", "service/vmhdbdev01/31003/SITE_ID": "1", "service/vmhdbdev01/31007/SITE_ID": "1", "service/vmhdbdev01/31001/DATABASE": "SYSTEMDB", "service/vmhdbdev01/31003/DATABASE": "HDD", "service/vmhdbdev01/31007/DATABASE": "HDD", "service/vmhdbdev01/31001/FULL_SYNC": "DISABLED", "service/vmhdbdev01/31001/SITE_NAME": "NBG", "service/vmhdbdev01/31001/VOLUME_ID": "1", "service/vmhdbdev01/31003/FULL_SYNC": "DISABLED", "service/vmhdbdev01/31003/SITE_NAME": "NBG", "service/vmhdbdev01/31003/VOLUME_ID": "3", "service/vmhdbdev01/31007/FULL_SYNC": "DISABLED", "service/vmhdbdev01/31007/SITE_NAME": "NBG", "service/vmhdbdev01/31007/VOLUME_ID": "2", "service/vmhdbdev01/31001/RESET_COUNT": "0", "service/vmhdbdev01/31003/RESET_COUNT": "0", "service/vmhdbdev01/31007/RESET_COUNT": "0", "service/vmhdbdev01/31001/SERVICE_NAME": "nameserver", "service/vmhdbdev01/31003/SERVICE_NAME": "indexserver", "service/vmhdbdev01/31007/SERVICE_NAME": "xsengine", "service/vmhdbdev01/31001/CREATION_TIME": "2022-01-11 12:56:29.020885", "service/vmhdbdev01/31003/CREATION_TIME": "2022-01-11 12:56:53.983097", "service/vmhdbdev01/31007/CREATION_TIME": "2022-01-11 12:56:58.348403", "service/vmhdbdev01/31001/OPERATION_MODE": "logreplay", "service/vmhdbdev01/31001/SECONDARY_HOST": "vmhdbdev02", "service/vmhdbdev01/31001/SECONDARY_PORT": "31001", "service/vmhdbdev01/31003/OPERATION_MODE": "logreplay", "service/vmhdbdev01/31003/SECONDARY_HOST": "vmhdbdev02", "service/vmhdbdev01/31003/SECONDARY_PORT": "31003", "service/vmhdbdev01/31007/OPERATION_MODE": "logreplay", "service/vmhdbdev01/31007/SECONDARY_HOST": "vmhdbdev02", "service/vmhdbdev01/31007/SECONDARY_PORT": "31007", "service/vmhdbdev01/31001/LAST_RESET_TIME": "2022-01-11 12:56:29.020885", "service/vmhdbdev01/31003/LAST_RESET_TIME": "2022-01-11 12:56:53.983097", "service/vmhdbdev01/31007/LAST_RESET_TIME": "2022-01-11 12:56:58.348403", "service/vmhdbdev01/31001/REPLICATION_MODE": "SYNC", "service/vmhdbdev01/31003/REPLICATION_MODE": "SYNC", "service/vmhdbdev01/31007/REPLICATION_MODE": "SYNC", "service/vmhdbdev01/31001/LAST_LOG_POSITION": "45295808", "service/vmhdbdev01/31001/SECONDARY_SITE_ID": "2", "service/vmhdbdev01/31003/LAST_LOG_POSITION": "247644160", "service/vmhdbdev01/31003/SECONDARY_SITE_ID": "2", "service/vmhdbdev01/31007/LAST_LOG_POSITION": "4670464", "service/vmhdbdev01/31007/SECONDARY_SITE_ID": "2", "service/vmhdbdev01/31001/REPLICATION_STATUS": "ACTIVE", "service/vmhdbdev01/31003/REPLICATION_STATUS": "ACTIVE", "service/vmhdbdev01/31007/REPLICATION_STATUS": "ACTIVE", "service/vmhdbdev01/31001/SECONDARY_SITE_NAME": "WDF", "service/vmhdbdev01/31003/SECONDARY_SITE_NAME": "WDF", "service/vmhdbdev01/31007/SECONDARY_SITE_NAME": "WDF", "service/vmhdbdev01/31001/SHIPPED_LOG_POSITION": "45295808", "service/vmhdbdev01/31003/SHIPPED_LOG_POSITION": "247644160", "service/vmhdbdev01/31007/SHIPPED_LOG_POSITION": "4670464", "service/vmhdbdev01/31001/REPLAYED_LOG_POSITION": "45295808", "service/vmhdbdev01/31003/REPLAYED_LOG_POSITION": "247644160", "service/vmhdbdev01/31007/REPLAYED_LOG_POSITION": "4670405", "service/vmhdbdev01/31001/LAST_LOG_POSITION_TIME": "2022-01-17 20:51:50.123508", "service/vmhdbdev01/31001/LAST_SAVEPOINT_VERSION": "2831", "service/vmhdbdev01/31001/SECONDARY_CONNECT_TIME": "2022-01-11 12:57:43.205984", "service/vmhdbdev01/31003/LAST_LOG_POSITION_TIME": "2022-01-17 20:51:54.241756", "service/vmhdbdev01/31003/LAST_SAVEPOINT_VERSION": "2790", "service/vmhdbdev01/31003/SECONDARY_CONNECT_TIME": "2022-01-11 13:01:20.044302", "service/vmhdbdev01/31007/LAST_LOG_POSITION_TIME": "2022-01-17 20:51:22.341237", "service/vmhdbdev01/31007/LAST_SAVEPOINT_VERSION": "2874", "service/vmhdbdev01/31007/SECONDARY_CONNECT_TIME": "2022-01-11 13:01:20.647048", "service/vmhdbdev01/31001/SECONDARY_ACTIVE_STATUS": "YES", "service/vmhdbdev01/31003/SECONDARY_ACTIVE_STATUS": "YES", "service/vmhdbdev01/31007/SECONDARY_ACTIVE_STATUS": "YES", "service/vmhdbdev01/31001/SECONDARY_FAILOVER_COUNT": "0", "service/vmhdbdev01/31001/SHIPPED_LOG_BUFFERS_SIZE": "555040768", "service/vmhdbdev01/31003/SECONDARY_FAILOVER_COUNT": "0", "service/vmhdbdev01/31003/SHIPPED_LOG_BUFFERS_SIZE": "3481903104", "service/vmhdbdev01/31007/SECONDARY_FAILOVER_COUNT": "0", "service/vmhdbdev01/31007/SHIPPED_LOG_BUFFERS_SIZE": "268271616", "service/vmhdbdev01/31001/LAST_SAVEPOINT_START_TIME": "2022-01-17 20:48:30.381133", "service/vmhdbdev01/31001/SECONDARY_RECONNECT_COUNT": "0", "service/vmhdbdev01/31001/SHIPPED_FULL_REPLICA_SIZE": "0", "service/vmhdbdev01/31001/SHIPPED_LOG_BUFFERS_COUNT": "125075", "service/vmhdbdev01/31001/SHIPPED_LOG_POSITION_TIME": "2022-01-17 20:51:50.123508", "service/vmhdbdev01/31001/SHIPPED_SAVEPOINT_VERSION": "0", "service/vmhdbdev01/31003/LAST_SAVEPOINT_START_TIME": "2022-01-17 20:49:47.741144", "service/vmhdbdev01/31003/SECONDARY_RECONNECT_COUNT": "7", "service/vmhdbdev01/31003/SHIPPED_FULL_REPLICA_SIZE": "0", "service/vmhdbdev01/31003/SHIPPED_LOG_BUFFERS_COUNT": "682002", "service/vmhdbdev01/31003/SHIPPED_LOG_POSITION_TIME": "2022-01-17 20:51:54.241756", "service/vmhdbdev01/31003/SHIPPED_SAVEPOINT_VERSION": "0", "service/vmhdbdev01/31007/LAST_SAVEPOINT_START_TIME": "2022-01-17 20:50:22.414771", "service/vmhdbdev01/31007/SECONDARY_RECONNECT_COUNT": "7", "service/vmhdbdev01/31007/SHIPPED_FULL_REPLICA_SIZE": "0", "service/vmhdbdev01/31007/SHIPPED_LOG_BUFFERS_COUNT": "65496", "service/vmhdbdev01/31007/SHIPPED_LOG_POSITION_TIME": "2022-01-17 20:51:22.341237", "service/vmhdbdev01/31007/SHIPPED_SAVEPOINT_VERSION": "0", "service/vmhdbdev01/31001/REPLAYED_LOG_POSITION_TIME": "2022-01-17 20:51:50.123508", "service/vmhdbdev01/31001/REPLICATION_STATUS_DETAILS": "", "service/vmhdbdev01/31001/SHIPPED_DELTA_REPLICA_SIZE": "0", "service/vmhdbdev01/31001/SHIPPED_FULL_REPLICA_COUNT": "0", "service/vmhdbdev01/31003/REPLAYED_LOG_POSITION_TIME": "2022-01-17 20:51:54.241756", "service/vmhdbdev01/31003/REPLICATION_STATUS_DETAILS": "", "service/vmhdbdev01/31003/SHIPPED_DELTA_REPLICA_SIZE": "0", "service/vmhdbdev01/31003/SHIPPED_FULL_REPLICA_COUNT": "0", "service/vmhdbdev01/31007/REPLAYED_LOG_POSITION_TIME": "2022-01-17 20:51:22.341237", "service/vmhdbdev01/31007/REPLICATION_STATUS_DETAILS": "", "service/vmhdbdev01/31007/SHIPPED_DELTA_REPLICA_SIZE": "0", "service/vmhdbdev01/31007/SHIPPED_FULL_REPLICA_COUNT": "0", "service/vmhdbdev01/31001/LAST_SAVEPOINT_LOG_POSITION": "45292482", "service/vmhdbdev01/31001/SHIPPED_DELTA_REPLICA_COUNT": "0", "service/vmhdbdev01/31003/LAST_SAVEPOINT_LOG_POSITION": "247637826", "service/vmhdbdev01/31003/SHIPPED_DELTA_REPLICA_COUNT": "0", "service/vmhdbdev01/31007/LAST_SAVEPOINT_LOG_POSITION": "4669955", "service/vmhdbdev01/31007/SHIPPED_DELTA_REPLICA_COUNT": "0", "service/vmhdbdev01/31001/SHIPPED_LOG_BUFFERS_DURATION": "332381033", "service/vmhdbdev01/31001/SHIPPED_SAVEPOINT_START_TIME": "-", "service/vmhdbdev01/31003/SHIPPED_LOG_BUFFERS_DURATION": "1761449260", "service/vmhdbdev01/31003/SHIPPED_SAVEPOINT_START_TIME": "-", "service/vmhdbdev01/31007/SHIPPED_LOG_BUFFERS_DURATION": "180172567", "service/vmhdbdev01/31007/SHIPPED_SAVEPOINT_START_TIME": "-", "service/vmhdbdev01/31001/SHIPPED_FULL_REPLICA_DURATION": "0", "service/vmhdbdev01/31003/SHIPPED_FULL_REPLICA_DURATION": "0", "service/vmhdbdev01/31007/SHIPPED_FULL_REPLICA_DURATION": "0", "service/vmhdbdev01/31001/SHIPPED_DELTA_REPLICA_DURATION": "0", "service/vmhdbdev01/31001/SHIPPED_LAST_FULL_REPLICA_SIZE": "0", "service/vmhdbdev01/31001/SHIPPED_SAVEPOINT_LOG_POSITION": "0", "service/vmhdbdev01/31003/SHIPPED_DELTA_REPLICA_DURATION": "0", "service/vmhdbdev01/31003/SHIPPED_LAST_FULL_REPLICA_SIZE": "0", "service/vmhdbdev01/31003/SHIPPED_SAVEPOINT_LOG_POSITION": "0", "service/vmhdbdev01/31007/SHIPPED_DELTA_REPLICA_DURATION": "0", "service/vmhdbdev01/31007/SHIPPED_LAST_FULL_REPLICA_SIZE": "0", "service/vmhdbdev01/31007/SHIPPED_SAVEPOINT_LOG_POSITION": "0", "service/vmhdbdev01/31001/SHIPPED_LAST_DELTA_REPLICA_SIZE": "0", "service/vmhdbdev01/31003/SHIPPED_LAST_DELTA_REPLICA_SIZE": "0", "service/vmhdbdev01/31007/SHIPPED_LAST_DELTA_REPLICA_SIZE": "0", "service/vmhdbdev01/31001/SHIPPED_LAST_FULL_REPLICA_END_TIME": "-", "service/vmhdbdev01/31003/SHIPPED_LAST_FULL_REPLICA_END_TIME": "-", "service/vmhdbdev01/31007/SHIPPED_LAST_FULL_REPLICA_END_TIME": "-", "service/vmhdbdev01/31001/SHIPPED_LAST_DELTA_REPLICA_END_TIME": "-", "service/vmhdbdev01/31003/SHIPPED_LAST_DELTA_REPLICA_END_TIME": "-", "service/vmhdbdev01/31007/SHIPPED_LAST_DELTA_REPLICA_END_TIME": "-", "service/vmhdbdev01/31001/SHIPPED_LAST_FULL_REPLICA_START_TIME": "-", "service/vmhdbdev01/31003/SHIPPED_LAST_FULL_REPLICA_START_TIME": "-", "service/vmhdbdev01/31007/SHIPPED_LAST_FULL_REPLICA_START_TIME": "-", "service/vmhdbdev01/31001/SHIPPED_LAST_DELTA_REPLICA_START_TIME": "-", "service/vmhdbdev01/31003/SHIPPED_LAST_DELTA_REPLICA_START_TIME": "-", "service/vmhdbdev01/31007/SHIPPED_LAST_DELTA_REPLICA_START_TIME": "-"}}]}]	2024-04-09 15:07:05.806244	2024-04-09 15:07:05.806244
88	9cd46919-5f19-59aa-993e-cf3736c71053	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:06.555721	2024-04-09 15:07:06.555721
97	0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:07:07.803043	2024-04-09 15:07:07.803043
101	927901fa-2c87-524e-b18c-3ef5187f504f	host_discovery	{"hostname": "vmdrbdprd02", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.80.1.32", "fe80::20d:3aff:fe2e:8b91"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmdrbdprd02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:08.41061	2024-04-09 15:07:08.41061
104	116d49bd-85e1-5e59-b820-83f66db8800c	ha_cluster_discovery	{"DC": true, "Id": "8bca366a6cb7816555538092a1ddd5aa", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmnwprd01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmnwprd02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "netweaver_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": null, "Groups": [{"Id": "grp_NWP_ASCS00", "Primitives": [{"Id": "rsc_ip_NWP_ASCS00", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWP_ASCS00-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWP_ASCS00-instance_attributes-ip", "Name": "ip", "Value": "10.80.1.25"}]}, {"Id": "rsc_fs_NWP_ASCS00", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWP_ASCS00-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWP_ASCS00-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWP_ASCS00-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWP_ASCS00-instance_attributes-device", "Name": "device", "Value": "10.80.1.33:/NWP/ASCS"}, {"Id": "rsc_fs_NWP_ASCS00-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWP/ASCS00"}, {"Id": "rsc_fs_NWP_ASCS00-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWP_ASCS00", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWP_ASCS00-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWP_ASCS00-meta_attributes-resource-stickiness", "Name": "resource-stickiness", "Value": "5000"}, {"Id": "rsc_sap_NWP_ASCS00-meta_attributes-failure-timeout", "Name": "failure-timeout", "Value": "60"}, {"Id": "rsc_sap_NWP_ASCS00-meta_attributes-migration-threshold", "Name": "migration-threshold", "Value": "1"}, {"Id": "rsc_sap_NWP_ASCS00-meta_attributes-priority", "Name": "priority", "Value": "10"}], "InstanceAttributes": [{"Id": "rsc_sap_NWP_ASCS00-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWP_ASCS00_sapnwpas"}, {"Id": "rsc_sap_NWP_ASCS00-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWP/profile/NWP_ASCS00_sapnwpas"}, {"Id": "rsc_sap_NWP_ASCS00-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}]}, {"Id": "rsc_socat_NWP_ASCS00", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWP_ASCS00-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWP_ASCS00-instance_attributes-port", "Name": "port", "Value": "62000"}]}]}, {"Id": "grp_NWP_ERS10", "Primitives": [{"Id": "rsc_ip_NWP_ERS10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWP_ERS10-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWP_ERS10-instance_attributes-ip", "Name": "ip", "Value": "10.80.1.26"}]}, {"Id": "rsc_fs_NWP_ERS10", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWP_ERS10-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWP_ERS10-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWP_ERS10-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWP_ERS10-instance_attributes-device", "Name": "device", "Value": "10.80.1.33:/NWP/ERS"}, {"Id": "rsc_fs_NWP_ERS10-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWP/ERS10"}, {"Id": "rsc_fs_NWP_ERS10-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWP_ERS10", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWP_ERS10-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWP_ERS10-meta_attributes-priority", "Name": "priority", "Value": "1000"}], "InstanceAttributes": [{"Id": "rsc_sap_NWP_ERS10-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWP_ERS10_sapnwper"}, {"Id": "rsc_sap_NWP_ERS10-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWP/profile/NWP_ERS10_sapnwper"}, {"Id": "rsc_sap_NWP_ERS10-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}, {"Id": "rsc_sap_NWP_ERS10-instance_attributes-IS_ERS", "Name": "IS_ERS", "Value": "true"}]}, {"Id": "rsc_socat_NWP_ERS10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWP_ERS10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWP_ERS10-instance_attributes-port", "Name": "port", "Value": "62110"}]}]}], "Masters": null, "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": [{"Id": "loc_sap_NWP_failover_to_ers", "Node": "", "Role": "", "Score": "", "Resource": "rsc_sap_NWP_ASCS00"}]}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_e34218cd-0d9a-4b21-b6d5-a313980baa82", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "e0c97fe2-f63a-4fd1-83df-9a736a03b49b", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmnwprd01", "Status": "clear"}, {"Id": 1, "Name": "vmnwprd02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_e34218cd-0d9a-4b21-b6d5-a313980baa82", "Status": "healthy"}]}, "Name": "netweaver_cluster", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmnwprd01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 5}, {"DC": false, "Id": "2", "Name": "vmnwprd02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 4}], "Clones": null, "Groups": [{"Id": "grp_NWP_ASCS00", "Resources": [{"Id": "rsc_ip_NWP_ASCS00", "Node": {"Id": "1", "Name": "vmnwprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWP_ASCS00", "Node": {"Id": "1", "Name": "vmnwprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWP_ASCS00", "Node": {"Id": "1", "Name": "vmnwprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWP_ASCS00", "Node": {"Id": "1", "Name": "vmnwprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}, {"Id": "grp_NWP_ERS10", "Resources": [{"Id": "rsc_ip_NWP_ERS10", "Node": {"Id": "2", "Name": "vmnwprd02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWP_ERS10", "Node": {"Id": "2", "Name": "vmnwprd02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWP_ERS10", "Node": {"Id": "2", "Name": "vmnwprd02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWP_ERS10", "Node": {"Id": "2", "Name": "vmnwprd02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 13:43:06 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmnwprd01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmnwprd01", "ResourceHistory": [{"Name": "rsc_ip_NWP_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_socat_NWP_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWP_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWP_ASCS00", "FailCount": 0, "MigrationThreshold": 1}]}, {"Name": "vmnwprd02", "ResourceHistory": [{"Name": "rsc_ip_NWP_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWP_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWP_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_socat_NWP_ERS10", "FailCount": 0, "MigrationThreshold": 3}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmnwprd02", "Attributes": [{"Name": "runs_ers_NWP", "Value": "1"}]}]}}, "Provider": "azure"}	2024-04-09 15:07:08.793989	2024-04-09 15:07:08.793989
106	3711ea88-9ccc-5b07-8f9d-042be449d72b	host_discovery	{"hostname": "vmnwqas02", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.90.1.22", "10.90.1.26", "fe80::6245:bdff:fe8d:6ef"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwqas02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:09.06494	2024-04-09 15:07:09.06494
283	13e8c25c-3180-5a9a-95c8-51ec38e50cfc	sap_system_discovery	[{"Id": "fd44c254ccb14331e54015c720c7a1f2", "SID": "HDD", "Type": 1, "Profile": {"SAPGLOBALHOST": "vmhdbdev01", "SAPSYSTEMNAME": "HDD", "hdbConfigType": "DEFAULT", "ssl/ciphersuites": "135:PFS:HIGH::EC_P256:EC_HIGH", "HDB_LINKED_BINARIES": "yes", "HDB_SHARED_BINARIES": "yes"}, "Databases": [{"Host": "vmhdbdev01", "User": "", "Group": "", "Active": "yes", "UserId": "", "GroupId": "", "SqlPort": "31015", "Database": "HDD", "Container": ""}], "Instances": [{"Host": "vmhdbdev01", "Name": "HDB10", "Type": 1, "SAPControl": {"Instances": [{"features": "HDB|HDB_WORKER", "hostname": "vmhdbdev01", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.3"}], "Processes": [{"pid": 18862, "name": "hdbdaemon", "starttime": "2022 01 11 12:56:11", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Daemon", "elapsedtime": "151:55:49"}, {"pid": 20257, "name": "hdbxsengine", "starttime": "2022 01 11 12:56:29", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB XSEngine-HDD", "elapsedtime": "151:55:31"}, {"pid": 18893, "name": "hdbnameserver", "starttime": "2022 01 11 12:56:12", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Nameserver", "elapsedtime": "151:55:48"}, {"pid": 20254, "name": "hdbindexserver", "starttime": "2022 01 11 12:56:29", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Indexserver-HDD", "elapsedtime": "151:55:31"}, {"pid": 20161, "name": "hdbpreprocessor", "starttime": "2022 01 11 12:56:29", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Preprocessor", "elapsedtime": "151:55:31"}, {"pid": 20158, "name": "hdbcompileserver", "starttime": "2022 01 11 12:56:29", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Compileserver", "elapsedtime": "151:55:31"}, {"pid": 22620, "name": "hdbwebdispatcher", "starttime": "2022 01 11 12:56:58", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Web Dispatcher", "elapsedtime": "151:55:02"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "YES", "property": "DBServices", "propertytype": "Attribute"}, {"value": "worker", "property": "HANA Roles", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "vmhdbdev01", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "HDB10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "HDD", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://vmhdbdev01:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": {"mode": "primary", "online": "true", "site_id": "1", "isSource": "true", "site_name": "NBG", "isConsumer": "false", "hasConsumers": "true", "siteTier/NBG": "1", "siteTier/WDF": "2", "operation_mode": "primary", "siteMapping/NBG": "WDF", "isTakeoverActive": "false", "isPrimarySuspended": "false", "mapping/vmhdbdev01": ["WDF/vmhdbdev02", "NBG/vmhdbdev01"], "siteOperationMode/NBG": "primary", "siteOperationMode/WDF": "logreplay", "siteReplicationMode/NBG": "primary", "siteReplicationMode/WDF": "sync"}, "HostConfiguration": {"host": "vmhdbdev01", "hostActive": "yes", "hostStatus": "ok", "removeStatus": "", "failoverStatus": "", "hostActualRoles": "worker", "hostConfigRoles": "worker", "storagePartition": "1", "workerActualGroups": "default", "workerConfigGroups": "default", "failoverActualGroup": "default", "failoverConfigGroup": "default", "nameServerActualRole": "master", "nameServerConfigRole": "master 1", "indexServerActualRole": "master", "indexServerConfigRole": "worker", "storageActualPartition": "1", "storageConfigPartition": "1"}, "SystemReplication": {"local_site_id": "1", "site/1/SITE_NAME": "NBG", "site/2/SITE_NAME": "WDF", "site/2/SOURCE_SITE_ID": "1", "site/1/REPLICATION_MODE": "PRIMARY", "site/2/REPLICATION_MODE": "SYNC", "site/2/REPLICATION_STATUS": "ACTIVE", "overall_replication_status": "ACTIVE", "service/vmhdbdev01/31001/HOST": "vmhdbdev01", "service/vmhdbdev01/31001/PORT": "31001", "service/vmhdbdev01/31003/HOST": "vmhdbdev01", "service/vmhdbdev01/31003/PORT": "31003", "service/vmhdbdev01/31007/HOST": "vmhdbdev01", "service/vmhdbdev01/31007/PORT": "31007", "service/vmhdbdev01/31001/SITE_ID": "1", "service/vmhdbdev01/31003/SITE_ID": "1", "service/vmhdbdev01/31007/SITE_ID": "1", "service/vmhdbdev01/31001/DATABASE": "SYSTEMDB", "service/vmhdbdev01/31003/DATABASE": "HDD", "service/vmhdbdev01/31007/DATABASE": "HDD", "service/vmhdbdev01/31001/FULL_SYNC": "DISABLED", "service/vmhdbdev01/31001/SITE_NAME": "NBG", "service/vmhdbdev01/31001/VOLUME_ID": "1", "service/vmhdbdev01/31003/FULL_SYNC": "DISABLED", "service/vmhdbdev01/31003/SITE_NAME": "NBG", "service/vmhdbdev01/31003/VOLUME_ID": "3", "service/vmhdbdev01/31007/FULL_SYNC": "DISABLED", "service/vmhdbdev01/31007/SITE_NAME": "NBG", "service/vmhdbdev01/31007/VOLUME_ID": "2", "service/vmhdbdev01/31001/RESET_COUNT": "0", "service/vmhdbdev01/31003/RESET_COUNT": "0", "service/vmhdbdev01/31007/RESET_COUNT": "0", "service/vmhdbdev01/31001/SERVICE_NAME": "nameserver", "service/vmhdbdev01/31003/SERVICE_NAME": "indexserver", "service/vmhdbdev01/31007/SERVICE_NAME": "xsengine", "service/vmhdbdev01/31001/CREATION_TIME": "2022-01-11 12:56:29.020885", "service/vmhdbdev01/31003/CREATION_TIME": "2022-01-11 12:56:53.983097", "service/vmhdbdev01/31007/CREATION_TIME": "2022-01-11 12:56:58.348403", "service/vmhdbdev01/31001/OPERATION_MODE": "logreplay", "service/vmhdbdev01/31001/SECONDARY_HOST": "vmhdbdev02", "service/vmhdbdev01/31001/SECONDARY_PORT": "31001", "service/vmhdbdev01/31003/OPERATION_MODE": "logreplay", "service/vmhdbdev01/31003/SECONDARY_HOST": "vmhdbdev02", "service/vmhdbdev01/31003/SECONDARY_PORT": "31003", "service/vmhdbdev01/31007/OPERATION_MODE": "logreplay", "service/vmhdbdev01/31007/SECONDARY_HOST": "vmhdbdev02", "service/vmhdbdev01/31007/SECONDARY_PORT": "31007", "service/vmhdbdev01/31001/LAST_RESET_TIME": "2022-01-11 12:56:29.020885", "service/vmhdbdev01/31003/LAST_RESET_TIME": "2022-01-11 12:56:53.983097", "service/vmhdbdev01/31007/LAST_RESET_TIME": "2022-01-11 12:56:58.348403", "service/vmhdbdev01/31001/REPLICATION_MODE": "SYNC", "service/vmhdbdev01/31003/REPLICATION_MODE": "SYNC", "service/vmhdbdev01/31007/REPLICATION_MODE": "SYNC", "service/vmhdbdev01/31001/LAST_LOG_POSITION": "45295808", "service/vmhdbdev01/31001/SECONDARY_SITE_ID": "2", "service/vmhdbdev01/31003/LAST_LOG_POSITION": "247644160", "service/vmhdbdev01/31003/SECONDARY_SITE_ID": "2", "service/vmhdbdev01/31007/LAST_LOG_POSITION": "4670464", "service/vmhdbdev01/31007/SECONDARY_SITE_ID": "2", "service/vmhdbdev01/31001/REPLICATION_STATUS": "ACTIVE", "service/vmhdbdev01/31003/REPLICATION_STATUS": "ACTIVE", "service/vmhdbdev01/31007/REPLICATION_STATUS": "ACTIVE", "service/vmhdbdev01/31001/SECONDARY_SITE_NAME": "WDF", "service/vmhdbdev01/31003/SECONDARY_SITE_NAME": "WDF", "service/vmhdbdev01/31007/SECONDARY_SITE_NAME": "WDF", "service/vmhdbdev01/31001/SHIPPED_LOG_POSITION": "45295808", "service/vmhdbdev01/31003/SHIPPED_LOG_POSITION": "247644160", "service/vmhdbdev01/31007/SHIPPED_LOG_POSITION": "4670464", "service/vmhdbdev01/31001/REPLAYED_LOG_POSITION": "45295808", "service/vmhdbdev01/31003/REPLAYED_LOG_POSITION": "247644160", "service/vmhdbdev01/31007/REPLAYED_LOG_POSITION": "4670405", "service/vmhdbdev01/31001/LAST_LOG_POSITION_TIME": "2022-01-17 20:51:50.123508", "service/vmhdbdev01/31001/LAST_SAVEPOINT_VERSION": "2831", "service/vmhdbdev01/31001/SECONDARY_CONNECT_TIME": "2022-01-11 12:57:43.205984", "service/vmhdbdev01/31003/LAST_LOG_POSITION_TIME": "2022-01-17 20:51:54.241756", "service/vmhdbdev01/31003/LAST_SAVEPOINT_VERSION": "2790", "service/vmhdbdev01/31003/SECONDARY_CONNECT_TIME": "2022-01-11 13:01:20.044302", "service/vmhdbdev01/31007/LAST_LOG_POSITION_TIME": "2022-01-17 20:51:22.341237", "service/vmhdbdev01/31007/LAST_SAVEPOINT_VERSION": "2874", "service/vmhdbdev01/31007/SECONDARY_CONNECT_TIME": "2022-01-11 13:01:20.647048", "service/vmhdbdev01/31001/SECONDARY_ACTIVE_STATUS": "YES", "service/vmhdbdev01/31003/SECONDARY_ACTIVE_STATUS": "YES", "service/vmhdbdev01/31007/SECONDARY_ACTIVE_STATUS": "YES", "service/vmhdbdev01/31001/SECONDARY_FAILOVER_COUNT": "0", "service/vmhdbdev01/31001/SHIPPED_LOG_BUFFERS_SIZE": "555040768", "service/vmhdbdev01/31003/SECONDARY_FAILOVER_COUNT": "0", "service/vmhdbdev01/31003/SHIPPED_LOG_BUFFERS_SIZE": "3481903104", "service/vmhdbdev01/31007/SECONDARY_FAILOVER_COUNT": "0", "service/vmhdbdev01/31007/SHIPPED_LOG_BUFFERS_SIZE": "268271616", "service/vmhdbdev01/31001/LAST_SAVEPOINT_START_TIME": "2022-01-17 20:48:30.381133", "service/vmhdbdev01/31001/SECONDARY_RECONNECT_COUNT": "0", "service/vmhdbdev01/31001/SHIPPED_FULL_REPLICA_SIZE": "0", "service/vmhdbdev01/31001/SHIPPED_LOG_BUFFERS_COUNT": "125075", "service/vmhdbdev01/31001/SHIPPED_LOG_POSITION_TIME": "2022-01-17 20:51:50.123508", "service/vmhdbdev01/31001/SHIPPED_SAVEPOINT_VERSION": "0", "service/vmhdbdev01/31003/LAST_SAVEPOINT_START_TIME": "2022-01-17 20:49:47.741144", "service/vmhdbdev01/31003/SECONDARY_RECONNECT_COUNT": "7", "service/vmhdbdev01/31003/SHIPPED_FULL_REPLICA_SIZE": "0", "service/vmhdbdev01/31003/SHIPPED_LOG_BUFFERS_COUNT": "682002", "service/vmhdbdev01/31003/SHIPPED_LOG_POSITION_TIME": "2022-01-17 20:51:54.241756", "service/vmhdbdev01/31003/SHIPPED_SAVEPOINT_VERSION": "0", "service/vmhdbdev01/31007/LAST_SAVEPOINT_START_TIME": "2022-01-17 20:50:22.414771", "service/vmhdbdev01/31007/SECONDARY_RECONNECT_COUNT": "7", "service/vmhdbdev01/31007/SHIPPED_FULL_REPLICA_SIZE": "0", "service/vmhdbdev01/31007/SHIPPED_LOG_BUFFERS_COUNT": "65496", "service/vmhdbdev01/31007/SHIPPED_LOG_POSITION_TIME": "2022-01-17 20:51:22.341237", "service/vmhdbdev01/31007/SHIPPED_SAVEPOINT_VERSION": "0", "service/vmhdbdev01/31001/REPLAYED_LOG_POSITION_TIME": "2022-01-17 20:51:50.123508", "service/vmhdbdev01/31001/REPLICATION_STATUS_DETAILS": "", "service/vmhdbdev01/31001/SHIPPED_DELTA_REPLICA_SIZE": "0", "service/vmhdbdev01/31001/SHIPPED_FULL_REPLICA_COUNT": "0", "service/vmhdbdev01/31003/REPLAYED_LOG_POSITION_TIME": "2022-01-17 20:51:54.241756", "service/vmhdbdev01/31003/REPLICATION_STATUS_DETAILS": "", "service/vmhdbdev01/31003/SHIPPED_DELTA_REPLICA_SIZE": "0", "service/vmhdbdev01/31003/SHIPPED_FULL_REPLICA_COUNT": "0", "service/vmhdbdev01/31007/REPLAYED_LOG_POSITION_TIME": "2022-01-17 20:51:22.341237", "service/vmhdbdev01/31007/REPLICATION_STATUS_DETAILS": "", "service/vmhdbdev01/31007/SHIPPED_DELTA_REPLICA_SIZE": "0", "service/vmhdbdev01/31007/SHIPPED_FULL_REPLICA_COUNT": "0", "service/vmhdbdev01/31001/LAST_SAVEPOINT_LOG_POSITION": "45292482", "service/vmhdbdev01/31001/SHIPPED_DELTA_REPLICA_COUNT": "0", "service/vmhdbdev01/31003/LAST_SAVEPOINT_LOG_POSITION": "247637826", "service/vmhdbdev01/31003/SHIPPED_DELTA_REPLICA_COUNT": "0", "service/vmhdbdev01/31007/LAST_SAVEPOINT_LOG_POSITION": "4669955", "service/vmhdbdev01/31007/SHIPPED_DELTA_REPLICA_COUNT": "0", "service/vmhdbdev01/31001/SHIPPED_LOG_BUFFERS_DURATION": "332381033", "service/vmhdbdev01/31001/SHIPPED_SAVEPOINT_START_TIME": "-", "service/vmhdbdev01/31003/SHIPPED_LOG_BUFFERS_DURATION": "1761449260", "service/vmhdbdev01/31003/SHIPPED_SAVEPOINT_START_TIME": "-", "service/vmhdbdev01/31007/SHIPPED_LOG_BUFFERS_DURATION": "180172567", "service/vmhdbdev01/31007/SHIPPED_SAVEPOINT_START_TIME": "-", "service/vmhdbdev01/31001/SHIPPED_FULL_REPLICA_DURATION": "0", "service/vmhdbdev01/31003/SHIPPED_FULL_REPLICA_DURATION": "0", "service/vmhdbdev01/31007/SHIPPED_FULL_REPLICA_DURATION": "0", "service/vmhdbdev01/31001/SHIPPED_DELTA_REPLICA_DURATION": "0", "service/vmhdbdev01/31001/SHIPPED_LAST_FULL_REPLICA_SIZE": "0", "service/vmhdbdev01/31001/SHIPPED_SAVEPOINT_LOG_POSITION": "0", "service/vmhdbdev01/31003/SHIPPED_DELTA_REPLICA_DURATION": "0", "service/vmhdbdev01/31003/SHIPPED_LAST_FULL_REPLICA_SIZE": "0", "service/vmhdbdev01/31003/SHIPPED_SAVEPOINT_LOG_POSITION": "0", "service/vmhdbdev01/31007/SHIPPED_DELTA_REPLICA_DURATION": "0", "service/vmhdbdev01/31007/SHIPPED_LAST_FULL_REPLICA_SIZE": "0", "service/vmhdbdev01/31007/SHIPPED_SAVEPOINT_LOG_POSITION": "0", "service/vmhdbdev01/31001/SHIPPED_LAST_DELTA_REPLICA_SIZE": "0", "service/vmhdbdev01/31003/SHIPPED_LAST_DELTA_REPLICA_SIZE": "0", "service/vmhdbdev01/31007/SHIPPED_LAST_DELTA_REPLICA_SIZE": "0", "service/vmhdbdev01/31001/SHIPPED_LAST_FULL_REPLICA_END_TIME": "-", "service/vmhdbdev01/31003/SHIPPED_LAST_FULL_REPLICA_END_TIME": "-", "service/vmhdbdev01/31007/SHIPPED_LAST_FULL_REPLICA_END_TIME": "-", "service/vmhdbdev01/31001/SHIPPED_LAST_DELTA_REPLICA_END_TIME": "-", "service/vmhdbdev01/31003/SHIPPED_LAST_DELTA_REPLICA_END_TIME": "-", "service/vmhdbdev01/31007/SHIPPED_LAST_DELTA_REPLICA_END_TIME": "-", "service/vmhdbdev01/31001/SHIPPED_LAST_FULL_REPLICA_START_TIME": "-", "service/vmhdbdev01/31003/SHIPPED_LAST_FULL_REPLICA_START_TIME": "-", "service/vmhdbdev01/31007/SHIPPED_LAST_FULL_REPLICA_START_TIME": "-", "service/vmhdbdev01/31001/SHIPPED_LAST_DELTA_REPLICA_START_TIME": "-", "service/vmhdbdev01/31003/SHIPPED_LAST_DELTA_REPLICA_START_TIME": "-", "service/vmhdbdev01/31007/SHIPPED_LAST_DELTA_REPLICA_START_TIME": "-"}}]}]	2024-04-09 15:08:27.026459	2024-04-09 15:08:27.026459
286	240f96b1-8d26-53b7-9e99-ffb0f2e735bf	sap_system_discovery	[]	2024-04-09 15:08:27.410952	2024-04-09 15:08:27.410952
291	f0c808b3-d869-5192-a944-20f66a6a8449	sap_system_discovery	[]	2024-04-09 15:08:28.070794	2024-04-09 15:08:28.070794
293	21de186a-e38f-5804-b643-7f4ef22fecfd	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:08:28.321058	2024-04-09 15:08:28.321058
294	a09d9cf3-46c1-505c-8fb8-4b0a71a9114e	host_discovery	{"hostname": "vmdrbdprd01", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.80.1.31", "10.80.1.33", "fe80::20d:3aff:fe25:7df0"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmdrbdprd01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:08:28.446513	2024-04-09 15:08:28.446513
61	a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:03.045068	2024-04-09 15:07:03.045068
66	e0c182db-32ff-55c6-a9eb-2b82dd21bc8b	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmhdbqas02", "plan": {}, "tags": "fake-tags", "vmId": "7b21fd90-d128-4e25-8812-2fef28f94839", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_E4s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmhdbqas02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmhdbqas02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmhdbqas02-Data01", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "1", "vhd": {"uri": ""}, "name": "disk-vmhdbqas02-Data02", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "2", "vhd": {"uri": ""}, "name": "disk-vmhdbqas02-Data03", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "3", "vhd": {"uri": ""}, "name": "disk-vmhdbqas02-Data04", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "4", "vhd": {"uri": ""}, "name": "disk-vmhdbqas02-Data05", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "5", "vhd": {"uri": ""}, "name": "disk-vmhdbqas02-Data06", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "6", "vhd": {"uri": ""}, "name": "disk-vmhdbqas02-Data07", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.90.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.90.1.12"}]}, "ipv6": {}, "macAddress": "6045BD8D08B3"}]}}, "Provider": "azure"}	2024-04-09 15:07:03.688594	2024-04-09 15:07:03.688594
67	422686d6-b2d1-5092-93e8-a744854f5085	host_discovery	{"hostname": "vmdrbdqas02", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.90.1.32", "fe80::6245:bdff:fe8d:523"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmdrbdqas02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:03.803173	2024-04-09 15:07:03.803173
70	13e8c25c-3180-5a9a-95c8-51ec38e50cfc	ha_cluster_discovery	{"DC": true, "Id": "04b8f8c21f9fd8991224478e8c4362f8", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmhdbdev01", "InstanceAttributes": [{"Id": "nodes-1-lpa_hdd_lpt", "Name": "lpa_hdd_lpt", "Value": "10"}, {"Id": "nodes-1-hana_hdd_vhost", "Name": "hana_hdd_vhost", "Value": "vmhdbdev01"}, {"Id": "nodes-1-hana_hdd_site", "Name": "hana_hdd_site", "Value": "NBG"}, {"Id": "nodes-1-hana_hdd_op_mode", "Name": "hana_hdd_op_mode", "Value": "logreplay"}, {"Id": "nodes-1-hana_hdd_srmode", "Name": "hana_hdd_srmode", "Value": "sync"}, {"Id": "nodes-1-hana_hdd_remoteHost", "Name": "hana_hdd_remoteHost", "Value": "vmhdbdev02"}]}, {"Id": "2", "Uname": "vmhdbdev02", "InstanceAttributes": [{"Id": "nodes-2-lpa_hdd_lpt", "Name": "lpa_hdd_lpt", "Value": "1643125026"}, {"Id": "nodes-2-hana_hdd_op_mode", "Name": "hana_hdd_op_mode", "Value": "logreplay"}, {"Id": "nodes-2-hana_hdd_vhost", "Name": "hana_hdd_vhost", "Value": "vmhdbdev02"}, {"Id": "nodes-2-hana_hdd_remoteHost", "Name": "hana_hdd_remoteHost", "Value": "vmhdbdev01"}, {"Id": "nodes-2-hana_hdd_site", "Name": "hana_hdd_site", "Value": "WDF"}, {"Id": "nodes-2-hana_hdd_srmode", "Name": "hana_hdd_srmode", "Value": "sync"}]}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "hana_cluster_1"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}, {"Id": "SAPHanaSR-hana_hdd_site_srHook_WDF", "Name": "hana_hdd_site_srHook_WDF", "Value": "PRIM"}]}, "Resources": {"Clones": [{"Id": "cln_SAPHanaTopology_HDD_HDB10", "Primitive": {"Id": "rsc_SAPHanaTopology_HDD_HDB10", "Type": "SAPHanaTopology", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHanaTopology_HDD_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "600", "Interval": "10"}, {"Id": "rsc_SAPHanaTopology_HDD_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "600", "Interval": "0"}, {"Id": "rsc_SAPHanaTopology_HDD_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "300", "Interval": "0"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHanaTopology_HDD_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDD"}, {"Id": "rsc_SAPHanaTopology_HDD_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}]}, "MetaAttributes": [{"Id": "cln_SAPHanaTopology_HDD_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "cln_SAPHanaTopology_HDD_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g_ip_HDD_HDB10", "Primitives": [{"Id": "rsc_ip_HDD_HDB10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_HDD_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDD_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDD_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_HDD_HDB10-instance_attributes-ip", "Name": "ip", "Value": "10.100.1.13"}, {"Id": "rsc_ip_HDD_HDB10-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "24"}, {"Id": "rsc_ip_HDD_HDB10-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "rsc_socat_HDD_HDB10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_HDD_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_HDD_HDB10-instance_attributes-port", "Name": "port", "Value": "62510"}]}]}], "Masters": [{"Id": "msl_SAPHana_HDD_HDB10", "Primitive": {"Id": "rsc_SAPHana_HDD_HDB10", "Type": "SAPHana", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHana_HDD_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDD_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDD_HDB10-promote-0", "Name": "promote", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDD_HDB10-monitor-60", "Name": "monitor", "Role": "Master", "Timeout": "700", "Interval": "60"}, {"Id": "rsc_SAPHana_HDD_HDB10-monitor-61", "Name": "monitor", "Role": "Slave", "Timeout": "700", "Interval": "61"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDD"}, {"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}, {"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-PREFER_SITE_TAKEOVER", "Name": "PREFER_SITE_TAKEOVER", "Value": "True"}, {"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-AUTOMATED_REGISTER", "Name": "AUTOMATED_REGISTER", "Value": "False"}, {"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-DUPLICATE_PRIMARY_TIMEOUT", "Name": "DUPLICATE_PRIMARY_TIMEOUT", "Value": "7200"}]}, "MetaAttributes": [{"Id": "msl_SAPHana_HDD_HDB10-meta_attributes-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "msl_SAPHana_HDD_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "msl_SAPHana_HDD_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": [{"Id": "stonith-sbd-monitor-15", "Name": "monitor", "Role": "", "Timeout": "15", "Interval": "15"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "15"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:182cb1b1-a815-4b82-b538-7a166b9bbb4a", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "cc39771e-ea2f-4fb1-8968-a6176aee3d0a", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmhdbdev01", "Status": "clear"}, {"Id": 1, "Name": "vmhdbdev02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:182cb1b1-a815-4b82-b538-7a166b9bbb4a", "Status": "healthy"}]}, "Name": "hana_cluster_1", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmhdbdev01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}, {"DC": false, "Id": "2", "Name": "vmhdbdev02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 4}], "Clones": [{"Id": "msl_SAPHana_HDD_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHana_HDD_HDB10", "Node": {"Id": "2", "Name": "vmhdbdev02", "Cached": true}, "Role": "Master", "Agent": "ocf::suse:SAPHana", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHana_HDD_HDB10", "Node": null, "Role": "Stopped", "Agent": "ocf::suse:SAPHana", "Active": false, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 0}], "MultiState": true, "FailureIgnored": false}, {"Id": "cln_SAPHanaTopology_HDD_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHanaTopology_HDD_HDB10", "Node": {"Id": "2", "Name": "vmhdbdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHanaTopology_HDD_HDB10", "Node": {"Id": "1", "Name": "vmhdbdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g_ip_HDD_HDB10", "Resources": [{"Id": "rsc_ip_HDD_HDB10", "Node": {"Id": "2", "Name": "vmhdbdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_HDD_HDB10", "Node": {"Id": "2", "Name": "vmhdbdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 7, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 25 15:37:06 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmhdbdev01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmhdbdev02", "ResourceHistory": [{"Name": "rsc_ip_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHana_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmhdbdev01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_ip_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHana_HDD_HDB10", "FailCount": 1000000, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmhdbdev01", "Attributes": [{"Name": "hana_hdd_clone_state", "Value": "UNDEFINED"}, {"Name": "hana_hdd_op_mode", "Value": "logreplay"}, {"Name": "hana_hdd_remoteHost", "Value": "vmhdbdev02"}, {"Name": "hana_hdd_roles", "Value": "1:P:master1::worker:"}, {"Name": "hana_hdd_site", "Value": "NBG"}, {"Name": "hana_hdd_srmode", "Value": "sync"}, {"Name": "hana_hdd_sync_state", "Value": "SFAIL"}, {"Name": "hana_hdd_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdd_vhost", "Value": "vmhdbdev01"}, {"Name": "lpa_hdd_lpt", "Value": "10"}, {"Name": "master-rsc_SAPHana_HDD_HDB10", "Value": "-9000"}]}, {"Name": "vmhdbdev02", "Attributes": [{"Name": "hana_hdd_clone_state", "Value": "PROMOTED"}, {"Name": "hana_hdd_op_mode", "Value": "logreplay"}, {"Name": "hana_hdd_remoteHost", "Value": "vmhdbdev01"}, {"Name": "hana_hdd_roles", "Value": "4:P:master1:master:worker:master"}, {"Name": "hana_hdd_site", "Value": "WDF"}, {"Name": "hana_hdd_srmode", "Value": "sync"}, {"Name": "hana_hdd_sync_state", "Value": "PRIM"}, {"Name": "hana_hdd_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdd_vhost", "Value": "vmhdbdev02"}, {"Name": "lpa_hdd_lpt", "Value": "1643125026"}, {"Name": "master-rsc_SAPHana_HDD_HDB10", "Value": "150"}]}]}}, "Provider": "azure"}	2024-04-09 15:07:04.202883	2024-04-09 15:07:04.202883
77	9cd46919-5f19-59aa-993e-cf3736c71053	ha_cluster_discovery	{"DC": true, "Id": "9c832998801e28cd70ad77380e82a5c0", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmhdbprd01", "InstanceAttributes": [{"Id": "nodes-1-lpa_hdp_lpt", "Name": "lpa_hdp_lpt", "Value": "1643125019"}, {"Id": "nodes-1-hana_hdp_vhost", "Name": "hana_hdp_vhost", "Value": "vmhdbprd01"}, {"Id": "nodes-1-hana_hdp_site", "Name": "hana_hdp_site", "Value": "NBG"}, {"Id": "nodes-1-hana_hdp_op_mode", "Name": "hana_hdp_op_mode", "Value": "logreplay"}, {"Id": "nodes-1-hana_hdp_srmode", "Name": "hana_hdp_srmode", "Value": "sync"}, {"Id": "nodes-1-hana_hdp_remoteHost", "Name": "hana_hdp_remoteHost", "Value": "vmhdbprd02"}]}, {"Id": "2", "Uname": "vmhdbprd02", "InstanceAttributes": [{"Id": "nodes-2-lpa_hdp_lpt", "Name": "lpa_hdp_lpt", "Value": "30"}, {"Id": "nodes-2-hana_hdp_op_mode", "Name": "hana_hdp_op_mode", "Value": "logreplay"}, {"Id": "nodes-2-hana_hdp_vhost", "Name": "hana_hdp_vhost", "Value": "vmhdbprd02"}, {"Id": "nodes-2-hana_hdp_remoteHost", "Name": "hana_hdp_remoteHost", "Value": "vmhdbprd01"}, {"Id": "nodes-2-hana_hdp_site", "Name": "hana_hdp_site", "Value": "WDF"}, {"Id": "nodes-2-hana_hdp_srmode", "Name": "hana_hdp_srmode", "Value": "sync"}]}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "hana_cluster_3"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "24"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}, {"Id": "SAPHanaSR-hana_hdp_site_srHook_WDF", "Name": "hana_hdp_site_srHook_WDF", "Value": "SOK"}]}, "Resources": {"Clones": [{"Id": "cln_SAPHanaTopology_HDP_HDB10", "Primitive": {"Id": "rsc_SAPHanaTopology_HDP_HDB10", "Type": "SAPHanaTopology", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHanaTopology_HDP_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "600", "Interval": "10"}, {"Id": "rsc_SAPHanaTopology_HDP_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "600", "Interval": "0"}, {"Id": "rsc_SAPHanaTopology_HDP_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "300", "Interval": "0"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHanaTopology_HDP_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDP"}, {"Id": "rsc_SAPHanaTopology_HDP_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}]}, "MetaAttributes": [{"Id": "cln_SAPHanaTopology_HDP_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "cln_SAPHanaTopology_HDP_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g_ip_HDP_HDB10", "Primitives": [{"Id": "rsc_ip_HDP_HDB10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_HDP_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDP_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDP_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_HDP_HDB10-instance_attributes-ip", "Name": "ip", "Value": "10.80.1.13"}, {"Id": "rsc_ip_HDP_HDB10-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "24"}, {"Id": "rsc_ip_HDP_HDB10-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "rsc_socat_HDP_HDB10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_HDP_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_HDP_HDB10-instance_attributes-port", "Name": "port", "Value": "62510"}]}]}], "Masters": [{"Id": "msl_SAPHana_HDP_HDB10", "Primitive": {"Id": "rsc_SAPHana_HDP_HDB10", "Type": "SAPHana", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHana_HDP_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDP_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDP_HDB10-promote-0", "Name": "promote", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDP_HDB10-monitor-60", "Name": "monitor", "Role": "Master", "Timeout": "700", "Interval": "60"}, {"Id": "rsc_SAPHana_HDP_HDB10-monitor-61", "Name": "monitor", "Role": "Slave", "Timeout": "700", "Interval": "61"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDP"}, {"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}, {"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-PREFER_SITE_TAKEOVER", "Name": "PREFER_SITE_TAKEOVER", "Value": "True"}, {"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-AUTOMATED_REGISTER", "Name": "AUTOMATED_REGISTER", "Value": "False"}, {"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-DUPLICATE_PRIMARY_TIMEOUT", "Name": "DUPLICATE_PRIMARY_TIMEOUT", "Value": "7200"}]}, "MetaAttributes": [{"Id": "msl_SAPHana_HDP_HDB10-meta_attributes-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "msl_SAPHana_HDP_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "msl_SAPHana_HDP_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": [{"Id": "stonith-sbd-monitor-15", "Name": "monitor", "Role": "", "Timeout": "15", "Interval": "15"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "15"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b924e77", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "a7a18c6b-7c8e-4bda-bb77-45e4b5dc8478", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmhdbprd01", "Status": "clear"}, {"Id": 1, "Name": "vmhdbprd02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b924e77", "Status": "healthy"}, {"Dump": {"Uuid": "a7a18c6b-7c8e-4bda-bb77-45e4b5dc8478", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmhdbprd01", "Status": "clear"}, {"Id": 1, "Name": "vmhdbprd02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b912345", "Status": "unhealthy"}, {"Dump": {"Uuid": "a7a18c6b-7c8e-4bda-bb77-45e4b5dc8478", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmhdbprd01", "Status": "clear"}, {"Id": 1, "Name": "vmhdbprd02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b954321", "Status": "unknown"}]}, "Name": "hana_cluster_3", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmhdbprd01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 5}, {"DC": false, "Id": "2", "Name": "vmhdbprd02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}], "Clones": [{"Id": "msl_SAPHana_HDP_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHana_HDP_HDB10", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Master", "Agent": "ocf::suse:SAPHana", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHana_HDP_HDB10", "Node": {"Id": "2", "Name": "vmhdbprd02", "Cached": true}, "Role": "Slave", "Agent": "ocf::suse:SAPHana", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": true, "FailureIgnored": false}, {"Id": "cln_SAPHanaTopology_HDP_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHanaTopology_HDP_HDB10", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHanaTopology_HDP_HDB10", "Node": {"Id": "2", "Name": "vmhdbprd02", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g_ip_HDP_HDB10", "Resources": [{"Id": "rsc_ip_HDP_HDB10", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_HDP_HDB10", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 7, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 25 15:36:59 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmhdbprd01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_ip_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHana_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmhdbprd02", "ResourceHistory": [{"Name": "rsc_SAPHana_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmhdbprd01", "Attributes": [{"Name": "hana_hdp_clone_state", "Value": "PROMOTED"}, {"Name": "hana_hdp_op_mode", "Value": "logreplay"}, {"Name": "hana_hdp_remoteHost", "Value": "vmhdbprd02"}, {"Name": "hana_hdp_roles", "Value": "4:P:master1:master:worker:master"}, {"Name": "hana_hdp_site", "Value": "NBG"}, {"Name": "hana_hdp_srmode", "Value": "sync"}, {"Name": "hana_hdp_sync_state", "Value": "PRIM"}, {"Name": "hana_hdp_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdp_vhost", "Value": "vmhdbprd01"}, {"Name": "lpa_hdp_lpt", "Value": "1643125019"}, {"Name": "master-rsc_SAPHana_HDP_HDB10", "Value": "150"}]}, {"Name": "vmhdbprd02", "Attributes": [{"Name": "hana_hdp_clone_state", "Value": "DEMOTED"}, {"Name": "hana_hdp_op_mode", "Value": "logreplay"}, {"Name": "hana_hdp_remoteHost", "Value": "vmhdbprd01"}, {"Name": "hana_hdp_roles", "Value": "4:S:master1:master:worker:master"}, {"Name": "hana_hdp_site", "Value": "WDF"}, {"Name": "hana_hdp_srmode", "Value": "sync"}, {"Name": "hana_hdp_sync_state", "Value": "SOK"}, {"Name": "hana_hdp_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdp_vhost", "Value": "vmhdbprd02"}, {"Name": "lpa_hdp_lpt", "Value": "30"}, {"Name": "master-rsc_SAPHana_HDP_HDB10", "Value": "100"}]}]}}, "Provider": "azure"}	2024-04-09 15:07:05.123315	2024-04-09 15:07:05.123315
83	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwdev02", "plan": {}, "tags": "fake-tags", "vmId": "84f224b2-ad29-41a7-94ae-26ced84cdace", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwdev02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.100.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.100.1.22"}]}, "ipv6": {}, "macAddress": "6045BD8D9C7D"}]}}, "Provider": "azure"}	2024-04-09 15:07:05.943453	2024-04-09 15:07:05.943453
84	0fc07435-7ee2-54ca-b0de-fb27ffdc5deb	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:06.067108	2024-04-09 15:07:06.067108
86	3711ea88-9ccc-5b07-8f9d-042be449d72b	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:07:06.307311	2024-04-09 15:07:06.307311
108	098fc159-3ed6-58e7-91be-38fda8a833ea	subscription_discovery	[{"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "SLES_SAP"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-ha"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:09.313286	2024-04-09 15:07:09.313286
114	422686d6-b2d1-5092-93e8-a744854f5085	sap_system_discovery	[]	2024-04-09 15:07:10.14754	2024-04-09 15:07:10.14754
116	f0c808b3-d869-5192-a944-20f66a6a8449	host_discovery	{"hostname": "vmiscsi01", "cpu_count": 1, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.90.1.4", "fe80::222:48ff:fe7f:d2f9"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 3422, "fully_qualified_domain_name": "vmiscsi01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:10.393237	2024-04-09 15:07:10.393237
80	25677e37-fd33-5005-896c-9275b1284534	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwqas01", "plan": {}, "tags": "fake-tags", "vmId": "2f1d001b-7ba0-49f3-afbd-c5668684a0a4", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwqas01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.90.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.90.1.21"}]}, "ipv6": {}, "macAddress": "6045BD8D0A30"}]}}, "Provider": "azure"}	2024-04-09 15:07:05.542155	2024-04-09 15:07:05.542155
81	69f4dcbb-efa2-5a16-8bc8-01df7dbb7384	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:05.657186	2024-04-09 15:07:05.657186
85	240f96b1-8d26-53b7-9e99-ffb0f2e735bf	sap_system_discovery	[]	2024-04-09 15:07:06.190788	2024-04-09 15:07:06.190788
89	3711ea88-9ccc-5b07-8f9d-042be449d72b	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwqas02", "plan": {}, "tags": "fake-tags", "vmId": "173ff22d-bb92-493a-a6b2-6a269614f178", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwqas02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.90.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.90.1.22"}]}, "ipv6": {}, "macAddress": "6045BD8D06EF"}]}}, "Provider": "azure"}	2024-04-09 15:07:06.695001	2024-04-09 15:07:06.695001
95	a09d9cf3-46c1-505c-8fb8-4b0a71a9114e	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:07.52426	2024-04-09 15:07:07.52426
102	99cf8a3a-48d6-57a4-b302-6e4482227ab6	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:08.536449	2024-04-09 15:07:08.536449
117	0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:10.518814	2024-04-09 15:07:10.518814
132	81e9b629-c1e7-538f-bff1-47d3a6580522	sap_system_discovery	[{"Id": "d01fdc69aeba7bd5133b210eb2884853", "SID": "NWQ", "Type": 2, "Profile": {"SAPDBHOST": "ha-cluster.suse.de", "dbms/name": "HDQ", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwqas", "rdisp/msserv": "sapmsNWQ", "SAPGLOBALHOST": "sapnwqas", "SAPSYSTEMNAME": "NWQ", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDQ", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwqas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.90.1.13", "Databases": null, "Instances": [{"Host": "vmnwqas04", "Name": "D02", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwqas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwqer", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwqpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwqaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 27154, "name": "gwrd", "starttime": "2022 01 17 12:42:20", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Gateway", "elapsedtime": "8:08:39"}, {"pid": 27155, "name": "icman", "starttime": "2022 01 17 12:42:20", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "ICM", "elapsedtime": "8:08:39"}, {"pid": 27150, "name": "igswd_mt", "starttime": "2022 01 17 12:42:19", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "IGS Watchdog", "elapsedtime": "8:08:40"}, {"pid": 27149, "name": "disp+work", "starttime": "2022 01 17 12:42:19", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Dispatcher", "elapsedtime": "8:08:40"}], "Properties": [{"value": "HTTP://sapnwqaas1:0/sap/admin/public/index.html", "property": "ICM", "propertytype": "NodeURL"}, {"value": "http://sapnwqaas1:40280", "property": "IGS", "propertytype": "NodeURL"}, {"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "ICMGetCacheEntries", "property": "ICM Cache", "propertytype": "NodeWebmethod"}, {"value": "02", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetThreadList", "property": "ICM Threads", "propertytype": "NodeWebmethod"}, {"value": "GetAlertTree", "property": "Open Alerts", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwqaas1", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "ABAPGetWPTable", "property": "ABAP WP Table", "propertytype": "NodeWebmethod"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "D02", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWQ", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "GetAlertTree", "property": "Current Status", "propertytype": "NodeWebmethod"}, {"value": "GWGetClientList", "property": "Gateway Clients", "propertytype": "NodeWebmethod"}, {"value": "ICMGetConnectionList", "property": "ICM Connections", "propertytype": "NodeWebmethod"}, {"value": "GetQueueStatistic", "property": "Queue Statistic", "propertytype": "NodeWebmethod"}, {"value": "GWGetConnectionList", "property": "Gateway Connections", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetProxyConnectionList", "property": "ICM Proxy Connections", "propertytype": "NodeWebmethod"}, {"value": "http://sapnwqaas1:50213/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:07:12.479674	2024-04-09 15:07:12.479674
87	69f4dcbb-efa2-5a16-8bc8-01df7dbb7384	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmiscsi01", "plan": {}, "tags": "fake-tags", "vmId": "458cb0ec-254e-4f68-873a-2d26e1e40c26", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_DS1_v2", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmiscsi01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-iscsisrv01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-iscsisrv01-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "StandardSSD_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.100.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.100.1.4"}]}, "ipv6": {}, "macAddress": "000D3A2AAABE"}]}}, "Provider": "azure"}	2024-04-09 15:07:06.423171	2024-04-09 15:07:06.423171
94	9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f	sap_system_discovery	[{"Id": "a1e80e3e152a903662f7882fb3f8a851", "SID": "NWD", "Type": 2, "Profile": {"SAPDBHOST": "10.100.1.13", "dbms/name": "HDD", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwdas", "rdisp/msserv": "sapmsNWD", "SAPGLOBALHOST": "sapnwdas", "SAPSYSTEMNAME": "NWD", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDD", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwdas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.100.1.13", "Databases": null, "Instances": [{"Host": "vmnwdev03", "Name": "D01", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwdas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwder", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 27224, "name": "gwrd", "starttime": "2022 01 11 13:03:58", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Gateway", "elapsedtime": "151:48:10"}, {"pid": 27225, "name": "icman", "starttime": "2022 01 11 13:03:58", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "ICM", "elapsedtime": "151:48:10"}, {"pid": 26907, "name": "igswd_mt", "starttime": "2022 01 11 13:03:55", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "IGS Watchdog", "elapsedtime": "151:48:13"}, {"pid": 26906, "name": "disp+work", "starttime": "2022 01 11 13:03:55", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Dispatcher", "elapsedtime": "151:48:13"}], "Properties": [{"value": "HTTP://sapnwdpas:0/sap/admin/public/index.html", "property": "ICM", "propertytype": "NodeURL"}, {"value": "http://sapnwdpas:40180", "property": "IGS", "propertytype": "NodeURL"}, {"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "ICMGetCacheEntries", "property": "ICM Cache", "propertytype": "NodeWebmethod"}, {"value": "01", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetThreadList", "property": "ICM Threads", "propertytype": "NodeWebmethod"}, {"value": "GetAlertTree", "property": "Open Alerts", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwdpas", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "ABAPGetWPTable", "property": "ABAP WP Table", "propertytype": "NodeWebmethod"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "D01", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWD", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "GetAlertTree", "property": "Current Status", "propertytype": "NodeWebmethod"}, {"value": "GWGetClientList", "property": "Gateway Clients", "propertytype": "NodeWebmethod"}, {"value": "ICMGetConnectionList", "property": "ICM Connections", "propertytype": "NodeWebmethod"}, {"value": "GetQueueStatistic", "property": "Queue Statistic", "propertytype": "NodeWebmethod"}, {"value": "GWGetConnectionList", "property": "Gateway Connections", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetProxyConnectionList", "property": "ICM Proxy Connections", "propertytype": "NodeWebmethod"}, {"value": "http://sapnwdpas:50113/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:07:07.331985	2024-04-09 15:07:07.331985
98	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:07.980441	2024-04-09 15:07:07.980441
105	422686d6-b2d1-5092-93e8-a744854f5085	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:07:08.927631	2024-04-09 15:07:08.927631
111	e0c182db-32ff-55c6-a9eb-2b82dd21bc8b	host_discovery	{"hostname": "vmhdbqas02", "cpu_count": 4, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.90.1.12", "fe80::6245:bdff:fe8d:8b3"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 32107, "fully_qualified_domain_name": "vmhdbqas02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:09.740213	2024-04-09 15:07:09.740213
126	0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4	sap_system_discovery	[{"Id": "fd44c254ccb14331e54015c720c7a1f2", "SID": "HDD", "Type": 1, "Profile": {"SAPGLOBALHOST": "vmhdbdev02", "SAPSYSTEMNAME": "HDD", "hdbConfigType": "DEFAULT", "ssl/ciphersuites": "135:PFS:HIGH::EC_P256:EC_HIGH", "HDB_LINKED_BINARIES": "yes", "HDB_SHARED_BINARIES": "yes"}, "Databases": [{"Host": "vmhdbdev02", "User": "", "Group": "", "Active": "yes", "UserId": "", "GroupId": "", "SqlPort": "31015", "Database": "HDD", "Container": ""}], "Instances": [{"Host": "vmhdbdev02", "Name": "HDB10", "Type": 1, "SAPControl": {"Instances": [{"features": "HDB|HDB_WORKER", "hostname": "vmhdbdev02", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.3"}], "Processes": [{"pid": 24133, "name": "hdbdaemon", "starttime": "2022 01 11 12:57:31", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Daemon", "elapsedtime": "151:54:31"}, {"pid": 24925, "name": "hdbxsengine", "starttime": "2022 01 11 12:57:45", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB XSEngine-HDD", "elapsedtime": "151:54:17"}, {"pid": 24153, "name": "hdbnameserver", "starttime": "2022 01 11 12:57:32", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Nameserver", "elapsedtime": "151:54:30"}, {"pid": 24916, "name": "hdbindexserver", "starttime": "2022 01 11 12:57:45", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Indexserver-HDD", "elapsedtime": "151:54:17"}, {"pid": 24822, "name": "hdbpreprocessor", "starttime": "2022 01 11 12:57:44", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Preprocessor", "elapsedtime": "151:54:18"}, {"pid": 24819, "name": "hdbcompileserver", "starttime": "2022 01 11 12:57:44", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Compileserver", "elapsedtime": "151:54:18"}, {"pid": 25653, "name": "hdbwebdispatcher", "starttime": "2022 01 11 12:57:53", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Web Dispatcher", "elapsedtime": "151:54:09"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "YES", "property": "DBServices", "propertytype": "Attribute"}, {"value": "worker", "property": "HANA Roles", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "vmhdbdev02", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "HDB10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "HDD", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://vmhdbdev02:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": {"mode": "sync", "online": "true", "site_id": "2", "isSource": "false", "site_name": "WDF", "isConsumer": "true", "replayMode": "auto", "hasConsumers": "false", "siteTier/NBG": "1", "siteTier/WDF": "2", "operation_mode": "logreplay", "primary_masters": "vmhdbdev01", "siteMapping/NBG": "WDF", "isTakeoverActive": "false", "isPrimarySuspended": "false", "mapping/vmhdbdev02": ["WDF/vmhdbdev02", "NBG/vmhdbdev01"], "active_primary_site": "1", "isTimetravelEnabled": "false", "siteOperationMode/NBG": "primary", "siteOperationMode/WDF": "logreplay", "siteReplicationMode/NBG": "primary", "siteReplicationMode/WDF": "sync"}, "HostConfiguration": {"host": "vmhdbdev02", "hostActive": "yes", "hostStatus": "ok", "removeStatus": "", "failoverStatus": "", "hostActualRoles": "worker", "hostConfigRoles": "worker", "storagePartition": "1", "workerActualGroups": "default", "workerConfigGroups": "default", "failoverActualGroup": "default", "failoverConfigGroup": "default", "nameServerActualRole": "master", "nameServerConfigRole": "master 1", "indexServerActualRole": "master", "indexServerConfigRole": "worker", "storageActualPartition": "1", "storageConfigPartition": "1"}, "SystemReplication": {"local_site_id": "2", "site/2/SITE_NAME": "WDF", "site/2/SOURCE_SITE_ID": "1", "site/2/PRIMARY_MASTERS": "vmhdbdev01", "site/2/REPLICATION_MODE": "SYNC"}}]}]	2024-04-09 15:07:11.703571	2024-04-09 15:07:11.703571
131	a09d9cf3-46c1-505c-8fb8-4b0a71a9114e	sap_system_discovery	[]	2024-04-09 15:07:12.363463	2024-04-09 15:07:12.363463
136	81e9b629-c1e7-538f-bff1-47d3a6580522	subscription_discovery	[{"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "SLES_SAP"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-ha"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:13.044792	2024-04-09 15:07:13.044792
137	0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmhdbdev02", "plan": {}, "tags": "fake-tags", "vmId": "90ec8d3d-71a6-42ac-83d7-abf93669c72d", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_E4s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmhdbdev02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmhdbdev02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmhdbdev02-Data01", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "1", "vhd": {"uri": ""}, "name": "disk-vmhdbdev02-Data02", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "2", "vhd": {"uri": ""}, "name": "disk-vmhdbdev02-Data03", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "3", "vhd": {"uri": ""}, "name": "disk-vmhdbdev02-Data04", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "4", "vhd": {"uri": ""}, "name": "disk-vmhdbdev02-Data05", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "5", "vhd": {"uri": ""}, "name": "disk-vmhdbdev02-Data06", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "6", "vhd": {"uri": ""}, "name": "disk-vmhdbdev02-Data07", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.100.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.100.1.12"}]}, "ipv6": {}, "macAddress": "6045BD8A5F6B"}]}}, "Provider": "azure"}	2024-04-09 15:07:13.162422	2024-04-09 15:07:13.162422
139	f0c808b3-d869-5192-a944-20f66a6a8449	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:07:13.412396	2024-04-09 15:07:13.412396
142	81e9b629-c1e7-538f-bff1-47d3a6580522	host_discovery	{"hostname": "vmnwqas04", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.90.1.28", "10.90.1.24", "fe80::6245:bdff:fe8d:dca"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwqas04.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:13.794489	2024-04-09 15:07:13.794489
447	0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4	host_discovery	{"hostname": "vmhdbdev02", "cpu_count": 4, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.100.1.12", "fe80::6245:bdff:fe8a:5f6b"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 32107, "fully_qualified_domain_name": "vmhdbdev02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:09:20.127409	2024-04-09 15:09:20.127409
448	69f4dcbb-efa2-5a16-8bc8-01df7dbb7384	host_discovery	{"hostname": "vmiscsi01", "cpu_count": 1, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.100.1.4", "fe80::20d:3aff:fe2a:aabe"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 3421, "fully_qualified_domain_name": "vmiscsi01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:09:20.254587	2024-04-09 15:09:20.254587
109	116d49bd-85e1-5e59-b820-83f66db8800c	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwprd01", "plan": {}, "tags": "fake-tags", "vmId": "63306bd8-a7f8-49ab-8156-5d4aa928fa7a", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwprd01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.21"}]}, "ipv6": {}, "macAddress": "000D3A2E8F04"}]}}, "Provider": "azure"}	2024-04-09 15:07:09.451945	2024-04-09 15:07:09.451945
113	b767b3e9-e802-587e-a442-541d093b86b9	host_discovery	{"hostname": "vmhdbprd02", "cpu_count": 4, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.80.1.12", "fe80::20d:3aff:fe21:f108"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 32107, "fully_qualified_domain_name": "vmhdbprd02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:10.020984	2024-04-09 15:07:10.020984
125	25677e37-fd33-5005-896c-9275b1284534	host_discovery	{"hostname": "vmnwqas01", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.90.1.21", "10.90.1.25", "fe80::6245:bdff:fe8d:a30"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwqas01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:11.584051	2024-04-09 15:07:11.584051
133	99cf8a3a-48d6-57a4-b302-6e4482227ab6	ha_cluster_discovery	{"DC": true, "Id": "4e905d706da85f5be14f85fa947c1e39", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmhdbqas01", "InstanceAttributes": [{"Id": "nodes-1-lpa_hdq_lpt", "Name": "lpa_hdq_lpt", "Value": "1643125033"}, {"Id": "nodes-1-hana_hdq_vhost", "Name": "hana_hdq_vhost", "Value": "vmhdbqas01"}, {"Id": "nodes-1-hana_hdq_site", "Name": "hana_hdq_site", "Value": "NBG"}, {"Id": "nodes-1-hana_hdq_op_mode", "Name": "hana_hdq_op_mode", "Value": "logreplay"}, {"Id": "nodes-1-hana_hdq_srmode", "Name": "hana_hdq_srmode", "Value": "sync"}, {"Id": "nodes-1-hana_hdq_remoteHost", "Name": "hana_hdq_remoteHost", "Value": "vmhdbqas02"}]}, {"Id": "2", "Uname": "vmhdbqas02", "InstanceAttributes": [{"Id": "nodes-2-lpa_hdq_lpt", "Name": "lpa_hdq_lpt", "Value": "30"}, {"Id": "nodes-2-hana_hdq_op_mode", "Name": "hana_hdq_op_mode", "Value": "logreplay"}, {"Id": "nodes-2-hana_hdq_vhost", "Name": "hana_hdq_vhost", "Value": "vmhdbqas02"}, {"Id": "nodes-2-hana_hdq_remoteHost", "Name": "hana_hdq_remoteHost", "Value": "vmhdbqas01"}, {"Id": "nodes-2-hana_hdq_site", "Name": "hana_hdq_site", "Value": "WDF"}, {"Id": "nodes-2-hana_hdq_srmode", "Name": "hana_hdq_srmode", "Value": "sync"}]}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "hana_cluster_2"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}, {"Id": "SAPHanaSR-hana_hdq_site_srHook_WDF", "Name": "hana_hdq_site_srHook_WDF", "Value": "SOK"}]}, "Resources": {"Clones": [{"Id": "cln_SAPHanaTopology_HDQ_HDB10", "Primitive": {"Id": "rsc_SAPHanaTopology_HDQ_HDB10", "Type": "SAPHanaTopology", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHanaTopology_HDQ_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "600", "Interval": "10"}, {"Id": "rsc_SAPHanaTopology_HDQ_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "600", "Interval": "0"}, {"Id": "rsc_SAPHanaTopology_HDQ_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "300", "Interval": "0"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHanaTopology_HDQ_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDQ"}, {"Id": "rsc_SAPHanaTopology_HDQ_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}]}, "MetaAttributes": [{"Id": "cln_SAPHanaTopology_HDQ_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "cln_SAPHanaTopology_HDQ_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g_ip_HDQ_HDB10", "Primitives": [{"Id": "rsc_ip_HDQ_HDB10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_HDQ_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDQ_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDQ_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_HDQ_HDB10-instance_attributes-ip", "Name": "ip", "Value": "10.90.1.13"}, {"Id": "rsc_ip_HDQ_HDB10-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "24"}, {"Id": "rsc_ip_HDQ_HDB10-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "rsc_socat_HDQ_HDB10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_HDQ_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_HDQ_HDB10-instance_attributes-port", "Name": "port", "Value": "62510"}]}]}], "Masters": [{"Id": "msl_SAPHana_HDQ_HDB10", "Primitive": {"Id": "rsc_SAPHana_HDQ_HDB10", "Type": "SAPHana", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHana_HDQ_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDQ_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDQ_HDB10-promote-0", "Name": "promote", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDQ_HDB10-monitor-60", "Name": "monitor", "Role": "Master", "Timeout": "700", "Interval": "60"}, {"Id": "rsc_SAPHana_HDQ_HDB10-monitor-61", "Name": "monitor", "Role": "Slave", "Timeout": "700", "Interval": "61"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHana_HDQ_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDQ"}, {"Id": "rsc_SAPHana_HDQ_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}, {"Id": "rsc_SAPHana_HDQ_HDB10-instance_attributes-PREFER_SITE_TAKEOVER", "Name": "PREFER_SITE_TAKEOVER", "Value": "True"}, {"Id": "rsc_SAPHana_HDQ_HDB10-instance_attributes-AUTOMATED_REGISTER", "Name": "AUTOMATED_REGISTER", "Value": "False"}, {"Id": "rsc_SAPHana_HDQ_HDB10-instance_attributes-DUPLICATE_PRIMARY_TIMEOUT", "Name": "DUPLICATE_PRIMARY_TIMEOUT", "Value": "7200"}]}, "MetaAttributes": [{"Id": "msl_SAPHana_HDQ_HDB10-meta_attributes-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "msl_SAPHana_HDQ_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "msl_SAPHana_HDQ_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": [{"Id": "stonith-sbd-monitor-15", "Name": "monitor", "Role": "", "Timeout": "15", "Interval": "15"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "15"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-360014058d88c7795c6a4b66bc024f4bd", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "246da75b-af59-4135-b980-90bf87815e2e", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmhdbqas01", "Status": "clear"}, {"Id": 1, "Name": "vmhdbqas02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-360014058d88c7795c6a4b66bc024f4bd", "Status": "healthy"}]}, "Name": "hana_cluster_2", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmhdbqas01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 5}, {"DC": false, "Id": "2", "Name": "vmhdbqas02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}], "Clones": [{"Id": "msl_SAPHana_HDQ_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHana_HDQ_HDB10", "Node": {"Id": "1", "Name": "vmhdbqas01", "Cached": true}, "Role": "Master", "Agent": "ocf::suse:SAPHana", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHana_HDQ_HDB10", "Node": {"Id": "2", "Name": "vmhdbqas02", "Cached": true}, "Role": "Slave", "Agent": "ocf::suse:SAPHana", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": true, "FailureIgnored": false}, {"Id": "cln_SAPHanaTopology_HDQ_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHanaTopology_HDQ_HDB10", "Node": {"Id": "1", "Name": "vmhdbqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHanaTopology_HDQ_HDB10", "Node": {"Id": "2", "Name": "vmhdbqas02", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g_ip_HDQ_HDB10", "Resources": [{"Id": "rsc_ip_HDQ_HDB10", "Node": {"Id": "1", "Name": "vmhdbqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_HDQ_HDB10", "Node": {"Id": "1", "Name": "vmhdbqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 7, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 25 15:37:13 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmhdbqas01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmhdbqas01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_ip_HDQ_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_HDQ_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDQ_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHana_HDQ_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmhdbqas02", "ResourceHistory": [{"Name": "rsc_SAPHana_HDQ_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDQ_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmhdbqas01", "Attributes": [{"Name": "hana_hdq_clone_state", "Value": "PROMOTED"}, {"Name": "hana_hdq_op_mode", "Value": "logreplay"}, {"Name": "hana_hdq_remoteHost", "Value": "vmhdbqas02"}, {"Name": "hana_hdq_roles", "Value": "4:P:master1:master:worker:master"}, {"Name": "hana_hdq_site", "Value": "NBG"}, {"Name": "hana_hdq_srmode", "Value": "sync"}, {"Name": "hana_hdq_sync_state", "Value": "PRIM"}, {"Name": "hana_hdq_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdq_vhost", "Value": "vmhdbqas01"}, {"Name": "lpa_hdq_lpt", "Value": "1643125033"}, {"Name": "master-rsc_SAPHana_HDQ_HDB10", "Value": "150"}]}, {"Name": "vmhdbqas02", "Attributes": [{"Name": "hana_hdq_clone_state", "Value": "DEMOTED"}, {"Name": "hana_hdq_op_mode", "Value": "logreplay"}, {"Name": "hana_hdq_remoteHost", "Value": "vmhdbqas01"}, {"Name": "hana_hdq_roles", "Value": "4:S:master1:master:worker:master"}, {"Name": "hana_hdq_site", "Value": "WDF"}, {"Name": "hana_hdq_srmode", "Value": "sync"}, {"Name": "hana_hdq_sync_state", "Value": "SOK"}, {"Name": "hana_hdq_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdq_vhost", "Value": "vmhdbqas02"}, {"Name": "lpa_hdq_lpt", "Value": "30"}, {"Name": "master-rsc_SAPHana_HDQ_HDB10", "Value": "100"}]}]}}, "Provider": "azure"}	2024-04-09 15:07:12.615131	2024-04-09 15:07:12.615131
143	9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwdev03", "plan": {}, "tags": "fake-tags", "vmId": "14173622-8d19-4e09-9661-2bfb236b01e4", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwdev03", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver03-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-netweaver01-App", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Attach", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.100.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.100.1.23"}, {"privateIpAddress": "10.100.1.27"}]}, "ipv6": {}, "macAddress": "6045BD8D9EF4"}]}}, "Provider": "azure"}	2024-04-09 15:07:13.938297	2024-04-09 15:07:13.938297
147	81e9b629-c1e7-538f-bff1-47d3a6580522	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:07:14.464464	2024-04-09 15:07:14.464464
151	7269ee51-5007-5849-aaa7-7c4a98b0c9ce	host_discovery	{"hostname": "vmnwdev01", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.100.1.21", "10.100.1.25", "fe80::6245:bdff:fe8a:5ce7"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwdev01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:15.058599	2024-04-09 15:07:15.058599
153	0fc07435-7ee2-54ca-b0de-fb27ffdc5deb	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwprd04", "plan": {}, "tags": "fake-tags", "vmId": "a7321bd7-c191-4650-b368-9c0b7bf04de6", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwprd04", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver04-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-netweaver02-App", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Attach", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.24"}, {"privateIpAddress": "10.80.1.28"}]}, "ipv6": {}, "macAddress": "000D3A2E8FAD"}]}}, "Provider": "azure"}	2024-04-09 15:07:15.338793	2024-04-09 15:07:15.338793
184	7269ee51-5007-5849-aaa7-7c4a98b0c9ce	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:19.831496	2024-04-09 15:07:19.831496
191	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:07:20.899449	2024-04-09 15:07:20.899449
120	7269ee51-5007-5849-aaa7-7c4a98b0c9ce	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwdev01", "plan": {}, "tags": "fake-tags", "vmId": "84e20bce-76e8-4d55-bdea-7ec3faff60f2", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwdev01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.100.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.100.1.21"}]}, "ipv6": {}, "macAddress": "6045BD8A5CE7"}]}}, "Provider": "azure"}	2024-04-09 15:07:10.933789	2024-04-09 15:07:10.933789
121	13e8c25c-3180-5a9a-95c8-51ec38e50cfc	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:11.065097	2024-04-09 15:07:11.065097
123	a09d9cf3-46c1-505c-8fb8-4b0a71a9114e	ha_cluster_discovery	{"DC": false, "Id": "238a4de1239aae2aa87433eed788b3ad", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmdrbdprd01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmdrbdprd02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "drbd_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": [{"Id": "cl-nfsserver", "Primitive": {"Id": "nfsserver", "Type": "nfs-server", "Class": "systemd", "Provider": "", "Operations": [{"Id": "nfsserver-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": null}, "MetaAttributes": [{"Id": "cl-nfsserver-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g-nfs_sapdata", "Primitives": [{"Id": "fs_sapdata", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "fs_sapdata-monitor-20", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "fs_sapdata-instance_attributes-device", "Name": "device", "Value": "/dev/drbd1"}, {"Id": "fs_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWP"}, {"Id": "fs_sapdata-instance_attributes-fstype", "Name": "fstype", "Value": "xfs"}, {"Id": "fs_sapdata-instance_attributes-options", "Name": "options", "Value": "noatime,nodiratime"}]}, {"Id": "vip_sapdata_nfs", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "vip_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "vip_sapdata_nfs-instance_attributes-ip", "Name": "ip", "Value": "10.80.1.33"}, {"Id": "vip_sapdata_nfs-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "32"}, {"Id": "vip_sapdata_nfs-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "exportfs_work_sapdata", "Type": "exportfs", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "exportfs_work_sapdata-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "exportfs_work_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWP"}, {"Id": "exportfs_work_sapdata-instance_attributes-fsid", "Name": "fsid", "Value": "1"}, {"Id": "exportfs_work_sapdata-instance_attributes-options", "Name": "options", "Value": "rw,no_root_squash"}, {"Id": "exportfs_work_sapdata-instance_attributes-clientspec", "Name": "clientspec", "Value": "*"}, {"Id": "exportfs_work_sapdata-instance_attributes-wait_for_leasetime_on_stop", "Name": "wait_for_leasetime_on_stop", "Value": "true"}]}, {"Id": "rsc_socat_sapdata_nfs", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_sapdata_nfs-instance_attributes-port", "Name": "port", "Value": "61000"}]}]}], "Masters": [{"Id": "ms_sapdata", "Primitive": {"Id": "drbd-sapdata", "Type": "drbd", "Class": "ocf", "Provider": "linbit", "Operations": [{"Id": "drbd-sapdata-monitor-15", "Name": "monitor", "Role": "Master", "Timeout": "", "Interval": "15"}, {"Id": "drbd-sapdata-monitor-30", "Name": "monitor", "Role": "Slave", "Timeout": "", "Interval": "30"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "drbd-sapdata-instance_attributes-drbd_resource", "Name": "drbd_resource", "Value": "sapdata"}]}, "MetaAttributes": [{"Id": "ms_sapdata-meta_attributes-master-max", "Name": "master-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-master-node-max", "Name": "master-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-0-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "ms_sapdata-meta_attributes-0-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-1-notify", "Name": "notify", "Value": "true"}, {"Id": "ms_sapdata-meta_attributes-1-target-role", "Name": "target-role", "Value": "Started"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_b7b1cd3d-776e-4432-a9e5-6fe56e4b4e17", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "28fd9d5e-3685-4cb7-85e9-76c4b140ea3c", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmdrbdprd01", "Status": "clear"}, {"Id": 1, "Name": "vmdrbdprd02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_b7b1cd3d-776e-4432-a9e5-6fe56e4b4e17", "Status": "healthy"}]}, "Name": "drbd_cluster", "Crmmon": {"Nodes": [{"DC": false, "Id": "1", "Name": "vmdrbdprd01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 7}, {"DC": true, "Id": "2", "Name": "vmdrbdprd02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}], "Clones": [{"Id": "ms_sapdata", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "drbd-sapdata", "Node": {"Id": "2", "Name": "vmdrbdprd02", "Cached": true}, "Role": "Slave", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "drbd-sapdata", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Master", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": true, "FailureIgnored": false}, {"Id": "cl-nfsserver", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "nfsserver", "Node": {"Id": "2", "Name": "vmdrbdprd02", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "nfsserver", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g-nfs_sapdata", "Resources": [{"Id": "fs_sapdata", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "vip_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "exportfs_work_sapdata", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:exportfs", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 13:24:06 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmdrbdprd02", "ResourceHistory": [{"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmdrbdprd01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "fs_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "vip_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "exportfs_work_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmdrbdprd01", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}, {"Name": "vmdrbdprd02", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}]}}, "Provider": "azure"}	2024-04-09 15:07:11.326729	2024-04-09 15:07:11.326729
127	240f96b1-8d26-53b7-9e99-ffb0f2e735bf	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:11.845494	2024-04-09 15:07:11.845494
130	9a26b6d0-6e72-597c-9fe5-152a6875f214	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:07:12.23671	2024-04-09 15:07:12.23671
134	9a26b6d0-6e72-597c-9fe5-152a6875f214	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmiscsi01", "plan": {}, "tags": "fake-tags", "vmId": "f57047ca-95a3-473a-8294-079c5173576a", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_DS1_v2", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmiscsi01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-iscsisrv01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-iscsisrv01-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "StandardSSD_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.4"}]}, "ipv6": {}, "macAddress": "000D3A2E835A"}]}}, "Provider": "azure"}	2024-04-09 15:07:12.768465	2024-04-09 15:07:12.768465
138	0fc07435-7ee2-54ca-b0de-fb27ffdc5deb	host_discovery	{"hostname": "vmnwprd04", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.80.1.24", "10.80.1.28", "fe80::20d:3aff:fe2e:8fad"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwprd04.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:13.289232	2024-04-09 15:07:13.289232
145	9a26b6d0-6e72-597c-9fe5-152a6875f214	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:14.201125	2024-04-09 15:07:14.201125
508	f0c808b3-d869-5192-a944-20f66a6a8449	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:09:28.264642	2024-04-09 15:09:28.264642
516	81e9b629-c1e7-538f-bff1-47d3a6580522	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:09:29.314067	2024-04-09 15:09:29.314067
135	9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:12.912998	2024-04-09 15:07:12.912998
164	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	sap_system_discovery	[{"Id": "a1e80e3e152a903662f7882fb3f8a851", "SID": "NWD", "Type": 2, "Profile": {"SAPDBHOST": "10.100.1.13", "dbms/name": "HDD", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwdas", "rdisp/msserv": "sapmsNWD", "SAPGLOBALHOST": "sapnwdas", "SAPSYSTEMNAME": "NWD", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDD", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwdas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.100.1.13", "Databases": null, "Instances": [{"Host": "vmnwdev02", "Name": "ERS10", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwdas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwder", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 6720, "name": "enrepserver", "starttime": "2022 01 11 12:55:17", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "EnqueueReplicator", "elapsedtime": "151:56:49"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwder", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "ERS10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWD", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.5", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://sapnwder:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:07:16.869932	2024-04-09 15:07:16.869932
165	e0c182db-32ff-55c6-a9eb-2b82dd21bc8b	sap_system_discovery	[{"Id": "9953878f07bb54cac20d5d5d7ff08af2", "SID": "HDQ", "Type": 1, "Profile": {"SAPGLOBALHOST": "vmhdbqas02", "SAPSYSTEMNAME": "HDQ", "hdbConfigType": "DEFAULT", "ssl/ciphersuites": "135:PFS:HIGH::EC_P256:EC_HIGH", "HDB_LINKED_BINARIES": "yes", "HDB_SHARED_BINARIES": "yes"}, "Databases": [{"Host": "vmhdbqas02", "User": "", "Group": "", "Active": "yes", "UserId": "", "GroupId": "", "SqlPort": "31015", "Database": "HDQ", "Container": ""}], "Instances": [{"Host": "vmhdbqas02", "Name": "HDB10", "Type": 1, "SAPControl": {"Instances": [{"features": "HDB|HDB_WORKER", "hostname": "vmhdbqas02", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.3"}], "Processes": [{"pid": 29597, "name": "hdbdaemon", "starttime": "2022 01 11 12:30:14", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Daemon", "elapsedtime": "152:21:46"}, {"pid": 30148, "name": "hdbxsengine", "starttime": "2022 01 11 12:30:27", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB XSEngine-HDQ", "elapsedtime": "152:21:33"}, {"pid": 29727, "name": "hdbnameserver", "starttime": "2022 01 11 12:30:14", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Nameserver", "elapsedtime": "152:21:46"}, {"pid": 30145, "name": "hdbindexserver", "starttime": "2022 01 11 12:30:27", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Indexserver-HDQ", "elapsedtime": "152:21:33"}, {"pid": 30047, "name": "hdbpreprocessor", "starttime": "2022 01 11 12:30:26", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Preprocessor", "elapsedtime": "152:21:34"}, {"pid": 30044, "name": "hdbcompileserver", "starttime": "2022 01 11 12:30:26", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Compileserver", "elapsedtime": "152:21:34"}, {"pid": 30855, "name": "hdbwebdispatcher", "starttime": "2022 01 11 12:30:35", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Web Dispatcher", "elapsedtime": "152:21:25"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "YES", "property": "DBServices", "propertytype": "Attribute"}, {"value": "worker", "property": "HANA Roles", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "vmhdbqas02", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "HDB10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "HDQ", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://vmhdbqas02:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": {"mode": "sync", "online": "true", "site_id": "2", "isSource": "false", "site_name": "WDF", "isConsumer": "true", "replayMode": "auto", "hasConsumers": "false", "siteTier/NBG": "1", "siteTier/WDF": "2", "operation_mode": "logreplay", "primary_masters": "vmhdbqas01", "siteMapping/NBG": "WDF", "isTakeoverActive": "false", "isPrimarySuspended": "false", "mapping/vmhdbqas02": ["WDF/vmhdbqas02", "NBG/vmhdbqas01"], "active_primary_site": "1", "isTimetravelEnabled": "false", "siteOperationMode/NBG": "primary", "siteOperationMode/WDF": "logreplay", "siteReplicationMode/NBG": "primary", "siteReplicationMode/WDF": "sync"}, "HostConfiguration": {"host": "vmhdbqas02", "hostActive": "yes", "hostStatus": "ok", "removeStatus": "", "failoverStatus": "", "hostActualRoles": "worker", "hostConfigRoles": "worker", "storagePartition": "1", "workerActualGroups": "default", "workerConfigGroups": "default", "failoverActualGroup": "default", "failoverConfigGroup": "default", "nameServerActualRole": "master", "nameServerConfigRole": "master 1", "indexServerActualRole": "master", "indexServerConfigRole": "worker", "storageActualPartition": "1", "storageConfigPartition": "1"}, "SystemReplication": {"local_site_id": "2", "site/2/SITE_NAME": "WDF", "site/2/SOURCE_SITE_ID": "1", "site/2/PRIMARY_MASTERS": "vmhdbqas01", "site/2/REPLICATION_MODE": "SYNC"}}]}]	2024-04-09 15:07:17.000807	2024-04-09 15:07:17.000807
173	99cf8a3a-48d6-57a4-b302-6e4482227ab6	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:07:18.264271	2024-04-09 15:07:18.264271
182	ddcb7992-2ffb-5c10-8b39-80685f6eaaba	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:19.55683	2024-04-09 15:07:19.55683
194	0fc07435-7ee2-54ca-b0de-fb27ffdc5deb	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:21.30244	2024-04-09 15:07:21.30244
196	3711ea88-9ccc-5b07-8f9d-042be449d72b	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwqas02", "plan": {}, "tags": "fake-tags", "vmId": "173ff22d-bb92-493a-a6b2-6a269614f178", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwqas02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.90.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.90.1.22"}]}, "ipv6": {}, "macAddress": "6045BD8D06EF"}]}}, "Provider": "azure"}	2024-04-09 15:07:21.578108	2024-04-09 15:07:21.578108
200	240f96b1-8d26-53b7-9e99-ffb0f2e735bf	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:22.14958	2024-04-09 15:07:22.14958
141	0fc07435-7ee2-54ca-b0de-fb27ffdc5deb	saptune_discovery	{"status": {"pid": 24623, "argv": "saptune --format json status", "result": {"staging": {"Notes staged": [], "staging enabled": false, "Solutions staged": []}, "services": {"tuned": [], "sapconf": [], "saptune": ["enabled", "active"]}, "tuning state": "not compliant", "Notes applied": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Notes enabled": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "virtualization": "oracle", "package version": "3.1.0", "Solution applied": [{"Solution ID": "NETWEAVER", "applied partially": false}], "Solution enabled": ["NETWEAVER"], "remember message": "\\nRegarding the tuning state of the system please use 'saptune note verify' for detailed information.\\n\\n", "configured version": "3", "systemd system state": "running", "Notes applied by Solution": [{"Note list": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Solution ID": "NETWEAVER"}], "Notes enabled by Solution": [{"Note list": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Solution ID": "NETWEAVER"}], "Notes enabled additionally": []}, "$schema": "file:///usr/share/saptune/schemas/1.0/saptune_status.schema.json", "command": "status", "messages": [{"message": "actions.go:85: ATTENTION: You are running a test version (3.1.0 from 2022/11/28) of saptune which is not supported for production use\\n", "priority": "NOTICE"}, {"message": "sysctl.go:73: Parameter 'kernel.shmmax' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0xffffffffffffffff), /boot/sysctl.conf-5.3.18-150300.59.93-default(0xffffffffffffffff).\\n", "priority": "WARNING"}, {"message": "sysctl.go:73: Parameter 'kernel.shmall' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0x0fffffffffffff00), /boot/sysctl.conf-5.3.18-150300.59.93-default(0x0fffffffffffff00).\\n", "priority": "WARNING"}, {"message": "ini.go:308: block device related section settings detected: Traversing all block devices can take a considerable amount of time.\\n", "priority": "NOTICE"}], "exit code": 4, "publish time": "2023-04-24 12:41:56.612"}, "package_version": "3.1.0", "saptune_installed": true}	2024-04-09 15:07:13.664402	2024-04-09 15:07:13.664402
146	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	host_discovery	{"hostname": "vmnwdev02", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.100.1.22", "10.100.1.26", "fe80::6245:bdff:fe8d:9c7d"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwdev02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:07:14.334104	2024-04-09 15:07:14.334104
148	f0c808b3-d869-5192-a944-20f66a6a8449	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmiscsi01", "plan": {}, "tags": "fake-tags", "vmId": "aa051519-6d23-461a-af09-8b3a2203ed04", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_DS1_v2", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmiscsi01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-iscsisrv01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-iscsisrv01-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "StandardSSD_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.90.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.90.1.4"}]}, "ipv6": {}, "macAddress": "0022487FD2F9"}]}}, "Provider": "azure"}	2024-04-09 15:07:14.60311	2024-04-09 15:07:14.60311
149	3711ea88-9ccc-5b07-8f9d-042be449d72b	sap_system_discovery	[{"Id": "d01fdc69aeba7bd5133b210eb2884853", "SID": "NWQ", "Type": 2, "Profile": {"SAPDBHOST": "ha-cluster.suse.de", "dbms/name": "HDQ", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwqas", "rdisp/msserv": "sapmsNWQ", "SAPGLOBALHOST": "sapnwqas", "SAPSYSTEMNAME": "NWQ", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDQ", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwqas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.90.1.13", "Databases": null, "Instances": [{"Host": "vmnwqas02", "Name": "ERS10", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwqas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwqer", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwqpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwqaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 9333, "name": "enrepserver", "starttime": "2022 01 17 12:41:17", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "EnqueueReplicator", "elapsedtime": "8:10:52"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwqer", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "ERS10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWQ", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.5", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://sapnwqer:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:07:14.73751	2024-04-09 15:07:14.73751
150	25677e37-fd33-5005-896c-9275b1284534	sap_system_discovery	[{"Id": "d01fdc69aeba7bd5133b210eb2884853", "SID": "NWQ", "Type": 2, "Profile": {"SAPDBHOST": "ha-cluster.suse.de", "dbms/name": "HDQ", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwqas", "rdisp/msserv": "sapmsNWQ", "SAPGLOBALHOST": "sapnwqas", "SAPSYSTEMNAME": "NWQ", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDQ", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwqas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.90.1.13", "Databases": null, "Instances": [{"Host": "vmnwqas01", "Name": "ASCS00", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwqas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwqer", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwqpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwqaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 16279, "name": "enserver", "starttime": "2022 01 17 12:40:24", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "EnqueueServer", "elapsedtime": "8:11:38"}, {"pid": 16278, "name": "msg_server", "starttime": "2022 01 17 12:40:24", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "MessageServer", "elapsedtime": "8:11:38"}], "Properties": [{"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "00", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "EnqGetLockTable", "property": "Enque Locks", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwqas", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "ASCS00", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWQ", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "1", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "YES", "property": "CentralServices", "propertytype": "Attribute"}, {"value": "EnqGetStatistic", "property": "Enque Statistic", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://sapnwqas:50013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}, {"value": "YES", "property": "SupportsUpdateSCSInstance", "propertytype": "Attribute"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:07:14.865858	2024-04-09 15:07:14.865858
152	116d49bd-85e1-5e59-b820-83f66db8800c	saptune_discovery	{"status": {"pid": 24623, "argv": "saptune --format json status", "result": {"staging": {"Notes staged": [], "staging enabled": false, "Solutions staged": []}, "services": {"tuned": [], "sapconf": [], "saptune": ["enabled", "active"]}, "tuning state": "not compliant", "Notes applied": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Notes enabled": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "virtualization": "oracle", "package version": "3.1.0", "Solution applied": [{"Solution ID": "NETWEAVER", "applied partially": false}], "Solution enabled": ["NETWEAVER"], "remember message": "\\nRegarding the tuning state of the system please use 'saptune note verify' for detailed information.\\n\\n", "configured version": "3", "systemd system state": "running", "Notes applied by Solution": [{"Note list": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Solution ID": "NETWEAVER"}], "Notes enabled by Solution": [{"Note list": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Solution ID": "NETWEAVER"}], "Notes enabled additionally": []}, "$schema": "file:///usr/share/saptune/schemas/1.0/saptune_status.schema.json", "command": "status", "messages": [{"message": "actions.go:85: ATTENTION: You are running a test version (3.1.0 from 2022/11/28) of saptune which is not supported for production use\\n", "priority": "NOTICE"}, {"message": "sysctl.go:73: Parameter 'kernel.shmmax' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0xffffffffffffffff), /boot/sysctl.conf-5.3.18-150300.59.93-default(0xffffffffffffffff).\\n", "priority": "WARNING"}, {"message": "sysctl.go:73: Parameter 'kernel.shmall' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0x0fffffffffffff00), /boot/sysctl.conf-5.3.18-150300.59.93-default(0x0fffffffffffff00).\\n", "priority": "WARNING"}, {"message": "ini.go:308: block device related section settings detected: Traversing all block devices can take a considerable amount of time.\\n", "priority": "NOTICE"}], "exit code": 4, "publish time": "2023-04-24 12:41:56.612"}, "package_version": "3.1.0", "saptune_installed": true}	2024-04-09 15:07:15.198735	2024-04-09 15:07:15.198735
155	098fc159-3ed6-58e7-91be-38fda8a833ea	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:07:15.658738	2024-04-09 15:07:15.658738
159	4b30a6af-4b52-5bda-bccb-f2248a12c992	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:16.191681	2024-04-09 15:07:16.191681
163	3711ea88-9ccc-5b07-8f9d-042be449d72b	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:16.719628	2024-04-09 15:07:16.719628
167	25677e37-fd33-5005-896c-9275b1284534	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:07:17.300345	2024-04-09 15:07:17.300345
180	7269ee51-5007-5849-aaa7-7c4a98b0c9ce	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:07:19.28739	2024-04-09 15:07:19.28739
144	b767b3e9-e802-587e-a442-541d093b86b9	saptune_discovery	{"status": {"pid": 24623, "argv": "saptune --format json status", "result": {"staging": {"Notes staged": [], "staging enabled": false, "Solutions staged": []}, "services": {"tuned": [], "sapconf": [], "saptune": ["enabled", "active"]}, "tuning state": "compliant", "Notes applied": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "Notes enabled": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "virtualization": "oracle", "package version": "3.1.0", "Solution applied": [{"Solution ID": "HANA", "applied partially": false}], "Solution enabled": ["HANA"], "remember message": "\\nRegarding the tuning state of the system please use 'saptune note verify' for detailed information.\\n\\n", "configured version": "3", "systemd system state": "running", "Notes applied by Solution": [{"Note list": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "Solution ID": "HANA"}], "Notes enabled by Solution": [{"Note list": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "Solution ID": "HANA"}], "Notes enabled additionally": []}, "$schema": "file:///usr/share/saptune/schemas/1.0/saptune_status.schema.json", "command": "status", "messages": [{"message": "actions.go:85: ATTENTION: You are running a test version (3.1.0 from 2022/11/28) of saptune which is not supported for production use\\n", "priority": "NOTICE"}, {"message": "sysctl.go:73: Parameter 'kernel.shmmax' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0xffffffffffffffff), /boot/sysctl.conf-5.3.18-150300.59.93-default(0xffffffffffffffff).\\n", "priority": "WARNING"}, {"message": "sysctl.go:73: Parameter 'kernel.shmall' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0x0fffffffffffff00), /boot/sysctl.conf-5.3.18-150300.59.93-default(0x0fffffffffffff00).\\n", "priority": "WARNING"}, {"message": "ini.go:308: block device related section settings detected: Traversing all block devices can take a considerable amount of time.\\n", "priority": "NOTICE"}], "exit code": 4, "publish time": "2023-04-24 12:41:56.612"}, "package_version": "3.1.0", "saptune_installed": true}	2024-04-09 15:07:14.067623	2024-04-09 15:07:14.067623
154	f0c808b3-d869-5192-a944-20f66a6a8449	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:15.478276	2024-04-09 15:07:15.478276
157	ddcb7992-2ffb-5c10-8b39-80685f6eaaba	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:07:15.921306	2024-04-09 15:07:15.921306
160	9cd46919-5f19-59aa-993e-cf3736c71053	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmhdbprd01", "plan": {}, "tags": "fake-tags", "vmId": "ee7cf44b-d202-4680-b331-1b3996f2f0e7", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_E4s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmhdbprd01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data01", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "1", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data02", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "2", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data03", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "3", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data04", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "4", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data05", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "5", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data06", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "6", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data07", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.11"}]}, "ipv6": {}, "macAddress": "000D3A232C6B"}]}}, "Provider": "azure"}	2024-04-09 15:07:16.319073	2024-04-09 15:07:16.319073
166	927901fa-2c87-524e-b18c-3ef5187f504f	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmdrbdprd02", "plan": {}, "tags": "fake-tags", "vmId": "f89fef5e-e7e3-469d-b819-a0154be6150c", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmdrbdprd02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmdrbdprd02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmdrbdprd02-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Standard_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.32"}]}, "ipv6": {}, "macAddress": "000D3A2E8B91"}]}}, "Provider": "azure"}	2024-04-09 15:07:17.14017	2024-04-09 15:07:17.14017
169	927901fa-2c87-524e-b18c-3ef5187f504f	saptune_discovery	{"status": {"pid": 24623, "argv": "saptune --format json status", "result": {"staging": {"Notes staged": [], "staging enabled": false, "Solutions staged": []}, "services": {"tuned": [], "sapconf": [], "saptune": ["enabled", "inactive"]}, "tuning state": "not tuned", "Notes applied": [], "Notes enabled": [], "virtualization": "oracle", "package version": "3.1.0", "Solution applied": [], "Solution enabled": [], "remember message": "\\nRegarding the tuning state of the system please use 'saptune note verify' for detailed information.\\n\\n", "configured version": "3", "systemd system state": "running", "Notes applied by Solution": [], "Notes enabled by Solution": [], "Notes enabled additionally": []}, "$schema": "file:///usr/share/saptune/schemas/1.0/saptune_status.schema.json", "command": "status", "messages": [], "exit code": 4, "publish time": "2023-04-24 12:41:56.612"}, "package_version": "3.1.0", "saptune_installed": true}	2024-04-09 15:07:17.591165	2024-04-09 15:07:17.591165
544	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	host_discovery	{"hostname": "vmnwdev02", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.100.1.22", "10.100.1.26", "fe80::6245:bdff:fe8d:9c7d"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwdev02.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:10:09.139519	2024-04-09 15:10:09.139519
156	422686d6-b2d1-5092-93e8-a744854f5085	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmdrbdqas02", "plan": {}, "tags": "fake-tags", "vmId": "cee2a7db-7fb7-4c51-928e-214966364f8f", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmdrbdqas02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmdrbdqas02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmdrbdqas02-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Standard_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.90.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.90.1.32"}]}, "ipv6": {}, "macAddress": "6045BD8D0523"}]}}, "Provider": "azure"}	2024-04-09 15:07:15.79108	2024-04-09 15:07:15.79108
162	7269ee51-5007-5849-aaa7-7c4a98b0c9ce	sap_system_discovery	[{"Id": "a1e80e3e152a903662f7882fb3f8a851", "SID": "NWD", "Type": 2, "Profile": {"SAPDBHOST": "10.100.1.13", "dbms/name": "HDD", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwdas", "rdisp/msserv": "sapmsNWD", "SAPGLOBALHOST": "sapnwdas", "SAPSYSTEMNAME": "NWD", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDD", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwdas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.100.1.13", "Databases": null, "Instances": [{"Host": "vmnwdev01", "Name": "ASCS00", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwdas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwder", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 7379, "name": "enserver", "starttime": "2022 01 11 12:55:17", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "EnqueueServer", "elapsedtime": "151:56:46"}, {"pid": 7378, "name": "msg_server", "starttime": "2022 01 11 12:55:17", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "MessageServer", "elapsedtime": "151:56:46"}], "Properties": [{"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "00", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "EnqGetLockTable", "property": "Enque Locks", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwdas", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "ASCS00", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWD", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "1", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "YES", "property": "CentralServices", "propertytype": "Attribute"}, {"value": "EnqGetStatistic", "property": "Enque Statistic", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://sapnwdas:50013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}, {"value": "YES", "property": "SupportsUpdateSCSInstance", "propertytype": "Attribute"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:07:16.581535	2024-04-09 15:07:16.581535
168	240f96b1-8d26-53b7-9e99-ffb0f2e735bf	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmdrbddev01", "plan": {}, "tags": "fake-tags", "vmId": "5e294482-9554-4989-8b9e-a0a2d3991c09", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmdrbddev01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmdrbddev01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmdrbddev01-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Standard_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.100.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.100.1.31"}]}, "ipv6": {}, "macAddress": "6045BD8A5969"}]}}, "Provider": "azure"}	2024-04-09 15:07:17.448802	2024-04-09 15:07:17.448802
171	4b30a6af-4b52-5bda-bccb-f2248a12c992	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwprd02", "plan": {}, "tags": "fake-tags", "vmId": "2c54a8bf-b71d-423b-a656-34bcc575970e", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwprd02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.22"}]}, "ipv6": {}, "macAddress": "000D3A2E8038"}]}}, "Provider": "azure"}	2024-04-09 15:07:17.93496	2024-04-09 15:07:17.93496
175	a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12	sap_system_discovery	[{"Id": "97a1e70aeff3c0685d65c4c3d32d533b", "SID": "NWP", "Type": 2, "Profile": {"SAPDBHOST": "10.80.1.13", "dbms/name": "HDP", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwpas", "rdisp/msserv": "sapmsNWP", "SAPGLOBALHOST": "sapnwpas", "SAPSYSTEMNAME": "NWP", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDP", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwpas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.80.1.13", "Databases": null, "Instances": [{"Host": "vmnwprd03", "Name": "D01", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwpas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwper", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwppas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwpaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 9752, "name": "gwrd", "starttime": "2022 01 11 13:44:51", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Gateway", "elapsedtime": "151:07:13"}, {"pid": 9753, "name": "icman", "starttime": "2022 01 11 13:44:51", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "ICM", "elapsedtime": "151:07:13"}, {"pid": 9732, "name": "igswd_mt", "starttime": "2022 01 11 13:44:49", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "IGS Watchdog", "elapsedtime": "151:07:15"}, {"pid": 9731, "name": "disp+work", "starttime": "2022 01 11 13:44:49", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Dispatcher", "elapsedtime": "151:07:15"}], "Properties": [{"value": "HTTP://sapnwppas:0/sap/admin/public/index.html", "property": "ICM", "propertytype": "NodeURL"}, {"value": "http://sapnwppas:40180", "property": "IGS", "propertytype": "NodeURL"}, {"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "ICMGetCacheEntries", "property": "ICM Cache", "propertytype": "NodeWebmethod"}, {"value": "01", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetThreadList", "property": "ICM Threads", "propertytype": "NodeWebmethod"}, {"value": "GetAlertTree", "property": "Open Alerts", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwppas", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "ABAPGetWPTable", "property": "ABAP WP Table", "propertytype": "NodeWebmethod"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "D01", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWP", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "GetAlertTree", "property": "Current Status", "propertytype": "NodeWebmethod"}, {"value": "GWGetClientList", "property": "Gateway Clients", "propertytype": "NodeWebmethod"}, {"value": "ICMGetConnectionList", "property": "ICM Connections", "propertytype": "NodeWebmethod"}, {"value": "GetQueueStatistic", "property": "Queue Statistic", "propertytype": "NodeWebmethod"}, {"value": "GWGetConnectionList", "property": "Gateway Connections", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetProxyConnectionList", "property": "ICM Proxy Connections", "propertytype": "NodeWebmethod"}, {"value": "http://sapnwppas:50113/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:07:18.606392	2024-04-09 15:07:18.606392
176	098fc159-3ed6-58e7-91be-38fda8a833ea	sap_system_discovery	[{"Id": "d01fdc69aeba7bd5133b210eb2884853", "SID": "NWQ", "Type": 2, "Profile": {"SAPDBHOST": "ha-cluster.suse.de", "dbms/name": "HDQ", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwqas", "rdisp/msserv": "sapmsNWQ", "SAPGLOBALHOST": "sapnwqas", "SAPSYSTEMNAME": "NWQ", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDQ", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwqas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.90.1.13", "Databases": null, "Instances": [{"Host": "vmnwqas03", "Name": "D01", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwqas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwqer", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwqpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwqaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 17085, "name": "gwrd", "starttime": "2022 01 17 12:42:04", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Gateway", "elapsedtime": "8:09:29"}, {"pid": 17086, "name": "icman", "starttime": "2022 01 17 12:42:04", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "ICM", "elapsedtime": "8:09:29"}, {"pid": 17081, "name": "igswd_mt", "starttime": "2022 01 17 12:42:03", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "IGS Watchdog", "elapsedtime": "8:09:30"}, {"pid": 17080, "name": "disp+work", "starttime": "2022 01 17 12:42:03", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Dispatcher", "elapsedtime": "8:09:30"}], "Properties": [{"value": "HTTP://sapnwqpas:0/sap/admin/public/index.html", "property": "ICM", "propertytype": "NodeURL"}, {"value": "http://sapnwqpas:40180", "property": "IGS", "propertytype": "NodeURL"}, {"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "ICMGetCacheEntries", "property": "ICM Cache", "propertytype": "NodeWebmethod"}, {"value": "01", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetThreadList", "property": "ICM Threads", "propertytype": "NodeWebmethod"}, {"value": "GetAlertTree", "property": "Open Alerts", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwqpas", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "ABAPGetWPTable", "property": "ABAP WP Table", "propertytype": "NodeWebmethod"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "D01", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWQ", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "GetAlertTree", "property": "Current Status", "propertytype": "NodeWebmethod"}, {"value": "GWGetClientList", "property": "Gateway Clients", "propertytype": "NodeWebmethod"}, {"value": "ICMGetConnectionList", "property": "ICM Connections", "propertytype": "NodeWebmethod"}, {"value": "GetQueueStatistic", "property": "Queue Statistic", "propertytype": "NodeWebmethod"}, {"value": "GWGetConnectionList", "property": "Gateway Connections", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetProxyConnectionList", "property": "ICM Proxy Connections", "propertytype": "NodeWebmethod"}, {"value": "http://sapnwqpas:50113/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:07:18.752394	2024-04-09 15:07:18.752394
177	1b0e9297-97dd-55d6-9874-8efde4d84c90	sap_system_discovery	[{"Id": "a1e80e3e152a903662f7882fb3f8a851", "SID": "NWD", "Type": 2, "Profile": {"SAPDBHOST": "10.100.1.13", "dbms/name": "HDD", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwdas", "rdisp/msserv": "sapmsNWD", "SAPGLOBALHOST": "sapnwdas", "SAPSYSTEMNAME": "NWD", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDD", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwdas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.100.1.13", "Databases": null, "Instances": [{"Host": "vmnwdev04", "Name": "D02", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwdas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwder", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 26496, "name": "gwrd", "starttime": "2022 01 11 13:05:00", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Gateway", "elapsedtime": "151:47:01"}, {"pid": 26497, "name": "icman", "starttime": "2022 01 11 13:05:00", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "ICM", "elapsedtime": "151:47:01"}, {"pid": 26476, "name": "igswd_mt", "starttime": "2022 01 11 13:04:57", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "IGS Watchdog", "elapsedtime": "151:47:04"}, {"pid": 26475, "name": "disp+work", "starttime": "2022 01 11 13:04:57", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Dispatcher", "elapsedtime": "151:47:04"}], "Properties": [{"value": "HTTP://sapnwdaas1:0/sap/admin/public/index.html", "property": "ICM", "propertytype": "NodeURL"}, {"value": "http://sapnwdaas1:40280", "property": "IGS", "propertytype": "NodeURL"}, {"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "ICMGetCacheEntries", "property": "ICM Cache", "propertytype": "NodeWebmethod"}, {"value": "02", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetThreadList", "property": "ICM Threads", "propertytype": "NodeWebmethod"}, {"value": "GetAlertTree", "property": "Open Alerts", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwdaas1", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "ABAPGetWPTable", "property": "ABAP WP Table", "propertytype": "NodeWebmethod"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "D02", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWD", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "GetAlertTree", "property": "Current Status", "propertytype": "NodeWebmethod"}, {"value": "GWGetClientList", "property": "Gateway Clients", "propertytype": "NodeWebmethod"}, {"value": "ICMGetConnectionList", "property": "ICM Connections", "propertytype": "NodeWebmethod"}, {"value": "GetQueueStatistic", "property": "Queue Statistic", "propertytype": "NodeWebmethod"}, {"value": "GWGetConnectionList", "property": "Gateway Connections", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetProxyConnectionList", "property": "ICM Proxy Connections", "propertytype": "NodeWebmethod"}, {"value": "http://sapnwdaas1:50213/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:07:18.892513	2024-04-09 15:07:18.892513
179	9cd46919-5f19-59aa-993e-cf3736c71053	saptune_discovery	{"status": {"pid": 24623, "argv": "saptune --format json status", "result": {"staging": {"Notes staged": [], "staging enabled": false, "Solutions staged": []}, "services": {"tuned": [], "sapconf": [], "saptune": ["enabled", "active"]}, "tuning state": "compliant", "Notes applied": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "Notes enabled": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "virtualization": "oracle", "package version": "3.1.0", "Solution applied": [{"Solution ID": "HANA", "applied partially": false}], "Solution enabled": ["HANA"], "remember message": "\\nRegarding the tuning state of the system please use 'saptune note verify' for detailed information.\\n\\n", "configured version": "3", "systemd system state": "running", "Notes applied by Solution": [{"Note list": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "Solution ID": "HANA"}], "Notes enabled by Solution": [{"Note list": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "Solution ID": "HANA"}], "Notes enabled additionally": []}, "$schema": "file:///usr/share/saptune/schemas/1.0/saptune_status.schema.json", "command": "status", "messages": [{"message": "actions.go:85: ATTENTION: You are running a test version (3.1.0 from 2022/11/28) of saptune which is not supported for production use\\n", "priority": "NOTICE"}, {"message": "sysctl.go:73: Parameter 'kernel.shmmax' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0xffffffffffffffff), /boot/sysctl.conf-5.3.18-150300.59.93-default(0xffffffffffffffff).\\n", "priority": "WARNING"}, {"message": "sysctl.go:73: Parameter 'kernel.shmall' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0x0fffffffffffff00), /boot/sysctl.conf-5.3.18-150300.59.93-default(0x0fffffffffffff00).\\n", "priority": "WARNING"}, {"message": "ini.go:308: block device related section settings detected: Traversing all block devices can take a considerable amount of time.\\n", "priority": "NOTICE"}], "exit code": 4, "publish time": "2023-04-24 12:41:56.612"}, "package_version": "3.1.0", "saptune_installed": true}	2024-04-09 15:07:19.151016	2024-04-09 15:07:19.151016
545	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	sap_system_discovery	[{"Id": "a1e80e3e152a903662f7882fb3f8a851", "SID": "NWD", "Type": 2, "Profile": {"SAPDBHOST": "10.100.1.13", "dbms/name": "HDD", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwdas", "rdisp/msserv": "sapmsNWD", "SAPGLOBALHOST": "sapnwdas", "SAPSYSTEMNAME": "NWD", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDD", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwdas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.100.1.13", "Databases": null, "Instances": [{"Host": "vmnwdev02", "Name": "ERS10", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwdas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwder", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 6720, "name": "enrepserver", "starttime": "2022 01 11 12:55:17", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "EnqueueReplicator", "elapsedtime": "151:56:49"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwder", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "ERS10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWD", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.5", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://sapnwder:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:10:09.262044	2024-04-09 15:10:09.262044
158	ddcb7992-2ffb-5c10-8b39-80685f6eaaba	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmdrbdqas01", "plan": {}, "tags": "fake-tags", "vmId": "9c5b4666-5356-4347-b688-6954027283a1", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmdrbdqas01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmdrbdqas01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmdrbdqas01-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Standard_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.90.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.90.1.31"}]}, "ipv6": {}, "macAddress": "6045BD8D00C2"}]}}, "Provider": "azure"}	2024-04-09 15:07:16.056479	2024-04-09 15:07:16.056479
161	e0c182db-32ff-55c6-a9eb-2b82dd21bc8b	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:16.451054	2024-04-09 15:07:16.451054
172	b767b3e9-e802-587e-a442-541d093b86b9	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:18.091275	2024-04-09 15:07:18.091275
174	4b30a6af-4b52-5bda-bccb-f2248a12c992	saptune_discovery	{"status": {"pid": 24623, "argv": "saptune --format json status", "result": {"staging": {"Notes staged": [], "staging enabled": false, "Solutions staged": []}, "services": {"tuned": [], "sapconf": [], "saptune": ["enabled", "active"]}, "tuning state": "not compliant", "Notes applied": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Notes enabled": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "virtualization": "oracle", "package version": "3.1.0", "Solution applied": [{"Solution ID": "NETWEAVER", "applied partially": false}], "Solution enabled": ["NETWEAVER"], "remember message": "\\nRegarding the tuning state of the system please use 'saptune note verify' for detailed information.\\n\\n", "configured version": "3", "systemd system state": "running", "Notes applied by Solution": [{"Note list": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Solution ID": "NETWEAVER"}], "Notes enabled by Solution": [{"Note list": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Solution ID": "NETWEAVER"}], "Notes enabled additionally": []}, "$schema": "file:///usr/share/saptune/schemas/1.0/saptune_status.schema.json", "command": "status", "messages": [{"message": "actions.go:85: ATTENTION: You are running a test version (3.1.0 from 2022/11/28) of saptune which is not supported for production use\\n", "priority": "NOTICE"}, {"message": "sysctl.go:73: Parameter 'kernel.shmmax' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0xffffffffffffffff), /boot/sysctl.conf-5.3.18-150300.59.93-default(0xffffffffffffffff).\\n", "priority": "WARNING"}, {"message": "sysctl.go:73: Parameter 'kernel.shmall' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0x0fffffffffffff00), /boot/sysctl.conf-5.3.18-150300.59.93-default(0x0fffffffffffff00).\\n", "priority": "WARNING"}, {"message": "ini.go:308: block device related section settings detected: Traversing all block devices can take a considerable amount of time.\\n", "priority": "NOTICE"}], "exit code": 4, "publish time": "2023-04-24 12:41:56.612"}, "package_version": "3.1.0", "saptune_installed": true}	2024-04-09 15:07:18.421844	2024-04-09 15:07:18.421844
178	25677e37-fd33-5005-896c-9275b1284534	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:19.021211	2024-04-09 15:07:19.021211
183	b767b3e9-e802-587e-a442-541d093b86b9	sap_system_discovery	[{"Id": "1154f7678ac587e5f0f242830a5201f1", "SID": "HDP", "Type": 1, "Profile": {"SAPGLOBALHOST": "vmhdbprd02", "SAPSYSTEMNAME": "HDP", "hdbConfigType": "DEFAULT", "ssl/ciphersuites": "135:PFS:HIGH::EC_P256:EC_HIGH", "HDB_LINKED_BINARIES": "yes", "HDB_SHARED_BINARIES": "yes"}, "Databases": [{"Host": "vmhdbprd02", "User": "", "Group": "", "Active": "yes", "UserId": "", "GroupId": "", "SqlPort": "31015", "Database": "HDP", "Container": ""}], "Instances": [{"Host": "vmhdbprd02", "Name": "HDB10", "Type": 1, "SAPControl": {"Instances": [{"features": "HDB|HDB_WORKER", "hostname": "vmhdbprd02", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.3"}], "Processes": [{"pid": 7464, "name": "hdbdaemon", "starttime": "2022 01 11 13:36:18", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Daemon", "elapsedtime": "151:15:40"}, {"pid": 8467, "name": "hdbxsengine", "starttime": "2022 01 11 13:36:34", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB XSEngine-HDP", "elapsedtime": "151:15:24"}, {"pid": 7484, "name": "hdbnameserver", "starttime": "2022 01 11 13:36:18", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Nameserver", "elapsedtime": "151:15:40"}, {"pid": 8460, "name": "hdbindexserver", "starttime": "2022 01 11 13:36:34", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Indexserver-HDP", "elapsedtime": "151:15:24"}, {"pid": 8253, "name": "hdbpreprocessor", "starttime": "2022 01 11 13:36:33", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Preprocessor", "elapsedtime": "151:15:25"}, {"pid": 8250, "name": "hdbcompileserver", "starttime": "2022 01 11 13:36:33", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Compileserver", "elapsedtime": "151:15:25"}, {"pid": 9083, "name": "hdbwebdispatcher", "starttime": "2022 01 11 13:36:43", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Web Dispatcher", "elapsedtime": "151:15:15"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "YES", "property": "DBServices", "propertytype": "Attribute"}, {"value": "worker", "property": "HANA Roles", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "vmhdbprd02", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "HDB10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "HDP", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://vmhdbprd02:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": {"mode": "sync", "online": "true", "site_id": "2", "isSource": "false", "site_name": "WDF", "isConsumer": "true", "replayMode": "auto", "hasConsumers": "false", "siteTier/NBG": "1", "siteTier/WDF": "2", "operation_mode": "logreplay", "primary_masters": "vmhdbprd01", "siteMapping/NBG": "WDF", "isTakeoverActive": "false", "isPrimarySuspended": "false", "mapping/vmhdbprd02": ["WDF/vmhdbprd02", "NBG/vmhdbprd01"], "active_primary_site": "1", "isTimetravelEnabled": "false", "siteOperationMode/NBG": "primary", "siteOperationMode/WDF": "logreplay", "siteReplicationMode/NBG": "primary", "siteReplicationMode/WDF": "sync"}, "HostConfiguration": {"host": "vmhdbprd02", "hostActive": "yes", "hostStatus": "ok", "removeStatus": "", "failoverStatus": "", "hostActualRoles": "worker", "hostConfigRoles": "worker", "storagePartition": "1", "workerActualGroups": "default", "workerConfigGroups": "default", "failoverActualGroup": "default", "failoverConfigGroup": "default", "nameServerActualRole": "master", "nameServerConfigRole": "master 1", "indexServerActualRole": "master", "indexServerConfigRole": "worker", "storageActualPartition": "1", "storageConfigPartition": "1"}, "SystemReplication": {"local_site_id": "2", "site/2/SITE_NAME": "WDF", "site/2/SOURCE_SITE_ID": "1", "site/2/PRIMARY_MASTERS": "vmhdbprd01", "site/2/REPLICATION_MODE": "SYNC"}}]}]	2024-04-09 15:07:19.700691	2024-04-09 15:07:19.700691
197	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:21.767301	2024-04-09 15:07:21.767301
549	9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f	sap_system_discovery	[{"Id": "a1e80e3e152a903662f7882fb3f8a851", "SID": "NWD", "Type": 2, "Profile": {"SAPDBHOST": "10.100.1.13", "dbms/name": "HDD", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwdas", "rdisp/msserv": "sapmsNWD", "SAPGLOBALHOST": "sapnwdas", "SAPSYSTEMNAME": "NWD", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDD", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwdas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.100.1.13", "Databases": null, "Instances": [{"Host": "vmnwdev03", "Name": "D01", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwdas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwder", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 27224, "name": "gwrd", "starttime": "2022 01 11 13:03:58", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Gateway", "elapsedtime": "151:48:10"}, {"pid": 27225, "name": "icman", "starttime": "2022 01 11 13:03:58", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "ICM", "elapsedtime": "151:48:10"}, {"pid": 26907, "name": "igswd_mt", "starttime": "2022 01 11 13:03:55", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "IGS Watchdog", "elapsedtime": "151:48:13"}, {"pid": 26906, "name": "disp+work", "starttime": "2022 01 11 13:03:55", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Dispatcher", "elapsedtime": "151:48:13"}], "Properties": [{"value": "HTTP://sapnwdpas:0/sap/admin/public/index.html", "property": "ICM", "propertytype": "NodeURL"}, {"value": "http://sapnwdpas:40180", "property": "IGS", "propertytype": "NodeURL"}, {"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "ICMGetCacheEntries", "property": "ICM Cache", "propertytype": "NodeWebmethod"}, {"value": "01", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetThreadList", "property": "ICM Threads", "propertytype": "NodeWebmethod"}, {"value": "GetAlertTree", "property": "Open Alerts", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwdpas", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "ABAPGetWPTable", "property": "ABAP WP Table", "propertytype": "NodeWebmethod"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "D01", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWD", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "GetAlertTree", "property": "Current Status", "propertytype": "NodeWebmethod"}, {"value": "GWGetClientList", "property": "Gateway Clients", "propertytype": "NodeWebmethod"}, {"value": "ICMGetConnectionList", "property": "ICM Connections", "propertytype": "NodeWebmethod"}, {"value": "GetQueueStatistic", "property": "Queue Statistic", "propertytype": "NodeWebmethod"}, {"value": "GWGetConnectionList", "property": "Gateway Connections", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetProxyConnectionList", "property": "ICM Proxy Connections", "propertytype": "NodeWebmethod"}, {"value": "http://sapnwdpas:50113/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:10:09.818374	2024-04-09 15:10:09.818374
170	21de186a-e38f-5804-b643-7f4ef22fecfd	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmdrbddev02", "plan": {}, "tags": "fake-tags", "vmId": "99ef5ab8-73b5-4ca9-8c37-6778e2d6abc1", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmdrbddev02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmdrbddev02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmdrbddev02-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Standard_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.100.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.100.1.32"}]}, "ipv6": {}, "macAddress": "6045BD8D95F1"}]}}, "Provider": "azure"}	2024-04-09 15:07:17.791776	2024-04-09 15:07:17.791776
181	e0c182db-32ff-55c6-a9eb-2b82dd21bc8b	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:07:19.423751	2024-04-09 15:07:19.423751
186	927901fa-2c87-524e-b18c-3ef5187f504f	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:20.101321	2024-04-09 15:07:20.101321
187	e0c182db-32ff-55c6-a9eb-2b82dd21bc8b	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmhdbqas02", "plan": {}, "tags": "fake-tags", "vmId": "7b21fd90-d128-4e25-8812-2fef28f94839", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_E4s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmhdbqas02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmhdbqas02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmhdbqas02-Data01", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "1", "vhd": {"uri": ""}, "name": "disk-vmhdbqas02-Data02", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "2", "vhd": {"uri": ""}, "name": "disk-vmhdbqas02-Data03", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "3", "vhd": {"uri": ""}, "name": "disk-vmhdbqas02-Data04", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "4", "vhd": {"uri": ""}, "name": "disk-vmhdbqas02-Data05", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "5", "vhd": {"uri": ""}, "name": "disk-vmhdbqas02-Data06", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "6", "vhd": {"uri": ""}, "name": "disk-vmhdbqas02-Data07", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.90.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.90.1.12"}]}, "ipv6": {}, "macAddress": "6045BD8D08B3"}]}}, "Provider": "azure"}	2024-04-09 15:07:20.286551	2024-04-09 15:07:20.286551
188	a09d9cf3-46c1-505c-8fb8-4b0a71a9114e	saptune_discovery	{"status": {"pid": 24623, "argv": "saptune --format json status", "result": {"staging": {"Notes staged": [], "staging enabled": false, "Solutions staged": []}, "services": {"tuned": [], "sapconf": [], "saptune": ["enabled", "inactive"]}, "tuning state": "not tuned", "Notes applied": [], "Notes enabled": [], "virtualization": "oracle", "package version": "3.1.0", "Solution applied": [], "Solution enabled": [], "remember message": "\\nRegarding the tuning state of the system please use 'saptune note verify' for detailed information.\\n\\n", "configured version": "3", "systemd system state": "running", "Notes applied by Solution": [], "Notes enabled by Solution": [], "Notes enabled additionally": []}, "$schema": "file:///usr/share/saptune/schemas/1.0/saptune_status.schema.json", "command": "status", "messages": [], "exit code": 4, "publish time": "2023-04-24 12:41:56.612"}, "package_version": "3.1.0", "saptune_installed": true}	2024-04-09 15:07:20.417762	2024-04-09 15:07:20.417762
189	b767b3e9-e802-587e-a442-541d093b86b9	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmhdbprd02", "plan": {}, "tags": "fake-tags", "vmId": "cdec8bb8-ec3f-437a-89dd-3df677e1507e", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_E4s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmhdbprd02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmhdbprd02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmhdbprd02-Data01", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "1", "vhd": {"uri": ""}, "name": "disk-vmhdbprd02-Data02", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "2", "vhd": {"uri": ""}, "name": "disk-vmhdbprd02-Data03", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "3", "vhd": {"uri": ""}, "name": "disk-vmhdbprd02-Data04", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "4", "vhd": {"uri": ""}, "name": "disk-vmhdbprd02-Data05", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "5", "vhd": {"uri": ""}, "name": "disk-vmhdbprd02-Data06", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "6", "vhd": {"uri": ""}, "name": "disk-vmhdbprd02-Data07", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.12"}]}, "ipv6": {}, "macAddress": "000D3A21F108"}]}}, "Provider": "azure"}	2024-04-09 15:07:20.619993	2024-04-09 15:07:20.619993
190	4b30a6af-4b52-5bda-bccb-f2248a12c992	sap_system_discovery	[{"Id": "97a1e70aeff3c0685d65c4c3d32d533b", "SID": "NWP", "Type": 2, "Profile": {"SAPDBHOST": "10.80.1.13", "dbms/name": "HDP", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwpas", "rdisp/msserv": "sapmsNWP", "SAPGLOBALHOST": "sapnwpas", "SAPSYSTEMNAME": "NWP", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDP", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwpas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.80.1.13", "Databases": null, "Instances": [{"Host": "vmnwprd02", "Name": "ERS10", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwpas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwper", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwppas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwpaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 23289, "name": "enrepserver", "starttime": "2022 01 11 13:43:18", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "EnqueueReplicator", "elapsedtime": "151:08:42"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwper", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "ERS10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWP", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.5", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://sapnwper:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:07:20.760877	2024-04-09 15:07:20.760877
558	9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f	sap_system_discovery	[{"Id": "a1e80e3e152a903662f7882fb3f8a851", "SID": "NWD", "Type": 2, "Profile": {"SAPDBHOST": "10.100.1.13", "dbms/name": "HDD", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwdas", "rdisp/msserv": "sapmsNWD", "SAPGLOBALHOST": "sapnwdas", "SAPSYSTEMNAME": "NWD", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDD", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwdas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.100.1.13", "Databases": null, "Instances": [{"Host": "vmnwdev03", "Name": "D01", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwdas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwder", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 27224, "name": "gwrd", "starttime": "2022 01 11 13:03:58", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Gateway", "elapsedtime": "151:48:10"}, {"pid": 27225, "name": "icman", "starttime": "2022 01 11 13:03:58", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "ICM", "elapsedtime": "151:48:10"}, {"pid": 26907, "name": "igswd_mt", "starttime": "2022 01 11 13:03:55", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "IGS Watchdog", "elapsedtime": "151:48:13"}, {"pid": 26906, "name": "disp+work", "starttime": "2022 01 11 13:03:55", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Dispatcher", "elapsedtime": "151:48:13"}], "Properties": [{"value": "HTTP://sapnwdpas:0/sap/admin/public/index.html", "property": "ICM", "propertytype": "NodeURL"}, {"value": "http://sapnwdpas:40180", "property": "IGS", "propertytype": "NodeURL"}, {"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "ICMGetCacheEntries", "property": "ICM Cache", "propertytype": "NodeWebmethod"}, {"value": "01", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetThreadList", "property": "ICM Threads", "propertytype": "NodeWebmethod"}, {"value": "GetAlertTree", "property": "Open Alerts", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwdpas", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "ABAPGetWPTable", "property": "ABAP WP Table", "propertytype": "NodeWebmethod"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "D01", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWD", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "GetAlertTree", "property": "Current Status", "propertytype": "NodeWebmethod"}, {"value": "GWGetClientList", "property": "Gateway Clients", "propertytype": "NodeWebmethod"}, {"value": "ICMGetConnectionList", "property": "ICM Connections", "propertytype": "NodeWebmethod"}, {"value": "GetQueueStatistic", "property": "Queue Statistic", "propertytype": "NodeWebmethod"}, {"value": "GWGetConnectionList", "property": "Gateway Connections", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetProxyConnectionList", "property": "ICM Proxy Connections", "propertytype": "NodeWebmethod"}, {"value": "http://sapnwdpas:50113/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:10:11.423624	2024-04-09 15:10:11.423624
185	422686d6-b2d1-5092-93e8-a744854f5085	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:19.961072	2024-04-09 15:07:19.961072
201	81e9b629-c1e7-538f-bff1-47d3a6580522	subscription_discovery	[{"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "SLES_SAP"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-ha"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Not Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:07:22.318095	2024-04-09 15:07:22.318095
192	25677e37-fd33-5005-896c-9275b1284534	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwqas01", "plan": {}, "tags": "fake-tags", "vmId": "2f1d001b-7ba0-49f3-afbd-c5668684a0a4", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwqas01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.90.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.90.1.21"}]}, "ipv6": {}, "macAddress": "6045BD8D0A30"}]}}, "Provider": "azure"}	2024-04-09 15:07:21.029888	2024-04-09 15:07:21.029888
193	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwdev02", "plan": {}, "tags": "fake-tags", "vmId": "84f224b2-ad29-41a7-94ae-26ced84cdace", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwdev02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.100.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.100.1.22"}]}, "ipv6": {}, "macAddress": "6045BD8D9C7D"}]}}, "Provider": "azure"}	2024-04-09 15:07:21.168315	2024-04-09 15:07:21.168315
195	3711ea88-9ccc-5b07-8f9d-042be449d72b	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:07:21.435547	2024-04-09 15:07:21.435547
198	240f96b1-8d26-53b7-9e99-ffb0f2e735bf	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:07:21.902746	2024-04-09 15:07:21.902746
199	7269ee51-5007-5849-aaa7-7c4a98b0c9ce	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwdev01", "plan": {}, "tags": "fake-tags", "vmId": "84e20bce-76e8-4d55-bdea-7ec3faff60f2", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwdev01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.100.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.100.1.21"}]}, "ipv6": {}, "macAddress": "6045BD8A5CE7"}]}}, "Provider": "azure"}	2024-04-09 15:07:22.024684	2024-04-09 15:07:22.024684
202	13e8c25c-3180-5a9a-95c8-51ec38e50cfc	host_discovery	{"hostname": "vmhdbdev01", "cpu_count": 4, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.100.1.11", "10.100.1.13", "fe80::6245:bdff:fe8d:9b69"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 32107, "fully_qualified_domain_name": "vmhdbdev01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:08:16.378107	2024-04-09 15:08:16.378107
203	116d49bd-85e1-5e59-b820-83f66db8800c	saptune_discovery	{"status": {"pid": 24623, "argv": "saptune --format json status", "result": {"staging": {"Notes staged": [], "staging enabled": false, "Solutions staged": []}, "services": {"tuned": [], "sapconf": [], "saptune": ["enabled", "active"]}, "tuning state": "not compliant", "Notes applied": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Notes enabled": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "virtualization": "oracle", "package version": "3.1.0", "Solution applied": [{"Solution ID": "NETWEAVER", "applied partially": false}], "Solution enabled": ["NETWEAVER"], "remember message": "\\nRegarding the tuning state of the system please use 'saptune note verify' for detailed information.\\n\\n", "configured version": "3", "systemd system state": "running", "Notes applied by Solution": [{"Note list": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Solution ID": "NETWEAVER"}], "Notes enabled by Solution": [{"Note list": ["941735", "1771258", "2578899", "2993054", "1656250", "900929"], "Solution ID": "NETWEAVER"}], "Notes enabled additionally": []}, "$schema": "file:///usr/share/saptune/schemas/1.0/saptune_status.schema.json", "command": "status", "messages": [{"message": "actions.go:85: ATTENTION: You are running a test version (3.1.0 from 2022/11/28) of saptune which is not supported for production use\\n", "priority": "NOTICE"}, {"message": "sysctl.go:73: Parameter 'kernel.shmmax' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0xffffffffffffffff), /boot/sysctl.conf-5.3.18-150300.59.93-default(0xffffffffffffffff).\\n", "priority": "WARNING"}, {"message": "sysctl.go:73: Parameter 'kernel.shmall' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0x0fffffffffffff00), /boot/sysctl.conf-5.3.18-150300.59.93-default(0x0fffffffffffff00).\\n", "priority": "WARNING"}, {"message": "ini.go:308: block device related section settings detected: Traversing all block devices can take a considerable amount of time.\\n", "priority": "NOTICE"}], "exit code": 4, "publish time": "2023-04-24 12:41:56.612"}, "package_version": "3.1.0", "saptune_installed": true}	2024-04-09 15:08:16.514152	2024-04-09 15:08:16.514152
204	9a26b6d0-6e72-597c-9fe5-152a6875f214	host_discovery	{"hostname": "vmiscsi01", "cpu_count": 1, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.80.1.4", "fe80::20d:3aff:fe2e:835a"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 3421, "fully_qualified_domain_name": "vmiscsi01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:08:16.636495	2024-04-09 15:08:16.636495
205	9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f	host_discovery	{"hostname": "vmnwdev03", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.100.1.23", "10.100.1.27", "fe80::6245:bdff:fe8d:9ef4"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwdev03.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:08:16.762902	2024-04-09 15:08:16.762902
206	0fc07435-7ee2-54ca-b0de-fb27ffdc5deb	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmnwprd04", "plan": {}, "tags": "fake-tags", "vmId": "a7321bd7-c191-4650-b368-9c0b7bf04de6", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmnwprd04", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-netweaver04-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-netweaver02-App", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Attach", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.24"}, {"privateIpAddress": "10.80.1.28"}]}, "ipv6": {}, "macAddress": "000D3A2E8FAD"}]}}, "Provider": "azure"}	2024-04-09 15:08:16.894725	2024-04-09 15:08:16.894725
207	f0c808b3-d869-5192-a944-20f66a6a8449	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:08:17.015054	2024-04-09 15:08:17.015054
208	1b0e9297-97dd-55d6-9874-8efde4d84c90	host_discovery	{"hostname": "vmnwdev04", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.100.1.24", "10.100.1.28", "fe80::6245:bdff:fe8d:9a74"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwdev04.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:08:17.138165	2024-04-09 15:08:17.138165
209	098fc159-3ed6-58e7-91be-38fda8a833ea	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:08:17.280945	2024-04-09 15:08:17.280945
211	ddcb7992-2ffb-5c10-8b39-80685f6eaaba	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:08:17.531243	2024-04-09 15:08:17.531243
210	422686d6-b2d1-5092-93e8-a744854f5085	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmdrbdqas02", "plan": {}, "tags": "fake-tags", "vmId": "cee2a7db-7fb7-4c51-928e-214966364f8f", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmdrbdqas02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmdrbdqas02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmdrbdqas02-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Standard_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.90.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.90.1.32"}]}, "ipv6": {}, "macAddress": "6045BD8D0523"}]}}, "Provider": "azure"}	2024-04-09 15:08:17.40782	2024-04-09 15:08:17.40782
215	4b30a6af-4b52-5bda-bccb-f2248a12c992	ha_cluster_discovery	{"DC": false, "Id": "8bca366a6cb7816555538092a1ddd5aa", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmnwprd01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmnwprd02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "netweaver_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": null, "Groups": [{"Id": "grp_NWP_ASCS00", "Primitives": [{"Id": "rsc_ip_NWP_ASCS00", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWP_ASCS00-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWP_ASCS00-instance_attributes-ip", "Name": "ip", "Value": "10.80.1.25"}]}, {"Id": "rsc_fs_NWP_ASCS00", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWP_ASCS00-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWP_ASCS00-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWP_ASCS00-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWP_ASCS00-instance_attributes-device", "Name": "device", "Value": "10.80.1.33:/NWP/ASCS"}, {"Id": "rsc_fs_NWP_ASCS00-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWP/ASCS00"}, {"Id": "rsc_fs_NWP_ASCS00-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWP_ASCS00", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWP_ASCS00-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWP_ASCS00-meta_attributes-resource-stickiness", "Name": "resource-stickiness", "Value": "5000"}, {"Id": "rsc_sap_NWP_ASCS00-meta_attributes-failure-timeout", "Name": "failure-timeout", "Value": "60"}, {"Id": "rsc_sap_NWP_ASCS00-meta_attributes-migration-threshold", "Name": "migration-threshold", "Value": "1"}, {"Id": "rsc_sap_NWP_ASCS00-meta_attributes-priority", "Name": "priority", "Value": "10"}], "InstanceAttributes": [{"Id": "rsc_sap_NWP_ASCS00-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWP_ASCS00_sapnwpas"}, {"Id": "rsc_sap_NWP_ASCS00-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWP/profile/NWP_ASCS00_sapnwpas"}, {"Id": "rsc_sap_NWP_ASCS00-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}]}, {"Id": "rsc_socat_NWP_ASCS00", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWP_ASCS00-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWP_ASCS00-instance_attributes-port", "Name": "port", "Value": "62000"}]}]}, {"Id": "grp_NWP_ERS10", "Primitives": [{"Id": "rsc_ip_NWP_ERS10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWP_ERS10-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWP_ERS10-instance_attributes-ip", "Name": "ip", "Value": "10.80.1.26"}]}, {"Id": "rsc_fs_NWP_ERS10", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWP_ERS10-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWP_ERS10-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWP_ERS10-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWP_ERS10-instance_attributes-device", "Name": "device", "Value": "10.80.1.33:/NWP/ERS"}, {"Id": "rsc_fs_NWP_ERS10-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWP/ERS10"}, {"Id": "rsc_fs_NWP_ERS10-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWP_ERS10", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWP_ERS10-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWP_ERS10-meta_attributes-priority", "Name": "priority", "Value": "1000"}], "InstanceAttributes": [{"Id": "rsc_sap_NWP_ERS10-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWP_ERS10_sapnwper"}, {"Id": "rsc_sap_NWP_ERS10-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWP/profile/NWP_ERS10_sapnwper"}, {"Id": "rsc_sap_NWP_ERS10-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}, {"Id": "rsc_sap_NWP_ERS10-instance_attributes-IS_ERS", "Name": "IS_ERS", "Value": "true"}]}, {"Id": "rsc_socat_NWP_ERS10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWP_ERS10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWP_ERS10-instance_attributes-port", "Name": "port", "Value": "62110"}]}]}], "Masters": null, "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": [{"Id": "loc_sap_NWP_failover_to_ers", "Node": "", "Role": "", "Score": "", "Resource": "rsc_sap_NWP_ASCS00"}]}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_e34218cd-0d9a-4b21-b6d5-a313980baa82", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "e0c97fe2-f63a-4fd1-83df-9a736a03b49b", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmnwprd01", "Status": "clear"}, {"Id": 1, "Name": "vmnwprd02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_e34218cd-0d9a-4b21-b6d5-a313980baa82", "Status": "healthy"}]}, "Name": "netweaver_cluster", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmnwprd01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 5}, {"DC": false, "Id": "2", "Name": "vmnwprd02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 4}], "Clones": null, "Groups": [{"Id": "grp_NWP_ASCS00", "Resources": [{"Id": "rsc_ip_NWP_ASCS00", "Node": {"Id": "1", "Name": "vmnwprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWP_ASCS00", "Node": {"Id": "1", "Name": "vmnwprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWP_ASCS00", "Node": {"Id": "1", "Name": "vmnwprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWP_ASCS00", "Node": {"Id": "1", "Name": "vmnwprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}, {"Id": "grp_NWP_ERS10", "Resources": [{"Id": "rsc_ip_NWP_ERS10", "Node": {"Id": "2", "Name": "vmnwprd02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWP_ERS10", "Node": {"Id": "2", "Name": "vmnwprd02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWP_ERS10", "Node": {"Id": "2", "Name": "vmnwprd02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWP_ERS10", "Node": {"Id": "2", "Name": "vmnwprd02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 13:43:06 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmnwprd01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmnwprd01", "ResourceHistory": [{"Name": "rsc_ip_NWP_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_socat_NWP_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWP_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWP_ASCS00", "FailCount": 0, "MigrationThreshold": 1}]}, {"Name": "vmnwprd02", "ResourceHistory": [{"Name": "rsc_ip_NWP_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWP_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWP_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_socat_NWP_ERS10", "FailCount": 0, "MigrationThreshold": 3}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmnwprd02", "Attributes": [{"Name": "runs_ers_NWP", "Value": "1"}]}]}}, "Provider": "azure"}	2024-04-09 15:08:18.061435	2024-04-09 15:08:18.061435
220	927901fa-2c87-524e-b18c-3ef5187f504f	sap_system_discovery	[]	2024-04-09 15:08:18.668789	2024-04-09 15:08:18.668789
221	3711ea88-9ccc-5b07-8f9d-042be449d72b	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:08:18.791321	2024-04-09 15:08:18.791321
227	422686d6-b2d1-5092-93e8-a744854f5085	ha_cluster_discovery	{"DC": true, "Id": "a034a158905404befe08775682910ee1", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmdrbdqas01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmdrbdqas02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "drbd_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": [{"Id": "cl-nfsserver", "Primitive": {"Id": "nfsserver", "Type": "nfs-server", "Class": "systemd", "Provider": "", "Operations": [{"Id": "nfsserver-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": null}, "MetaAttributes": [{"Id": "cl-nfsserver-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g-nfs_sapdata", "Primitives": [{"Id": "fs_sapdata", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "fs_sapdata-monitor-20", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "fs_sapdata-instance_attributes-device", "Name": "device", "Value": "/dev/drbd1"}, {"Id": "fs_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWQ"}, {"Id": "fs_sapdata-instance_attributes-fstype", "Name": "fstype", "Value": "xfs"}, {"Id": "fs_sapdata-instance_attributes-options", "Name": "options", "Value": "noatime,nodiratime"}]}, {"Id": "vip_sapdata_nfs", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "vip_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "vip_sapdata_nfs-instance_attributes-ip", "Name": "ip", "Value": "10.90.1.33"}, {"Id": "vip_sapdata_nfs-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "32"}, {"Id": "vip_sapdata_nfs-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "exportfs_work_sapdata", "Type": "exportfs", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "exportfs_work_sapdata-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "exportfs_work_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWQ"}, {"Id": "exportfs_work_sapdata-instance_attributes-fsid", "Name": "fsid", "Value": "1"}, {"Id": "exportfs_work_sapdata-instance_attributes-options", "Name": "options", "Value": "rw,no_root_squash"}, {"Id": "exportfs_work_sapdata-instance_attributes-clientspec", "Name": "clientspec", "Value": "*"}, {"Id": "exportfs_work_sapdata-instance_attributes-wait_for_leasetime_on_stop", "Name": "wait_for_leasetime_on_stop", "Value": "true"}]}, {"Id": "rsc_socat_sapdata_nfs", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_sapdata_nfs-instance_attributes-port", "Name": "port", "Value": "61000"}]}]}], "Masters": [{"Id": "ms_sapdata", "Primitive": {"Id": "drbd-sapdata", "Type": "drbd", "Class": "ocf", "Provider": "linbit", "Operations": [{"Id": "drbd-sapdata-monitor-15", "Name": "monitor", "Role": "Master", "Timeout": "", "Interval": "15"}, {"Id": "drbd-sapdata-monitor-30", "Name": "monitor", "Role": "Slave", "Timeout": "", "Interval": "30"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "drbd-sapdata-instance_attributes-drbd_resource", "Name": "drbd_resource", "Value": "sapdata"}]}, "MetaAttributes": [{"Id": "ms_sapdata-meta_attributes-master-max", "Name": "master-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-master-node-max", "Name": "master-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-0-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "ms_sapdata-meta_attributes-0-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-1-notify", "Name": "notify", "Value": "true"}, {"Id": "ms_sapdata-meta_attributes-1-target-role", "Name": "target-role", "Value": "Started"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:c1c003f5-4e45-4d6f-8d81-e338f666365c", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "f5991966-5a7f-45d6-90d1-bfcedb265df6", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmdrbdqas01", "Status": "clear"}, {"Id": 1, "Name": "vmdrbdqas02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:c1c003f5-4e45-4d6f-8d81-e338f666365c", "Status": "healthy"}]}, "Name": "drbd_cluster", "Crmmon": {"Nodes": [{"DC": false, "Id": "1", "Name": "vmdrbdqas01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 7}, {"DC": true, "Id": "2", "Name": "vmdrbdqas02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}], "Clones": [{"Id": "ms_sapdata", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "drbd-sapdata", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Master", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "drbd-sapdata", "Node": {"Id": "2", "Name": "vmdrbdqas02", "Cached": true}, "Role": "Slave", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": true, "FailureIgnored": false}, {"Id": "cl-nfsserver", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "nfsserver", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "nfsserver", "Node": {"Id": "2", "Name": "vmdrbdqas02", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g-nfs_sapdata", "Resources": [{"Id": "fs_sapdata", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "vip_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "exportfs_work_sapdata", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:exportfs", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 12:20:56 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmdrbdqas01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmdrbdqas01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "fs_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "vip_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "exportfs_work_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmdrbdqas02", "ResourceHistory": [{"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmdrbdqas01", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}, {"Name": "vmdrbdqas02", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}]}}, "Provider": "azure"}	2024-04-09 15:08:19.581055	2024-04-09 15:08:19.581055
236	0a055c90-4cb6-54ce-ac9c-ae3fedaf40d4	ha_cluster_discovery	{"DC": false, "Id": "04b8f8c21f9fd8991224478e8c4362f8", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmhdbdev01", "InstanceAttributes": [{"Id": "nodes-1-lpa_hdd_lpt", "Name": "lpa_hdd_lpt", "Value": "10"}, {"Id": "nodes-1-hana_hdd_vhost", "Name": "hana_hdd_vhost", "Value": "vmhdbdev01"}, {"Id": "nodes-1-hana_hdd_site", "Name": "hana_hdd_site", "Value": "NBG"}, {"Id": "nodes-1-hana_hdd_op_mode", "Name": "hana_hdd_op_mode", "Value": "logreplay"}, {"Id": "nodes-1-hana_hdd_srmode", "Name": "hana_hdd_srmode", "Value": "sync"}, {"Id": "nodes-1-hana_hdd_remoteHost", "Name": "hana_hdd_remoteHost", "Value": "vmhdbdev02"}]}, {"Id": "2", "Uname": "vmhdbdev02", "InstanceAttributes": [{"Id": "nodes-2-lpa_hdd_lpt", "Name": "lpa_hdd_lpt", "Value": "1643125026"}, {"Id": "nodes-2-hana_hdd_op_mode", "Name": "hana_hdd_op_mode", "Value": "logreplay"}, {"Id": "nodes-2-hana_hdd_vhost", "Name": "hana_hdd_vhost", "Value": "vmhdbdev02"}, {"Id": "nodes-2-hana_hdd_remoteHost", "Name": "hana_hdd_remoteHost", "Value": "vmhdbdev01"}, {"Id": "nodes-2-hana_hdd_site", "Name": "hana_hdd_site", "Value": "WDF"}, {"Id": "nodes-2-hana_hdd_srmode", "Name": "hana_hdd_srmode", "Value": "sync"}]}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "hana_cluster_1"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}, {"Id": "SAPHanaSR-hana_hdd_site_srHook_WDF", "Name": "hana_hdd_site_srHook_WDF", "Value": "PRIM"}]}, "Resources": {"Clones": [{"Id": "cln_SAPHanaTopology_HDD_HDB10", "Primitive": {"Id": "rsc_SAPHanaTopology_HDD_HDB10", "Type": "SAPHanaTopology", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHanaTopology_HDD_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "600", "Interval": "10"}, {"Id": "rsc_SAPHanaTopology_HDD_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "600", "Interval": "0"}, {"Id": "rsc_SAPHanaTopology_HDD_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "300", "Interval": "0"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHanaTopology_HDD_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDD"}, {"Id": "rsc_SAPHanaTopology_HDD_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}]}, "MetaAttributes": [{"Id": "cln_SAPHanaTopology_HDD_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "cln_SAPHanaTopology_HDD_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g_ip_HDD_HDB10", "Primitives": [{"Id": "rsc_ip_HDD_HDB10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_HDD_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDD_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDD_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_HDD_HDB10-instance_attributes-ip", "Name": "ip", "Value": "10.100.1.13"}, {"Id": "rsc_ip_HDD_HDB10-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "24"}, {"Id": "rsc_ip_HDD_HDB10-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "rsc_socat_HDD_HDB10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_HDD_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_HDD_HDB10-instance_attributes-port", "Name": "port", "Value": "62510"}]}]}], "Masters": [{"Id": "msl_SAPHana_HDD_HDB10", "Primitive": {"Id": "rsc_SAPHana_HDD_HDB10", "Type": "SAPHana", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHana_HDD_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDD_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDD_HDB10-promote-0", "Name": "promote", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDD_HDB10-monitor-60", "Name": "monitor", "Role": "Master", "Timeout": "700", "Interval": "60"}, {"Id": "rsc_SAPHana_HDD_HDB10-monitor-61", "Name": "monitor", "Role": "Slave", "Timeout": "700", "Interval": "61"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDD"}, {"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}, {"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-PREFER_SITE_TAKEOVER", "Name": "PREFER_SITE_TAKEOVER", "Value": "True"}, {"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-AUTOMATED_REGISTER", "Name": "AUTOMATED_REGISTER", "Value": "False"}, {"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-DUPLICATE_PRIMARY_TIMEOUT", "Name": "DUPLICATE_PRIMARY_TIMEOUT", "Value": "7200"}]}, "MetaAttributes": [{"Id": "msl_SAPHana_HDD_HDB10-meta_attributes-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "msl_SAPHana_HDD_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "msl_SAPHana_HDD_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": [{"Id": "stonith-sbd-monitor-15", "Name": "monitor", "Role": "", "Timeout": "15", "Interval": "15"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "15"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:182cb1b1-a815-4b82-b538-7a166b9bbb4a", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "cc39771e-ea2f-4fb1-8968-a6176aee3d0a", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmhdbdev01", "Status": "clear"}, {"Id": 1, "Name": "vmhdbdev02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:182cb1b1-a815-4b82-b538-7a166b9bbb4a", "Status": "healthy"}]}, "Name": "hana_cluster_1", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmhdbdev01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}, {"DC": false, "Id": "2", "Name": "vmhdbdev02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 4}], "Clones": [{"Id": "msl_SAPHana_HDD_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHana_HDD_HDB10", "Node": {"Id": "2", "Name": "vmhdbdev02", "Cached": true}, "Role": "Master", "Agent": "ocf::suse:SAPHana", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHana_HDD_HDB10", "Node": null, "Role": "Stopped", "Agent": "ocf::suse:SAPHana", "Active": false, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 0}], "MultiState": true, "FailureIgnored": false}, {"Id": "cln_SAPHanaTopology_HDD_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHanaTopology_HDD_HDB10", "Node": {"Id": "2", "Name": "vmhdbdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHanaTopology_HDD_HDB10", "Node": {"Id": "1", "Name": "vmhdbdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g_ip_HDD_HDB10", "Resources": [{"Id": "rsc_ip_HDD_HDB10", "Node": {"Id": "2", "Name": "vmhdbdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_HDD_HDB10", "Node": {"Id": "2", "Name": "vmhdbdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 7, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 25 15:37:06 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmhdbdev01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmhdbdev02", "ResourceHistory": [{"Name": "rsc_ip_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHana_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmhdbdev01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_ip_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHana_HDD_HDB10", "FailCount": 1000000, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmhdbdev01", "Attributes": [{"Name": "hana_hdd_clone_state", "Value": "UNDEFINED"}, {"Name": "hana_hdd_op_mode", "Value": "logreplay"}, {"Name": "hana_hdd_remoteHost", "Value": "vmhdbdev02"}, {"Name": "hana_hdd_roles", "Value": "1:P:master1::worker:"}, {"Name": "hana_hdd_site", "Value": "NBG"}, {"Name": "hana_hdd_srmode", "Value": "sync"}, {"Name": "hana_hdd_sync_state", "Value": "SFAIL"}, {"Name": "hana_hdd_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdd_vhost", "Value": "vmhdbdev01"}, {"Name": "lpa_hdd_lpt", "Value": "10"}, {"Name": "master-rsc_SAPHana_HDD_HDB10", "Value": "-9000"}]}, {"Name": "vmhdbdev02", "Attributes": [{"Name": "hana_hdd_clone_state", "Value": "PROMOTED"}, {"Name": "hana_hdd_op_mode", "Value": "logreplay"}, {"Name": "hana_hdd_remoteHost", "Value": "vmhdbdev01"}, {"Name": "hana_hdd_roles", "Value": "4:P:master1:master:worker:master"}, {"Name": "hana_hdd_site", "Value": "WDF"}, {"Name": "hana_hdd_srmode", "Value": "sync"}, {"Name": "hana_hdd_sync_state", "Value": "PRIM"}, {"Name": "hana_hdd_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdd_vhost", "Value": "vmhdbdev02"}, {"Name": "lpa_hdd_lpt", "Value": "1643125026"}, {"Name": "master-rsc_SAPHana_HDD_HDB10", "Value": "150"}]}]}}, "Provider": "azure"}	2024-04-09 15:08:20.741074	2024-04-09 15:08:20.741074
242	a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12	sap_system_discovery	[{"Id": "97a1e70aeff3c0685d65c4c3d32d533b", "SID": "NWP", "Type": 2, "Profile": {"SAPDBHOST": "10.80.1.13", "dbms/name": "HDP", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwpas", "rdisp/msserv": "sapmsNWP", "SAPGLOBALHOST": "sapnwpas", "SAPSYSTEMNAME": "NWP", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDP", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwpas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.80.1.13", "Databases": null, "Instances": [{"Host": "vmnwprd03", "Name": "D01", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwpas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwper", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwppas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwpaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 9752, "name": "gwrd", "starttime": "2022 01 11 13:44:51", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Gateway", "elapsedtime": "151:07:13"}, {"pid": 9753, "name": "icman", "starttime": "2022 01 11 13:44:51", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "ICM", "elapsedtime": "151:07:13"}, {"pid": 9732, "name": "igswd_mt", "starttime": "2022 01 11 13:44:49", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "IGS Watchdog", "elapsedtime": "151:07:15"}, {"pid": 9731, "name": "disp+work", "starttime": "2022 01 11 13:44:49", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Dispatcher", "elapsedtime": "151:07:15"}], "Properties": [{"value": "HTTP://sapnwppas:0/sap/admin/public/index.html", "property": "ICM", "propertytype": "NodeURL"}, {"value": "http://sapnwppas:40180", "property": "IGS", "propertytype": "NodeURL"}, {"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "ICMGetCacheEntries", "property": "ICM Cache", "propertytype": "NodeWebmethod"}, {"value": "01", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetThreadList", "property": "ICM Threads", "propertytype": "NodeWebmethod"}, {"value": "GetAlertTree", "property": "Open Alerts", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwppas", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "ABAPGetWPTable", "property": "ABAP WP Table", "propertytype": "NodeWebmethod"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "D01", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWP", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "GetAlertTree", "property": "Current Status", "propertytype": "NodeWebmethod"}, {"value": "GWGetClientList", "property": "Gateway Clients", "propertytype": "NodeWebmethod"}, {"value": "ICMGetConnectionList", "property": "ICM Connections", "propertytype": "NodeWebmethod"}, {"value": "GetQueueStatistic", "property": "Queue Statistic", "propertytype": "NodeWebmethod"}, {"value": "GWGetConnectionList", "property": "Gateway Connections", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetProxyConnectionList", "property": "ICM Proxy Connections", "propertytype": "NodeWebmethod"}, {"value": "http://sapnwppas:50113/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:08:21.495543	2024-04-09 15:08:21.495543
245	240f96b1-8d26-53b7-9e99-ffb0f2e735bf	ha_cluster_discovery	{"DC": false, "Id": "04a81f89c847e82390e35bece2e25c9b", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmdrbddev01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmdrbddev02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "drbd_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": [{"Id": "cl-nfsserver", "Primitive": {"Id": "nfsserver", "Type": "nfs-server", "Class": "systemd", "Provider": "", "Operations": [{"Id": "nfsserver-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": null}, "MetaAttributes": [{"Id": "cl-nfsserver-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g-nfs_sapdata", "Primitives": [{"Id": "fs_sapdata", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "fs_sapdata-monitor-20", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "fs_sapdata-instance_attributes-device", "Name": "device", "Value": "/dev/drbd1"}, {"Id": "fs_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWD"}, {"Id": "fs_sapdata-instance_attributes-fstype", "Name": "fstype", "Value": "xfs"}, {"Id": "fs_sapdata-instance_attributes-options", "Name": "options", "Value": "noatime,nodiratime"}]}, {"Id": "vip_sapdata_nfs", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "vip_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "vip_sapdata_nfs-instance_attributes-ip", "Name": "ip", "Value": "10.100.1.33"}, {"Id": "vip_sapdata_nfs-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "32"}, {"Id": "vip_sapdata_nfs-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "exportfs_work_sapdata", "Type": "exportfs", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "exportfs_work_sapdata-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "exportfs_work_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWD"}, {"Id": "exportfs_work_sapdata-instance_attributes-fsid", "Name": "fsid", "Value": "1"}, {"Id": "exportfs_work_sapdata-instance_attributes-options", "Name": "options", "Value": "rw,no_root_squash"}, {"Id": "exportfs_work_sapdata-instance_attributes-clientspec", "Name": "clientspec", "Value": "*"}, {"Id": "exportfs_work_sapdata-instance_attributes-wait_for_leasetime_on_stop", "Name": "wait_for_leasetime_on_stop", "Value": "true"}]}, {"Id": "rsc_socat_sapdata_nfs", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_sapdata_nfs-instance_attributes-port", "Name": "port", "Value": "61000"}]}]}], "Masters": [{"Id": "ms_sapdata", "Primitive": {"Id": "drbd-sapdata", "Type": "drbd", "Class": "ocf", "Provider": "linbit", "Operations": [{"Id": "drbd-sapdata-monitor-15", "Name": "monitor", "Role": "Master", "Timeout": "", "Interval": "15"}, {"Id": "drbd-sapdata-monitor-30", "Name": "monitor", "Role": "Slave", "Timeout": "", "Interval": "30"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "drbd-sapdata-instance_attributes-drbd_resource", "Name": "drbd_resource", "Value": "sapdata"}]}, "MetaAttributes": [{"Id": "ms_sapdata-meta_attributes-master-max", "Name": "master-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-master-node-max", "Name": "master-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-0-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "ms_sapdata-meta_attributes-0-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-1-notify", "Name": "notify", "Value": "true"}, {"Id": "ms_sapdata-meta_attributes-1-target-role", "Name": "target-role", "Value": "Started"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:3947fa28-25e0-46d4-bbed-89ce88f977f1", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "27016e64-5f07-4563-90d5-16cb8f9ebc2a", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmdrbddev01", "Status": "clear"}, {"Id": 1, "Name": "vmdrbddev02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:3947fa28-25e0-46d4-bbed-89ce88f977f1", "Status": "healthy"}]}, "Name": "drbd_cluster", "Crmmon": {"Nodes": [{"DC": false, "Id": "1", "Name": "vmdrbddev01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 7}, {"DC": true, "Id": "2", "Name": "vmdrbddev02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}], "Clones": [{"Id": "ms_sapdata", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "drbd-sapdata", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Master", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "drbd-sapdata", "Node": {"Id": "2", "Name": "vmdrbddev02", "Cached": true}, "Role": "Slave", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": true, "FailureIgnored": false}, {"Id": "cl-nfsserver", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "nfsserver", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "nfsserver", "Node": {"Id": "2", "Name": "vmdrbddev02", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g-nfs_sapdata", "Resources": [{"Id": "fs_sapdata", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "vip_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "exportfs_work_sapdata", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:exportfs", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 12:50:53 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmdrbddev01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "fs_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "vip_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "exportfs_work_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmdrbddev02", "ResourceHistory": [{"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmdrbddev01", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}, {"Name": "vmdrbddev02", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}]}}, "Provider": "azure"}	2024-04-09 15:08:21.860441	2024-04-09 15:08:21.860441
253	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	ha_cluster_discovery	{"DC": false, "Id": "057f083c3be591f4398eed816d4c8cd7", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmnwdev01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmnwdev02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "netweaver_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": null, "Groups": [{"Id": "grp_NWD_ASCS00", "Primitives": [{"Id": "rsc_ip_NWD_ASCS00", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWD_ASCS00-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWD_ASCS00-instance_attributes-ip", "Name": "ip", "Value": "10.100.1.25"}]}, {"Id": "rsc_fs_NWD_ASCS00", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWD_ASCS00-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWD_ASCS00-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWD_ASCS00-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWD_ASCS00-instance_attributes-device", "Name": "device", "Value": "10.100.1.33:/NWD/ASCS"}, {"Id": "rsc_fs_NWD_ASCS00-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWD/ASCS00"}, {"Id": "rsc_fs_NWD_ASCS00-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWD_ASCS00", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWD_ASCS00-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWD_ASCS00-meta_attributes-resource-stickiness", "Name": "resource-stickiness", "Value": "5000"}, {"Id": "rsc_sap_NWD_ASCS00-meta_attributes-failure-timeout", "Name": "failure-timeout", "Value": "60"}, {"Id": "rsc_sap_NWD_ASCS00-meta_attributes-migration-threshold", "Name": "migration-threshold", "Value": "1"}, {"Id": "rsc_sap_NWD_ASCS00-meta_attributes-priority", "Name": "priority", "Value": "10"}], "InstanceAttributes": [{"Id": "rsc_sap_NWD_ASCS00-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWD_ASCS00_sapnwdas"}, {"Id": "rsc_sap_NWD_ASCS00-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWD/profile/NWD_ASCS00_sapnwdas"}, {"Id": "rsc_sap_NWD_ASCS00-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}]}, {"Id": "rsc_socat_NWD_ASCS00", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWD_ASCS00-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWD_ASCS00-instance_attributes-port", "Name": "port", "Value": "62000"}]}]}, {"Id": "grp_NWD_ERS10", "Primitives": [{"Id": "rsc_ip_NWD_ERS10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWD_ERS10-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWD_ERS10-instance_attributes-ip", "Name": "ip", "Value": "10.100.1.26"}]}, {"Id": "rsc_fs_NWD_ERS10", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWD_ERS10-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWD_ERS10-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWD_ERS10-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWD_ERS10-instance_attributes-device", "Name": "device", "Value": "10.100.1.33:/NWD/ERS"}, {"Id": "rsc_fs_NWD_ERS10-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWD/ERS10"}, {"Id": "rsc_fs_NWD_ERS10-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWD_ERS10", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWD_ERS10-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWD_ERS10-meta_attributes-priority", "Name": "priority", "Value": "1000"}], "InstanceAttributes": [{"Id": "rsc_sap_NWD_ERS10-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWD_ERS10_sapnwder"}, {"Id": "rsc_sap_NWD_ERS10-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWD/profile/NWD_ERS10_sapnwder"}, {"Id": "rsc_sap_NWD_ERS10-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}, {"Id": "rsc_sap_NWD_ERS10-instance_attributes-IS_ERS", "Name": "IS_ERS", "Value": "true"}]}, {"Id": "rsc_socat_NWD_ERS10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWD_ERS10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWD_ERS10-instance_attributes-port", "Name": "port", "Value": "62110"}]}]}], "Masters": null, "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": [{"Id": "loc_sap_NWD_failover_to_ers", "Node": "", "Role": "", "Score": "", "Resource": "rsc_sap_NWD_ASCS00"}]}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-36001405f01eb5f4c5c941e499beb055d", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "4e8adda1-da35-4ee4-92b9-a134494861f0", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmnwdev01", "Status": "clear"}, {"Id": 1, "Name": "vmnwdev02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-36001405f01eb5f4c5c941e499beb055d", "Status": "healthy"}]}, "Name": "netweaver_cluster", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmnwdev01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 5}, {"DC": false, "Id": "2", "Name": "vmnwdev02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 4}], "Clones": null, "Groups": [{"Id": "grp_NWD_ASCS00", "Resources": [{"Id": "rsc_ip_NWD_ASCS00", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWD_ASCS00", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWD_ASCS00", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWD_ASCS00", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}, {"Id": "grp_NWD_ERS10", "Resources": [{"Id": "rsc_ip_NWD_ERS10", "Node": {"Id": "2", "Name": "vmnwdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWD_ERS10", "Node": {"Id": "2", "Name": "vmnwdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWD_ERS10", "Node": {"Id": "2", "Name": "vmnwdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWD_ERS10", "Node": {"Id": "2", "Name": "vmnwdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 12:55:06 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmnwdev01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWD_ASCS00", "FailCount": 0, "MigrationThreshold": 1}, {"Name": "rsc_socat_NWD_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_ip_NWD_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWD_ASCS00", "FailCount": 0, "MigrationThreshold": 3}]}, {"Name": "vmnwdev02", "ResourceHistory": [{"Name": "rsc_ip_NWD_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWD_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWD_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_socat_NWD_ERS10", "FailCount": 0, "MigrationThreshold": 3}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmnwdev02", "Attributes": [{"Name": "runs_ers_NWD", "Value": "1"}]}]}}, "Provider": "azure"}	2024-04-09 15:08:22.94856	2024-04-09 15:08:22.94856
258	21de186a-e38f-5804-b643-7f4ef22fecfd	ha_cluster_discovery	{"DC": true, "Id": "04a81f89c847e82390e35bece2e25c9b", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmdrbddev01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmdrbddev02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "drbd_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": [{"Id": "cl-nfsserver", "Primitive": {"Id": "nfsserver", "Type": "nfs-server", "Class": "systemd", "Provider": "", "Operations": [{"Id": "nfsserver-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": null}, "MetaAttributes": [{"Id": "cl-nfsserver-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g-nfs_sapdata", "Primitives": [{"Id": "fs_sapdata", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "fs_sapdata-monitor-20", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "fs_sapdata-instance_attributes-device", "Name": "device", "Value": "/dev/drbd1"}, {"Id": "fs_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWD"}, {"Id": "fs_sapdata-instance_attributes-fstype", "Name": "fstype", "Value": "xfs"}, {"Id": "fs_sapdata-instance_attributes-options", "Name": "options", "Value": "noatime,nodiratime"}]}, {"Id": "vip_sapdata_nfs", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "vip_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "vip_sapdata_nfs-instance_attributes-ip", "Name": "ip", "Value": "10.100.1.33"}, {"Id": "vip_sapdata_nfs-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "32"}, {"Id": "vip_sapdata_nfs-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "exportfs_work_sapdata", "Type": "exportfs", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "exportfs_work_sapdata-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "exportfs_work_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWD"}, {"Id": "exportfs_work_sapdata-instance_attributes-fsid", "Name": "fsid", "Value": "1"}, {"Id": "exportfs_work_sapdata-instance_attributes-options", "Name": "options", "Value": "rw,no_root_squash"}, {"Id": "exportfs_work_sapdata-instance_attributes-clientspec", "Name": "clientspec", "Value": "*"}, {"Id": "exportfs_work_sapdata-instance_attributes-wait_for_leasetime_on_stop", "Name": "wait_for_leasetime_on_stop", "Value": "true"}]}, {"Id": "rsc_socat_sapdata_nfs", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_sapdata_nfs-instance_attributes-port", "Name": "port", "Value": "61000"}]}]}], "Masters": [{"Id": "ms_sapdata", "Primitive": {"Id": "drbd-sapdata", "Type": "drbd", "Class": "ocf", "Provider": "linbit", "Operations": [{"Id": "drbd-sapdata-monitor-15", "Name": "monitor", "Role": "Master", "Timeout": "", "Interval": "15"}, {"Id": "drbd-sapdata-monitor-30", "Name": "monitor", "Role": "Slave", "Timeout": "", "Interval": "30"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "drbd-sapdata-instance_attributes-drbd_resource", "Name": "drbd_resource", "Value": "sapdata"}]}, "MetaAttributes": [{"Id": "ms_sapdata-meta_attributes-master-max", "Name": "master-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-master-node-max", "Name": "master-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-0-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "ms_sapdata-meta_attributes-0-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-1-notify", "Name": "notify", "Value": "true"}, {"Id": "ms_sapdata-meta_attributes-1-target-role", "Name": "target-role", "Value": "Started"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:3947fa28-25e0-46d4-bbed-89ce88f977f1", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "27016e64-5f07-4563-90d5-16cb8f9ebc2a", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmdrbddev01", "Status": "clear"}, {"Id": 1, "Name": "vmdrbddev02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:3947fa28-25e0-46d4-bbed-89ce88f977f1", "Status": "healthy"}]}, "Name": "drbd_cluster", "Crmmon": {"Nodes": [{"DC": false, "Id": "1", "Name": "vmdrbddev01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 7}, {"DC": true, "Id": "2", "Name": "vmdrbddev02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}], "Clones": [{"Id": "ms_sapdata", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "drbd-sapdata", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Master", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "drbd-sapdata", "Node": {"Id": "2", "Name": "vmdrbddev02", "Cached": true}, "Role": "Slave", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": true, "FailureIgnored": false}, {"Id": "cl-nfsserver", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "nfsserver", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "nfsserver", "Node": {"Id": "2", "Name": "vmdrbddev02", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g-nfs_sapdata", "Resources": [{"Id": "fs_sapdata", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "vip_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "exportfs_work_sapdata", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:exportfs", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 12:50:53 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmdrbddev01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmdrbddev01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "fs_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "vip_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "exportfs_work_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmdrbddev02", "ResourceHistory": [{"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmdrbddev01", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}, {"Name": "vmdrbddev02", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}]}}, "Provider": "azure"}	2024-04-09 15:08:23.667223	2024-04-09 15:08:23.667223
275	13e8c25c-3180-5a9a-95c8-51ec38e50cfc	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmhdbdev01", "plan": {}, "tags": "fake-tags", "vmId": "a187496f-69bd-48fa-81a4-749e51f08b8b", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_E4s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmhdbdev01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmhdbdev01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmhdbdev01-Data01", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "1", "vhd": {"uri": ""}, "name": "disk-vmhdbdev01-Data02", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "2", "vhd": {"uri": ""}, "name": "disk-vmhdbdev01-Data03", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "3", "vhd": {"uri": ""}, "name": "disk-vmhdbdev01-Data04", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "4", "vhd": {"uri": ""}, "name": "disk-vmhdbdev01-Data05", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "5", "vhd": {"uri": ""}, "name": "disk-vmhdbdev01-Data06", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "6", "vhd": {"uri": ""}, "name": "disk-vmhdbdev01-Data07", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.100.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.100.1.11"}]}, "ipv6": {}, "macAddress": "6045BD8D9B69"}]}}, "Provider": "azure"}	2024-04-09 15:08:25.949502	2024-04-09 15:08:25.949502
282	69f4dcbb-efa2-5a16-8bc8-01df7dbb7384	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:08:26.908505	2024-04-09 15:08:26.908505
296	a09d9cf3-46c1-505c-8fb8-4b0a71a9114e	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:08:28.714096	2024-04-09 15:08:28.714096
212	ddcb7992-2ffb-5c10-8b39-80685f6eaaba	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmdrbdqas01", "plan": {}, "tags": "fake-tags", "vmId": "9c5b4666-5356-4347-b688-6954027283a1", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmdrbdqas01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmdrbdqas01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmdrbdqas01-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Standard_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.90.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.90.1.31"}]}, "ipv6": {}, "macAddress": "6045BD8D00C2"}]}}, "Provider": "azure"}	2024-04-09 15:08:17.654465	2024-04-09 15:08:17.654465
213	4b30a6af-4b52-5bda-bccb-f2248a12c992	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:08:17.786744	2024-04-09 15:08:17.786744
214	b767b3e9-e802-587e-a442-541d093b86b9	ha_cluster_discovery	{"DC": false, "Id": "9c832998801e28cd70ad77380e82a5c0", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmhdbprd01", "InstanceAttributes": [{"Id": "nodes-1-lpa_hdp_lpt", "Name": "lpa_hdp_lpt", "Value": "1643125019"}, {"Id": "nodes-1-hana_hdp_vhost", "Name": "hana_hdp_vhost", "Value": "vmhdbprd01"}, {"Id": "nodes-1-hana_hdp_site", "Name": "hana_hdp_site", "Value": "NBG"}, {"Id": "nodes-1-hana_hdp_op_mode", "Name": "hana_hdp_op_mode", "Value": "logreplay"}, {"Id": "nodes-1-hana_hdp_srmode", "Name": "hana_hdp_srmode", "Value": "sync"}, {"Id": "nodes-1-hana_hdp_remoteHost", "Name": "hana_hdp_remoteHost", "Value": "vmhdbprd02"}]}, {"Id": "2", "Uname": "vmhdbprd02", "InstanceAttributes": [{"Id": "nodes-2-lpa_hdp_lpt", "Name": "lpa_hdp_lpt", "Value": "30"}, {"Id": "nodes-2-hana_hdp_op_mode", "Name": "hana_hdp_op_mode", "Value": "logreplay"}, {"Id": "nodes-2-hana_hdp_vhost", "Name": "hana_hdp_vhost", "Value": "vmhdbprd02"}, {"Id": "nodes-2-hana_hdp_remoteHost", "Name": "hana_hdp_remoteHost", "Value": "vmhdbprd01"}, {"Id": "nodes-2-hana_hdp_site", "Name": "hana_hdp_site", "Value": "WDF"}, {"Id": "nodes-2-hana_hdp_srmode", "Name": "hana_hdp_srmode", "Value": "sync"}]}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "hana_cluster_3"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "24"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}, {"Id": "SAPHanaSR-hana_hdp_site_srHook_WDF", "Name": "hana_hdp_site_srHook_WDF", "Value": "SOK"}]}, "Resources": {"Clones": [{"Id": "cln_SAPHanaTopology_HDP_HDB10", "Primitive": {"Id": "rsc_SAPHanaTopology_HDP_HDB10", "Type": "SAPHanaTopology", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHanaTopology_HDP_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "600", "Interval": "10"}, {"Id": "rsc_SAPHanaTopology_HDP_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "600", "Interval": "0"}, {"Id": "rsc_SAPHanaTopology_HDP_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "300", "Interval": "0"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHanaTopology_HDP_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDP"}, {"Id": "rsc_SAPHanaTopology_HDP_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}]}, "MetaAttributes": [{"Id": "cln_SAPHanaTopology_HDP_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "cln_SAPHanaTopology_HDP_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g_ip_HDP_HDB10", "Primitives": [{"Id": "rsc_ip_HDP_HDB10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_HDP_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDP_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDP_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_HDP_HDB10-instance_attributes-ip", "Name": "ip", "Value": "10.80.1.13"}, {"Id": "rsc_ip_HDP_HDB10-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "24"}, {"Id": "rsc_ip_HDP_HDB10-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "rsc_socat_HDP_HDB10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_HDP_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_HDP_HDB10-instance_attributes-port", "Name": "port", "Value": "62510"}]}]}], "Masters": [{"Id": "msl_SAPHana_HDP_HDB10", "Primitive": {"Id": "rsc_SAPHana_HDP_HDB10", "Type": "SAPHana", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHana_HDP_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDP_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDP_HDB10-promote-0", "Name": "promote", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDP_HDB10-monitor-60", "Name": "monitor", "Role": "Master", "Timeout": "700", "Interval": "60"}, {"Id": "rsc_SAPHana_HDP_HDB10-monitor-61", "Name": "monitor", "Role": "Slave", "Timeout": "700", "Interval": "61"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDP"}, {"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}, {"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-PREFER_SITE_TAKEOVER", "Name": "PREFER_SITE_TAKEOVER", "Value": "True"}, {"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-AUTOMATED_REGISTER", "Name": "AUTOMATED_REGISTER", "Value": "False"}, {"Id": "rsc_SAPHana_HDP_HDB10-instance_attributes-DUPLICATE_PRIMARY_TIMEOUT", "Name": "DUPLICATE_PRIMARY_TIMEOUT", "Value": "7200"}]}, "MetaAttributes": [{"Id": "msl_SAPHana_HDP_HDB10-meta_attributes-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "msl_SAPHana_HDP_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "msl_SAPHana_HDP_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": [{"Id": "stonith-sbd-monitor-15", "Name": "monitor", "Role": "", "Timeout": "15", "Interval": "15"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "15"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b924e77", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "a7a18c6b-7c8e-4bda-bb77-45e4b5dc8478", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmhdbprd01", "Status": "clear"}, {"Id": 1, "Name": "vmhdbprd02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_8d286026-c3a6-4404-90ac-f2549b924e77", "Status": "healthy"}]}, "Name": "hana_cluster_3", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmhdbprd01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 5}, {"DC": false, "Id": "2", "Name": "vmhdbprd02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}], "Clones": [{"Id": "msl_SAPHana_HDP_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHana_HDP_HDB10", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Master", "Agent": "ocf::suse:SAPHana", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHana_HDP_HDB10", "Node": {"Id": "2", "Name": "vmhdbprd02", "Cached": true}, "Role": "Slave", "Agent": "ocf::suse:SAPHana", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": true, "FailureIgnored": false}, {"Id": "cln_SAPHanaTopology_HDP_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHanaTopology_HDP_HDB10", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHanaTopology_HDP_HDB10", "Node": {"Id": "2", "Name": "vmhdbprd02", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g_ip_HDP_HDB10", "Resources": [{"Id": "rsc_ip_HDP_HDB10", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_HDP_HDB10", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 7, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 25 15:36:59 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmhdbprd01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmhdbprd01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_ip_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHana_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmhdbprd02", "ResourceHistory": [{"Name": "rsc_SAPHana_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDP_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmhdbprd01", "Attributes": [{"Name": "hana_hdp_clone_state", "Value": "PROMOTED"}, {"Name": "hana_hdp_op_mode", "Value": "logreplay"}, {"Name": "hana_hdp_remoteHost", "Value": "vmhdbprd02"}, {"Name": "hana_hdp_roles", "Value": "4:P:master1:master:worker:master"}, {"Name": "hana_hdp_site", "Value": "NBG"}, {"Name": "hana_hdp_srmode", "Value": "sync"}, {"Name": "hana_hdp_sync_state", "Value": "PRIM"}, {"Name": "hana_hdp_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdp_vhost", "Value": "vmhdbprd01"}, {"Name": "lpa_hdp_lpt", "Value": "1643125019"}, {"Name": "master-rsc_SAPHana_HDP_HDB10", "Value": "150"}]}, {"Name": "vmhdbprd02", "Attributes": [{"Name": "hana_hdp_clone_state", "Value": "DEMOTED"}, {"Name": "hana_hdp_op_mode", "Value": "logreplay"}, {"Name": "hana_hdp_remoteHost", "Value": "vmhdbprd01"}, {"Name": "hana_hdp_roles", "Value": "4:S:master1:master:worker:master"}, {"Name": "hana_hdp_site", "Value": "WDF"}, {"Name": "hana_hdp_srmode", "Value": "sync"}, {"Name": "hana_hdp_sync_state", "Value": "SOK"}, {"Name": "hana_hdp_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdp_vhost", "Value": "vmhdbprd02"}, {"Name": "lpa_hdp_lpt", "Value": "30"}, {"Name": "master-rsc_SAPHana_HDP_HDB10", "Value": "100"}]}]}}, "Provider": "azure"}	2024-04-09 15:08:17.927443	2024-04-09 15:08:17.927443
216	9a3ec76a-dd4f-5013-9cf0-5eb4cf89898f	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:08:18.191731	2024-04-09 15:08:18.191731
217	9cd46919-5f19-59aa-993e-cf3736c71053	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmhdbprd01", "plan": {}, "tags": "fake-tags", "vmId": "ee7cf44b-d202-4680-b331-1b3996f2f0e7", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_E4s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmhdbprd01", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data01", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "1", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data02", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "2", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data03", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "3", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data04", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "4", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data05", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "5", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data06", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}, {"lun": "6", "vhd": {"uri": ""}, "name": "disk-vmhdbprd01-Data07", "image": {"uri": ""}, "caching": "None", "diskSizeGB": "128", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "1", "platformUpdateDomain": "1", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.11"}]}, "ipv6": {}, "macAddress": "000D3A232C6B"}]}}, "Provider": "azure"}	2024-04-09 15:08:18.305731	2024-04-09 15:08:18.305731
218	e0c182db-32ff-55c6-a9eb-2b82dd21bc8b	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:08:18.425211	2024-04-09 15:08:18.425211
219	7269ee51-5007-5849-aaa7-7c4a98b0c9ce	sap_system_discovery	[{"Id": "a1e80e3e152a903662f7882fb3f8a851", "SID": "NWD", "Type": 2, "Profile": {"SAPDBHOST": "10.100.1.13", "dbms/name": "HDD", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwdas", "rdisp/msserv": "sapmsNWD", "SAPGLOBALHOST": "sapnwdas", "SAPSYSTEMNAME": "NWD", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDD", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwdas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.100.1.13", "Databases": null, "Instances": [{"Host": "vmnwdev01", "Name": "ASCS00", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwdas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwder", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 7379, "name": "enserver", "starttime": "2022 01 11 12:55:17", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "EnqueueServer", "elapsedtime": "151:56:46"}, {"pid": 7378, "name": "msg_server", "starttime": "2022 01 11 12:55:17", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "MessageServer", "elapsedtime": "151:56:46"}], "Properties": [{"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "00", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "EnqGetLockTable", "property": "Enque Locks", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwdas", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "ASCS00", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWD", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "1", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "YES", "property": "CentralServices", "propertytype": "Attribute"}, {"value": "EnqGetStatistic", "property": "Enque Statistic", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://sapnwdas:50013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}, {"value": "YES", "property": "SupportsUpdateSCSInstance", "propertytype": "Attribute"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:08:18.550619	2024-04-09 15:08:18.550619
222	fb2c6b8a-9915-5969-a6b7-8b5a42de1971	sap_system_discovery	[{"Id": "a1e80e3e152a903662f7882fb3f8a851", "SID": "NWD", "Type": 2, "Profile": {"SAPDBHOST": "10.100.1.13", "dbms/name": "HDD", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwdas", "rdisp/msserv": "sapmsNWD", "SAPGLOBALHOST": "sapnwdas", "SAPSYSTEMNAME": "NWD", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDD", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwdas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.100.1.13", "Databases": null, "Instances": [{"Host": "vmnwdev02", "Name": "ERS10", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwdas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwder", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 6720, "name": "enrepserver", "starttime": "2022 01 11 12:55:17", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "EnqueueReplicator", "elapsedtime": "151:56:49"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwder", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "ERS10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWD", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.5", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://sapnwder:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:08:18.913506	2024-04-09 15:08:18.913506
223	e0c182db-32ff-55c6-a9eb-2b82dd21bc8b	sap_system_discovery	[{"Id": "9953878f07bb54cac20d5d5d7ff08af2", "SID": "HDQ", "Type": 1, "Profile": {"SAPGLOBALHOST": "vmhdbqas02", "SAPSYSTEMNAME": "HDQ", "hdbConfigType": "DEFAULT", "ssl/ciphersuites": "135:PFS:HIGH::EC_P256:EC_HIGH", "HDB_LINKED_BINARIES": "yes", "HDB_SHARED_BINARIES": "yes"}, "Databases": [{"Host": "vmhdbqas02", "User": "", "Group": "", "Active": "yes", "UserId": "", "GroupId": "", "SqlPort": "31015", "Database": "HDQ", "Container": ""}], "Instances": [{"Host": "vmhdbqas02", "Name": "HDB10", "Type": 1, "SAPControl": {"Instances": [{"features": "HDB|HDB_WORKER", "hostname": "vmhdbqas02", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.3"}], "Processes": [{"pid": 29597, "name": "hdbdaemon", "starttime": "2022 01 11 12:30:14", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Daemon", "elapsedtime": "152:21:46"}, {"pid": 30148, "name": "hdbxsengine", "starttime": "2022 01 11 12:30:27", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB XSEngine-HDQ", "elapsedtime": "152:21:33"}, {"pid": 29727, "name": "hdbnameserver", "starttime": "2022 01 11 12:30:14", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Nameserver", "elapsedtime": "152:21:46"}, {"pid": 30145, "name": "hdbindexserver", "starttime": "2022 01 11 12:30:27", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Indexserver-HDQ", "elapsedtime": "152:21:33"}, {"pid": 30047, "name": "hdbpreprocessor", "starttime": "2022 01 11 12:30:26", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Preprocessor", "elapsedtime": "152:21:34"}, {"pid": 30044, "name": "hdbcompileserver", "starttime": "2022 01 11 12:30:26", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Compileserver", "elapsedtime": "152:21:34"}, {"pid": 30855, "name": "hdbwebdispatcher", "starttime": "2022 01 11 12:30:35", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Web Dispatcher", "elapsedtime": "152:21:25"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "YES", "property": "DBServices", "propertytype": "Attribute"}, {"value": "worker", "property": "HANA Roles", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "vmhdbqas02", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "HDB10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "HDQ", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://vmhdbqas02:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": {"mode": "sync", "online": "true", "site_id": "2", "isSource": "false", "site_name": "WDF", "isConsumer": "true", "replayMode": "auto", "hasConsumers": "false", "siteTier/NBG": "1", "siteTier/WDF": "2", "operation_mode": "logreplay", "primary_masters": "vmhdbqas01", "siteMapping/NBG": "WDF", "isTakeoverActive": "false", "isPrimarySuspended": "false", "mapping/vmhdbqas02": ["WDF/vmhdbqas02", "NBG/vmhdbqas01"], "active_primary_site": "1", "isTimetravelEnabled": "false", "siteOperationMode/NBG": "primary", "siteOperationMode/WDF": "logreplay", "siteReplicationMode/NBG": "primary", "siteReplicationMode/WDF": "sync"}, "HostConfiguration": {"host": "vmhdbqas02", "hostActive": "yes", "hostStatus": "ok", "removeStatus": "", "failoverStatus": "", "hostActualRoles": "worker", "hostConfigRoles": "worker", "storagePartition": "1", "workerActualGroups": "default", "workerConfigGroups": "default", "failoverActualGroup": "default", "failoverConfigGroup": "default", "nameServerActualRole": "master", "nameServerConfigRole": "master 1", "indexServerActualRole": "master", "indexServerConfigRole": "worker", "storageActualPartition": "1", "storageConfigPartition": "1"}, "SystemReplication": {"local_site_id": "2", "site/2/SITE_NAME": "WDF", "site/2/SOURCE_SITE_ID": "1", "site/2/PRIMARY_MASTERS": "vmhdbqas01", "site/2/REPLICATION_MODE": "SYNC"}}]}]	2024-04-09 15:08:19.044408	2024-04-09 15:08:19.044408
234	927901fa-2c87-524e-b18c-3ef5187f504f	ha_cluster_discovery	{"DC": true, "Id": "238a4de1239aae2aa87433eed788b3ad", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmdrbdprd01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmdrbdprd02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "drbd_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": [{"Id": "cl-nfsserver", "Primitive": {"Id": "nfsserver", "Type": "nfs-server", "Class": "systemd", "Provider": "", "Operations": [{"Id": "nfsserver-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": null}, "MetaAttributes": [{"Id": "cl-nfsserver-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g-nfs_sapdata", "Primitives": [{"Id": "fs_sapdata", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "fs_sapdata-monitor-20", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "fs_sapdata-instance_attributes-device", "Name": "device", "Value": "/dev/drbd1"}, {"Id": "fs_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWP"}, {"Id": "fs_sapdata-instance_attributes-fstype", "Name": "fstype", "Value": "xfs"}, {"Id": "fs_sapdata-instance_attributes-options", "Name": "options", "Value": "noatime,nodiratime"}]}, {"Id": "vip_sapdata_nfs", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "vip_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "vip_sapdata_nfs-instance_attributes-ip", "Name": "ip", "Value": "10.80.1.33"}, {"Id": "vip_sapdata_nfs-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "32"}, {"Id": "vip_sapdata_nfs-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "exportfs_work_sapdata", "Type": "exportfs", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "exportfs_work_sapdata-monitor-30s", "Name": "monitor", "Role": "", "Timeout": "", "Interval": "30s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "exportfs_work_sapdata-instance_attributes-directory", "Name": "directory", "Value": "/mnt_permanent/sapdata/NWP"}, {"Id": "exportfs_work_sapdata-instance_attributes-fsid", "Name": "fsid", "Value": "1"}, {"Id": "exportfs_work_sapdata-instance_attributes-options", "Name": "options", "Value": "rw,no_root_squash"}, {"Id": "exportfs_work_sapdata-instance_attributes-clientspec", "Name": "clientspec", "Value": "*"}, {"Id": "exportfs_work_sapdata-instance_attributes-wait_for_leasetime_on_stop", "Name": "wait_for_leasetime_on_stop", "Value": "true"}]}, {"Id": "rsc_socat_sapdata_nfs", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_sapdata_nfs-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_sapdata_nfs-instance_attributes-port", "Name": "port", "Value": "61000"}]}]}], "Masters": [{"Id": "ms_sapdata", "Primitive": {"Id": "drbd-sapdata", "Type": "drbd", "Class": "ocf", "Provider": "linbit", "Operations": [{"Id": "drbd-sapdata-monitor-15", "Name": "monitor", "Role": "Master", "Timeout": "", "Interval": "15"}, {"Id": "drbd-sapdata-monitor-30", "Name": "monitor", "Role": "Slave", "Timeout": "", "Interval": "30"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "drbd-sapdata-instance_attributes-drbd_resource", "Name": "drbd_resource", "Value": "sapdata"}]}, "MetaAttributes": [{"Id": "ms_sapdata-meta_attributes-master-max", "Name": "master-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-master-node-max", "Name": "master-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-0-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "ms_sapdata-meta_attributes-0-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "ms_sapdata-meta_attributes-1-notify", "Name": "notify", "Value": "true"}, {"Id": "ms_sapdata-meta_attributes-1-target-role", "Name": "target-role", "Value": "Started"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_b7b1cd3d-776e-4432-a9e5-6fe56e4b4e17", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "28fd9d5e-3685-4cb7-85e9-76c4b140ea3c", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmdrbdprd01", "Status": "clear"}, {"Id": 1, "Name": "vmdrbdprd02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-SLIO-ORG_IBLOCK_b7b1cd3d-776e-4432-a9e5-6fe56e4b4e17", "Status": "healthy"}]}, "Name": "drbd_cluster", "Crmmon": {"Nodes": [{"DC": false, "Id": "1", "Name": "vmdrbdprd01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 7}, {"DC": true, "Id": "2", "Name": "vmdrbdprd02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}], "Clones": [{"Id": "ms_sapdata", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "drbd-sapdata", "Node": {"Id": "2", "Name": "vmdrbdprd02", "Cached": true}, "Role": "Slave", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "drbd-sapdata", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Master", "Agent": "ocf::linbit:drbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": true, "FailureIgnored": false}, {"Id": "cl-nfsserver", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "nfsserver", "Node": {"Id": "2", "Name": "vmdrbdprd02", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "nfsserver", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "systemd:nfs-server", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g-nfs_sapdata", "Resources": [{"Id": "fs_sapdata", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "vip_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "exportfs_work_sapdata", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:exportfs", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_sapdata_nfs", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 13:24:06 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmdrbdprd01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmdrbdprd02", "ResourceHistory": [{"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmdrbdprd01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "fs_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "vip_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "exportfs_work_sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_sapdata_nfs", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "drbd-sapdata", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "nfsserver", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmdrbdprd01", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}, {"Name": "vmdrbdprd02", "Attributes": [{"Name": "master-drbd-sapdata", "Value": "10000"}]}]}}, "Provider": "azure"}	2024-04-09 15:08:20.499979	2024-04-09 15:08:20.499979
244	1b0e9297-97dd-55d6-9874-8efde4d84c90	sap_system_discovery	[{"Id": "a1e80e3e152a903662f7882fb3f8a851", "SID": "NWD", "Type": 2, "Profile": {"SAPDBHOST": "10.100.1.13", "dbms/name": "HDD", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwdas", "rdisp/msserv": "sapmsNWD", "SAPGLOBALHOST": "sapnwdas", "SAPSYSTEMNAME": "NWD", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDD", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwdas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.100.1.13", "Databases": null, "Instances": [{"Host": "vmnwdev04", "Name": "D02", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwdas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwder", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwdaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 26496, "name": "gwrd", "starttime": "2022 01 11 13:05:00", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Gateway", "elapsedtime": "151:47:01"}, {"pid": 26497, "name": "icman", "starttime": "2022 01 11 13:05:00", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "ICM", "elapsedtime": "151:47:01"}, {"pid": 26476, "name": "igswd_mt", "starttime": "2022 01 11 13:04:57", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "IGS Watchdog", "elapsedtime": "151:47:04"}, {"pid": 26475, "name": "disp+work", "starttime": "2022 01 11 13:04:57", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Dispatcher", "elapsedtime": "151:47:04"}], "Properties": [{"value": "HTTP://sapnwdaas1:0/sap/admin/public/index.html", "property": "ICM", "propertytype": "NodeURL"}, {"value": "http://sapnwdaas1:40280", "property": "IGS", "propertytype": "NodeURL"}, {"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "ICMGetCacheEntries", "property": "ICM Cache", "propertytype": "NodeWebmethod"}, {"value": "02", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetThreadList", "property": "ICM Threads", "propertytype": "NodeWebmethod"}, {"value": "GetAlertTree", "property": "Open Alerts", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwdaas1", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "ABAPGetWPTable", "property": "ABAP WP Table", "propertytype": "NodeWebmethod"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "D02", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWD", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "GetAlertTree", "property": "Current Status", "propertytype": "NodeWebmethod"}, {"value": "GWGetClientList", "property": "Gateway Clients", "propertytype": "NodeWebmethod"}, {"value": "ICMGetConnectionList", "property": "ICM Connections", "propertytype": "NodeWebmethod"}, {"value": "GetQueueStatistic", "property": "Queue Statistic", "propertytype": "NodeWebmethod"}, {"value": "GWGetConnectionList", "property": "Gateway Connections", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetProxyConnectionList", "property": "ICM Proxy Connections", "propertytype": "NodeWebmethod"}, {"value": "http://sapnwdaas1:50213/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:08:21.733345	2024-04-09 15:08:21.733345
247	25677e37-fd33-5005-896c-9275b1284534	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:08:22.111661	2024-04-09 15:08:22.111661
249	1b0e9297-97dd-55d6-9874-8efde4d84c90	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:08:22.396008	2024-04-09 15:08:22.396008
250	7269ee51-5007-5849-aaa7-7c4a98b0c9ce	saptune_discovery	{"status": null, "package_version": "", "saptune_installed": false}	2024-04-09 15:08:22.51926	2024-04-09 15:08:22.51926
224	927901fa-2c87-524e-b18c-3ef5187f504f	cloud_discovery	{"Metadata": {"compute": {"sku": "gen2", "name": "vmdrbdprd02", "plan": {}, "tags": "fake-tags", "vmId": "f89fef5e-e7e3-469d-b819-a0154be6150c", "offer": "sles-sap-15-sp3-byos", "osType": "Linux", "vmSize": "Standard_D2s_v3", "version": "2021.12.19", "location": "westeurope", "provider": "Microsoft.Compute", "tagsList": [{"name": "Cost Center", "value": "00000000"}, {"name": "Department", "value": "EI"}, {"name": "Environment", "value": "Development"}, {"name": "Finance Business Partner", "value": "John Doe"}, {"name": "General Ledger Code", "value": "100000000"}, {"name": "Group", "value": "SAP Solutions"}, {"name": "Owner", "value": "John Doe"}, {"name": "Stakeholder", "value": "John Doe"}, {"name": "workspace", "value": "xxxxxxx"}], "osProfile": {"computerName": "vmdrbdprd02", "adminUsername": "cloudadmin", "disablePasswordAuthentication": "true"}, "publisher": "SUSE", "publicKeys": [{"path": "ssh-no-see", "keyData": "ssh-no-see"}], "resourceId": "/subscriptions/00000000-0000-0000-0000-000000000000", "azEnvironment": "AzurePublicCloud", "storageProfile": {"osDisk": {"vhd": {"uri": ""}, "name": "disk-vmdrbdprd02-Os", "image": {"uri": ""}, "osType": "Linux", "caching": "ReadWrite", "diskSizeGB": "30", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Premium_LRS"}, "createOption": "FromImage", "diffDiskSettings": {"option": ""}, "encryptionSettings": {"enabled": "false"}, "writeAcceleratorEnabled": "false"}, "dataDisks": [{"lun": "0", "vhd": {"uri": ""}, "name": "disk-vmdrbdprd02-Data01", "image": {"uri": ""}, "caching": "ReadWrite", "diskSizeGB": "10", "managedDisk": {"id": "/subscriptions/00000000-0000-0000-0000-000000000000", "storageAccountType": "Standard_LRS"}, "createOption": "Empty", "writeAcceleratorEnabled": "false"}], "imageReference": {"sku": "gen2", "offer": "sles-sap-15-sp3-byos", "version": "latest", "publisher": "SUSE"}}, "subscriptionId": "00000000-0000-0000-0000-000000000000", "securityProfile": {"secureBootEnabled": "false", "virtualTpmEnabled": "false"}, "resourceGroupName": "resourceGroupName", "platformFaultDomain": "0", "platformUpdateDomain": "0", "isHostCompatibilityLayerVm": "false"}, "network": {"interface": [{"ipv4": {"subnet": [{"prefix": "24", "address": "10.80.1.0"}], "ipAddress": [{"publicIpAddress": "XX.XXX.XX.XXX", "privateIpAddress": "10.80.1.32"}]}, "ipv6": {}, "macAddress": "000D3A2E8B91"}]}}, "Provider": "azure"}	2024-04-09 15:08:19.173679	2024-04-09 15:08:19.173679
225	a3297d85-5e8b-5ac5-b8a3-55eebc2b8d12	host_discovery	{"hostname": "vmnwprd03", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.80.1.23", "10.80.1.27", "fe80::20d:3aff:fe25:7f83"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwprd03.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:08:19.30745	2024-04-09 15:08:19.30745
226	25677e37-fd33-5005-896c-9275b1284534	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:08:19.443724	2024-04-09 15:08:19.443724
229	69f4dcbb-efa2-5a16-8bc8-01df7dbb7384	sap_system_discovery	[]	2024-04-09 15:08:19.855534	2024-04-09 15:08:19.855534
230	116d49bd-85e1-5e59-b820-83f66db8800c	host_discovery	{"hostname": "vmnwprd01", "cpu_count": 2, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.80.1.21", "10.80.1.25", "fe80::20d:3aff:fe2e:8f04"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 7951, "fully_qualified_domain_name": "vmnwprd01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:08:19.989867	2024-04-09 15:08:19.989867
235	b767b3e9-e802-587e-a442-541d093b86b9	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:08:20.620284	2024-04-09 15:08:20.620284
237	99cf8a3a-48d6-57a4-b302-6e4482227ab6	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:08:20.872627	2024-04-09 15:08:20.872627
239	7269ee51-5007-5849-aaa7-7c4a98b0c9ce	ha_cluster_discovery	{"DC": true, "Id": "057f083c3be591f4398eed816d4c8cd7", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmnwdev01", "InstanceAttributes": null}, {"Id": "2", "Uname": "vmnwdev02", "InstanceAttributes": null}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "netweaver_cluster"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}]}, "Resources": {"Clones": null, "Groups": [{"Id": "grp_NWD_ASCS00", "Primitives": [{"Id": "rsc_ip_NWD_ASCS00", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWD_ASCS00-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWD_ASCS00-instance_attributes-ip", "Name": "ip", "Value": "10.100.1.25"}]}, {"Id": "rsc_fs_NWD_ASCS00", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWD_ASCS00-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWD_ASCS00-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWD_ASCS00-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWD_ASCS00-instance_attributes-device", "Name": "device", "Value": "10.100.1.33:/NWD/ASCS"}, {"Id": "rsc_fs_NWD_ASCS00-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWD/ASCS00"}, {"Id": "rsc_fs_NWD_ASCS00-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWD_ASCS00", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWD_ASCS00-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWD_ASCS00-meta_attributes-resource-stickiness", "Name": "resource-stickiness", "Value": "5000"}, {"Id": "rsc_sap_NWD_ASCS00-meta_attributes-failure-timeout", "Name": "failure-timeout", "Value": "60"}, {"Id": "rsc_sap_NWD_ASCS00-meta_attributes-migration-threshold", "Name": "migration-threshold", "Value": "1"}, {"Id": "rsc_sap_NWD_ASCS00-meta_attributes-priority", "Name": "priority", "Value": "10"}], "InstanceAttributes": [{"Id": "rsc_sap_NWD_ASCS00-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWD_ASCS00_sapnwdas"}, {"Id": "rsc_sap_NWD_ASCS00-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWD/profile/NWD_ASCS00_sapnwdas"}, {"Id": "rsc_sap_NWD_ASCS00-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}]}, {"Id": "rsc_socat_NWD_ASCS00", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWD_ASCS00-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWD_ASCS00-instance_attributes-port", "Name": "port", "Value": "62000"}]}]}, {"Id": "grp_NWD_ERS10", "Primitives": [{"Id": "rsc_ip_NWD_ERS10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_NWD_ERS10-monitor-10s", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_NWD_ERS10-instance_attributes-ip", "Name": "ip", "Value": "10.100.1.26"}]}, {"Id": "rsc_fs_NWD_ERS10", "Type": "Filesystem", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_fs_NWD_ERS10-start-0", "Name": "start", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWD_ERS10-stop-0", "Name": "stop", "Role": "", "Timeout": "60s", "Interval": "0"}, {"Id": "rsc_fs_NWD_ERS10-monitor-20s", "Name": "monitor", "Role": "", "Timeout": "40s", "Interval": "20s"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_fs_NWD_ERS10-instance_attributes-device", "Name": "device", "Value": "10.100.1.33:/NWD/ERS"}, {"Id": "rsc_fs_NWD_ERS10-instance_attributes-directory", "Name": "directory", "Value": "/usr/sap/NWD/ERS10"}, {"Id": "rsc_fs_NWD_ERS10-instance_attributes-fstype", "Name": "fstype", "Value": "nfs4"}]}, {"Id": "rsc_sap_NWD_ERS10", "Type": "SAPInstance", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_sap_NWD_ERS10-operations-monitor-120", "Name": "monitor", "Role": "", "Timeout": "60", "Interval": "120"}], "MetaAttributes": [{"Id": "rsc_sap_NWD_ERS10-meta_attributes-priority", "Name": "priority", "Value": "1000"}], "InstanceAttributes": [{"Id": "rsc_sap_NWD_ERS10-instance_attributes-InstanceName", "Name": "InstanceName", "Value": "NWD_ERS10_sapnwder"}, {"Id": "rsc_sap_NWD_ERS10-instance_attributes-START_PROFILE", "Name": "START_PROFILE", "Value": "/sapmnt/NWD/profile/NWD_ERS10_sapnwder"}, {"Id": "rsc_sap_NWD_ERS10-instance_attributes-AUTOMATIC_RECOVER", "Name": "AUTOMATIC_RECOVER", "Value": "false"}, {"Id": "rsc_sap_NWD_ERS10-instance_attributes-IS_ERS", "Name": "IS_ERS", "Value": "true"}]}, {"Id": "rsc_socat_NWD_ERS10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_NWD_ERS10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20s", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_NWD_ERS10-instance_attributes-port", "Name": "port", "Value": "62110"}]}]}], "Masters": null, "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": null, "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "30s"}]}]}, "Constraints": {"RscLocations": [{"Id": "loc_sap_NWD_failover_to_ers", "Node": "", "Role": "", "Score": "", "Resource": "rsc_sap_NWD_ASCS00"}]}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-36001405f01eb5f4c5c941e499beb055d", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "4e8adda1-da35-4ee4-92b9-a134494861f0", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmnwdev01", "Status": "clear"}, {"Id": 1, "Name": "vmnwdev02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-36001405f01eb5f4c5c941e499beb055d", "Status": "healthy"}]}, "Name": "netweaver_cluster", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmnwdev01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 5}, {"DC": false, "Id": "2", "Name": "vmnwdev02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 4}], "Clones": null, "Groups": [{"Id": "grp_NWD_ASCS00", "Resources": [{"Id": "rsc_ip_NWD_ASCS00", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWD_ASCS00", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWD_ASCS00", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWD_ASCS00", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}, {"Id": "grp_NWD_ERS10", "Resources": [{"Id": "rsc_ip_NWD_ERS10", "Node": {"Id": "2", "Name": "vmnwdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_fs_NWD_ERS10", "Node": {"Id": "2", "Name": "vmnwdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:Filesystem", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_sap_NWD_ERS10", "Node": {"Id": "2", "Name": "vmnwdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:SAPInstance", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_NWD_ERS10", "Node": {"Id": "2", "Name": "vmnwdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 9, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 11 12:55:06 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmnwdev01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmnwdev01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWD_ASCS00", "FailCount": 0, "MigrationThreshold": 1}, {"Name": "rsc_socat_NWD_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_ip_NWD_ASCS00", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWD_ASCS00", "FailCount": 0, "MigrationThreshold": 3}]}, {"Name": "vmnwdev02", "ResourceHistory": [{"Name": "rsc_ip_NWD_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_fs_NWD_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_sap_NWD_ERS10", "FailCount": 0, "MigrationThreshold": 3}, {"Name": "rsc_socat_NWD_ERS10", "FailCount": 0, "MigrationThreshold": 3}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmnwdev02", "Attributes": [{"Name": "runs_ers_NWD", "Value": "1"}]}]}}, "Provider": "azure"}	2024-04-09 15:08:21.126211	2024-04-09 15:08:21.126211
240	99cf8a3a-48d6-57a4-b302-6e4482227ab6	host_discovery	{"hostname": "vmhdbqas01", "cpu_count": 4, "os_version": "15-SP3", "ip_addresses": ["127.0.0.1", "::1", "10.90.1.11", "10.90.1.13", "fe80::6245:bdff:fe8d:1d5"], "socket_count": 1, "agent_version": "2.1.0", "total_memory_mb": 32107, "fully_qualified_domain_name": "vmhdbqas01.l15cqsinwnpu5gfyrf1r5l51fe.ax.internal.cloudapp.net"}	2024-04-09 15:08:21.253096	2024-04-09 15:08:21.253096
241	21de186a-e38f-5804-b643-7f4ef22fecfd	sap_system_discovery	[]	2024-04-09 15:08:21.376125	2024-04-09 15:08:21.376125
243	098fc159-3ed6-58e7-91be-38fda8a833ea	sap_system_discovery	[{"Id": "d01fdc69aeba7bd5133b210eb2884853", "SID": "NWQ", "Type": 2, "Profile": {"SAPDBHOST": "ha-cluster.suse.de", "dbms/name": "HDQ", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwqas", "rdisp/msserv": "sapmsNWQ", "SAPGLOBALHOST": "sapnwqas", "SAPSYSTEMNAME": "NWQ", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDQ", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwqas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods": "SDEFAULT", "system/secure_communication": "ON", "is/HTTP/show_detailed_errors": "FALSE", "login/password_downwards_compatibility": "0", "icm/HTTP/ASJava/disable_url_session_tracking": "TRUE"}, "DBAddress": "10.90.1.13", "Databases": null, "Instances": [{"Host": "vmnwqas03", "Name": "D01", "Type": 2, "SAPControl": {"Instances": [{"features": "MESSAGESERVER|ENQUE", "hostname": "sapnwqas", "httpPort": 50013, "httpsPort": 50014, "dispstatus": "SAPControl-GREEN", "instanceNr": 0, "startPriority": "1"}, {"features": "ENQREP", "hostname": "sapnwqer", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.5"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwqpas", "httpPort": 50113, "httpsPort": 50114, "dispstatus": "SAPControl-GREEN", "instanceNr": 1, "startPriority": "3"}, {"features": "ABAP|GATEWAY|ICMAN|IGS", "hostname": "sapnwqaas1", "httpPort": 50213, "httpsPort": 50214, "dispstatus": "SAPControl-GREEN", "instanceNr": 2, "startPriority": "3"}], "Processes": [{"pid": 17085, "name": "gwrd", "starttime": "2022 01 17 12:42:04", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Gateway", "elapsedtime": "8:09:29"}, {"pid": 17086, "name": "icman", "starttime": "2022 01 17 12:42:04", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "ICM", "elapsedtime": "8:09:29"}, {"pid": 17081, "name": "igswd_mt", "starttime": "2022 01 17 12:42:03", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "IGS Watchdog", "elapsedtime": "8:09:30"}, {"pid": 17080, "name": "disp+work", "starttime": "2022 01 17 12:42:03", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "Dispatcher", "elapsedtime": "8:09:30"}], "Properties": [{"value": "HTTP://sapnwqpas:0/sap/admin/public/index.html", "property": "ICM", "propertytype": "NodeURL"}, {"value": "http://sapnwqpas:40180", "property": "IGS", "propertytype": "NodeURL"}, {"value": "ABAPReadSyslog", "property": "Syslog", "propertytype": "NodeWebmethod"}, {"value": "ICMGetCacheEntries", "property": "ICM Cache", "propertytype": "NodeWebmethod"}, {"value": "01", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,ABAPSetServerInactive,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetThreadList", "property": "ICM Threads", "propertytype": "NodeWebmethod"}, {"value": "GetAlertTree", "property": "Open Alerts", "propertytype": "NodeWebmethod"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "sapnwqpas", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "ABAPGetWPTable", "property": "ABAP WP Table", "propertytype": "NodeWebmethod"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "D01", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "https://launchpad.support.sap.com/#/softwarecenter/template/products/_APP=00200682500000001943&_EVENT=DISPHIER&HEADER=Y&FUNCTIONBAR=N&EVENT=TREE&NE=NAVIGATE&ENR=73554900100200005858&V=MAINT", "property": "Kernel Update", "propertytype": "NodeURL"}, {"value": "NWQ", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "GetAlertTree", "property": "Current Status", "propertytype": "NodeWebmethod"}, {"value": "GWGetClientList", "property": "Gateway Clients", "propertytype": "NodeWebmethod"}, {"value": "ICMGetConnectionList", "property": "ICM Connections", "propertytype": "NodeWebmethod"}, {"value": "GetQueueStatistic", "property": "Queue Statistic", "propertytype": "NodeWebmethod"}, {"value": "GWGetConnectionList", "property": "Gateway Connections", "propertytype": "NodeWebmethod"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,ABAPSetServerInactive,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "ICMGetProxyConnectionList", "property": "ICM Proxy Connections", "propertytype": "NodeWebmethod"}, {"value": "http://sapnwqpas:50113/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": null, "HostConfiguration": null, "SystemReplication": null}]}]	2024-04-09 15:08:21.614575	2024-04-09 15:08:21.614575
248	9cd46919-5f19-59aa-993e-cf3736c71053	saptune_discovery	{"status": {"pid": 24623, "argv": "saptune --format json status", "result": {"staging": {"Notes staged": [], "staging enabled": false, "Solutions staged": []}, "services": {"tuned": [], "sapconf": [], "saptune": ["enabled", "active"]}, "tuning state": "compliant", "Notes applied": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "Notes enabled": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "virtualization": "oracle", "package version": "3.1.0", "Solution applied": [{"Solution ID": "HANA", "applied partially": false}], "Solution enabled": ["HANA"], "remember message": "\\nRegarding the tuning state of the system please use 'saptune note verify' for detailed information.\\n\\n", "configured version": "3", "systemd system state": "running", "Notes applied by Solution": [{"Note list": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "Solution ID": "HANA"}], "Notes enabled by Solution": [{"Note list": ["941735", "1771258", "1868829", "1980196", "2578899", "2684254", "2382421", "2534844", "2993054", "1656250"], "Solution ID": "HANA"}], "Notes enabled additionally": []}, "$schema": "file:///usr/share/saptune/schemas/1.0/saptune_status.schema.json", "command": "status", "messages": [{"message": "actions.go:85: ATTENTION: You are running a test version (3.1.0 from 2022/11/28) of saptune which is not supported for production use\\n", "priority": "NOTICE"}, {"message": "sysctl.go:73: Parameter 'kernel.shmmax' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0xffffffffffffffff), /boot/sysctl.conf-5.3.18-150300.59.93-default(0xffffffffffffffff).\\n", "priority": "WARNING"}, {"message": "sysctl.go:73: Parameter 'kernel.shmall' additional defined in the following sysctl config file /boot/sysctl.conf-5.3.18-150300.59.90-default(0x0fffffffffffff00), /boot/sysctl.conf-5.3.18-150300.59.93-default(0x0fffffffffffff00).\\n", "priority": "WARNING"}, {"message": "ini.go:308: block device related section settings detected: Traversing all block devices can take a considerable amount of time.\\n", "priority": "NOTICE"}], "exit code": 4, "publish time": "2023-04-24 12:41:56.612"}, "package_version": "3.1.0", "saptune_installed": true}	2024-04-09 15:08:22.276979	2024-04-09 15:08:22.276979
254	e0c182db-32ff-55c6-a9eb-2b82dd21bc8b	saptune_discovery	{"status": null, "package_version": "3.0.0", "saptune_installed": true}	2024-04-09 15:08:23.090499	2024-04-09 15:08:23.090499
256	ddcb7992-2ffb-5c10-8b39-80685f6eaaba	subscription_discovery	[{"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "SLES_SAP", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-basesystem"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-desktop-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-server-applications"}, {"arch": "x86_64", "type": "internal", "status": "Registered", "version": "15.3", "starts_at": "2021-10-18 06:23:46 UTC", "expires_at": "2026-10-18 06:23:46 UTC", "identifier": "sle-ha", "subscription_status": "ACTIVE"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-sap-applications"}, {"arch": "x86_64", "status": "Registered", "version": "15.3", "identifier": "sle-module-public-cloud"}]	2024-04-09 15:08:23.396355	2024-04-09 15:08:23.396355
259	b767b3e9-e802-587e-a442-541d093b86b9	sap_system_discovery	[{"Id": "1154f7678ac587e5f0f242830a5201f1", "SID": "HDP", "Type": 1, "Profile": {"SAPGLOBALHOST": "vmhdbprd02", "SAPSYSTEMNAME": "HDP", "hdbConfigType": "DEFAULT", "ssl/ciphersuites": "135:PFS:HIGH::EC_P256:EC_HIGH", "HDB_LINKED_BINARIES": "yes", "HDB_SHARED_BINARIES": "yes"}, "Databases": [{"Host": "vmhdbprd02", "User": "", "Group": "", "Active": "yes", "UserId": "", "GroupId": "", "SqlPort": "31015", "Database": "HDP", "Container": ""}], "Instances": [{"Host": "vmhdbprd02", "Name": "HDB10", "Type": 1, "SAPControl": {"Instances": [{"features": "HDB|HDB_WORKER", "hostname": "vmhdbprd02", "httpPort": 51013, "httpsPort": 51014, "dispstatus": "SAPControl-GREEN", "instanceNr": 10, "startPriority": "0.3"}], "Processes": [{"pid": 7464, "name": "hdbdaemon", "starttime": "2022 01 11 13:36:18", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Daemon", "elapsedtime": "151:15:40"}, {"pid": 8467, "name": "hdbxsengine", "starttime": "2022 01 11 13:36:34", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB XSEngine-HDP", "elapsedtime": "151:15:24"}, {"pid": 7484, "name": "hdbnameserver", "starttime": "2022 01 11 13:36:18", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Nameserver", "elapsedtime": "151:15:40"}, {"pid": 8460, "name": "hdbindexserver", "starttime": "2022 01 11 13:36:34", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Indexserver-HDP", "elapsedtime": "151:15:24"}, {"pid": 8253, "name": "hdbpreprocessor", "starttime": "2022 01 11 13:36:33", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Preprocessor", "elapsedtime": "151:15:25"}, {"pid": 8250, "name": "hdbcompileserver", "starttime": "2022 01 11 13:36:33", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Compileserver", "elapsedtime": "151:15:25"}, {"pid": 9083, "name": "hdbwebdispatcher", "starttime": "2022 01 11 13:36:43", "dispstatus": "SAPControl-GREEN", "textstatus": "Running", "description": "HDB Web Dispatcher", "elapsedtime": "151:15:15"}], "Properties": [{"value": "10", "property": "SAPSYSTEM", "propertytype": "Attribute"}, {"value": "YES", "property": "DBServices", "propertytype": "Attribute"}, {"value": "worker", "property": "HANA Roles", "propertytype": "Attribute"}, {"value": "Start,InstanceStart,StartBypassHA,Bootstrap,Stop,InstanceStop,StopBypassHA,Shutdown,ParameterValue,GetProcessList,GetStartProfile,GetTraceFile,GetAlertTree,GetAlerts,RestartService,StopService,GetEnvironment,ListDeveloperTraces,ReadDeveloperTrace,RestartInstance,SendSignal,GetVersionInfo,GetQueueStatistic,GetInstanceProperties,OSExecute,ReadLogFile,AnalyseLogFiles,ListLogFiles,GetAccessPointList,GetSystemInstanceList,GetSystemUpdateList,StartSystem,StopSystem,RestartSystem,UpdateSystem,UpdateSCSInstance,CheckUpdateSystem,AccessCheck,GetProcessParameter,SetProcessParameter,SetProcessParameter2,CheckParameter,ShmDetach,GetNetworkId,GetSecNetworkId,RequestLogonFile,CreateSnapshot,ReadSnapshot,ListSnapshots,DeleteSnapshots,GetCallstack,ABAPReadSyslog,ABAPReadRawSyslog,ABAPGetWPTable,ABAPAcknowledgeAlerts,ABAPGetComponentList,ABAPCheckRFCDestinations,ABAPGetSystemWPTable,J2EEGetProcessList,J2EEGetProcessList2,J2EEControlProcess,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadCallStack,J2EEGetThreadTaskStack,J2EEGetSessionList,J2EEGetWebSessionList,J2EEGetWebSessionList2,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetApplicationAliasList,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetEJBSessionList,J2EEGetRemoteObjectList,J2EEGetClusterMsgList,J2EEGetSharedTableInfo,J2EEGetComponentList,J2EEControlComponents,ICMGetThreadList,ICMGetConnectionList,ICMGetCacheEntries,ICMGetProxyConnectionList,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,EnqGetLockTable,EnqRemoveLocks,EnqRemoveUserLocks,EnqGetStatistic,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,UpdateSystemPKI,UpdateInstancePSE,StorePSE,DeletePSE,CheckPSE,HACheckConfig,HACheckFailoverConfig,HAGetFailoverConfig,HAFailoverToNode,HASetMaintenanceMode,HACheckMaintenanceMode,ListConfigFiles,ReadConfigFile", "property": "Webmethods", "propertytype": "Attribute"}, {"value": "GetProcessList", "property": "Process List", "propertytype": "NodeWebmethod"}, {"value": "vmhdbprd02", "property": "SAPLOCALHOST", "propertytype": "Attribute"}, {"value": "GetAccessPointList", "property": "Access Points", "propertytype": "NodeWebmethod"}, {"value": "HDB10", "property": "INSTANCE_NAME", "propertytype": "Attribute"}, {"value": "HDP", "property": "SAPSYSTEMNAME", "propertytype": "Attribute"}, {"value": "0.3", "property": "StartPriority", "propertytype": "Attribute"}, {"value": "ABAPAcknowledgeAlerts,ABAPCheckRFCDestinations,ABAPGetComponentList,ABAPGetSystemWPTable,ABAPGetWPTable,ABAPReadRawSyslog,ABAPReadSyslog,AnalyseLogFiles,Bootstrap,CheckParameter,CheckPSE,CheckUpdateSystem,ConfigureLogFileList,CreatePSECredential,CreateSnapshot,DeletePSE,DeleteSnapshots,EnqGetLockTable,EnqGetStatistic,EnqRemoveLocks,EnqRemoveUserLocks,GetAccessPointList,GetAlerts,GetAlertTree,GetCallstack,GetEnvironment,GetLogFileList,GetProcessParameter,GetQueueStatistic,GetStartProfile,GetSystemUpdateList,GetTraceFile,GetVersionInfo,GWCancelConnections,GWDeleteClients,GWDeleteConnections,GWGetConnectionList,GWGetClientList,HACheckConfig,HACheckFailoverConfig,HACheckMaintenanceMode,HAFailoverToNode,HAGetFailoverConfig,HASetMaintenanceMode,ICMGetCacheEntries,ICMGetConnectionList,ICMGetProxyConnectionList,ICMGetThreadList,InstanceStart,InstanceStop,J2EEControlCluster,J2EEControlComponents,J2EEControlProcess,J2EEDisableDbgSession,J2EEEnableDbgSession,J2EEGetApplicationAliasList,J2EEGetCacheStatistic,J2EEGetCacheStatistic2,J2EEGetClusterMsgList,J2EEGetComponentList,J2EEGetEJBSessionList,J2EEGetProcessList,J2EEGetProcessList2,J2EEGetRemoteObjectList,J2EEGetSessionList,J2EEGetSharedTableInfo,J2EEGetThreadCallStack,J2EEGetThreadList,J2EEGetThreadList2,J2EEGetThreadTaskStack,J2EEGetVMGCHistory,J2EEGetVMGCHistory2,J2EEGetVMHeapInfo,J2EEGetWebSessionList,J2EEGetWebSessionList2,ListConfigFiles,ListDeveloperTraces,ListLogFiles,ListSnapshots,OSExecute,ParameterValue,ReadConfigFile,ReadDeveloperTrace,ReadLogFile,ReadSnapshot,RestartInstance,RestartService,RestartSystem,SendSignal,SetProcessParameter,SetProcessParameter2,ShmDetach,Shutdown,Start,StartBypassHA,StartSystem,Stop,StopBypassHA,StopService,StopSystem,StorePSE,UpdateInstancePSE,UpdateSCSInstance,UpdateSystem,UpdateSystemPKI,WebDispGetServerList,WebDispGetGroupList,WebDispGetVirtHostList,WebDispGetUrlPrefixList,GetAgentConfig,GetListOfMaByCusGrp,GetMcInLocalMs,GetMtesByRequestTable,GetMtListByMtclass,InfoGetTree,MscCustomizeWrite,MscDeleteLines,MscReadCache,MsGetLocalMsInfo,MsGetMteclsInLocalMs,MtChangeStatus,MtCustomizeWrite,MtDbsetToWpsetByTid,MtDestroyMarkNTry,MteGetByToolRunstatus,MtGetAllToCust,MtGetAllToolsToSet,MtGetMteinfo,MtGetTidByName,MtRead,MtReset,PerfCustomizeWrite,PerfRead,PerfReadSmoothData,ReadDirectory,ReadFile,ReadProfileParameters,ReferenceRead,Register,RequestLogonFile,SnglmgsCustomizeWrite,SystemObjectSetValue,TextAttrRead,ToolGetEffective,ToolSet,ToolSetRuntimeStatus,TriggerDataCollection,Unregister,UtilAlChangeStatus,UtilMtGetAidByTid,UtilMtGetTreeLocal,UtilMtReadAll,UtilReadRawalertByAid,UtilSnglmsgReadRawdata", "property": "Protected Webmethods", "propertytype": "Attribute"}, {"value": "http://vmhdbprd02:51013/sapparamEN.html", "property": "Parameter Documentation", "propertytype": "NodeURL"}]}, "HdbnsutilSRstate": {"mode": "sync", "online": "true", "site_id": "2", "isSource": "false", "site_name": "WDF", "isConsumer": "true", "replayMode": "auto", "hasConsumers": "false", "siteTier/NBG": "1", "siteTier/WDF": "2", "operation_mode": "logreplay", "primary_masters": "vmhdbprd01", "siteMapping/NBG": "WDF", "isTakeoverActive": "false", "isPrimarySuspended": "false", "mapping/vmhdbprd02": ["WDF/vmhdbprd02", "NBG/vmhdbprd01"], "active_primary_site": "1", "isTimetravelEnabled": "false", "siteOperationMode/NBG": "primary", "siteOperationMode/WDF": "logreplay", "siteReplicationMode/NBG": "primary", "siteReplicationMode/WDF": "sync"}, "HostConfiguration": {"host": "vmhdbprd02", "hostActive": "yes", "hostStatus": "ok", "removeStatus": "", "failoverStatus": "", "hostActualRoles": "worker", "hostConfigRoles": "worker", "storagePartition": "1", "workerActualGroups": "default", "workerConfigGroups": "default", "failoverActualGroup": "default", "failoverConfigGroup": "default", "nameServerActualRole": "master", "nameServerConfigRole": "master 1", "indexServerActualRole": "master", "indexServerConfigRole": "worker", "storageActualPartition": "1", "storageConfigPartition": "1"}, "SystemReplication": {"local_site_id": "2", "site/2/SITE_NAME": "WDF", "site/2/SOURCE_SITE_ID": "1", "site/2/PRIMARY_MASTERS": "vmhdbprd01", "site/2/REPLICATION_MODE": "SYNC"}}]}]	2024-04-09 15:08:23.809044	2024-04-09 15:08:23.809044
271	13e8c25c-3180-5a9a-95c8-51ec38e50cfc	ha_cluster_discovery	{"DC": true, "Id": "04b8f8c21f9fd8991224478e8c4362f8", "Cib": {"Configuration": {"Nodes": [{"Id": "1", "Uname": "vmhdbdev01", "InstanceAttributes": [{"Id": "nodes-1-lpa_hdd_lpt", "Name": "lpa_hdd_lpt", "Value": "10"}, {"Id": "nodes-1-hana_hdd_vhost", "Name": "hana_hdd_vhost", "Value": "vmhdbdev01"}, {"Id": "nodes-1-hana_hdd_site", "Name": "hana_hdd_site", "Value": "NBG"}, {"Id": "nodes-1-hana_hdd_op_mode", "Name": "hana_hdd_op_mode", "Value": "logreplay"}, {"Id": "nodes-1-hana_hdd_srmode", "Name": "hana_hdd_srmode", "Value": "sync"}, {"Id": "nodes-1-hana_hdd_remoteHost", "Name": "hana_hdd_remoteHost", "Value": "vmhdbdev02"}]}, {"Id": "2", "Uname": "vmhdbdev02", "InstanceAttributes": [{"Id": "nodes-2-lpa_hdd_lpt", "Name": "lpa_hdd_lpt", "Value": "1643125026"}, {"Id": "nodes-2-hana_hdd_op_mode", "Name": "hana_hdd_op_mode", "Value": "logreplay"}, {"Id": "nodes-2-hana_hdd_vhost", "Name": "hana_hdd_vhost", "Value": "vmhdbdev02"}, {"Id": "nodes-2-hana_hdd_remoteHost", "Name": "hana_hdd_remoteHost", "Value": "vmhdbdev01"}, {"Id": "nodes-2-hana_hdd_site", "Name": "hana_hdd_site", "Value": "WDF"}, {"Id": "nodes-2-hana_hdd_srmode", "Name": "hana_hdd_srmode", "Value": "sync"}]}], "CrmConfig": {"ClusterProperties": [{"Id": "cib-bootstrap-options-have-watchdog", "Name": "have-watchdog", "Value": "true"}, {"Id": "cib-bootstrap-options-dc-version", "Name": "dc-version", "Value": "2.0.5+20201202.ba59be712-4.13.1-2.0.5+20201202.ba59be712"}, {"Id": "cib-bootstrap-options-cluster-infrastructure", "Name": "cluster-infrastructure", "Value": "corosync"}, {"Id": "cib-bootstrap-options-cluster-name", "Name": "cluster-name", "Value": "hana_cluster_1"}, {"Id": "cib-bootstrap-options-stonith-enabled", "Name": "stonith-enabled", "Value": "true"}, {"Id": "cib-bootstrap-options-stonith-timeout", "Name": "stonith-timeout", "Value": "144s"}, {"Id": "cib-bootstrap-options-maintenance-mode", "Name": "maintenance-mode", "Value": "false"}, {"Id": "SAPHanaSR-hana_hdd_site_srHook_WDF", "Name": "hana_hdd_site_srHook_WDF", "Value": "PRIM"}]}, "Resources": {"Clones": [{"Id": "cln_SAPHanaTopology_HDD_HDB10", "Primitive": {"Id": "rsc_SAPHanaTopology_HDD_HDB10", "Type": "SAPHanaTopology", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHanaTopology_HDD_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "600", "Interval": "10"}, {"Id": "rsc_SAPHanaTopology_HDD_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "600", "Interval": "0"}, {"Id": "rsc_SAPHanaTopology_HDD_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "300", "Interval": "0"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHanaTopology_HDD_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDD"}, {"Id": "rsc_SAPHanaTopology_HDD_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}]}, "MetaAttributes": [{"Id": "cln_SAPHanaTopology_HDD_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "cln_SAPHanaTopology_HDD_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Groups": [{"Id": "g_ip_HDD_HDB10", "Primitives": [{"Id": "rsc_ip_HDD_HDB10", "Type": "IPaddr2", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_ip_HDD_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDD_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "20", "Interval": "0"}, {"Id": "rsc_ip_HDD_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_ip_HDD_HDB10-instance_attributes-ip", "Name": "ip", "Value": "10.100.1.13"}, {"Id": "rsc_ip_HDD_HDB10-instance_attributes-cidr_netmask", "Name": "cidr_netmask", "Value": "24"}, {"Id": "rsc_ip_HDD_HDB10-instance_attributes-nic", "Name": "nic", "Value": "eth0"}]}, {"Id": "rsc_socat_HDD_HDB10", "Type": "azure-lb", "Class": "ocf", "Provider": "heartbeat", "Operations": [{"Id": "rsc_socat_HDD_HDB10-monitor-10", "Name": "monitor", "Role": "", "Timeout": "20", "Interval": "10"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_socat_HDD_HDB10-instance_attributes-port", "Name": "port", "Value": "62510"}]}]}], "Masters": [{"Id": "msl_SAPHana_HDD_HDB10", "Primitive": {"Id": "rsc_SAPHana_HDD_HDB10", "Type": "SAPHana", "Class": "ocf", "Provider": "suse", "Operations": [{"Id": "rsc_SAPHana_HDD_HDB10-start-0", "Name": "start", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDD_HDB10-stop-0", "Name": "stop", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDD_HDB10-promote-0", "Name": "promote", "Role": "", "Timeout": "3600", "Interval": "0"}, {"Id": "rsc_SAPHana_HDD_HDB10-monitor-60", "Name": "monitor", "Role": "Master", "Timeout": "700", "Interval": "60"}, {"Id": "rsc_SAPHana_HDD_HDB10-monitor-61", "Name": "monitor", "Role": "Slave", "Timeout": "700", "Interval": "61"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-SID", "Name": "SID", "Value": "HDD"}, {"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-InstanceNumber", "Name": "InstanceNumber", "Value": "10"}, {"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-PREFER_SITE_TAKEOVER", "Name": "PREFER_SITE_TAKEOVER", "Value": "True"}, {"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-AUTOMATED_REGISTER", "Name": "AUTOMATED_REGISTER", "Value": "False"}, {"Id": "rsc_SAPHana_HDD_HDB10-instance_attributes-DUPLICATE_PRIMARY_TIMEOUT", "Name": "DUPLICATE_PRIMARY_TIMEOUT", "Value": "7200"}]}, "MetaAttributes": [{"Id": "msl_SAPHana_HDD_HDB10-meta_attributes-clone-max", "Name": "clone-max", "Value": "2"}, {"Id": "msl_SAPHana_HDD_HDB10-meta_attributes-clone-node-max", "Name": "clone-node-max", "Value": "1"}, {"Id": "msl_SAPHana_HDD_HDB10-meta_attributes-interleave", "Name": "interleave", "Value": "true"}]}], "Primitives": [{"Id": "stonith-sbd", "Type": "external/sbd", "Class": "stonith", "Provider": "", "Operations": [{"Id": "stonith-sbd-monitor-15", "Name": "monitor", "Role": "", "Timeout": "15", "Interval": "15"}], "MetaAttributes": null, "InstanceAttributes": [{"Id": "stonith-sbd-instance_attributes-pcmk_delay_max", "Name": "pcmk_delay_max", "Value": "15"}]}]}, "Constraints": {"RscLocations": null}}}, "SBD": {"Config": {"SBD_OPTS": "", "SBD_DEVICE": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:182cb1b1-a815-4b82-b538-7a166b9bbb4a", "SBD_PACEMAKER": "yes", "SBD_STARTMODE": "always", "SBD_DELAY_START": "yes", "SBD_WATCHDOG_DEV": "/dev/watchdog", "SBD_TIMEOUT_ACTION": "flush,reboot", "SBD_WATCHDOG_TIMEOUT": "5", "SBD_MOVE_TO_ROOT_CGROUP": "auto", "SBD_SYNC_RESOURCE_STARTUP": "no"}, "Devices": [{"Dump": {"Uuid": "cc39771e-ea2f-4fb1-8968-a6176aee3d0a", "Slots": 255, "Header": "2.1", "SectorSize": 512, "TimeoutLoop": 1, "TimeoutMsgwait": 10, "TimeoutAllocate": 2, "TimeoutWatchdog": 5}, "List": [{"Id": 0, "Name": "vmhdbdev01", "Status": "clear"}, {"Id": 1, "Name": "vmhdbdev02", "Status": "clear"}], "Device": "/dev/disk/by-id/scsi-1LIO-ORG_IBLOCK:182cb1b1-a815-4b82-b538-7a166b9bbb4a", "Status": "healthy"}]}, "Name": "hana_cluster_1", "Crmmon": {"Nodes": [{"DC": true, "Id": "1", "Name": "vmhdbdev01", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 2}, {"DC": false, "Id": "2", "Name": "vmhdbdev02", "Type": "member", "Online": true, "Pending": false, "Standby": false, "Unclean": false, "Shutdown": false, "ExpectedUp": true, "Maintenance": false, "StandbyOnFail": false, "ResourcesRunning": 4}], "Clones": [{"Id": "msl_SAPHana_HDD_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHana_HDD_HDB10", "Node": {"Id": "2", "Name": "vmhdbdev02", "Cached": true}, "Role": "Master", "Agent": "ocf::suse:SAPHana", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHana_HDD_HDB10", "Node": null, "Role": "Stopped", "Agent": "ocf::suse:SAPHana", "Active": false, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 0}], "MultiState": true, "FailureIgnored": false}, {"Id": "cln_SAPHanaTopology_HDD_HDB10", "Failed": false, "Unique": false, "Managed": true, "Resources": [{"Id": "rsc_SAPHanaTopology_HDD_HDB10", "Node": {"Id": "2", "Name": "vmhdbdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_SAPHanaTopology_HDD_HDB10", "Node": {"Id": "1", "Name": "vmhdbdev01", "Cached": true}, "Role": "Started", "Agent": "ocf::suse:SAPHanaTopology", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "MultiState": false, "FailureIgnored": false}], "Groups": [{"Id": "g_ip_HDD_HDB10", "Resources": [{"Id": "rsc_ip_HDD_HDB10", "Node": {"Id": "2", "Name": "vmhdbdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:IPaddr2", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}, {"Id": "rsc_socat_HDD_HDB10", "Node": {"Id": "2", "Name": "vmhdbdev02", "Cached": true}, "Role": "Started", "Agent": "ocf::heartbeat:azure-lb", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}]}], "Summary": {"Nodes": {"Number": 2}, "Resources": {"Number": 7, "Blocked": 0, "Disabled": 0}, "LastChange": {"Time": "Tue Jan 25 15:37:06 2022"}, "ClusterOptions": {"StonithEnabled": true}}, "Version": "2.0.5", "Resources": [{"Id": "stonith-sbd", "Node": {"Id": "1", "Name": "vmhdbdev01", "Cached": true}, "Role": "Started", "Agent": "stonith:external/sbd", "Active": true, "Failed": false, "Blocked": false, "Managed": true, "Orphaned": false, "FailureIgnored": false, "NodesRunningOn": 1}], "NodeHistory": {"Nodes": [{"Name": "vmhdbdev02", "ResourceHistory": [{"Name": "rsc_ip_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHana_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}, {"Name": "vmhdbdev01", "ResourceHistory": [{"Name": "stonith-sbd", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_ip_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_socat_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHana_HDD_HDB10", "FailCount": 1000000, "MigrationThreshold": 5000}, {"Name": "rsc_SAPHanaTopology_HDD_HDB10", "FailCount": 0, "MigrationThreshold": 5000}]}]}, "NodeAttributes": {"Nodes": [{"Name": "vmhdbdev01", "Attributes": [{"Name": "hana_hdd_clone_state", "Value": "UNDEFINED"}, {"Name": "hana_hdd_op_mode", "Value": "logreplay"}, {"Name": "hana_hdd_remoteHost", "Value": "vmhdbdev02"}, {"Name": "hana_hdd_roles", "Value": "1:P:master1::worker:"}, {"Name": "hana_hdd_site", "Value": "NBG"}, {"Name": "hana_hdd_srmode", "Value": "sync"}, {"Name": "hana_hdd_sync_state", "Value": "SFAIL"}, {"Name": "hana_hdd_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdd_vhost", "Value": "vmhdbdev01"}, {"Name": "lpa_hdd_lpt", "Value": "10"}, {"Name": "master-rsc_SAPHana_HDD_HDB10", "Value": "-9000"}]}, {"Name": "vmhdbdev02", "Attributes": [{"Name": "hana_hdd_clone_state", "Value": "PROMOTED"}, {"Name": "hana_hdd_op_mode", "Value": "logreplay"}, {"Name": "hana_hdd_remoteHost", "Value": "vmhdbdev01"}, {"Name": "hana_hdd_roles", "Value": "4:P:master1:master:worker:master"}, {"Name": "hana_hdd_site", "Value": "WDF"}, {"Name": "hana_hdd_srmode", "Value": "sync"}, {"Name": "hana_hdd_sync_state", "Value": "PRIM"}, {"Name": "hana_hdd_version", "Value": "2.00.057.00.1629894416"}, {"Name": "hana_hdd_vhost", "Value": "vmhdbdev02"}, {"Name": "lpa_hdd_lpt", "Value": "1643125026"}, {"Name": "master-rsc_SAPHana_HDD_HDB10", "Value": "150"}]}]}}, "Provider": "azure"}	2024-04-09 15:08:25.39698	2024-04-09 15:08:25.39698
274	4b30a6af-4b52-5bda-bccb-f2248a12c992	sap_system_discovery	[{"Id": "97a1e70aeff3c0685d65c4c3d32d533b", "SID": "NWP", "Type": 2, "Profile": {"SAPDBHOST": "10.80.1.13", "dbms/name": "HDP", "dbms/type": "hdb", "gw/acl_mode": "1", "gw/sec_info": "$(DIR_GLOBAL)$(DIR_SEP)secinfo$(FT_DAT)", "system/type": "ABAP", "vmcj/enable": "off", "rdisp/mshost": "sapnwpas", "rdisp/msserv": "sapmsNWP", "SAPGLOBALHOST": "sapnwpas", "SAPSYSTEMNAME": "NWP", "rdisp/btctime": "0", "dbs/hdb/dbname": "HDP", "dbs/hdb/schema": "SAPABAP1", "enque/serverhost": "sapnwpas", "enque/serverinst": "00", "icf/user_recheck": "1", "rdisp/bufrefmode": "sendoff", "rsdb/ssfs_connect": "0", "rsec/ssfs_keypath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)key", "rdisp/autoabaptime": "0", "rsec/ssfs_datapath": "$(DIR_GLOBAL)$(DIR_SEP)security$(DIR_SEP)rsecssfs$(DIR_SEP)data", "login/system_client": "001", "rdisp/msserv_internal": "3900", "enque/process_location": "REMOTESA", "enque/deque_wait_answer": "TRUE", "service/protectedwebmethods