import Config

# Configure your database
config :wanda, Wanda.Repo,
  username: "postgres",
  password: "postgres",
  hostname: "localhost",
  database: "wanda_dev",
  port: 5434,
  stacktrace: true,
  show_sensitive_data_on_connection_error: true,
  pool_size: 10

# For development, we disable any cache and enable
# debugging and code reloading.
#
# The watchers configuration can be used to run external
# watchers to your application. For example, we use it
# with esbuild to bundle .js and .css sources.
config :wanda, WandaWeb.Endpoint,
  # Binding to loopback ipv4 address prevents access from other machines.
  # Change to `ip: {0, 0, 0, 0}` to allow access from other machines.
  http: [ip: {127, 0, 0, 1}, port: 4001],
  check_origin: false,
  code_reloader: true,
  debug_errors: true,
  secret_key_base: "TDBhePnJFAJxgjzgZAckntbWeD89nTA16RUratDYpzsZyqIyP5gXz1qjGFu2uV4P",
  watchers: []

amqp_connection =
  if System.get_env("USE_LOCAL_RABBIT_TLS") do
    "amqps://wanda:wanda@localhost:5676?certfile=container_fixtures/rabbitmq/certs/client_wanda.trento.local_certificate.pem&keyfile=container_fixtures/rabbitmq/certs/client_wanda.trento.local_key.pem&verify=verify_peer&cacertfile=container_fixtures/rabbitmq/certs/ca_certificate.pem"
  else
    "amqp://wanda:wanda@localhost:5674"
  end

config :wanda, Wanda.Messaging.Adapters.AMQP,
  checks: [
    consumer: [
      connection: amqp_connection
    ],
    publisher: [
      connection: amqp_connection
    ]
  ],
  operations: [
    consumer: [
      connection: amqp_connection
    ],
    publisher: [
      connection: amqp_connection
    ]
  ],
  catalog: [
    publisher: [
      connection: amqp_connection
    ]
  ]

# ## SSL Support
#
# In order to use HTTPS in development, a self-signed
# certificate can be generated by running the following
# Mix task:
#
#     mix phx.gen.cert
#
# Note that this task requires Erlang/OTP 20 or later.
# Run `mix help phx.gen.cert` for more information.
#
# The `http:` config above can be replaced with:
#
#     https: [
#       port: 4001,
#       cipher_suite: :strong,
#       keyfile: "priv/cert/selfsigned_key.pem",
#       certfile: "priv/cert/selfsigned.pem"
#     ],
#
# If desired, both `http:` and `https:` keys can be
# configured to run both http and https servers on
# different ports.

# Do not include metadata nor timestamps in development logs
config :logger, :console,
  format: "[$level] $message\n",
  metadata: [:request_id, :state]

# Set a higher stacktrace during development. Avoid configuring such
# in production as building large stacktraces may be expensive.
config :phoenix, :stacktrace_depth, 20

# Initialize plugs at runtime for faster development compilation
config :phoenix, :plug_init_mode, :runtime

config :joken,
  access_token_signer: "s2ZdE+3+ke1USHEJ5O45KT364KiXPYaB9cJPdH3p60t8yT0nkLexLBNw8TFSzC7k"

config :unplug, :init_mode, :runtime

config :open_api_spex, :cache_adapter, OpenApiSpex.Plug.NoneCache

# Override with local dev.local.exs file
if File.exists?("#{__DIR__}/dev.local.exs") do
  import_config "dev.local.exs"
end
