// Copyright (c) 2012 Ecma International.  All rights reserved.
// Ecma International makes this code available under the terms and conditions set
// forth on http://hg.ecmascript.org/tests/test262/raw-file/tip/LICENSE (the
// "Use Terms").   Any redistribution of this code must retain the above
// copyright and this notice and otherwise comply with the Use Terms.

/*---
es5id: 15.2.3.5-4-288
description: >
    Object.create - one property in 'Properties' is an Error object
    that uses Object's [[Get]] method to access the 'set' property
    (8.10.5 step 8.a)
includes: [runTestCase.js]
---*/

function testcase() {
        var errObj = new Error("error");
        var data = "data";

        errObj.set = function (value) {
            data = value;
        };

        var newObj = Object.create({}, {
            prop: errObj
        });

        newObj.prop = "overrideData";

        return newObj.hasOwnProperty("prop") && data === "overrideData";
    }
runTestCase(testcase);
