; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -verify-machineinstrs < %s | FileCheck %s --check-prefix=RV32I
; RUN: llc -mtriple=riscv64 -verify-machineinstrs < %s | FileCheck %s --check-prefix=RV64I

; This test case test the LocalStackSlotAllocation pass that use a base register
; for the frame index that its offset is out-of-range (for RISC-V. the immediate
; is 12 bits for the load store instruction (excludes vector load / store))
define void @use_frame_base_reg() {
; RV32I-LABEL: use_frame_base_reg:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a0, 24
; RV32I-NEXT:    addi a0, a0, 1712
; RV32I-NEXT:    sub sp, sp, a0
; RV32I-NEXT:    .cfi_def_cfa_offset 100016
; RV32I-NEXT:    lui a0, 24
; RV32I-NEXT:    addi a0, a0, 1704
; RV32I-NEXT:    add a0, sp, a0
; RV32I-NEXT:    lbu zero, 4(a0)
; RV32I-NEXT:    lbu zero, 0(a0)
; RV32I-NEXT:    lui a0, 24
; RV32I-NEXT:    addi a0, a0, 1712
; RV32I-NEXT:    add sp, sp, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: use_frame_base_reg:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a0, 24
; RV64I-NEXT:    addiw a0, a0, 1712
; RV64I-NEXT:    sub sp, sp, a0
; RV64I-NEXT:    .cfi_def_cfa_offset 100016
; RV64I-NEXT:    lui a0, 24
; RV64I-NEXT:    addiw a0, a0, 1704
; RV64I-NEXT:    add a0, sp, a0
; RV64I-NEXT:    lbu zero, 4(a0)
; RV64I-NEXT:    lbu zero, 0(a0)
; RV64I-NEXT:    lui a0, 24
; RV64I-NEXT:    addiw a0, a0, 1712
; RV64I-NEXT:    add sp, sp, a0
; RV64I-NEXT:    ret

  %va = alloca i8, align 4
  %va1 = alloca i8, align 4
  %large = alloca [ 100000 x i8 ]
  %argp.cur = load volatile i8, ptr %va, align 4
  %argp.next = load volatile i8, ptr %va1, align 4
  ret void
}

; Test containing a load with its own local offset. Make sure isFrameOffsetLegal
; considers it and creates a virtual base register.
define void @load_with_offset() {
; RV32I-LABEL: load_with_offset:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -2048
; RV32I-NEXT:    addi sp, sp, -464
; RV32I-NEXT:    .cfi_def_cfa_offset 2512
; RV32I-NEXT:    addi a0, sp, 2012
; RV32I-NEXT:    lbu a1, 0(a0)
; RV32I-NEXT:    sb a1, 0(a0)
; RV32I-NEXT:    addi sp, sp, 2032
; RV32I-NEXT:    addi sp, sp, 480
; RV32I-NEXT:    ret
;
; RV64I-LABEL: load_with_offset:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -2048
; RV64I-NEXT:    addi sp, sp, -464
; RV64I-NEXT:    .cfi_def_cfa_offset 2512
; RV64I-NEXT:    addi a0, sp, 2012
; RV64I-NEXT:    lbu a1, 0(a0)
; RV64I-NEXT:    sb a1, 0(a0)
; RV64I-NEXT:    addi sp, sp, 2032
; RV64I-NEXT:    addi sp, sp, 480
; RV64I-NEXT:    ret

  %va = alloca [2500 x i8], align 4
  %va_gep = getelementptr [2000 x i8], ptr %va, i64 0, i64 2000
  %load = load volatile i8, ptr %va_gep, align 4
  store volatile i8 %load, ptr %va_gep, align 4
  ret void
}

; Test containing a load with its own local offset that is smaller than the
; previous test case. Make sure we don't create a virtual base register.
define void @load_with_offset2() {
; RV32I-LABEL: load_with_offset2:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -2048
; RV32I-NEXT:    addi sp, sp, -464
; RV32I-NEXT:    .cfi_def_cfa_offset 2512
; RV32I-NEXT:    lbu a0, 1412(sp)
; RV32I-NEXT:    sb a0, 1412(sp)
; RV32I-NEXT:    addi sp, sp, 2032
; RV32I-NEXT:    addi sp, sp, 480
; RV32I-NEXT:    ret
;
; RV64I-LABEL: load_with_offset2:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -2048
; RV64I-NEXT:    addi sp, sp, -464
; RV64I-NEXT:    .cfi_def_cfa_offset 2512
; RV64I-NEXT:    lbu a0, 1412(sp)
; RV64I-NEXT:    sb a0, 1412(sp)
; RV64I-NEXT:    addi sp, sp, 2032
; RV64I-NEXT:    addi sp, sp, 480
; RV64I-NEXT:    ret

  %va = alloca [2500 x i8], align 4
  %va_gep = getelementptr [2000 x i8], ptr %va, i64 0, i64 1400
  %load = load volatile i8, ptr %va_gep, align 4
  store volatile i8 %load, ptr %va_gep, align 4
  ret void
}

define void @frame_pointer() "frame-pointer"="all" {
; RV32I-LABEL: frame_pointer:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi sp, sp, -2032
; RV32I-NEXT:    .cfi_def_cfa_offset 2032
; RV32I-NEXT:    sw ra, 2028(sp) # 4-byte Folded Spill
; RV32I-NEXT:    sw s0, 2024(sp) # 4-byte Folded Spill
; RV32I-NEXT:    .cfi_offset ra, -4
; RV32I-NEXT:    .cfi_offset s0, -8
; RV32I-NEXT:    addi s0, sp, 2032
; RV32I-NEXT:    .cfi_def_cfa s0, 0
; RV32I-NEXT:    addi sp, sp, -480
; RV32I-NEXT:    lbu a0, -1960(s0)
; RV32I-NEXT:    sb a0, -1960(s0)
; RV32I-NEXT:    addi sp, sp, 480
; RV32I-NEXT:    lw ra, 2028(sp) # 4-byte Folded Reload
; RV32I-NEXT:    lw s0, 2024(sp) # 4-byte Folded Reload
; RV32I-NEXT:    addi sp, sp, 2032
; RV32I-NEXT:    ret
;
; RV64I-LABEL: frame_pointer:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi sp, sp, -2032
; RV64I-NEXT:    .cfi_def_cfa_offset 2032
; RV64I-NEXT:    sd ra, 2024(sp) # 8-byte Folded Spill
; RV64I-NEXT:    sd s0, 2016(sp) # 8-byte Folded Spill
; RV64I-NEXT:    .cfi_offset ra, -8
; RV64I-NEXT:    .cfi_offset s0, -16
; RV64I-NEXT:    addi s0, sp, 2032
; RV64I-NEXT:    .cfi_def_cfa s0, 0
; RV64I-NEXT:    addi sp, sp, -496
; RV64I-NEXT:    addi a0, s0, -1972
; RV64I-NEXT:    lbu a1, 0(a0)
; RV64I-NEXT:    sb a1, 0(a0)
; RV64I-NEXT:    addi sp, sp, 496
; RV64I-NEXT:    ld ra, 2024(sp) # 8-byte Folded Reload
; RV64I-NEXT:    ld s0, 2016(sp) # 8-byte Folded Reload
; RV64I-NEXT:    addi sp, sp, 2032
; RV64I-NEXT:    ret

  %va = alloca [2500 x i8], align 4
  %va_gep = getelementptr [2000 x i8], ptr %va, i64 0, i64 552
  %load = load volatile i8, ptr %va_gep, align 4
  store volatile i8 %load, ptr %va_gep, align 4
  ret void
}
