; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32-unknown-linux-gnu < %s | FileCheck %s --check-prefixes=CHECK,RV32,RV32I
; RUN: llc -mtriple=riscv64-unknown-linux-gnu < %s | FileCheck %s --check-prefixes=CHECK,RV64,RV64I
; RUN: llc -mtriple=riscv32-unknown-linux-gnu -mattr=+zbb < %s | FileCheck %s --check-prefixes=CHECK,RV32,RV32ZBB
; RUN: llc -mtriple=riscv64-unknown-linux-gnu -mattr=+zbb < %s | FileCheck %s --check-prefixes=CHECK,RV64,RV64ZBB

; https://bugs.llvm.org/show_bug.cgi?id=38149

; We are truncating from wider width, and then sign-extending
; back to the original width. Then we inequality-comparing orig and src.
; If they don't match, then we had signed truncation during truncation.

; This can be expressed in a several ways in IR:
;   trunc + sext + icmp ne <- not canonical
;   shl   + ashr + icmp ne
;   add          + icmp ult/ule
;   add          + icmp uge/ugt
; However only the simplest form (with two shifts) gets lowered best.

; ---------------------------------------------------------------------------- ;
; shl + ashr + icmp ne
; ---------------------------------------------------------------------------- ;

define i1 @shifts_necmp_i16_i8(i16 %x) nounwind {
; RV32I-LABEL: shifts_necmp_i16_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 16
; RV32I-NEXT:    addi a1, a1, -1
; RV32I-NEXT:    and a2, a0, a1
; RV32I-NEXT:    slli a0, a0, 24
; RV32I-NEXT:    srai a0, a0, 24
; RV32I-NEXT:    and a0, a0, a1
; RV32I-NEXT:    xor a0, a0, a2
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: shifts_necmp_i16_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 16
; RV64I-NEXT:    addiw a1, a1, -1
; RV64I-NEXT:    and a2, a0, a1
; RV64I-NEXT:    slli a0, a0, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    and a0, a0, a1
; RV64I-NEXT:    xor a0, a0, a2
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: shifts_necmp_i16_i8:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    zext.h a1, a0
; RV32ZBB-NEXT:    sext.b a0, a0
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    xor a0, a0, a1
; RV32ZBB-NEXT:    snez a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: shifts_necmp_i16_i8:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    zext.h a1, a0
; RV64ZBB-NEXT:    sext.b a0, a0
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    xor a0, a0, a1
; RV64ZBB-NEXT:    snez a0, a0
; RV64ZBB-NEXT:    ret
  %tmp0 = shl i16 %x, 8 ; 16-8
  %tmp1 = ashr exact i16 %tmp0, 8 ; 16-8
  %tmp2 = icmp ne i16 %tmp1, %x
  ret i1 %tmp2
}

define i1 @shifts_necmp_i32_i16(i32 %x) nounwind {
; RV32I-LABEL: shifts_necmp_i32_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 16
; RV32I-NEXT:    srai a1, a1, 16
; RV32I-NEXT:    xor a0, a1, a0
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: shifts_necmp_i32_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sext.w a1, a0
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srai a0, a0, 48
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: shifts_necmp_i32_i16:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    sext.h a1, a0
; RV32ZBB-NEXT:    xor a0, a1, a0
; RV32ZBB-NEXT:    snez a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: shifts_necmp_i32_i16:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sext.w a1, a0
; RV64ZBB-NEXT:    sext.h a0, a0
; RV64ZBB-NEXT:    xor a0, a0, a1
; RV64ZBB-NEXT:    snez a0, a0
; RV64ZBB-NEXT:    ret
  %tmp0 = shl i32 %x, 16 ; 32-16
  %tmp1 = ashr exact i32 %tmp0, 16 ; 32-16
  %tmp2 = icmp ne i32 %tmp1, %x
  ret i1 %tmp2
}

define i1 @shifts_necmp_i32_i8(i32 %x) nounwind {
; RV32I-LABEL: shifts_necmp_i32_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a1, a0, 24
; RV32I-NEXT:    srai a1, a1, 24
; RV32I-NEXT:    xor a0, a1, a0
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: shifts_necmp_i32_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    sext.w a1, a0
; RV64I-NEXT:    slli a0, a0, 56
; RV64I-NEXT:    srai a0, a0, 56
; RV64I-NEXT:    xor a0, a0, a1
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: shifts_necmp_i32_i8:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    sext.b a1, a0
; RV32ZBB-NEXT:    xor a0, a1, a0
; RV32ZBB-NEXT:    snez a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: shifts_necmp_i32_i8:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sext.w a1, a0
; RV64ZBB-NEXT:    sext.b a0, a0
; RV64ZBB-NEXT:    xor a0, a0, a1
; RV64ZBB-NEXT:    snez a0, a0
; RV64ZBB-NEXT:    ret
  %tmp0 = shl i32 %x, 24 ; 32-8
  %tmp1 = ashr exact i32 %tmp0, 24 ; 32-8
  %tmp2 = icmp ne i32 %tmp1, %x
  ret i1 %tmp2
}

define i1 @shifts_necmp_i64_i32(i64 %x) nounwind {
; RV32-LABEL: shifts_necmp_i64_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    srai a0, a0, 31
; RV32-NEXT:    xor a0, a0, a1
; RV32-NEXT:    snez a0, a0
; RV32-NEXT:    ret
;
; RV64-LABEL: shifts_necmp_i64_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    sext.w a1, a0
; RV64-NEXT:    xor a0, a1, a0
; RV64-NEXT:    snez a0, a0
; RV64-NEXT:    ret
  %tmp0 = shl i64 %x, 32 ; 64-32
  %tmp1 = ashr exact i64 %tmp0, 32 ; 64-32
  %tmp2 = icmp ne i64 %tmp1, %x
  ret i1 %tmp2
}

define i1 @shifts_necmp_i64_i16(i64 %x) nounwind {
; RV32I-LABEL: shifts_necmp_i64_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 16
; RV32I-NEXT:    srai a3, a2, 16
; RV32I-NEXT:    srai a2, a2, 31
; RV32I-NEXT:    xor a1, a2, a1
; RV32I-NEXT:    xor a0, a3, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: shifts_necmp_i64_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a1, a0, 48
; RV64I-NEXT:    srai a1, a1, 48
; RV64I-NEXT:    xor a0, a1, a0
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: shifts_necmp_i64_i16:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    sext.h a2, a0
; RV32ZBB-NEXT:    srai a3, a2, 31
; RV32ZBB-NEXT:    xor a0, a2, a0
; RV32ZBB-NEXT:    xor a1, a3, a1
; RV32ZBB-NEXT:    or a0, a0, a1
; RV32ZBB-NEXT:    snez a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: shifts_necmp_i64_i16:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sext.h a1, a0
; RV64ZBB-NEXT:    xor a0, a1, a0
; RV64ZBB-NEXT:    snez a0, a0
; RV64ZBB-NEXT:    ret
  %tmp0 = shl i64 %x, 48 ; 64-16
  %tmp1 = ashr exact i64 %tmp0, 48 ; 64-16
  %tmp2 = icmp ne i64 %tmp1, %x
  ret i1 %tmp2
}

define i1 @shifts_necmp_i64_i8(i64 %x) nounwind {
; RV32I-LABEL: shifts_necmp_i64_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a2, a0, 24
; RV32I-NEXT:    srai a3, a2, 24
; RV32I-NEXT:    srai a2, a2, 31
; RV32I-NEXT:    xor a1, a2, a1
; RV32I-NEXT:    xor a0, a3, a0
; RV32I-NEXT:    or a0, a0, a1
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: shifts_necmp_i64_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a1, a0, 56
; RV64I-NEXT:    srai a1, a1, 56
; RV64I-NEXT:    xor a0, a1, a0
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: shifts_necmp_i64_i8:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    sext.b a2, a0
; RV32ZBB-NEXT:    srai a3, a2, 31
; RV32ZBB-NEXT:    xor a0, a2, a0
; RV32ZBB-NEXT:    xor a1, a3, a1
; RV32ZBB-NEXT:    or a0, a0, a1
; RV32ZBB-NEXT:    snez a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: shifts_necmp_i64_i8:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sext.b a1, a0
; RV64ZBB-NEXT:    xor a0, a1, a0
; RV64ZBB-NEXT:    snez a0, a0
; RV64ZBB-NEXT:    ret
  %tmp0 = shl i64 %x, 56 ; 64-8
  %tmp1 = ashr exact i64 %tmp0, 56 ; 64-8
  %tmp2 = icmp ne i64 %tmp1, %x
  ret i1 %tmp2
}

; ---------------------------------------------------------------------------- ;
; add + icmp ult
; ---------------------------------------------------------------------------- ;

define i1 @add_ultcmp_i16_i8(i16 %x) nounwind {
; RV32I-LABEL: add_ultcmp_i16_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    addi a0, a0, -128
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sltiu a0, a0, 255
; RV32I-NEXT:    ret
;
; RV64I-LABEL: add_ultcmp_i16_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    addi a0, a0, -128
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sltiu a0, a0, 255
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: add_ultcmp_i16_i8:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    addi a0, a0, -128
; RV32ZBB-NEXT:    srli a0, a0, 8
; RV32ZBB-NEXT:    sltiu a0, a0, 255
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: add_ultcmp_i16_i8:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    addi a0, a0, -128
; RV64ZBB-NEXT:    srli a0, a0, 8
; RV64ZBB-NEXT:    sltiu a0, a0, 255
; RV64ZBB-NEXT:    ret
  %tmp0 = add i16 %x, -128 ; ~0U << (8-1)
  %tmp1 = icmp ult i16 %tmp0, -256 ; ~0U << 8
  ret i1 %tmp1
}

define i1 @add_ultcmp_i32_i16(i32 %x) nounwind {
; RV32I-LABEL: add_ultcmp_i32_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 1048568
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    lui a1, 1048560
; RV32I-NEXT:    sltu a0, a0, a1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: add_ultcmp_i32_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1048568
; RV64I-NEXT:    addw a0, a0, a1
; RV64I-NEXT:    lui a1, 1048560
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: add_ultcmp_i32_i16:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    sext.h a1, a0
; RV32ZBB-NEXT:    xor a0, a1, a0
; RV32ZBB-NEXT:    snez a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: add_ultcmp_i32_i16:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sext.w a1, a0
; RV64ZBB-NEXT:    sext.h a0, a0
; RV64ZBB-NEXT:    xor a0, a0, a1
; RV64ZBB-NEXT:    snez a0, a0
; RV64ZBB-NEXT:    ret
  %tmp0 = add i32 %x, -32768 ; ~0U << (16-1)
  %tmp1 = icmp ult i32 %tmp0, -65536 ; ~0U << 16
  ret i1 %tmp1
}

define i1 @add_ultcmp_i32_i8(i32 %x) nounwind {
; RV32-LABEL: add_ultcmp_i32_i8:
; RV32:       # %bb.0:
; RV32-NEXT:    addi a0, a0, -128
; RV32-NEXT:    sltiu a0, a0, -256
; RV32-NEXT:    ret
;
; RV64-LABEL: add_ultcmp_i32_i8:
; RV64:       # %bb.0:
; RV64-NEXT:    addiw a0, a0, -128
; RV64-NEXT:    sltiu a0, a0, -256
; RV64-NEXT:    ret
  %tmp0 = add i32 %x, -128 ; ~0U << (8-1)
  %tmp1 = icmp ult i32 %tmp0, -256 ; ~0U << 8
  ret i1 %tmp1
}

define i1 @add_ultcmp_i64_i32(i64 %x) nounwind {
; RV32-LABEL: add_ultcmp_i64_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    srai a0, a0, 31
; RV32-NEXT:    xor a0, a0, a1
; RV32-NEXT:    snez a0, a0
; RV32-NEXT:    ret
;
; RV64-LABEL: add_ultcmp_i64_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    sext.w a1, a0
; RV64-NEXT:    xor a0, a1, a0
; RV64-NEXT:    snez a0, a0
; RV64-NEXT:    ret
  %tmp0 = add i64 %x, -2147483648 ; ~0U << (32-1)
  %tmp1 = icmp ult i64 %tmp0, -4294967296 ; ~0U << 32
  ret i1 %tmp1
}

define i1 @add_ultcmp_i64_i16(i64 %x) nounwind {
; RV32I-LABEL: add_ultcmp_i64_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 1048568
; RV32I-NEXT:    add a2, a0, a2
; RV32I-NEXT:    sltu a0, a2, a0
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    lui a1, 1048560
; RV32I-NEXT:    sltu a1, a2, a1
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: add_ultcmp_i64_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 1048568
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    lui a1, 1048560
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: add_ultcmp_i64_i16:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    sext.h a2, a0
; RV32ZBB-NEXT:    xor a0, a2, a0
; RV32ZBB-NEXT:    srai a2, a2, 31
; RV32ZBB-NEXT:    xor a1, a2, a1
; RV32ZBB-NEXT:    or a0, a0, a1
; RV32ZBB-NEXT:    snez a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: add_ultcmp_i64_i16:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sext.h a1, a0
; RV64ZBB-NEXT:    xor a0, a1, a0
; RV64ZBB-NEXT:    snez a0, a0
; RV64ZBB-NEXT:    ret
  %tmp0 = add i64 %x, -32768 ; ~0U << (16-1)
  %tmp1 = icmp ult i64 %tmp0, -65536 ; ~0U << 16
  ret i1 %tmp1
}

define i1 @add_ultcmp_i64_i8(i64 %x) nounwind {
; RV32I-LABEL: add_ultcmp_i64_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a2, a0, -128
; RV32I-NEXT:    sltu a0, a2, a0
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    sltiu a1, a2, -256
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV64-LABEL: add_ultcmp_i64_i8:
; RV64:       # %bb.0:
; RV64-NEXT:    addi a0, a0, -128
; RV64-NEXT:    sltiu a0, a0, -256
; RV64-NEXT:    ret
;
; RV32ZBB-LABEL: add_ultcmp_i64_i8:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    sext.b a2, a0
; RV32ZBB-NEXT:    xor a0, a2, a0
; RV32ZBB-NEXT:    srai a2, a2, 31
; RV32ZBB-NEXT:    xor a1, a2, a1
; RV32ZBB-NEXT:    or a0, a0, a1
; RV32ZBB-NEXT:    snez a0, a0
; RV32ZBB-NEXT:    ret
  %tmp0 = add i64 %x, -128 ; ~0U << (8-1)
  %tmp1 = icmp ult i64 %tmp0, -256 ; ~0U << 8
  ret i1 %tmp1
}

; Slightly more canonical variant
define i1 @add_ulecmp_i16_i8(i16 %x) nounwind {
; RV32I-LABEL: add_ulecmp_i16_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    addi a0, a0, -128
; RV32I-NEXT:    srli a0, a0, 8
; RV32I-NEXT:    sltiu a0, a0, 255
; RV32I-NEXT:    ret
;
; RV64I-LABEL: add_ulecmp_i16_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    addi a0, a0, -128
; RV64I-NEXT:    srli a0, a0, 8
; RV64I-NEXT:    sltiu a0, a0, 255
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: add_ulecmp_i16_i8:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    addi a0, a0, -128
; RV32ZBB-NEXT:    srli a0, a0, 8
; RV32ZBB-NEXT:    sltiu a0, a0, 255
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: add_ulecmp_i16_i8:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    addi a0, a0, -128
; RV64ZBB-NEXT:    srli a0, a0, 8
; RV64ZBB-NEXT:    sltiu a0, a0, 255
; RV64ZBB-NEXT:    ret
  %tmp0 = add i16 %x, -128 ; ~0U << (8-1)
  %tmp1 = icmp ule i16 %tmp0, -257 ; ~0U << 8 - 1
  ret i1 %tmp1
}

; ---------------------------------------------------------------------------- ;
; add + icmp uge
; ---------------------------------------------------------------------------- ;

define i1 @add_ugecmp_i16_i8(i16 %x) nounwind {
; RV32I-LABEL: add_ugecmp_i16_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, 128
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    sltiu a0, a0, 256
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: add_ugecmp_i16_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a0, a0, 128
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    sltiu a0, a0, 256
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: add_ugecmp_i16_i8:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    addi a0, a0, 128
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    sltiu a0, a0, 256
; RV32ZBB-NEXT:    xori a0, a0, 1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: add_ugecmp_i16_i8:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    addi a0, a0, 128
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 256
; RV64ZBB-NEXT:    xori a0, a0, 1
; RV64ZBB-NEXT:    ret
  %tmp0 = add i16 %x, 128 ; 1U << (8-1)
  %tmp1 = icmp uge i16 %tmp0, 256 ; 1U << 8
  ret i1 %tmp1
}

define i1 @add_ugecmp_i32_i16(i32 %x) nounwind {
; RV32I-LABEL: add_ugecmp_i32_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a1, 8
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: add_ugecmp_i32_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 8
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    srliw a0, a0, 16
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: add_ugecmp_i32_i16:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    sext.h a1, a0
; RV32ZBB-NEXT:    xor a0, a1, a0
; RV32ZBB-NEXT:    snez a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: add_ugecmp_i32_i16:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sext.w a1, a0
; RV64ZBB-NEXT:    sext.h a0, a0
; RV64ZBB-NEXT:    xor a0, a0, a1
; RV64ZBB-NEXT:    snez a0, a0
; RV64ZBB-NEXT:    ret
  %tmp0 = add i32 %x, 32768 ; 1U << (16-1)
  %tmp1 = icmp uge i32 %tmp0, 65536 ; 1U << 16
  ret i1 %tmp1
}

define i1 @add_ugecmp_i32_i8(i32 %x) nounwind {
; RV32-LABEL: add_ugecmp_i32_i8:
; RV32:       # %bb.0:
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    sltiu a0, a0, 256
; RV32-NEXT:    xori a0, a0, 1
; RV32-NEXT:    ret
;
; RV64-LABEL: add_ugecmp_i32_i8:
; RV64:       # %bb.0:
; RV64-NEXT:    addiw a0, a0, 128
; RV64-NEXT:    sltiu a0, a0, 256
; RV64-NEXT:    xori a0, a0, 1
; RV64-NEXT:    ret
  %tmp0 = add i32 %x, 128 ; 1U << (8-1)
  %tmp1 = icmp uge i32 %tmp0, 256 ; 1U << 8
  ret i1 %tmp1
}

define i1 @add_ugecmp_i64_i32(i64 %x) nounwind {
; RV32-LABEL: add_ugecmp_i64_i32:
; RV32:       # %bb.0:
; RV32-NEXT:    srai a0, a0, 31
; RV32-NEXT:    xor a0, a0, a1
; RV32-NEXT:    snez a0, a0
; RV32-NEXT:    ret
;
; RV64-LABEL: add_ugecmp_i64_i32:
; RV64:       # %bb.0:
; RV64-NEXT:    sext.w a1, a0
; RV64-NEXT:    xor a0, a1, a0
; RV64-NEXT:    snez a0, a0
; RV64-NEXT:    ret
  %tmp0 = add i64 %x, 2147483648 ; 1U << (32-1)
  %tmp1 = icmp uge i64 %tmp0, 4294967296 ; 1U << 32
  ret i1 %tmp1
}

define i1 @add_ugecmp_i64_i16(i64 %x) nounwind {
; RV32I-LABEL: add_ugecmp_i64_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 8
; RV32I-NEXT:    add a2, a0, a2
; RV32I-NEXT:    sltu a0, a2, a0
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    srli a2, a2, 16
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    ret
;
; RV64I-LABEL: add_ugecmp_i64_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a1, 8
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    srli a0, a0, 16
; RV64I-NEXT:    snez a0, a0
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: add_ugecmp_i64_i16:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    sext.h a2, a0
; RV32ZBB-NEXT:    xor a0, a2, a0
; RV32ZBB-NEXT:    srai a2, a2, 31
; RV32ZBB-NEXT:    xor a1, a2, a1
; RV32ZBB-NEXT:    or a0, a0, a1
; RV32ZBB-NEXT:    snez a0, a0
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: add_ugecmp_i64_i16:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    sext.h a1, a0
; RV64ZBB-NEXT:    xor a0, a1, a0
; RV64ZBB-NEXT:    snez a0, a0
; RV64ZBB-NEXT:    ret
  %tmp0 = add i64 %x, 32768 ; 1U << (16-1)
  %tmp1 = icmp uge i64 %tmp0, 65536 ; 1U << 16
  ret i1 %tmp1
}

define i1 @add_ugecmp_i64_i8(i64 %x) nounwind {
; RV32I-LABEL: add_ugecmp_i64_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a2, a0, 128
; RV32I-NEXT:    sltu a0, a2, a0
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    snez a0, a0
; RV32I-NEXT:    sltiu a1, a2, 256
; RV32I-NEXT:    xori a1, a1, 1
; RV32I-NEXT:    or a0, a1, a0
; RV32I-NEXT:    ret
;
; RV64-LABEL: add_ugecmp_i64_i8:
; RV64:       # %bb.0:
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    sltiu a0, a0, 256
; RV64-NEXT:    xori a0, a0, 1
; RV64-NEXT:    ret
;
; RV32ZBB-LABEL: add_ugecmp_i64_i8:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    sext.b a2, a0
; RV32ZBB-NEXT:    xor a0, a2, a0
; RV32ZBB-NEXT:    srai a2, a2, 31
; RV32ZBB-NEXT:    xor a1, a2, a1
; RV32ZBB-NEXT:    or a0, a0, a1
; RV32ZBB-NEXT:    snez a0, a0
; RV32ZBB-NEXT:    ret
  %tmp0 = add i64 %x, 128 ; 1U << (8-1)
  %tmp1 = icmp uge i64 %tmp0, 256 ; 1U << 8
  ret i1 %tmp1
}

; Slightly more canonical variant
define i1 @add_ugtcmp_i16_i8(i16 %x) nounwind {
; RV32I-LABEL: add_ugtcmp_i16_i8:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, 128
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    sltiu a0, a0, 256
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: add_ugtcmp_i16_i8:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a0, a0, 128
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    sltiu a0, a0, 256
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: add_ugtcmp_i16_i8:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    addi a0, a0, 128
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    sltiu a0, a0, 256
; RV32ZBB-NEXT:    xori a0, a0, 1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: add_ugtcmp_i16_i8:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    addi a0, a0, 128
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 256
; RV64ZBB-NEXT:    xori a0, a0, 1
; RV64ZBB-NEXT:    ret
  %tmp0 = add i16 %x, 128 ; 1U << (8-1)
  %tmp1 = icmp ugt i16 %tmp0, 255 ; (1U << 8) - 1
  ret i1 %tmp1
}

; Negative tests
; ---------------------------------------------------------------------------- ;

; Adding not a constant
define i1 @add_ugecmp_bad_i16_i8_add(i16 %x, i16 %y) nounwind {
; RV32I-LABEL: add_ugecmp_bad_i16_i8_add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    add a0, a0, a1
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    sltiu a0, a0, 256
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: add_ugecmp_bad_i16_i8_add:
; RV64I:       # %bb.0:
; RV64I-NEXT:    add a0, a0, a1
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    sltiu a0, a0, 256
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: add_ugecmp_bad_i16_i8_add:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    add a0, a0, a1
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    sltiu a0, a0, 256
; RV32ZBB-NEXT:    xori a0, a0, 1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: add_ugecmp_bad_i16_i8_add:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    add a0, a0, a1
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 256
; RV64ZBB-NEXT:    xori a0, a0, 1
; RV64ZBB-NEXT:    ret
  %tmp0 = add i16 %x, %y
  %tmp1 = icmp uge i16 %tmp0, 256 ; 1U << 8
  ret i1 %tmp1
}

; Comparing not with a constant
define i1 @add_ugecmp_bad_i16_i8_cmp(i16 %x, i16 %y) nounwind {
; RV32I-LABEL: add_ugecmp_bad_i16_i8_cmp:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 16
; RV32I-NEXT:    addi a2, a2, -1
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    addi a0, a0, 128
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    sltu a0, a0, a1
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: add_ugecmp_bad_i16_i8_cmp:
; RV64I:       # %bb.0:
; RV64I-NEXT:    lui a2, 16
; RV64I-NEXT:    addiw a2, a2, -1
; RV64I-NEXT:    and a1, a1, a2
; RV64I-NEXT:    addi a0, a0, 128
; RV64I-NEXT:    and a0, a0, a2
; RV64I-NEXT:    sltu a0, a0, a1
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: add_ugecmp_bad_i16_i8_cmp:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    zext.h a1, a1
; RV32ZBB-NEXT:    addi a0, a0, 128
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    sltu a0, a0, a1
; RV32ZBB-NEXT:    xori a0, a0, 1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: add_ugecmp_bad_i16_i8_cmp:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    zext.h a1, a1
; RV64ZBB-NEXT:    addi a0, a0, 128
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    sltu a0, a0, a1
; RV64ZBB-NEXT:    xori a0, a0, 1
; RV64ZBB-NEXT:    ret
  %tmp0 = add i16 %x, 128 ; 1U << (8-1)
  %tmp1 = icmp uge i16 %tmp0, %y
  ret i1 %tmp1
}

; Second constant is not larger than the first one
define i1 @add_ugecmp_bad_i8_i16(i16 %x) nounwind {
; RV32I-LABEL: add_ugecmp_bad_i8_i16:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, 128
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    sltiu a0, a0, 128
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: add_ugecmp_bad_i8_i16:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a0, a0, 128
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    sltiu a0, a0, 128
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: add_ugecmp_bad_i8_i16:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    addi a0, a0, 128
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    sltiu a0, a0, 128
; RV32ZBB-NEXT:    xori a0, a0, 1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: add_ugecmp_bad_i8_i16:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    addi a0, a0, 128
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 128
; RV64ZBB-NEXT:    xori a0, a0, 1
; RV64ZBB-NEXT:    ret
  %tmp0 = add i16 %x, 128 ; 1U << (8-1)
  %tmp1 = icmp uge i16 %tmp0, 128 ; 1U << (8-1)
  ret i1 %tmp1
}

; First constant is not power of two
define i1 @add_ugecmp_bad_i16_i8_c0notpoweroftwo(i16 %x) nounwind {
; RV32I-LABEL: add_ugecmp_bad_i16_i8_c0notpoweroftwo:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, 192
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    sltiu a0, a0, 256
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: add_ugecmp_bad_i16_i8_c0notpoweroftwo:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a0, a0, 192
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    sltiu a0, a0, 256
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: add_ugecmp_bad_i16_i8_c0notpoweroftwo:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    addi a0, a0, 192
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    sltiu a0, a0, 256
; RV32ZBB-NEXT:    xori a0, a0, 1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: add_ugecmp_bad_i16_i8_c0notpoweroftwo:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    addi a0, a0, 192
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 256
; RV64ZBB-NEXT:    xori a0, a0, 1
; RV64ZBB-NEXT:    ret
  %tmp0 = add i16 %x, 192 ; (1U << (8-1)) + (1U << (8-1-1))
  %tmp1 = icmp uge i16 %tmp0, 256 ; 1U << 8
  ret i1 %tmp1
}

; Second constant is not power of two
define i1 @add_ugecmp_bad_i16_i8_c1notpoweroftwo(i16 %x) nounwind {
; RV32I-LABEL: add_ugecmp_bad_i16_i8_c1notpoweroftwo:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, 128
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    sltiu a0, a0, 768
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: add_ugecmp_bad_i16_i8_c1notpoweroftwo:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a0, a0, 128
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    sltiu a0, a0, 768
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: add_ugecmp_bad_i16_i8_c1notpoweroftwo:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    addi a0, a0, 128
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    sltiu a0, a0, 768
; RV32ZBB-NEXT:    xori a0, a0, 1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: add_ugecmp_bad_i16_i8_c1notpoweroftwo:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    addi a0, a0, 128
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 768
; RV64ZBB-NEXT:    xori a0, a0, 1
; RV64ZBB-NEXT:    ret
  %tmp0 = add i16 %x, 128 ; 1U << (8-1)
  %tmp1 = icmp uge i16 %tmp0, 768 ; (1U << 8)) + (1U << (8+1))
  ret i1 %tmp1
}

; Magic check fails, 64 << 1 != 256
define i1 @add_ugecmp_bad_i16_i8_magic(i16 %x) nounwind {
; RV32I-LABEL: add_ugecmp_bad_i16_i8_magic:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, 64
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    sltiu a0, a0, 256
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: add_ugecmp_bad_i16_i8_magic:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a0, a0, 64
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    sltiu a0, a0, 256
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: add_ugecmp_bad_i16_i8_magic:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    addi a0, a0, 64
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    sltiu a0, a0, 256
; RV32ZBB-NEXT:    xori a0, a0, 1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: add_ugecmp_bad_i16_i8_magic:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    addi a0, a0, 64
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 256
; RV64ZBB-NEXT:    xori a0, a0, 1
; RV64ZBB-NEXT:    ret
  %tmp0 = add i16 %x, 64 ; 1U << (8-1-1)
  %tmp1 = icmp uge i16 %tmp0, 256 ; 1U << 8
  ret i1 %tmp1
}

; Bad 'destination type'
define i1 @add_ugecmp_bad_i16_i4(i16 %x) nounwind {
; RV32I-LABEL: add_ugecmp_bad_i16_i4:
; RV32I:       # %bb.0:
; RV32I-NEXT:    addi a0, a0, 8
; RV32I-NEXT:    slli a0, a0, 16
; RV32I-NEXT:    srli a0, a0, 16
; RV32I-NEXT:    sltiu a0, a0, 16
; RV32I-NEXT:    xori a0, a0, 1
; RV32I-NEXT:    ret
;
; RV64I-LABEL: add_ugecmp_bad_i16_i4:
; RV64I:       # %bb.0:
; RV64I-NEXT:    addi a0, a0, 8
; RV64I-NEXT:    slli a0, a0, 48
; RV64I-NEXT:    srli a0, a0, 48
; RV64I-NEXT:    sltiu a0, a0, 16
; RV64I-NEXT:    xori a0, a0, 1
; RV64I-NEXT:    ret
;
; RV32ZBB-LABEL: add_ugecmp_bad_i16_i4:
; RV32ZBB:       # %bb.0:
; RV32ZBB-NEXT:    addi a0, a0, 8
; RV32ZBB-NEXT:    zext.h a0, a0
; RV32ZBB-NEXT:    sltiu a0, a0, 16
; RV32ZBB-NEXT:    xori a0, a0, 1
; RV32ZBB-NEXT:    ret
;
; RV64ZBB-LABEL: add_ugecmp_bad_i16_i4:
; RV64ZBB:       # %bb.0:
; RV64ZBB-NEXT:    addi a0, a0, 8
; RV64ZBB-NEXT:    zext.h a0, a0
; RV64ZBB-NEXT:    sltiu a0, a0, 16
; RV64ZBB-NEXT:    xori a0, a0, 1
; RV64ZBB-NEXT:    ret
  %tmp0 = add i16 %x, 8 ; 1U << (4-1)
  %tmp1 = icmp uge i16 %tmp0, 16 ; 1U << 4
  ret i1 %tmp1
}

; Bad storage type
define i1 @add_ugecmp_bad_i24_i8(i24 %x) nounwind {
; RV32-LABEL: add_ugecmp_bad_i24_i8:
; RV32:       # %bb.0:
; RV32-NEXT:    addi a0, a0, 128
; RV32-NEXT:    slli a0, a0, 8
; RV32-NEXT:    srli a0, a0, 8
; RV32-NEXT:    sltiu a0, a0, 256
; RV32-NEXT:    xori a0, a0, 1
; RV32-NEXT:    ret
;
; RV64-LABEL: add_ugecmp_bad_i24_i8:
; RV64:       # %bb.0:
; RV64-NEXT:    addi a0, a0, 128
; RV64-NEXT:    slli a0, a0, 40
; RV64-NEXT:    srli a0, a0, 40
; RV64-NEXT:    sltiu a0, a0, 256
; RV64-NEXT:    xori a0, a0, 1
; RV64-NEXT:    ret
  %tmp0 = add i24 %x, 128 ; 1U << (8-1)
  %tmp1 = icmp uge i24 %tmp0, 256 ; 1U << 8
  ret i1 %tmp1
}

; Slightly more canonical variant
define i1 @add_ugtcmp_bad_i16_i8(i16 %x) nounwind {
; CHECK-LABEL: add_ugtcmp_bad_i16_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    li a0, 0
; CHECK-NEXT:    ret
  %tmp0 = add i16 %x, 128 ; 1U << (8-1)
  %tmp1 = icmp ugt i16 %tmp0, -1 ; when we +1 it, it will wrap to 0
  ret i1 %tmp1
}
