; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown | FileCheck %s --check-prefixes=CHECK,X86
; RUN: llc < %s -mtriple=x86_64-unknown | FileCheck %s --check-prefixes=CHECK,X64
; RUN: llc < %s -mtriple=i686-unknown -mattr=+xop | FileCheck %s --check-prefixes=CHECK,X86XOP
; RUN: llc < %s -mtriple=x86_64-unknown -mattr=+avx512bw,+avx512vl,+gfni | FileCheck %s --check-prefixes=CHECK,GFNI

; These tests just check that the plumbing is in place for @llvm.bitreverse. The
; actual output is massive at the moment as llvm.bitreverse is not yet legal.

declare <2 x i16> @llvm.bitreverse.v2i16(<2 x i16>) readnone

define <2 x i16> @test_bitreverse_v2i16(<2 x i16> %a) nounwind {
; X86-LABEL: test_bitreverse_v2i16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    rolw $8, %ax
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    andl $3855, %edx # imm = 0xF0F
; X86-NEXT:    shll $4, %edx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $3855, %eax # imm = 0xF0F
; X86-NEXT:    orl %edx, %eax
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    andl $13107, %edx # imm = 0x3333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $13107, %eax # imm = 0x3333
; X86-NEXT:    leal (%eax,%edx,4), %eax
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    andl $21845, %edx # imm = 0x5555
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $21845, %eax # imm = 0x5555
; X86-NEXT:    leal (%eax,%edx,2), %eax
; X86-NEXT:    rolw $8, %cx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    andl $3855, %edx # imm = 0xF0F
; X86-NEXT:    shll $4, %edx
; X86-NEXT:    shrl $4, %ecx
; X86-NEXT:    andl $3855, %ecx # imm = 0xF0F
; X86-NEXT:    orl %edx, %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    andl $13107, %edx # imm = 0x3333
; X86-NEXT:    shrl $2, %ecx
; X86-NEXT:    andl $13107, %ecx # imm = 0x3333
; X86-NEXT:    leal (%ecx,%edx,4), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    andl $21845, %edx # imm = 0x5555
; X86-NEXT:    shrl %ecx
; X86-NEXT:    andl $21845, %ecx # imm = 0x5555
; X86-NEXT:    leal (%ecx,%edx,2), %edx
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    # kill: def $dx killed $dx killed $edx
; X86-NEXT:    retl
;
; X64-LABEL: test_bitreverse_v2i16:
; X64:       # %bb.0:
; X64-NEXT:    movdqa %xmm0, %xmm1
; X64-NEXT:    psrlw $8, %xmm1
; X64-NEXT:    psllw $8, %xmm0
; X64-NEXT:    por %xmm1, %xmm0
; X64-NEXT:    movdqa %xmm0, %xmm1
; X64-NEXT:    psrlw $4, %xmm1
; X64-NEXT:    movdqa {{.*#+}} xmm2 = [15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15]
; X64-NEXT:    pand %xmm2, %xmm1
; X64-NEXT:    pand %xmm2, %xmm0
; X64-NEXT:    psllw $4, %xmm0
; X64-NEXT:    por %xmm1, %xmm0
; X64-NEXT:    movdqa %xmm0, %xmm1
; X64-NEXT:    psrlw $2, %xmm1
; X64-NEXT:    movdqa {{.*#+}} xmm2 = [51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51]
; X64-NEXT:    pand %xmm2, %xmm1
; X64-NEXT:    pand %xmm2, %xmm0
; X64-NEXT:    psllw $2, %xmm0
; X64-NEXT:    por %xmm1, %xmm0
; X64-NEXT:    movdqa %xmm0, %xmm1
; X64-NEXT:    psrlw $1, %xmm1
; X64-NEXT:    movdqa {{.*#+}} xmm2 = [85,85,85,85,85,85,85,85,85,85,85,85,85,85,85,85]
; X64-NEXT:    pand %xmm2, %xmm1
; X64-NEXT:    pand %xmm2, %xmm0
; X64-NEXT:    paddb %xmm0, %xmm0
; X64-NEXT:    por %xmm1, %xmm0
; X64-NEXT:    retq
;
; X86XOP-LABEL: test_bitreverse_v2i16:
; X86XOP:       # %bb.0:
; X86XOP-NEXT:    vpperm {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0, %xmm0
; X86XOP-NEXT:    retl
;
; GFNI-LABEL: test_bitreverse_v2i16:
; GFNI:       # %bb.0:
; GFNI-NEXT:    vpshufb {{.*#+}} xmm0 = xmm0[1,0,3,2,5,4,7,6,9,8,11,10,13,12,15,14]
; GFNI-NEXT:    vgf2p8affineqb $0, {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; GFNI-NEXT:    retq
  %b = call <2 x i16> @llvm.bitreverse.v2i16(<2 x i16> %a)
  ret <2 x i16> %b
}

declare i64 @llvm.bitreverse.i64(i64) readnone

define i64 @test_bitreverse_i64(i64 %a) nounwind {
; X86-LABEL: test_bitreverse_i64:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    bswapl %eax
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    andl $252645135, %edx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %edx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X86-NEXT:    orl %edx, %eax
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    andl $858993459, %edx # imm = 0x33333333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X86-NEXT:    leal (%eax,%edx,4), %eax
; X86-NEXT:    movl %eax, %edx
; X86-NEXT:    andl $1431655765, %edx # imm = 0x55555555
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $1431655765, %eax # imm = 0x55555555
; X86-NEXT:    leal (%eax,%edx,2), %eax
; X86-NEXT:    bswapl %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    andl $252645135, %edx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %edx
; X86-NEXT:    shrl $4, %ecx
; X86-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; X86-NEXT:    orl %edx, %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    andl $858993459, %edx # imm = 0x33333333
; X86-NEXT:    shrl $2, %ecx
; X86-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; X86-NEXT:    leal (%ecx,%edx,4), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    andl $1431655765, %edx # imm = 0x55555555
; X86-NEXT:    shrl %ecx
; X86-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; X86-NEXT:    leal (%ecx,%edx,2), %edx
; X86-NEXT:    retl
;
; X64-LABEL: test_bitreverse_i64:
; X64:       # %bb.0:
; X64-NEXT:    bswapq %rdi
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    shrq $4, %rax
; X64-NEXT:    movabsq $1085102592571150095, %rcx # imm = 0xF0F0F0F0F0F0F0F
; X64-NEXT:    andq %rcx, %rax
; X64-NEXT:    andq %rcx, %rdi
; X64-NEXT:    shlq $4, %rdi
; X64-NEXT:    orq %rax, %rdi
; X64-NEXT:    movabsq $3689348814741910323, %rax # imm = 0x3333333333333333
; X64-NEXT:    movq %rdi, %rcx
; X64-NEXT:    andq %rax, %rcx
; X64-NEXT:    shrq $2, %rdi
; X64-NEXT:    andq %rax, %rdi
; X64-NEXT:    leaq (%rdi,%rcx,4), %rax
; X64-NEXT:    movabsq $6148914691236517205, %rcx # imm = 0x5555555555555555
; X64-NEXT:    movq %rax, %rdx
; X64-NEXT:    andq %rcx, %rdx
; X64-NEXT:    shrq %rax
; X64-NEXT:    andq %rcx, %rax
; X64-NEXT:    leaq (%rax,%rdx,2), %rax
; X64-NEXT:    retq
;
; X86XOP-LABEL: test_bitreverse_i64:
; X86XOP:       # %bb.0:
; X86XOP-NEXT:    vmovq {{.*#+}} xmm0 = mem[0],zero
; X86XOP-NEXT:    vpperm {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0, %xmm0
; X86XOP-NEXT:    vmovd %xmm0, %eax
; X86XOP-NEXT:    vpextrd $1, %xmm0, %edx
; X86XOP-NEXT:    retl
;
; GFNI-LABEL: test_bitreverse_i64:
; GFNI:       # %bb.0:
; GFNI-NEXT:    bswapq %rdi
; GFNI-NEXT:    movq %rdi, %rax
; GFNI-NEXT:    shrq $4, %rax
; GFNI-NEXT:    movabsq $1085102592571150095, %rcx # imm = 0xF0F0F0F0F0F0F0F
; GFNI-NEXT:    andq %rcx, %rax
; GFNI-NEXT:    andq %rcx, %rdi
; GFNI-NEXT:    shlq $4, %rdi
; GFNI-NEXT:    orq %rax, %rdi
; GFNI-NEXT:    movabsq $3689348814741910323, %rax # imm = 0x3333333333333333
; GFNI-NEXT:    movq %rdi, %rcx
; GFNI-NEXT:    andq %rax, %rcx
; GFNI-NEXT:    shrq $2, %rdi
; GFNI-NEXT:    andq %rax, %rdi
; GFNI-NEXT:    leaq (%rdi,%rcx,4), %rax
; GFNI-NEXT:    movabsq $6148914691236517205, %rcx # imm = 0x5555555555555555
; GFNI-NEXT:    movq %rax, %rdx
; GFNI-NEXT:    andq %rcx, %rdx
; GFNI-NEXT:    shrq %rax
; GFNI-NEXT:    andq %rcx, %rax
; GFNI-NEXT:    leaq (%rax,%rdx,2), %rax
; GFNI-NEXT:    retq
  %b = call i64 @llvm.bitreverse.i64(i64 %a)
  ret i64 %b
}

declare i32 @llvm.bitreverse.i32(i32) readnone

define i32 @test_bitreverse_i32(i32 %a) nounwind {
; X86-LABEL: test_bitreverse_i32:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    bswapl %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $1431655765, %eax # imm = 0x55555555
; X86-NEXT:    leal (%eax,%ecx,2), %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_bitreverse_i32:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    bswapl %edi
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X64-NEXT:    shll $4, %eax
; X64-NEXT:    shrl $4, %edi
; X64-NEXT:    andl $252645135, %edi # imm = 0xF0F0F0F
; X64-NEXT:    orl %eax, %edi
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X64-NEXT:    shrl $2, %edi
; X64-NEXT:    andl $858993459, %edi # imm = 0x33333333
; X64-NEXT:    leal (%rdi,%rax,4), %eax
; X64-NEXT:    movl %eax, %ecx
; X64-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; X64-NEXT:    shrl %eax
; X64-NEXT:    andl $1431655765, %eax # imm = 0x55555555
; X64-NEXT:    leal (%rax,%rcx,2), %eax
; X64-NEXT:    retq
;
; X86XOP-LABEL: test_bitreverse_i32:
; X86XOP:       # %bb.0:
; X86XOP-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86XOP-NEXT:    vpperm {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0, %xmm0
; X86XOP-NEXT:    vmovd %xmm0, %eax
; X86XOP-NEXT:    retl
;
; GFNI-LABEL: test_bitreverse_i32:
; GFNI:       # %bb.0:
; GFNI-NEXT:    # kill: def $edi killed $edi def $rdi
; GFNI-NEXT:    bswapl %edi
; GFNI-NEXT:    movl %edi, %eax
; GFNI-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; GFNI-NEXT:    shll $4, %eax
; GFNI-NEXT:    shrl $4, %edi
; GFNI-NEXT:    andl $252645135, %edi # imm = 0xF0F0F0F
; GFNI-NEXT:    orl %eax, %edi
; GFNI-NEXT:    movl %edi, %eax
; GFNI-NEXT:    andl $858993459, %eax # imm = 0x33333333
; GFNI-NEXT:    shrl $2, %edi
; GFNI-NEXT:    andl $858993459, %edi # imm = 0x33333333
; GFNI-NEXT:    leal (%rdi,%rax,4), %eax
; GFNI-NEXT:    movl %eax, %ecx
; GFNI-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; GFNI-NEXT:    shrl %eax
; GFNI-NEXT:    andl $1431655765, %eax # imm = 0x55555555
; GFNI-NEXT:    leal (%rax,%rcx,2), %eax
; GFNI-NEXT:    retq
  %b = call i32 @llvm.bitreverse.i32(i32 %a)
  ret i32 %b
}

declare i24 @llvm.bitreverse.i24(i24) readnone

define i24 @test_bitreverse_i24(i24 %a) nounwind {
; X86-LABEL: test_bitreverse_i24:
; X86:       # %bb.0:
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    bswapl %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $1431655680, %ecx # imm = 0x55555500
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $1431655680, %eax # imm = 0x55555500
; X86-NEXT:    leal (%eax,%ecx,2), %eax
; X86-NEXT:    shrl $8, %eax
; X86-NEXT:    retl
;
; X64-LABEL: test_bitreverse_i24:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    bswapl %edi
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X64-NEXT:    shll $4, %eax
; X64-NEXT:    shrl $4, %edi
; X64-NEXT:    andl $252645135, %edi # imm = 0xF0F0F0F
; X64-NEXT:    orl %eax, %edi
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X64-NEXT:    shrl $2, %edi
; X64-NEXT:    andl $858993459, %edi # imm = 0x33333333
; X64-NEXT:    leal (%rdi,%rax,4), %eax
; X64-NEXT:    movl %eax, %ecx
; X64-NEXT:    andl $1431655680, %ecx # imm = 0x55555500
; X64-NEXT:    shrl %eax
; X64-NEXT:    andl $1431655680, %eax # imm = 0x55555500
; X64-NEXT:    leal (%rax,%rcx,2), %eax
; X64-NEXT:    shrl $8, %eax
; X64-NEXT:    retq
;
; X86XOP-LABEL: test_bitreverse_i24:
; X86XOP:       # %bb.0:
; X86XOP-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86XOP-NEXT:    vpperm {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0, %xmm0
; X86XOP-NEXT:    vmovd %xmm0, %eax
; X86XOP-NEXT:    shrl $8, %eax
; X86XOP-NEXT:    retl
;
; GFNI-LABEL: test_bitreverse_i24:
; GFNI:       # %bb.0:
; GFNI-NEXT:    # kill: def $edi killed $edi def $rdi
; GFNI-NEXT:    bswapl %edi
; GFNI-NEXT:    movl %edi, %eax
; GFNI-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; GFNI-NEXT:    shll $4, %eax
; GFNI-NEXT:    shrl $4, %edi
; GFNI-NEXT:    andl $252645135, %edi # imm = 0xF0F0F0F
; GFNI-NEXT:    orl %eax, %edi
; GFNI-NEXT:    movl %edi, %eax
; GFNI-NEXT:    andl $858993459, %eax # imm = 0x33333333
; GFNI-NEXT:    shrl $2, %edi
; GFNI-NEXT:    andl $858993459, %edi # imm = 0x33333333
; GFNI-NEXT:    leal (%rdi,%rax,4), %eax
; GFNI-NEXT:    movl %eax, %ecx
; GFNI-NEXT:    andl $1431655680, %ecx # imm = 0x55555500
; GFNI-NEXT:    shrl %eax
; GFNI-NEXT:    andl $1431655680, %eax # imm = 0x55555500
; GFNI-NEXT:    leal (%rax,%rcx,2), %eax
; GFNI-NEXT:    shrl $8, %eax
; GFNI-NEXT:    retq
  %b = call i24 @llvm.bitreverse.i24(i24 %a)
  ret i24 %b
}

declare i16 @llvm.bitreverse.i16(i16) readnone

define i16 @test_bitreverse_i16(i16 %a) nounwind {
; X86-LABEL: test_bitreverse_i16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    rolw $8, %ax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $3855, %ecx # imm = 0xF0F
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $3855, %eax # imm = 0xF0F
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $13107, %ecx # imm = 0x3333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $13107, %eax # imm = 0x3333
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $21845, %ecx # imm = 0x5555
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $21845, %eax # imm = 0x5555
; X86-NEXT:    leal (%eax,%ecx,2), %eax
; X86-NEXT:    # kill: def $ax killed $ax killed $eax
; X86-NEXT:    retl
;
; X64-LABEL: test_bitreverse_i16:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    rolw $8, %di
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $3855, %eax # imm = 0xF0F
; X64-NEXT:    shll $4, %eax
; X64-NEXT:    shrl $4, %edi
; X64-NEXT:    andl $3855, %edi # imm = 0xF0F
; X64-NEXT:    orl %eax, %edi
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andl $13107, %eax # imm = 0x3333
; X64-NEXT:    shrl $2, %edi
; X64-NEXT:    andl $13107, %edi # imm = 0x3333
; X64-NEXT:    leal (%rdi,%rax,4), %eax
; X64-NEXT:    movl %eax, %ecx
; X64-NEXT:    andl $21845, %ecx # imm = 0x5555
; X64-NEXT:    shrl %eax
; X64-NEXT:    andl $21845, %eax # imm = 0x5555
; X64-NEXT:    leal (%rax,%rcx,2), %eax
; X64-NEXT:    # kill: def $ax killed $ax killed $eax
; X64-NEXT:    retq
;
; X86XOP-LABEL: test_bitreverse_i16:
; X86XOP:       # %bb.0:
; X86XOP-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86XOP-NEXT:    vpperm {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0, %xmm0
; X86XOP-NEXT:    vmovd %xmm0, %eax
; X86XOP-NEXT:    # kill: def $ax killed $ax killed $eax
; X86XOP-NEXT:    retl
;
; GFNI-LABEL: test_bitreverse_i16:
; GFNI:       # %bb.0:
; GFNI-NEXT:    # kill: def $edi killed $edi def $rdi
; GFNI-NEXT:    rolw $8, %di
; GFNI-NEXT:    movl %edi, %eax
; GFNI-NEXT:    andl $3855, %eax # imm = 0xF0F
; GFNI-NEXT:    shll $4, %eax
; GFNI-NEXT:    shrl $4, %edi
; GFNI-NEXT:    andl $3855, %edi # imm = 0xF0F
; GFNI-NEXT:    orl %eax, %edi
; GFNI-NEXT:    movl %edi, %eax
; GFNI-NEXT:    andl $13107, %eax # imm = 0x3333
; GFNI-NEXT:    shrl $2, %edi
; GFNI-NEXT:    andl $13107, %edi # imm = 0x3333
; GFNI-NEXT:    leal (%rdi,%rax,4), %eax
; GFNI-NEXT:    movl %eax, %ecx
; GFNI-NEXT:    andl $21845, %ecx # imm = 0x5555
; GFNI-NEXT:    shrl %eax
; GFNI-NEXT:    andl $21845, %eax # imm = 0x5555
; GFNI-NEXT:    leal (%rax,%rcx,2), %eax
; GFNI-NEXT:    # kill: def $ax killed $ax killed $eax
; GFNI-NEXT:    retq
  %b = call i16 @llvm.bitreverse.i16(i16 %a)
  ret i16 %b
}

declare i8 @llvm.bitreverse.i8(i8) readnone

define i8 @test_bitreverse_i8(i8 %a) {
; X86-LABEL: test_bitreverse_i8:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    rolb $4, %al
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andb $51, %cl
; X86-NEXT:    shlb $2, %cl
; X86-NEXT:    shrb $2, %al
; X86-NEXT:    andb $51, %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andb $85, %cl
; X86-NEXT:    addb %cl, %cl
; X86-NEXT:    shrb %al
; X86-NEXT:    andb $85, %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: test_bitreverse_i8:
; X64:       # %bb.0:
; X64-NEXT:    rolb $4, %dil
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $51, %al
; X64-NEXT:    shlb $2, %al
; X64-NEXT:    shrb $2, %dil
; X64-NEXT:    andb $51, %dil
; X64-NEXT:    orb %dil, %al
; X64-NEXT:    movl %eax, %ecx
; X64-NEXT:    andb $85, %cl
; X64-NEXT:    addb %cl, %cl
; X64-NEXT:    shrb %al
; X64-NEXT:    andb $85, %al
; X64-NEXT:    orb %cl, %al
; X64-NEXT:    retq
;
; X86XOP-LABEL: test_bitreverse_i8:
; X86XOP:       # %bb.0:
; X86XOP-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86XOP-NEXT:    vpperm {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0, %xmm0
; X86XOP-NEXT:    vmovd %xmm0, %eax
; X86XOP-NEXT:    # kill: def $al killed $al killed $eax
; X86XOP-NEXT:    retl
;
; GFNI-LABEL: test_bitreverse_i8:
; GFNI:       # %bb.0:
; GFNI-NEXT:    rolb $4, %dil
; GFNI-NEXT:    movl %edi, %eax
; GFNI-NEXT:    andb $51, %al
; GFNI-NEXT:    shlb $2, %al
; GFNI-NEXT:    shrb $2, %dil
; GFNI-NEXT:    andb $51, %dil
; GFNI-NEXT:    orb %dil, %al
; GFNI-NEXT:    movl %eax, %ecx
; GFNI-NEXT:    andb $85, %cl
; GFNI-NEXT:    addb %cl, %cl
; GFNI-NEXT:    shrb %al
; GFNI-NEXT:    andb $85, %al
; GFNI-NEXT:    orb %cl, %al
; GFNI-NEXT:    retq
  %b = call i8 @llvm.bitreverse.i8(i8 %a)
  ret i8 %b
}

declare i4 @llvm.bitreverse.i4(i4) readnone

define i4 @test_bitreverse_i4(i4 %a) {
; X86-LABEL: test_bitreverse_i4:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl %ecx, %eax
; X86-NEXT:    andb $8, %al
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    addb %cl, %dl
; X86-NEXT:    andb $4, %dl
; X86-NEXT:    movb %cl, %ah
; X86-NEXT:    shlb $3, %ah
; X86-NEXT:    andb $8, %ah
; X86-NEXT:    orb %dl, %ah
; X86-NEXT:    shrb %cl
; X86-NEXT:    andb $2, %cl
; X86-NEXT:    orb %ah, %cl
; X86-NEXT:    shrb $3, %al
; X86-NEXT:    orb %cl, %al
; X86-NEXT:    retl
;
; X64-LABEL: test_bitreverse_i4:
; X64:       # %bb.0:
; X64-NEXT:    # kill: def $edi killed $edi def $rdi
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    andb $8, %al
; X64-NEXT:    leal (%rdi,%rdi), %ecx
; X64-NEXT:    andb $4, %cl
; X64-NEXT:    leal (,%rdi,8), %edx
; X64-NEXT:    andb $8, %dl
; X64-NEXT:    orb %cl, %dl
; X64-NEXT:    shrb %dil
; X64-NEXT:    andb $2, %dil
; X64-NEXT:    orb %dil, %dl
; X64-NEXT:    shrb $3, %al
; X64-NEXT:    orb %dl, %al
; X64-NEXT:    retq
;
; X86XOP-LABEL: test_bitreverse_i4:
; X86XOP:       # %bb.0:
; X86XOP-NEXT:    vmovd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; X86XOP-NEXT:    vpperm {{\.?LCPI[0-9]+_[0-9]+}}, %xmm0, %xmm0, %xmm0
; X86XOP-NEXT:    vmovd %xmm0, %eax
; X86XOP-NEXT:    shrb $4, %al
; X86XOP-NEXT:    # kill: def $al killed $al killed $eax
; X86XOP-NEXT:    retl
;
; GFNI-LABEL: test_bitreverse_i4:
; GFNI:       # %bb.0:
; GFNI-NEXT:    # kill: def $edi killed $edi def $rdi
; GFNI-NEXT:    movl %edi, %eax
; GFNI-NEXT:    andb $8, %al
; GFNI-NEXT:    leal (%rdi,%rdi), %ecx
; GFNI-NEXT:    andb $4, %cl
; GFNI-NEXT:    leal (,%rdi,8), %edx
; GFNI-NEXT:    andb $8, %dl
; GFNI-NEXT:    orb %cl, %dl
; GFNI-NEXT:    shrb %dil
; GFNI-NEXT:    andb $2, %dil
; GFNI-NEXT:    orb %dil, %dl
; GFNI-NEXT:    shrb $3, %al
; GFNI-NEXT:    orb %dl, %al
; GFNI-NEXT:    retq
  %b = call i4 @llvm.bitreverse.i4(i4 %a)
  ret i4 %b
}

; These tests check that bitreverse(constant) calls are folded

define <2 x i16> @fold_v2i16() {
; X86-LABEL: fold_v2i16:
; X86:       # %bb.0:
; X86-NEXT:    movw $-4096, %ax # imm = 0xF000
; X86-NEXT:    movw $240, %dx
; X86-NEXT:    retl
;
; X64-LABEL: fold_v2i16:
; X64:       # %bb.0:
; X64-NEXT:    movaps {{.*#+}} xmm0 = <61440,240,u,u,u,u,u,u>
; X64-NEXT:    retq
;
; X86XOP-LABEL: fold_v2i16:
; X86XOP:       # %bb.0:
; X86XOP-NEXT:    vbroadcastss {{.*#+}} xmm0 = [61440,240,61440,240,61440,240,61440,240]
; X86XOP-NEXT:    retl
;
; GFNI-LABEL: fold_v2i16:
; GFNI:       # %bb.0:
; GFNI-NEXT:    vbroadcastss {{.*#+}} xmm0 = [61440,240,61440,240,61440,240,61440,240]
; GFNI-NEXT:    retq
  %b = call <2 x i16> @llvm.bitreverse.v2i16(<2 x i16> <i16 15, i16 3840>)
  ret <2 x i16> %b
}

define i24 @fold_i24() {
; CHECK-LABEL: fold_i24:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movl $2048, %eax # imm = 0x800
; CHECK-NEXT:    ret{{[l|q]}}
  %b = call i24 @llvm.bitreverse.i24(i24 4096)
  ret i24 %b
}

define i8 @fold_i8() {
; CHECK-LABEL: fold_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movb $-16, %al
; CHECK-NEXT:    ret{{[l|q]}}
  %b = call i8 @llvm.bitreverse.i8(i8 15)
  ret i8 %b
}

define i4 @fold_i4() {
; CHECK-LABEL: fold_i4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    movb $1, %al
; CHECK-NEXT:    ret{{[l|q]}}
  %b = call i4 @llvm.bitreverse.i4(i4 8)
  ret i4 %b
}

; These tests check that bitreverse(bitreverse()) calls are removed

define i8 @identity_i8(i8 %a) {
; X86-LABEL: identity_i8:
; X86:       # %bb.0:
; X86-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    retl
;
; X64-LABEL: identity_i8:
; X64:       # %bb.0:
; X64-NEXT:    movl %edi, %eax
; X64-NEXT:    # kill: def $al killed $al killed $eax
; X64-NEXT:    retq
;
; X86XOP-LABEL: identity_i8:
; X86XOP:       # %bb.0:
; X86XOP-NEXT:    movzbl {{[0-9]+}}(%esp), %eax
; X86XOP-NEXT:    retl
;
; GFNI-LABEL: identity_i8:
; GFNI:       # %bb.0:
; GFNI-NEXT:    movl %edi, %eax
; GFNI-NEXT:    # kill: def $al killed $al killed $eax
; GFNI-NEXT:    retq
  %b = call i8 @llvm.bitreverse.i8(i8 %a)
  %c = call i8 @llvm.bitreverse.i8(i8 %b)
  ret i8 %c
}

define <2 x i16> @identity_v2i16(<2 x i16> %a) {
; X86-LABEL: identity_v2i16:
; X86:       # %bb.0:
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movzwl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    retl
;
; X64-LABEL: identity_v2i16:
; X64:       # %bb.0:
; X64-NEXT:    retq
;
; X86XOP-LABEL: identity_v2i16:
; X86XOP:       # %bb.0:
; X86XOP-NEXT:    retl
;
; GFNI-LABEL: identity_v2i16:
; GFNI:       # %bb.0:
; GFNI-NEXT:    retq
  %b = call <2 x i16> @llvm.bitreverse.v2i16(<2 x i16> %a)
  %c = call <2 x i16> @llvm.bitreverse.v2i16(<2 x i16> %b)
  ret <2 x i16> %c
}

; These tests check that bitreverse(undef) calls are removed

define i8 @undef_i8() {
; CHECK-LABEL: undef_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %b = call i8 @llvm.bitreverse.i8(i8 undef)
  ret i8 %b
}

define <2 x i16> @undef_v2i16() {
; CHECK-LABEL: undef_v2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    ret{{[l|q]}}
  %b = call <2 x i16> @llvm.bitreverse.v2i16(<2 x i16> undef)
  ret <2 x i16> %b
}

; Make sure we don't assert during type legalization promoting a large
; bitreverse due to the need for a large shift that won't fit in the i8 returned
; from getShiftAmountTy.
define i528 @large_promotion(i528 %A) nounwind {
; X86-LABEL: large_promotion:
; X86:       # %bb.0:
; X86-NEXT:    pushl %ebp
; X86-NEXT:    pushl %ebx
; X86-NEXT:    pushl %edi
; X86-NEXT:    pushl %esi
; X86-NEXT:    subl $56, %esp
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edx
; X86-NEXT:    movl {{[0-9]+}}(%esp), %esi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %ebx
; X86-NEXT:    bswapl %ebx
; X86-NEXT:    movl %ebx, %ebp
; X86-NEXT:    andl $252645135, %ebp # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %ebp
; X86-NEXT:    shrl $4, %ebx
; X86-NEXT:    andl $252645135, %ebx # imm = 0xF0F0F0F
; X86-NEXT:    orl %ebp, %ebx
; X86-NEXT:    movl %ebx, %ebp
; X86-NEXT:    andl $858993459, %ebp # imm = 0x33333333
; X86-NEXT:    shrl $2, %ebx
; X86-NEXT:    andl $858993459, %ebx # imm = 0x33333333
; X86-NEXT:    leal (%ebx,%ebp,4), %ebx
; X86-NEXT:    movl %ebx, %ebp
; X86-NEXT:    andl $1431633920, %ebp # imm = 0x55550000
; X86-NEXT:    shrl %ebx
; X86-NEXT:    andl $1431633920, %ebx # imm = 0x55550000
; X86-NEXT:    leal (%ebx,%ebp,2), %ebx
; X86-NEXT:    movl %ebx, (%esp) # 4-byte Spill
; X86-NEXT:    bswapl %edi
; X86-NEXT:    movl %edi, %ebx
; X86-NEXT:    andl $252645135, %ebx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %ebx
; X86-NEXT:    shrl $4, %edi
; X86-NEXT:    andl $252645135, %edi # imm = 0xF0F0F0F
; X86-NEXT:    orl %ebx, %edi
; X86-NEXT:    movl %edi, %ebx
; X86-NEXT:    andl $858993459, %ebx # imm = 0x33333333
; X86-NEXT:    shrl $2, %edi
; X86-NEXT:    andl $858993459, %edi # imm = 0x33333333
; X86-NEXT:    leal (%edi,%ebx,4), %edi
; X86-NEXT:    movl %edi, %ebx
; X86-NEXT:    andl $1431655765, %ebx # imm = 0x55555555
; X86-NEXT:    shrl %edi
; X86-NEXT:    andl $1431655765, %edi # imm = 0x55555555
; X86-NEXT:    leal (%edi,%ebx,2), %ebx
; X86-NEXT:    bswapl %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    andl $252645135, %edi # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %edi
; X86-NEXT:    shrl $4, %esi
; X86-NEXT:    andl $252645135, %esi # imm = 0xF0F0F0F
; X86-NEXT:    orl %edi, %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    andl $858993459, %edi # imm = 0x33333333
; X86-NEXT:    shrl $2, %esi
; X86-NEXT:    andl $858993459, %esi # imm = 0x33333333
; X86-NEXT:    leal (%esi,%edi,4), %esi
; X86-NEXT:    movl %esi, %edi
; X86-NEXT:    andl $1431655765, %edi # imm = 0x55555555
; X86-NEXT:    shrl %esi
; X86-NEXT:    andl $1431655765, %esi # imm = 0x55555555
; X86-NEXT:    leal (%esi,%edi,2), %esi
; X86-NEXT:    movl %esi, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    bswapl %edx
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    andl $252645135, %esi # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %esi
; X86-NEXT:    shrl $4, %edx
; X86-NEXT:    andl $252645135, %edx # imm = 0xF0F0F0F
; X86-NEXT:    orl %esi, %edx
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    andl $858993459, %esi # imm = 0x33333333
; X86-NEXT:    shrl $2, %edx
; X86-NEXT:    andl $858993459, %edx # imm = 0x33333333
; X86-NEXT:    leal (%edx,%esi,4), %edx
; X86-NEXT:    movl %edx, %esi
; X86-NEXT:    andl $1431655765, %esi # imm = 0x55555555
; X86-NEXT:    shrl %edx
; X86-NEXT:    andl $1431655765, %edx # imm = 0x55555555
; X86-NEXT:    leal (%edx,%esi,2), %edx
; X86-NEXT:    movl %edx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    bswapl %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    andl $252645135, %edx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %edx
; X86-NEXT:    shrl $4, %ecx
; X86-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; X86-NEXT:    orl %edx, %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    andl $858993459, %edx # imm = 0x33333333
; X86-NEXT:    shrl $2, %ecx
; X86-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; X86-NEXT:    leal (%ecx,%edx,4), %ecx
; X86-NEXT:    movl %ecx, %edx
; X86-NEXT:    andl $1431655765, %edx # imm = 0x55555555
; X86-NEXT:    shrl %ecx
; X86-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; X86-NEXT:    leal (%ecx,%edx,2), %ecx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    bswapl %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $1431655765, %eax # imm = 0x55555555
; X86-NEXT:    leal (%eax,%ecx,2), %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    bswapl %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $1431655765, %eax # imm = 0x55555555
; X86-NEXT:    leal (%eax,%ecx,2), %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    bswapl %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $1431655765, %eax # imm = 0x55555555
; X86-NEXT:    leal (%eax,%ecx,2), %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    bswapl %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $1431655765, %eax # imm = 0x55555555
; X86-NEXT:    leal (%eax,%ecx,2), %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    bswapl %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $1431655765, %eax # imm = 0x55555555
; X86-NEXT:    leal (%eax,%ecx,2), %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    bswapl %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $1431655765, %eax # imm = 0x55555555
; X86-NEXT:    leal (%eax,%ecx,2), %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    bswapl %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $1431655765, %eax # imm = 0x55555555
; X86-NEXT:    leal (%eax,%ecx,2), %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    bswapl %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $1431655765, %eax # imm = 0x55555555
; X86-NEXT:    leal (%eax,%ecx,2), %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    bswapl %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $1431655765, %eax # imm = 0x55555555
; X86-NEXT:    leal (%eax,%ecx,2), %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    bswapl %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $1431655765, %eax # imm = 0x55555555
; X86-NEXT:    leal (%eax,%ecx,2), %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    bswapl %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $1431655765, %eax # imm = 0x55555555
; X86-NEXT:    leal (%eax,%ecx,2), %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    bswapl %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $252645135, %ecx # imm = 0xF0F0F0F
; X86-NEXT:    shll $4, %ecx
; X86-NEXT:    shrl $4, %eax
; X86-NEXT:    andl $252645135, %eax # imm = 0xF0F0F0F
; X86-NEXT:    orl %ecx, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $858993459, %ecx # imm = 0x33333333
; X86-NEXT:    shrl $2, %eax
; X86-NEXT:    andl $858993459, %eax # imm = 0x33333333
; X86-NEXT:    leal (%eax,%ecx,4), %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    andl $1431655765, %ecx # imm = 0x55555555
; X86-NEXT:    shrl %eax
; X86-NEXT:    andl $1431655765, %eax # imm = 0x55555555
; X86-NEXT:    leal (%eax,%ecx,2), %edx
; X86-NEXT:    movl (%esp), %esi # 4-byte Reload
; X86-NEXT:    shrdl $16, %ebx, %esi
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    shrdl $16, %eax, %ebx
; X86-NEXT:    movl %ebx, (%esp) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    shrdl $16, %ecx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    shrdl $16, %eax, %ecx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    shrdl $16, %ecx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    shrdl $16, %eax, %ecx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    shrdl $16, %ecx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    shrdl $16, %eax, %ecx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    shrdl $16, %ecx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    shrdl $16, %eax, %ecx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    shrdl $16, %ecx, %eax
; X86-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebp # 4-byte Reload
; X86-NEXT:    shrdl $16, %ebp, %ecx
; X86-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ebx # 4-byte Reload
; X86-NEXT:    shrdl $16, %ebx, %ebp
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %eax # 4-byte Reload
; X86-NEXT:    shrdl $16, %eax, %ebx
; X86-NEXT:    shrdl $16, %edi, %eax
; X86-NEXT:    movl %eax, %ecx
; X86-NEXT:    shrdl $16, %edx, %edi
; X86-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86-NEXT:    movl %edi, 60(%eax)
; X86-NEXT:    movl %ecx, 56(%eax)
; X86-NEXT:    movl %ebx, 52(%eax)
; X86-NEXT:    movl %ebp, 48(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, 44(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, 40(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, 36(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, 32(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, 28(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, 24(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, 20(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, 16(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, 12(%eax)
; X86-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, 8(%eax)
; X86-NEXT:    movl (%esp), %ecx # 4-byte Reload
; X86-NEXT:    movl %ecx, 4(%eax)
; X86-NEXT:    movl %esi, (%eax)
; X86-NEXT:    shrl $16, %edx
; X86-NEXT:    movw %dx, 64(%eax)
; X86-NEXT:    addl $56, %esp
; X86-NEXT:    popl %esi
; X86-NEXT:    popl %edi
; X86-NEXT:    popl %ebx
; X86-NEXT:    popl %ebp
; X86-NEXT:    retl $4
;
; X64-LABEL: large_promotion:
; X64:       # %bb.0:
; X64-NEXT:    pushq %r15
; X64-NEXT:    pushq %r14
; X64-NEXT:    pushq %r13
; X64-NEXT:    pushq %r12
; X64-NEXT:    pushq %rbx
; X64-NEXT:    movq %rdi, %rax
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r12
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %r15
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rbx
; X64-NEXT:    movq {{[0-9]+}}(%rsp), %rdi
; X64-NEXT:    bswapq %rdi
; X64-NEXT:    movq %rdi, %r10
; X64-NEXT:    shrq $4, %r10
; X64-NEXT:    movabsq $1085102592571150095, %r11 # imm = 0xF0F0F0F0F0F0F0F
; X64-NEXT:    andq %r11, %r10
; X64-NEXT:    andq %r11, %rdi
; X64-NEXT:    shlq $4, %rdi
; X64-NEXT:    orq %r10, %rdi
; X64-NEXT:    movabsq $3689348814741910323, %r10 # imm = 0x3333333333333333
; X64-NEXT:    movq %rdi, %r14
; X64-NEXT:    andq %r10, %r14
; X64-NEXT:    shrq $2, %rdi
; X64-NEXT:    andq %r10, %rdi
; X64-NEXT:    leaq (%rdi,%r14,4), %rdi
; X64-NEXT:    movabsq $6148820866244280320, %r14 # imm = 0x5555000000000000
; X64-NEXT:    movq %rdi, %r13
; X64-NEXT:    andq %r14, %r13
; X64-NEXT:    shrq %rdi
; X64-NEXT:    andq %r14, %rdi
; X64-NEXT:    leaq (%rdi,%r13,2), %rdi
; X64-NEXT:    bswapq %rbx
; X64-NEXT:    movq %rbx, %r14
; X64-NEXT:    shrq $4, %r14
; X64-NEXT:    andq %r11, %r14
; X64-NEXT:    andq %r11, %rbx
; X64-NEXT:    shlq $4, %rbx
; X64-NEXT:    orq %r14, %rbx
; X64-NEXT:    movq %rbx, %r14
; X64-NEXT:    andq %r10, %r14
; X64-NEXT:    shrq $2, %rbx
; X64-NEXT:    andq %r10, %rbx
; X64-NEXT:    leaq (%rbx,%r14,4), %rbx
; X64-NEXT:    movabsq $6148914691236517205, %r14 # imm = 0x5555555555555555
; X64-NEXT:    movq %rbx, %r13
; X64-NEXT:    andq %r14, %r13
; X64-NEXT:    shrq %rbx
; X64-NEXT:    andq %r14, %rbx
; X64-NEXT:    leaq (%rbx,%r13,2), %rbx
; X64-NEXT:    shrdq $48, %rbx, %rdi
; X64-NEXT:    bswapq %r15
; X64-NEXT:    movq %r15, %r13
; X64-NEXT:    shrq $4, %r13
; X64-NEXT:    andq %r11, %r13
; X64-NEXT:    andq %r11, %r15
; X64-NEXT:    shlq $4, %r15
; X64-NEXT:    orq %r13, %r15
; X64-NEXT:    movq %r15, %r13
; X64-NEXT:    andq %r10, %r13
; X64-NEXT:    shrq $2, %r15
; X64-NEXT:    andq %r10, %r15
; X64-NEXT:    leaq (%r15,%r13,4), %r15
; X64-NEXT:    movq %r15, %r13
; X64-NEXT:    andq %r14, %r13
; X64-NEXT:    shrq %r15
; X64-NEXT:    andq %r14, %r15
; X64-NEXT:    leaq (%r15,%r13,2), %r15
; X64-NEXT:    shrdq $48, %r15, %rbx
; X64-NEXT:    bswapq %r12
; X64-NEXT:    movq %r12, %r13
; X64-NEXT:    shrq $4, %r13
; X64-NEXT:    andq %r11, %r13
; X64-NEXT:    andq %r11, %r12
; X64-NEXT:    shlq $4, %r12
; X64-NEXT:    orq %r13, %r12
; X64-NEXT:    movq %r12, %r13
; X64-NEXT:    andq %r10, %r13
; X64-NEXT:    shrq $2, %r12
; X64-NEXT:    andq %r10, %r12
; X64-NEXT:    leaq (%r12,%r13,4), %r12
; X64-NEXT:    movq %r12, %r13
; X64-NEXT:    andq %r14, %r13
; X64-NEXT:    shrq %r12
; X64-NEXT:    andq %r14, %r12
; X64-NEXT:    leaq (%r12,%r13,2), %r12
; X64-NEXT:    shrdq $48, %r12, %r15
; X64-NEXT:    bswapq %r9
; X64-NEXT:    movq %r9, %r13
; X64-NEXT:    shrq $4, %r13
; X64-NEXT:    andq %r11, %r13
; X64-NEXT:    andq %r11, %r9
; X64-NEXT:    shlq $4, %r9
; X64-NEXT:    orq %r13, %r9
; X64-NEXT:    movq %r9, %r13
; X64-NEXT:    andq %r10, %r13
; X64-NEXT:    shrq $2, %r9
; X64-NEXT:    andq %r10, %r9
; X64-NEXT:    leaq (%r9,%r13,4), %r9
; X64-NEXT:    movq %r9, %r13
; X64-NEXT:    andq %r14, %r13
; X64-NEXT:    shrq %r9
; X64-NEXT:    andq %r14, %r9
; X64-NEXT:    leaq (%r9,%r13,2), %r9
; X64-NEXT:    shrdq $48, %r9, %r12
; X64-NEXT:    bswapq %r8
; X64-NEXT:    movq %r8, %r13
; X64-NEXT:    shrq $4, %r13
; X64-NEXT:    andq %r11, %r13
; X64-NEXT:    andq %r11, %r8
; X64-NEXT:    shlq $4, %r8
; X64-NEXT:    orq %r13, %r8
; X64-NEXT:    movq %r8, %r13
; X64-NEXT:    andq %r10, %r13
; X64-NEXT:    shrq $2, %r8
; X64-NEXT:    andq %r10, %r8
; X64-NEXT:    leaq (%r8,%r13,4), %r8
; X64-NEXT:    movq %r8, %r13
; X64-NEXT:    andq %r14, %r13
; X64-NEXT:    shrq %r8
; X64-NEXT:    andq %r14, %r8
; X64-NEXT:    leaq (%r8,%r13,2), %r8
; X64-NEXT:    shrdq $48, %r8, %r9
; X64-NEXT:    bswapq %rcx
; X64-NEXT:    movq %rcx, %r13
; X64-NEXT:    shrq $4, %r13
; X64-NEXT:    andq %r11, %r13
; X64-NEXT:    andq %r11, %rcx
; X64-NEXT:    shlq $4, %rcx
; X64-NEXT:    orq %r13, %rcx
; X64-NEXT:    movq %rcx, %r13
; X64-NEXT:    andq %r10, %r13
; X64-NEXT:    shrq $2, %rcx
; X64-NEXT:    andq %r10, %rcx
; X64-NEXT:    leaq (%rcx,%r13,4), %rcx
; X64-NEXT:    movq %rcx, %r13
; X64-NEXT:    andq %r14, %r13
; X64-NEXT:    shrq %rcx
; X64-NEXT:    andq %r14, %rcx
; X64-NEXT:    leaq (%rcx,%r13,2), %rcx
; X64-NEXT:    shrdq $48, %rcx, %r8
; X64-NEXT:    bswapq %rdx
; X64-NEXT:    movq %rdx, %r13
; X64-NEXT:    shrq $4, %r13
; X64-NEXT:    andq %r11, %r13
; X64-NEXT:    andq %r11, %rdx
; X64-NEXT:    shlq $4, %rdx
; X64-NEXT:    orq %r13, %rdx
; X64-NEXT:    movq %rdx, %r13
; X64-NEXT:    andq %r10, %r13
; X64-NEXT:    shrq $2, %rdx
; X64-NEXT:    andq %r10, %rdx
; X64-NEXT:    leaq (%rdx,%r13,4), %rdx
; X64-NEXT:    movq %rdx, %r13
; X64-NEXT:    andq %r14, %r13
; X64-NEXT:    shrq %rdx
; X64-NEXT:    andq %r14, %rdx
; X64-NEXT:    leaq (%rdx,%r13,2), %rdx
; X64-NEXT:    shrdq $48, %rdx, %rcx
; X64-NEXT:    bswapq %rsi
; X64-NEXT:    movq %rsi, %r13
; X64-NEXT:    shrq $4, %r13
; X64-NEXT:    andq %r11, %r13
; X64-NEXT:    andq %r11, %rsi
; X64-NEXT:    shlq $4, %rsi
; X64-NEXT:    orq %r13, %rsi
; X64-NEXT:    movq %rsi, %r11
; X64-NEXT:    andq %r10, %r11
; X64-NEXT:    shrq $2, %rsi
; X64-NEXT:    andq %r10, %rsi
; X64-NEXT:    leaq (%rsi,%r11,4), %rsi
; X64-NEXT:    movq %rsi, %r10
; X64-NEXT:    andq %r14, %r10
; X64-NEXT:    shrq %rsi
; X64-NEXT:    andq %r14, %rsi
; X64-NEXT:    leaq (%rsi,%r10,2), %rsi
; X64-NEXT:    shrdq $48, %rsi, %rdx
; X64-NEXT:    shrq $48, %rsi
; X64-NEXT:    movq %rdx, 56(%rax)
; X64-NEXT:    movq %rcx, 48(%rax)
; X64-NEXT:    movq %r8, 40(%rax)
; X64-NEXT:    movq %r9, 32(%rax)
; X64-NEXT:    movq %r12, 24(%rax)
; X64-NEXT:    movq %r15, 16(%rax)
; X64-NEXT:    movq %rbx, 8(%rax)
; X64-NEXT:    movq %rdi, (%rax)
; X64-NEXT:    movw %si, 64(%rax)
; X64-NEXT:    popq %rbx
; X64-NEXT:    popq %r12
; X64-NEXT:    popq %r13
; X64-NEXT:    popq %r14
; X64-NEXT:    popq %r15
; X64-NEXT:    retq
;
; X86XOP-LABEL: large_promotion:
; X86XOP:       # %bb.0:
; X86XOP-NEXT:    pushl %ebp
; X86XOP-NEXT:    pushl %ebx
; X86XOP-NEXT:    pushl %edi
; X86XOP-NEXT:    pushl %esi
; X86XOP-NEXT:    subl $44, %esp
; X86XOP-NEXT:    vmovdqa {{.*#+}} xmm0 = [87,86,85,84,83,82,81,80,95,94,93,92,91,90,89,88]
; X86XOP-NEXT:    vmovd {{.*#+}} xmm1 = mem[0],zero,zero,zero
; X86XOP-NEXT:    vpperm %xmm0, %xmm1, %xmm0, %xmm1
; X86XOP-NEXT:    vpextrd $1, %xmm1, %eax
; X86XOP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; X86XOP-NEXT:    vpperm %xmm0, %xmm1, %xmm0, %xmm1
; X86XOP-NEXT:    vmovd %xmm1, %ecx
; X86XOP-NEXT:    shrdl $16, %ecx, %eax
; X86XOP-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86XOP-NEXT:    vpextrd $1, %xmm1, %eax
; X86XOP-NEXT:    shrdl $16, %eax, %ecx
; X86XOP-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86XOP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; X86XOP-NEXT:    vpperm %xmm0, %xmm1, %xmm0, %xmm1
; X86XOP-NEXT:    vmovd %xmm1, %ecx
; X86XOP-NEXT:    shrdl $16, %ecx, %eax
; X86XOP-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86XOP-NEXT:    vpextrd $1, %xmm1, %eax
; X86XOP-NEXT:    shrdl $16, %eax, %ecx
; X86XOP-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86XOP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; X86XOP-NEXT:    vpperm %xmm0, %xmm1, %xmm0, %xmm1
; X86XOP-NEXT:    vmovd %xmm1, %ecx
; X86XOP-NEXT:    shrdl $16, %ecx, %eax
; X86XOP-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86XOP-NEXT:    vpextrd $1, %xmm1, %eax
; X86XOP-NEXT:    shrdl $16, %eax, %ecx
; X86XOP-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86XOP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; X86XOP-NEXT:    vpperm %xmm0, %xmm1, %xmm0, %xmm1
; X86XOP-NEXT:    vmovd %xmm1, %ecx
; X86XOP-NEXT:    shrdl $16, %ecx, %eax
; X86XOP-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86XOP-NEXT:    vpextrd $1, %xmm1, %eax
; X86XOP-NEXT:    shrdl $16, %eax, %ecx
; X86XOP-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86XOP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; X86XOP-NEXT:    vpperm %xmm0, %xmm1, %xmm0, %xmm1
; X86XOP-NEXT:    vmovd %xmm1, %ecx
; X86XOP-NEXT:    shrdl $16, %ecx, %eax
; X86XOP-NEXT:    movl %eax, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86XOP-NEXT:    vpextrd $1, %xmm1, %eax
; X86XOP-NEXT:    shrdl $16, %eax, %ecx
; X86XOP-NEXT:    movl %ecx, {{[-0-9]+}}(%e{{[sb]}}p) # 4-byte Spill
; X86XOP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; X86XOP-NEXT:    vpperm %xmm0, %xmm1, %xmm0, %xmm1
; X86XOP-NEXT:    vmovd %xmm1, %ebp
; X86XOP-NEXT:    shrdl $16, %ebp, %eax
; X86XOP-NEXT:    movl %eax, (%esp) # 4-byte Spill
; X86XOP-NEXT:    vpextrd $1, %xmm1, %ebx
; X86XOP-NEXT:    shrdl $16, %ebx, %ebp
; X86XOP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; X86XOP-NEXT:    vpperm %xmm0, %xmm1, %xmm0, %xmm1
; X86XOP-NEXT:    vmovd %xmm1, %esi
; X86XOP-NEXT:    shrdl $16, %esi, %ebx
; X86XOP-NEXT:    vpextrd $1, %xmm1, %edx
; X86XOP-NEXT:    shrdl $16, %edx, %esi
; X86XOP-NEXT:    vmovq {{.*#+}} xmm1 = mem[0],zero
; X86XOP-NEXT:    vpperm %xmm0, %xmm1, %xmm0, %xmm0
; X86XOP-NEXT:    vmovd %xmm0, %ecx
; X86XOP-NEXT:    shrdl $16, %ecx, %edx
; X86XOP-NEXT:    vpextrd $1, %xmm0, %edi
; X86XOP-NEXT:    shrdl $16, %edi, %ecx
; X86XOP-NEXT:    movl {{[0-9]+}}(%esp), %eax
; X86XOP-NEXT:    movl %ecx, 60(%eax)
; X86XOP-NEXT:    movl %edx, 56(%eax)
; X86XOP-NEXT:    movl %esi, 52(%eax)
; X86XOP-NEXT:    movl %ebx, 48(%eax)
; X86XOP-NEXT:    movl %ebp, 44(%eax)
; X86XOP-NEXT:    movl (%esp), %ecx # 4-byte Reload
; X86XOP-NEXT:    movl %ecx, 40(%eax)
; X86XOP-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86XOP-NEXT:    movl %ecx, 36(%eax)
; X86XOP-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86XOP-NEXT:    movl %ecx, 32(%eax)
; X86XOP-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86XOP-NEXT:    movl %ecx, 28(%eax)
; X86XOP-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86XOP-NEXT:    movl %ecx, 24(%eax)
; X86XOP-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86XOP-NEXT:    movl %ecx, 20(%eax)
; X86XOP-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86XOP-NEXT:    movl %ecx, 16(%eax)
; X86XOP-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86XOP-NEXT:    movl %ecx, 12(%eax)
; X86XOP-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86XOP-NEXT:    movl %ecx, 8(%eax)
; X86XOP-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86XOP-NEXT:    movl %ecx, 4(%eax)
; X86XOP-NEXT:    movl {{[-0-9]+}}(%e{{[sb]}}p), %ecx # 4-byte Reload
; X86XOP-NEXT:    movl %ecx, (%eax)
; X86XOP-NEXT:    shrl $16, %edi
; X86XOP-NEXT:    movw %di, 64(%eax)
; X86XOP-NEXT:    addl $44, %esp
; X86XOP-NEXT:    popl %esi
; X86XOP-NEXT:    popl %edi
; X86XOP-NEXT:    popl %ebx
; X86XOP-NEXT:    popl %ebp
; X86XOP-NEXT:    retl $4
;
; GFNI-LABEL: large_promotion:
; GFNI:       # %bb.0:
; GFNI-NEXT:    pushq %r15
; GFNI-NEXT:    pushq %r14
; GFNI-NEXT:    pushq %r13
; GFNI-NEXT:    pushq %r12
; GFNI-NEXT:    pushq %rbx
; GFNI-NEXT:    movq %rdi, %rax
; GFNI-NEXT:    movq {{[0-9]+}}(%rsp), %r12
; GFNI-NEXT:    movq {{[0-9]+}}(%rsp), %r15
; GFNI-NEXT:    movq {{[0-9]+}}(%rsp), %rbx
; GFNI-NEXT:    movq {{[0-9]+}}(%rsp), %rdi
; GFNI-NEXT:    bswapq %rdi
; GFNI-NEXT:    movq %rdi, %r10
; GFNI-NEXT:    shrq $4, %r10
; GFNI-NEXT:    movabsq $1085102592571150095, %r11 # imm = 0xF0F0F0F0F0F0F0F
; GFNI-NEXT:    andq %r11, %r10
; GFNI-NEXT:    andq %r11, %rdi
; GFNI-NEXT:    shlq $4, %rdi
; GFNI-NEXT:    orq %r10, %rdi
; GFNI-NEXT:    movabsq $3689348814741910323, %r10 # imm = 0x3333333333333333
; GFNI-NEXT:    movq %rdi, %r14
; GFNI-NEXT:    andq %r10, %r14
; GFNI-NEXT:    shrq $2, %rdi
; GFNI-NEXT:    andq %r10, %rdi
; GFNI-NEXT:    leaq (%rdi,%r14,4), %rdi
; GFNI-NEXT:    movabsq $6148820866244280320, %r14 # imm = 0x5555000000000000
; GFNI-NEXT:    movq %rdi, %r13
; GFNI-NEXT:    andq %r14, %r13
; GFNI-NEXT:    shrq %rdi
; GFNI-NEXT:    andq %r14, %rdi
; GFNI-NEXT:    leaq (%rdi,%r13,2), %rdi
; GFNI-NEXT:    bswapq %rbx
; GFNI-NEXT:    movq %rbx, %r14
; GFNI-NEXT:    shrq $4, %r14
; GFNI-NEXT:    andq %r11, %r14
; GFNI-NEXT:    andq %r11, %rbx
; GFNI-NEXT:    shlq $4, %rbx
; GFNI-NEXT:    orq %r14, %rbx
; GFNI-NEXT:    movq %rbx, %r14
; GFNI-NEXT:    andq %r10, %r14
; GFNI-NEXT:    shrq $2, %rbx
; GFNI-NEXT:    andq %r10, %rbx
; GFNI-NEXT:    leaq (%rbx,%r14,4), %rbx
; GFNI-NEXT:    movabsq $6148914691236517205, %r14 # imm = 0x5555555555555555
; GFNI-NEXT:    movq %rbx, %r13
; GFNI-NEXT:    andq %r14, %r13
; GFNI-NEXT:    shrq %rbx
; GFNI-NEXT:    andq %r14, %rbx
; GFNI-NEXT:    leaq (%rbx,%r13,2), %rbx
; GFNI-NEXT:    shrdq $48, %rbx, %rdi
; GFNI-NEXT:    bswapq %r15
; GFNI-NEXT:    movq %r15, %r13
; GFNI-NEXT:    shrq $4, %r13
; GFNI-NEXT:    andq %r11, %r13
; GFNI-NEXT:    andq %r11, %r15
; GFNI-NEXT:    shlq $4, %r15
; GFNI-NEXT:    orq %r13, %r15
; GFNI-NEXT:    movq %r15, %r13
; GFNI-NEXT:    andq %r10, %r13
; GFNI-NEXT:    shrq $2, %r15
; GFNI-NEXT:    andq %r10, %r15
; GFNI-NEXT:    leaq (%r15,%r13,4), %r15
; GFNI-NEXT:    movq %r15, %r13
; GFNI-NEXT:    andq %r14, %r13
; GFNI-NEXT:    shrq %r15
; GFNI-NEXT:    andq %r14, %r15
; GFNI-NEXT:    leaq (%r15,%r13,2), %r15
; GFNI-NEXT:    shrdq $48, %r15, %rbx
; GFNI-NEXT:    bswapq %r12
; GFNI-NEXT:    movq %r12, %r13
; GFNI-NEXT:    shrq $4, %r13
; GFNI-NEXT:    andq %r11, %r13
; GFNI-NEXT:    andq %r11, %r12
; GFNI-NEXT:    shlq $4, %r12
; GFNI-NEXT:    orq %r13, %r12
; GFNI-NEXT:    movq %r12, %r13
; GFNI-NEXT:    andq %r10, %r13
; GFNI-NEXT:    shrq $2, %r12
; GFNI-NEXT:    andq %r10, %r12
; GFNI-NEXT:    leaq (%r12,%r13,4), %r12
; GFNI-NEXT:    movq %r12, %r13
; GFNI-NEXT:    andq %r14, %r13
; GFNI-NEXT:    shrq %r12
; GFNI-NEXT:    andq %r14, %r12
; GFNI-NEXT:    leaq (%r12,%r13,2), %r12
; GFNI-NEXT:    shrdq $48, %r12, %r15
; GFNI-NEXT:    bswapq %r9
; GFNI-NEXT:    movq %r9, %r13
; GFNI-NEXT:    shrq $4, %r13
; GFNI-NEXT:    andq %r11, %r13
; GFNI-NEXT:    andq %r11, %r9
; GFNI-NEXT:    shlq $4, %r9
; GFNI-NEXT:    orq %r13, %r9
; GFNI-NEXT:    movq %r9, %r13
; GFNI-NEXT:    andq %r10, %r13
; GFNI-NEXT:    shrq $2, %r9
; GFNI-NEXT:    andq %r10, %r9
; GFNI-NEXT:    leaq (%r9,%r13,4), %r9
; GFNI-NEXT:    movq %r9, %r13
; GFNI-NEXT:    andq %r14, %r13
; GFNI-NEXT:    shrq %r9
; GFNI-NEXT:    andq %r14, %r9
; GFNI-NEXT:    leaq (%r9,%r13,2), %r9
; GFNI-NEXT:    shrdq $48, %r9, %r12
; GFNI-NEXT:    bswapq %r8
; GFNI-NEXT:    movq %r8, %r13
; GFNI-NEXT:    shrq $4, %r13
; GFNI-NEXT:    andq %r11, %r13
; GFNI-NEXT:    andq %r11, %r8
; GFNI-NEXT:    shlq $4, %r8
; GFNI-NEXT:    orq %r13, %r8
; GFNI-NEXT:    movq %r8, %r13
; GFNI-NEXT:    andq %r10, %r13
; GFNI-NEXT:    shrq $2, %r8
; GFNI-NEXT:    andq %r10, %r8
; GFNI-NEXT:    leaq (%r8,%r13,4), %r8
; GFNI-NEXT:    movq %r8, %r13
; GFNI-NEXT:    andq %r14, %r13
; GFNI-NEXT:    shrq %r8
; GFNI-NEXT:    andq %r14, %r8
; GFNI-NEXT:    leaq (%r8,%r13,2), %r8
; GFNI-NEXT:    shrdq $48, %r8, %r9
; GFNI-NEXT:    bswapq %rcx
; GFNI-NEXT:    movq %rcx, %r13
; GFNI-NEXT:    shrq $4, %r13
; GFNI-NEXT:    andq %r11, %r13
; GFNI-NEXT:    andq %r11, %rcx
; GFNI-NEXT:    shlq $4, %rcx
; GFNI-NEXT:    orq %r13, %rcx
; GFNI-NEXT:    movq %rcx, %r13
; GFNI-NEXT:    andq %r10, %r13
; GFNI-NEXT:    shrq $2, %rcx
; GFNI-NEXT:    andq %r10, %rcx
; GFNI-NEXT:    leaq (%rcx,%r13,4), %rcx
; GFNI-NEXT:    movq %rcx, %r13
; GFNI-NEXT:    andq %r14, %r13
; GFNI-NEXT:    shrq %rcx
; GFNI-NEXT:    andq %r14, %rcx
; GFNI-NEXT:    leaq (%rcx,%r13,2), %rcx
; GFNI-NEXT:    shrdq $48, %rcx, %r8
; GFNI-NEXT:    bswapq %rdx
; GFNI-NEXT:    movq %rdx, %r13
; GFNI-NEXT:    shrq $4, %r13
; GFNI-NEXT:    andq %r11, %r13
; GFNI-NEXT:    andq %r11, %rdx
; GFNI-NEXT:    shlq $4, %rdx
; GFNI-NEXT:    orq %r13, %rdx
; GFNI-NEXT:    movq %rdx, %r13
; GFNI-NEXT:    andq %r10, %r13
; GFNI-NEXT:    shrq $2, %rdx
; GFNI-NEXT:    andq %r10, %rdx
; GFNI-NEXT:    leaq (%rdx,%r13,4), %rdx
; GFNI-NEXT:    movq %rdx, %r13
; GFNI-NEXT:    andq %r14, %r13
; GFNI-NEXT:    shrq %rdx
; GFNI-NEXT:    andq %r14, %rdx
; GFNI-NEXT:    leaq (%rdx,%r13,2), %rdx
; GFNI-NEXT:    shrdq $48, %rdx, %rcx
; GFNI-NEXT:    bswapq %rsi
; GFNI-NEXT:    movq %rsi, %r13
; GFNI-NEXT:    shrq $4, %r13
; GFNI-NEXT:    andq %r11, %r13
; GFNI-NEXT:    andq %r11, %rsi
; GFNI-NEXT:    shlq $4, %rsi
; GFNI-NEXT:    orq %r13, %rsi
; GFNI-NEXT:    movq %rsi, %r11
; GFNI-NEXT:    andq %r10, %r11
; GFNI-NEXT:    shrq $2, %rsi
; GFNI-NEXT:    andq %r10, %rsi
; GFNI-NEXT:    leaq (%rsi,%r11,4), %rsi
; GFNI-NEXT:    movq %rsi, %r10
; GFNI-NEXT:    andq %r14, %r10
; GFNI-NEXT:    shrq %rsi
; GFNI-NEXT:    andq %r14, %rsi
; GFNI-NEXT:    leaq (%rsi,%r10,2), %rsi
; GFNI-NEXT:    shrdq $48, %rsi, %rdx
; GFNI-NEXT:    shrq $48, %rsi
; GFNI-NEXT:    movq %rdx, 56(%rax)
; GFNI-NEXT:    movq %rcx, 48(%rax)
; GFNI-NEXT:    movq %r8, 40(%rax)
; GFNI-NEXT:    movq %r9, 32(%rax)
; GFNI-NEXT:    movq %r12, 24(%rax)
; GFNI-NEXT:    movq %r15, 16(%rax)
; GFNI-NEXT:    movq %rbx, 8(%rax)
; GFNI-NEXT:    movq %rdi, (%rax)
; GFNI-NEXT:    movw %si, 64(%rax)
; GFNI-NEXT:    popq %rbx
; GFNI-NEXT:    popq %r12
; GFNI-NEXT:    popq %r13
; GFNI-NEXT:    popq %r14
; GFNI-NEXT:    popq %r15
; GFNI-NEXT:    retq
  %Z = call i528 @llvm.bitreverse.i528(i528 %A)
  ret i528 %Z
}
declare i528 @llvm.bitreverse.i528(i528)
