; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -march=amdgcn -mcpu=gfx1100 -verify-machineinstrs < %s | FileCheck -check-prefix=ATTRIB %s
; RUN: llc -march=amdgcn -mcpu=gfx1100 -amdgpu-nsa-threshold=2 -verify-machineinstrs < %s | FileCheck -check-prefix=FORCE-2 %s
; RUN: llc -march=amdgcn -mcpu=gfx1100 -amdgpu-nsa-threshold=3 -verify-machineinstrs < %s | FileCheck -check-prefix=FORCE-3 %s
; RUN: llc -march=amdgcn -mcpu=gfx1100 -amdgpu-nsa-threshold=4 -verify-machineinstrs < %s | FileCheck -check-prefix=FORCE-4 %s

; Note: command line argument should override function attribute.

define amdgpu_ps <4 x float> @sample_2d_nsa2(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %t, float %s) #2 {
; ATTRIB-LABEL: sample_2d_nsa2:
; ATTRIB:       ; %bb.0: ; %main_body
; ATTRIB-NEXT:    s_mov_b32 s12, exec_lo
; ATTRIB-NEXT:    s_wqm_b32 exec_lo, exec_lo
; ATTRIB-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; ATTRIB-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; ATTRIB-NEXT:    image_sample v[0:3], [v1, v0], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_2D
; ATTRIB-NEXT:    s_waitcnt vmcnt(0)
; ATTRIB-NEXT:    ; return to shader part epilog
;
; FORCE-2-LABEL: sample_2d_nsa2:
; FORCE-2:       ; %bb.0: ; %main_body
; FORCE-2-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-2-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-2-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; FORCE-2-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-2-NEXT:    image_sample v[0:3], [v1, v0], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_2D
; FORCE-2-NEXT:    s_waitcnt vmcnt(0)
; FORCE-2-NEXT:    ; return to shader part epilog
;
; FORCE-3-LABEL: sample_2d_nsa2:
; FORCE-3:       ; %bb.0: ; %main_body
; FORCE-3-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-3-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-3-NEXT:    v_mov_b32_e32 v2, v0
; FORCE-3-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-3-NEXT:    image_sample v[0:3], v[1:2], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_2D
; FORCE-3-NEXT:    s_waitcnt vmcnt(0)
; FORCE-3-NEXT:    ; return to shader part epilog
;
; FORCE-4-LABEL: sample_2d_nsa2:
; FORCE-4:       ; %bb.0: ; %main_body
; FORCE-4-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-4-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-4-NEXT:    v_mov_b32_e32 v2, v0
; FORCE-4-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-4-NEXT:    image_sample v[0:3], v[1:2], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_2D
; FORCE-4-NEXT:    s_waitcnt vmcnt(0)
; FORCE-4-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.2d.v4f32.f32(i32 15, float %s, float %t, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_3d_nsa2(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %r, float %s, float %t) #2 {
; ATTRIB-LABEL: sample_3d_nsa2:
; ATTRIB:       ; %bb.0: ; %main_body
; ATTRIB-NEXT:    s_mov_b32 s12, exec_lo
; ATTRIB-NEXT:    s_wqm_b32 exec_lo, exec_lo
; ATTRIB-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; ATTRIB-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; ATTRIB-NEXT:    image_sample v[0:3], [v1, v2, v0], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_3D
; ATTRIB-NEXT:    s_waitcnt vmcnt(0)
; ATTRIB-NEXT:    ; return to shader part epilog
;
; FORCE-2-LABEL: sample_3d_nsa2:
; FORCE-2:       ; %bb.0: ; %main_body
; FORCE-2-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-2-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-2-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; FORCE-2-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-2-NEXT:    image_sample v[0:3], [v1, v2, v0], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_3D
; FORCE-2-NEXT:    s_waitcnt vmcnt(0)
; FORCE-2-NEXT:    ; return to shader part epilog
;
; FORCE-3-LABEL: sample_3d_nsa2:
; FORCE-3:       ; %bb.0: ; %main_body
; FORCE-3-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-3-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-3-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; FORCE-3-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-3-NEXT:    image_sample v[0:3], [v1, v2, v0], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_3D
; FORCE-3-NEXT:    s_waitcnt vmcnt(0)
; FORCE-3-NEXT:    ; return to shader part epilog
;
; FORCE-4-LABEL: sample_3d_nsa2:
; FORCE-4:       ; %bb.0: ; %main_body
; FORCE-4-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-4-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-4-NEXT:    v_mov_b32_e32 v3, v0
; FORCE-4-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-4-NEXT:    image_sample v[0:3], v[1:3], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_3D
; FORCE-4-NEXT:    s_waitcnt vmcnt(0)
; FORCE-4-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.3d.v4f32.f32(i32 15, float %s, float %t, float %r, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_2d_nsa3(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %t, float %s) #3 {
; ATTRIB-LABEL: sample_2d_nsa3:
; ATTRIB:       ; %bb.0: ; %main_body
; ATTRIB-NEXT:    s_mov_b32 s12, exec_lo
; ATTRIB-NEXT:    s_wqm_b32 exec_lo, exec_lo
; ATTRIB-NEXT:    v_mov_b32_e32 v2, v0
; ATTRIB-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; ATTRIB-NEXT:    image_sample v[0:3], v[1:2], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_2D
; ATTRIB-NEXT:    s_waitcnt vmcnt(0)
; ATTRIB-NEXT:    ; return to shader part epilog
;
; FORCE-2-LABEL: sample_2d_nsa3:
; FORCE-2:       ; %bb.0: ; %main_body
; FORCE-2-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-2-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-2-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; FORCE-2-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-2-NEXT:    image_sample v[0:3], [v1, v0], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_2D
; FORCE-2-NEXT:    s_waitcnt vmcnt(0)
; FORCE-2-NEXT:    ; return to shader part epilog
;
; FORCE-3-LABEL: sample_2d_nsa3:
; FORCE-3:       ; %bb.0: ; %main_body
; FORCE-3-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-3-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-3-NEXT:    v_mov_b32_e32 v2, v0
; FORCE-3-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-3-NEXT:    image_sample v[0:3], v[1:2], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_2D
; FORCE-3-NEXT:    s_waitcnt vmcnt(0)
; FORCE-3-NEXT:    ; return to shader part epilog
;
; FORCE-4-LABEL: sample_2d_nsa3:
; FORCE-4:       ; %bb.0: ; %main_body
; FORCE-4-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-4-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-4-NEXT:    v_mov_b32_e32 v2, v0
; FORCE-4-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-4-NEXT:    image_sample v[0:3], v[1:2], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_2D
; FORCE-4-NEXT:    s_waitcnt vmcnt(0)
; FORCE-4-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.2d.v4f32.f32(i32 15, float %s, float %t, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_3d_nsa3(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %r, float %s, float %t) #3 {
; ATTRIB-LABEL: sample_3d_nsa3:
; ATTRIB:       ; %bb.0: ; %main_body
; ATTRIB-NEXT:    s_mov_b32 s12, exec_lo
; ATTRIB-NEXT:    s_wqm_b32 exec_lo, exec_lo
; ATTRIB-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; ATTRIB-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; ATTRIB-NEXT:    image_sample v[0:3], [v1, v2, v0], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_3D
; ATTRIB-NEXT:    s_waitcnt vmcnt(0)
; ATTRIB-NEXT:    ; return to shader part epilog
;
; FORCE-2-LABEL: sample_3d_nsa3:
; FORCE-2:       ; %bb.0: ; %main_body
; FORCE-2-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-2-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-2-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; FORCE-2-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-2-NEXT:    image_sample v[0:3], [v1, v2, v0], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_3D
; FORCE-2-NEXT:    s_waitcnt vmcnt(0)
; FORCE-2-NEXT:    ; return to shader part epilog
;
; FORCE-3-LABEL: sample_3d_nsa3:
; FORCE-3:       ; %bb.0: ; %main_body
; FORCE-3-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-3-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-3-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; FORCE-3-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-3-NEXT:    image_sample v[0:3], [v1, v2, v0], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_3D
; FORCE-3-NEXT:    s_waitcnt vmcnt(0)
; FORCE-3-NEXT:    ; return to shader part epilog
;
; FORCE-4-LABEL: sample_3d_nsa3:
; FORCE-4:       ; %bb.0: ; %main_body
; FORCE-4-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-4-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-4-NEXT:    v_mov_b32_e32 v3, v0
; FORCE-4-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-4-NEXT:    image_sample v[0:3], v[1:3], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_3D
; FORCE-4-NEXT:    s_waitcnt vmcnt(0)
; FORCE-4-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.3d.v4f32.f32(i32 15, float %s, float %t, float %r, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_2d_nsa4(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %t, float %s) #4 {
; ATTRIB-LABEL: sample_2d_nsa4:
; ATTRIB:       ; %bb.0: ; %main_body
; ATTRIB-NEXT:    s_mov_b32 s12, exec_lo
; ATTRIB-NEXT:    s_wqm_b32 exec_lo, exec_lo
; ATTRIB-NEXT:    v_mov_b32_e32 v2, v0
; ATTRIB-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; ATTRIB-NEXT:    image_sample v[0:3], v[1:2], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_2D
; ATTRIB-NEXT:    s_waitcnt vmcnt(0)
; ATTRIB-NEXT:    ; return to shader part epilog
;
; FORCE-2-LABEL: sample_2d_nsa4:
; FORCE-2:       ; %bb.0: ; %main_body
; FORCE-2-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-2-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-2-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; FORCE-2-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-2-NEXT:    image_sample v[0:3], [v1, v0], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_2D
; FORCE-2-NEXT:    s_waitcnt vmcnt(0)
; FORCE-2-NEXT:    ; return to shader part epilog
;
; FORCE-3-LABEL: sample_2d_nsa4:
; FORCE-3:       ; %bb.0: ; %main_body
; FORCE-3-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-3-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-3-NEXT:    v_mov_b32_e32 v2, v0
; FORCE-3-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-3-NEXT:    image_sample v[0:3], v[1:2], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_2D
; FORCE-3-NEXT:    s_waitcnt vmcnt(0)
; FORCE-3-NEXT:    ; return to shader part epilog
;
; FORCE-4-LABEL: sample_2d_nsa4:
; FORCE-4:       ; %bb.0: ; %main_body
; FORCE-4-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-4-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-4-NEXT:    v_mov_b32_e32 v2, v0
; FORCE-4-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-4-NEXT:    image_sample v[0:3], v[1:2], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_2D
; FORCE-4-NEXT:    s_waitcnt vmcnt(0)
; FORCE-4-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.2d.v4f32.f32(i32 15, float %s, float %t, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

define amdgpu_ps <4 x float> @sample_3d_nsa4(<8 x i32> inreg %rsrc, <4 x i32> inreg %samp, float %r, float %s, float %t) #4 {
; ATTRIB-LABEL: sample_3d_nsa4:
; ATTRIB:       ; %bb.0: ; %main_body
; ATTRIB-NEXT:    s_mov_b32 s12, exec_lo
; ATTRIB-NEXT:    s_wqm_b32 exec_lo, exec_lo
; ATTRIB-NEXT:    v_mov_b32_e32 v3, v0
; ATTRIB-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; ATTRIB-NEXT:    image_sample v[0:3], v[1:3], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_3D
; ATTRIB-NEXT:    s_waitcnt vmcnt(0)
; ATTRIB-NEXT:    ; return to shader part epilog
;
; FORCE-2-LABEL: sample_3d_nsa4:
; FORCE-2:       ; %bb.0: ; %main_body
; FORCE-2-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-2-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-2-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; FORCE-2-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-2-NEXT:    image_sample v[0:3], [v1, v2, v0], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_3D
; FORCE-2-NEXT:    s_waitcnt vmcnt(0)
; FORCE-2-NEXT:    ; return to shader part epilog
;
; FORCE-3-LABEL: sample_3d_nsa4:
; FORCE-3:       ; %bb.0: ; %main_body
; FORCE-3-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-3-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-3-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; FORCE-3-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-3-NEXT:    image_sample v[0:3], [v1, v2, v0], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_3D
; FORCE-3-NEXT:    s_waitcnt vmcnt(0)
; FORCE-3-NEXT:    ; return to shader part epilog
;
; FORCE-4-LABEL: sample_3d_nsa4:
; FORCE-4:       ; %bb.0: ; %main_body
; FORCE-4-NEXT:    s_mov_b32 s12, exec_lo
; FORCE-4-NEXT:    s_wqm_b32 exec_lo, exec_lo
; FORCE-4-NEXT:    v_mov_b32_e32 v3, v0
; FORCE-4-NEXT:    s_and_b32 exec_lo, exec_lo, s12
; FORCE-4-NEXT:    image_sample v[0:3], v[1:3], s[0:7], s[8:11] dmask:0xf dim:SQ_RSRC_IMG_3D
; FORCE-4-NEXT:    s_waitcnt vmcnt(0)
; FORCE-4-NEXT:    ; return to shader part epilog
main_body:
  %v = call <4 x float> @llvm.amdgcn.image.sample.3d.v4f32.f32(i32 15, float %s, float %t, float %r, <8 x i32> %rsrc, <4 x i32> %samp, i1 0, i32 0, i32 0)
  ret <4 x float> %v
}

declare <4 x float> @llvm.amdgcn.image.sample.2d.v4f32.f32(i32, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1
declare <4 x float> @llvm.amdgcn.image.sample.3d.v4f32.f32(i32, float, float, float, <8 x i32>, <4 x i32>, i1, i32, i32) #1

attributes #1 = { nounwind readonly }
attributes #2 = { nounwind readonly "amdgpu-nsa-threshold"="2" }
attributes #3 = { nounwind readonly "amdgpu-nsa-threshold"="3" }
attributes #4 = { nounwind readonly "amdgpu-nsa-threshold"="4" }
