/* Generated by JTB 1.5.1 */
package grammars.b.visitor;

import static grammars.b.syntaxtree.NodeConstants.*;
import grammars.b.Token;
import grammars.b.syntaxtree.*;
import grammars.b.visitor.signature.NodeFieldsSignature;

/**
 * Provides default methods which visit each node in the tree in depth-first order.<br>
 * In your "Ret" visitors extend this class and override part or all of these methods.
 *
 * @param <R> - The return type parameter
 */
public class DepthFirstRetVisitor<R> implements IRetVisitor<R> {


  /*
   * Base nodes classes visit methods (to be overridden if necessary)
   */

  /**
   * Visits a {@link NodeChoice} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final NodeChoice n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    final R nRes = n.choice.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link NodeList} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final NodeList n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    R nRes = null;
    for (INode e : n.nodes) {
      @SuppressWarnings("unused")
      final R sRes = e.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link NodeListOptional} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final NodeListOptional n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    if (n.present()) {
      R nRes = null;
      for (INode e : n.nodes) {
        @SuppressWarnings("unused")
        R sRes = e.accept(this);
      }
      return nRes;
    }
    return null;
  }

  /**
   * Visits a {@link NodeOptional} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final NodeOptional n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    if (n.present()) {
      final R nRes = n.node.accept(this);
      return nRes;
    }
    return null;
  }

  /**
   * Visits a {@link NodeSequence} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final NodeSequence n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    R nRes = null;
    for (INode e : n.nodes) {
      @SuppressWarnings("unused")
      R subRet = e.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link Token} node.
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  public R visit(final Token n) {
    /* You have to adapt which data is returned (result variables below are just examples) */
    R nRes = null;
    @SuppressWarnings("unused")
    final String tkIm = n.image;
    return nRes;
  }

  /*
   * User grammar generated visit methods (to be overridden if necessary)
   */

  /**
   * Visits a {@link jcp_v$} node, with no child :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @SuppressWarnings("unused")
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_JCP_V$, JTB_USER_JCP_V$ })
  public R visit(final jcp_v$ n) {
    R nRes = null;
    /* empty node, nothing that can be generated so far */
    return nRes;
  }

  /**
   * Visits a {@link jcp_iv$} node, with no child :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @SuppressWarnings("unused")
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_JCP_IV$, JTB_USER_JCP_IV$ })
  public R visit(final jcp_iv$ n) {
    R nRes = null;
    /* empty node, nothing that can be generated so far */
    return nRes;
  }

  /**
   * Visits a {@link jcp_ui$} node, with no child :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @SuppressWarnings("unused")
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_JCP_UI$, JTB_USER_JCP_UI$ })
  public R visit(final jcp_ui$ n) {
    R nRes = null;
    /* empty node, nothing that can be generated so far */
    return nRes;
  }

  /**
   * Visits a {@link jcp_s$} node, with no child :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @SuppressWarnings("unused")
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_JCP_S$, JTB_USER_JCP_S$ })
  public R visit(final jcp_s$ n) {
    R nRes = null;
    /* empty node, nothing that can be generated so far */
    return nRes;
  }

  /**
   * Visits a {@link jcp_ubar$} node, with no child :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @SuppressWarnings("unused")
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_JCP_UBAR$, JTB_USER_JCP_UBAR$ })
  public R visit(final jcp_ubar$ n) {
    R nRes = null;
    /* empty node, nothing that can be generated so far */
    return nRes;
  }

  /**
   * Visits a {@link Start} node, whose child is the following :
   * <p>
   * f0 -> . %0 < EOF ><br>
   * .. .. | %1 #00 bp_v() #01 bp_v_()<br>
   * .. .. . .. #02 bp_w() #03 bp_w_() #04 bp_x()<br>
   * .. .. . .. #05 bp_x_() #06 bp_x__() #07 bp_y()<br>
   * .. .. . .. #08 bp_y_() #09 bp_z_() #10 bp_z__()<br>
   * .. .. . .. #11 bp_v_o() #12 bp_v_o() #13 bp_ui()<br>
   * .. .. . .. #14 bp_s() #15 bp_sa()<br>
   * .. .. . .. #16 bp_v1() #17 bp_v2() #18 bp_v3()<br>
   * .. .. . .. #19 bp_s1() #20 bp_s2() #21 bp_s3()<br>
   * .. .. . .. #22 bp_c() #23 bp_ca() #24 bp_h()<br>
   * .. .. . .. #25 bp_haa() #26 bp_l()<br>
   * .. .. . .. #27 bp_d() #28 bp_da() #29 bp_f()<br>
   * .. .. . .. #30 bp_jual() #31 bp_hm() #32 < EOF ><br>
   * .. .. | %2 #0 ";" #1 bp_tu_a() #2 bp_acc()<br>
   * .. .. . .. #3 bp_DoubleThrows()<br>
   * .. .. . .. :4 bp_DoubleThrows()<br>
   * .. .. . .. #5 jcp_DoubleThrows()<br>
   * .. .. . .. :6 jcp_DoubleThrows()<br>
   * .. .. . .. #7 skipButBuild() #8 < EOF ><br>
   * .. .. | %3 #0 "," #1 expch_a() #2 expch_b()<br>
   * .. .. . .. #3 expch_c() #4 expch_c() #5 expch_c()<br>
   * .. .. . .. #6 expch_c() #7 expch_c() #8 expch_c()<br>
   * .. .. | %4 #0 "." #1 expch_em_lxac() #2 expch_em_lxac()<br>
   * .. .. . .. #3 expch_em_lxac() #4 expch_em_lxac()<br>
   * .. .. . .. #5 expch_wnsn() #6 expch_wnsn() #7 expch_2ch()<br>
   * s: 1245641368<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1245641368, JTB_SIG_START, JTB_USER_START })
  public R visit(final Start n) {
    R nRes = null;
    // f0 -> . %0 < EOF >
    // .. .. | %1 #00 bp_v() #01 bp_v_()
    // .. .. . .. #02 bp_w() #03 bp_w_() #04 bp_x()
    // .. .. . .. #05 bp_x_() #06 bp_x__() #07 bp_y()
    // .. .. . .. #08 bp_y_() #09 bp_z_() #10 bp_z__()
    // .. .. . .. #11 bp_v_o() #12 bp_v_o() #13 bp_ui()
    // .. .. . .. #14 bp_s() #15 bp_sa()
    // .. .. . .. #16 bp_v1() #17 bp_v2() #18 bp_v3()
    // .. .. . .. #19 bp_s1() #20 bp_s2() #21 bp_s3()
    // .. .. . .. #22 bp_c() #23 bp_ca() #24 bp_h()
    // .. .. . .. #25 bp_haa() #26 bp_l()
    // .. .. . .. #27 bp_d() #28 bp_da() #29 bp_f()
    // .. .. . .. #30 bp_jual() #31 bp_hm() #32 < EOF >
    // .. .. | %2 #0 ";" #1 bp_tu_a() #2 bp_acc()
    // .. .. . .. #3 bp_DoubleThrows()
    // .. .. . .. :4 bp_DoubleThrows()
    // .. .. . .. #5 jcp_DoubleThrows()
    // .. .. . .. :6 jcp_DoubleThrows()
    // .. .. . .. #7 skipButBuild() #8 < EOF >
    // .. .. | %3 #0 "," #1 expch_a() #2 expch_b()
    // .. .. . .. #3 expch_c() #4 expch_c() #5 expch_c()
    // .. .. . .. #6 expch_c() #7 expch_c() #8 expch_c()
    // .. .. | %4 #0 "." #1 expch_em_lxac() #2 expch_em_lxac()
    // .. .. . .. #3 expch_em_lxac() #4 expch_em_lxac()
    // .. .. . .. #5 expch_wnsn() #6 expch_wnsn() #7 expch_2ch()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < EOF >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 #00 bp_v() #01 bp_v_()
        //.. #02 bp_w() #03 bp_w_() #04 bp_x()
        //.. #05 bp_x_() #06 bp_x__() #07 bp_y()
        //.. #08 bp_y_() #09 bp_z_() #10 bp_z__()
        //.. #11 bp_v_o() #12 bp_v_o() #13 bp_ui()
        //.. #14 bp_s() #15 bp_sa()
        //.. #16 bp_v1() #17 bp_v2() #18 bp_v3()
        //.. #19 bp_s1() #20 bp_s2() #21 bp_s3()
        //.. #22 bp_c() #23 bp_ca() #24 bp_h()
        //.. #25 bp_haa() #26 bp_l()
        //.. #27 bp_d() #28 bp_da() #29 bp_f()
        //.. #30 bp_jual() #31 bp_hm() #32 < EOF >
        final NodeSequence seq = (NodeSequence) ich;
        //#00 bp_v()
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#01 bp_v_()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        //#02 bp_w()
        final INode nd2 = seq.elementAt(2);
        nRes = nd2.accept(this);
        //#03 bp_w_()
        final INode nd3 = seq.elementAt(3);
        nRes = nd3.accept(this);
        //#04 bp_x()
        final INode nd4 = seq.elementAt(4);
        nRes = nd4.accept(this);
        //#05 bp_x_()
        final INode nd5 = seq.elementAt(5);
        nRes = nd5.accept(this);
        //#06 bp_x__()
        final INode nd6 = seq.elementAt(6);
        nRes = nd6.accept(this);
        //#07 bp_y()
        final INode nd7 = seq.elementAt(7);
        nRes = nd7.accept(this);
        //#08 bp_y_()
        final INode nd8 = seq.elementAt(8);
        nRes = nd8.accept(this);
        //#09 bp_z_()
        final INode nd9 = seq.elementAt(9);
        nRes = nd9.accept(this);
        //#10 bp_z__()
        final INode nd10 = seq.elementAt(10);
        nRes = nd10.accept(this);
        //#11 bp_v_o()
        final INode nd11 = seq.elementAt(11);
        nRes = nd11.accept(this);
        //#12 bp_v_o()
        final INode nd12 = seq.elementAt(12);
        nRes = nd12.accept(this);
        //#13 bp_ui()
        final INode nd13 = seq.elementAt(13);
        nRes = nd13.accept(this);
        //#14 bp_s()
        final INode nd14 = seq.elementAt(14);
        nRes = nd14.accept(this);
        //#15 bp_sa()
        final INode nd15 = seq.elementAt(15);
        nRes = nd15.accept(this);
        //#16 bp_v1()
        final INode nd16 = seq.elementAt(16);
        nRes = nd16.accept(this);
        //#17 bp_v2()
        final INode nd17 = seq.elementAt(17);
        nRes = nd17.accept(this);
        //#18 bp_v3()
        final INode nd18 = seq.elementAt(18);
        nRes = nd18.accept(this);
        //#19 bp_s1()
        final INode nd19 = seq.elementAt(19);
        nRes = nd19.accept(this);
        //#20 bp_s2()
        final INode nd20 = seq.elementAt(20);
        nRes = nd20.accept(this);
        //#21 bp_s3()
        final INode nd21 = seq.elementAt(21);
        nRes = nd21.accept(this);
        //#22 bp_c()
        final INode nd22 = seq.elementAt(22);
        nRes = nd22.accept(this);
        //#23 bp_ca()
        final INode nd23 = seq.elementAt(23);
        nRes = nd23.accept(this);
        //#24 bp_h()
        final INode nd24 = seq.elementAt(24);
        nRes = nd24.accept(this);
        //#25 bp_haa()
        final INode nd25 = seq.elementAt(25);
        nRes = nd25.accept(this);
        //#26 bp_l()
        final INode nd26 = seq.elementAt(26);
        nRes = nd26.accept(this);
        //#27 bp_d()
        final INode nd27 = seq.elementAt(27);
        nRes = nd27.accept(this);
        //#28 bp_da()
        final INode nd28 = seq.elementAt(28);
        nRes = nd28.accept(this);
        //#29 bp_f()
        final INode nd29 = seq.elementAt(29);
        nRes = nd29.accept(this);
        //#30 bp_jual()
        final INode nd30 = seq.elementAt(30);
        nRes = nd30.accept(this);
        //#31 bp_hm()
        final INode nd31 = seq.elementAt(31);
        nRes = nd31.accept(this);
        //#32 < EOF >
        final INode nd32 = seq.elementAt(32);
        nRes = nd32.accept(this);
        break;
      case 2:
        //%2 #0 ";" #1 bp_tu_a() #2 bp_acc()
        //.. #3 bp_DoubleThrows()
        //.. :4 bp_DoubleThrows()
        //.. #5 jcp_DoubleThrows()
        //.. :6 jcp_DoubleThrows()
        //.. #7 skipButBuild() #8 < EOF >
        final NodeSequence seq1 = (NodeSequence) ich;
        //#0 ";"
        final INode nd33 = seq1.elementAt(0);
        nRes = nd33.accept(this);
        //#1 bp_tu_a()
        final INode nd34 = seq1.elementAt(1);
        nRes = nd34.accept(this);
        //#2 bp_acc()
        final INode nd35 = seq1.elementAt(2);
        nRes = nd35.accept(this);
        //#3 bp_DoubleThrows()
        final INode nd36 = seq1.elementAt(3);
        nRes = nd36.accept(this);
        //:4 bp_DoubleThrows()
        final INode nd37 = seq1.elementAt(4);
        if (nd37 != null) {
          nRes = nd37.accept(this);
        }
        //#5 jcp_DoubleThrows()
        final INode nd38 = seq1.elementAt(5);
        nRes = nd38.accept(this);
        //:6 jcp_DoubleThrows()
        final INode nd39 = seq1.elementAt(6);
        if (nd39 != null) {
          nRes = nd39.accept(this);
        }
        //#7 skipButBuild()
        final INode nd40 = seq1.elementAt(7);
        nRes = nd40.accept(this);
        //#8 < EOF >
        final INode nd41 = seq1.elementAt(8);
        nRes = nd41.accept(this);
        break;
      case 3:
        //%3 #0 "," #1 expch_a() #2 expch_b()
        //.. #3 expch_c() #4 expch_c() #5 expch_c()
        //.. #6 expch_c() #7 expch_c() #8 expch_c()
        final NodeSequence seq2 = (NodeSequence) ich;
        //#0 ","
        final INode nd42 = seq2.elementAt(0);
        nRes = nd42.accept(this);
        //#1 expch_a()
        final INode nd43 = seq2.elementAt(1);
        nRes = nd43.accept(this);
        //#2 expch_b()
        final INode nd44 = seq2.elementAt(2);
        nRes = nd44.accept(this);
        //#3 expch_c()
        final INode nd45 = seq2.elementAt(3);
        nRes = nd45.accept(this);
        //#4 expch_c()
        final INode nd46 = seq2.elementAt(4);
        nRes = nd46.accept(this);
        //#5 expch_c()
        final INode nd47 = seq2.elementAt(5);
        nRes = nd47.accept(this);
        //#6 expch_c()
        final INode nd48 = seq2.elementAt(6);
        nRes = nd48.accept(this);
        //#7 expch_c()
        final INode nd49 = seq2.elementAt(7);
        nRes = nd49.accept(this);
        //#8 expch_c()
        final INode nd50 = seq2.elementAt(8);
        nRes = nd50.accept(this);
        break;
      case 4:
        //%4 #0 "." #1 expch_em_lxac() #2 expch_em_lxac()
        //.. #3 expch_em_lxac() #4 expch_em_lxac()
        //.. #5 expch_wnsn() #6 expch_wnsn() #7 expch_2ch()
        final NodeSequence seq3 = (NodeSequence) ich;
        //#0 "."
        final INode nd51 = seq3.elementAt(0);
        nRes = nd51.accept(this);
        //#1 expch_em_lxac()
        final INode nd52 = seq3.elementAt(1);
        nRes = nd52.accept(this);
        //#2 expch_em_lxac()
        final INode nd53 = seq3.elementAt(2);
        nRes = nd53.accept(this);
        //#3 expch_em_lxac()
        final INode nd54 = seq3.elementAt(3);
        nRes = nd54.accept(this);
        //#4 expch_em_lxac()
        final INode nd55 = seq3.elementAt(4);
        nRes = nd55.accept(this);
        //#5 expch_wnsn()
        final INode nd56 = seq3.elementAt(5);
        nRes = nd56.accept(this);
        //#6 expch_wnsn()
        final INode nd57 = seq3.elementAt(6);
        nRes = nd57.accept(this);
        //#7 expch_2ch()
        final INode nd58 = seq3.elementAt(7);
        nRes = nd58.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link bp_v} node, whose child is the following :
   * <p>
   * f0 -> < ID ><br>
   * s: -1032372970<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1032372970, JTB_SIG_BP_V, JTB_USER_BP_V })
  public R visit(final bp_v n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_v_} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_BP_V_, JTB_USER_BP_V_ })
  public R visit(final bp_v_ n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link bp_w} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_BP_W, JTB_USER_BP_W })
  public R visit(final bp_w n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link bp_w_} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_BP_W_, JTB_USER_BP_W_ })
  public R visit(final bp_w_ n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link bp_x} node, whose child is the following :
   * <p>
   * f0 -> bp_v()<br>
   * s: 130120127<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 130120127, JTB_SIG_BP_X, JTB_USER_BP_X })
  public R visit(final bp_x n) {
    R nRes = null;
    // f0 -> bp_v()
    final bp_v n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_x_} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_BP_X_, JTB_USER_BP_X_ })
  public R visit(final bp_x_ n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link bp_x__} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_BP_X__, JTB_USER_BP_X__ })
  public R visit(final bp_x__ n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link bp_y} node, whose children are the following :
   * <p>
   * f0 -> < Y:":y" ><br>
   * f1 -> ":"<br>
   * s: 1249636947<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1249636947, JTB_SIG_BP_Y, JTB_USER_BP_Y })
  public R visit(final bp_y n) {
    R nRes = null;
    // f0 -> < Y:":y" >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ":"
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_y_} node, whose child is the following :
   * <p>
   * f0 -> "!"<br>
   * s: 2055659818<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 2055659818, JTB_SIG_BP_Y_, JTB_USER_BP_Y_ })
  public R visit(final bp_y_ n) {
    R nRes = null;
    // f0 -> "!"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_z_} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_BP_Z_, JTB_USER_BP_Z_ })
  public R visit(final bp_z_ n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link bp_z__} node, whose child is the following :
   * <p>
   * f0 -> bp_y_()<br>
   * s: -261101121<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -261101121, JTB_SIG_BP_Z__, JTB_USER_BP_Z__ })
  public R visit(final bp_z__ n) {
    R nRes = null;
    // f0 -> bp_y_()
    final bp_y_ n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_v_o} node, whose children are the following :
   * <p>
   * f0 -> ( %0 #0 ( &0 "_foo"<br>
   * .. .. . .. .. | &1 {} )<br>
   * .. .. . .. #1 "_bar" #2 < ID ><br>
   * .. .. | %1 #0 "_bar" #1 "_bar" )<br>
   * f1 -> ( %0 #0 ( &0 {}<br>
   * .. .. . .. .. | &1 "_foo" )<br>
   * .. .. . .. #1 "_bar" #2 < ID ><br>
   * .. .. | %1 #0 "_bar" #1 "_bar" )<br>
   * s: 1752869627<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1752869627, JTB_SIG_BP_V_O, JTB_USER_BP_V_O })
  public R visit(final bp_v_o n) {
    R nRes = null;
    // f0 -> ( %0 #0 ( &0 "_foo"
    // .. .. . .. .. | &1 {} )
    // .. .. . .. #1 "_bar" #2 < ID >
    // .. .. | %1 #0 "_bar" #1 "_bar" )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 ( &0 "_foo"
        //.. .. | &1 {} )
        //.. #1 "_bar" #2 < ID >
        final NodeSequence seq = (NodeSequence) ich;
        //#0 ( &0 "_foo"
        //.. | &1 {} )
        final INode nd = seq.elementAt(0);
        final NodeChoice nch1 = (NodeChoice) nd;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            //&0 "_foo"
            nRes = ich1.accept(this);
            break;
          case 1:
            //&1 {}
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch1);
        }
        //#1 "_bar"
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        //#2 < ID >
        final INode nd2 = seq.elementAt(2);
        nRes = nd2.accept(this);
        break;
      case 1:
        //%1 #0 "_bar" #1 "_bar"
        final NodeSequence seq1 = (NodeSequence) ich;
        //#0 "_bar"
        final INode nd3 = seq1.elementAt(0);
        nRes = nd3.accept(this);
        //#1 "_bar"
        final INode nd4 = seq1.elementAt(1);
        nRes = nd4.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    // f1 -> ( %0 #0 ( &0 {}
    // .. .. . .. .. | &1 "_foo" )
    // .. .. . .. #1 "_bar" #2 < ID >
    // .. .. | %1 #0 "_bar" #1 "_bar" )
    final NodeChoice n1 = n.f1;
    final NodeChoice nch2 = n1;
    final INode ich2 = nch2.choice;
    switch (nch2.which) {
      case 0:
        //%0 #0 ( &0 {}
        //.. .. | &1 "_foo" )
        //.. #1 "_bar" #2 < ID >
        final NodeSequence seq2 = (NodeSequence) ich2;
        //#0 ( &0 {}
        //.. | &1 "_foo" )
        final INode nd5 = seq2.elementAt(0);
        final NodeChoice nch3 = (NodeChoice) nd5;
        final INode ich3 = nch3.choice;
        switch (nch3.which) {
          case 0:
            //&0 {}
            break;
          case 1:
            //&1 "_foo"
            nRes = ich3.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch3);
        }
        //#1 "_bar"
        final INode nd6 = seq2.elementAt(1);
        nRes = nd6.accept(this);
        //#2 < ID >
        final INode nd7 = seq2.elementAt(2);
        nRes = nd7.accept(this);
        break;
      case 1:
        //%1 #0 "_bar" #1 "_bar"
        final NodeSequence seq3 = (NodeSequence) ich2;
        //#0 "_bar"
        final INode nd8 = seq3.elementAt(0);
        nRes = nd8.accept(this);
        //#1 "_bar"
        final INode nd9 = seq3.elementAt(1);
        nRes = nd9.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch2);
    }
    return nRes;
  }

  /**
   * Visits a {@link bp_i} node, whose child is the following :
   * <p>
   * f0 -> < ID ><br>
   * s: -1032372970<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1032372970, JTB_SIG_BP_I, JTB_USER_BP_I })
  public R visit(final bp_i n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_i2} node, whose child is the following :
   * <p>
   * f0 -> bp_i()<br>
   * s: 130107634<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 130107634, JTB_SIG_BP_I2, JTB_USER_BP_I2 })
  public R visit(final bp_i2 n) {
    R nRes = null;
    // f0 -> bp_i()
    final bp_i n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_ui} node, whose child is the following :
   * <p>
   * f0 -> < ID >.kind<br>
   * s: 1875637612<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1875637612, JTB_SIG_BP_UI, JTB_USER_BP_UI })
  public R visit(final bp_ui n) {
    R nRes = null;
    // f0 -> < ID >.kind
    final Token n0 = n.f0;
    nRes = n0.accept(this);
// Please report to support with a real example of your grammar if you want the suffix to be generated : $1 [ ?0 "." ?1 < IDENTIFIER > ]
    return nRes;
  }

  /**
   * Visits a {@link bp_s} node, whose child is the following :
   * <p>
   * f0 -> < ID ><br>
   * s: -1032372970<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1032372970, JTB_SIG_BP_S, JTB_USER_BP_S })
  public R visit(final bp_s n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_tcf_ie_w} node, whose child is the following :
   * <p>
   * f0 -> < ID ><br>
   * s: -1032372970<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1032372970, JTB_SIG_BP_TCF_IE_W, JTB_USER_BP_TCF_IE_W })
  public R visit(final bp_tcf_ie_w n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_sa} node, whose child is the following :
   * <p>
   * f0 -> < ID ><br>
   * s: -1032372970<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1032372970, JTB_SIG_BP_SA, JTB_USER_BP_SA })
  public R visit(final bp_sa n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_v1} node, whose child is the following :
   * <p>
   * f0 -> bp_v()<br>
   * s: 130120127<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 130120127, JTB_SIG_BP_V1, JTB_USER_BP_V1 })
  public R visit(final bp_v1 n) {
    R nRes = null;
    // f0 -> bp_v()
    final bp_v n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_v2} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_BP_V2, JTB_USER_BP_V2 })
  public R visit(final bp_v2 n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link bp_v3} node, whose child is the following :
   * <p>
   * f0 -> bp_v()<br>
   * s: 130120127<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 130120127, JTB_SIG_BP_V3, JTB_USER_BP_V3 })
  public R visit(final bp_v3 n) {
    R nRes = null;
    // f0 -> bp_v()
    final bp_v n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_s1} node, whose child is the following :
   * <p>
   * f0 -> bp_s()<br>
   * s: 130117244<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 130117244, JTB_SIG_BP_S1, JTB_USER_BP_S1 })
  public R visit(final bp_s1 n) {
    R nRes = null;
    // f0 -> bp_s()
    final bp_s n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_s2} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_BP_S2, JTB_USER_BP_S2 })
  public R visit(final bp_s2 n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link bp_s3} node, whose child is the following :
   * <p>
   * f0 -> bp_s()<br>
   * s: 130117244<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 130117244, JTB_SIG_BP_S3, JTB_USER_BP_S3 })
  public R visit(final bp_s3 n) {
    R nRes = null;
    // f0 -> bp_s()
    final bp_s n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_c} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_BP_C, JTB_USER_BP_C })
  public R visit(final bp_c n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link bp_ca} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_BP_CA, JTB_USER_BP_CA })
  public R visit(final bp_ca n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link bp_h} node, whose child is the following :
   * <p>
   * f0 -> ( < ID > )<br>
   * s: -2053831081<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -2053831081, JTB_SIG_BP_H, JTB_USER_BP_H })
  public R visit(final bp_h n) {
    R nRes = null;
    // f0 -> ( < ID > )
    final NodeSequence n0 = n.f0;
    // invalid sub comment index (0), size = 0 ; Expansion, e
    final INode nd = n0.elementAt(0);
    nRes = nd.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_haa} node, whose child is the following :
   * <p>
   * f0 -> < ID ><br>
   * s: -1032372970<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1032372970, JTB_SIG_BP_HAA, JTB_USER_BP_HAA })
  public R visit(final bp_haa n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_l} node, whose child is the following :
   * <p>
   * f0 -> < ID ><br>
   * s: -1032372970<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1032372970, JTB_SIG_BP_L, JTB_USER_BP_L })
  public R visit(final bp_l n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_d} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_BP_D, JTB_USER_BP_D })
  public R visit(final bp_d n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link bp_da} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_BP_DA, JTB_USER_BP_DA })
  public R visit(final bp_da n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link bp_f} node, whose child is the following :
   * <p>
   * f0 -> < efID ><br>
   * s: 861265399<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 861265399, JTB_SIG_BP_F, JTB_USER_BP_F })
  public R visit(final bp_f n) {
    R nRes = null;
    // f0 -> < efID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_jual} node, whose child is the following :
   * <p>
   * f0 -> < ID ><br>
   * s: -1032372970<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1032372970, JTB_SIG_BP_JUAL, JTB_USER_BP_JUAL })
  public R visit(final bp_jual n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_hm} node, whose child is the following :
   * <p>
   * f0 -> < ID ><br>
   * s: -1032372970<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1032372970, JTB_SIG_BP_HM, JTB_USER_BP_HM })
  public R visit(final bp_hm n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_tu_a} node, whose children are the following :
   * <p>
   * f0 -> < ID ><br>
   * f1 -> ( #0 skipButBuild()<br>
   * .. .. . #1 jcp_ubar$() )<br>
   * f2 -> bp_v()<br>
   * s: -554973151<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -554973151, JTB_SIG_BP_TU_A, JTB_USER_BP_TU_A })
  public R visit(final bp_tu_a n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> ( #0 skipButBuild()
    // .. .. . #1 jcp_ubar$() )
    final NodeSequence n1 = n.f1;
    //#0 skipButBuild()
    final INode nd = n1.elementAt(0);
    nRes = nd.accept(this);
    //#1 jcp_ubar$()
    final INode nd1 = n1.elementAt(1);
    nRes = nd1.accept(this);
    // f2 -> bp_v()
    final bp_v n2 = n.f2;
    nRes = n2.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link bp_acc} node, whose children are the following :
   * <p>
   * f0 -> < ID ><br>
   * f1 -> [ "xyz" ]<br>
   * f2 -> ( bp_i() )*<br>
   * f3 -> ( %0 bp_v()<br>
   * .. .. | %1 ( #0 bp_w() #1 bp_x() ) )<br>
   * s: -2115359581<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -2115359581, JTB_SIG_BP_ACC, JTB_USER_BP_ACC })
  public R visit(final bp_acc n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> [ "xyz" ]
    final NodeOptional n1 = n.f1;
    if (n1.present()) {
      nRes = n1.accept(this);
    }
    // f2 -> ( bp_i() )*
    final NodeListOptional n2 = n.f2;
    if (n2.present()) {
      for (int i = 0; i < n2.size(); i++) {
        final INode nloeai = n2.elementAt(i);
        nRes = nloeai.accept(this);
      }
    }
    // f3 -> ( %0 bp_v()
    // .. .. | %1 ( #0 bp_w() #1 bp_x() ) )
    final NodeChoice n3 = n.f3;
    final NodeChoice nch = n3;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 bp_v()
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 ( #0 bp_w() #1 bp_x() )
        final NodeSequence seq = (NodeSequence) ich;
        //#0 bp_w()
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 bp_x()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link bp_DoubleThrows} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_BP_DOUBLETHROWS, JTB_USER_BP_DOUBLETHROWS })
  public R visit(final bp_DoubleThrows n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link bp_class1} node, whose child is the following :
   * <p>
   * f0 -> < ID ><br>
   * s: -1032372970<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1032372970, JTB_SIG_BP_CLASS1, JTB_USER_BP_CLASS1 })
  public R visit(final bp_class1 n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link jcp_DoubleThrows} node, with no child :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @SuppressWarnings("unused")
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_JCP_DOUBLETHROWS, JTB_USER_JCP_DOUBLETHROWS })
  public R visit(final jcp_DoubleThrows n) {
    R nRes = null;
    /* empty node, nothing that can be generated so far */
    return nRes;
  }

  /**
   * Visits a {@link skipButBuild} node, with no child :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @SuppressWarnings("unused")
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_SKIPBUTBUILD, JTB_USER_SKIPBUTBUILD })
  public R visit(final skipButBuild n) {
    R nRes = null;
    /* empty node, nothing that can be generated so far */
    return nRes;
  }

  /**
   * Visits a {@link expch_a} node, whose child is the following :
   * <p>
   * f0 -> . %0 #0 "!" #1 < ID ><br>
   * .. .. | %1 "!abc"<br>
   * s: 1194643558<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1194643558, JTB_SIG_EXPCH_A, JTB_USER_EXPCH_A })
  public R visit(final expch_a n) {
    R nRes = null;
    // f0 -> . %0 #0 "!" #1 < ID >
    // .. .. | %1 "!abc"
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 "!" #1 < ID >
        final NodeSequence seq = (NodeSequence) ich;
        //#0 "!"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 < ID >
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        break;
      case 1:
        //%1 "!abc"
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expch_b} node, whose child is the following :
   * <p>
   * f0 -> ( %0 #0 "?" #1 < abID ><br>
   * .. .. | %1 "?abc" )<br>
   * s: -2010824528<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -2010824528, JTB_SIG_EXPCH_B, JTB_USER_EXPCH_B })
  public R visit(final expch_b n) {
    R nRes = null;
    // f0 -> ( %0 #0 "?" #1 < abID >
    // .. .. | %1 "?abc" )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 #0 "?" #1 < abID >
        final NodeSequence seq = (NodeSequence) ich;
        //#0 "?"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 < abID >
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        break;
      case 1:
        //%1 "?abc"
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expch_c} node, whose child is the following :
   * <p>
   * f0 -> ( %0 ( &0 #0 < NUM_3_9 > #1 "!NUM_3_9!"<br>
   * .. .. . .. | &1 #0 < NUM_3_9 > #1 < ID ><br>
   * .. .. . .. | &2 #0 < ID > #1 "i==0"<br>
   * .. .. . .. | &3 #0 ( $0 < ID > $1 "i==1" )?<br>
   * .. .. . .. . .. #1 ( $0 < ID > $1 "j==2" )*<br>
   * .. .. . .. . .. #2 ( $0 < ID > $1 "j==3" )+ )<br>
   * .. .. | %1 < ES ><br>
   * .. .. | %2 #0 < NUM_3_9 > #1 "*39*" )<br>
   * s: -1450696804<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1450696804, JTB_SIG_EXPCH_C, JTB_USER_EXPCH_C })
  public R visit(final expch_c n) {
    R nRes = null;
    // f0 -> ( %0 ( &0 #0 < NUM_3_9 > #1 "!NUM_3_9!"
    // .. .. . .. | &1 #0 < NUM_3_9 > #1 < ID >
    // .. .. . .. | &2 #0 < ID > #1 "i==0"
    // .. .. . .. | &3 #0 ( $0 < ID > $1 "i==1" )?
    // .. .. . .. . .. #1 ( $0 < ID > $1 "j==2" )*
    // .. .. . .. . .. #2 ( $0 < ID > $1 "j==3" )+ )
    // .. .. | %1 < ES >
    // .. .. | %2 #0 < NUM_3_9 > #1 "*39*" )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 ( &0 #0 < NUM_3_9 > #1 "!NUM_3_9!"
        //.. | &1 #0 < NUM_3_9 > #1 < ID >
        //.. | &2 #0 < ID > #1 "i==0"
        //.. | &3 #0 ( $0 < ID > $1 "i==1" )?
        //.. .. #1 ( $0 < ID > $1 "j==2" )*
        //.. .. #2 ( $0 < ID > $1 "j==3" )+ )
        final NodeChoice nch1 = (NodeChoice) ich;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            //&0 #0 < NUM_3_9 > #1 "!NUM_3_9!"
            final NodeSequence seq = (NodeSequence) ich1;
            //#0 < NUM_3_9 >
            final INode nd = seq.elementAt(0);
            nRes = nd.accept(this);
            //#1 "!NUM_3_9!"
            final INode nd1 = seq.elementAt(1);
            nRes = nd1.accept(this);
            break;
          case 1:
            //&1 #0 < NUM_3_9 > #1 < ID >
            final NodeSequence seq1 = (NodeSequence) ich1;
            //#0 < NUM_3_9 >
            final INode nd2 = seq1.elementAt(0);
            nRes = nd2.accept(this);
            //#1 < ID >
            final INode nd3 = seq1.elementAt(1);
            nRes = nd3.accept(this);
            break;
          case 2:
            //&2 #0 < ID > #1 "i==0"
            final NodeSequence seq2 = (NodeSequence) ich1;
            //#0 < ID >
            final INode nd4 = seq2.elementAt(0);
            nRes = nd4.accept(this);
            //#1 "i==0"
            final INode nd5 = seq2.elementAt(1);
            nRes = nd5.accept(this);
            break;
          case 3:
            //&3 #0 ( $0 < ID > $1 "i==1" )?
            //.. #1 ( $0 < ID > $1 "j==2" )*
            //.. #2 ( $0 < ID > $1 "j==3" )+
            final NodeSequence seq3 = (NodeSequence) ich1;
            //#0 ( $0 < ID > $1 "i==1" )?
            final INode nd6 = seq3.elementAt(0);
            final NodeOptional opt = (NodeOptional) nd6;
            if (opt.present()) {
              final NodeSequence seq4 = (NodeSequence) opt.node;
              //$0 < ID >
              final INode nd7 = seq4.elementAt(0);
              nRes = nd7.accept(this);
              //$1 "i==1"
              final INode nd8 = seq4.elementAt(1);
              nRes = nd8.accept(this);
            }
            //#1 ( $0 < ID > $1 "j==2" )*
            final INode nd9 = seq3.elementAt(1);
            final NodeListOptional nlo = (NodeListOptional) nd9;
            if (nlo.present()) {
              for (int i = 0; i < nlo.size(); i++) {
                final INode nloeai = nlo.elementAt(i);
                final NodeSequence seq5 = (NodeSequence) nloeai;
                //$0 < ID >
                final INode nd10 = seq5.elementAt(0);
                nRes = nd10.accept(this);
                //$1 "j==2"
                final INode nd11 = seq5.elementAt(1);
                nRes = nd11.accept(this);
              }
            }
            //#2 ( $0 < ID > $1 "j==3" )+
            final INode nd12 = seq3.elementAt(2);
            final NodeList lst = (NodeList) nd12;
            for (int i = 0; i < lst.size(); i++) {
              final INode lsteai = lst.elementAt(i);
              final NodeSequence seq6 = (NodeSequence) lsteai;
              //$0 < ID >
              final INode nd13 = seq6.elementAt(0);
              nRes = nd13.accept(this);
              //$1 "j==3"
              final INode nd14 = seq6.elementAt(1);
              nRes = nd14.accept(this);
            }
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch1);
        }
        break;
      case 1:
        //%1 < ES >
        nRes = ich.accept(this);
        break;
      case 2:
        //%2 #0 < NUM_3_9 > #1 "*39*"
        final NodeSequence seq7 = (NodeSequence) ich;
        //#0 < NUM_3_9 >
        final INode nd15 = seq7.elementAt(0);
        nRes = nd15.accept(this);
        //#1 "*39*"
        final INode nd16 = seq7.elementAt(1);
        nRes = nd16.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expch_em_lxac} node, whose children are the following :
   * <p>
   * f0 -> ( %0 ":poi"<br>
   * .. .. | %1 ":uyt"<br>
   * .. .. | %2 ":rez"<br>
   * .. .. | %3 {} )<br>
   * f1 -> "/"<br>
   * s: -1331397378<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1331397378, JTB_SIG_EXPCH_EM_LXAC, JTB_USER_EXPCH_EM_LXAC })
  public R visit(final expch_em_lxac n) {
    R nRes = null;
    // f0 -> ( %0 ":poi"
    // .. .. | %1 ":uyt"
    // .. .. | %2 ":rez"
    // .. .. | %3 {} )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 ":poi"
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 ":uyt"
        nRes = ich.accept(this);
        break;
      case 2:
        //%2 ":rez"
        nRes = ich.accept(this);
        break;
      case 3:
        //%3 {}
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    // f1 -> "/"
    final Token n1 = n.f1;
    nRes = n1.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link expch_wnsn} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_EXPCH_WNSN, JTB_USER_EXPCH_WNSN })
  public R visit(final expch_wnsn n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link expch_2ch} node, whose children are the following :
   * <p>
   * f0 -> ( %0 ",jkl"<br>
   * .. .. | %1 {} )<br>
   * f1 -> ( %0 {}<br>
   * .. .. | %1 ",stu" )<br>
   * s: 1094260034<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1094260034, JTB_SIG_EXPCH_2CH, JTB_USER_EXPCH_2CH })
  public R visit(final expch_2ch n) {
    R nRes = null;
    // f0 -> ( %0 ",jkl"
    // .. .. | %1 {} )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 ",jkl"
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 {}
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    // f1 -> ( %0 {}
    // .. .. | %1 ",stu" )
    final NodeChoice n1 = n.f1;
    final NodeChoice nch1 = n1;
    final INode ich1 = nch1.choice;
    switch (nch1.which) {
      case 0:
        //%0 {}
        break;
      case 1:
        //%1 ",stu"
        nRes = ich1.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch1);
    }
    return nRes;
  }

  /**
   * Visits a {@link expch_bl_a} node, whose child is the following :
   * <p>
   * f0 -> . %0 < NUM_3_9 ><br>
   * .. .. | %1 {}<br>
   * s: -396343826<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -396343826, JTB_SIG_EXPCH_BL_A, JTB_USER_EXPCH_BL_A })
  public R visit(final expch_bl_a n) {
    R nRes = null;
    // f0 -> . %0 < NUM_3_9 >
    // .. .. | %1 {}
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < NUM_3_9 >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 {}
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expch_bl_a$} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_EXPCH_BL_A$, JTB_USER_EXPCH_BL_A$ })
  public R visit(final expch_bl_a$ n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link expch_bl_b} node, whose child is the following :
   * <p>
   * f0 -> . %0 {}<br>
   * .. .. | %1 < NUM_3_9 ><br>
   * s: 1722077994<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1722077994, JTB_SIG_EXPCH_BL_B, JTB_USER_EXPCH_BL_B })
  public R visit(final expch_bl_b n) {
    R nRes = null;
    // f0 -> . %0 {}
    // .. .. | %1 < NUM_3_9 >
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 {}
        break;
      case 1:
        //%1 < NUM_3_9 >
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expch_bl_b$} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_EXPCH_BL_B$, JTB_USER_EXPCH_BL_B$ })
  public R visit(final expch_bl_b$ n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link expch_bl_c} node, whose child is the following :
   * <p>
   * f0 -> . %0 {}<br>
   * .. .. | %1 < NUM_3_9 ><br>
   * s: 1722077994<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1722077994, JTB_SIG_EXPCH_BL_C, JTB_USER_EXPCH_BL_C })
  public R visit(final expch_bl_c n) {
    R nRes = null;
    // f0 -> . %0 {}
    // .. .. | %1 < NUM_3_9 >
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 {}
        break;
      case 1:
        //%1 < NUM_3_9 >
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expch_bl_c$} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_EXPCH_BL_C$, JTB_USER_EXPCH_BL_C$ })
  public R visit(final expch_bl_c$ n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link expch_bl_d} node, whose child is the following :
   * <p>
   * f0 -> . %0 < A_BS_B ><br>
   * .. .. | %1 < NUM_3_9 ><br>
   * .. .. | %2 {}<br>
   * .. .. | %3 {}<br>
   * .. .. | %4 {}<br>
   * .. .. | %5 {}<br>
   * .. .. | %6 {}<br>
   * .. .. | %7 "$^$^"<br>
   * s: 1959280963<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1959280963, JTB_SIG_EXPCH_BL_D, JTB_USER_EXPCH_BL_D })
  public R visit(final expch_bl_d n) {
    R nRes = null;
    // f0 -> . %0 < A_BS_B >
    // .. .. | %1 < NUM_3_9 >
    // .. .. | %2 {}
    // .. .. | %3 {}
    // .. .. | %4 {}
    // .. .. | %5 {}
    // .. .. | %6 {}
    // .. .. | %7 "$^$^"
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < A_BS_B >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 < NUM_3_9 >
        nRes = ich.accept(this);
        break;
      case 2:
        //%2 {}
        break;
      case 3:
        //%3 {}
        break;
      case 4:
        //%4 {}
        break;
      case 5:
        //%5 {}
        break;
      case 6:
        //%6 {}
        break;
      case 7:
        //%7 "$^$^"
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expch_eu_a} node, whose child is the following :
   * <p>
   * f0 -> . %0 < abID ><br>
   * .. .. | %1 {}<br>
   * .. .. | %2 < OP:["+"] ><br>
   * .. .. | %3 #0 "*1"<br>
   * .. .. . .. #1 ( &0 < SC1:";1" ><br>
   * .. .. . .. .. | &1 {}<br>
   * .. .. . .. .. | &2 < efID > )<br>
   * .. .. . .. #2 [ ( ( &0 < abID ><br>
   * .. .. . .. .. . . | &1 < "*2" ><br>
   * .. .. . .. .. . . | &2 {} ) )? ]<br>
   * .. .. . .. #3 ( ( ( &0 < abID ><br>
   * .. .. . .. .. . . | &1 < "*2" ><br>
   * .. .. . .. .. . . | &2 {} ) )? )?<br>
   * .. .. . .. #4 ( $0 "*4"<br>
   * .. .. . .. .. . $1 ( ( &0 {}<br>
   * .. .. . .. .. . .. . | &1 {}<br>
   * .. .. . .. .. . .. . | &2 < efID > ) )* )*<br>
   * .. .. . .. #5 ( $0 ( < "*5" > )?<br>
   * .. .. . .. .. . $1 ( ( &0 < abID ><br>
   * .. .. . .. .. . .. . | &1 {}<br>
   * .. .. . .. .. . .. . | &2 < SC4:(";4")+ ><br>
   * .. .. . .. .. . .. . | &3 {}<br>
   * .. .. . .. .. . .. . | &4 {} ) )+ )+<br>
   * s: 1610864831<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1610864831, JTB_SIG_EXPCH_EU_A, JTB_USER_EXPCH_EU_A })
  public R visit(final expch_eu_a n) {
    R nRes = null;
    // f0 -> . %0 < abID >
    // .. .. | %1 {}
    // .. .. | %2 < OP:["+"] >
    // .. .. | %3 #0 "*1"
    // .. .. . .. #1 ( &0 < SC1:";1" >
    // .. .. . .. .. | &1 {}
    // .. .. . .. .. | &2 < efID > )
    // .. .. . .. #2 [ ( ( &0 < abID >
    // .. .. . .. .. . . | &1 < "*2" >
    // .. .. . .. .. . . | &2 {} ) )? ]
    // .. .. . .. #3 ( ( ( &0 < abID >
    // .. .. . .. .. . . | &1 < "*2" >
    // .. .. . .. .. . . | &2 {} ) )? )?
    // .. .. . .. #4 ( $0 "*4"
    // .. .. . .. .. . $1 ( ( &0 {}
    // .. .. . .. .. . .. . | &1 {}
    // .. .. . .. .. . .. . | &2 < efID > ) )* )*
    // .. .. . .. #5 ( $0 ( < "*5" > )?
    // .. .. . .. .. . $1 ( ( &0 < abID >
    // .. .. . .. .. . .. . | &1 {}
    // .. .. . .. .. . .. . | &2 < SC4:(";4")+ >
    // .. .. . .. .. . .. . | &3 {}
    // .. .. . .. .. . .. . | &4 {} ) )+ )+
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < abID >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 {}
        break;
      case 2:
        //%2 < OP:["+"] >
        nRes = ich.accept(this);
        break;
      case 3:
        //%3 #0 "*1"
        //.. #1 ( &0 < SC1:";1" >
        //.. .. | &1 {}
        //.. .. | &2 < efID > )
        //.. #2 [ ( ( &0 < abID >
        //.. .. . . | &1 < "*2" >
        //.. .. . . | &2 {} ) )? ]
        //.. #3 ( ( ( &0 < abID >
        //.. .. . . | &1 < "*2" >
        //.. .. . . | &2 {} ) )? )?
        //.. #4 ( $0 "*4"
        //.. .. . $1 ( ( &0 {}
        //.. .. . .. . | &1 {}
        //.. .. . .. . | &2 < efID > ) )* )*
        //.. #5 ( $0 ( < "*5" > )?
        //.. .. . $1 ( ( &0 < abID >
        //.. .. . .. . | &1 {}
        //.. .. . .. . | &2 < SC4:(";4")+ >
        //.. .. . .. . | &3 {}
        //.. .. . .. . | &4 {} ) )+ )+
        final NodeSequence seq = (NodeSequence) ich;
        //#0 "*1"
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 ( &0 < SC1:";1" >
        //.. | &1 {}
        //.. | &2 < efID > )
        final INode nd1 = seq.elementAt(1);
        final NodeChoice nch1 = (NodeChoice) nd1;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            //&0 < SC1:";1" >
            nRes = ich1.accept(this);
            break;
          case 1:
            //&1 {}
            break;
          case 2:
            //&2 < efID >
            nRes = ich1.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch1);
        }
        //#2 [ ( ( &0 < abID >
        //.. . . | &1 < "*2" >
        //.. . . | &2 {} ) )? ]
        final INode nd2 = seq.elementAt(2);
        final NodeOptional opt = (NodeOptional) nd2;
        if (opt.present()) {
          if (opt.present()) {
            final NodeChoice nch2 = (NodeChoice) opt.node;
            final INode ich2 = nch2.choice;
            switch (nch2.which) {
              case 0:
                //&0 < abID >
                nRes = ich2.accept(this);
                break;
              case 1:
                //&1 < "*2" >
                nRes = ich2.accept(this);
                break;
              case 2:
                //&2 {}
                break;
              default:
                // should not occur !!!
                throw new ShouldNotOccurException(nch2);
            }
          }
        }
        //#3 ( ( ( &0 < abID >
        //.. . . | &1 < "*2" >
        //.. . . | &2 {} ) )? )?
        final INode nd3 = seq.elementAt(3);
        final NodeOptional opt1 = (NodeOptional) nd3;
        if (opt1.present()) {
          if (opt1.present()) {
            final NodeChoice nch3 = (NodeChoice) opt1.node;
            final INode ich3 = nch3.choice;
            switch (nch3.which) {
              case 0:
                //&0 < abID >
                nRes = ich3.accept(this);
                break;
              case 1:
                //&1 < "*2" >
                nRes = ich3.accept(this);
                break;
              case 2:
                //&2 {}
                break;
              default:
                // should not occur !!!
                throw new ShouldNotOccurException(nch3);
            }
          }
        }
        //#4 ( $0 "*4"
        //.. . $1 ( ( &0 {}
        //.. . .. . | &1 {}
        //.. . .. . | &2 < efID > ) )* )*
        final INode nd4 = seq.elementAt(4);
        final NodeListOptional nlo = (NodeListOptional) nd4;
        if (nlo.present()) {
          for (int i = 0; i < nlo.size(); i++) {
            final INode nloeai = nlo.elementAt(i);
            final NodeSequence seq1 = (NodeSequence) nloeai;
            //$0 "*4"
            final INode nd5 = seq1.elementAt(0);
            nRes = nd5.accept(this);
            //$1 ( ( &0 {}
            //.. . | &1 {}
            //.. . | &2 < efID > ) )*
            final INode nd6 = seq1.elementAt(1);
            final NodeListOptional nlo1 = (NodeListOptional) nd6;
            if (nlo1.present()) {
              for (int i1 = 0; i1 < nlo1.size(); i1++) {
                final INode nloeai1 = nlo1.elementAt(i1);
                final NodeChoice nch4 = (NodeChoice) nloeai1;
                final INode ich4 = nch4.choice;
                switch (nch4.which) {
                  case 0:
                    //&0 {}
                    break;
                  case 1:
                    //&1 {}
                    break;
                  case 2:
                    //&2 < efID >
                    nRes = ich4.accept(this);
                    break;
                  default:
                    // should not occur !!!
                    throw new ShouldNotOccurException(nch4);
                }
              }
            }
          }
        }
        //#5 ( $0 ( < "*5" > )?
        //.. . $1 ( ( &0 < abID >
        //.. . .. . | &1 {}
        //.. . .. . | &2 < SC4:(";4")+ >
        //.. . .. . | &3 {}
        //.. . .. . | &4 {} ) )+ )+
        final INode nd7 = seq.elementAt(5);
        final NodeList lst = (NodeList) nd7;
        for (int i = 0; i < lst.size(); i++) {
          final INode lsteai = lst.elementAt(i);
          final NodeSequence seq2 = (NodeSequence) lsteai;
          //$0 ( < "*5" > )?
          final INode nd8 = seq2.elementAt(0);
          final NodeOptional opt2 = (NodeOptional) nd8;
          if (opt2.present()) {
            nRes = opt2.accept(this);
          }
          //$1 ( ( &0 < abID >
          //.. . | &1 {}
          //.. . | &2 < SC4:(";4")+ >
          //.. . | &3 {}
          //.. . | &4 {} ) )+
          final INode nd9 = seq2.elementAt(1);
          final NodeList lst1 = (NodeList) nd9;
          for (int i1 = 0; i1 < lst1.size(); i1++) {
            final INode lsteai1 = lst1.elementAt(i1);
            final NodeChoice nch5 = (NodeChoice) lsteai1;
            final INode ich5 = nch5.choice;
            switch (nch5.which) {
              case 0:
                //&0 < abID >
                nRes = ich5.accept(this);
                break;
              case 1:
                //&1 {}
                break;
              case 2:
                //&2 < SC4:(";4")+ >
                nRes = ich5.accept(this);
                break;
              case 3:
                //&3 {}
                break;
              case 4:
                //&4 {}
                break;
              default:
                // should not occur !!!
                throw new ShouldNotOccurException(nch5);
            }
          }
        }
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expun_a1} node, whose children are the following :
   * <p>
   * f0 -> < ID ><br>
   * f1 -> Identifier()<br>
   * f2 -> ( %0 < ID ><br>
   * .. .. | %1 Identifier() )<br>
   * f3 -> ( %0 < ID ><br>
   * .. .. | %1 Identifier() )<br>
   * s: 1376158947<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1376158947, JTB_SIG_EXPUN_A1, JTB_USER_EXPUN_A1 })
  public R visit(final expun_a1 n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Identifier()
    final Identifier n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( %0 < ID >
    // .. .. | %1 Identifier() )
    final NodeChoice n2 = n.f2;
    final NodeChoice nch = n2;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < ID >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 Identifier()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    // f3 -> ( %0 < ID >
    // .. .. | %1 Identifier() )
    final NodeChoice n3 = n.f3;
    final NodeChoice nch1 = n3;
    final INode ich1 = nch1.choice;
    switch (nch1.which) {
      case 0:
        //%0 < ID >
        nRes = ich1.accept(this);
        break;
      case 1:
        //%1 Identifier()
        nRes = ich1.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch1);
    }
    return nRes;
  }

  /**
   * Visits a {@link expun_b1} node, whose children are the following :
   * <p>
   * f0 -> < ID ><br>
   * f1 -> Identifier()<br>
   * f2 -> ( %0 < ID ><br>
   * .. .. | %1 Identifier() )<br>
   * f3 -> eu_id_or_ident()<br>
   * s: -1408399324<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1408399324, JTB_SIG_EXPUN_B1, JTB_USER_EXPUN_B1 })
  public R visit(final expun_b1 n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Identifier()
    final Identifier n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( %0 < ID >
    // .. .. | %1 Identifier() )
    final NodeChoice n2 = n.f2;
    final NodeChoice nch = n2;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < ID >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 Identifier()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    // f3 -> eu_id_or_ident()
    final eu_id_or_ident n3 = n.f3;
    nRes = n3.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link expun_c1} node, whose children are the following :
   * <p>
   * f0 -> < ID ><br>
   * f1 -> Identifier()<br>
   * f2 -> ( %0 < ID ><br>
   * .. .. | %1 Identifier() )<br>
   * s: 1973180222<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1973180222, JTB_SIG_EXPUN_C1, JTB_USER_EXPUN_C1 })
  public R visit(final expun_c1 n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Identifier()
    final Identifier n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( %0 < ID >
    // .. .. | %1 Identifier() )
    final NodeChoice n2 = n.f2;
    final NodeChoice nch = n2;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < ID >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 Identifier()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expun_d1} node, whose children are the following :
   * <p>
   * f0 -> < ID ><br>
   * f1 -> Identifier()<br>
   * f2 -> ( %0 < ID ><br>
   * .. .. | %1 Identifier() )<br>
   * s: 1973180222<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1973180222, JTB_SIG_EXPUN_D1, JTB_USER_EXPUN_D1 })
  public R visit(final expun_d1 n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Identifier()
    final Identifier n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( %0 < ID >
    // .. .. | %1 Identifier() )
    final NodeChoice n2 = n.f2;
    final NodeChoice nch = n2;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < ID >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 Identifier()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expun_a2} node, whose children are the following :
   * <p>
   * f0 -> < ID ><br>
   * f1 -> Identifier()<br>
   * f2 -> ( %0 < ID ><br>
   * .. .. | %1 #0 Identifier()<br>
   * .. .. . .. #1 ( &0 < ID ><br>
   * .. .. . .. .. | &1 Identifier() ) )<br>
   * s: 1070599542<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1070599542, JTB_SIG_EXPUN_A2, JTB_USER_EXPUN_A2 })
  public R visit(final expun_a2 n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Identifier()
    final Identifier n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( %0 < ID >
    // .. .. | %1 #0 Identifier()
    // .. .. . .. #1 ( &0 < ID >
    // .. .. . .. .. | &1 Identifier() ) )
    final NodeChoice n2 = n.f2;
    final NodeChoice nch = n2;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < ID >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 #0 Identifier()
        //.. #1 ( &0 < ID >
        //.. .. | &1 Identifier() )
        final NodeSequence seq = (NodeSequence) ich;
        //#0 Identifier()
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 ( &0 < ID >
        //.. | &1 Identifier() )
        final INode nd1 = seq.elementAt(1);
        final NodeChoice nch1 = (NodeChoice) nd1;
        final INode ich1 = nch1.choice;
        switch (nch1.which) {
          case 0:
            //&0 < ID >
            nRes = ich1.accept(this);
            break;
          case 1:
            //&1 Identifier()
            nRes = ich1.accept(this);
            break;
          default:
            // should not occur !!!
            throw new ShouldNotOccurException(nch1);
        }
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expun_b2} node, whose children are the following :
   * <p>
   * f0 -> < ID ><br>
   * f1 -> Identifier()<br>
   * f2 -> ( %0 < ID ><br>
   * .. .. | %1 #0 Identifier() #1 eu_id_or_ident() )<br>
   * s: 1485056343<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1485056343, JTB_SIG_EXPUN_B2, JTB_USER_EXPUN_B2 })
  public R visit(final expun_b2 n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Identifier()
    final Identifier n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( %0 < ID >
    // .. .. | %1 #0 Identifier() #1 eu_id_or_ident() )
    final NodeChoice n2 = n.f2;
    final NodeChoice nch = n2;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < ID >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 #0 Identifier() #1 eu_id_or_ident()
        final NodeSequence seq = (NodeSequence) ich;
        //#0 Identifier()
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 eu_id_or_ident()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expun_c2} node, whose children are the following :
   * <p>
   * f0 -> < ID ><br>
   * f1 -> Identifier()<br>
   * f2 -> ( %0 < ID ><br>
   * .. .. | %1 Identifier() )<br>
   * s: 1973180222<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1973180222, JTB_SIG_EXPUN_C2, JTB_USER_EXPUN_C2 })
  public R visit(final expun_c2 n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Identifier()
    final Identifier n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( %0 < ID >
    // .. .. | %1 Identifier() )
    final NodeChoice n2 = n.f2;
    final NodeChoice nch = n2;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < ID >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 Identifier()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expun_d2} node, whose children are the following :
   * <p>
   * f0 -> < ID ><br>
   * f1 -> Identifier()<br>
   * f2 -> ( %0 < ID ><br>
   * .. .. | %1 Identifier() )<br>
   * s: 1973180222<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1973180222, JTB_SIG_EXPUN_D2, JTB_USER_EXPUN_D2 })
  public R visit(final expun_d2 n) {
    R nRes = null;
    // f0 -> < ID >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    // f1 -> Identifier()
    final Identifier n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( %0 < ID >
    // .. .. | %1 Identifier() )
    final NodeChoice n2 = n.f2;
    final NodeChoice nch = n2;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < ID >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 Identifier()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expun_a3} node, whose child is the following :
   * <p>
   * f0 -> ( %0 < ID ><br>
   * .. .. | %1 #0 Identifier() #1 eu_id_or_ident() )<br>
   * s: 1613489651<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1613489651, JTB_SIG_EXPUN_A3, JTB_USER_EXPUN_A3 })
  public R visit(final expun_a3 n) {
    R nRes = null;
    // f0 -> ( %0 < ID >
    // .. .. | %1 #0 Identifier() #1 eu_id_or_ident() )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < ID >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 #0 Identifier() #1 eu_id_or_ident()
        final NodeSequence seq = (NodeSequence) ich;
        //#0 Identifier()
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 eu_id_or_ident()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expun_b3} node, whose child is the following :
   * <p>
   * f0 -> ( %0 {}<br>
   * .. .. | %1 #0 Identifier() #1 eu_id_or_ident() )<br>
   * s: -234196616<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -234196616, JTB_SIG_EXPUN_B3, JTB_USER_EXPUN_B3 })
  public R visit(final expun_b3 n) {
    R nRes = null;
    // f0 -> ( %0 {}
    // .. .. | %1 #0 Identifier() #1 eu_id_or_ident() )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 {}
        break;
      case 1:
        //%1 #0 Identifier() #1 eu_id_or_ident()
        final NodeSequence seq = (NodeSequence) ich;
        //#0 Identifier()
        final INode nd = seq.elementAt(0);
        nRes = nd.accept(this);
        //#1 eu_id_or_ident()
        final INode nd1 = seq.elementAt(1);
        nRes = nd1.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expun_c3} node, whose child is the following :
   * <p>
   * f0 -> ( %0 < ID ><br>
   * .. .. | %1 {} )<br>
   * s: 1971178170<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1971178170, JTB_SIG_EXPUN_C3, JTB_USER_EXPUN_C3 })
  public R visit(final expun_c3 n) {
    R nRes = null;
    // f0 -> ( %0 < ID >
    // .. .. | %1 {} )
    final NodeChoice n0 = n.f0;
    final NodeChoice nch = n0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < ID >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 {}
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link expun_d3} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_EXPUN_D3, JTB_USER_EXPUN_D3 })
  public R visit(final expun_d3 n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link eu_id_or_ident} node, whose child is the following :
   * <p>
   * f0 -> . %0 < ID ><br>
   * .. .. | %1 Identifier()<br>
   * s: 205316371<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 205316371, JTB_SIG_EU_ID_OR_IDENT, JTB_USER_EU_ID_OR_IDENT })
  public R visit(final eu_id_or_ident n) {
    R nRes = null;
    // f0 -> . %0 < ID >
    // .. .. | %1 Identifier()
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < ID >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 Identifier()
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link Identifier} node, whose child is the following :
   * <p>
   * f0 -> . %0 < A_BS_B ><br>
   * .. .. | %1 < ID ><br>
   * s: 2078928335<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 2078928335, JTB_SIG_IDENTIFIER, JTB_USER_IDENTIFIER })
  public R visit(final Identifier n) {
    R nRes = null;
    // f0 -> . %0 < A_BS_B >
    // .. .. | %1 < ID >
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < A_BS_B >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 < ID >
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link check_proper_formatting} node, whose child is the following :
   * <p>
   * f0 -> . %0 < ID ><br>
   * .. .. | %1 < ES ><br>
   * s: 1099811577<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1099811577, JTB_SIG_CHECK_PROPER_FORMATTING, JTB_USER_CHECK_PROPER_FORMATTING })
  public R visit(final check_proper_formatting n) {
    R nRes = null;
    // f0 -> . %0 < ID >
    // .. .. | %1 < ES >
    final NodeChoice nch = n.f0;
    final INode ich = nch.choice;
    switch (nch.which) {
      case 0:
        //%0 < ID >
        nRes = ich.accept(this);
        break;
      case 1:
        //%1 < ES >
        nRes = ich.accept(this);
        break;
      default:
        // should not occur !!!
        throw new ShouldNotOccurException(nch);
    }
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_be} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_F0_EU1_BE, JTB_USER_F0_EU1_BE })
  public R visit(final f0_eu1_be n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_b1} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_F0_EU1_B1, JTB_USER_F0_EU1_B1 })
  public R visit(final f0_eu1_b1 n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_b2} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_F0_EU1_B2, JTB_USER_F0_EU1_B2 })
  public R visit(final f0_eu1_b2 n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_ias1} node, whose child is the following :
   * <p>
   * f0 -> f0_eu1_be()<br>
   * s: -1061049602<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1061049602, JTB_SIG_F0_EU1_IAS1, JTB_USER_F0_EU1_IAS1 })
  public R visit(final f0_eu1_ias1 n) {
    R nRes = null;
    // f0 -> f0_eu1_be()
    final f0_eu1_be n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_ias2} node, whose child is the following :
   * <p>
   * f0 -> f0_eu1_b1()<br>
   * s: -1061099574<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1061099574, JTB_SIG_F0_EU1_IAS2, JTB_USER_F0_EU1_IAS2 })
  public R visit(final f0_eu1_ias2 n) {
    R nRes = null;
    // f0 -> f0_eu1_b1()
    if (n.f0 != null) {
      nRes = n.f0.accept(this);
    }
    return nRes;
  }

  /**
   * Visits a {@link f0_eu2_all1} node, whose children are the following :
   * <p>
   * f0 -> [ ";".image ]<br>
   * f1 -> f0_eu1_b1()<br>
   * f2 -> ( #0 ";; "<br>
   * .. .. . #1 ( $0 ";;; " $1 ";;;; " ) )<br>
   * f3 -> ( < NUM_3_9 > )*<br>
   * f4 -> ( ( %0 ":"<br>
   * .. .. . | %1 < NUM_3_9 ><br>
   * .. .. . | %2 ":" ) )?<br>
   * f5 -> f0_eu1_peias2()<br>
   * f6 ->   %0 expch_a()<br>
   * .. .. | %1 expch_b()<br>
   * f7 -> ( %0 expch_2ch()<br>
   * .. .. | %1 expch_bl_a() )<br>
   * s: -1377841071<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1377841071, JTB_SIG_F0_EU2_ALL1, JTB_USER_F0_EU2_ALL1 })
  public R visit(final f0_eu2_all1 n) {
    R nRes = null;
    // f0 -> [ ";".image ]
    final NodeOptional n0 = n.f0;
    if (n0.present()) {
      nRes = n0.accept(this);
// Please report to support with a real example of your grammar if you want the suffix to be generated : $1 [ ?0 "." ?1 < IDENTIFIER > ]
    }
    // f1 -> f0_eu1_b1()
    final f0_eu1_b1 n1 = n.f1;
    nRes = n1.accept(this);
    // f2 -> ( #0 ";; "
    // .. .. . #1 ( $0 ";;; " $1 ";;;; " ) )
    final NodeSequence n2 = n.f2;
    //#0 ";; "
    final INode nd = n2.elementAt(0);
    nRes = nd.accept(this);
    //#1 ( $0 ";;; " $1 ";;;; " )
    final INode nd1 = n2.elementAt(1);
    final NodeSequence seq = (NodeSequence) nd1;
    //$0 ";;; "
    final INode nd2 = seq.elementAt(0);
    nRes = nd2.accept(this);
    //$1 ";;;; "
    final INode nd3 = seq.elementAt(1);
    nRes = nd3.accept(this);
    // f3 -> ( < NUM_3_9 > )*
    final NodeListOptional n3 = n.f3;
    if (n3.present()) {
      for (int i = 0; i < n3.size(); i++) {
        final INode nloeai = n3.elementAt(i);
        nRes = nloeai.accept(this);
      }
    }
    // f4 -> ( ( %0 ":"
    // .. .. . | %1 < NUM_3_9 >
    // .. .. . | %2 ":" ) )?
    final NodeOptional n4 = n.f4;
    if (n4.present()) {
      final NodeChoice nch = (NodeChoice) n4.node;
      final INode ich = nch.choice;
      switch (nch.which) {
        case 0:
          //%0 ":"
          nRes = ich.accept(this);
          break;
        case 1:
          //%1 < NUM_3_9 >
          nRes = ich.accept(this);
          break;
        case 2:
          //%2 ":"
          nRes = ich.accept(this);
          break;
        default:
          // should not occur !!!
          throw new ShouldNotOccurException(nch);
      }
    }
    // f5 -> f0_eu1_peias2()
    if (n.f5 != null) {
      nRes = n.f5.accept(this);
    }
    //%0 expch_a()
    if (n.f6 != null) {
      final INode ich1 = n.f6.choice;
      switch (n.f6.which) {
        case 0:
          //%1 expch_b()
          if (ich1 != null) {
            nRes = ich1.accept(this);
          }
          break;
        case 1:
          //%0 expch_2ch()
          if (ich1 != null) {
            nRes = ich1.accept(this);
          }
          break;
        default:
          // should not occur !!!
          throw new ShouldNotOccurException(n.f6);
      }
    }
    //%1 expch_bl_a()
    if (n.f7 != null) {
      final INode ich2 = n.f7.choice;
      switch (n.f7.which) {
        case 0:
          // invalid sub comment index (11), size = 11 ; ExpansionChoices, h
          if (ich2 != null) {
            nRes = ich2.accept(this);
          }
          break;
        case 1:
          // invalid sub comment index (12), size = 11 ; ExpansionChoices, j
          if (ich2 != null) {
            nRes = ich2.accept(this);
          }
          break;
        default:
          // should not occur !!!
          throw new ShouldNotOccurException(n.f7);
      }
    }
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_jc} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_F0_EU1_JC, JTB_USER_F0_EU1_JC })
  public R visit(final f0_eu1_jc n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_peias1} node, whose child is the following :
   * <p>
   * f0 -> f0_eu1_b2()<br>
   * s: -1061098613<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1061098613, JTB_SIG_F0_EU1_PEIAS1, JTB_USER_F0_EU1_PEIAS1 })
  public R visit(final f0_eu1_peias1 n) {
    R nRes = null;
    // f0 -> f0_eu1_b2()
    final f0_eu1_b2 n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_peias2} node, whose child is the following :
   * <p>
   * f0 -> f0_eu1_b2()<br>
   * s: -1061098613<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1061098613, JTB_SIG_F0_EU1_PEIAS2, JTB_USER_F0_EU1_PEIAS2 })
  public R visit(final f0_eu1_peias2 n) {
    R nRes = null;
    // f0 -> f0_eu1_b2()
    final f0_eu1_b2 n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_pejc1} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_F0_EU1_PEJC1, JTB_USER_F0_EU1_PEJC1 })
  public R visit(final f0_eu1_pejc1 n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_pejc2} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_F0_EU1_PEJC2, JTB_USER_F0_EU1_PEJC2 })
  public R visit(final f0_eu1_pejc2 n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_resl1} node, whose child is the following :
   * <p>
   * f0 -> "!"<br>
   * s: 2055659818<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 2055659818, JTB_SIG_F0_EU1_RESL1, JTB_USER_F0_EU1_RESL1 })
  public R visit(final f0_eu1_resl1 n) {
    R nRes = null;
    // f0 -> "!"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_resl2} node, whose child is the following :
   * <p>
   * f0 -> < resl2:"!x" ><br>
   * s: 788986552<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 788986552, JTB_SIG_F0_EU1_RESL2, JTB_USER_F0_EU1_RESL2 })
  public R visit(final f0_eu1_resl2 n) {
    R nRes = null;
    // f0 -> < resl2:"!x" >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_resl3} node, whose child is the following :
   * <p>
   * f0 -> < resl3:< resl2 > ><br>
   * s: 1643973678<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 1643973678, JTB_SIG_F0_EU1_RESL3, JTB_USER_F0_EU1_RESL3 })
  public R visit(final f0_eu1_resl3 n) {
    R nRes = null;
    // f0 -> < resl3:< resl2 > >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_recrec1} node, whose child is the following :
   * <p>
   * f0 -> < recrec1:< abID >< ID >|< efID > ><br>
   * s: 11265239<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 11265239, JTB_SIG_F0_EU1_RECREC1, JTB_USER_F0_EU1_RECREC1 })
  public R visit(final f0_eu1_recrec1 n) {
    R nRes = null;
    // f0 -> < recrec1:< abID >< ID >|< efID > >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_recrec2} node, whose child is the following :
   * <p>
   * f0 -> < recrec2:"!"|< resl2 >|< resl3 >|< efID >|("#1")|(("#2")?"#3"|(("#4")*"#5"|("#6")+))|("#7"< A_BS_B >)("#8"|< SYN_ESC >) ><br>
   * s: -823049317<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -823049317, JTB_SIG_F0_EU1_RECREC2, JTB_USER_F0_EU1_RECREC2 })
  public R visit(final f0_eu1_recrec2 n) {
    R nRes = null;
    // f0 -> < recrec2:"!"|< resl2 >|< resl3 >|< efID >|("#1")|(("#2")?"#3"|(("#4")*"#5"|("#6")+))|("#7"< A_BS_B >)("#8"|< SYN_ESC >) >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_recrec3} node, whose child is the following :
   * <p>
   * f0 -> < recrec3:"'"|< recrec1 >|< recrec2 > ><br>
   * s: -2056495050<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -2056495050, JTB_SIG_F0_EU1_RECREC3, JTB_USER_F0_EU1_RECREC3 })
  public R visit(final f0_eu1_recrec3 n) {
    R nRes = null;
    // f0 -> < recrec3:"'"|< recrec1 >|< recrec2 > >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_retk} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_F0_EU1_RETK, JTB_USER_F0_EU1_RETK })
  public R visit(final f0_eu1_retk n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link f0_eu1_reeof} node, whose child is the following :
   * <p>
   * f0 -> < EOF ><br>
   * s: -1942121731<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1942121731, JTB_SIG_F0_EU1_REEOF, JTB_USER_F0_EU1_REEOF })
  public R visit(final f0_eu1_reeof n) {
    R nRes = null;
    // f0 -> < EOF >
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link f0_laeu2_be} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_F0_LAEU2_BE, JTB_USER_F0_LAEU2_BE })
  public R visit(final f0_laeu2_be n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link f0_laeu2_b1} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_F0_LAEU2_B1, JTB_USER_F0_LAEU2_B1 })
  public R visit(final f0_laeu2_b1 n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link f0_laeu2_ias1} node, whose child is the following :
   * <p>
   * f0 -> f0_eu1_be()<br>
   * s: -1061049602<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1061049602, JTB_SIG_F0_LAEU2_IAS1, JTB_USER_F0_LAEU2_IAS1 })
  public R visit(final f0_laeu2_ias1 n) {
    R nRes = null;
    // f0 -> f0_eu1_be()
    final f0_eu1_be n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link f0_laeu2_ias2} node, whose child is the following :
   * <p>
   * f0 -> f0_eu1_b1()<br>
   * s: -1061099574<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -1061099574, JTB_SIG_F0_LAEU2_IAS2, JTB_USER_F0_LAEU2_IAS2 })
  public R visit(final f0_laeu2_ias2 n) {
    R nRes = null;
    // f0 -> f0_eu1_b1()
    final f0_eu1_b1 n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link f0_laeu2_jc} node, whose children are the following :
   * <p>
   * s: 0<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ 0, JTB_SIG_F0_LAEU2_JC, JTB_USER_F0_LAEU2_JC })
  public R visit(final f0_laeu2_jc n) {
    R nRes = null;
    return nRes;
  }

  /**
   * Visits a {@link gt_1} node, whose child is the following :
   * <p>
   * f0 -> " >;"<br>
   * s: -195872082<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -195872082, JTB_SIG_GT_1, JTB_USER_GT_1 })
  public R visit(final gt_1 n) {
    R nRes = null;
    // f0 -> " >;"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Visits a {@link lt_1} node, whose child is the following :
   * <p>
   * f0 -> "<;"<br>
   * s: -699028326<br>
   *
   * @param n - the node to visit
   * @return the user return information
   */
  @Override
  @NodeFieldsSignature({ -699028326, JTB_SIG_LT_1, JTB_USER_LT_1 })
  public R visit(final lt_1 n) {
    R nRes = null;
    // f0 -> "<;"
    final Token n0 = n.f0;
    nRes = n0.accept(this);
    return nRes;
  }

  /**
   * Class handling a programmatic exception. Static for generic outer classes.
   */
  public static class ShouldNotOccurException extends RuntimeException {

    /** Default serialVersionUID */
    private static final long serialVersionUID = 1L;

    /**
     * Constructor with no message.
     */
    public ShouldNotOccurException() {
      super();
    }

    /**
     * Constructor which outputs a message.
     *
     * @param ch - a NodeChoice whose which value is invalid or lead to a fall-through
     */
    public ShouldNotOccurException(final NodeChoice ch) {
      super("Invalid switch value (" + ch.which + ") or fall-through");
    }

  }

}
