/* Generated by JTB 1.5.1 */
package examples.java.ex2jtb.syntaxtree;

import examples.java.ex2jtb.visitor.IGenVisitor;

/**
 * Represents a grammar optional node (? or []), e.g. ' ( A )? ' or ' [ A ] '.<br>
 * The class stores the node.
 */
public class NodeOptional implements INode {

  /** The node (if null there is no node) */
  public INode node;

  /** The serial version UID */
  private static final long serialVersionUID = 151L;

  /**
   * Initializes an empty {@link NodeOptional}.
   */
  public NodeOptional() {
    node = null;
  }

  /**
   * Initializes a {@link NodeOptional} with a node.
   *
   * @param n - the node
   */
  public NodeOptional(final INode n) {
    addNode(n);
  }

  /**
   * Adds a node to the {@link NodeOptional}.
   *
   * @param n - the node to add
   */
  public void addNode(final INode n) {
    if (node != null)
      throw new Error("Attempt to set optional node twice"); //$NON-NLS-1$
    node = n;
  }

  /**
   * @return true if the node exists, false otherwise
   */
  public boolean present() {
    return (node != null); }

  /*
   * Visitors accept methods (no -novis option, visitors specification : Gen,void,java.lang.String)
   */

  /**
   * Accepts a {@link IGenVisitor} visitor with user argument data.
   *
   * @param vis - the visitor
   * @param argu - the user Argument data
   */
  @Override
  public void accept(final IGenVisitor vis, final String argu) {
    vis.visit(this, argu);
  }

}
