/* Generated by JTB 1.5.1 */
package EDU.purdue.jtb.parser.syntaxtree;

import EDU.purdue.jtb.parser.visitor.IIntVisitor;
import EDU.purdue.jtb.parser.visitor.IVoidVisitor;

/**
 * Represents a grammar optional node (? or []), e.g. ' ( A )? ' or ' [ A ] '.<br>
 * The class stores the node.
 */
public class NodeOptional implements INode {

  /** The node (if null there is no node) */
  public INode node;

  /** The serial version UID */
  private static final long serialVersionUID = 151L;

  /**
   * Initializes an empty {@link NodeOptional}.
   */
  public NodeOptional() {
    node = null;
  }

  /**
   * Initializes a {@link NodeOptional} with a node.
   *
   * @param n - the node
   */
  public NodeOptional(final INode n) {
    addNode(n);
  }

  /**
   * Adds a node to the {@link NodeOptional}.
   *
   * @param n - the node to add
   */
  public void addNode(final INode n) {
    if (node != null)
      throw new Error("Attempt to set optional node twice"); //$NON-NLS-1$
    node = n;
  }

  /**
   * @return true if the node exists, false otherwise
   */
  public boolean present() {
    return (node != null); }

  /*
   * Visitors accept methods (no -novis option, visitors specification : Void,void,None;Int,int,None)
   */

  /**
   * Accepts a {@link IIntVisitor} visitor with user return data.
   *
   * @param vis - the visitor
   * @return the user Return data
   */
  @Override
  public int accept(final IIntVisitor vis) {
    return vis.visit(this);
  }

  /**
   * Accepts a {@link IVoidVisitor} visitor} visitor with user return data.
   *
   * @param vis - the visitor
   */
  @Override
  public void accept(final IVoidVisitor vis) {
    vis.visit(this);
  }

}
