/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.CharSetEnumerator;

public final class CharSet {
    static final int BITS = 6;
    static final int MOD = 63;
    long[] bits;
    private int numElements;

    public CharSet() {
        this.bits = new long[1];
    }

    public CharSet(int initialSize, int character) {
        this.bits = new long[(initialSize >> 6) + 1];
        this.add(character);
    }

    public void add(int character) {
        this.resize(character);
        if ((this.bits[character >> 6] & 1L << (character & 0x3F)) == 0L) {
            ++this.numElements;
        }
        int n = character >> 6;
        this.bits[n] = this.bits[n] | 1L << (character & 0x3F);
    }

    private int nbits2size(int nbits) {
        return (nbits >> 6) + 1;
    }

    private void resize(int nbits) {
        int needed = this.nbits2size(nbits);
        if (needed < this.bits.length) {
            return;
        }
        long[] newbits = new long[Math.max(this.bits.length * 2, needed)];
        System.arraycopy(this.bits, 0, newbits, 0, this.bits.length);
        this.bits = newbits;
    }

    public boolean isElement(int character) {
        int index = character >> 6;
        if (index >= this.bits.length) {
            return false;
        }
        return (this.bits[index] & 1L << (character & 0x3F)) != 0L;
    }

    public CharSetEnumerator characters() {
        return new CharSetEnumerator(this);
    }

    public boolean containsElements() {
        return this.numElements > 0;
    }

    public int size() {
        return this.numElements;
    }

    public String toString() {
        CharSetEnumerator charSetEnumerator = this.characters();
        StringBuffer result = new StringBuffer("{");
        if (charSetEnumerator.hasMoreElements()) {
            result.append("" + charSetEnumerator.nextElement());
        }
        while (charSetEnumerator.hasMoreElements()) {
            int i = charSetEnumerator.nextElement();
            result.append(", " + i);
        }
        result.append("}");
        return result.toString();
    }
}

