// This file was generated by gir (https://github.com/gtk-rs/gir)
// from
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{CacheType, SessionFeature};
use glib::{prelude::*, translate::*};
use std::fmt;

glib::wrapper! {
    #[doc(alias = "SoupCache")]
    pub struct Cache(Object<ffi::SoupCache, ffi::SoupCacheClass>) @implements SessionFeature;

    match fn {
        type_ => || ffi::soup_cache_get_type(),
    }
}

impl Cache {
    pub const NONE: Option<&'static Cache> = None;

    #[doc(alias = "soup_cache_new")]
    pub fn new(cache_dir: Option<&str>, cache_type: CacheType) -> Cache {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_cache_new(
                cache_dir.to_glib_none().0,
                cache_type.into_glib(),
            ))
        }
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::Cache>> Sealed for T {}
}

pub trait CacheExt: IsA<Cache> + sealed::Sealed + 'static {
    #[doc(alias = "soup_cache_clear")]
    fn clear(&self) {
        unsafe {
            ffi::soup_cache_clear(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "soup_cache_dump")]
    fn dump(&self) {
        unsafe {
            ffi::soup_cache_dump(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "soup_cache_flush")]
    fn flush(&self) {
        unsafe {
            ffi::soup_cache_flush(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "soup_cache_get_max_size")]
    #[doc(alias = "get_max_size")]
    fn max_size(&self) -> u32 {
        unsafe { ffi::soup_cache_get_max_size(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "soup_cache_load")]
    fn load(&self) {
        unsafe {
            ffi::soup_cache_load(self.as_ref().to_glib_none().0);
        }
    }

    #[doc(alias = "soup_cache_set_max_size")]
    fn set_max_size(&self, max_size: u32) {
        unsafe {
            ffi::soup_cache_set_max_size(self.as_ref().to_glib_none().0, max_size);
        }
    }

    #[doc(alias = "cache-dir")]
    fn cache_dir(&self) -> Option<glib::GString> {
        ObjectExt::property(self.as_ref(), "cache-dir")
    }

    #[doc(alias = "cache-type")]
    fn cache_type(&self) -> CacheType {
        ObjectExt::property(self.as_ref(), "cache-type")
    }
}

impl<O: IsA<Cache>> CacheExt for O {}

impl fmt::Display for Cache {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Cache")
    }
}
