# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.0.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).


## [[0.5.2](https://github.com/Devolutions/picky-rs/compare/picky-asn1-der-v0.5.1...picky-asn1-der-v0.5.2)] - 2025-01-16

### <!-- 4 -->Bug Fixes

- Symlinks to license files in packages (#339) ([1834c04f39](https://github.com/Devolutions/picky-rs/commit/1834c04f3930fb1bbf040deb6525b166e378b8aa)) 

  Use symlinks instead of copying files to avoid a “dirty” state during
  cargo publish and preserve VCS info. With #337 merged, CI handles
  publishing consistently, so developer environments no longer matter.


## [0.5.1] 2024-11-26

### Changed

- Update dependencies

## [0.5.0] 2024-07-12

### Changed

- Bump minimal rustc version to 1.61
- Update dependencies

## [0.4.1] 2023-08-23

### Fixed

- License files are now correctly included in the published package

### Changed

- Update dependencies

## [0.4.0] 2022-11-07

### Added

- Derive additional traits for some types ([#171](https://github.com/Devolutions/picky-rs/pull/171))

## [0.3.1] 2022-05-19

### Changed

- Make `ApplicationTag`’s inner value public
- Update dependencies

## [0.3.0] 2022-02-02

### Added

- Support for `GeneralString`
- `ApplicationTag` to encode ASN.1 application tags

### Changed

- Bump minimal rustc version to 1.56

## [0.2.5] 2021-05-27

### Added

- Support for `BMP_STRING` type

## [0.2.4] 2020-08-31

### Changed

- Update dependencies

## [0.2.3] 2020-07-07

### Changed

- Dependencies clean up

## [0.2.2] 2020-01-14

### Fixed

- Fix `Asn1RawDer` behind Application/Context tags issue [#14](https://github.com/Devolutions/picky-rs/issues/14).

## [0.2.1] 2020-01-10

### Added

- `Asn1RawDer` wrapper for user-provided raw DER.

## [0.2.0] 2019-12-23

### Added

- Add `from_reader_with_max_len` deserialization function to limit how many bytes can be read at most.

### Changed

- `from_reader` function has a default limit of 10240 bytes before returning a truncated data error.
    Uses `from_reader_with_max_len` to change the limit.

### Fixed

- Fix various crash found by fuzzing.
