// Code generated by protoc-gen-twirp v8.1.3, DO NOT EDIT.
// source: livekit_sip.proto

package livekit

import context "context"
import fmt "fmt"
import http "net/http"
import io "io"
import json "encoding/json"
import strconv "strconv"
import strings "strings"

import protojson "google.golang.org/protobuf/encoding/protojson"
import proto "google.golang.org/protobuf/proto"
import twirp "github.com/twitchtv/twirp"
import ctxsetters "github.com/twitchtv/twirp/ctxsetters"

// Version compatibility assertion.
// If the constant is not defined in the package, that likely means
// the package needs to be updated to work with this generated code.
// See https://twitchtv.github.io/twirp/docs/version_matrix.html
const _ = twirp.TwirpPackageMinVersion_8_1_0

// =============
// SIP Interface
// =============

type SIP interface {
	CreateSIPTrunk(context.Context, *CreateSIPTrunkRequest) (*SIPTrunkInfo, error)

	ListSIPTrunk(context.Context, *ListSIPTrunkRequest) (*ListSIPTrunkResponse, error)

	DeleteSIPTrunk(context.Context, *DeleteSIPTrunkRequest) (*SIPTrunkInfo, error)

	CreateSIPDispatchRule(context.Context, *CreateSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error)

	ListSIPDispatchRule(context.Context, *ListSIPDispatchRuleRequest) (*ListSIPDispatchRuleResponse, error)

	DeleteSIPDispatchRule(context.Context, *DeleteSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error)

	CreateSIPParticipant(context.Context, *CreateSIPParticipantRequest) (*SIPParticipantInfo, error)
}

// ===================
// SIP Protobuf Client
// ===================

type sIPProtobufClient struct {
	client      HTTPClient
	urls        [7]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewSIPProtobufClient creates a Protobuf client that implements the SIP interface.
// It communicates using Protobuf and can be configured with a custom HTTPClient.
func NewSIPProtobufClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) SIP {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Using ReadOpt allows backwards and forwards compatibility with new options in the future
	literalURLs := false
	_ = clientOpts.ReadOpt("literalURLs", &literalURLs)
	var pathPrefix string
	if ok := clientOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(pathPrefix, "livekit", "SIP")
	urls := [7]string{
		serviceURL + "CreateSIPTrunk",
		serviceURL + "ListSIPTrunk",
		serviceURL + "DeleteSIPTrunk",
		serviceURL + "CreateSIPDispatchRule",
		serviceURL + "ListSIPDispatchRule",
		serviceURL + "DeleteSIPDispatchRule",
		serviceURL + "CreateSIPParticipant",
	}

	return &sIPProtobufClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *sIPProtobufClient) CreateSIPTrunk(ctx context.Context, in *CreateSIPTrunkRequest) (*SIPTrunkInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "SIP")
	ctx = ctxsetters.WithMethodName(ctx, "CreateSIPTrunk")
	caller := c.callCreateSIPTrunk
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateSIPTrunkRequest) (*SIPTrunkInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateSIPTrunkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateSIPTrunkRequest) when calling interceptor")
					}
					return c.callCreateSIPTrunk(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPTrunkInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPTrunkInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *sIPProtobufClient) callCreateSIPTrunk(ctx context.Context, in *CreateSIPTrunkRequest) (*SIPTrunkInfo, error) {
	out := new(SIPTrunkInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *sIPProtobufClient) ListSIPTrunk(ctx context.Context, in *ListSIPTrunkRequest) (*ListSIPTrunkResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "SIP")
	ctx = ctxsetters.WithMethodName(ctx, "ListSIPTrunk")
	caller := c.callListSIPTrunk
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListSIPTrunkRequest) (*ListSIPTrunkResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListSIPTrunkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListSIPTrunkRequest) when calling interceptor")
					}
					return c.callListSIPTrunk(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListSIPTrunkResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListSIPTrunkResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *sIPProtobufClient) callListSIPTrunk(ctx context.Context, in *ListSIPTrunkRequest) (*ListSIPTrunkResponse, error) {
	out := new(ListSIPTrunkResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *sIPProtobufClient) DeleteSIPTrunk(ctx context.Context, in *DeleteSIPTrunkRequest) (*SIPTrunkInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "SIP")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteSIPTrunk")
	caller := c.callDeleteSIPTrunk
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteSIPTrunkRequest) (*SIPTrunkInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteSIPTrunkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteSIPTrunkRequest) when calling interceptor")
					}
					return c.callDeleteSIPTrunk(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPTrunkInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPTrunkInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *sIPProtobufClient) callDeleteSIPTrunk(ctx context.Context, in *DeleteSIPTrunkRequest) (*SIPTrunkInfo, error) {
	out := new(SIPTrunkInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *sIPProtobufClient) CreateSIPDispatchRule(ctx context.Context, in *CreateSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "SIP")
	ctx = ctxsetters.WithMethodName(ctx, "CreateSIPDispatchRule")
	caller := c.callCreateSIPDispatchRule
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateSIPDispatchRuleRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateSIPDispatchRuleRequest) when calling interceptor")
					}
					return c.callCreateSIPDispatchRule(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPDispatchRuleInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPDispatchRuleInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *sIPProtobufClient) callCreateSIPDispatchRule(ctx context.Context, in *CreateSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error) {
	out := new(SIPDispatchRuleInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *sIPProtobufClient) ListSIPDispatchRule(ctx context.Context, in *ListSIPDispatchRuleRequest) (*ListSIPDispatchRuleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "SIP")
	ctx = ctxsetters.WithMethodName(ctx, "ListSIPDispatchRule")
	caller := c.callListSIPDispatchRule
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListSIPDispatchRuleRequest) (*ListSIPDispatchRuleResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListSIPDispatchRuleRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListSIPDispatchRuleRequest) when calling interceptor")
					}
					return c.callListSIPDispatchRule(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListSIPDispatchRuleResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListSIPDispatchRuleResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *sIPProtobufClient) callListSIPDispatchRule(ctx context.Context, in *ListSIPDispatchRuleRequest) (*ListSIPDispatchRuleResponse, error) {
	out := new(ListSIPDispatchRuleResponse)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *sIPProtobufClient) DeleteSIPDispatchRule(ctx context.Context, in *DeleteSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "SIP")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteSIPDispatchRule")
	caller := c.callDeleteSIPDispatchRule
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteSIPDispatchRuleRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteSIPDispatchRuleRequest) when calling interceptor")
					}
					return c.callDeleteSIPDispatchRule(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPDispatchRuleInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPDispatchRuleInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *sIPProtobufClient) callDeleteSIPDispatchRule(ctx context.Context, in *DeleteSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error) {
	out := new(SIPDispatchRuleInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *sIPProtobufClient) CreateSIPParticipant(ctx context.Context, in *CreateSIPParticipantRequest) (*SIPParticipantInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "SIP")
	ctx = ctxsetters.WithMethodName(ctx, "CreateSIPParticipant")
	caller := c.callCreateSIPParticipant
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateSIPParticipantRequest) (*SIPParticipantInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateSIPParticipantRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateSIPParticipantRequest) when calling interceptor")
					}
					return c.callCreateSIPParticipant(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPParticipantInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPParticipantInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *sIPProtobufClient) callCreateSIPParticipant(ctx context.Context, in *CreateSIPParticipantRequest) (*SIPParticipantInfo, error) {
	out := new(SIPParticipantInfo)
	ctx, err := doProtobufRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ===============
// SIP JSON Client
// ===============

type sIPJSONClient struct {
	client      HTTPClient
	urls        [7]string
	interceptor twirp.Interceptor
	opts        twirp.ClientOptions
}

// NewSIPJSONClient creates a JSON client that implements the SIP interface.
// It communicates using JSON and can be configured with a custom HTTPClient.
func NewSIPJSONClient(baseURL string, client HTTPClient, opts ...twirp.ClientOption) SIP {
	if c, ok := client.(*http.Client); ok {
		client = withoutRedirects(c)
	}

	clientOpts := twirp.ClientOptions{}
	for _, o := range opts {
		o(&clientOpts)
	}

	// Using ReadOpt allows backwards and forwards compatibility with new options in the future
	literalURLs := false
	_ = clientOpts.ReadOpt("literalURLs", &literalURLs)
	var pathPrefix string
	if ok := clientOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	// Build method URLs: <baseURL>[<prefix>]/<package>.<Service>/<Method>
	serviceURL := sanitizeBaseURL(baseURL)
	serviceURL += baseServicePath(pathPrefix, "livekit", "SIP")
	urls := [7]string{
		serviceURL + "CreateSIPTrunk",
		serviceURL + "ListSIPTrunk",
		serviceURL + "DeleteSIPTrunk",
		serviceURL + "CreateSIPDispatchRule",
		serviceURL + "ListSIPDispatchRule",
		serviceURL + "DeleteSIPDispatchRule",
		serviceURL + "CreateSIPParticipant",
	}

	return &sIPJSONClient{
		client:      client,
		urls:        urls,
		interceptor: twirp.ChainInterceptors(clientOpts.Interceptors...),
		opts:        clientOpts,
	}
}

func (c *sIPJSONClient) CreateSIPTrunk(ctx context.Context, in *CreateSIPTrunkRequest) (*SIPTrunkInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "SIP")
	ctx = ctxsetters.WithMethodName(ctx, "CreateSIPTrunk")
	caller := c.callCreateSIPTrunk
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateSIPTrunkRequest) (*SIPTrunkInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateSIPTrunkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateSIPTrunkRequest) when calling interceptor")
					}
					return c.callCreateSIPTrunk(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPTrunkInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPTrunkInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *sIPJSONClient) callCreateSIPTrunk(ctx context.Context, in *CreateSIPTrunkRequest) (*SIPTrunkInfo, error) {
	out := new(SIPTrunkInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[0], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *sIPJSONClient) ListSIPTrunk(ctx context.Context, in *ListSIPTrunkRequest) (*ListSIPTrunkResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "SIP")
	ctx = ctxsetters.WithMethodName(ctx, "ListSIPTrunk")
	caller := c.callListSIPTrunk
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListSIPTrunkRequest) (*ListSIPTrunkResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListSIPTrunkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListSIPTrunkRequest) when calling interceptor")
					}
					return c.callListSIPTrunk(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListSIPTrunkResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListSIPTrunkResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *sIPJSONClient) callListSIPTrunk(ctx context.Context, in *ListSIPTrunkRequest) (*ListSIPTrunkResponse, error) {
	out := new(ListSIPTrunkResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[1], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *sIPJSONClient) DeleteSIPTrunk(ctx context.Context, in *DeleteSIPTrunkRequest) (*SIPTrunkInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "SIP")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteSIPTrunk")
	caller := c.callDeleteSIPTrunk
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteSIPTrunkRequest) (*SIPTrunkInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteSIPTrunkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteSIPTrunkRequest) when calling interceptor")
					}
					return c.callDeleteSIPTrunk(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPTrunkInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPTrunkInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *sIPJSONClient) callDeleteSIPTrunk(ctx context.Context, in *DeleteSIPTrunkRequest) (*SIPTrunkInfo, error) {
	out := new(SIPTrunkInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[2], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *sIPJSONClient) CreateSIPDispatchRule(ctx context.Context, in *CreateSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "SIP")
	ctx = ctxsetters.WithMethodName(ctx, "CreateSIPDispatchRule")
	caller := c.callCreateSIPDispatchRule
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateSIPDispatchRuleRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateSIPDispatchRuleRequest) when calling interceptor")
					}
					return c.callCreateSIPDispatchRule(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPDispatchRuleInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPDispatchRuleInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *sIPJSONClient) callCreateSIPDispatchRule(ctx context.Context, in *CreateSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error) {
	out := new(SIPDispatchRuleInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[3], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *sIPJSONClient) ListSIPDispatchRule(ctx context.Context, in *ListSIPDispatchRuleRequest) (*ListSIPDispatchRuleResponse, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "SIP")
	ctx = ctxsetters.WithMethodName(ctx, "ListSIPDispatchRule")
	caller := c.callListSIPDispatchRule
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *ListSIPDispatchRuleRequest) (*ListSIPDispatchRuleResponse, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListSIPDispatchRuleRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListSIPDispatchRuleRequest) when calling interceptor")
					}
					return c.callListSIPDispatchRule(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListSIPDispatchRuleResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListSIPDispatchRuleResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *sIPJSONClient) callListSIPDispatchRule(ctx context.Context, in *ListSIPDispatchRuleRequest) (*ListSIPDispatchRuleResponse, error) {
	out := new(ListSIPDispatchRuleResponse)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[4], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *sIPJSONClient) DeleteSIPDispatchRule(ctx context.Context, in *DeleteSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "SIP")
	ctx = ctxsetters.WithMethodName(ctx, "DeleteSIPDispatchRule")
	caller := c.callDeleteSIPDispatchRule
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *DeleteSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteSIPDispatchRuleRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteSIPDispatchRuleRequest) when calling interceptor")
					}
					return c.callDeleteSIPDispatchRule(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPDispatchRuleInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPDispatchRuleInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *sIPJSONClient) callDeleteSIPDispatchRule(ctx context.Context, in *DeleteSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error) {
	out := new(SIPDispatchRuleInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[5], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

func (c *sIPJSONClient) CreateSIPParticipant(ctx context.Context, in *CreateSIPParticipantRequest) (*SIPParticipantInfo, error) {
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "SIP")
	ctx = ctxsetters.WithMethodName(ctx, "CreateSIPParticipant")
	caller := c.callCreateSIPParticipant
	if c.interceptor != nil {
		caller = func(ctx context.Context, req *CreateSIPParticipantRequest) (*SIPParticipantInfo, error) {
			resp, err := c.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateSIPParticipantRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateSIPParticipantRequest) when calling interceptor")
					}
					return c.callCreateSIPParticipant(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPParticipantInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPParticipantInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}
	return caller(ctx, in)
}

func (c *sIPJSONClient) callCreateSIPParticipant(ctx context.Context, in *CreateSIPParticipantRequest) (*SIPParticipantInfo, error) {
	out := new(SIPParticipantInfo)
	ctx, err := doJSONRequest(ctx, c.client, c.opts.Hooks, c.urls[6], in, out)
	if err != nil {
		twerr, ok := err.(twirp.Error)
		if !ok {
			twerr = twirp.InternalErrorWith(err)
		}
		callClientError(ctx, c.opts.Hooks, twerr)
		return nil, err
	}

	callClientResponseReceived(ctx, c.opts.Hooks)

	return out, nil
}

// ==================
// SIP Server Handler
// ==================

type sIPServer struct {
	SIP
	interceptor      twirp.Interceptor
	hooks            *twirp.ServerHooks
	pathPrefix       string // prefix for routing
	jsonSkipDefaults bool   // do not include unpopulated fields (default values) in the response
	jsonCamelCase    bool   // JSON fields are serialized as lowerCamelCase rather than keeping the original proto names
}

// NewSIPServer builds a TwirpServer that can be used as an http.Handler to handle
// HTTP requests that are routed to the right method in the provided svc implementation.
// The opts are twirp.ServerOption modifiers, for example twirp.WithServerHooks(hooks).
func NewSIPServer(svc SIP, opts ...interface{}) TwirpServer {
	serverOpts := newServerOpts(opts)

	// Using ReadOpt allows backwards and forwards compatibility with new options in the future
	jsonSkipDefaults := false
	_ = serverOpts.ReadOpt("jsonSkipDefaults", &jsonSkipDefaults)
	jsonCamelCase := false
	_ = serverOpts.ReadOpt("jsonCamelCase", &jsonCamelCase)
	var pathPrefix string
	if ok := serverOpts.ReadOpt("pathPrefix", &pathPrefix); !ok {
		pathPrefix = "/twirp" // default prefix
	}

	return &sIPServer{
		SIP:              svc,
		hooks:            serverOpts.Hooks,
		interceptor:      twirp.ChainInterceptors(serverOpts.Interceptors...),
		pathPrefix:       pathPrefix,
		jsonSkipDefaults: jsonSkipDefaults,
		jsonCamelCase:    jsonCamelCase,
	}
}

// writeError writes an HTTP response with a valid Twirp error format, and triggers hooks.
// If err is not a twirp.Error, it will get wrapped with twirp.InternalErrorWith(err)
func (s *sIPServer) writeError(ctx context.Context, resp http.ResponseWriter, err error) {
	writeError(ctx, resp, err, s.hooks)
}

// handleRequestBodyError is used to handle error when the twirp server cannot read request
func (s *sIPServer) handleRequestBodyError(ctx context.Context, resp http.ResponseWriter, msg string, err error) {
	if context.Canceled == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.Canceled, "failed to read request: context canceled"))
		return
	}
	if context.DeadlineExceeded == ctx.Err() {
		s.writeError(ctx, resp, twirp.NewError(twirp.DeadlineExceeded, "failed to read request: deadline exceeded"))
		return
	}
	s.writeError(ctx, resp, twirp.WrapError(malformedRequestError(msg), err))
}

// SIPPathPrefix is a convenience constant that may identify URL paths.
// Should be used with caution, it only matches routes generated by Twirp Go clients,
// with the default "/twirp" prefix and default CamelCase service and method names.
// More info: https://twitchtv.github.io/twirp/docs/routing.html
const SIPPathPrefix = "/twirp/livekit.SIP/"

func (s *sIPServer) ServeHTTP(resp http.ResponseWriter, req *http.Request) {
	ctx := req.Context()
	ctx = ctxsetters.WithPackageName(ctx, "livekit")
	ctx = ctxsetters.WithServiceName(ctx, "SIP")
	ctx = ctxsetters.WithResponseWriter(ctx, resp)

	var err error
	ctx, err = callRequestReceived(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	if req.Method != "POST" {
		msg := fmt.Sprintf("unsupported method %q (only POST is allowed)", req.Method)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	// Verify path format: [<prefix>]/<package>.<Service>/<Method>
	prefix, pkgService, method := parseTwirpPath(req.URL.Path)
	if pkgService != "livekit.SIP" {
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
	if prefix != s.pathPrefix {
		msg := fmt.Sprintf("invalid path prefix %q, expected %q, on path %q", prefix, s.pathPrefix, req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}

	switch method {
	case "CreateSIPTrunk":
		s.serveCreateSIPTrunk(ctx, resp, req)
		return
	case "ListSIPTrunk":
		s.serveListSIPTrunk(ctx, resp, req)
		return
	case "DeleteSIPTrunk":
		s.serveDeleteSIPTrunk(ctx, resp, req)
		return
	case "CreateSIPDispatchRule":
		s.serveCreateSIPDispatchRule(ctx, resp, req)
		return
	case "ListSIPDispatchRule":
		s.serveListSIPDispatchRule(ctx, resp, req)
		return
	case "DeleteSIPDispatchRule":
		s.serveDeleteSIPDispatchRule(ctx, resp, req)
		return
	case "CreateSIPParticipant":
		s.serveCreateSIPParticipant(ctx, resp, req)
		return
	default:
		msg := fmt.Sprintf("no handler for path %q", req.URL.Path)
		s.writeError(ctx, resp, badRouteError(msg, req.Method, req.URL.Path))
		return
	}
}

func (s *sIPServer) serveCreateSIPTrunk(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateSIPTrunkJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateSIPTrunkProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *sIPServer) serveCreateSIPTrunkJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateSIPTrunk")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(CreateSIPTrunkRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.SIP.CreateSIPTrunk
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateSIPTrunkRequest) (*SIPTrunkInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateSIPTrunkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateSIPTrunkRequest) when calling interceptor")
					}
					return s.SIP.CreateSIPTrunk(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPTrunkInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPTrunkInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *SIPTrunkInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SIPTrunkInfo and nil error while calling CreateSIPTrunk. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sIPServer) serveCreateSIPTrunkProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateSIPTrunk")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(CreateSIPTrunkRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.SIP.CreateSIPTrunk
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateSIPTrunkRequest) (*SIPTrunkInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateSIPTrunkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateSIPTrunkRequest) when calling interceptor")
					}
					return s.SIP.CreateSIPTrunk(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPTrunkInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPTrunkInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *SIPTrunkInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SIPTrunkInfo and nil error while calling CreateSIPTrunk. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sIPServer) serveListSIPTrunk(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListSIPTrunkJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListSIPTrunkProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *sIPServer) serveListSIPTrunkJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListSIPTrunk")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(ListSIPTrunkRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.SIP.ListSIPTrunk
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListSIPTrunkRequest) (*ListSIPTrunkResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListSIPTrunkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListSIPTrunkRequest) when calling interceptor")
					}
					return s.SIP.ListSIPTrunk(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListSIPTrunkResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListSIPTrunkResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ListSIPTrunkResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListSIPTrunkResponse and nil error while calling ListSIPTrunk. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sIPServer) serveListSIPTrunkProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListSIPTrunk")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(ListSIPTrunkRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.SIP.ListSIPTrunk
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListSIPTrunkRequest) (*ListSIPTrunkResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListSIPTrunkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListSIPTrunkRequest) when calling interceptor")
					}
					return s.SIP.ListSIPTrunk(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListSIPTrunkResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListSIPTrunkResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ListSIPTrunkResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListSIPTrunkResponse and nil error while calling ListSIPTrunk. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sIPServer) serveDeleteSIPTrunk(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteSIPTrunkJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteSIPTrunkProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *sIPServer) serveDeleteSIPTrunkJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteSIPTrunk")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(DeleteSIPTrunkRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.SIP.DeleteSIPTrunk
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteSIPTrunkRequest) (*SIPTrunkInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteSIPTrunkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteSIPTrunkRequest) when calling interceptor")
					}
					return s.SIP.DeleteSIPTrunk(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPTrunkInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPTrunkInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *SIPTrunkInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SIPTrunkInfo and nil error while calling DeleteSIPTrunk. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sIPServer) serveDeleteSIPTrunkProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteSIPTrunk")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(DeleteSIPTrunkRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.SIP.DeleteSIPTrunk
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteSIPTrunkRequest) (*SIPTrunkInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteSIPTrunkRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteSIPTrunkRequest) when calling interceptor")
					}
					return s.SIP.DeleteSIPTrunk(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPTrunkInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPTrunkInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *SIPTrunkInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SIPTrunkInfo and nil error while calling DeleteSIPTrunk. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sIPServer) serveCreateSIPDispatchRule(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateSIPDispatchRuleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateSIPDispatchRuleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *sIPServer) serveCreateSIPDispatchRuleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateSIPDispatchRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(CreateSIPDispatchRuleRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.SIP.CreateSIPDispatchRule
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateSIPDispatchRuleRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateSIPDispatchRuleRequest) when calling interceptor")
					}
					return s.SIP.CreateSIPDispatchRule(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPDispatchRuleInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPDispatchRuleInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *SIPDispatchRuleInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SIPDispatchRuleInfo and nil error while calling CreateSIPDispatchRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sIPServer) serveCreateSIPDispatchRuleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateSIPDispatchRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(CreateSIPDispatchRuleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.SIP.CreateSIPDispatchRule
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateSIPDispatchRuleRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateSIPDispatchRuleRequest) when calling interceptor")
					}
					return s.SIP.CreateSIPDispatchRule(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPDispatchRuleInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPDispatchRuleInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *SIPDispatchRuleInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SIPDispatchRuleInfo and nil error while calling CreateSIPDispatchRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sIPServer) serveListSIPDispatchRule(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveListSIPDispatchRuleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveListSIPDispatchRuleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *sIPServer) serveListSIPDispatchRuleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListSIPDispatchRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(ListSIPDispatchRuleRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.SIP.ListSIPDispatchRule
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListSIPDispatchRuleRequest) (*ListSIPDispatchRuleResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListSIPDispatchRuleRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListSIPDispatchRuleRequest) when calling interceptor")
					}
					return s.SIP.ListSIPDispatchRule(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListSIPDispatchRuleResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListSIPDispatchRuleResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ListSIPDispatchRuleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListSIPDispatchRuleResponse and nil error while calling ListSIPDispatchRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sIPServer) serveListSIPDispatchRuleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "ListSIPDispatchRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(ListSIPDispatchRuleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.SIP.ListSIPDispatchRule
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *ListSIPDispatchRuleRequest) (*ListSIPDispatchRuleResponse, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*ListSIPDispatchRuleRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*ListSIPDispatchRuleRequest) when calling interceptor")
					}
					return s.SIP.ListSIPDispatchRule(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*ListSIPDispatchRuleResponse)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*ListSIPDispatchRuleResponse) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *ListSIPDispatchRuleResponse
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *ListSIPDispatchRuleResponse and nil error while calling ListSIPDispatchRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sIPServer) serveDeleteSIPDispatchRule(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveDeleteSIPDispatchRuleJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveDeleteSIPDispatchRuleProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *sIPServer) serveDeleteSIPDispatchRuleJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteSIPDispatchRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(DeleteSIPDispatchRuleRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.SIP.DeleteSIPDispatchRule
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteSIPDispatchRuleRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteSIPDispatchRuleRequest) when calling interceptor")
					}
					return s.SIP.DeleteSIPDispatchRule(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPDispatchRuleInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPDispatchRuleInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *SIPDispatchRuleInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SIPDispatchRuleInfo and nil error while calling DeleteSIPDispatchRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sIPServer) serveDeleteSIPDispatchRuleProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "DeleteSIPDispatchRule")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(DeleteSIPDispatchRuleRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.SIP.DeleteSIPDispatchRule
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *DeleteSIPDispatchRuleRequest) (*SIPDispatchRuleInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*DeleteSIPDispatchRuleRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*DeleteSIPDispatchRuleRequest) when calling interceptor")
					}
					return s.SIP.DeleteSIPDispatchRule(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPDispatchRuleInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPDispatchRuleInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *SIPDispatchRuleInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SIPDispatchRuleInfo and nil error while calling DeleteSIPDispatchRule. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sIPServer) serveCreateSIPParticipant(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	header := req.Header.Get("Content-Type")
	i := strings.Index(header, ";")
	if i == -1 {
		i = len(header)
	}
	switch strings.TrimSpace(strings.ToLower(header[:i])) {
	case "application/json":
		s.serveCreateSIPParticipantJSON(ctx, resp, req)
	case "application/protobuf":
		s.serveCreateSIPParticipantProtobuf(ctx, resp, req)
	default:
		msg := fmt.Sprintf("unexpected Content-Type: %q", req.Header.Get("Content-Type"))
		twerr := badRouteError(msg, req.Method, req.URL.Path)
		s.writeError(ctx, resp, twerr)
	}
}

func (s *sIPServer) serveCreateSIPParticipantJSON(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateSIPParticipant")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	d := json.NewDecoder(req.Body)
	rawReqBody := json.RawMessage{}
	if err := d.Decode(&rawReqBody); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}
	reqContent := new(CreateSIPParticipantRequest)
	unmarshaler := protojson.UnmarshalOptions{DiscardUnknown: true}
	if err = unmarshaler.Unmarshal(rawReqBody, reqContent); err != nil {
		s.handleRequestBodyError(ctx, resp, "the json request could not be decoded", err)
		return
	}

	handler := s.SIP.CreateSIPParticipant
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateSIPParticipantRequest) (*SIPParticipantInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateSIPParticipantRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateSIPParticipantRequest) when calling interceptor")
					}
					return s.SIP.CreateSIPParticipant(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPParticipantInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPParticipantInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *SIPParticipantInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SIPParticipantInfo and nil error while calling CreateSIPParticipant. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	marshaler := &protojson.MarshalOptions{UseProtoNames: !s.jsonCamelCase, EmitUnpopulated: !s.jsonSkipDefaults}
	respBytes, err := marshaler.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal json response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/json")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)

	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sIPServer) serveCreateSIPParticipantProtobuf(ctx context.Context, resp http.ResponseWriter, req *http.Request) {
	var err error
	ctx = ctxsetters.WithMethodName(ctx, "CreateSIPParticipant")
	ctx, err = callRequestRouted(ctx, s.hooks)
	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}

	buf, err := io.ReadAll(req.Body)
	if err != nil {
		s.handleRequestBodyError(ctx, resp, "failed to read request body", err)
		return
	}
	reqContent := new(CreateSIPParticipantRequest)
	if err = proto.Unmarshal(buf, reqContent); err != nil {
		s.writeError(ctx, resp, malformedRequestError("the protobuf request could not be decoded"))
		return
	}

	handler := s.SIP.CreateSIPParticipant
	if s.interceptor != nil {
		handler = func(ctx context.Context, req *CreateSIPParticipantRequest) (*SIPParticipantInfo, error) {
			resp, err := s.interceptor(
				func(ctx context.Context, req interface{}) (interface{}, error) {
					typedReq, ok := req.(*CreateSIPParticipantRequest)
					if !ok {
						return nil, twirp.InternalError("failed type assertion req.(*CreateSIPParticipantRequest) when calling interceptor")
					}
					return s.SIP.CreateSIPParticipant(ctx, typedReq)
				},
			)(ctx, req)
			if resp != nil {
				typedResp, ok := resp.(*SIPParticipantInfo)
				if !ok {
					return nil, twirp.InternalError("failed type assertion resp.(*SIPParticipantInfo) when calling interceptor")
				}
				return typedResp, err
			}
			return nil, err
		}
	}

	// Call service method
	var respContent *SIPParticipantInfo
	func() {
		defer ensurePanicResponses(ctx, resp, s.hooks)
		respContent, err = handler(ctx, reqContent)
	}()

	if err != nil {
		s.writeError(ctx, resp, err)
		return
	}
	if respContent == nil {
		s.writeError(ctx, resp, twirp.InternalError("received a nil *SIPParticipantInfo and nil error while calling CreateSIPParticipant. nil responses are not supported"))
		return
	}

	ctx = callResponsePrepared(ctx, s.hooks)

	respBytes, err := proto.Marshal(respContent)
	if err != nil {
		s.writeError(ctx, resp, wrapInternal(err, "failed to marshal proto response"))
		return
	}

	ctx = ctxsetters.WithStatusCode(ctx, http.StatusOK)
	resp.Header().Set("Content-Type", "application/protobuf")
	resp.Header().Set("Content-Length", strconv.Itoa(len(respBytes)))
	resp.WriteHeader(http.StatusOK)
	if n, err := resp.Write(respBytes); err != nil {
		msg := fmt.Sprintf("failed to write response, %d of %d bytes written: %s", n, len(respBytes), err.Error())
		twerr := twirp.NewError(twirp.Unknown, msg)
		ctx = callError(ctx, s.hooks, twerr)
	}
	callResponseSent(ctx, s.hooks)
}

func (s *sIPServer) ServiceDescriptor() ([]byte, int) {
	return twirpFileDescriptor3, 0
}

func (s *sIPServer) ProtocGenTwirpVersion() string {
	return "v8.1.3"
}

// PathPrefix returns the base service path, in the form: "/<prefix>/<package>.<Service>/"
// that is everything in a Twirp route except for the <Method>. This can be used for routing,
// for example to identify the requests that are targeted to this service in a mux.
func (s *sIPServer) PathPrefix() string {
	return baseServicePath(s.pathPrefix, "livekit", "SIP")
}

var twirpFileDescriptor3 = []byte{
	// 887 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0xdd, 0x72, 0xdb, 0x44,
	0x14, 0xae, 0x2c, 0xc7, 0xb1, 0x8f, 0x53, 0x27, 0x5e, 0xdb, 0x8c, 0xb0, 0x4d, 0xc9, 0xa8, 0xed,
	0x50, 0x7e, 0xc6, 0x19, 0xcc, 0x15, 0xbd, 0xa3, 0xc9, 0xb4, 0xf5, 0xb4, 0x13, 0x84, 0x52, 0x2e,
	0x60, 0x3a, 0x08, 0xd9, 0xda, 0xc4, 0x3b, 0x91, 0x25, 0xa1, 0x5d, 0x85, 0xf0, 0x0c, 0x5c, 0xe7,
	0x25, 0xb8, 0xe1, 0x09, 0x78, 0x04, 0x1e, 0x81, 0x17, 0xe0, 0x19, 0xb8, 0x60, 0x76, 0xb5, 0x92,
	0x25, 0x5b, 0x72, 0xec, 0x3b, 0xfb, 0x9c, 0xb3, 0x9f, 0xbe, 0xb3, 0xdf, 0xf9, 0x8e, 0x04, 0x6d,
	0x97, 0xdc, 0xe0, 0x6b, 0xc2, 0x2c, 0x4a, 0x82, 0x51, 0x10, 0xfa, 0xcc, 0x47, 0xfb, 0x32, 0xa4,
	0xff, 0x57, 0x81, 0xde, 0x69, 0x88, 0x6d, 0x86, 0x2f, 0x26, 0xc6, 0xbb, 0x30, 0xf2, 0xae, 0x4d,
	0xfc, 0x4b, 0x84, 0x29, 0x43, 0x9f, 0x43, 0x9b, 0x78, 0x53, 0x3f, 0xf2, 0x1c, 0xcb, 0x76, 0x9c,
	0x10, 0x53, 0x8a, 0xa9, 0xa6, 0x1c, 0xab, 0xcf, 0x1a, 0xe6, 0x91, 0x4c, 0x7c, 0x93, 0xc4, 0xd1,
	0xa7, 0x70, 0xe4, 0x47, 0x2c, 0x57, 0xad, 0x55, 0x8e, 0x95, 0x67, 0x0d, 0xf3, 0x30, 0x89, 0xcb,
	0x62, 0xf4, 0x09, 0xa4, 0x21, 0xcb, 0x8b, 0x16, 0x53, 0x1c, 0x6a, 0xaa, 0xa8, 0x6c, 0x25, 0xe1,
	0x73, 0x11, 0x45, 0x63, 0xe8, 0x25, 0x04, 0xe2, 0x3a, 0x6a, 0x85, 0xf8, 0x0a, 0xdf, 0x6a, 0x55,
	0x41, 0xa2, 0x23, 0x93, 0x71, 0x35, 0x35, 0x79, 0x8a, 0xf3, 0x48, 0xce, 0x44, 0x14, 0x87, 0x9e,
	0xbd, 0xc0, 0xda, 0x5e, 0xcc, 0x43, 0xc6, 0xbf, 0x97, 0xe1, 0x6c, 0x69, 0x60, 0x53, 0xfa, 0xab,
	0x1f, 0x3a, 0x5a, 0x2d, 0x57, 0x6a, 0xc8, 0x30, 0xbf, 0x8a, 0x94, 0x72, 0x0a, 0xbb, 0x2f, 0x6a,
	0xd3, 0xb6, 0x53, 0xdc, 0x6c, 0x71, 0x0a, 0x5c, 0xcf, 0x17, 0x27, 0xc8, 0xfa, 0x9d, 0x0a, 0x07,
	0xc9, 0xc5, 0x4f, 0xbc, 0x4b, 0x1f, 0x1d, 0xc3, 0x01, 0x25, 0x81, 0xc5, 0x78, 0xc0, 0x22, 0x8e,
	0xa6, 0x88, 0x83, 0x40, 0x49, 0x10, 0xd7, 0x38, 0xc5, 0xba, 0x54, 0x76, 0xd0, 0x45, 0xdd, 0x5a,
	0x97, 0xea, 0x6e, 0xba, 0xec, 0xed, 0xa6, 0x4b, 0x6d, 0x7b, 0x5d, 0xf6, 0x77, 0xd0, 0xa5, 0xbe,
	0x8b, 0x2e, 0x8d, 0x12, 0x5d, 0x7a, 0xd0, 0x79, 0x4b, 0x28, 0x5b, 0xf1, 0x84, 0x7e, 0x0a, 0xdd,
	0x7c, 0x98, 0x06, 0xbe, 0x47, 0x39, 0xf6, 0x1e, 0x61, 0x78, 0x11, 0xfb, 0xa3, 0x39, 0xee, 0x8d,
	0xa4, 0xbd, 0x46, 0x59, 0x6d, 0xcd, 0xb8, 0x46, 0xff, 0x1a, 0x7a, 0x67, 0xd8, 0xc5, 0xeb, 0x8e,
	0xbb, 0x57, 0x7b, 0xfd, 0x25, 0xf4, 0x2e, 0x26, 0xc6, 0x19, 0xa1, 0x81, 0xcd, 0x66, 0x73, 0x33,
	0x72, 0xf1, 0x19, 0x09, 0xf1, 0x8c, 0xa1, 0x01, 0x34, 0x42, 0xdf, 0x5f, 0x58, 0xe2, 0x06, 0xe2,
	0x73, 0x75, 0x1e, 0x38, 0xe7, 0x9d, 0x1f, 0x81, 0x1a, 0x10, 0x4f, 0xfa, 0x91, 0xff, 0xd4, 0xcf,
	0xe1, 0xc3, 0x15, 0x9c, 0x89, 0xe7, 0x90, 0x1b, 0xe2, 0x44, 0xb6, 0x8b, 0x3e, 0x86, 0xa6, 0xc0,
	0x0a, 0x42, 0x7c, 0x49, 0x6e, 0x13, 0x16, 0x3c, 0x64, 0x88, 0x48, 0x01, 0xde, 0xdf, 0x0a, 0x1c,
	0xae, 0x00, 0x22, 0x13, 0xba, 0x8e, 0xfc, 0x6f, 0x85, 0x91, 0x8b, 0x2d, 0x47, 0x50, 0x15, 0x78,
	0xcd, 0xf1, 0xa3, 0xec, 0x15, 0xad, 0x37, 0xf4, 0xfa, 0x81, 0x89, 0x9c, 0xf5, 0x36, 0x7f, 0x02,
	0x2d, 0x8f, 0x49, 0x52, 0xda, 0x82, 0x4e, 0x73, 0xac, 0x97, 0xe1, 0x2e, 0x1b, 0x7c, 0xfd, 0xc0,
	0xfc, 0xc0, 0x29, 0xcc, 0xbc, 0xa8, 0x41, 0x95, 0xc3, 0xea, 0x77, 0x0a, 0x0c, 0xd3, 0xad, 0x98,
	0x45, 0x49, 0xa4, 0xfa, 0x22, 0x2e, 0x94, 0xcd, 0x68, 0x65, 0x0f, 0x35, 0x45, 0x15, 0x57, 0x27,
	0x11, 0x35, 0xb1, 0x6a, 0x9d, 0xc5, 0x92, 0x52, 0xf4, 0x19, 0xb4, 0xe7, 0xc4, 0xc1, 0x56, 0x30,
	0xf7, 0x3d, 0x9c, 0xdd, 0x88, 0x75, 0xf3, 0x90, 0x27, 0x0c, 0x1e, 0x8f, 0xcd, 0xa4, 0xff, 0xa5,
	0x40, 0x67, 0xad, 0xaf, 0x4b, 0x1f, 0x9d, 0x40, 0x97, 0x4f, 0xce, 0xca, 0xdd, 0x24, 0x13, 0xd4,
	0xa6, 0x24, 0xc8, 0x1d, 0x71, 0x52, 0xfe, 0x95, 0xdd, 0xf9, 0xab, 0xdb, 0xf0, 0xaf, 0x16, 0xf3,
	0x1f, 0x42, 0x5f, 0xfa, 0xa7, 0xe0, 0x52, 0xf5, 0xef, 0x60, 0x50, 0x98, 0x95, 0x26, 0x1b, 0xe7,
	0x4d, 0x36, 0x2c, 0x57, 0x7a, 0xe9, 0xb5, 0x6f, 0x61, 0x98, 0x7a, 0xad, 0x48, 0xc7, 0x5d, 0x2f,
	0x4e, 0xff, 0x53, 0x81, 0x41, 0x3a, 0x19, 0x86, 0x1d, 0x32, 0x32, 0x23, 0x81, 0xed, 0xb1, 0xad,
	0x3d, 0x8c, 0x1e, 0x41, 0x93, 0x57, 0xcc, 0x6c, 0xd7, 0xb5, 0x98, 0x2f, 0x5d, 0xd4, 0xa0, 0x24,
	0x38, 0xb5, 0x5d, 0xf7, 0x9d, 0x9f, 0xb7, 0xb2, 0xba, 0x62, 0xe5, 0x2f, 0xa1, 0x1b, 0x2c, 0x1f,
	0x6a, 0x11, 0x07, 0x7b, 0x8c, 0xb0, 0xdf, 0xe4, 0xa6, 0xee, 0x64, 0x72, 0x13, 0x99, 0xd2, 0x7f,
	0x57, 0x00, 0xe5, 0xb9, 0x8a, 0x91, 0x79, 0x0a, 0xad, 0x3c, 0x92, 0xa4, 0xfa, 0x30, 0x87, 0x51,
	0xfa, 0xc0, 0x4a, 0xe9, 0x03, 0x37, 0x36, 0x30, 0xfe, 0xa7, 0x0a, 0xea, 0xc5, 0xc4, 0x40, 0xaf,
	0xa0, 0x95, 0xff, 0xec, 0x40, 0xcb, 0x8d, 0x50, 0xf8, 0x3d, 0xd2, 0x2f, 0x5e, 0xaa, 0xe8, 0x0d,
	0x1c, 0x64, 0x57, 0x32, 0x5a, 0x8e, 0x45, 0xc1, 0x02, 0xef, 0x7f, 0x54, 0x92, 0x95, 0x23, 0xf6,
	0x0a, 0x5a, 0xf9, 0xd5, 0x9c, 0x61, 0x55, 0xb8, 0xb3, 0xcb, 0x58, 0xbd, 0xcf, 0x7c, 0x55, 0xe5,
	0xb6, 0xe2, 0xd3, 0xf5, 0x2e, 0x0b, 0xe6, 0xb2, 0xbf, 0x71, 0xb8, 0xd1, 0xcf, 0xe9, 0xdb, 0x29,
	0x87, 0xfd, 0x78, 0xb5, 0xb9, 0x22, 0xe4, 0x27, 0x9b, 0x8b, 0xe4, 0x45, 0xbc, 0xcf, 0xbc, 0xa3,
	0x4a, 0xf8, 0x6f, 0xf2, 0xd5, 0x3d, 0xfc, 0x7f, 0x80, 0x6e, 0x91, 0x87, 0xd0, 0x93, 0xf5, 0xcb,
	0x59, 0xb7, 0x58, 0x7f, 0x90, 0xc5, 0x5e, 0x19, 0xeb, 0x17, 0x2f, 0x7f, 0x7c, 0x7c, 0x45, 0xd8,
	0x3c, 0x9a, 0x8e, 0x66, 0xfe, 0xe2, 0x44, 0x16, 0x9e, 0x88, 0x8f, 0xde, 0x99, 0xef, 0x26, 0x81,
	0x3f, 0x2a, 0x0f, 0xdf, 0x92, 0x1b, 0xfc, 0x86, 0xb0, 0x91, 0xc1, 0x53, 0xff, 0x56, 0x5a, 0xf2,
	0xff, 0xf3, 0xe7, 0x22, 0x30, 0xad, 0x89, 0x23, 0x5f, 0xfd, 0x1f, 0x00, 0x00, 0xff, 0xff, 0x58,
	0x18, 0xd2, 0x3a, 0x3c, 0x0b, 0x00, 0x00,
}
