// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub struct StartMedicalScribeStreamInput {
    /// <p>Specify an identifier for your streaming session (in UUID format). If you don't include a SessionId in your request, Amazon Web Services HealthScribe generates an ID and returns it in the response.</p>
    pub session_id: ::std::option::Option<::std::string::String>,
    /// <p>Specify the language code for your HealthScribe streaming session.</p>
    pub language_code: ::std::option::Option<crate::types::MedicalScribeLanguageCode>,
    /// <p>Specify the sample rate of the input audio (in hertz). Amazon Web Services HealthScribe supports a range from 16,000 Hz to 48,000 Hz. The sample rate you specify must match that of your audio.</p>
    pub media_sample_rate_hertz: ::std::option::Option<i32>,
    /// <p>Specify the encoding used for the input audio.</p>
    /// <p>Supported formats are:</p>
    /// <ul>
    /// <li>
    /// <p>FLAC</p></li>
    /// <li>
    /// <p>OPUS-encoded audio in an Ogg container</p></li>
    /// <li>
    /// <p>PCM (only signed 16-bit little-endian audio formats, which does not include WAV)</p></li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.</p>
    pub media_encoding: ::std::option::Option<crate::types::MedicalScribeMediaEncoding>,
    /// <p>Specify the input stream where you will send events in real time.</p>
    /// <p>The first element of the input stream must be a <code>MedicalScribeConfigurationEvent</code>.</p>
    pub input_stream: ::aws_smithy_http::event_stream::EventStreamSender<
        crate::types::MedicalScribeInputStream,
        crate::types::error::MedicalScribeInputStreamError,
    >,
}
impl StartMedicalScribeStreamInput {
    /// <p>Specify an identifier for your streaming session (in UUID format). If you don't include a SessionId in your request, Amazon Web Services HealthScribe generates an ID and returns it in the response.</p>
    pub fn session_id(&self) -> ::std::option::Option<&str> {
        self.session_id.as_deref()
    }
    /// <p>Specify the language code for your HealthScribe streaming session.</p>
    pub fn language_code(&self) -> ::std::option::Option<&crate::types::MedicalScribeLanguageCode> {
        self.language_code.as_ref()
    }
    /// <p>Specify the sample rate of the input audio (in hertz). Amazon Web Services HealthScribe supports a range from 16,000 Hz to 48,000 Hz. The sample rate you specify must match that of your audio.</p>
    pub fn media_sample_rate_hertz(&self) -> ::std::option::Option<i32> {
        self.media_sample_rate_hertz
    }
    /// <p>Specify the encoding used for the input audio.</p>
    /// <p>Supported formats are:</p>
    /// <ul>
    /// <li>
    /// <p>FLAC</p></li>
    /// <li>
    /// <p>OPUS-encoded audio in an Ogg container</p></li>
    /// <li>
    /// <p>PCM (only signed 16-bit little-endian audio formats, which does not include WAV)</p></li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.</p>
    pub fn media_encoding(&self) -> ::std::option::Option<&crate::types::MedicalScribeMediaEncoding> {
        self.media_encoding.as_ref()
    }
    /// <p>Specify the input stream where you will send events in real time.</p>
    /// <p>The first element of the input stream must be a <code>MedicalScribeConfigurationEvent</code>.</p>
    pub fn input_stream(
        &self,
    ) -> &::aws_smithy_http::event_stream::EventStreamSender<crate::types::MedicalScribeInputStream, crate::types::error::MedicalScribeInputStreamError>
    {
        &self.input_stream
    }
}
impl StartMedicalScribeStreamInput {
    /// Creates a new builder-style object to manufacture [`StartMedicalScribeStreamInput`](crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamInput).
    pub fn builder() -> crate::operation::start_medical_scribe_stream::builders::StartMedicalScribeStreamInputBuilder {
        crate::operation::start_medical_scribe_stream::builders::StartMedicalScribeStreamInputBuilder::default()
    }
}

/// A builder for [`StartMedicalScribeStreamInput`](crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamInput).
#[derive(::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct StartMedicalScribeStreamInputBuilder {
    pub(crate) session_id: ::std::option::Option<::std::string::String>,
    pub(crate) language_code: ::std::option::Option<crate::types::MedicalScribeLanguageCode>,
    pub(crate) media_sample_rate_hertz: ::std::option::Option<i32>,
    pub(crate) media_encoding: ::std::option::Option<crate::types::MedicalScribeMediaEncoding>,
    pub(crate) input_stream: ::std::option::Option<
        ::aws_smithy_http::event_stream::EventStreamSender<
            crate::types::MedicalScribeInputStream,
            crate::types::error::MedicalScribeInputStreamError,
        >,
    >,
}
impl StartMedicalScribeStreamInputBuilder {
    /// <p>Specify an identifier for your streaming session (in UUID format). If you don't include a SessionId in your request, Amazon Web Services HealthScribe generates an ID and returns it in the response.</p>
    pub fn session_id(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.session_id = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>Specify an identifier for your streaming session (in UUID format). If you don't include a SessionId in your request, Amazon Web Services HealthScribe generates an ID and returns it in the response.</p>
    pub fn set_session_id(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.session_id = input;
        self
    }
    /// <p>Specify an identifier for your streaming session (in UUID format). If you don't include a SessionId in your request, Amazon Web Services HealthScribe generates an ID and returns it in the response.</p>
    pub fn get_session_id(&self) -> &::std::option::Option<::std::string::String> {
        &self.session_id
    }
    /// <p>Specify the language code for your HealthScribe streaming session.</p>
    /// This field is required.
    pub fn language_code(mut self, input: crate::types::MedicalScribeLanguageCode) -> Self {
        self.language_code = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specify the language code for your HealthScribe streaming session.</p>
    pub fn set_language_code(mut self, input: ::std::option::Option<crate::types::MedicalScribeLanguageCode>) -> Self {
        self.language_code = input;
        self
    }
    /// <p>Specify the language code for your HealthScribe streaming session.</p>
    pub fn get_language_code(&self) -> &::std::option::Option<crate::types::MedicalScribeLanguageCode> {
        &self.language_code
    }
    /// <p>Specify the sample rate of the input audio (in hertz). Amazon Web Services HealthScribe supports a range from 16,000 Hz to 48,000 Hz. The sample rate you specify must match that of your audio.</p>
    /// This field is required.
    pub fn media_sample_rate_hertz(mut self, input: i32) -> Self {
        self.media_sample_rate_hertz = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specify the sample rate of the input audio (in hertz). Amazon Web Services HealthScribe supports a range from 16,000 Hz to 48,000 Hz. The sample rate you specify must match that of your audio.</p>
    pub fn set_media_sample_rate_hertz(mut self, input: ::std::option::Option<i32>) -> Self {
        self.media_sample_rate_hertz = input;
        self
    }
    /// <p>Specify the sample rate of the input audio (in hertz). Amazon Web Services HealthScribe supports a range from 16,000 Hz to 48,000 Hz. The sample rate you specify must match that of your audio.</p>
    pub fn get_media_sample_rate_hertz(&self) -> &::std::option::Option<i32> {
        &self.media_sample_rate_hertz
    }
    /// <p>Specify the encoding used for the input audio.</p>
    /// <p>Supported formats are:</p>
    /// <ul>
    /// <li>
    /// <p>FLAC</p></li>
    /// <li>
    /// <p>OPUS-encoded audio in an Ogg container</p></li>
    /// <li>
    /// <p>PCM (only signed 16-bit little-endian audio formats, which does not include WAV)</p></li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.</p>
    /// This field is required.
    pub fn media_encoding(mut self, input: crate::types::MedicalScribeMediaEncoding) -> Self {
        self.media_encoding = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specify the encoding used for the input audio.</p>
    /// <p>Supported formats are:</p>
    /// <ul>
    /// <li>
    /// <p>FLAC</p></li>
    /// <li>
    /// <p>OPUS-encoded audio in an Ogg container</p></li>
    /// <li>
    /// <p>PCM (only signed 16-bit little-endian audio formats, which does not include WAV)</p></li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.</p>
    pub fn set_media_encoding(mut self, input: ::std::option::Option<crate::types::MedicalScribeMediaEncoding>) -> Self {
        self.media_encoding = input;
        self
    }
    /// <p>Specify the encoding used for the input audio.</p>
    /// <p>Supported formats are:</p>
    /// <ul>
    /// <li>
    /// <p>FLAC</p></li>
    /// <li>
    /// <p>OPUS-encoded audio in an Ogg container</p></li>
    /// <li>
    /// <p>PCM (only signed 16-bit little-endian audio formats, which does not include WAV)</p></li>
    /// </ul>
    /// <p>For more information, see <a href="https://docs.aws.amazon.com/transcribe/latest/dg/how-input.html#how-input-audio">Media formats</a>.</p>
    pub fn get_media_encoding(&self) -> &::std::option::Option<crate::types::MedicalScribeMediaEncoding> {
        &self.media_encoding
    }
    /// <p>Specify the input stream where you will send events in real time.</p>
    /// <p>The first element of the input stream must be a <code>MedicalScribeConfigurationEvent</code>.</p>
    /// This field is required.
    pub fn input_stream(
        mut self,
        input: ::aws_smithy_http::event_stream::EventStreamSender<
            crate::types::MedicalScribeInputStream,
            crate::types::error::MedicalScribeInputStreamError,
        >,
    ) -> Self {
        self.input_stream = ::std::option::Option::Some(input);
        self
    }
    /// <p>Specify the input stream where you will send events in real time.</p>
    /// <p>The first element of the input stream must be a <code>MedicalScribeConfigurationEvent</code>.</p>
    pub fn set_input_stream(
        mut self,
        input: ::std::option::Option<
            ::aws_smithy_http::event_stream::EventStreamSender<
                crate::types::MedicalScribeInputStream,
                crate::types::error::MedicalScribeInputStreamError,
            >,
        >,
    ) -> Self {
        self.input_stream = input;
        self
    }
    /// <p>Specify the input stream where you will send events in real time.</p>
    /// <p>The first element of the input stream must be a <code>MedicalScribeConfigurationEvent</code>.</p>
    pub fn get_input_stream(
        &self,
    ) -> &::std::option::Option<
        ::aws_smithy_http::event_stream::EventStreamSender<
            crate::types::MedicalScribeInputStream,
            crate::types::error::MedicalScribeInputStreamError,
        >,
    > {
        &self.input_stream
    }
    /// Consumes the builder and constructs a [`StartMedicalScribeStreamInput`](crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamInput).
    /// This method will fail if any of the following fields are not set:
    /// - [`input_stream`](crate::operation::start_medical_scribe_stream::builders::StartMedicalScribeStreamInputBuilder::input_stream)
    pub fn build(
        self,
    ) -> ::std::result::Result<
        crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamInput,
        ::aws_smithy_types::error::operation::BuildError,
    > {
        ::std::result::Result::Ok(crate::operation::start_medical_scribe_stream::StartMedicalScribeStreamInput {
            session_id: self.session_id,
            language_code: self.language_code,
            media_sample_rate_hertz: self.media_sample_rate_hertz,
            media_encoding: self.media_encoding,
            input_stream: self.input_stream.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "input_stream",
                    "input_stream was not specified but it is required when building StartMedicalScribeStreamInput",
                )
            })?,
        })
    }
}
