// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
/// Orchestration and serialization glue logic for `StartSpeechSynthesisTask`.
#[derive(::std::clone::Clone, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct StartSpeechSynthesisTask;
impl StartSpeechSynthesisTask {
    /// Creates a new `StartSpeechSynthesisTask`
    pub fn new() -> Self {
        Self
    }
    pub(crate) async fn orchestrate(
        runtime_plugins: &::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
        input: crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskInput,
    ) -> ::std::result::Result<
        crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskOutput,
        ::aws_smithy_runtime_api::client::result::SdkError<
            crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskError,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let map_err = |err: ::aws_smithy_runtime_api::client::result::SdkError<
            ::aws_smithy_runtime_api::client::interceptors::context::Error,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >| {
            err.map_service_error(|err| {
                err.downcast::<crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskError>()
                    .expect("correct error type")
            })
        };
        let context = Self::orchestrate_with_stop_point(runtime_plugins, input, ::aws_smithy_runtime::client::orchestrator::StopPoint::None)
            .await
            .map_err(map_err)?;
        let output = context.finalize().map_err(map_err)?;
        ::std::result::Result::Ok(
            output
                .downcast::<crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskOutput>()
                .expect("correct output type"),
        )
    }

    pub(crate) async fn orchestrate_with_stop_point(
        runtime_plugins: &::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
        input: crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskInput,
        stop_point: ::aws_smithy_runtime::client::orchestrator::StopPoint,
    ) -> ::std::result::Result<
        ::aws_smithy_runtime_api::client::interceptors::context::InterceptorContext,
        ::aws_smithy_runtime_api::client::result::SdkError<
            ::aws_smithy_runtime_api::client::interceptors::context::Error,
            ::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
        >,
    > {
        let input = ::aws_smithy_runtime_api::client::interceptors::context::Input::erase(input);
        ::aws_smithy_runtime::client::orchestrator::invoke_with_stop_point("polly", "StartSpeechSynthesisTask", input, runtime_plugins, stop_point)
            .await
    }

    pub(crate) fn operation_runtime_plugins(
        client_runtime_plugins: ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins,
        client_config: &crate::config::Config,
        config_override: ::std::option::Option<crate::config::Builder>,
    ) -> ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugins {
        let mut runtime_plugins = client_runtime_plugins.with_operation_plugin(Self::new());
        runtime_plugins = runtime_plugins.with_client_plugin(crate::auth_plugin::DefaultAuthOptionsPlugin::new(vec![
            ::aws_runtime::auth::sigv4::SCHEME_ID,
        ]));
        if let ::std::option::Option::Some(config_override) = config_override {
            for plugin in config_override.runtime_plugins.iter().cloned() {
                runtime_plugins = runtime_plugins.with_operation_plugin(plugin);
            }
            runtime_plugins = runtime_plugins.with_operation_plugin(crate::config::ConfigOverrideRuntimePlugin::new(
                config_override,
                client_config.config.clone(),
                &client_config.runtime_components,
            ));
        }
        runtime_plugins
    }
}
impl ::aws_smithy_runtime_api::client::runtime_plugin::RuntimePlugin for StartSpeechSynthesisTask {
    fn config(&self) -> ::std::option::Option<::aws_smithy_types::config_bag::FrozenLayer> {
        let mut cfg = ::aws_smithy_types::config_bag::Layer::new("StartSpeechSynthesisTask");

        cfg.store_put(::aws_smithy_runtime_api::client::ser_de::SharedRequestSerializer::new(
            StartSpeechSynthesisTaskRequestSerializer,
        ));
        cfg.store_put(::aws_smithy_runtime_api::client::ser_de::SharedResponseDeserializer::new(
            StartSpeechSynthesisTaskResponseDeserializer,
        ));

        cfg.store_put(::aws_smithy_runtime_api::client::auth::AuthSchemeOptionResolverParams::new(
            ::aws_smithy_runtime_api::client::auth::static_resolver::StaticAuthSchemeOptionResolverParams::new(),
        ));

        cfg.store_put(::aws_smithy_runtime_api::client::orchestrator::Metadata::new(
            "StartSpeechSynthesisTask",
            "polly",
        ));
        let mut signing_options = ::aws_runtime::auth::SigningOptions::default();
        signing_options.double_uri_encode = true;
        signing_options.content_sha256_header = false;
        signing_options.normalize_uri_path = true;
        signing_options.payload_override = None;

        cfg.store_put(::aws_runtime::auth::SigV4OperationSigningConfig {
            signing_options,
            ..::std::default::Default::default()
        });

        ::std::option::Option::Some(cfg.freeze())
    }

    fn runtime_components(
        &self,
        _: &::aws_smithy_runtime_api::client::runtime_components::RuntimeComponentsBuilder,
    ) -> ::std::borrow::Cow<'_, ::aws_smithy_runtime_api::client::runtime_components::RuntimeComponentsBuilder> {
        #[allow(unused_mut)]
        let mut rcb = ::aws_smithy_runtime_api::client::runtime_components::RuntimeComponentsBuilder::new("StartSpeechSynthesisTask")
            .with_interceptor(::aws_smithy_runtime::client::stalled_stream_protection::StalledStreamProtectionInterceptor::default())
            .with_interceptor(StartSpeechSynthesisTaskEndpointParamsInterceptor)
            .with_retry_classifier(::aws_smithy_runtime::client::retries::classifiers::TransientErrorClassifier::<
                crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskError,
            >::new())
            .with_retry_classifier(::aws_smithy_runtime::client::retries::classifiers::ModeledAsRetryableClassifier::<
                crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskError,
            >::new())
            .with_retry_classifier(::aws_runtime::retries::classifiers::AwsErrorCodeClassifier::<
                crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskError,
            >::new());

        ::std::borrow::Cow::Owned(rcb)
    }
}

#[derive(Debug)]
struct StartSpeechSynthesisTaskResponseDeserializer;
impl ::aws_smithy_runtime_api::client::ser_de::DeserializeResponse for StartSpeechSynthesisTaskResponseDeserializer {
    fn deserialize_nonstreaming(
        &self,
        response: &::aws_smithy_runtime_api::client::orchestrator::HttpResponse,
    ) -> ::aws_smithy_runtime_api::client::interceptors::context::OutputOrError {
        let (success, status) = (response.status().is_success(), response.status().as_u16());
        let headers = response.headers();
        let body = response.body().bytes().expect("body loaded");
        #[allow(unused_mut)]
        let mut force_error = false;
        ::tracing::debug!(request_id = ?::aws_types::request_id::RequestId::request_id(response));
        let parse_result = if !success && status != 200 || force_error {
            crate::protocol_serde::shape_start_speech_synthesis_task::de_start_speech_synthesis_task_http_error(status, headers, body)
        } else {
            crate::protocol_serde::shape_start_speech_synthesis_task::de_start_speech_synthesis_task_http_response(status, headers, body)
        };
        crate::protocol_serde::type_erase_result(parse_result)
    }
}
#[derive(Debug)]
struct StartSpeechSynthesisTaskRequestSerializer;
impl ::aws_smithy_runtime_api::client::ser_de::SerializeRequest for StartSpeechSynthesisTaskRequestSerializer {
    #[allow(unused_mut, clippy::let_and_return, clippy::needless_borrow, clippy::useless_conversion)]
    fn serialize_input(
        &self,
        input: ::aws_smithy_runtime_api::client::interceptors::context::Input,
        _cfg: &mut ::aws_smithy_types::config_bag::ConfigBag,
    ) -> ::std::result::Result<::aws_smithy_runtime_api::client::orchestrator::HttpRequest, ::aws_smithy_runtime_api::box_error::BoxError> {
        let input = input
            .downcast::<crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskInput>()
            .expect("correct type");
        let _header_serialization_settings = _cfg
            .load::<crate::serialization_settings::HeaderSerializationSettings>()
            .cloned()
            .unwrap_or_default();
        let mut request_builder = {
            fn uri_base(
                _input: &crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskInput,
                output: &mut ::std::string::String,
            ) -> ::std::result::Result<(), ::aws_smithy_types::error::operation::BuildError> {
                use ::std::fmt::Write as _;
                ::std::write!(output, "/v1/synthesisTasks").expect("formatting should succeed");
                ::std::result::Result::Ok(())
            }
            #[allow(clippy::unnecessary_wraps)]
            fn update_http_builder(
                input: &crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskInput,
                builder: ::http::request::Builder,
            ) -> ::std::result::Result<::http::request::Builder, ::aws_smithy_types::error::operation::BuildError> {
                let mut uri = ::std::string::String::new();
                uri_base(input, &mut uri)?;
                ::std::result::Result::Ok(builder.method("POST").uri(uri))
            }
            let mut builder = update_http_builder(&input, ::http::request::Builder::new())?;
            builder = _header_serialization_settings.set_default_header(builder, ::http::header::CONTENT_TYPE, "application/json");
            builder
        };
        let body = ::aws_smithy_types::body::SdkBody::from(
            crate::protocol_serde::shape_start_speech_synthesis_task::ser_start_speech_synthesis_task_input(&input)?,
        );
        if let Some(content_length) = body.content_length() {
            let content_length = content_length.to_string();
            request_builder = _header_serialization_settings.set_default_header(request_builder, ::http::header::CONTENT_LENGTH, &content_length);
        }
        ::std::result::Result::Ok(request_builder.body(body).expect("valid request").try_into().unwrap())
    }
}
#[derive(Debug)]
struct StartSpeechSynthesisTaskEndpointParamsInterceptor;

impl ::aws_smithy_runtime_api::client::interceptors::Intercept for StartSpeechSynthesisTaskEndpointParamsInterceptor {
    fn name(&self) -> &'static str {
        "StartSpeechSynthesisTaskEndpointParamsInterceptor"
    }

    fn read_before_execution(
        &self,
        context: &::aws_smithy_runtime_api::client::interceptors::context::BeforeSerializationInterceptorContextRef<
            '_,
            ::aws_smithy_runtime_api::client::interceptors::context::Input,
            ::aws_smithy_runtime_api::client::interceptors::context::Output,
            ::aws_smithy_runtime_api::client::interceptors::context::Error,
        >,
        cfg: &mut ::aws_smithy_types::config_bag::ConfigBag,
    ) -> ::std::result::Result<(), ::aws_smithy_runtime_api::box_error::BoxError> {
        let _input = context
            .input()
            .downcast_ref::<StartSpeechSynthesisTaskInput>()
            .ok_or("failed to downcast to StartSpeechSynthesisTaskInput")?;

        let params = crate::config::endpoint::Params::builder()
            .set_region(cfg.load::<::aws_types::region::Region>().map(|r| r.as_ref().to_owned()))
            .set_use_dual_stack(cfg.load::<::aws_types::endpoint_config::UseDualStack>().map(|ty| ty.0))
            .set_use_fips(cfg.load::<::aws_types::endpoint_config::UseFips>().map(|ty| ty.0))
            .set_endpoint(cfg.load::<::aws_types::endpoint_config::EndpointUrl>().map(|ty| ty.0.clone()))
            .build()
            .map_err(|err| {
                ::aws_smithy_runtime_api::client::interceptors::error::ContextAttachedError::new("endpoint params could not be built", err)
            })?;
        cfg.interceptor_state()
            .store_put(::aws_smithy_runtime_api::client::endpoint::EndpointResolverParams::new(params));
        ::std::result::Result::Ok(())
    }
}

// The get_* functions below are generated from JMESPath expressions in the
// operationContextParams trait. They target the operation's input shape.

/// Error type for the `StartSpeechSynthesisTaskError` operation.
#[non_exhaustive]
#[derive(::std::fmt::Debug)]
pub enum StartSpeechSynthesisTaskError {
    /// <p>This engine is not compatible with the voice that you have designated. Choose a new voice that is compatible with the engine or change the engine and restart the operation.</p>
    EngineNotSupportedException(crate::types::error::EngineNotSupportedException),
    /// <p>The provided Amazon S3 bucket name is invalid. Please check your input with S3 bucket naming requirements and try again.</p>
    InvalidS3BucketException(crate::types::error::InvalidS3BucketException),
    /// <p>The provided Amazon S3 key prefix is invalid. Please provide a valid S3 object key name.</p>
    InvalidS3KeyException(crate::types::error::InvalidS3KeyException),
    /// <p>The specified sample rate is not valid.</p>
    InvalidSampleRateException(crate::types::error::InvalidSampleRateException),
    /// <p>The provided SNS topic ARN is invalid. Please provide a valid SNS topic ARN and try again.</p>
    InvalidSnsTopicArnException(crate::types::error::InvalidSnsTopicArnException),
    /// <p>The SSML you provided is invalid. Verify the SSML syntax, spelling of tags and values, and then try again.</p>
    InvalidSsmlException(crate::types::error::InvalidSsmlException),
    /// <p>The language specified is not currently supported by Amazon Polly in this capacity.</p>
    LanguageNotSupportedException(crate::types::error::LanguageNotSupportedException),
    /// <p>Amazon Polly can't find the specified lexicon. This could be caused by a lexicon that is missing, its name is misspelled or specifying a lexicon that is in a different region.</p>
    /// <p>Verify that the lexicon exists, is in the region (see <code>ListLexicons</code>) and that you spelled its name is spelled correctly. Then try again.</p>
    LexiconNotFoundException(crate::types::error::LexiconNotFoundException),
    /// <p>Speech marks are not supported for the <code>OutputFormat</code> selected. Speech marks are only available for content in <code>json</code> format.</p>
    MarksNotSupportedForFormatException(crate::types::error::MarksNotSupportedForFormatException),
    /// <p>An unknown condition has caused a service failure.</p>
    ServiceFailureException(crate::types::error::ServiceFailureException),
    /// <p>SSML speech marks are not supported for plain text-type input.</p>
    SsmlMarksNotSupportedForTextTypeException(crate::types::error::SsmlMarksNotSupportedForTextTypeException),
    /// <p>The value of the "Text" parameter is longer than the accepted limits. For the <code>SynthesizeSpeech</code> API, the limit for input text is a maximum of 6000 characters total, of which no more than 3000 can be billed characters. For the <code>StartSpeechSynthesisTask</code> API, the maximum is 200,000 characters, of which no more than 100,000 can be billed characters. SSML tags are not counted as billed characters.</p>
    TextLengthExceededException(crate::types::error::TextLengthExceededException),
    /// An unexpected error occurred (e.g., invalid JSON returned by the service or an unknown error code).
    #[deprecated(note = "Matching `Unhandled` directly is not forwards compatible. Instead, match using a \
    variable wildcard pattern and check `.code()`:
     \
    &nbsp;&nbsp;&nbsp;`err if err.code() == Some(\"SpecificExceptionCode\") => { /* handle the error */ }`
     \
    See [`ProvideErrorMetadata`](#impl-ProvideErrorMetadata-for-StartSpeechSynthesisTaskError) for what information is available for the error.")]
    Unhandled(crate::error::sealed_unhandled::Unhandled),
}
impl StartSpeechSynthesisTaskError {
    /// Creates the `StartSpeechSynthesisTaskError::Unhandled` variant from any error type.
    pub fn unhandled(
        err: impl ::std::convert::Into<::std::boxed::Box<dyn ::std::error::Error + ::std::marker::Send + ::std::marker::Sync + 'static>>,
    ) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: err.into(),
            meta: ::std::default::Default::default(),
        })
    }

    /// Creates the `StartSpeechSynthesisTaskError::Unhandled` variant from an [`ErrorMetadata`](::aws_smithy_types::error::ErrorMetadata).
    pub fn generic(err: ::aws_smithy_types::error::ErrorMetadata) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source: err.clone().into(),
            meta: err,
        })
    }
    ///
    /// Returns error metadata, which includes the error code, message,
    /// request ID, and potentially additional information.
    ///
    pub fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        match self {
            Self::EngineNotSupportedException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::InvalidS3BucketException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::InvalidS3KeyException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::InvalidSampleRateException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::InvalidSnsTopicArnException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::InvalidSsmlException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::LanguageNotSupportedException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::LexiconNotFoundException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::MarksNotSupportedForFormatException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::ServiceFailureException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::SsmlMarksNotSupportedForTextTypeException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::TextLengthExceededException(e) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(e),
            Self::Unhandled(e) => &e.meta,
        }
    }
    /// Returns `true` if the error kind is `StartSpeechSynthesisTaskError::EngineNotSupportedException`.
    pub fn is_engine_not_supported_exception(&self) -> bool {
        matches!(self, Self::EngineNotSupportedException(_))
    }
    /// Returns `true` if the error kind is `StartSpeechSynthesisTaskError::InvalidS3BucketException`.
    pub fn is_invalid_s3_bucket_exception(&self) -> bool {
        matches!(self, Self::InvalidS3BucketException(_))
    }
    /// Returns `true` if the error kind is `StartSpeechSynthesisTaskError::InvalidS3KeyException`.
    pub fn is_invalid_s3_key_exception(&self) -> bool {
        matches!(self, Self::InvalidS3KeyException(_))
    }
    /// Returns `true` if the error kind is `StartSpeechSynthesisTaskError::InvalidSampleRateException`.
    pub fn is_invalid_sample_rate_exception(&self) -> bool {
        matches!(self, Self::InvalidSampleRateException(_))
    }
    /// Returns `true` if the error kind is `StartSpeechSynthesisTaskError::InvalidSnsTopicArnException`.
    pub fn is_invalid_sns_topic_arn_exception(&self) -> bool {
        matches!(self, Self::InvalidSnsTopicArnException(_))
    }
    /// Returns `true` if the error kind is `StartSpeechSynthesisTaskError::InvalidSsmlException`.
    pub fn is_invalid_ssml_exception(&self) -> bool {
        matches!(self, Self::InvalidSsmlException(_))
    }
    /// Returns `true` if the error kind is `StartSpeechSynthesisTaskError::LanguageNotSupportedException`.
    pub fn is_language_not_supported_exception(&self) -> bool {
        matches!(self, Self::LanguageNotSupportedException(_))
    }
    /// Returns `true` if the error kind is `StartSpeechSynthesisTaskError::LexiconNotFoundException`.
    pub fn is_lexicon_not_found_exception(&self) -> bool {
        matches!(self, Self::LexiconNotFoundException(_))
    }
    /// Returns `true` if the error kind is `StartSpeechSynthesisTaskError::MarksNotSupportedForFormatException`.
    pub fn is_marks_not_supported_for_format_exception(&self) -> bool {
        matches!(self, Self::MarksNotSupportedForFormatException(_))
    }
    /// Returns `true` if the error kind is `StartSpeechSynthesisTaskError::ServiceFailureException`.
    pub fn is_service_failure_exception(&self) -> bool {
        matches!(self, Self::ServiceFailureException(_))
    }
    /// Returns `true` if the error kind is `StartSpeechSynthesisTaskError::SsmlMarksNotSupportedForTextTypeException`.
    pub fn is_ssml_marks_not_supported_for_text_type_exception(&self) -> bool {
        matches!(self, Self::SsmlMarksNotSupportedForTextTypeException(_))
    }
    /// Returns `true` if the error kind is `StartSpeechSynthesisTaskError::TextLengthExceededException`.
    pub fn is_text_length_exceeded_exception(&self) -> bool {
        matches!(self, Self::TextLengthExceededException(_))
    }
}
impl ::std::error::Error for StartSpeechSynthesisTaskError {
    fn source(&self) -> ::std::option::Option<&(dyn ::std::error::Error + 'static)> {
        match self {
            Self::EngineNotSupportedException(_inner) => ::std::option::Option::Some(_inner),
            Self::InvalidS3BucketException(_inner) => ::std::option::Option::Some(_inner),
            Self::InvalidS3KeyException(_inner) => ::std::option::Option::Some(_inner),
            Self::InvalidSampleRateException(_inner) => ::std::option::Option::Some(_inner),
            Self::InvalidSnsTopicArnException(_inner) => ::std::option::Option::Some(_inner),
            Self::InvalidSsmlException(_inner) => ::std::option::Option::Some(_inner),
            Self::LanguageNotSupportedException(_inner) => ::std::option::Option::Some(_inner),
            Self::LexiconNotFoundException(_inner) => ::std::option::Option::Some(_inner),
            Self::MarksNotSupportedForFormatException(_inner) => ::std::option::Option::Some(_inner),
            Self::ServiceFailureException(_inner) => ::std::option::Option::Some(_inner),
            Self::SsmlMarksNotSupportedForTextTypeException(_inner) => ::std::option::Option::Some(_inner),
            Self::TextLengthExceededException(_inner) => ::std::option::Option::Some(_inner),
            Self::Unhandled(_inner) => ::std::option::Option::Some(&*_inner.source),
        }
    }
}
impl ::std::fmt::Display for StartSpeechSynthesisTaskError {
    fn fmt(&self, f: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        match self {
            Self::EngineNotSupportedException(_inner) => _inner.fmt(f),
            Self::InvalidS3BucketException(_inner) => _inner.fmt(f),
            Self::InvalidS3KeyException(_inner) => _inner.fmt(f),
            Self::InvalidSampleRateException(_inner) => _inner.fmt(f),
            Self::InvalidSnsTopicArnException(_inner) => _inner.fmt(f),
            Self::InvalidSsmlException(_inner) => _inner.fmt(f),
            Self::LanguageNotSupportedException(_inner) => _inner.fmt(f),
            Self::LexiconNotFoundException(_inner) => _inner.fmt(f),
            Self::MarksNotSupportedForFormatException(_inner) => _inner.fmt(f),
            Self::ServiceFailureException(_inner) => _inner.fmt(f),
            Self::SsmlMarksNotSupportedForTextTypeException(_inner) => _inner.fmt(f),
            Self::TextLengthExceededException(_inner) => _inner.fmt(f),
            Self::Unhandled(_inner) => {
                if let ::std::option::Option::Some(code) = ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self) {
                    write!(f, "unhandled error ({code})")
                } else {
                    f.write_str("unhandled error")
                }
            }
        }
    }
}
impl ::aws_smithy_types::retry::ProvideErrorKind for StartSpeechSynthesisTaskError {
    fn code(&self) -> ::std::option::Option<&str> {
        ::aws_smithy_types::error::metadata::ProvideErrorMetadata::code(self)
    }
    fn retryable_error_kind(&self) -> ::std::option::Option<::aws_smithy_types::retry::ErrorKind> {
        ::std::option::Option::None
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for StartSpeechSynthesisTaskError {
    fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        match self {
            Self::EngineNotSupportedException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::InvalidS3BucketException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::InvalidS3KeyException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::InvalidSampleRateException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::InvalidSnsTopicArnException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::InvalidSsmlException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::LanguageNotSupportedException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::LexiconNotFoundException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::MarksNotSupportedForFormatException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::ServiceFailureException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::SsmlMarksNotSupportedForTextTypeException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::TextLengthExceededException(_inner) => ::aws_smithy_types::error::metadata::ProvideErrorMetadata::meta(_inner),
            Self::Unhandled(_inner) => &_inner.meta,
        }
    }
}
impl ::aws_smithy_runtime_api::client::result::CreateUnhandledError for StartSpeechSynthesisTaskError {
    fn create_unhandled_error(
        source: ::std::boxed::Box<dyn ::std::error::Error + ::std::marker::Send + ::std::marker::Sync + 'static>,
        meta: ::std::option::Option<::aws_smithy_types::error::ErrorMetadata>,
    ) -> Self {
        Self::Unhandled(crate::error::sealed_unhandled::Unhandled {
            source,
            meta: meta.unwrap_or_default(),
        })
    }
}
impl ::aws_types::request_id::RequestId for crate::operation::start_speech_synthesis_task::StartSpeechSynthesisTaskError {
    fn request_id(&self) -> Option<&str> {
        self.meta().request_id()
    }
}

pub use crate::operation::start_speech_synthesis_task::_start_speech_synthesis_task_output::StartSpeechSynthesisTaskOutput;

pub use crate::operation::start_speech_synthesis_task::_start_speech_synthesis_task_input::StartSpeechSynthesisTaskInput;

mod _start_speech_synthesis_task_input;

mod _start_speech_synthesis_task_output;

/// Builders
pub mod builders;
