//
//Copyright 2024 Google LLC
//
//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//https://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.33.0
// 	protoc        v4.23.4
// source: sharedprotos/datawarehouse/datawarehouse.proto

package datawarehouse

import (
	status "github.com/GoogleCloudPlatform/workloadagentplatform/sharedprotos/status"
	system "github.com/GoogleCloudPlatform/workloadagentplatform/sharedprotos/system"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The different SAP validation types.
type SapValidation_SapValidationType int32

const (
	// Unspecified type.
	SapValidation_SAP_VALIDATION_TYPE_UNSPECIFIED SapValidation_SapValidationType = 0
	// The SYSTEM validation type collects underlying system data from the VM.
	SapValidation_SYSTEM SapValidation_SapValidationType = 1
	// The COROSYNC validation type collects Corosync configuration and runtime
	// data. Corosync enables servers to interact as a HA cluster.
	SapValidation_COROSYNC SapValidation_SapValidationType = 2
	// The PACEMAKER validation type collects Pacemaker configuration data.
	// Pacemaker is a high-availability cluster resource manager.
	SapValidation_PACEMAKER SapValidation_SapValidationType = 3
	// The HANA validation type collects HANA configuration data. SAP HANA is an
	// in-memory, column-oriented, relational database management system.
	SapValidation_HANA SapValidation_SapValidationType = 4
	// The NETWEAVER validation type collects NetWeaver configuration data. SAP
	// NetWeaver is a software stack for many of SAP SE's applications.
	SapValidation_NETWEAVER SapValidation_SapValidationType = 5
	// The HANA_SECURITY validation type collects HANA configuration data as it
	// relates to SAP security best practices.
	SapValidation_HANA_SECURITY SapValidation_SapValidationType = 6
	// The CUSTOM validation type collects any customer-defined data that does
	// not fall into any of the other categories of validations.
	SapValidation_CUSTOM SapValidation_SapValidationType = 7
)

// Enum value maps for SapValidation_SapValidationType.
var (
	SapValidation_SapValidationType_name = map[int32]string{
		0: "SAP_VALIDATION_TYPE_UNSPECIFIED",
		1: "SYSTEM",
		2: "COROSYNC",
		3: "PACEMAKER",
		4: "HANA",
		5: "NETWEAVER",
		6: "HANA_SECURITY",
		7: "CUSTOM",
	}
	SapValidation_SapValidationType_value = map[string]int32{
		"SAP_VALIDATION_TYPE_UNSPECIFIED": 0,
		"SYSTEM":                          1,
		"COROSYNC":                        2,
		"PACEMAKER":                       3,
		"HANA":                            4,
		"NETWEAVER":                       5,
		"HANA_SECURITY":                   6,
		"CUSTOM":                          7,
	}
)

func (x SapValidation_SapValidationType) Enum() *SapValidation_SapValidationType {
	p := new(SapValidation_SapValidationType)
	*p = x
	return p
}

func (x SapValidation_SapValidationType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SapValidation_SapValidationType) Descriptor() protoreflect.EnumDescriptor {
	return file_sharedprotos_datawarehouse_datawarehouse_proto_enumTypes[0].Descriptor()
}

func (SapValidation_SapValidationType) Type() protoreflect.EnumType {
	return &file_sharedprotos_datawarehouse_datawarehouse_proto_enumTypes[0]
}

func (x SapValidation_SapValidationType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SapValidation_SapValidationType.Descriptor instead.
func (SapValidation_SapValidationType) EnumDescriptor() ([]byte, []int) {
	return file_sharedprotos_datawarehouse_datawarehouse_proto_rawDescGZIP(), []int{2, 0}
}

// WorkloadType enumerates the types of supported torso workloads.
type TorsoValidation_WorkloadType int32

const (
	TorsoValidation_WORKLOAD_TYPE_UNSPECIFIED TorsoValidation_WorkloadType = 0
	TorsoValidation_MYSQL                     TorsoValidation_WorkloadType = 1
	TorsoValidation_ORACLE                    TorsoValidation_WorkloadType = 2
	TorsoValidation_REDIS                     TorsoValidation_WorkloadType = 3
)

// Enum value maps for TorsoValidation_WorkloadType.
var (
	TorsoValidation_WorkloadType_name = map[int32]string{
		0: "WORKLOAD_TYPE_UNSPECIFIED",
		1: "MYSQL",
		2: "ORACLE",
		3: "REDIS",
	}
	TorsoValidation_WorkloadType_value = map[string]int32{
		"WORKLOAD_TYPE_UNSPECIFIED": 0,
		"MYSQL":                     1,
		"ORACLE":                    2,
		"REDIS":                     3,
	}
)

func (x TorsoValidation_WorkloadType) Enum() *TorsoValidation_WorkloadType {
	p := new(TorsoValidation_WorkloadType)
	*p = x
	return p
}

func (x TorsoValidation_WorkloadType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TorsoValidation_WorkloadType) Descriptor() protoreflect.EnumDescriptor {
	return file_sharedprotos_datawarehouse_datawarehouse_proto_enumTypes[1].Descriptor()
}

func (TorsoValidation_WorkloadType) Type() protoreflect.EnumType {
	return &file_sharedprotos_datawarehouse_datawarehouse_proto_enumTypes[1]
}

func (x TorsoValidation_WorkloadType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TorsoValidation_WorkloadType.Descriptor instead.
func (TorsoValidation_WorkloadType) EnumDescriptor() ([]byte, []int) {
	return file_sharedprotos_datawarehouse_datawarehouse_proto_rawDescGZIP(), []int{3, 0}
}

// Request for sending the data insights.
type WriteInsightRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The GCP location.
	// The format is: projects/{project}/locations/{location}.
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The metrics data details.
	Insight *Insight `protobuf:"bytes,2,opt,name=insight,proto3" json:"insight,omitempty"`
	// An optional request ID to identify requests.
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// The agent version collected this data point.
	AgentVersion string `protobuf:"bytes,5,opt,name=agent_version,json=agentVersion,proto3" json:"agent_version,omitempty"`
}

func (x *WriteInsightRequest) Reset() {
	*x = WriteInsightRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *WriteInsightRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*WriteInsightRequest) ProtoMessage() {}

func (x *WriteInsightRequest) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use WriteInsightRequest.ProtoReflect.Descriptor instead.
func (*WriteInsightRequest) Descriptor() ([]byte, []int) {
	return file_sharedprotos_datawarehouse_datawarehouse_proto_rawDescGZIP(), []int{0}
}

func (x *WriteInsightRequest) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *WriteInsightRequest) GetInsight() *Insight {
	if x != nil {
		return x.Insight
	}
	return nil
}

func (x *WriteInsightRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *WriteInsightRequest) GetAgentVersion() string {
	if x != nil {
		return x.AgentVersion
	}
	return ""
}

// A presentation of host resource usage where the workload runs.
type Insight struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// [Output only] Create time stamp
	SentTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=sent_time,json=sentTime,proto3" json:"sent_time,omitempty"`
	// The insights data for the SAP workload validation.
	SapValidation *SapValidation `protobuf:"bytes,2,opt,name=sap_validation,json=sapValidation,proto3" json:"sap_validation,omitempty"`
	// The insights data for SAP system discovery. This is a copy of SAP System
	// proto and should get updated whenever that one changes.
	SapDiscovery        *system.SapDiscovery `protobuf:"bytes,3,opt,name=sap_discovery,json=sapDiscovery,proto3" json:"sap_discovery,omitempty"`
	SqlserverValidation string               `protobuf:"bytes,4,opt,name=sqlserver_validation,json=sqlserverValidation,proto3" json:"sqlserver_validation,omitempty"`
	// The instance id where the insight is generated from
	InstanceId string `protobuf:"bytes,5,opt,name=instance_id,json=instanceId,proto3" json:"instance_id,omitempty"`
	// The insights data for workload validation of torso workloads.
	TorsoValidation *TorsoValidation `protobuf:"bytes,6,opt,name=torso_validation,json=torsoValidation,proto3" json:"torso_validation,omitempty"`
	// The status of the agent and services (process metrics, host metrics, etc).
	AgentStatus *status.AgentStatus `protobuf:"bytes,7,opt,name=agent_status,json=agentStatus,proto3" json:"agent_status,omitempty"`
}

func (x *Insight) Reset() {
	*x = Insight{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Insight) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Insight) ProtoMessage() {}

func (x *Insight) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Insight.ProtoReflect.Descriptor instead.
func (*Insight) Descriptor() ([]byte, []int) {
	return file_sharedprotos_datawarehouse_datawarehouse_proto_rawDescGZIP(), []int{1}
}

func (x *Insight) GetSentTime() *timestamppb.Timestamp {
	if x != nil {
		return x.SentTime
	}
	return nil
}

func (x *Insight) GetSapValidation() *SapValidation {
	if x != nil {
		return x.SapValidation
	}
	return nil
}

func (x *Insight) GetSapDiscovery() *system.SapDiscovery {
	if x != nil {
		return x.SapDiscovery
	}
	return nil
}

func (x *Insight) GetSqlserverValidation() string {
	if x != nil {
		return x.SqlserverValidation
	}
	return ""
}

func (x *Insight) GetInstanceId() string {
	if x != nil {
		return x.InstanceId
	}
	return ""
}

func (x *Insight) GetTorsoValidation() *TorsoValidation {
	if x != nil {
		return x.TorsoValidation
	}
	return nil
}

func (x *Insight) GetAgentStatus() *status.AgentStatus {
	if x != nil {
		return x.AgentStatus
	}
	return nil
}

// A presentation of SAP workload insight.
// The schema of SAP workloads validation related data.
type SapValidation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A list of SAP validation metrics data.
	ValidationDetails []*SapValidation_ValidationDetail `protobuf:"bytes,1,rep,name=validation_details,json=validationDetails,proto3" json:"validation_details,omitempty"`
	// The project_id of the cloud project that the Insight data comes from.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The zone of the instance that the Insight data comes from.
	Zone string `protobuf:"bytes,3,opt,name=zone,proto3" json:"zone,omitempty"`
}

func (x *SapValidation) Reset() {
	*x = SapValidation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SapValidation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SapValidation) ProtoMessage() {}

func (x *SapValidation) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SapValidation.ProtoReflect.Descriptor instead.
func (*SapValidation) Descriptor() ([]byte, []int) {
	return file_sharedprotos_datawarehouse_datawarehouse_proto_rawDescGZIP(), []int{2}
}

func (x *SapValidation) GetValidationDetails() []*SapValidation_ValidationDetail {
	if x != nil {
		return x.ValidationDetails
	}
	return nil
}

func (x *SapValidation) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *SapValidation) GetZone() string {
	if x != nil {
		return x.Zone
	}
	return ""
}

// The schema of torso workload validation data.
type TorsoValidation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// workload_type specifies the type of torso workload.
	WorkloadType TorsoValidation_WorkloadType `protobuf:"varint,1,opt,name=workload_type,json=workloadType,proto3,enum=workloadagentplatform.sharedprotos.datawarehouse.TorsoValidation_WorkloadType" json:"workload_type,omitempty"`
	// validation_details contains the <k,v> pairs of validation data:
	// field name & field value.
	ValidationDetails map[string]string `protobuf:"bytes,2,rep,name=validation_details,json=validationDetails,proto3" json:"validation_details,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// agent_version lists the version of the agent that collected this data.
	AgentVersion string `protobuf:"bytes,3,opt,name=agent_version,json=agentVersion,proto3" json:"agent_version,omitempty"`
	// project_id lists the human readable cloud project that the data comes from.
	ProjectId string `protobuf:"bytes,4,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// instance_name lists the human readable name of the instance that the data
	// comes from.
	// (-- api-linter: core::0122::name-suffix=disabled
	//
	//	aip.dev/not-precedent: Disambiguation between instance_id and
	//	instance_name. --)
	InstanceName string `protobuf:"bytes,5,opt,name=instance_name,json=instanceName,proto3" json:"instance_name,omitempty"`
}

func (x *TorsoValidation) Reset() {
	*x = TorsoValidation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TorsoValidation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TorsoValidation) ProtoMessage() {}

func (x *TorsoValidation) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TorsoValidation.ProtoReflect.Descriptor instead.
func (*TorsoValidation) Descriptor() ([]byte, []int) {
	return file_sharedprotos_datawarehouse_datawarehouse_proto_rawDescGZIP(), []int{3}
}

func (x *TorsoValidation) GetWorkloadType() TorsoValidation_WorkloadType {
	if x != nil {
		return x.WorkloadType
	}
	return TorsoValidation_WORKLOAD_TYPE_UNSPECIFIED
}

func (x *TorsoValidation) GetValidationDetails() map[string]string {
	if x != nil {
		return x.ValidationDetails
	}
	return nil
}

func (x *TorsoValidation) GetAgentVersion() string {
	if x != nil {
		return x.AgentVersion
	}
	return ""
}

func (x *TorsoValidation) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *TorsoValidation) GetInstanceName() string {
	if x != nil {
		return x.InstanceName
	}
	return ""
}

// Message describing the SAP validation metrics.
type SapValidation_ValidationDetail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The SAP system that the validation data is from.
	SapValidationType SapValidation_SapValidationType `protobuf:"varint,1,opt,name=sap_validation_type,json=sapValidationType,proto3,enum=workloadagentplatform.sharedprotos.datawarehouse.SapValidation_SapValidationType" json:"sap_validation_type,omitempty"`
	// The <k,v> pairs of metrics data: field name & field value.
	Details map[string]string `protobuf:"bytes,2,rep,name=details,proto3" json:"details,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Was there a SAP system detected for this validation type.
	IsPresent bool `protobuf:"varint,3,opt,name=is_present,json=isPresent,proto3" json:"is_present,omitempty"`
}

func (x *SapValidation_ValidationDetail) Reset() {
	*x = SapValidation_ValidationDetail{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SapValidation_ValidationDetail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SapValidation_ValidationDetail) ProtoMessage() {}

func (x *SapValidation_ValidationDetail) ProtoReflect() protoreflect.Message {
	mi := &file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SapValidation_ValidationDetail.ProtoReflect.Descriptor instead.
func (*SapValidation_ValidationDetail) Descriptor() ([]byte, []int) {
	return file_sharedprotos_datawarehouse_datawarehouse_proto_rawDescGZIP(), []int{2, 0}
}

func (x *SapValidation_ValidationDetail) GetSapValidationType() SapValidation_SapValidationType {
	if x != nil {
		return x.SapValidationType
	}
	return SapValidation_SAP_VALIDATION_TYPE_UNSPECIFIED
}

func (x *SapValidation_ValidationDetail) GetDetails() map[string]string {
	if x != nil {
		return x.Details
	}
	return nil
}

func (x *SapValidation_ValidationDetail) GetIsPresent() bool {
	if x != nil {
		return x.IsPresent
	}
	return false
}

var File_sharedprotos_datawarehouse_datawarehouse_proto protoreflect.FileDescriptor

var file_sharedprotos_datawarehouse_datawarehouse_proto_rawDesc = []byte{
	0x0a, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f, 0x64, 0x61, 0x74,
	0x61, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x30, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75,
	0x73, 0x65, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2f, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2f, 0x73, 0x79, 0x73, 0x74, 0x65,
	0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xd0, 0x01, 0x0a, 0x13, 0x57, 0x72, 0x69, 0x74,
	0x65, 0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1a, 0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x53, 0x0a, 0x07, 0x69,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x49, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x52, 0x07, 0x69, 0x6e, 0x73, 0x69, 0x67, 0x68, 0x74,
	0x12, 0x1d, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12,
	0x23, 0x0a, 0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x56, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x4a, 0x04, 0x08, 0x04, 0x10, 0x05, 0x22, 0xa6, 0x04, 0x0a, 0x07, 0x49,
	0x6e, 0x73, 0x69, 0x67, 0x68, 0x74, 0x12, 0x37, 0x0a, 0x09, 0x73, 0x65, 0x6e, 0x74, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x73, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x66, 0x0a, 0x0e, 0x73, 0x61, 0x70, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x64, 0x61, 0x74,
	0x61, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x53, 0x61, 0x70, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0d, 0x73, 0x61, 0x70, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x0d, 0x73, 0x61, 0x70, 0x5f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38,
	0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x73, 0x2e, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x53, 0x61, 0x70, 0x44,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x52, 0x0c, 0x73, 0x61, 0x70, 0x44, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x12, 0x31, 0x0a, 0x14, 0x73, 0x71, 0x6c, 0x73, 0x65, 0x72,
	0x76, 0x65, 0x72, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x13, 0x73, 0x71, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x56,
	0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x49, 0x64, 0x12, 0x6c, 0x0a, 0x10, 0x74, 0x6f,
	0x72, 0x73, 0x6f, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x41, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61,
	0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x77, 0x61,
	0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x54, 0x6f, 0x72, 0x73, 0x6f, 0x56, 0x61, 0x6c,
	0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0f, 0x74, 0x6f, 0x72, 0x73, 0x6f, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x59, 0x0a, 0x0c, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36,
	0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x41, 0x67, 0x65, 0x6e, 0x74,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x0b, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x53, 0x74, 0x61,
	0x74, 0x75, 0x73, 0x22, 0xcc, 0x05, 0x0a, 0x0d, 0x53, 0x61, 0x70, 0x56, 0x61, 0x6c, 0x69, 0x64,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7f, 0x0a, 0x12, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x50, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x77, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x2e, 0x53, 0x61, 0x70, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74,
	0x61, 0x69, 0x6c, 0x52, 0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x7a, 0x6f, 0x6e, 0x65, 0x1a, 0xea, 0x02, 0x0a, 0x10, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x12, 0x81,
	0x01, 0x0a, 0x13, 0x73, 0x61, 0x70, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x51, 0x2e, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x53, 0x61, 0x70, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x61,
	0x70, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52,
	0x11, 0x73, 0x61, 0x70, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x77, 0x0a, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x5d, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72,
	0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x77, 0x61, 0x72,
	0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x53, 0x61, 0x70, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44,
	0x65, 0x74, 0x61, 0x69, 0x6c, 0x2e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x07, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x69,
	0x73, 0x5f, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x09, 0x69, 0x73, 0x50, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x1a, 0x3a, 0x0a, 0x0c, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x99, 0x01, 0x0a, 0x11, 0x53, 0x61, 0x70, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x23, 0x0a, 0x1f,
	0x53, 0x41, 0x50, 0x5f, 0x56, 0x41, 0x4c, 0x49, 0x44, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x59, 0x53, 0x54, 0x45, 0x4d, 0x10, 0x01, 0x12, 0x0c, 0x0a,
	0x08, 0x43, 0x4f, 0x52, 0x4f, 0x53, 0x59, 0x4e, 0x43, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x50,
	0x41, 0x43, 0x45, 0x4d, 0x41, 0x4b, 0x45, 0x52, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x41,
	0x4e, 0x41, 0x10, 0x04, 0x12, 0x0d, 0x0a, 0x09, 0x4e, 0x45, 0x54, 0x57, 0x45, 0x41, 0x56, 0x45,
	0x52, 0x10, 0x05, 0x12, 0x11, 0x0a, 0x0d, 0x48, 0x41, 0x4e, 0x41, 0x5f, 0x53, 0x45, 0x43, 0x55,
	0x52, 0x49, 0x54, 0x59, 0x10, 0x06, 0x12, 0x0a, 0x0a, 0x06, 0x43, 0x55, 0x53, 0x54, 0x4f, 0x4d,
	0x10, 0x07, 0x22, 0x90, 0x04, 0x0a, 0x0f, 0x54, 0x6f, 0x72, 0x73, 0x6f, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x73, 0x0a, 0x0d, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4e, 0x2e,
	0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x64, 0x61, 0x74, 0x61, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65,
	0x2e, 0x54, 0x6f, 0x72, 0x73, 0x6f, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x2e, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0c, 0x77,
	0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x87, 0x01, 0x0a, 0x12,
	0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69,
	0x6c, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x58, 0x2e, 0x77, 0x6f, 0x72, 0x6b, 0x6c,
	0x6f, 0x61, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x64, 0x61,
	0x74, 0x61, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x54, 0x6f, 0x72, 0x73,
	0x6f, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x56, 0x61, 0x6c, 0x69,
	0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x11, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65,
	0x74, 0x61, 0x69, 0x6c, 0x73, 0x12, 0x23, 0x0a, 0x0d, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x5f, 0x76,
	0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x23, 0x0a, 0x0d, 0x69, 0x6e, 0x73,
	0x74, 0x61, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x1a, 0x44,
	0x0a, 0x16, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x74, 0x61,
	0x69, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x4f, 0x0a, 0x0c, 0x57, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x1d, 0x0a, 0x19, 0x57, 0x4f, 0x52, 0x4b, 0x4c, 0x4f, 0x41, 0x44,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x4d, 0x59, 0x53, 0x51, 0x4c, 0x10, 0x01, 0x12, 0x0a,
	0x0a, 0x06, 0x4f, 0x52, 0x41, 0x43, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x52, 0x45,
	0x44, 0x49, 0x53, 0x10, 0x03, 0x42, 0x51, 0x5a, 0x4f, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x50,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x6c, 0x6f, 0x61, 0x64,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x73, 0x68,
	0x61, 0x72, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x77,
	0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_sharedprotos_datawarehouse_datawarehouse_proto_rawDescOnce sync.Once
	file_sharedprotos_datawarehouse_datawarehouse_proto_rawDescData = file_sharedprotos_datawarehouse_datawarehouse_proto_rawDesc
)

func file_sharedprotos_datawarehouse_datawarehouse_proto_rawDescGZIP() []byte {
	file_sharedprotos_datawarehouse_datawarehouse_proto_rawDescOnce.Do(func() {
		file_sharedprotos_datawarehouse_datawarehouse_proto_rawDescData = protoimpl.X.CompressGZIP(file_sharedprotos_datawarehouse_datawarehouse_proto_rawDescData)
	})
	return file_sharedprotos_datawarehouse_datawarehouse_proto_rawDescData
}

var file_sharedprotos_datawarehouse_datawarehouse_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_sharedprotos_datawarehouse_datawarehouse_proto_goTypes = []interface{}{
	(SapValidation_SapValidationType)(0),   // 0: workloadagentplatform.sharedprotos.datawarehouse.SapValidation.SapValidationType
	(TorsoValidation_WorkloadType)(0),      // 1: workloadagentplatform.sharedprotos.datawarehouse.TorsoValidation.WorkloadType
	(*WriteInsightRequest)(nil),            // 2: workloadagentplatform.sharedprotos.datawarehouse.WriteInsightRequest
	(*Insight)(nil),                        // 3: workloadagentplatform.sharedprotos.datawarehouse.Insight
	(*SapValidation)(nil),                  // 4: workloadagentplatform.sharedprotos.datawarehouse.SapValidation
	(*TorsoValidation)(nil),                // 5: workloadagentplatform.sharedprotos.datawarehouse.TorsoValidation
	(*SapValidation_ValidationDetail)(nil), // 6: workloadagentplatform.sharedprotos.datawarehouse.SapValidation.ValidationDetail
	nil,                                    // 7: workloadagentplatform.sharedprotos.datawarehouse.SapValidation.ValidationDetail.DetailsEntry
	nil,                                    // 8: workloadagentplatform.sharedprotos.datawarehouse.TorsoValidation.ValidationDetailsEntry
	(*timestamppb.Timestamp)(nil),          // 9: google.protobuf.Timestamp
	(*system.SapDiscovery)(nil),            // 10: workloadagentplatform.sharedprotoss.system.SapDiscovery
	(*status.AgentStatus)(nil),             // 11: workloadagentplatform.sharedprotos.status.AgentStatus
}
var file_sharedprotos_datawarehouse_datawarehouse_proto_depIdxs = []int32{
	3,  // 0: workloadagentplatform.sharedprotos.datawarehouse.WriteInsightRequest.insight:type_name -> workloadagentplatform.sharedprotos.datawarehouse.Insight
	9,  // 1: workloadagentplatform.sharedprotos.datawarehouse.Insight.sent_time:type_name -> google.protobuf.Timestamp
	4,  // 2: workloadagentplatform.sharedprotos.datawarehouse.Insight.sap_validation:type_name -> workloadagentplatform.sharedprotos.datawarehouse.SapValidation
	10, // 3: workloadagentplatform.sharedprotos.datawarehouse.Insight.sap_discovery:type_name -> workloadagentplatform.sharedprotoss.system.SapDiscovery
	5,  // 4: workloadagentplatform.sharedprotos.datawarehouse.Insight.torso_validation:type_name -> workloadagentplatform.sharedprotos.datawarehouse.TorsoValidation
	11, // 5: workloadagentplatform.sharedprotos.datawarehouse.Insight.agent_status:type_name -> workloadagentplatform.sharedprotos.status.AgentStatus
	6,  // 6: workloadagentplatform.sharedprotos.datawarehouse.SapValidation.validation_details:type_name -> workloadagentplatform.sharedprotos.datawarehouse.SapValidation.ValidationDetail
	1,  // 7: workloadagentplatform.sharedprotos.datawarehouse.TorsoValidation.workload_type:type_name -> workloadagentplatform.sharedprotos.datawarehouse.TorsoValidation.WorkloadType
	8,  // 8: workloadagentplatform.sharedprotos.datawarehouse.TorsoValidation.validation_details:type_name -> workloadagentplatform.sharedprotos.datawarehouse.TorsoValidation.ValidationDetailsEntry
	0,  // 9: workloadagentplatform.sharedprotos.datawarehouse.SapValidation.ValidationDetail.sap_validation_type:type_name -> workloadagentplatform.sharedprotos.datawarehouse.SapValidation.SapValidationType
	7,  // 10: workloadagentplatform.sharedprotos.datawarehouse.SapValidation.ValidationDetail.details:type_name -> workloadagentplatform.sharedprotos.datawarehouse.SapValidation.ValidationDetail.DetailsEntry
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_sharedprotos_datawarehouse_datawarehouse_proto_init() }
func file_sharedprotos_datawarehouse_datawarehouse_proto_init() {
	if File_sharedprotos_datawarehouse_datawarehouse_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*WriteInsightRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Insight); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SapValidation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TorsoValidation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SapValidation_ValidationDetail); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_sharedprotos_datawarehouse_datawarehouse_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_sharedprotos_datawarehouse_datawarehouse_proto_goTypes,
		DependencyIndexes: file_sharedprotos_datawarehouse_datawarehouse_proto_depIdxs,
		EnumInfos:         file_sharedprotos_datawarehouse_datawarehouse_proto_enumTypes,
		MessageInfos:      file_sharedprotos_datawarehouse_datawarehouse_proto_msgTypes,
	}.Build()
	File_sharedprotos_datawarehouse_datawarehouse_proto = out.File
	file_sharedprotos_datawarehouse_datawarehouse_proto_rawDesc = nil
	file_sharedprotos_datawarehouse_datawarehouse_proto_goTypes = nil
	file_sharedprotos_datawarehouse_datawarehouse_proto_depIdxs = nil
}
