/*
 * @test
 * @summary Test case for issue #4948: https://github.com/typetools/checker-framework/issues/4948
 *
 * @compile/timeout=30 -XDrawDiagnostics -Xlint:unchecked -processor org.checkerframework.checker.nullness.NullnessChecker -Alint Issue4948.java
 */
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;

@SuppressWarnings("nullness") // Check for timeout.
public class Issue4948 {

  static class MyClass<T> {

    // No type argumment inference.
    static MyClass<Object[]> of2(@Nullable Object[]... p) {
      throw new RuntimeException();
    }

    // Poly qualifiers
    static MyClass<@PolyNull Object[]> of3(@PolyNull Object[]... p) {
      throw new RuntimeException();
    }
  }

  static Stream<Object[]> parseTest() {
    return Stream.of(
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[1],
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE});
  }

  static Stream<Object[]> parseTest2() {
    return Stream.of(
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE},
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE});
  }

  static Stream<Object[]> parseTest4() {
    return Stream.of(
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE},
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE},
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE},
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE},
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE},
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE},
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE});
  }

  static MyClass<Object[]> parseTest11() {
    return MyClass.of2(
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE},
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE},
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE},
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE});
  }

  static MyClass<Object[]> parseTestB4() {
    return MyClass.of3(
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE},
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE},
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE},
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE},
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE});
  }

  static Stream<Object[]> parseTestB9() {
    return Stream.of(
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE});
  }

  static Stream<Object[]> parseTestB10() {
    return Stream.of(
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE});
  }

  static Stream<Object[]> parseTestB11() {
    return Stream.of(
        new Object[] {"12:15:24", 125},
        new Object[] {"3:27", 5456},
        new Object[] {"-1:15:4:00", 54665453},
        new Object[] {"124:7:56:00", 45},
        new Object[] {"10", null},
        new Object[] {"10:74:00:00", null},
        new Object[] {"10:00:60:00", null},
        new Object[] {"10:00:00:05", null},
        new Object[] {"12#15:24", null},
        new Object[] {"12:15#24", null},
        new Object[] {"12:15:24#10", null},
        new Object[] {"x12:15:24", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"12:15:24x", null},
        new Object[] {"#####", -2},
        new Object[] {"*****", -1},
        new Object[] {"<<<<<", Integer.MIN_VALUE},
        new Object[] {">>>>>", Integer.MAX_VALUE});
  }
}
