```toml
[advisory]
id = "RUSTSEC-2023-0074"
package = "zerocopy"
date = "2023-12-14"
url = "https://github.com/google/zerocopy/issues/716"
keywords = ["ref", "refcell", "mutable-aliasing"]
aliases = ["GHSA-3mv5-343c-w2qg", "GHSA-rjhf-4mh8-9xjq"]

[versions]
patched = [">= 0.2.9, < 0.3.0", ">= 0.3.2, < 0.4.0", ">= 0.4.1, < 0.5.0", ">= 0.5.2, < 0.6.0", ">= 0.6.6, < 0.7.0", ">= 0.7.31"]
unaffected = ["< 0.2.2"]

[affected.functions]
"zerocopy::Ref::into_ref" = [">= 0.2.2, < 0.2.9", ">= 0.3.0, < 0.3.2", ">= 0.4.0, < 0.4.1", ">= 0.5.0, < 0.5.2", ">= 0.6.0, < 0.6.6", ">= 0.7.0, < 0.7.31"]
"zerocopy::Ref::into_mut" = [">= 0.2.2, < 0.2.9", ">= 0.3.0, < 0.3.2", ">= 0.4.0, < 0.4.1", ">= 0.5.0, < 0.5.2", ">= 0.6.0, < 0.6.6", ">= 0.7.0, < 0.7.31"]
"zerocopy::Ref::into_slice" = [">= 0.2.2, < 0.2.9", ">= 0.3.0, < 0.3.2", ">= 0.4.0, < 0.4.1", ">= 0.5.0, < 0.5.2", ">= 0.6.0, < 0.6.6", ">= 0.7.0, < 0.7.31"]
"zerocopy::Ref::into_mut_slice" = [">= 0.2.2, < 0.2.9", ">= 0.3.0, < 0.3.2", ">= 0.4.0, < 0.4.1", ">= 0.5.0, < 0.5.2", ">= 0.6.0, < 0.6.6", ">= 0.7.0, < 0.7.31"]
```

# Some Ref methods are unsound with some type parameters

The `Ref` methods `into_ref`, `into_mut`, `into_slice`, and `into_slice_mut` are unsound
and may allow safe code to exhibit undefined behavior when used with `Ref<B, T>` where `B`
is [`cell::Ref`](https://doc.rust-lang.org/core/cell/struct.Ref.html) or
[`cell::RefMut`](https://doc.rust-lang.org/core/cell/struct.RefMut.html). Note that these
methods remain sound when used with `B` types other than `cell::Ref` or `cell::RefMut`.

See https://github.com/google/zerocopy/issues/716 for a more in-depth analysis.

The current plan is to yank the affected versions soon. See
https://github.com/google/zerocopy/issues/679 for more detail.
