```toml
[advisory]
id = "RUSTSEC-2018-0006"
package = "yaml-rust"
aliases = ["CVE-2018-20993", "GHSA-hv87-47h9-jcvq"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2018-09-17"
keywords = ["crash"]
url = "https://github.com/chyh1990/yaml-rust/pull/109"

[versions]
patched = [">= 0.4.1"]
```

# Uncontrolled recursion leads to abort in deserialization

Affected versions of this crate did not prevent deep recursion while
deserializing data structures.

This allows an attacker to make a YAML file with deeply nested structures
that causes an abort while deserializing it.

The flaw was corrected by checking the recursion depth.

Note: `clap 2.33` is not affected by this because it uses `yaml-rust`
in a way that doesn't trigger the vulnerability. More specifically:

1. The input to the YAML parser is always trusted - is included at compile
time via `include_str!`.

2. The nesting level is never deep enough to trigger the overflow in practice
(at most 5).
