```toml
[advisory]
id = "RUSTSEC-2023-0052"
package = "webpki"
date = "2023-08-22"
categories = ["denial-of-service"]
keywords = ["certificate", "path building", "x509"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
related = ["CVE-2018-16875"]
aliases = ["GHSA-8qv2-5vq6-g2g7"]

[versions]
patched = [">= 0.22.2"]
```

# webpki: CPU denial of service in certificate path building

When this crate is given a pathological certificate chain to validate, it will
spend CPU time exponential with the number of candidate certificates at each
step of path building.

Both TLS clients and TLS servers that accept client certificate are affected.

This was previously reported in
<https://github.com/briansmith/webpki/issues/69> and re-reported recently
by Luke Malinowski.

webpki 0.22.1 included a partial fix and webpki 0.22.2 added further fixes.
