```toml
[advisory]
id = "RUSTSEC-2021-0110"
package = "wasmtime"
date = "2021-09-17"
references = ["https://github.com/bytecodealliance/wasmtime/security/advisories/GHSA-v4cp-h94r-m7xf", "https://github.com/bytecodealliance/wasmtime/security/advisories/GHSA-4873-36h9-wv49", "https://github.com/bytecodealliance/wasmtime/security/advisories/GHSA-q879-9g95-56mx"]
categories = ["memory-corruption", "memory-exposure"]
keywords = ["use-after-free", "out-of-bounds read", "out-of-bounds write", "Wasm", "garbage collection"]
aliases = ["CVE-2021-39216", "CVE-2021-39218", "CVE-2021-39219", "GHSA-4873-36h9-wv49", "GHSA-q879-9g95-56mx", "GHSA-v4cp-h94r-m7xf"]
cvss = "CVSS:3.1/AV:L/AC:H/PR:L/UI:N/S:U/C:N/I:H/A:H"

[versions]
patched = [">= 0.30.0"]
unaffected = []

[affected.functions]
"wasmtime::Store::gc" = ["< 0.30.0"]
"wasmtime::Linker::func_wrap" = ["< 0.30.0"]
"wasmtime::Linker::func_new" = ["< 0.30.0"]
```

# Multiple Vulnerabilities in Wasmtime

* [Use after free passing `externref`s to Wasm in
  Wasmtime](https://github.com/bytecodealliance/wasmtime/security/advisories/GHSA-v4cp-h94r-m7xf)

* [Out-of-bounds read/write and invalid free with `externref`s and GC safepoints
  in
  Wasmtime](https://github.com/bytecodealliance/wasmtime/security/advisories/GHSA-4873-36h9-wv49)

* [Wrong type for `Linker`-define functions when used across two
  `Engine`s](https://github.com/bytecodealliance/wasmtime/security/advisories/GHSA-q879-9g95-56mx)
