```toml
[advisory]
id = "RUSTSEC-2020-0127"
package = "v9"
date = "2020-12-18"
url = "https://github.com/purpleposeidon/v9/issues/1"
references = ["https://github.com/purpleposeidon/v9/commit/18847c50e5d36561cc91c996c3539ddb1eacf6c7"]
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2020-36447", "GHSA-3837-87vh-xq3w", "GHSA-pfjq-935c-4895"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = [">= 0.1.43"]
```

# SyncRef's clone() and debug() allow data races

Affected versions of this crate unconditionally implement `Sync` for `SyncRef<T>`.
This definition allows data races if `&T` is accessible through `&SyncRef`.

`SyncRef<T>` derives `Clone` and `Debug`, and the default implementations of those traits access `&T` by invoking `T::clone()` & `T::fmt()`. It is possible to create data races & undefined behavior by concurrently invoking `SyncRef<T>::clone()` or `SyncRef<T>::fmt()` from multiple threads with `T: !Sync`.
