```toml
[advisory]
id = "RUSTSEC-2023-0059"
package = "users"
date = "2023-09-10"
url = "https://github.com/ogham/rust-users/issues/55"
informational = "unsound"
keywords = ["unaligned-read"]
aliases = ["GHSA-jcr6-4frq-9gjj"]

[versions]
patched = []
```

# Unaligned read of `*const *const c_char` pointer

Affected versions dereference a potentially unaligned pointer. The pointer is
commonly unaligned in practice, resulting in undefined behavior.

In some build modes, this is observable as a panic followed by abort. In other
build modes the UB may manifest in some other way, including the possibility of
working correctly in some architectures.

The crate is not currently maintained, so a patched version is not available.

## Recommended alternatives
- [`uzers`](https://crates.io/crates/uzers) (an actively maintained fork of the `users` crate)
- [`sysinfo`](https://crates.io/crates/sysinfo)
