```toml
[advisory]
id = "RUSTSEC-2020-0116"
package = "unicycle"
date = "2020-11-15"
url = "https://github.com/udoprog/unicycle/issues/8"
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2020-36436", "GHSA-686f-ch3r-xwmh"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = [">= 0.7.1"]
```

# PinSlab<T> and Unordered<T, S> need bounds on their Send/Sync traits

Affected versions of this crate unconditionally implemented `Send` & `Sync` for types `PinSlab<T>` & `Unordered<T, S>`. This allows sending non-Send types to other threads and concurrently accessing non-Sync types from multiple threads.

This can result in a data race & memory corruption when types that provide internal mutability without synchronization are contained within `PinSlab<T>` or `Unordered<T, S>` and accessed concurrently from multiple threads.

The flaw was corrected in commits 92f40b4 & 6a6c367 by adding trait bound `T: Send` to `Send` impls for `PinSlab<T>` & `Unordered<T, S>` and adding `T: Sync` to `Sync` impls for `PinSlab<T>` & `Unordered<T, S>`.
