```toml
[advisory]
id = "RUSTSEC-2020-0024"
package = "tough"
date = "2020-07-09"
aliases = ["CVE-2020-15093", "GHSA-5q2r-92f9-4m49"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:C/C:N/I:H/A:N"
related = ["CVE-2020-6174"]
url = "https://github.com/awslabs/tough/security/advisories/GHSA-5q2r-92f9-4m49"

[versions]
patched = [">= 0.7.1"]
```

# Improper uniqueness verification of signature threshold

The tough library, prior to 0.7.1, does not properly verify the uniqueness of
keys in the signatures provided to meet the threshold of cryptographic
signatures. It allows someone with access to a valid signing key to create
multiple valid signatures in order to circumvent TUF requiring a minimum
threshold of unique keys before the metadata is considered valid.

AWS would like to thank Erick Tryzelaar of the Google Fuchsia Team for
reporting this issue.

A fix is available in version 0.7.1.

CVE-2020-6174 is assigned to the same issue in the TUF reference
implementation.

If you have any questions or comments about this advisory, contact AWS Security
at aws-security@amazon.com.
