```toml
[advisory]
id = "RUSTSEC-2024-0340"
package = "tor-circmgr"
date = "2024-05-15"
url = "https://gitlab.torproject.org/tpo/core/arti/-/issues/1409"
keywords = ["tor", "privacy", "information-leak"]
aliases = ["CVE-2024-35313", "GHSA-c96h-cxx6-rmg9", "TROVE-2024-004"]
related = ["TROVE-2024-003"]

[versions]
patched = [">= 0.18.1"]
unaffected = ["< 0.18.0"]
```

# Tor path lengths too short when "full Vanguards" configured

## Description

When building anonymizing circuits to or from an onion service with 
full vanguards enabled, 
the circuit manager code would build the circuits with one hop too few.

## Impact

This makes users of this code more vulnerable to some kinds of traffic analysis
when they run or visit onion services.

## Vulnerable configurations and use cases

Arti configured with "full vangaurds" is vulnerable.

Only users who make connections to Onion Services
(Tor Hidden Services) are affected.
Note, however, that when used as a browser proxy,
malicious web pages can typically make such connections.

## Mitigation

Preventing access to Tor Hidden Services will avoid the problem,
with corresponding loss of functionality.
This can be achieved in the Arti configuration file with:

```
[address_filter]
allow_onion_addrs = false
```

Changing the configuration (eg to turn off vanguards)
reclassifies the behaviour as "as configured",
but reduces security rather than improving it,
so is not a mitigation.

## Resolution

Rebuild `arti` (or other affected applications)
with a fixed version of `tor-circmgr`:
0.18.1 or later.

The fixed `tor-circmgr` is on crates.io and available in
[the upstream git repository](https://gitlab.torproject.org/tpo/core/arti)
at signed tag `arti-v1.2.3`.

### Note about older versions

Even though earlier versions are classified as "not affected",
this is because in those versions the Vanguards feature
is experimental, or absent.
Downgrading worsens security, rather than improving it.

## References

 * [arti#1400](https://gitlab.torproject.org/tpo/core/arti/-/issues/1400):
   the ticket in the Arti bugtracker.
 * [TROVE](https://gitlab.torproject.org/tpo/core/team/-/wikis/NetworkTeam/TROVE)
   Tor Project vulnerability database.
 * [arti#1409](https://gitlab.torproject.org/tpo/core/arti/-/issues/1409):
   the similar bug with the vanguards lite feature.
