```toml
[advisory]
id = "RUSTSEC-2020-0119"
package = "ticketed_lock"
date = "2020-11-17"
url = "https://github.com/kvark/ticketed_lock/issues/7"
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2020-36439", "GHSA-77m6-x95j-75r5", "GHSA-gq4h-f254-7cw9"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = [">= 0.3.0"]
```

# ReadTicket and WriteTicket should only be sendable when T is Send

Affected versions of this crate unconditionally implemented `Send` for `ReadTicket<T>` & `WriteTicket<T>`.
This allows to send non-Send `T` to other threads.

This can allows creating data races by cloning types with internal mutability and sending them to other threads (as `T` of `ReadTicket<T>`/`WriteTicket<T>`). Such data races can cause memory corruption or other undefined behavior.

The flaw was corrected in commit a986a93 by adding `T: Send` bounds to `Send` impls of `ReadTicket<T>`/`WriteTicket<T>`.
