```toml
[advisory]
id = "RUSTSEC-2019-0012"
package = "smallvec"
aliases = ["CVE-2019-15554", "GHSA-69gw-hgj3-45m7"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
categories = ["code-execution", "memory-corruption"]
date = "2019-07-19"
url = "https://github.com/servo/rust-smallvec/issues/149"

[affected.functions]
"smallvec::SmallVec::grow" = ["< 0.6.10, >= 0.6.3"]

[versions]
patched = [">= 0.6.10"]
unaffected = ["< 0.6.3"]
```

# Memory corruption in SmallVec::grow()

Attempting to call `grow` on a spilled SmallVec with a value less than the current capacity causes corruption of memory allocator data structures.

An attacker that controls the value passed to `grow` may exploit this flaw to obtain memory contents or gain remote code execution.

Credits to @ehuss for discovering, reporting and fixing the bug.
