```toml
[advisory]
id = "RUSTSEC-2024-0345"
package = "sequoia-openpgp"
date = "2024-06-26"
url = "https://gitlab.com/sequoia-pgp/sequoia/-/issues/1106"
categories = ["denial-of-service"]
keywords = ["infinite-loop"]

[versions]
patched = [">= 1.21.0"]
unaffected = ["< 1.13.0"]

[affected]
functions = { "sequoia_openpgp::cert::raw::RawCertParser" = [">= 1.13.0, < 1.21.0"] }
```

# Low severity (DoS) vulnerability in sequoia-openpgp

There is a denial-of-service vulnerability in sequoia-openpgp, our
crate providing a low-level interface to our OpenPGP implementation.
When triggered, the process will enter an infinite loop.

Many thanks to Andrew Gallagher for disclosing the issue to us.

## Impact

Any software directly or indirectly using the interface
`sequoia_openpgp::cert::raw::RawCertParser`.  Notably, this includes all
software using the `sequoia_cert_store` crate.

## Details

The `RawCertParser` does not advance the input stream when
encountering unsupported cert (primary key) versions, resulting in an
infinite loop.

The fix introduces a new raw-cert-specific
`cert::raw::Error::UnuspportedCert`.

## Affected software

- sequoia-openpgp 1.13.0
- sequoia-openpgp 1.14.0
- sequoia-openpgp 1.15.0
- sequoia-openpgp 1.16.0
- sequoia-openpgp 1.17.0
- sequoia-openpgp 1.18.0
- sequoia-openpgp 1.19.0
- sequoia-openpgp 1.20.0
- Any software built against a vulnerable version of sequoia-openpgp
  which is directly or indirectly using the interface
  `sequoia_openpgp::cert::raw::RawCertParser`.  Notably, this includes
  all software using the `sequoia_cert_store` crate.
