```toml
[advisory]
id = "RUSTSEC-2023-0070"
package = "self_cell"
date = "2023-11-10"
url = "https://github.com/Voultapher/self_cell/issues/49"
categories = []
keywords = ["unsound", "self_cell", "self-referential"]
aliases = ["GHSA-48m6-wm5p-rr6h"]

[versions]
patched = [">= 0.10.3, < 1.0.0", ">= 1.0.2"]
```

# Insufficient covariance check makes self_cell unsound

All public versions prior to `1.02` used an insufficient check to ensure that
users correctly marked the dependent type as either `covariant` or
`not_covariant`. This allowed users to mark a dependent as covariant even though
its type was not covariant but invariant, for certain invariant types involving
trait object lifetimes. One example for such a dependent type is `type
Dependent<'a> = RefCell<Box<dyn fmt::Display + 'a>>`. Such a type allowed
unsound usage in purely safe user code that leads to undefined behavior. The
patched versions now produce a compile time error if such a type is marked as
`covariant`.
