```toml
[advisory]
id = "RUSTSEC-2020-0133"
package = "scottqueue"
date = "2020-11-15"
url = "https://github.com/rossdylan/rust-scottqueue/issues/1"
categories = ["memory-corruption", "thread-safety"]
aliases = ["CVE-2020-36453", "GHSA-gvvv-w559-2hg6"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = []
```

# Queue<T> should have a Send bound on its Send/Sync traits

Affected versions of this crate unconditionally implements `Send`/`Sync` for `Queue<T>`.

This allows (1) creating data races to a `T: !Sync` and (2) sending `T: !Send` to other threads, resulting in memory corruption or other undefined behavior.
